/*
 * Decompiled with CFR 0.152.
 */
package exc.xmpF;

import exc.block.BasicBlock;
import exc.block.BasicBlockExprIterator;
import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockIterator;
import exc.block.BlockList;
import exc.block.FdoBlock;
import exc.block.ForBlock;
import exc.block.FuncDefBlock;
import exc.block.FunctionBlock;
import exc.block.PragmaBlock;
import exc.block.Statement;
import exc.block.bottomupBlockIterator;
import exc.block.topdownBlockIterator;
import exc.object.BasicType;
import exc.object.Ident;
import exc.object.PropObject;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectIterator;
import exc.object.Xtype;
import exc.object.bottomupXobjectIterator;
import exc.xmpF.XMP;
import exc.xmpF.XMParray;
import exc.xmpF.XMPcoarray;
import exc.xmpF.XMPdimInfo;
import exc.xmpF.XMPenv;
import exc.xmpF.XMPinfo;
import exc.xmpF.XMPmodule;
import exc.xmpF.XMPnodes;
import exc.xmpF.XMPobject;
import exc.xmpF.XMPobjectsRef;
import exc.xmpF.XMPpragma;
import exc.xmpF.XMPsymbolTable;
import exc.xmpF.XMPtemplate;
import exc.xmpF.XMPtransCoarrayRun;
import java.util.Vector;
import xcodeml.util.XmOption;

public class XMPtransPragma {
    private XMPenv env;
    static boolean loop_opt_enable = true;
    private static final int GMOVE_ALL = 0;
    private static final int GMOVE_INDEX = 1;
    private static final int GMOVE_RANGE = 2;
    private static final int GMOVE_COLL = 400;
    private static final int GMOVE_IN = 401;
    private static final int GMOVE_OUT = 402;

    public void run(FuncDefBlock funcDefBlock, XMPenv xMPenv) {
        this.env = xMPenv;
        xMPenv.setCurrentDef(funcDefBlock);
        FunctionBlock functionBlock = funcDefBlock.getBlock();
        XMP.debug("pass3:");
        if (XMP.debugFlag) {
            System.out.println("pass3 +fblock=" + functionBlock);
        }
        bottomupBlockIterator bottomupBlockIterator2 = new bottomupBlockIterator(functionBlock.getBody().getHead());
        ((BlockIterator)bottomupBlockIterator2).init();
        while (!((BlockIterator)bottomupBlockIterator2).end()) {
            Block block = bottomupBlockIterator2.getBlock();
            if (block.Opcode() == Xcode.XMP_PRAGMA && (block = this.transPragma((PragmaBlock)block)) != null) {
                bottomupBlockIterator2.setBlock(block);
            }
            ((BlockIterator)bottomupBlockIterator2).next();
        }
        this.run_block(funcDefBlock, xMPenv, null);
    }

    public Vector<Block> run_block(FuncDefBlock funcDefBlock, XMPenv xMPenv, Block block) {
        Object object;
        Object object2;
        FunctionBlock functionBlock = funcDefBlock.getBlock();
        BlockList blockList = Bcons.emptyBody();
        BlockList blockList2 = Bcons.emptyBody();
        this.buildXMPobjectBlock(blockList, blockList2, block);
        if (block == null) {
            block = functionBlock.getBody().getHead();
            if (funcDefBlock.getDef().getName().equals("xmpf_main")) {
                object2 = xMPenv.declIdent("xmp_barrier", Xtype.FsubroutineType);
                blockList2.add(((Ident)object2).callSubroutine(Xcons.List()));
            }
        }
        object2 = new topdownBlockIterator(block);
        ((BlockIterator)object2).init();
        while (!((BlockIterator)object2).end()) {
            object = ((BlockIterator)object2).getBlock();
            if (((Block)object).Opcode() == Xcode.OMP_PRAGMA && ((PragmaBlock)object).getPragma().equals("THREADPRIVATE")) {
                ((Block)object).remove();
                blockList.insert((Block)object);
            } else if (((Block)object).Opcode() == Xcode.F_BLOCK_STATEMENT) {
                if (block == object) {
                    ((BlockIterator)object2).setAside((Block)object);
                } else {
                    ((BlockIterator)object2).setAside(this.run_block(funcDefBlock, xMPenv, (Block)object));
                }
            }
            ((BlockIterator)object2).next();
        }
        if (xMPenv.currentDefIsModule()) {
            Xobject xobject;
            object = Xtype.FlogicalType.copy();
            ((Xtype)object).setIsFsave(true);
            BlockList blockList3 = xMPenv.getCurrentDef().getBlock().getBody();
            Ident ident = blockList3.declLocalIdent("xmpf_init_flag_" + xMPenv.currentDefName(), (Xtype)object, StorageClass.FSAVE, Xcons.List(Xcode.F_VALUE, Xcons.FlogicalConstant(false)));
            Vector<XMPmodule> vector = xMPenv.getModules();
            for (int i = vector.size() - 1; i >= 0; --i) {
                xobject = xMPenv.declIdent("xmpf_traverse_module_" + vector.get(i).getModuleName(), Xtype.FsubroutineType);
                blockList.insert(xobject.callSubroutine(Xcons.List()));
            }
            blockList.insert(Bcons.IF(ident.Ref(), Xcons.List(Xcode.RETURN_STATEMENT), null));
            blockList.add(Xcons.Set(ident.Ref(), Xcons.FlogicalConstant(true)));
            Ident ident2 = xMPenv.declIdent("xmpf_traverse_module_" + xMPenv.currentDefName(), Xtype.FsubroutineType);
            xobject = Xcons.Symbol(Xcode.IDENT, xMPenv.getCurrentDef().getDef().getName());
            XobjList xobjList = Xcons.List(Xcons.List(Xcode.F_USE_DECL, xobject, Xcons.IntConstant(0)));
            XobjectDef xobjectDef = XobjectDef.Func(ident2, null, xobjList, blockList.toXobject());
            xMPenv.getEnv().add(xobjectDef);
        } else {
            object = block.getBody();
            ((BlockList)object).insert(Bcons.COMPOUND(blockList));
            ((BlockList)object).add(Bcons.COMPOUND(blockList2));
        }
        return ((BlockIterator)object2).getContainer();
    }

    void buildXMPobjectBlock(BlockList blockList, BlockList blockList2, Block block) {
        XMPsymbolTable xMPsymbolTable;
        XMPsymbolTable xMPsymbolTable2 = xMPsymbolTable = block != null ? block.getXMPsymbolTable() : this.env.getXMPsymbolTable();
        if (block == null) {
            blockList2.add(Xcons.StatementLabel("99999"));
            blockList2.add(Xcons.List(Xcode.F_CONTINUE_STATEMENT));
        }
        if (xMPsymbolTable != null) {
            Object object;
            for (XMPobject iterator : xMPsymbolTable.getXMPobjects()) {
                iterator.buildConstructor(blockList, this.env, block);
                iterator.buildDestructor(blockList2, this.env, block);
            }
            for (XMParray xMParray : xMPsymbolTable.getXMParrays()) {
                xMParray.buildConstructor(blockList, this.env, block);
                xMParray.buildDestructor(blockList2, this.env, block);
            }
            if (block == null) {
                XobjectDef xobjectDef = this.env.getCurrentDef().getDef();
                object = xobjectDef.getDef().getArg(1);
            } else {
                object = block.getBody().getLocalCoarrays();
            }
            if (object != null) {
                for (Xobject xobject : (XobjList)object) {
                    Ident ident = (Ident)xobject;
                    if (!ident.isCoarray() || (block != null || ident.getAlias() != null) && (block == null || ident.getAlias() == null)) continue;
                    XMPcoarray xMPcoarray = new XMPcoarray(ident, this.env);
                    xMPcoarray.build_setMappingNodes(blockList, block);
                }
            }
        }
    }

    Block transPragma(PragmaBlock pragmaBlock) {
        XMPinfo xMPinfo = (XMPinfo)pragmaBlock.getProp("XMPprop");
        if (xMPinfo == null) {
            return null;
        }
        switch (xMPinfo.pragma) {
            case NODES: 
            case TEMPLATE: 
            case DISTRIBUTE: 
            case ALIGN: 
            case SHADOW: 
            case LOCAL_ALIAS: 
            case COARRAY: 
            case SAVE_DESC: {
                return Bcons.emptyBlock();
            }
            case LOOP: {
                return this.translateLoop(pragmaBlock, xMPinfo);
            }
            case REFLECT: 
            case REDUCE_SHADOW: {
                return this.translateReflect(pragmaBlock, xMPinfo);
            }
            case BARRIER: {
                return this.translateBarrier(pragmaBlock, xMPinfo);
            }
            case REDUCTION: {
                return this.translateReduction(pragmaBlock, xMPinfo);
            }
            case BCAST: {
                return this.translateBcast(pragmaBlock, xMPinfo);
            }
            case WAIT_ASYNC: {
                return this.translateWaitAsync(pragmaBlock, xMPinfo);
            }
            case TASK: {
                return this.translateTask(pragmaBlock, xMPinfo);
            }
            case TASKS: {
                return this.translateTasks(pragmaBlock, xMPinfo);
            }
            case GMOVE: {
                return this.translateGmove(pragmaBlock, xMPinfo);
            }
            case TEMPLATE_FIX: {
                return this.translateTemplateFix(pragmaBlock, xMPinfo);
            }
            case IMAGE: {
                return XMPtransCoarrayRun.translateImageDirective(pragmaBlock, xMPinfo);
            }
        }
        return null;
    }

    private Block translateLoop(PragmaBlock pragmaBlock, XMPinfo xMPinfo) {
        Statement statement;
        BlockList blockList = Bcons.emptyBody();
        int n = xMPinfo.getLoopType();
        Vector<XMPdimInfo> vector = xMPinfo.getWidthList();
        XMPobjectsRef xMPobjectsRef = xMPinfo.getOnRef();
        blockList.add(xMPobjectsRef.buildLoopConstructor(this.env));
        if (!loop_opt_enable) {
            ForBlock forBlock = (ForBlock)((Object)pragmaBlock.getBody().getHead());
            BlockList blockList2 = xMPinfo.getBody();
            FdoBlock fdoBlock = (FdoBlock)blockList2.getParent();
            Xobject xobject = xMPobjectsRef.buildLoopTestFuncCall(this.env, xMPinfo);
            Block block = Bcons.IF(BasicBlock.Cond(xobject), blockList2, null);
            fdoBlock.setBody(new BlockList(block));
            blockList.add((Block)((Object)forBlock));
            return Bcons.COMPOUND(blockList);
        }
        Block block = Bcons.emptyBlock();
        BasicBlock basicBlock = block.getBasicBlock();
        block6: for (int i = 0; i < xMPinfo.getLoopDim(); ++i) {
            Ident ident;
            Ident ident2;
            Xobject xobject;
            Xobject xobject2;
            Xobject xobject3;
            PropObject propObject;
            Object object;
            XMPtemplate xMPtemplate = xMPobjectsRef.getTemplate();
            int n2 = xMPobjectsRef.getLoopOnIndex(i);
            XMPdimInfo xMPdimInfo = xMPinfo.getLoopDimInfo(i);
            Ident ident3 = xMPdimInfo.getLoopLocalVar();
            ForBlock forBlock = xMPdimInfo.getLoopBlock();
            BasicType basicType = Xtype.intType;
            if (ident3 == null) {
                object = xMPobjectsRef.buildLoopTestSkipFuncCall(this.env, xMPinfo, i);
                propObject = Bcons.IF(BasicBlock.Cond((Xobject)object), Bcons.blockList(Bcons.Fcycle()), null);
                forBlock.getBody().insert((Block)propObject);
                continue;
            }
            object = ident3.Type();
            propObject = this.env.declIdent(XMP.genSym("loop_lb"), (Xtype)object, pragmaBlock);
            Ident ident4 = this.env.declIdent(XMP.genSym("loop_ub"), (Xtype)object, pragmaBlock);
            Ident ident5 = this.env.declIdent(XMP.genSym("loop_step"), basicType, pragmaBlock);
            Xobject xobject4 = forBlock.getInductionVar();
            ((FdoBlock)forBlock).setInductionVar(ident3.Ref());
            basicBlock.add(Xcons.Set(((Ident)propObject).Ref(), forBlock.getLowerBound()));
            basicBlock.add(Xcons.Set(ident4.Ref(), forBlock.getUpperBound()));
            basicBlock.add(Xcons.Set(ident5.Ref(), forBlock.getStep()));
            if (vector.isEmpty()) {
                xobject3 = Xcons.IntConstant(0);
                xobject2 = Xcons.IntConstant(0);
                xobject = Xcons.IntConstant(0);
            } else {
                XMPdimInfo xMPdimInfo2 = vector.get(n2);
                xobject3 = xMPdimInfo2.getLower();
                xobject2 = xMPdimInfo2.getUpper();
                xobject = xMPdimInfo2.getStride();
            }
            int n3 = n == 411 && ((Xobject)xobject).getInt() == -1 ? 410 : n;
            Ident ident6 = this.env.declInternIdent("xmpf_loop_sched_", Xtype.FsubroutineType);
            XobjList xobjList = Xcons.List(((Ident)propObject).Ref(), ident4.Ref(), ident5.Ref(), Xcons.IntConstant(i), xMPobjectsRef.getDescId().Ref(), Xcons.IntConstant(n3), xobject3, xobject2, xobject);
            basicBlock.add(ident6.callSubroutine(xobjList));
            forBlock.setLowerBound(((Ident)propObject).Ref());
            forBlock.setUpperBound(ident4.Ref());
            if (forBlock.getStep().isOneConstant() && (xMPtemplate.getDistMannerAt(n2) != 102 || xMPtemplate.getDistArgAt(n2) == null || xMPtemplate.getDistArgAt(n2).isOneConstant())) {
                forBlock.setStep(Xcons.IntConstant(1));
            } else {
                forBlock.setStep(ident5.Ref());
            }
            if (!this.isVarUsed(forBlock.getBody(), xobject4)) continue;
            if (XmOption.isXcalableACC()) {
                switch (xMPtemplate.getDistMannerAt(n2)) {
                    case 101: 
                    case 104: {
                        ident2 = this.env.declIdent(XMP.genSym("loop_l2goff"), Xtype.FintType, pragmaBlock);
                        ident = this.env.declInternIdent("xmpf_l2g_", Xtype.FsubroutineType);
                        xobjList = Xcons.List(ident2.Ref(), Xcons.IntConstant(0), Xcons.IntConstant(i), xMPobjectsRef.getDescId().Ref());
                        basicBlock.add(ident.callSubroutine(xobjList));
                        forBlock.getBody().insert(Xcons.Set(xobject4, Xcons.binaryOp(Xcode.PLUS_EXPR, ident2.Ref(), ident3.Ref())));
                        break;
                    }
                    default: {
                        forBlock.getBody().insert(Xcons.Set(xobject4, this.calcLtoG(xMPtemplate, n2, ident3.Ref())));
                        break;
                    }
                }
                continue;
            }
            ident2 = this.env.declInternIdent("xmpf_l2g_", Xtype.FsubroutineType);
            switch (xMPtemplate.getDistMannerAt(n2)) {
                case 101: 
                case 104: {
                    ident = this.env.declIdent(XMP.genSym("loop_l2goff"), Xtype.FintType, pragmaBlock);
                    xobjList = Xcons.List(ident.Ref(), Xcons.IntConstant(0), Xcons.IntConstant(i), xMPobjectsRef.getDescId().Ref());
                    basicBlock.add(ident2.callSubroutine(xobjList));
                    forBlock.getBody().insert(Xcons.Set(xobject4, Xcons.binaryOp(Xcode.PLUS_EXPR, ident.Ref(), ident3.Ref())));
                    continue block6;
                }
                default: {
                    xobjList = Xcons.List(xobject4, ident3.Ref(), Xcons.IntConstant(i), xMPobjectsRef.getDescId().Ref());
                    forBlock.getBody().insert(ident2.callSubroutine(xobjList));
                }
            }
        }
        blockList.add(block);
        if (pragmaBlock.getPrev() != null && pragmaBlock.getPrev().Opcode() == Xcode.F_STATEMENT_LIST && pragmaBlock.getPrev().getBasicBlock() != null && (statement = pragmaBlock.getPrev().getBasicBlock().getTail()) != null && statement.getExpr().Opcode() == Xcode.PRAGMA_LINE) {
            blockList.add(statement.getExpr());
            statement.remove();
        }
        blockList.add(pragmaBlock.getBody().getHead());
        Ident ident = this.env.declInternIdent("xmpf_ref_dealloc_", Xtype.FsubroutineType);
        blockList.add(ident.callSubroutine(Xcons.List(xMPobjectsRef.getDescId())));
        if (xMPinfo.getReductionOp() != 0) {
            blockList.add(this.translateReduction(pragmaBlock, xMPinfo));
        }
        return Bcons.COMPOUND(blockList);
    }

    private Xobject calcLtoG(XMPtemplate xMPtemplate, int n, Xobject xobject) {
        if (!xMPtemplate.isDistributed() || xMPtemplate.getDistMannerAt(n) == 100) {
            return xobject;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (xMPtemplate.getDistMannerAt(i) == 100) continue;
            ++n2;
        }
        XMPnodes xMPnodes = xMPtemplate.getOntoNodes();
        Xobject xobject2 = xMPnodes.getInfoAt(n2).getNodeRankVar().Ref();
        Xobject xobject3 = xMPnodes.getInfoAt(n2).getSize();
        if (xobject3 == null) {
            xobject3 = xMPnodes.getInfoAt(n2).getNodeSizeVar().Ref();
        }
        Xobject xobject4 = xMPtemplate.getSizeAt(n);
        Xobject xobject5 = xMPtemplate.getLowerAt(n);
        Xobject xobject6 = null;
        switch (xMPtemplate.getDistMannerAt(n)) {
            case 101: {
                Xobject xobject7 = Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.binaryOp(Xcode.DIV_EXPR, Xcons.binaryOp(Xcode.MINUS_EXPR, xobject4, Xcons.IntConstant(1)), xobject3), Xcons.IntConstant(1));
                xobject6 = Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.binaryOp(Xcode.MUL_EXPR, xobject7, xobject2), xobject5), xobject);
                break;
            }
            case 102: {
                Xobject xobject8 = xMPtemplate.getDistArgAt(n);
                if (xobject8 == null) {
                    xobject6 = Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.binaryOp(Xcode.MUL_EXPR, xobject, xobject3), xobject2), xobject5);
                    break;
                }
                Xobject xobject9 = xobject8;
                Ident ident = this.env.declIntrinsicIdent("mod", Xtype.FintFunctionType);
                xobject6 = Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.binaryOp(Xcode.MUL_EXPR, Xcons.binaryOp(Xcode.MUL_EXPR, Xcons.binaryOp(Xcode.DIV_EXPR, xobject, xobject9), xobject9), xobject3), Xcons.binaryOp(Xcode.MUL_EXPR, xobject9, xobject2)), ident.Call(Xcons.List(xobject, xobject9))), xobject5);
                break;
            }
            case 104: {
                XMP.fatal("gblock is not implemented");
            }
            default: {
                XMP.fatal("unknown distribute manner");
            }
        }
        return xobject6;
    }

    boolean isVarUsed(BlockList blockList, Xobject xobject) {
        BasicBlockExprIterator basicBlockExprIterator = new BasicBlockExprIterator(blockList);
        basicBlockExprIterator.init();
        while (!basicBlockExprIterator.end()) {
            Xobject xobject2 = basicBlockExprIterator.getExpr();
            if (xobject2 != null) {
                bottomupXobjectIterator bottomupXobjectIterator2 = new bottomupXobjectIterator(xobject2);
                ((XobjectIterator)bottomupXobjectIterator2).init();
                while (!((XobjectIterator)bottomupXobjectIterator2).end()) {
                    Xobject xobject3 = bottomupXobjectIterator2.getXobject();
                    if (xobject3 != null) {
                        switch (xobject3.Opcode()) {
                            case VAR: 
                            case VAR_ADDR: {
                                if (!xobject3.getName().equals(xobject.getName())) break;
                                return true;
                            }
                        }
                    }
                    ((XobjectIterator)bottomupXobjectIterator2).next();
                }
            }
            basicBlockExprIterator.next();
        }
        return false;
    }

    private Block translateReflect(PragmaBlock pragmaBlock, XMPinfo xMPinfo) {
        Object object;
        Ident ident;
        Iterable<XMParray> iterable;
        Block block = Bcons.emptyBlock();
        BasicBlock basicBlock = block.getBasicBlock();
        boolean bl = xMPinfo.isAcc();
        Ident ident2 = xMPinfo.pragma == XMPpragma.REFLECT ? this.env.declInternIdent(bl ? "xaccf_reflect_" : "xmpf_reflect_", Xtype.FsubroutineType) : this.env.declInternIdent(bl ? "xaccf_reduce_shadow_" : "xmpf_reduce_shadow_", Xtype.FsubroutineType);
        if (xMPinfo.getAsyncId() != null) {
            iterable = Xcons.List(xMPinfo.getAsyncId());
            ident = this.env.declInternIdent("xmpf_init_async_", Xtype.FsubroutineType);
            basicBlock.add(ident.callSubroutine((Xobject)((Object)iterable)));
        }
        iterable = xMPinfo.getReflectArrays();
        for (XMParray object2 : iterable) {
            for (int xobjList = 0; xobjList < xMPinfo.widthList.size(); ++xobjList) {
                ident = xMPinfo.pragma == XMPpragma.REFLECT ? this.env.declInternIdent(bl ? "xaccf_set_reflect_" : "xmpf_set_reflect_", Xtype.FsubroutineType) : this.env.declInternIdent(bl ? "xaccf_set_reduce_shadow_" : "xmpf_set_reduce_shadow_", Xtype.FsubroutineType);
                XMPdimInfo xMPdimInfo = xMPinfo.widthList.get(xobjList);
                if (xMPdimInfo.getStride().getInt() == 1 && object2.isFullShadow(xobjList)) {
                    XMP.error("Periodic reflect cannot be specified for a dimension with full shadow.");
                }
                XobjList xobjList2 = Xcons.List(object2.getDescId().Ref(), Xcons.IntConstant(xobjList), xMPdimInfo.getLower(), xMPdimInfo.getUpper(), xMPdimInfo.getStride());
                basicBlock.add(ident.callSubroutine(xobjList2));
            }
            if (xMPinfo.getAsyncId() != null) {
                Ident ident3 = xMPinfo.pragma == XMPpragma.REFLECT ? this.env.declInternIdent(bl ? "xaccf_reflect_async_" : "xmpf_reflect_async_", Xtype.FsubroutineType) : ident2;
                basicBlock.add(ident3.callSubroutine(Xcons.List(object2.getDescId().Ref(), xMPinfo.getAsyncId())));
                continue;
            }
            XobjList xMParray = Xcons.List();
            if (bl) {
                ((Xobject)xMParray).add(object2.getLocalId().Ref());
            }
            ((Xobject)xMParray).add(object2.getDescId().Ref());
            basicBlock.add(ident2.callSubroutine(xMParray));
        }
        if (xMPinfo.getAsyncId() != null) {
            object = Xcons.List();
            ident = this.env.declInternIdent("xmpf_start_async_", Xtype.FsubroutineType);
            basicBlock.add(ident.callSubroutine((Xobject)object));
        }
        if (bl) {
            object = Xcons.List();
            for (XMParray xMParray : iterable) {
                ((XobjList)object).add(xMParray.getLocalId().Ref());
            }
            block = this.buildAccHostData((Xobject)object, Bcons.blockList(block));
        }
        return block;
    }

    private Block translateBarrier(PragmaBlock pragmaBlock, XMPinfo xMPinfo) {
        Xobject xobject;
        BlockList blockList = Bcons.emptyBody();
        XMPobjectsRef xMPobjectsRef = xMPinfo.getOnRef();
        Ident ident = this.env.findVarIdent("XMP_NULL", pragmaBlock);
        if (ident == null) {
            ident = this.env.declObjectId("XMP_NULL", null, Xcons.Cast(Xtype.voidPtrType, Xcons.IntConstant(0)));
        }
        if (xMPobjectsRef != null) {
            blockList.add(xMPobjectsRef.buildConstructor(this.env));
            xobject = xMPobjectsRef.getDescId().Ref();
        } else {
            xobject = ident;
        }
        Ident ident2 = this.env.declInternIdent("xmpf_barrier_", Xtype.FsubroutineType);
        blockList.add(ident2.callSubroutine(Xcons.List(xobject)));
        if (xMPobjectsRef != null) {
            Ident ident3 = this.env.declInternIdent("xmpf_ref_dealloc_", Xtype.FsubroutineType);
            blockList.add(ident3.callSubroutine(Xcons.List(xMPobjectsRef.getDescId())));
        }
        return Bcons.COMPOUND(blockList);
    }

    private Block translateReduction(PragmaBlock pragmaBlock, XMPinfo xMPinfo) {
        Object object;
        Xobject xobject;
        Object object2;
        BlockList blockList = Bcons.emptyBody();
        XMPobjectsRef xMPobjectsRef = xMPinfo.getOnRef();
        Ident ident = this.env.findVarIdent("XMP_NULL", pragmaBlock);
        if (ident == null) {
            ident = this.env.declObjectId("XMP_NULL", null, Xcons.Cast(Xtype.voidPtrType, Xcons.IntConstant(0)));
        }
        if (xMPinfo.getAsyncId() != null) {
            object2 = Xcons.List(xMPinfo.getAsyncId());
            Ident ident2 = this.env.declInternIdent("xmpf_init_async_", Xtype.FsubroutineType);
            blockList.add(ident2.callSubroutine((Xobject)object2));
        }
        if (xMPobjectsRef != null) {
            if (xMPinfo.pragma != XMPpragma.LOOP) {
                blockList.add(xMPobjectsRef.buildConstructor(this.env));
                xobject = xMPobjectsRef.getDescId().Ref();
            } else {
                object2 = xMPobjectsRef.convertLoopToReduction();
                blockList.add(((XMPobjectsRef)object2).buildConstructor(this.env));
                xobject = ((XMPobjectsRef)object2).getDescId().Ref();
            }
        } else {
            xobject = ident;
        }
        int n = xMPinfo.getReductionOp();
        boolean bl = xMPinfo.isAcc();
        Ident ident3 = this.env.declInternIdent(bl ? "xaccf_reduction_" : "xmpf_reduction_", Xtype.FsubroutineType);
        Ident ident4 = this.env.declInternIdent(bl ? "xaccf_reduction_loc_" : "xmpf_reduction_loc_", Xtype.FsubroutineType);
        for (int i = 0; i < xMPinfo.getReductionVars().size(); ++i) {
            Xobject xobject2;
            Object object3;
            object = xMPinfo.getReductionVars().elementAt(i);
            Vector<Ident> object4 = xMPinfo.getReductionPosVars().elementAt(i);
            Xtype xtype = ((Xobject)object).Type();
            Xobject xobject3 = Xcons.IntConstant(1);
            if (xtype.isFallocatable()) {
                object3 = this.env.declIntrinsicIdent("size", Xtype.FintFunctionType);
                xobject3 = ((Ident)object3).Call(Xcons.List(((Ident)object).Ref()));
                xtype = xtype.getRef();
            } else if (xtype.isFarray()) {
                for (Xobject xobject4 : xtype.getFarraySizeExpr()) {
                    xobject2 = Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.IntConstant(1), Xcons.binaryOp(Xcode.MINUS_EXPR, xobject4.getArg(1), xobject4.getArg(0)));
                    xobject3 = Xcons.binaryOp(Xcode.MUL_EXPR, xobject3, xobject2);
                }
                xtype = xtype.getRef();
            }
            if (xtype.isFunction()) {
                xtype = xtype.getRef();
            }
            if (!xtype.isBasic()) {
                XMP.fatal("reduction for non-basic type =" + xtype);
            }
            if (xtype.getFlen() != null) {
                xobject3 = Xcons.binaryOp(Xcode.MUL_EXPR, xobject3, xtype.getFlen());
            }
            object3 = Xcons.List(((Ident)object).Ref(), xobject3, XMP.typeIntConstant(xtype), Xcons.IntConstant(n), xobject);
            ((Xobject)object3).add(Xcons.IntConstant(object4.size()));
            int n2 = 0;
            for (Xobject xobject4 : object4) {
                xobject2 = Xcons.List(Xcons.IntConstant(n2), ((Ident)xobject4).Ref(), XMP.typeIntConstant(xobject4.Type()));
                blockList.add(ident4.callSubroutine(xobject2));
                ++n2;
            }
            blockList.add(ident3.callSubroutine((Xobject)object3));
        }
        if (xMPinfo.getAsyncId() != null) {
            XobjList xobjList = Xcons.List();
            object = this.env.declInternIdent("xmpf_start_async_", Xtype.FsubroutineType);
            blockList.add(((Ident)object).callSubroutine(xobjList));
        }
        if (xMPobjectsRef != null) {
            Ident ident5 = this.env.declInternIdent("xmpf_ref_dealloc_", Xtype.FsubroutineType);
            blockList.add(ident5.callSubroutine(Xcons.List(xMPobjectsRef.getDescId())));
        }
        if (bl) {
            XobjList xobjList = Xcons.List();
            for (Ident ident2 : xMPinfo.getReductionVars()) {
                xobjList.add(ident2.Ref());
            }
            blockList = Bcons.blockList(this.buildAccHostData(xobjList, blockList));
        }
        return Bcons.COMPOUND(blockList);
    }

    /*
     * WARNING - void declaration
     */
    private Block translateBcast(PragmaBlock pragmaBlock, XMPinfo xMPinfo) {
        Object object;
        Xobject xobject;
        Xobject xobject2;
        Object object2;
        BlockList blockList = Bcons.emptyBody();
        boolean bl = xMPinfo.isAcc();
        Ident ident = this.env.findVarIdent("XMP_NULL", pragmaBlock);
        if (ident == null) {
            ident = this.env.declObjectId("XMP_NULL", null, Xcons.Cast(Xtype.voidPtrType, Xcons.IntConstant(0)));
        }
        if (xMPinfo.getAsyncId() != null) {
            object2 = Xcons.List(xMPinfo.getAsyncId());
            xobject2 = this.env.declInternIdent("xmpf_init_async_", Xtype.FsubroutineType);
            blockList.add(((Ident)xobject2).callSubroutine((Xobject)object2));
        }
        if ((object2 = xMPinfo.getBcastFrom()) != null) {
            blockList.add(((XMPobjectsRef)object2).buildConstructor(this.env));
            xobject2 = ((XMPobjectsRef)object2).getDescId().Ref();
        } else {
            xobject2 = ident;
        }
        XMPobjectsRef xMPobjectsRef = xMPinfo.getOnRef();
        if (xMPobjectsRef != null) {
            blockList.add(xMPobjectsRef.buildConstructor(this.env));
            xobject = xMPobjectsRef.getDescId().Ref();
        } else {
            xobject = ident;
        }
        Ident ident2 = this.env.declInternIdent(bl ? "xaccf_bcast_" : "xmpf_bcast_", Xtype.FsubroutineType);
        for (Ident object3 : xMPinfo.getInfoVarIdents()) {
            void var13_16;
            Object object4;
            Xtype xtype = object3.Type();
            Xobject xobject3 = Xcons.IntConstant(1);
            if (xtype.isFarray()) {
                if (xtype.isFassumedSize()) {
                    XMP.fatal("assumed-size array cannot be the target of bcast.");
                }
                if (!xtype.isFassumedShape() && !xtype.isFallocatable()) {
                    for (Xobject xobject4 : xtype.getFarraySizeExpr()) {
                        Xobject xobject5;
                        if (xobject4.Opcode() == Xcode.F_INDEX_RANGE) {
                            Xobject xobject6 = xobject4.getArg(0);
                            Xobject xobject7 = xobject4.getArg(1);
                            xobject5 = Xcons.binaryOp(Xcode.MINUS_EXPR, xobject7, xobject6);
                            xobject5 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject5, Xcons.IntConstant(1));
                        } else {
                            xobject5 = xobject4;
                        }
                        xobject3 = Xcons.binaryOp(Xcode.MUL_EXPR, xobject3, xobject5);
                    }
                } else {
                    object4 = this.env.declIntrinsicIdent("size", Xtype.FintFunctionType);
                    xobject3 = ((Ident)object4).Call(Xcons.List(object3.Ref()));
                }
                Xtype xtype2 = xtype.getRef();
            }
            if (!var13_16.isBasic()) {
                XMP.fatal("bcast for non-basic type =" + var13_16);
            }
            if (var13_16.getFlen() != null) {
                xobject3 = Xcons.binaryOp(Xcode.MUL_EXPR, xobject3, var13_16.getFlen());
            }
            object4 = Xcons.List(object3.Ref(), xobject3, XMP.typeIntConstant((Xtype)var13_16), xobject2, xobject);
            blockList.add(ident2.callSubroutine((Xobject)object4));
        }
        if (xMPinfo.getAsyncId() != null) {
            object = Xcons.List();
            Ident ident3 = this.env.declInternIdent("xmpf_start_async_", Xtype.FsubroutineType);
            blockList.add(ident3.callSubroutine((Xobject)object));
        }
        if (xMPobjectsRef != null) {
            object = this.env.declInternIdent("xmpf_ref_dealloc_", Xtype.FsubroutineType);
            blockList.add(((Ident)object).callSubroutine(Xcons.List(xMPobjectsRef.getDescId())));
        }
        if (object2 != null) {
            object = this.env.declInternIdent("xmpf_ref_dealloc_", Xtype.FsubroutineType);
            blockList.add(((Ident)object).callSubroutine(Xcons.List(((XMPobjectsRef)object2).getDescId())));
        }
        if (bl) {
            object = Xcons.List();
            for (Ident ident4 : xMPinfo.getInfoVarIdents()) {
                ((XobjList)object).add(ident4.Ref());
            }
            blockList = Bcons.blockList(this.buildAccHostData((Xobject)object, blockList));
        }
        return Bcons.COMPOUND(blockList);
    }

    private Block translateWaitAsync(PragmaBlock pragmaBlock, XMPinfo xMPinfo) {
        Xobject xobject;
        BlockList blockList = Bcons.emptyBody();
        XMPobjectsRef xMPobjectsRef = xMPinfo.getOnRef();
        if (xMPobjectsRef != null) {
            blockList.add(xMPobjectsRef.buildConstructor(this.env));
            xobject = xMPobjectsRef.getDescId().Ref();
        } else {
            xobject = this.env.getNullIdent(pragmaBlock).Ref();
        }
        Ident ident = this.env.declInternIdent("xmpf_wait_async_", Xtype.FsubroutineType);
        for (Xobject xobject2 : xMPinfo.waitAsyncIds) {
            blockList.add(ident.callSubroutine(Xcons.List(xobject2, xobject)));
        }
        return Bcons.COMPOUND(blockList);
    }

    private Block translateTask(PragmaBlock pragmaBlock, XMPinfo xMPinfo) {
        Ident ident;
        Object object;
        BlockList blockList = Bcons.emptyBody();
        XMPobjectsRef xMPobjectsRef = xMPinfo.getOnRef();
        if (xMPobjectsRef == null) {
            return Bcons.COMPOUND(pragmaBlock.getBody());
        }
        Block block = pragmaBlock.getParentBlock();
        boolean bl = false;
        if (block != null && block instanceof PragmaBlock && (object = (XMPinfo)block.getProp("XMPprop")) != null && ((XMPinfo)object).pragma == XMPpragma.TASKS) {
            bl = true;
        }
        object = xMPobjectsRef.buildConstructor(this.env);
        BasicBlock basicBlock = ((Block)object).getBasicBlock();
        Ident ident2 = this.env.declObjectId(XMP.genSym("TASK_NODES"), pragmaBlock);
        if (!xMPinfo.isNocomm()) {
            ident = this.env.declInternIdent("xmpf_create_task_nodes_", Xtype.FsubroutineType, pragmaBlock);
            basicBlock.add(ident.callSubroutine(Xcons.List(ident2, xMPobjectsRef.getDescId().Ref())));
        }
        Ident ident3 = this.env.declInternIdent("xmpf_nodes_dealloc_", Xtype.FsubroutineType, pragmaBlock);
        Ident ident4 = this.env.declInternIdent("xmpf_ref_dealloc_", Xtype.FsubroutineType, pragmaBlock);
        if (bl) {
            block.insert((Block)object);
            block.add(ident3.callSubroutine(Xcons.List(ident2)));
            block.add(ident4.callSubroutine(Xcons.List(xMPobjectsRef.getDescId())));
        } else {
            blockList.add((Block)object);
        }
        Xobject xobject = null;
        if (!xMPinfo.isNocomm()) {
            ident = this.env.declInternIdent("xmpf_test_task_on_nodes_", Xtype.FlogicalFunctionType, pragmaBlock);
            xobject = ident.Call(Xcons.List(ident2.Ref()));
        } else {
            ident = this.env.declInternIdent("xmpf_test_task_nocomm_", Xtype.FlogicalFunctionType);
            xobject = ident.Call(Xcons.List(xMPobjectsRef.getDescId()));
        }
        blockList.add(Bcons.IF(xobject, Bcons.COMPOUND(pragmaBlock.getBody()), null));
        if (!xMPinfo.isNocomm()) {
            ident = this.env.declInternIdent("xmpf_end_task_", Xtype.FsubroutineType);
            pragmaBlock.getBody().add(ident.Call(Xcons.List()));
        }
        if (!bl) {
            if (!xMPinfo.isNocomm()) {
                blockList.add(ident3.callSubroutine(Xcons.List(ident2)));
            }
            blockList.add(ident4.callSubroutine(Xcons.List(xMPobjectsRef.getDescId())));
        }
        return Bcons.COMPOUND(blockList);
    }

    private Block translateTasks(PragmaBlock pragmaBlock, XMPinfo xMPinfo) {
        return Bcons.COMPOUND(pragmaBlock.getBody());
    }

    private Block translateGmove(PragmaBlock pragmaBlock, XMPinfo xMPinfo) {
        Xobject xobject;
        Xobject xobject2;
        Block block = Bcons.emptyBlock();
        BasicBlock basicBlock = block.getBasicBlock();
        Xobject xobject3 = xMPinfo.getGmoveLeft();
        Xobject xobject4 = xMPinfo.getGmoveRight();
        if (xobject3 == null && xobject4 == null) {
            return pragmaBlock.getBody().getHead();
        }
        Ident ident = this.buildGmoveDesc(xobject3, basicBlock, pragmaBlock);
        Ident ident2 = this.buildGmoveDesc(xobject4, basicBlock, pragmaBlock);
        if (xMPinfo.getAsyncId() != null) {
            xobject2 = Xcons.List(xMPinfo.getAsyncId());
            xobject = this.env.declInternIdent("xmpf_init_async_", Xtype.FsubroutineType);
            basicBlock.add(xobject.callSubroutine(xobject2));
        }
        xobject2 = this.env.declInternIdent("xmpf_gmv_do_", Xtype.FsubroutineType);
        xobject = Xcons.List(ident.Ref(), ident2.Ref(), xMPinfo.getGmoveOpt());
        basicBlock.add(((Ident)xobject2).callSubroutine(xobject));
        Ident ident3 = this.env.declInternIdent("xmpf_gmv_dealloc_", Xtype.FsubroutineType);
        XobjList xobjList = Xcons.List(ident.Ref());
        basicBlock.add(ident3.callSubroutine(xobjList));
        XobjList xobjList2 = Xcons.List(ident2.Ref());
        basicBlock.add(ident3.callSubroutine(xobjList2));
        if (xMPinfo.getAsyncId() != null) {
            XobjList xobjList3 = Xcons.List(xMPinfo.getAsyncId());
            Ident ident4 = this.env.declInternIdent("xmpf_start_async_", Xtype.FsubroutineType);
            basicBlock.add(ident4.callSubroutine(xobjList3));
        }
        return block;
    }

    private Ident buildGmoveDesc(Xobject xobject, BasicBlock basicBlock, PragmaBlock pragmaBlock) {
        Ident ident = this.env.declObjectId(XMP.genSym("gmv"), pragmaBlock);
        XMParray xMParray = null;
        switch (xobject.Opcode()) {
            case F_ARRAY_REF: {
                Xobject xobject2 = xobject.getArg(0).getArg(0);
                xMParray = (XMParray)xobject2.getProp("XMPRWprotected");
                if (xMParray != null) {
                    Ident ident2 = this.env.declInternIdent("xmpf_gmv_g_alloc_", Xtype.FsubroutineType);
                    XobjList xobjList = Xcons.List(ident.Ref(), xMParray.getDescId().Ref());
                    basicBlock.add(ident2.callSubroutine(xobjList));
                    ident2 = this.env.declInternIdent("xmpf_gmv_g_dim_info_", Xtype.FsubroutineType);
                    int n = 0;
                    for (Xobject xobject3 : (XobjList)xobject.getArg(1)) {
                        switch (xobject3.Opcode()) {
                            case F_ARRAY_INDEX: {
                                xobjList = Xcons.List(ident.Ref(), Xcons.IntConstant(n), Xcons.IntConstant(1), xobject3.getArg(0), Xcons.IntConstant(0), Xcons.IntConstant(0));
                                break;
                            }
                            case F_INDEX_RANGE: {
                                if (xobject3.getArg(0) == null && xobject3.getArg(1) == null) {
                                    xobjList = Xcons.List(ident.Ref(), Xcons.IntConstant(n), Xcons.IntConstant(0), Xcons.IntConstant(0), Xcons.IntConstant(0), Xcons.IntConstant(0));
                                    break;
                                }
                                Xobject xobject4 = xobject3.getArg(2);
                                if (xobject4 == null) {
                                    xobject4 = Xcons.IntConstant(1);
                                }
                                xobjList = Xcons.List(ident.Ref(), Xcons.IntConstant(n), Xcons.IntConstant(2), xobject3.getArg(0), xobject3.getArg(1), xobject4);
                                break;
                            }
                            default: {
                                XMP.fatal("buildGmoveDec: unknown F_ARRAY_REF element");
                            }
                        }
                        basicBlock.add(ident2.callSubroutine(xobjList));
                        ++n;
                    }
                } else {
                    Ident ident3 = this.env.declInternIdent("xmpf_gmv_l_alloc_", Xtype.FsubroutineType);
                    Xtype xtype = xobject2.Type();
                    if (!xtype.isFarray()) {
                        XMP.fatal("buildGmoveDesc:F_ARRAY_REF for not Farray");
                    }
                    XobjList xobjList = Xcons.List(ident.Ref(), xobject2, Xcons.IntConstant(xtype.getNumDimensions()));
                    basicBlock.add(ident3.callSubroutine(xobjList));
                    Ident ident4 = this.env.declIntrinsicIdent("lbound", Xtype.FintFunctionType);
                    Ident ident5 = this.env.declIntrinsicIdent("ubound", Xtype.FintFunctionType);
                    ident3 = this.env.declInternIdent("xmpf_gmv_l_dim_info_", Xtype.FsubroutineType);
                    int n = 0;
                    for (Xobject xobject5 : (XobjList)xobject.getArg(1)) {
                        Xobject xobject6 = Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.IntConstant(n), Xcons.IntConstant(1));
                        switch (xobject5.Opcode()) {
                            case F_ARRAY_INDEX: {
                                xobjList = Xcons.List(ident.Ref(), Xcons.IntConstant(n), ident4.Call(Xcons.List(xobject2, xobject6)), ident5.Call(Xcons.List(xobject2, xobject6)), Xcons.IntConstant(1), xobject5.getArg(0), Xcons.IntConstant(0), Xcons.IntConstant(0));
                                break;
                            }
                            case F_INDEX_RANGE: {
                                if (xobject5.getArg(0) == null && xobject5.getArg(1) == null) {
                                    xobjList = Xcons.List(ident.Ref(), Xcons.IntConstant(n), ident4.Call(Xcons.List(xobject2, xobject6)), ident5.Call(Xcons.List(xobject2, xobject6)), Xcons.IntConstant(0), Xcons.IntConstant(0), Xcons.IntConstant(0), Xcons.IntConstant(0));
                                    break;
                                }
                                Xobject xobject7 = xobject5.getArg(2);
                                if (xobject7 == null) {
                                    xobject7 = Xcons.IntConstant(1);
                                }
                                xobjList = Xcons.List(ident.Ref(), Xcons.IntConstant(n), ident4.Call(Xcons.List(xobject2, xobject6)), ident5.Call(Xcons.List(xobject2, xobject6)), Xcons.IntConstant(2), xobject5.getArg(0), xobject5.getArg(1), xobject7);
                                break;
                            }
                            default: {
                                XMP.fatal("buildGmoveDec: unknown F_ARRAY_REF element");
                            }
                        }
                        basicBlock.add(ident3.callSubroutine(xobjList));
                        ++n;
                    }
                }
                break;
            }
            case VAR: {
                xMParray = (XMParray)xobject.getProp("XMPRWprotected");
                if (xMParray != null) {
                    Ident ident6 = this.env.declInternIdent("xmpf_gmv_g_alloc_", Xtype.FsubroutineType);
                    XobjList xobjList = Xcons.List(ident.Ref(), xMParray.getDescId().Ref());
                    basicBlock.add(ident6.callSubroutine(xobjList));
                    ident6 = this.env.declInternIdent("xmpf_gmv_g_dim_info_", Xtype.FsubroutineType);
                    for (int i = 0; i < xMParray.getDim(); ++i) {
                        xobjList = Xcons.List(ident.Ref(), Xcons.IntConstant(i), Xcons.IntConstant(0), Xcons.IntConstant(0), Xcons.IntConstant(0), Xcons.IntConstant(0));
                        basicBlock.add(ident6.callSubroutine(xobjList));
                    }
                    break;
                }
                Ident ident7 = this.env.declInternIdent("xmpf_gmv_l_alloc_", Xtype.FsubroutineType);
                XobjList xobjList = Xcons.List(ident.Ref(), xobject, Xcons.IntConstant(0));
                basicBlock.add(ident7.callSubroutine(xobjList));
                break;
            }
            default: {
                XMP.errorAt(pragmaBlock, "gmove must be followed by simple assignment");
            }
        }
        return ident;
    }

    private Block translateTemplateFix(PragmaBlock pragmaBlock, XMPinfo xMPinfo) {
        Object object;
        int n;
        Xobject xobject;
        int n2;
        Block block = Bcons.emptyBlock();
        BasicBlock basicBlock = block.getBasicBlock();
        XMPtemplate xMPtemplate = xMPinfo.getTemplate();
        XobjList xobjList = xMPinfo.getSizeList();
        XobjList xobjList2 = xMPinfo.getDistList();
        if (xobjList == null || xobjList.isEmptyList()) {
            xobjList = Xcons.List();
            for (n2 = 0; n2 < xMPtemplate.getDim(); ++n2) {
                xobjList.add(Xcons.List(xMPtemplate.getLowerAt(n2), xMPtemplate.getUpperAt(n2)));
            }
        } else if (xobjList.Nargs() != xMPtemplate.getDim()) {
            XMP.fatal(pragmaBlock, "the number of <template-spec> is different from that in the declaration");
        }
        if (xobjList2 == null || xobjList2.isEmptyList()) {
            xobjList2 = Xcons.List();
            for (n2 = 0; n2 < xMPtemplate.getDim(); ++n2) {
                xobjList2.add(Xcons.List(Xcons.IntConstant(xMPtemplate.getDistMannerAt(n2)), xMPtemplate.getDistArgAt(n2)));
            }
        } else {
            for (n2 = 0; n2 < xMPtemplate.getDim(); ++n2) {
                xobject = xobjList2.getArg(n2);
                n = xMPtemplate.getDistMannerAt(n2);
                if (xobject == null) {
                    if (n == 100) continue;
                    XMP.fatal(pragmaBlock, "<dist-format> not match");
                    continue;
                }
                object = xobject.getArg(0).getString();
                if (((String)object).equalsIgnoreCase("BLOCK")) {
                    if (n == 101) continue;
                    XMP.fatal(pragmaBlock, "<dist-format> not match");
                    continue;
                }
                if (((String)object).equalsIgnoreCase("CYCLIC")) {
                    if (n == 102) continue;
                    XMP.fatal(pragmaBlock, "<dist-format> not match");
                    continue;
                }
                if (!((String)object).equalsIgnoreCase("GBLOCK")) continue;
                if (n != 104) {
                    XMP.fatal(pragmaBlock, "<dist-format> not match");
                }
                if (xMPtemplate.getDistArgAt(n2) == null) continue;
                XMP.fatal(pragmaBlock, "<dist-format> not match");
            }
        }
        Ident ident = this.env.declInternIdent("xmpf_template_dim_info_", Xtype.FsubroutineType);
        for (n2 = 0; n2 < xMPtemplate.getDim(); ++n2) {
            xobject = xobjList2.getArg(n2);
            n = 100;
            if (xobject == null) {
                n = 100;
            } else if (xobject.getArg(0).isIntConstant()) {
                n = xobject.getArg(0).getInt();
            } else {
                object = xobject.getArg(0).getString();
                if (((String)object).equalsIgnoreCase("BLOCK")) {
                    n = 101;
                } else if (((String)object).equalsIgnoreCase("CYCLIC")) {
                    n = 102;
                } else if (((String)object).equalsIgnoreCase("GBLOCK")) {
                    n = 104;
                } else {
                    XMP.fatal(pragmaBlock, "unknown distribution format," + (String)object);
                }
            }
            object = xobject != null && xobject.getArg(1) != null ? xobject.getArg(1) : Xcons.IntConstant(0);
            XobjList xobjList3 = Xcons.List(new Xobject[]{xMPtemplate.getDescId().Ref(), Xcons.IntConstant(n2), xobjList.getArg(n2).getArg(0), xobjList.getArg(n2).getArg(1), Xcons.IntConstant(n), object});
            basicBlock.add(ident.callSubroutine(xobjList3));
        }
        ident = this.env.declInternIdent("xmpf_template_init_", Xtype.FsubroutineType);
        basicBlock.add(ident.callSubroutine(Xcons.List(xMPtemplate.getDescId().Ref(), xMPtemplate.getOntoNodes().getDescId().Ref())));
        return block;
    }

    private Block buildAccHostData(Xobject xobject, BlockList blockList) {
        return Bcons.PRAGMA(Xcode.ACC_PRAGMA, "HOST_DATA", Xcons.List(Xcons.List(Xcons.String("USE_DEVICE"), xobject)), blockList);
    }
}

