/*
 * Decompiled with CFR 0.152.
 */
package exc.xmpF;

import exc.block.BasicBlock;
import exc.block.BasicBlockExprIterator;
import exc.block.BasicBlockIterator;
import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockIterator;
import exc.block.BlockList;
import exc.block.FuncDefBlock;
import exc.block.FunctionBlock;
import exc.block.PragmaBlock;
import exc.block.Statement;
import exc.block.StatementIterator;
import exc.block.topdownBlockIterator;
import exc.object.BasicType;
import exc.object.FunctionType;
import exc.object.Ident;
import exc.object.LineNo;
import exc.object.PropObject;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjConst;
import exc.object.XobjInt;
import exc.object.XobjList;
import exc.object.XobjString;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectIterator;
import exc.object.Xtype;
import exc.object.bottomupXobjectIterator;
import exc.object.topdownXobjectIterator;
import exc.xmpF.XMP;
import exc.xmpF.XMPcoarray;
import exc.xmpF.XMPcoarrayInitProcedure;
import exc.xmpF.XMPcoindexObj;
import exc.xmpF.XMPenv;
import exc.xmpF.XMPinfo;
import exc.xmpF.XMPtranslate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class XMPtransCoarrayRun {
    static final String[] _coarrayIntrinsics = new String[]{"num_images", "this_image", "image_index", "lcobound", "ucocound", "co_broadcast", "co_sum", "co_max", "co_min", "atomic_define", "atomic_ref"};
    static final List _coarrayIntrinsicList = Arrays.asList(_coarrayIntrinsics);
    static final String[] _coarrayStmtKeywords = new String[]{"xmpf_critical", "xmpf_end_critical", "xmpf_error_stop", "xmpf_lock", "xmpf_sync_all", "xmpf_sync_images", "xmpf_sync_memory", "xmpf_unlock"};
    static final List _coarrayStmtKeywordList = Arrays.asList(_coarrayStmtKeywords);
    static final String VAR_TAG_NAME = "xmpf_resource_tag";
    static final String TRAV_COUNTCOARRAY_PREFIX = "xmpf_traverse_countcoarray";
    static final String TRAV_INITCOARRAY_PREFIX = "xmpf_traverse_initcoarray";
    static final String FIND_DESCPOINTER_NAME = "xmpf_coarray_find_descptr";
    static final String COARRAY_MALLOC_NAME = "xmpf_coarray_malloc_generic";
    static final String COARRAY_REGMEM_NAME = "xmpf_coarray_regmem_generic";
    static final String COARRAY_DEALLOC_NAME = "xmpf_coarray_dealloc_generic";
    static final String COARRAY_DEREGMEM_NAME = "xmpf_coarray_deregmem";
    static final String NUM_IMAGES_NAME = "xmpf_num_images_generic";
    static final String THIS_IMAGE_NAME = "xmpf_this_image_generic";
    static final String COBOUND_NAME = "xmpf_cobound_generic";
    static final String IMAGE_INDEX_NAME = "xmpf_image_index";
    static final String CO_BROADCAST_NAME = "xmpf_co_broadcast_generic";
    static final String CO_SUM_NAME = "xmpf_co_sum_generic";
    static final String CO_MAX_NAME = "xmpf_co_max_generic";
    static final String CO_MIN_NAME = "xmpf_co_min_generic";
    static final String ATOMIC_DEFINE_NAME = "xmpf_atomic_define_generic";
    static final String ATOMIC_REF_NAME = "xmpf_atomic_ref_generic";
    static final String COARRAY_PROLOG_NAME = "xmpf_coarray_prolog";
    static final String COARRAY_EPILOG_NAME = "xmpf_coarray_epilog";
    static final String SYNCALL_NAME = "xmpf_sync_all";
    static final String SYNCIMAGES_NAME = "xmpf_sync_images";
    static final String SYNCMEMORY_NAME = "xmpf_sync_memory";
    static final String AUTO_SYNCALL_NAME = "xmpf_sync_all_auto";
    static final String FINALIZE_PROGRAM_NAME = "xmpf_finalize_all_";
    static final List<String> intrinsicProcedureNames = Arrays.asList("num_images", "this_image", "lcobound", "ucobound", "image_index", "co_broadcast", "co_sum", "co_max", "co_min", "atomic_define", "atomic_ref");
    private int version;
    private Boolean useMalloc;
    private Boolean onlyCafMode;
    private int optLevel;
    private XMPenv env;
    private String name;
    private XobjectDef def;
    FuncDefBlock funcDef;
    private static int gen_id;
    static ArrayList<XMPtransCoarrayRun> ancestors;
    private ArrayList<XMPcoarray> localCoarrays;
    private ArrayList<XMPcoarray> moduleCoarrays;
    private ArrayList<XMPcoarray> staticLocalCoarrays;
    private ArrayList<XMPcoarray> allocatableLocalCoarrays;
    private ArrayList<XMPcoarray> staticDummyCoarrays;
    private ArrayList<XMPcoarray> allocatableDummyCoarrays;
    private ArrayList<XMPcoarray> staticModuleCoarrays;
    private ArrayList<XMPcoarray> allocatableModuleCoarrays;
    private String hostModuleName;
    private String hostProcedureName;
    private XMPtransCoarrayRun hostModuleRun;
    private XMPtransCoarrayRun hostProcedureRun;
    private ArrayList<XMPcoarray> visibleCoarrays;
    private String initProcTextForFile;
    private String traverseCountName;
    private String traverseInitName;
    private Ident _resourceTagId = null;
    private ArrayList<Xobject> _prologStmts = new ArrayList();
    private ArrayList<Xobject> _epilogStmts = new ArrayList();
    private ArrayList<Xobject> _extraStmts = new ArrayList();
    private Boolean _autoDealloc;

    public XMPtransCoarrayRun(XobjectDef xobjectDef, XMPenv xMPenv, ArrayList<XMPtransCoarrayRun> arrayList, int n, int n2, Boolean bl, Boolean bl2, int n3) {
        this.def = xobjectDef;
        this.env = xMPenv;
        this.name = xobjectDef.getName();
        this.version = n2;
        this.useMalloc = bl;
        this.onlyCafMode = bl2;
        this.optLevel = n3;
        this.funcDef = new FuncDefBlock(xobjectDef);
        xMPenv.setCurrentDef(this.funcDef);
        this._setHostName();
        this._setHostRun(arrayList);
        String string = this._genNewProcPostfix();
        this.traverseCountName = TRAV_COUNTCOARRAY_PREFIX + string;
        this.traverseInitName = TRAV_INITCOARRAY_PREFIX + string;
        XMP.exitByError();
    }

    private void disp_version(String string) {
        switch (this.version) {
            case 3: {
                break;
            }
            case 4: {
                XMP.warning("Coarray Fortran Version 4 (trial version): " + string);
                break;
            }
            case 6: {
                XMP.warning("Coarray Fortran Version 6 (another trial version): " + string);
                break;
            }
            case 7: {
                if (this.useMalloc.booleanValue()) {
                    XMP.warning("Coarray Fortran Version 7g (latest version 7 over GASNet): " + string);
                    break;
                }
                XMP.warning("Coarray Fortran Version 7 (latest version): " + string);
                break;
            }
            default: {
                XMP.fatal("Wrong version number (" + this.version + ") specified for Coarray Fortran");
            }
        }
    }

    private void _setHostName() {
        this.hostModuleName = null;
        this.hostProcedureName = null;
        XobjectDef xobjectDef = this.def.getParent();
        if (xobjectDef == null) {
            return;
        }
        block0 : switch (xobjectDef.getDef().Opcode()) {
            case F_MODULE_DEFINITION: {
                this.hostModuleName = xobjectDef.getName();
                break;
            }
            case FUNCTION_DEFINITION: {
                this.hostProcedureName = xobjectDef.getName();
                XobjectDef xobjectDef2 = xobjectDef.getParent();
                if (xobjectDef2 == null) break;
                switch (xobjectDef2.getDef().Opcode()) {
                    case F_MODULE_DEFINITION: {
                        this.hostModuleName = xobjectDef2.getName();
                        break block0;
                    }
                }
                XMP.fatal("INTERNAL: unexpected nest of procedures " + this.name + ", " + this.hostProcedureName + ", " + xobjectDef2.getName());
                break;
            }
        }
    }

    private void _setHostRun(ArrayList<XMPtransCoarrayRun> arrayList) {
        if (arrayList == null) {
            return;
        }
        this.hostModuleRun = null;
        this.hostProcedureRun = null;
        XobjectDef xobjectDef = this.def.getParent();
        if (xobjectDef == null) {
            return;
        }
        switch (xobjectDef.getDef().Opcode()) {
            case FUNCTION_DEFINITION: {
                this._setHostRun_proc(xobjectDef, arrayList);
                break;
            }
            case F_MODULE_DEFINITION: {
                this._setHostRun_module(xobjectDef, arrayList);
                break;
            }
            default: {
                XMP.fatal("INTERNAL: illegal opcode of parent XobjectDef: " + (Object)((Object)xobjectDef.getDef().Opcode()));
            }
        }
    }

    private void _setHostRun_proc(XobjectDef xobjectDef, ArrayList<XMPtransCoarrayRun> arrayList) {
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            XMPtransCoarrayRun xMPtransCoarrayRun = object.next();
            if (xobjectDef != xMPtransCoarrayRun.def) continue;
            this.hostProcedureRun = xMPtransCoarrayRun;
            break;
        }
        if (this.hostProcedureRun == null) {
            XMP.fatal("INTERNAL: Host procedure '" + this.hostProcedureName + "' is expected in pastRuns before '" + this.name + "'");
        }
        if ((object = xobjectDef.getParent()) == null) {
            return;
        }
        switch (((XobjectDef)object).getDef().Opcode()) {
            case F_MODULE_DEFINITION: {
                this._setHostRun_module((XobjectDef)object, arrayList);
                break;
            }
            default: {
                XMP.fatal("INTERNAL: illegal opcode of ground-parent XobjectDef: " + (Object)((Object)((XobjectDef)object).getDef().Opcode()));
            }
        }
    }

    private void _setHostRun_module(XobjectDef xobjectDef, ArrayList<XMPtransCoarrayRun> arrayList) {
        for (XMPtransCoarrayRun xMPtransCoarrayRun : arrayList) {
            if (xobjectDef != xMPtransCoarrayRun.def) continue;
            this.hostModuleRun = xMPtransCoarrayRun;
            break;
        }
        if (this.hostModuleRun == null) {
            XMP.fatal("INTERNAL: Host module '" + this.hostModuleName + "' is expected in pastRuns before '" + this.name + "'");
        }
    }

    private void _hoistLocalCoarrays(Xobject xobject, Xobject xobject2, FunctionBlock functionBlock, Boolean bl) {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(functionBlock);
        ((BlockIterator)topdownBlockIterator2).init();
        while (!((BlockIterator)topdownBlockIterator2).end()) {
            Block block = topdownBlockIterator2.getBlock();
            if (block.Opcode() == Xcode.F_BLOCK_STATEMENT) {
                XobjList xobjList = block.getBody().getIdentList();
                block1: for (Xobject xobject3 : xobjList) {
                    Object object;
                    Object object2;
                    Object object3;
                    Ident ident = (Ident)xobject3;
                    if (!ident.wasCoarray()) continue;
                    if (bl.booleanValue()) {
                        ident.setAlias(ident.getName() + "_" + XMPtransCoarrayRun.get_gen_id());
                        block2: while (true) {
                            object3 = block.findVarIdent(ident.getAlias());
                            object2 = block;
                            while (object3 != null) {
                                if (((Ident)object3).wasCoarray() && ((Block)(object2 = ((Block)object2).findVarIdentBlock(ident.getAlias()))).Opcode() == Xcode.F_BLOCK_STATEMENT) {
                                    object3 = ((Block)object2).findVarIdent(ident.getAlias());
                                    continue;
                                }
                                ident.setAlias(ident.getName() + "_" + XMPtransCoarrayRun.get_gen_id());
                                object3 = block.findVarIdent(ident.getAlias());
                                continue block2;
                            }
                            for (object = this.def.getParent(); object != null; object = ((XobjectDef)object).getParent()) {
                                for (Xobject xobject4 : (XobjList)((XobjectDef)object).getDef().getArg(1)) {
                                    if (!xobject4.getName().equals(ident.getAlias())) continue;
                                    ident.setAlias(ident.getName() + "_" + XMPtransCoarrayRun.get_gen_id());
                                    continue block2;
                                }
                            }
                            continue block1;
                            break;
                        }
                        {
                            break;
                        }
                    }
                    if (block.Opcode() == Xcode.FUNCTION_DEFINITION) {
                        object3 = functionBlock.getNameObj().Type();
                        object2 = null;
                        if (object3 != null && ((Xtype)object3).isFunction()) {
                            object2 = ((Xtype)object3).getFuncParam();
                        }
                        if (object2 != null && ident.getStorageClass() == StorageClass.FPARAM) {
                            object = ((XobjList)object2).iterator();
                            while (object.hasNext()) {
                                Xobject xobject5 = (Xobject)object.next();
                                if (xobject5.Opcode() != Xcode.IDENT || !xobject5.getName().equals(ident.getName())) continue;
                                xobject5.setName(ident.getAlias());
                            }
                        }
                    }
                    object3 = (XobjList)block.getBody().getDecls();
                    object2 = ((XobjList)object3).iterator();
                    while (object2.hasNext()) {
                        object = object2.next();
                        if (((Xobject)object).Opcode() != Xcode.VAR_DECL || !((XobjString)((Xobject)object).getArg(0)).getName().equals(ident.getName())) continue;
                        ((XobjString)((Xobject)object).getArg(0)).setName(ident.getAlias());
                        ((XobjString)ident.getValue()).setName(ident.getAlias());
                        ident.setName(ident.getAlias());
                        xobjList.remove((Xobject)object);
                        xobject.add(ident);
                        block.getBody().addLocalCoarray(ident);
                        ((XobjList)object3).remove((Xobject)object);
                        xobject2.add((Xobject)object);
                        continue block1;
                    }
                }
            }
            ((BlockIterator)topdownBlockIterator2).next();
        }
    }

    private void _rewriteExprLocalCoarrays(FunctionBlock functionBlock) {
        PropObject propObject;
        Xobject xobject;
        Object object;
        Object object2;
        PropObject propObject2;
        PropObject propObject3;
        Object object3;
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(functionBlock);
        ((BlockIterator)topdownBlockIterator2).init();
        while (!((BlockIterator)topdownBlockIterator2).end()) {
            object3 = topdownBlockIterator2.getBlock();
            if (((Block)object3).Opcode() == Xcode.XMP_PRAGMA && ((PragmaBlock)(propObject3 = (PragmaBlock)object3)).getPragma().equals("COARRAY")) {
                propObject2 = ((PragmaBlock)propObject3).getClauses();
                object2 = (XobjList)((Xobject)propObject2).getArg(1);
                object = ((XobjList)object2).iterator();
                while (object.hasNext()) {
                    xobject = object.next();
                    propObject = this.env.findVarIdent(xobject.getString(), (Block)propObject3);
                    if (propObject == null || propObject.getAlias() == null) continue;
                    ((XobjString)xobject).setName(propObject.getAlias());
                }
            }
            ((BlockIterator)topdownBlockIterator2).next();
        }
        object3 = new BasicBlockExprIterator(functionBlock);
        ((BasicBlockExprIterator)object3).init();
        while (!((BasicBlockExprIterator)object3).end()) {
            propObject3 = ((BasicBlockExprIterator)object3).getExpr();
            propObject2 = ((BasicBlockExprIterator)object3).getBasicBlock();
            if (propObject3 != null) {
                object2 = new bottomupXobjectIterator((Xobject)propObject3);
                ((bottomupXobjectIterator)object2).init();
                while (!((bottomupXobjectIterator)object2).end()) {
                    object = ((XobjectIterator)object2).getXobject();
                    if (object != null && ((Xobject)object).Opcode() != null) {
                        switch (((Xobject)object).Opcode()) {
                            case VAR: {
                                String string;
                                xobject = this.env.findVarIdent(((Xobject)object).getName(), ((BasicBlock)propObject2).getParent());
                                propObject = this.env.findVarIdentBlock(((Xobject)object).getName(), ((BasicBlock)propObject2).getParent());
                                if (xobject == null || !((Ident)xobject).wasCoarray() || (string = ((Ident)xobject).getAlias()) == null) break;
                                ((XobjString)object).setName(string);
                            }
                        }
                    }
                    ((bottomupXobjectIterator)object2).next();
                }
            }
            ((BasicBlockExprIterator)object3).next();
        }
    }

    private void _setLocalCoarrays() {
        this.localCoarrays = new ArrayList();
        this.moduleCoarrays = new ArrayList();
        Xobject xobject = this.def.getFuncIdList();
        for (Xobject object : (XobjList)xobject) {
            Ident ident = (Ident)object;
            if (!ident.wasCoarray()) continue;
            XMPcoarray xMPcoarray = new XMPcoarray(ident, this.def, this.getFblock(), this.env);
            xMPcoarray.setUseMallocWithHint(this.useMalloc);
            if (xMPcoarray.isUseAssociated().booleanValue()) {
                this.moduleCoarrays.add(xMPcoarray);
                continue;
            }
            this.localCoarrays.add(xMPcoarray);
        }
        for (int i = 0; i < this.moduleCoarrays.size(); ++i) {
            XMPcoarray xMPcoarray = this.moduleCoarrays.get(i);
            this.moduleCoarrays.set(i, this.localizedCopyOfCoarray(xMPcoarray));
        }
        this.staticLocalCoarrays = new ArrayList();
        this.allocatableLocalCoarrays = new ArrayList();
        this.staticDummyCoarrays = new ArrayList();
        this.allocatableDummyCoarrays = new ArrayList();
        for (XMPcoarray xMPcoarray : this.localCoarrays) {
            if (xMPcoarray.isDummyArg().booleanValue()) {
                if (xMPcoarray.isAllocatable().booleanValue()) {
                    this.allocatableDummyCoarrays.add(xMPcoarray);
                    continue;
                }
                this.staticDummyCoarrays.add(xMPcoarray);
                continue;
            }
            if (xMPcoarray.isExplicitShape().booleanValue()) {
                this.staticLocalCoarrays.add(xMPcoarray);
                continue;
            }
            this.allocatableLocalCoarrays.add(xMPcoarray);
        }
        this.staticModuleCoarrays = new ArrayList();
        this.allocatableModuleCoarrays = new ArrayList();
        for (XMPcoarray xMPcoarray : this.moduleCoarrays) {
            if (xMPcoarray.isExplicitShape().booleanValue()) {
                this.staticModuleCoarrays.add(xMPcoarray);
                continue;
            }
            this.allocatableModuleCoarrays.add(xMPcoarray);
        }
        if (this.hostModuleRun != null && this.hostProcedureRun == null) {
            for (XMPcoarray xMPcoarray : this.hostModuleRun.staticLocalCoarrays) {
                if (this.funcDef.getBlock().getBody().findLocalIdent(xMPcoarray.getName()) != null) continue;
                this.staticModuleCoarrays.add(this.localizedCopyOfCoarray(xMPcoarray));
            }
            for (XMPcoarray xMPcoarray : this.hostModuleRun.staticModuleCoarrays) {
                if (this.funcDef.getBlock().getBody().findLocalIdent(xMPcoarray.getName()) != null) continue;
                this.staticModuleCoarrays.add(this.localizedCopyOfCoarray(xMPcoarray));
            }
        }
    }

    private XMPcoarray localizedCopyOfCoarray(XMPcoarray xMPcoarray) {
        Ident ident = xMPcoarray.getIdent();
        Xtype xtype = ident.Type().copy();
        String string = xMPcoarray.getName();
        this.env.removeIdent(string, null);
        Ident ident2 = this.env.declIdent(string, xtype);
        ident2.setFdeclaredModule(null);
        XMPcoarray xMPcoarray2 = new XMPcoarray(ident2, this.def, this.getFblock(), this.env, xMPcoarray.getHomeBlockCodeName());
        xMPcoarray2.setUseMallocWithHint(this.useMalloc);
        xMPcoarray2.setWasMovedFromModule(true);
        return xMPcoarray2;
    }

    private void _setVisibleCoarrays() {
        this.visibleCoarrays = new ArrayList();
        this._mergeCoarraysByName(this.visibleCoarrays, this.localCoarrays);
        this._mergeCoarraysByName(this.visibleCoarrays, this.staticModuleCoarrays);
        this._mergeCoarraysByName(this.visibleCoarrays, this.allocatableModuleCoarrays);
        if (this.hostProcedureRun != null) {
            this._mergeCoarraysByName(this.visibleCoarrays, this.hostProcedureRun.visibleCoarrays);
        } else if (this.hostModuleRun != null) {
            this._mergeCoarraysByName(this.visibleCoarrays, this.hostModuleRun.visibleCoarrays);
        }
    }

    private void _mergeCoarraysByName(ArrayList<XMPcoarray> arrayList, ArrayList<XMPcoarray> arrayList2) {
        ArrayList<XMPcoarray> arrayList3 = new ArrayList<XMPcoarray>();
        for (XMPcoarray xMPcoarray : arrayList2) {
            boolean bl = false;
            String string = xMPcoarray.getName();
            for (XMPcoarray xMPcoarray2 : arrayList) {
                if (!string.equals(xMPcoarray2.getName())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList3.add(xMPcoarray);
        }
        arrayList.addAll(arrayList3);
    }

    public void run3() {
        this._hoistLocalCoarrays(null, null, this.getFblock(), true);
        this._rewriteExprLocalCoarrays(this.getFblock());
        this.funcDef.finalizeBlock();
    }

    public void run4() {
        this._hoistLocalCoarrays(this.def.getFuncIdList(), this.def.getFuncDecls(), this.getFblock(), false);
        this.funcDef.finalizeBlock();
    }

    public void run1() {
        this._setLocalCoarrays();
        if (this.version > 3) {
            this.disp_version("run1, " + this.getName());
        }
        if (this.isModule()) {
            this.run1_module();
        } else if (this.isBlockData()) {
            this.run1_procedure();
        } else if (this.isFunction()) {
            this.run1_procedure();
            if (this.onlyCafMode.booleanValue() && this.isMainProgram()) {
                this._convMainProgramToSubroutine("xmpf_main");
                XMPtranslate.create_main(this.def);
            }
        } else {
            XMP.fatal("XMPtransCoarrayRun.run1(), def kind unkown : " + this.def);
        }
    }

    private void run1_procedure() {
        this.set_autoDealloc(false);
        this.transDeclPart_staticLocal();
        this.transDeclPart_allocatableLocal();
        this.transDeclPart_staticDummy();
        this.transDeclPart_allocatableDummy();
        this.transDeclPart_staticModule();
        this.transDeclPart_allocatableModule();
        this._setVisibleCoarrays();
        this.transExecPart();
        this.funcDef.finalizeBlock();
    }

    private void _convMainProgramToSubroutine(String string) {
        Xtype xtype = this.def.getFuncType();
        xtype.setIsFprogram(false);
        String string2 = this.def.getName();
        Ident ident = this.env.getEnv().findVarIdent(string2);
        if (ident == null) {
            XMP.fatal("main program name '" + string2 + "' not found");
        }
        ident.setName(string);
        this.def.setName(string);
    }

    private void run1_module() {
        this.transModule_staticLocal1();
        this.transModule_allocatableLocal();
        this.transModule_allocatableModule();
        this._setVisibleCoarrays();
        this.funcDef.finalizeBlock();
    }

    public void run2() {
        this._setLocalCoarrays();
        if (this.version > 3) {
            this.disp_version("run2, " + this.getName());
        }
        if (this.isModule()) {
            this.run2_module();
        } else {
            this.run2_procedure();
        }
    }

    private void run2_module() {
        this.transModule_staticLocal2();
        this.removeDeclOfIntrinsicNames();
    }

    private void run2_procedure() {
        this.removeDeclOfIntrinsicNames();
    }

    private void transDeclPart_staticLocal() {
        this.genDeclOfDescPointer(this.staticLocalCoarrays);
        if (this.version == 7) {
            this.addSaveAttrToDescPointer(this.staticLocalCoarrays, false);
        } else if (this.version == 6) {
            this.addSaveAttrToDescPointer(this.staticLocalCoarrays);
        } else {
            this.genCommonStmt(this.staticLocalCoarrays);
        }
        if (this.version == 7 && this.useMalloc.booleanValue()) {
            this.genDeclOfCrayPointer_withSave(this.staticLocalCoarrays);
        } else if (this.version <= 3) {
            this.genDeclOfCrayPointer(this.staticLocalCoarrays);
            this.genCommonStmtForCrayPointer(this.staticLocalCoarrays);
        } else {
            this.genDeclOfCrayPointer(this.staticLocalCoarrays);
            this.genCommonStmtForCrayPointer(this.staticLocalCoarrays);
        }
        if (this.version == 7) {
            if (this.useMalloc.booleanValue()) {
                this.readyBlockForStaticCoarrays_alloc(this.staticLocalCoarrays);
            } else {
                this.readyBlockForStaticCoarrays_regmem(this.staticLocalCoarrays);
            }
        } else if (this.version == 6) {
            this.genRegmemOfStaticCoarrays(this.staticLocalCoarrays);
        } else {
            this.genAllocOfStaticCoarrays(this.staticLocalCoarrays);
        }
        this.removeCodimensions(this.staticLocalCoarrays);
        if (this.version == 6) {
            this.addSaveAttr(this.staticLocalCoarrays);
        } else {
            this.removeSaveAttr(this.staticLocalCoarrays);
            if (this.version == 4) {
                this.genCommonBlockForStaticCoarrays(this.staticLocalCoarrays);
            }
        }
    }

    private void transDeclPart_staticModule() {
        this.genDeclOfDescPointer(this.staticModuleCoarrays);
        this.genCommonStmt(this.staticModuleCoarrays);
        this.genCommonBlockForStaticCoarrays(this.staticModuleCoarrays);
        this.genDeclOfCrayPointer(this.staticModuleCoarrays);
        this.genCommonStmtForCrayPointer(this.staticModuleCoarrays);
        this.genAllocOfStaticCoarrays(this.staticModuleCoarrays);
        this.removeCodimensions(this.staticModuleCoarrays);
        this.removeSaveAttr(this.staticModuleCoarrays);
    }

    private void transDeclPart_allocatableLocal() {
        this.genDeclOfDescPointer(this.allocatableLocalCoarrays, true);
        this.removeCodimensions(this.allocatableLocalCoarrays);
        this.removeSaveAttr(this.allocatableLocalCoarrays);
        this.replaceAllocatableWithPointer(this.allocatableLocalCoarrays);
    }

    private void transDeclPart_allocatableModule() {
        this.genDeclOfDescPointer(this.allocatableModuleCoarrays, true);
    }

    private void transModule_allocatableLocal() {
        this.genDeclOfDescPointer(this.allocatableLocalCoarrays);
        this.removeCodimensions(this.allocatableLocalCoarrays);
        this.replaceAllocatableWithPointer(this.allocatableLocalCoarrays);
    }

    private void transModule_allocatableModule() {
        this.genDeclOfDescPointer(this.allocatableModuleCoarrays);
        this.removeCodimensions(this.allocatableModuleCoarrays);
        this.replaceAllocatableWithPointer(this.allocatableModuleCoarrays);
    }

    private void transDeclPart_staticDummy() {
        this.genDeclOfDescPointer(this.staticDummyCoarrays, true);
        this.genDefinitionOfDescPointer(this.staticDummyCoarrays);
        this.removeCodimensions(this.staticDummyCoarrays);
    }

    private void transDeclPart_allocatableDummy() {
        if (this.allocatableDummyCoarrays.isEmpty()) {
            return;
        }
        this.genDeclOfDescPointer(this.allocatableDummyCoarrays, true);
        this.genDefinitionOfDescPointer(this.allocatableDummyCoarrays);
        this.removeCodimensions(this.allocatableDummyCoarrays);
        this.replaceAllocatableWithPointer(this.allocatableDummyCoarrays);
    }

    private void transModule_staticLocal1() {
        this.genDeclOfDescPointer(this.staticLocalCoarrays);
        this.genDeclOfCrayPointer(this.staticLocalCoarrays);
        this.genAllocOfStaticCoarrays(this.staticLocalCoarrays);
    }

    private void transModule_staticLocal2() {
        this.removeDeclOfCoarrays(this.staticLocalCoarrays);
    }

    private void transExecPart() {
        this.replaceIntrinsicCalls1(this.visibleCoarrays);
        this.convCoidxObjsToFuncCalls(this.visibleCoarrays);
        this.convCoidxStmtsToSubrCalls(this.visibleCoarrays);
        if (this.optLevel == 1) {
            this.convGETfuncStmtsToSubrCalls(this.visibleCoarrays);
        }
        this.convAllocateStmts(this.visibleCoarrays);
        this.convDellocateStmts(this.visibleCoarrays);
        this.replaceIntrinsicCalls2(this.visibleCoarrays);
        this.genCallOfPrologAndEpilog();
        if (this.onlyCafMode.booleanValue()) {
            this.insertFinalizationCall();
        }
        this.addVisibleCoarraysToSyncEtc(this.visibleCoarrays);
        for (XMPcoarray xMPcoarray : this.moduleCoarrays) {
            if (xMPcoarray.isExplicitShape().booleanValue()) continue;
            this.removeDeclOfCoarray(xMPcoarray);
        }
        this.expandEntryBlockForStaticCoarrays();
    }

    private void genDeclOfDescPointer(ArrayList<XMPcoarray> arrayList) {
        this.genDeclOfDescPointer(arrayList, false);
    }

    private void genDeclOfDescPointer(ArrayList<XMPcoarray> arrayList, Boolean bl) {
        for (XMPcoarray xMPcoarray : arrayList) {
            xMPcoarray.genDecl_descPointer();
            if (!bl.booleanValue()) continue;
            xMPcoarray.setZeroToDescPointer();
        }
    }

    private void genCommonStmt(ArrayList<XMPcoarray> arrayList) {
        if (arrayList.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (XMPcoarray xMPcoarray : arrayList) {
            String string = xMPcoarray.getDescCommonName();
            if (arrayList2.contains(string)) continue;
            arrayList2.add(string);
            XobjString xobjString = Xcons.Symbol(Xcode.IDENT, string);
            XobjList xobjList = Xcons.List();
            for (XMPcoarray xMPcoarray2 : arrayList) {
                if (!string.equals(xMPcoarray2.getDescCommonName())) continue;
                Ident ident = xMPcoarray2.getDescPointerId();
                ((Xobject)xobjList).add(Xcons.FvarRef(ident));
            }
            Xobject xobject = this.getFblock().getBody().getDecls();
            XobjList object2 = Xcons.List(Xcode.F_COMMON_DECL, Xcons.List(Xcode.F_VAR_LIST, xobjString, xobjList));
            xobject.add(object2);
        }
    }

    private void addSaveAttrToDescPointer(ArrayList<XMPcoarray> arrayList) {
        this.addSaveAttrToDescPointer(arrayList, true);
    }

    private void addSaveAttrToDescPointer(ArrayList<XMPcoarray> arrayList, Boolean bl) {
        if (this.isModule()) {
            XMP.fatal("unexpected situation (XMPtransCoarrayRun.addSaveAttrToDescPointer)");
            return;
        }
        for (XMPcoarray xMPcoarray : arrayList) {
            xMPcoarray.setSaveAttrToDescPointer();
        }
        if (bl.booleanValue()) {
            for (XMPcoarray xMPcoarray : arrayList) {
                xMPcoarray.setZeroToDescPointer();
            }
        }
    }

    private void genCommonBlockForStaticCoarrays(ArrayList<XMPcoarray> arrayList) {
        if (arrayList.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (XMPcoarray xMPcoarray : arrayList) {
            String string = xMPcoarray.getCoarrayCommonName();
            if (xMPcoarray.usesMalloc().booleanValue() || arrayList2.contains(string)) continue;
            arrayList2.add(string);
            XobjString xobjString = Xcons.Symbol(Xcode.IDENT, string);
            XobjList xobjList = Xcons.List();
            for (XMPcoarray xMPcoarray2 : arrayList) {
                if (!string.equals(xMPcoarray2.getCoarrayCommonName())) continue;
                Ident ident = xMPcoarray2.getIdent();
                ((Xobject)xobjList).add(Xcons.FvarRef(ident));
            }
            Xobject xobject = this.getFblock().getBody().getDecls();
            XobjList object2 = Xcons.List(Xcode.F_COMMON_DECL, Xcons.List(Xcode.F_VAR_LIST, xobjString, xobjList));
            xobject.add(object2);
        }
    }

    private void genDeclOfCrayPointer(ArrayList<XMPcoarray> arrayList) {
        this.genDeclOfCrayPointer(arrayList, false);
    }

    private void genDeclOfCrayPointer(ArrayList<XMPcoarray> arrayList, Boolean bl) {
        if (arrayList.isEmpty()) {
            return;
        }
        for (XMPcoarray xMPcoarray : arrayList) {
            if (!xMPcoarray.usesMalloc().booleanValue()) continue;
            xMPcoarray.genDecl_crayPointer(bl);
        }
    }

    private void genDeclOfCrayPointer_withSave(ArrayList<XMPcoarray> arrayList) {
        this.genDeclOfCrayPointer(arrayList, true);
    }

    private void genCommonStmtForCrayPointer(ArrayList<XMPcoarray> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (XMPcoarray xMPcoarray : arrayList) {
            String string = xMPcoarray.getCrayCommonName();
            if (!xMPcoarray.usesMalloc().booleanValue() || arrayList2.contains(string)) continue;
            arrayList2.add(string);
            XobjString xobjString = Xcons.Symbol(Xcode.IDENT, string);
            XobjList xobjList = Xcons.List();
            for (XMPcoarray xMPcoarray2 : arrayList) {
                if (!string.equals(xMPcoarray2.getCrayCommonName())) continue;
                Ident ident = xMPcoarray2.getCrayPointerId();
                ((Xobject)xobjList).add(Xcons.FvarRef(ident));
            }
            Xobject xobject = this.getFblock().getBody().getDecls();
            XobjList object2 = Xcons.List(Xcode.F_COMMON_DECL, Xcons.List(Xcode.F_VAR_LIST, xobjString, xobjList));
            xobject.add(object2);
        }
    }

    private void addVisibleCoarraysToSyncEtc(ArrayList<XMPcoarray> arrayList) {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(this.getFblock());
        ((BlockIterator)topdownBlockIterator2).init();
        while (!((BlockIterator)topdownBlockIterator2).end()) {
            BasicBlock basicBlock = topdownBlockIterator2.getBlock().getBasicBlock();
            if (basicBlock != null) {
                for (Statement statement = basicBlock.getHead(); statement != null; statement = statement.getNext()) {
                    Xobject xobject;
                    Xobject xobject2;
                    Xobject xobject3;
                    Xobject xobject4;
                    Xobject xobject5 = statement.getExpr();
                    if (this._isCallStmtForSyncimages(xobject5).booleanValue()) {
                        xobject4 = xobject5.getArg(0);
                        xobject3 = xobject4.getArg(1);
                        if (xobject3 == null || xobject3.Nargs() == 0) {
                            XMP.error("lack of arguments in SYNC IMAGES");
                            continue;
                        }
                        xobject2 = ((XobjList)xobject3).getArg(0);
                        Xtype xtype = xobject2.Type();
                        Xobject xobject6 = null;
                        switch (xtype.getKind()) {
                            case 1: {
                                switch (xtype.getBasicType()) {
                                    case 7: {
                                        xobject6 = Xcons.IntConstant(1);
                                        break;
                                    }
                                    case 23: {
                                        xobject6 = Xcons.IntConstant(0);
                                    }
                                }
                                break;
                            }
                            case 8: {
                                xobject = this.declIntIntrinsicIdent("size");
                                xobject6 = xobject.Call(Xcons.List(xobject2));
                            }
                        }
                        xobject3.insert(xobject6);
                    }
                    if (!this._isCallStmtForSyncEtc(xobject5).booleanValue()) continue;
                    xobject4 = this._getCoarrayNamesIntoArgs(arrayList);
                    xobject3 = xobject5.getArg(0);
                    xobject2 = xobject3.getArg(1);
                    if (xobject2 == null) {
                        xobject3.setArg(1, xobject4);
                        continue;
                    }
                    for (Xobject xobject6 : (XobjList)xobject4) {
                        xobject = xobject6.getArg(0);
                        xobject2.add(xobject);
                    }
                }
            }
            ((BlockIterator)topdownBlockIterator2).next();
        }
    }

    private Boolean _isCallStmtForSyncimages(Xobject xobject) {
        String[] stringArray = new String[]{SYNCIMAGES_NAME};
        return this._isCallStmtForSubroutines(xobject, stringArray);
    }

    private Boolean _isCallStmtForSyncEtc(Xobject xobject) {
        String[] stringArray = new String[]{SYNCALL_NAME, AUTO_SYNCALL_NAME, SYNCIMAGES_NAME, SYNCMEMORY_NAME};
        return this._isCallStmtForSubroutines(xobject, stringArray);
    }

    private Boolean _isCallStmtForSubroutines(Xobject xobject, String[] stringArray) {
        List<String> list = Arrays.asList(stringArray);
        return this._isCallStmtForSubroutines(xobject, list);
    }

    private Boolean _isCallStmtForSubroutines(Xobject xobject, List<String> list) {
        if (xobject == null || xobject.Opcode() != Xcode.EXPR_STATEMENT) {
            return false;
        }
        Xobject xobject2 = xobject.getArg(0);
        if (xobject2 == null || xobject2.Opcode() != Xcode.FUNCTION_CALL || xobject2.getArg(0).Opcode() == Xcode.MEMBER_REF) {
            return false;
        }
        String string = xobject2.getArg(0).getName();
        return list.contains(string);
    }

    private Xobject _getCoarrayNamesIntoArgs(ArrayList<XMPcoarray> arrayList) {
        XobjList xobjList = Xcons.List();
        for (XMPcoarray xMPcoarray : arrayList) {
            Xobject xobject = Xcons.FvarRef(xMPcoarray.getIdent());
            if (xMPcoarray.isAllocatable().booleanValue()) {
                Ident ident = this.declInt8IntrinsicIdent("loc");
                ((Xobject)xobjList).add(ident.Call(Xcons.List(xobject)));
                continue;
            }
            ((Xobject)xobjList).add(xobject);
        }
        return xobjList;
    }

    private void insertFinalizationCall() {
        BasicBlockIterator basicBlockIterator = new BasicBlockIterator(this.getFblock());
        basicBlockIterator.init();
        while (!basicBlockIterator.end()) {
            StatementIterator statementIterator = basicBlockIterator.getBasicBlock().statements();
            while (statementIterator.hasNext()) {
                Statement statement = (Statement)statementIterator.next();
                Xobject xobject = statement.getExpr();
                if (xobject == null) continue;
                switch (xobject.Opcode()) {
                    case F_STOP_STATEMENT: {
                        LineNo lineNo = xobject.getLineNo();
                        Ident ident = this.env.declInternIdent(FINALIZE_PROGRAM_NAME, Xtype.FsubroutineType);
                        Xobject xobject2 = ident.callSubroutine();
                        xobject2.setLineNo(lineNo);
                        statement.insert(xobject2);
                        break;
                    }
                }
            }
            basicBlockIterator.next();
        }
    }

    private void genCallOfPrologAndEpilog() {
        if (this.get_autoDealloc().booleanValue()) {
            this.genCallOfPrologAndEpilog_dealloc();
        }
        if (this._prologStmts.size() > 0) {
            this.genPrologStmts();
        }
        if (this._epilogStmts.size() > 0) {
            this.genEpilogStmts();
        }
    }

    private void genPrologStmts() {
        BlockList blockList = this.getFblock().getBody().getHead().getBody();
        int n = this._prologStmts.size();
        for (int i = n - 1; i >= 0; --i) {
            blockList.insert(this._prologStmts.get(i));
        }
        if (n > 0 && this._findEntryStmtInBlock().booleanValue()) {
            XMP.error("restriction: An ENTRY statement is not allowed in the program including coarray features.");
        }
    }

    private Boolean _findEntryStmtInBlock() {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(this.getFblock());
        ((BlockIterator)topdownBlockIterator2).init();
        while (!((BlockIterator)topdownBlockIterator2).end()) {
            Block block = topdownBlockIterator2.getBlock();
            if (block.Opcode() == Xcode.F_ENTRY_DECL) {
                return true;
            }
            ((BlockIterator)topdownBlockIterator2).next();
        }
        return false;
    }

    private void genEpilogStmts() {
        Object object;
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(this.getFblock());
        ((BlockIterator)topdownBlockIterator2).init();
        while (!((BlockIterator)topdownBlockIterator2).end()) {
            object = topdownBlockIterator2.getBlock();
            switch (((Block)object).Opcode()) {
                case RETURN_STATEMENT: {
                    LineNo lineNo = ((Block)object).getLineNo();
                    for (Xobject xobject : this._epilogStmts) {
                        Xobject xobject2 = xobject.copy();
                        xobject2.setLineNo(lineNo);
                        ((Block)object).insert(xobject2);
                    }
                    break;
                }
            }
            ((BlockIterator)topdownBlockIterator2).next();
        }
        object = this.getFblock().getBody().getHead().getBody();
        if (((BlockList)object).getTail().Opcode() == Xcode.RETURN_STATEMENT) {
            return;
        }
        for (Xobject xobject : this._epilogStmts) {
            ((BlockList)object).add(xobject);
        }
    }

    private void genCallOfPrologAndEpilog_syncall() {
        XobjList xobjList = Xcons.List();
        Ident ident = this.env.declExternIdent(AUTO_SYNCALL_NAME, BasicType.FexternalSubroutineType);
        Xobject xobject = ident.callSubroutine(xobjList);
        this.addEpilogStmt(xobject);
    }

    private void genCallOfPrologAndEpilog_dealloc() {
        XobjList xobjList = Xcons.List(Xcons.FvarRef(this.getResourceTagId()), Xcons.IntConstant(this.name.length()), Xcons.FcharacterConstant(Xtype.FcharacterType, this.name, null));
        Ident ident = this.env.declExternIdent(COARRAY_PROLOG_NAME, BasicType.FexternalSubroutineType);
        if (((Xobject)xobjList).hasNullArg()) {
            XMP.fatal("INTERNAL: generated null argument " + ident + "(genCallofPrologAndEpilog args1)");
        }
        Xobject xobject = ident.callSubroutine(xobjList);
        this.insertPrologStmt(xobject);
        XobjList xobjList2 = Xcons.List(Xcons.FvarRef(this.getResourceTagId()));
        Ident ident2 = this.env.declExternIdent(COARRAY_EPILOG_NAME, BasicType.FexternalSubroutineType);
        if (((Xobject)xobjList2).hasNullArg()) {
            XMP.fatal("INTERNAL: generated null argument " + ident2 + "(genCallofPrologAndEpilog args2)");
        }
        Xobject xobject2 = ident2.callSubroutine(xobjList2);
        this.addEpilogStmt(xobject2);
    }

    private void genDefinitionOfDescPointer(ArrayList<XMPcoarray> arrayList) {
        for (XMPcoarray xMPcoarray : arrayList) {
            Ident ident = xMPcoarray.getDescPointerId();
            String string = xMPcoarray.getName();
            XobjList xobjList = Xcons.List(ident, xMPcoarray.getIdent(), Xcons.IntConstant(string.length()), Xcons.FcharacterConstant(Xtype.FcharacterType, string, null));
            Ident ident2 = this.env.declExternIdent(FIND_DESCPOINTER_NAME, BasicType.FexternalSubroutineType);
            if (((Xobject)xobjList).hasNullArg()) {
                XMP.fatal("generated null argument xmpf_coarray_find_descptr(genDefinitionOfDescPointer)");
            }
            Xobject xobject = ident2.callSubroutine(xobjList);
            this.addPrologStmt(xobject);
            xMPcoarray.addStmts_setCoshape(this._prologStmts);
            xobject = xMPcoarray.makeStmt_setVarName();
            this.addPrologStmt(xobject);
        }
    }

    private void convCoidxStmtsToSubrCalls(ArrayList<XMPcoarray> arrayList) {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(this.getFblock());
        ((BlockIterator)topdownBlockIterator2).init();
        while (!((BlockIterator)topdownBlockIterator2).end()) {
            BasicBlock basicBlock = topdownBlockIterator2.getBlock().getBasicBlock();
            if (basicBlock != null) {
                for (Statement statement = basicBlock.getHead(); statement != null; statement = statement.getNext()) {
                    Xobject xobject = statement.getExpr();
                    if (xobject == null || !this._isCoindexVarStmt(xobject).booleanValue()) continue;
                    Xobject xobject2 = this.coindexVarStmtToCallStmt(xobject, arrayList);
                    statement.setExpr(xobject2);
                }
            }
            ((BlockIterator)topdownBlockIterator2).next();
        }
    }

    private Boolean _isCoindexVarStmt(Xobject xobject) {
        Xobject xobject2;
        if (xobject.Opcode() == Xcode.F_ASSIGN_STATEMENT && this._isCoindexObj(xobject2 = xobject.getArg(0)).booleanValue()) {
            return true;
        }
        return false;
    }

    private Xobject coindexVarStmtToCallStmt(Xobject xobject, ArrayList<XMPcoarray> arrayList) {
        Xobject xobject2 = xobject.getArg(0);
        Xobject xobject3 = xobject.getArg(1);
        int n = this._getConditionOfCoarrayPut(xobject3);
        XMPcoindexObj xMPcoindexObj = new XMPcoindexObj(xobject2, arrayList);
        return xMPcoindexObj.toCallStmt(xobject3, Xcons.IntConstant(n));
    }

    private int _getConditionOfCoarrayPut(Xobject xobject) {
        switch (xobject.Opcode()) {
            case F_VAR_REF: {
                return 0;
            }
            case F_ARRAY_REF: {
                return 1;
            }
        }
        return 1;
    }

    private void convGETfuncStmtsToSubrCalls(ArrayList<XMPcoarray> arrayList) {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(this.getFblock());
        ((BlockIterator)topdownBlockIterator2).init();
        while (!((BlockIterator)topdownBlockIterator2).end()) {
            BasicBlock basicBlock = topdownBlockIterator2.getBlock().getBasicBlock();
            if (basicBlock != null) {
                for (Statement statement = basicBlock.getHead(); statement != null; statement = statement.getNext()) {
                    Xobject xobject = statement.getExpr();
                    if (xobject == null || !this._hasGETfuncAsRHS(xobject).booleanValue()) continue;
                    Xobject xobject2 = this.convGETfuncStmtToCallStmt(xobject);
                    statement.setExpr(xobject2);
                }
            }
            ((BlockIterator)topdownBlockIterator2).next();
        }
    }

    private Xobject convGETfuncStmtToCallStmt(Xobject xobject) {
        LineNo lineNo = xobject.getLineNo();
        Xobject xobject2 = xobject.getArg(0);
        Xobject xobject3 = xobject.getArg(1);
        Xobject xobject4 = xobject3.getArg(1);
        String string = "xmpf_coarray_getsub_generic";
        xobject4.add(xobject2);
        Ident ident = this.env.findVarIdent(string, null);
        if (ident == null) {
            ident = this.env.declExternIdent(string, Xtype.FexternalSubroutineType);
        }
        Xobject xobject5 = ident.callSubroutine(xobject4);
        xobject5.setLineNo(lineNo);
        return xobject5;
    }

    private Boolean _hasGETfuncAsRHS(Xobject xobject) {
        Xobject xobject2;
        if (xobject.Opcode() == Xcode.F_ASSIGN_STATEMENT && this._isGETfunc(xobject2 = xobject.getArg(1)).booleanValue()) {
            return true;
        }
        return false;
    }

    private Boolean _isGETfunc(Xobject xobject) {
        return XMPcoindexObj.isGETfunc(xobject);
    }

    private void convCoidxObjsToFuncCalls(ArrayList<XMPcoarray> arrayList) {
        while (this._convCoidxObjsToFuncCalls1(arrayList).booleanValue()) {
        }
    }

    private Boolean _convCoidxObjsToFuncCalls1(ArrayList<XMPcoarray> arrayList) {
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(this.def.getFuncBody());
        Boolean bl = false;
        ((XobjectIterator)topdownXobjectIterator2).init();
        while (!((XobjectIterator)topdownXobjectIterator2).end()) {
            Xobject xobject = topdownXobjectIterator2.getXobject();
            if (xobject != null && this._isCoindexObj(xobject).booleanValue() && this._isTargetCoindexObj(xobject).booleanValue()) {
                Xobject xobject2 = this.coindexObjToFuncRef(xobject, arrayList);
                ((XobjectIterator)topdownXobjectIterator2).setXobject(xobject2);
                bl = true;
            }
            ((XobjectIterator)topdownXobjectIterator2).next();
        }
        return bl;
    }

    private Xobject coindexObjToFuncRef(Xobject xobject, ArrayList<XMPcoarray> arrayList) {
        XMPcoindexObj xMPcoindexObj = new XMPcoindexObj(xobject, arrayList);
        return xMPcoindexObj.toFuncRef();
    }

    private Boolean _isCoindexObj(Xobject xobject) {
        if (xobject.Opcode() == null) {
            return false;
        }
        switch (xobject.Opcode()) {
            case CO_ARRAY_REF: {
                return true;
            }
            case MEMBER_REF: {
                Xobject xobject2;
                Xobject xobject3 = xobject.getArg(0);
                if (xobject3.Opcode() != Xcode.F_VAR_REF || !this._isCoindexObj(xobject2 = xobject3.getArg(0)).booleanValue()) break;
                return true;
            }
            case F_ARRAY_REF: {
                Xobject xobject4;
                Xobject xobject5;
                Xobject xobject6;
                Xobject xobject7 = xobject.getArg(0);
                if (xobject7.Opcode() != Xcode.F_VAR_REF || (xobject6 = xobject7.getArg(0)).Opcode() != Xcode.MEMBER_REF || (xobject5 = xobject6.getArg(0)).Opcode() != Xcode.F_VAR_REF || !this._isCoindexObj(xobject4 = xobject5.getArg(0)).booleanValue()) break;
                return true;
            }
        }
        return false;
    }

    private Boolean _isTargetCoindexObj(Xobject xobject) {
        Xobject xobject2 = (Xobject)xobject.getParent();
        switch (xobject2.Opcode()) {
            case F_ASSIGN_STATEMENT: {
                if (xobject2.getArg(0) == xobject) {
                    return false;
                }
                return true;
            }
            case F_VAR_REF: {
                break;
            }
            case F_ARRAY_REF: 
            case CO_ARRAY_REF: 
            case MEMBER_REF: {
                XMP.fatal("found illegal internal form.");
            }
            default: {
                return true;
            }
        }
        Xobject xobject3 = (Xobject)xobject2.getParent();
        if (xobject3.Nargs() != 2 || xobject3.getArg(0) != xobject2) {
            return true;
        }
        switch (xobject3.Opcode()) {
            case CO_ARRAY_REF: {
                XMP.error("found duplicated sets of cosubscript(s)");
                return false;
            }
            case MEMBER_REF: {
                return false;
            }
            case F_ARRAY_REF: {
                return false;
            }
        }
        return true;
    }

    private void genAllocOfStaticCoarrays(ArrayList<XMPcoarray> arrayList) {
        ArrayList<XMPcoarray> arrayList2 = new ArrayList<XMPcoarray>();
        for (XMPcoarray xMPcoarray : arrayList) {
            if (xMPcoarray.wasMovedFromModule().booleanValue()) continue;
            arrayList2.add(xMPcoarray);
        }
        if (arrayList2.isEmpty()) {
            return;
        }
        XMPcoarrayInitProcedure xMPcoarrayInitProcedure = new XMPcoarrayInitProcedure(arrayList2, this.traverseCountName, this.traverseInitName, this.env, this.version);
        xMPcoarrayInitProcedure.run();
    }

    private void readyBlockForStaticCoarrays_regmem(ArrayList<XMPcoarray> arrayList) {
        if (arrayList.size() == 0) {
            return;
        }
        this.addExtraStmt(this.makeStmt_ENTRY(this.traverseInitName));
        for (XMPcoarray xMPcoarray : arrayList) {
            this.addExtraStmt(xMPcoarray.makeStmt_regmemStatic());
            xMPcoarray.addStmts_setCoshape(this._extraStmts, this.env);
        }
        this.addExtraStmt(this.makeStmt_RETURN());
    }

    private void readyBlockForStaticCoarrays_alloc(ArrayList<XMPcoarray> arrayList) {
        if (arrayList.size() == 0) {
            return;
        }
        this.addExtraStmt(this.makeStmt_ENTRY(this.traverseCountName));
        for (XMPcoarray xMPcoarray : arrayList) {
            this.addExtraStmt(xMPcoarray.makeStmt_countCoarrays());
        }
        this.addExtraStmt(this.makeStmt_RETURN());
        this.addExtraStmt(this.makeStmt_ENTRY(this.traverseInitName));
        for (XMPcoarray xMPcoarray : arrayList) {
            this.addExtraStmt(xMPcoarray.makeStmt_allocStatic());
            xMPcoarray.addStmts_setCoshape(this._extraStmts, this.env);
        }
        this.addExtraStmt(this.makeStmt_RETURN());
    }

    private void expandEntryBlockForStaticCoarrays() {
        if (this._extraStmts.size() == 0) {
            return;
        }
        BlockList blockList = this.getFblock().getBody().getHead().getBody();
        if (blockList.getTail().Opcode() != Xcode.RETURN_STATEMENT) {
            blockList.add(this.makeStmt_RETURN());
        }
        for (Xobject xobject : this._extraStmts) {
            blockList.add(xobject);
        }
    }

    private Xobject makeStmt_ENTRY(String string) {
        Ident ident = this.env.declIdent(string, Xtype.FsubroutineType);
        XobjList xobjList = Xcons.List(Xcode.F_ENTRY_DECL, (Xtype)null, Xcons.Symbol(Xcode.IDENT, string));
        return xobjList;
    }

    private Xobject makeStmt_RETURN() {
        XobjList xobjList = Xcons.List(Xcode.RETURN_STATEMENT);
        return xobjList;
    }

    private void genRegmemOfStaticCoarrays(ArrayList<XMPcoarray> arrayList) {
        Xobject xobject;
        XobjList xobjList = Xcons.List();
        for (XMPcoarray object2 : arrayList) {
            if (object2.wasMovedFromModule().booleanValue()) continue;
            xobject = object2.makeStmt_regmemStatic();
            xobjList.add(xobject);
        }
        for (XMPcoarray xMPcoarray : arrayList) {
            xMPcoarray.addStmts_setCoshape(xobjList, this.env);
        }
        if (xobjList.Nargs() == 0) {
            return;
        }
        XMPcoarray xMPcoarray = arrayList.get(0);
        Ident ident = xMPcoarray.getDescPointerId();
        xobject = Xcons.IntConstant(0, Xtype.intType, "8");
        Xobject xobject2 = Xcons.binaryOp(Xcode.LOG_EQ_EXPR, ident, xobject);
        XobjList xobjList2 = Xcons.List(Xcode.F_IF_STATEMENT, (Xtype)null, null, xobject2, xobjList, null);
        this.addPrologStmt(xobjList2);
    }

    private void convAllocateStmts(ArrayList<XMPcoarray> arrayList) {
        BasicBlockIterator basicBlockIterator = new BasicBlockIterator(this.getFblock());
        basicBlockIterator.init();
        while (!basicBlockIterator.end()) {
            StatementIterator statementIterator = basicBlockIterator.getBasicBlock().statements();
            while (statementIterator.hasNext()) {
                Statement statement = (Statement)statementIterator.next();
                Xobject xobject = statement.getExpr();
                if (xobject == null || xobject.Opcode() == null) continue;
                switch (xobject.Opcode()) {
                    case F_ALLOCATE_STATEMENT: {
                        if (!this._listHasCoarray(xobject.getArg(1), arrayList).booleanValue()) break;
                        ArrayList<Xobject> arrayList2 = this.genAllocateStmt(xobject, arrayList);
                        if (!this.useMalloc.booleanValue()) {
                            statement.insert(statement.getExpr());
                        }
                        LineNo lineNo = xobject.getLineNo();
                        for (Xobject xobject2 : arrayList2) {
                            xobject2.setLineNo(lineNo);
                            statement.insert(xobject2);
                        }
                        statement.remove();
                    }
                }
            }
            basicBlockIterator.next();
        }
    }

    private void convDellocateStmts(ArrayList<XMPcoarray> arrayList) {
        BasicBlockIterator basicBlockIterator = new BasicBlockIterator(this.getFblock());
        basicBlockIterator.init();
        while (!basicBlockIterator.end()) {
            StatementIterator statementIterator = basicBlockIterator.getBasicBlock().statements();
            while (statementIterator.hasNext()) {
                Statement statement = (Statement)statementIterator.next();
                Xobject xobject = statement.getExpr();
                if (xobject == null || xobject.Opcode() == null) continue;
                switch (xobject.Opcode()) {
                    case F_DEALLOCATE_STATEMENT: {
                        if (!this._listHasCoarray(xobject.getArg(1), arrayList).booleanValue()) break;
                        ArrayList<Xobject> arrayList2 = this.genDeallocateStmt(xobject, arrayList);
                        LineNo lineNo = xobject.getLineNo();
                        for (Xobject xobject2 : arrayList2) {
                            xobject2.setLineNo(lineNo);
                            statement.insert(xobject2);
                        }
                        if (!this.useMalloc.booleanValue()) break;
                        statement.remove();
                    }
                }
            }
            basicBlockIterator.next();
        }
    }

    private Boolean _listHasCoarray(Xobject xobject, ArrayList<XMPcoarray> arrayList) {
        Boolean bl = true;
        Boolean bl2 = true;
        for (Xobject xobject2 : (XobjList)xobject) {
            Boolean bl3 = false;
            Xobject xobject3 = xobject2.getArg(0);
            block0 : switch (xobject3.Opcode()) {
                case VAR: {
                    String string = xobject2.getArg(0).getString();
                    for (XMPcoarray xMPcoarray : arrayList) {
                        if (!string.equals(xMPcoarray.getName())) continue;
                        bl3 = true;
                        break block0;
                    }
                    break;
                }
                case MEMBER_REF: {
                    break;
                }
                default: {
                    XMP.fatal("internal error: unexpected code of Xobject in ALLOCATE stmt");
                }
            }
            if (bl3.booleanValue() && bl.booleanValue()) {
                bl2 = false;
                continue;
            }
            if (!bl3.booleanValue() && bl2.booleanValue()) {
                bl = false;
                continue;
            }
            XMP.error("current restriction: An ALLOCATE/DEALLOCATE statement cannnot have both coarrays and noncoarrays.");
        }
        return bl;
    }

    private Xobject _getFirstArgOfCall(Xobject xobject) {
        Xobject xobject2 = xobject.getArg(1);
        if (xobject2 == null) {
            return null;
        }
        return xobject2.getArg(0);
    }

    private Boolean _isCoarrayInCoarrays(Xobject xobject, ArrayList<XMPcoarray> arrayList) {
        if (xobject.Opcode() == Xcode.MEMBER_REF) {
            return false;
        }
        return this._findCoarrayInCoarrays(xobject, arrayList) != null;
    }

    private XMPcoarray _findCoarrayInCoarrays(Xobject xobject, ArrayList<XMPcoarray> arrayList) {
        if (xobject == null) {
            return null;
        }
        String string = xobject.getName();
        for (XMPcoarray xMPcoarray : arrayList) {
            if (!string.equals(xMPcoarray.getName())) continue;
            return xMPcoarray;
        }
        return null;
    }

    private Boolean _isIntrinsic(Xobject xobject) {
        Ident ident = this.env.findVarIdent(xobject.getName(), this.getFblock());
        if (ident == null) {
            return true;
        }
        return ident.Type().isFintrinsic();
    }

    private ArrayList<Xobject> genAllocateStmt(Xobject xobject, ArrayList<XMPcoarray> arrayList) {
        ArrayList<Xobject> arrayList2 = new ArrayList<Xobject>();
        for (Xobject xobject2 : (XobjList)xobject.getArg(1)) {
            Xobject xobject3 = xobject2.getArg(0);
            XMPcoarray xMPcoarray = this._findCoarrayInCoarrays(xobject3, arrayList);
            XobjList xobjList = Xcons.List();
            int n = xobject2.getArg(1).Nargs();
            if (xobject2.getArg(1).getArg(n - 1).Opcode() != Xcode.F_CO_SHAPE) {
                XMP.error("lack of coshape in the ALLOCATE stetement");
                return arrayList2;
            }
            int n2 = n - 1;
            XobjList xobjList2 = (XobjList)xobject2.getArg(1).getArg(n2);
            for (int i = 0; i < n2; ++i) {
                xobjList.add(xobject2.getArg(1).getArg(i));
            }
            if (!xMPcoarray.usesMalloc().booleanValue()) {
                xobject2.getArg(1).removeLastArgs();
            }
            arrayList2.add(this.makeStmt_coarrayAlloc(xMPcoarray, xobjList));
            xMPcoarray.addStmts_setCoshape(arrayList2, xobjList2);
            arrayList2.add(xMPcoarray.makeStmt_setVarName());
        }
        return arrayList2;
    }

    private ArrayList<Xobject> genDeallocateStmt(Xobject xobject, ArrayList<XMPcoarray> arrayList) {
        ArrayList<Xobject> arrayList2 = new ArrayList<Xobject>();
        for (Xobject xobject2 : (XobjList)xobject.getArg(1)) {
            Xobject xobject3 = xobject2.getArg(0);
            XMPcoarray xMPcoarray = this._findCoarrayInCoarrays(xobject3, arrayList);
            arrayList2.add(this.makeStmt_coarrayDealloc(xMPcoarray));
        }
        return arrayList2;
    }

    private Xobject makeStmt_coarrayAlloc(XMPcoarray xMPcoarray, XobjList xobjList) {
        Ident ident;
        int n = xMPcoarray.getRank();
        if (n != xobjList.Nargs()) {
            XMP.fatal("Number of dimensions " + n + " does not equal to " + xobjList.Nargs() + ", the rank of coarray " + xMPcoarray.getName());
        }
        Xobject xobject = xMPcoarray.wasMovedFromModule() != false || xMPcoarray.def != this.def || xMPcoarray.usesMalloc() == false ? Xcons.IntConstant(0, Xtype.Fint8Type, "8") : Xcons.FvarRef(this.getResourceTagId());
        Xobject xobject2 = xMPcoarray.getDescPointerId();
        if (xobject2 == null) {
            xobject2 = Xcons.IntConstant(0, Xtype.Fint8Type, "8");
        }
        XobjList xobjList2 = Xcons.List(xobject2, Xcons.FvarRef(xMPcoarray.getIdent()), this._buildCountExpr(xobjList, n), xMPcoarray.getElementLengthExpr_runtime(), xobject, Xcons.IntConstant(n));
        for (int i = 0; i < n; ++i) {
            ((Xobject)xobjList2).add(this._getLboundInIndexRange(xobjList.getArg(i)));
            ((Xobject)xobjList2).add(this._getUboundInIndexRange(xobjList.getArg(i)));
        }
        String string = xMPcoarray.usesMalloc() != false ? COARRAY_MALLOC_NAME : COARRAY_REGMEM_NAME;
        if (((Xobject)xobjList2).hasNullArg()) {
            XMP.fatal("INTERNAL: generated null argument for " + string + "(makeStmt_coarrayAlloc)");
        }
        if ((ident = this.env.findVarIdent(string, null)) == null) {
            ident = this.env.declExternIdent(string, BasicType.FexternalSubroutineType);
        }
        Xobject xobject3 = ident.callSubroutine(xobjList2);
        return xobject3;
    }

    private Xobject makeStmt_coarrayDealloc(XMPcoarray xMPcoarray) {
        Ident ident;
        int n = xMPcoarray.getRank();
        XobjList xobjList = Xcons.List(xMPcoarray.getDescPointerId(), Xcons.FvarRef(xMPcoarray.getIdent()));
        String string = xMPcoarray.usesMalloc() != false ? COARRAY_DEALLOC_NAME : COARRAY_DEREGMEM_NAME;
        if (((Xobject)xobjList).hasNullArg()) {
            XMP.fatal("generated null argument for " + string + "(makeStmt_coarrayDealloc)");
        }
        if ((ident = this.env.findVarIdent(string, null)) == null) {
            ident = this.env.declExternIdent(string, BasicType.FexternalSubroutineType);
        }
        Xobject xobject = ident.callSubroutine(xobjList);
        return xobject;
    }

    private Xobject _buildCountExpr(XobjList xobjList, int n) {
        if (n == 0) {
            return Xcons.IntConstant(1);
        }
        Xobject xobject = this._getExtentInIndexRange(xobjList.getArg(0));
        for (int i = 1; i < n; ++i) {
            xobject = Xcons.binaryOp(Xcode.MUL_EXPR, xobject, this._getExtentInIndexRange(xobjList.getArg(i))).cfold(this.getFblock());
        }
        return xobject;
    }

    private Xobject _getLboundInIndexRange(Xobject xobject) {
        Xobject xobject2;
        if (xobject == null) {
            xobject2 = null;
        } else {
            switch (xobject.Opcode()) {
                case F_INDEX_RANGE: {
                    xobject2 = xobject.getArg(0);
                    break;
                }
                case F_ARRAY_INDEX: {
                    xobject2 = null;
                    break;
                }
                default: {
                    xobject2 = null;
                }
            }
        }
        if (xobject2 == null) {
            return Xcons.IntConstant(1);
        }
        return xobject2.cfold(this.getFblock());
    }

    private Xobject _getUboundInIndexRange(Xobject xobject) {
        Xobject xobject2;
        if (xobject == null) {
            xobject2 = null;
        } else {
            switch (xobject.Opcode()) {
                case F_INDEX_RANGE: {
                    xobject2 = xobject.getArg(1);
                    break;
                }
                case F_ARRAY_INDEX: {
                    xobject2 = xobject.getArg(0);
                    break;
                }
                default: {
                    xobject2 = xobject;
                }
            }
        }
        if (xobject2 == null) {
            XMP.fatal("illegal upper bound specified in ALLOCATE statement");
        }
        return xobject2.cfold(this.getFblock());
    }

    private Xobject _getExtentInIndexRange(Xobject xobject) {
        Xobject xobject2;
        if (xobject == null) {
            xobject2 = null;
        } else {
            switch (xobject.Opcode()) {
                case F_INDEX_RANGE: {
                    Xobject xobject3 = xobject.getArg(0);
                    Xobject xobject4 = xobject.getArg(1);
                    if (xobject4 == null) {
                        xobject2 = null;
                        break;
                    }
                    if (xobject3 == null) {
                        xobject2 = xobject4;
                        break;
                    }
                    Xobject xobject5 = Xcons.binaryOp(Xcode.MINUS_EXPR, xobject4, xobject3);
                    xobject2 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject5, Xcons.IntConstant(1));
                    break;
                }
                case F_ARRAY_INDEX: {
                    xobject2 = xobject.getArg(0);
                    break;
                }
                default: {
                    xobject2 = xobject;
                }
            }
        }
        if (xobject2 == null) {
            XMP.fatal("illegal extent of a dimension specified in ALLOCATE statement");
        }
        return xobject2.cfold(this.getFblock());
    }

    private void removeCodimensions(ArrayList<XMPcoarray> arrayList) {
        for (XMPcoarray xMPcoarray : arrayList) {
            xMPcoarray.hideCodimensions();
        }
    }

    private void removeSaveAttr(ArrayList<XMPcoarray> arrayList) {
        for (XMPcoarray xMPcoarray : arrayList) {
            xMPcoarray.resetSaveAttr();
        }
    }

    private void addSaveAttr(ArrayList<XMPcoarray> arrayList) {
        if (this.def.isFmoduleDef()) {
            return;
        }
        Xtype xtype = this.def.getFuncType();
        if (xtype != null && xtype.isFprogram()) {
            return;
        }
        for (XMPcoarray xMPcoarray : arrayList) {
            xMPcoarray.setSaveAttr();
        }
    }

    private void replaceAllocatableWithPointer(ArrayList<XMPcoarray> arrayList) {
        for (XMPcoarray xMPcoarray : arrayList) {
            if (!xMPcoarray.usesMalloc().booleanValue()) continue;
            xMPcoarray.resetAllocatable();
            xMPcoarray.setPointer();
        }
    }

    private void replaceIntrinsicCalls1(ArrayList<XMPcoarray> arrayList) {
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(this.def.getFuncBody());
        ((XobjectIterator)topdownXobjectIterator2).init();
        while (!((XobjectIterator)topdownXobjectIterator2).end()) {
            Xobject xobject = topdownXobjectIterator2.getXobject();
            if (xobject != null && xobject.Opcode() == Xcode.FUNCTION_CALL && xobject.getArg(0).Opcode() != Xcode.MEMBER_REF) {
                String string = xobject.getArg(0).getString();
                if (string.equalsIgnoreCase("num_images")) {
                    this._replaceNumImages(xobject, arrayList);
                } else if (string.equalsIgnoreCase("this_image")) {
                    this._replaceThisImage(xobject, arrayList);
                } else if (string.equalsIgnoreCase("image_index")) {
                    this._replaceImageIndex(xobject, arrayList);
                } else if (string.equalsIgnoreCase("lcobound")) {
                    this._replaceCobound(xobject, arrayList, 0);
                } else if (string.equalsIgnoreCase("ucobound")) {
                    this._replaceCobound(xobject, arrayList, 1);
                } else if (string.equalsIgnoreCase("co_broadcast")) {
                    this._replaceCoBroadcast(xobject, string, CO_BROADCAST_NAME);
                } else if (string.equalsIgnoreCase("co_sum")) {
                    this._replaceCoReduction(xobject, string, CO_SUM_NAME);
                } else if (string.equalsIgnoreCase("co_max")) {
                    this._replaceCoReduction(xobject, string, CO_MAX_NAME);
                } else if (string.equalsIgnoreCase("co_min")) {
                    this._replaceCoReduction(xobject, string, CO_MIN_NAME);
                } else if (string.equalsIgnoreCase("atomic_define")) {
                    this._replaceAtomicDefine(xobject, arrayList);
                } else if (string.equalsIgnoreCase("atomic_ref")) {
                    this._replaceAtomicRef(xobject, arrayList);
                }
            }
            ((XobjectIterator)topdownXobjectIterator2).next();
        }
    }

    private void replaceIntrinsicCalls2(ArrayList<XMPcoarray> arrayList) {
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(this.def.getFuncBody());
        ((XobjectIterator)topdownXobjectIterator2).init();
        while (!((XobjectIterator)topdownXobjectIterator2).end()) {
            String string;
            Xobject xobject = topdownXobjectIterator2.getXobject();
            if (xobject != null && xobject.Opcode() == Xcode.FUNCTION_CALL && xobject.getArg(0).Opcode() != Xcode.MEMBER_REF && (string = xobject.getArg(0).getString()).equalsIgnoreCase("allocated")) {
                this._replaceAllocatedWithAssociated(xobject, arrayList);
            }
            ((XobjectIterator)topdownXobjectIterator2).next();
        }
    }

    private void _removeCoarrayIntrinsicIdents(XobjArgs xobjArgs, XobjArgs xobjArgs2) {
        if (xobjArgs2 == null) {
            return;
        }
        XobjArgs xobjArgs3 = xobjArgs2.nextArgs();
        Ident ident = (Ident)xobjArgs2.getArg();
        String string = ident.getName();
        if (XMPtransCoarrayRun.isCoarrayIntrinsicName(string).booleanValue()) {
            xobjArgs.setNext(xobjArgs3);
            xobjArgs2 = xobjArgs;
        }
        this._removeCoarrayIntrinsicIdents(xobjArgs2, xobjArgs3);
    }

    private void _replaceCoReduction(Xobject xobject, String string, String string2) {
        int n;
        XobjList xobjList = (XobjList)xobject.getArg(1);
        int n2 = n = xobjList == null ? 0 : xobjList.Nargs();
        if (n < 1 || n > 3) {
            XMP.error("Too few or too many arguments are found in " + string);
            return;
        }
        Xobject xobject2 = xobjList.getArgWithKeyword("source", 0);
        Xobject xobject3 = xobjList.getArgWithKeyword("result", 1);
        Xobject xobject4 = xobjList.getArgWithKeyword("result_image", 2);
        if (xobject2 == null) {
            XMP.error("The first argument 'source' was not found in " + string);
            return;
        }
        XobjList xobjList2 = Xcons.List(xobject2);
        if (xobject3 != null) {
            ((Xobject)xobjList2).add(xobject3);
        }
        if (xobject4 != null) {
            ((Xobject)xobjList2).add(this._buildKeywordArg("result_image", this._convInt4(xobject4)));
        }
        xobject.setArg(1, xobjList2);
        XobjString xobjString = Xcons.Symbol(Xcode.IDENT, string2);
        xobject.setArg(0, xobjString);
    }

    private void _replaceCoBroadcast(Xobject xobject, String string, String string2) {
        int n;
        XobjList xobjList = (XobjList)xobject.getArg(1);
        int n2 = n = xobjList == null ? 0 : xobjList.Nargs();
        if (n != 2) {
            XMP.error("Too few or too many arguments are found in " + string);
            return;
        }
        Xobject xobject2 = xobjList.getArgWithKeyword("source", 0);
        if (xobject2 == null) {
            XMP.error("The first argument 'source' was not found in " + string);
            return;
        }
        Xobject xobject3 = xobjList.getArgWithKeyword("source_image", 1);
        if (xobject3 == null) {
            XMP.error("The second argument 'source_image' was not found in " + string);
            return;
        }
        XobjList xobjList2 = Xcons.List(xobject2, this._convInt4(xobject3));
        xobject.setArg(1, xobjList2);
        XobjString xobjString = Xcons.Symbol(Xcode.IDENT, string2);
        xobject.setArg(0, xobjString);
    }

    private void _replaceAtomicRef(Xobject xobject, ArrayList<XMPcoarray> arrayList) {
        String string;
        int n;
        XobjList xobjList = (XobjList)xobject.getArg(1);
        int n2 = n = xobjList == null ? 0 : xobjList.Nargs();
        if (n != 2) {
            XMP.error("Too few or too many arguments found in the call of atomic_ref");
            return;
        }
        Xobject xobject2 = xobjList.getArgWithKeyword("value", 0);
        if (xobject2 == null) {
            XMP.error("Argument 'value' not found in atomic_ref");
            return;
        }
        Xobject xobject3 = xobjList.getArgWithKeyword("atomic", 1);
        if (xobject3 == null) {
            XMP.error("Argument 'atomic' not found in atomic_ref");
            return;
        }
        XobjString xobjString = Xcons.Symbol(Xcode.IDENT, ATOMIC_REF_NAME);
        xobject.setArg(0, xobjString);
        try {
            string = xobject3.getName();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            XMP.error("Illegal argument #2 in the call of atomic_ref");
            return;
        }
        XMPcoarray xMPcoarray = XMPcoarray.findCoarrayInCoarrays(string, arrayList);
        if (xMPcoarray == null) {
            XMP.error("Argument #2 of atomic_ref must be a coarray or a coindexed object.");
            return;
        }
        switch (xobject3.Opcode()) {
            case VAR: 
            case F_ARRAY_REF: {
                Xobject xobject4 = xMPcoarray.getDescPointerIdExpr(xobject3);
                Xobject xobject5 = xobject3;
                Xobject xobject6 = xobject2;
                xobject.setArg(1, Xcons.List(xobject4, xobject5, xobject6));
                break;
            }
            case CO_ARRAY_REF: {
                XMPcoindexObj xMPcoindexObj = new XMPcoindexObj(xobject3, xMPcoarray);
                Xobject xobject7 = xMPcoindexObj.getBaseAddr();
                Xobject xobject8 = xMPcoarray.getDescPointerIdExpr(xobject7);
                Xobject xobject9 = xMPcoarray.getImageIndex(xobject7, xMPcoindexObj.cosubscripts);
                Xobject xobject10 = xMPcoindexObj.removeCoindex();
                Xobject xobject11 = xobject2;
                xobject.setArg(1, Xcons.List(xobject8, xobject9, xobject10, xobject11));
            }
        }
    }

    private void _replaceAtomicDefine(Xobject xobject, ArrayList<XMPcoarray> arrayList) {
        String string;
        int n;
        XobjList xobjList = (XobjList)xobject.getArg(1);
        int n2 = n = xobjList == null ? 0 : xobjList.Nargs();
        if (n != 2) {
            XMP.error("Too few or too many arguments found in the call of atomic_define");
            return;
        }
        Xobject xobject2 = xobjList.getArgWithKeyword("atomic", 0);
        if (xobject2 == null) {
            XMP.error("Argument 'atomic' not found in atomic_define");
            return;
        }
        Xobject xobject3 = xobjList.getArgWithKeyword("value", 1);
        if (xobject3 == null) {
            XMP.error("Argument 'value' not found in atomic_define");
            return;
        }
        XobjString xobjString = Xcons.Symbol(Xcode.IDENT, ATOMIC_DEFINE_NAME);
        xobject.setArg(0, xobjString);
        try {
            string = xobject2.getName();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            XMP.error("Illegal argument #1 in the call of atomic_define");
            return;
        }
        XMPcoarray xMPcoarray = XMPcoarray.findCoarrayInCoarrays(string, arrayList);
        if (xMPcoarray == null) {
            XMP.error("Argument #1 of atomic_define must be a coarray or a coindexed object.");
            return;
        }
        switch (xobject2.Opcode()) {
            case VAR: 
            case F_ARRAY_REF: {
                Xobject xobject4 = xMPcoarray.getDescPointerIdExpr(xobject2);
                Xobject xobject5 = xobject2;
                Xobject xobject6 = xobject3;
                xobject.setArg(1, Xcons.List(xobject4, xobject5, xobject6));
                break;
            }
            case CO_ARRAY_REF: {
                XMPcoindexObj xMPcoindexObj = new XMPcoindexObj(xobject2, xMPcoarray);
                Xobject xobject7 = xMPcoindexObj.getBaseAddr();
                Xobject xobject8 = xMPcoarray.getDescPointerIdExpr(xobject7);
                Xobject xobject9 = xMPcoarray.getImageIndex(xobject7, xMPcoindexObj.cosubscripts);
                Xobject xobject10 = xMPcoindexObj.removeCoindex();
                Xobject xobject11 = xobject3;
                xobject.setArg(1, Xcons.List(xobject8, xobject9, xobject10, xobject11));
            }
        }
    }

    private void _replaceAllocatedWithAssociated(Xobject xobject, ArrayList<XMPcoarray> arrayList) {
        XMPcoarray xMPcoarray;
        Xobject xobject2 = xobject.getArg(0);
        XobjList xobjList = (XobjList)xobject.getArg(1);
        Xobject xobject3 = xobjList.getArg(0);
        if (this._isIntrinsic(xobject2).booleanValue() && this._isCoarrayInCoarrays(xobject3, arrayList).booleanValue() && (xMPcoarray = this._findCoarrayInCoarrays(xobject3, arrayList)).usesMalloc().booleanValue()) {
            XobjString xobjString = Xcons.Symbol(Xcode.IDENT, "associated");
            xobject.setArg(0, xobjString);
        }
    }

    private void _replaceNumImages(Xobject xobject, ArrayList<XMPcoarray> arrayList) {
        int n;
        Xobject xobject2 = xobject.getArg(0);
        XobjList xobjList = (XobjList)xobject.getArg(1);
        int n2 = n = xobjList == null ? 0 : xobjList.Nargs();
        if (n > 0) {
            XMP.error("No arguments are expected in num_images().");
            return;
        }
        if (!"num_images".equals("NUM_IMAGES_NAME")) {
            XobjString xobjString = Xcons.Symbol(Xcode.IDENT, NUM_IMAGES_NAME);
            xobject.setArg(0, xobjString);
        }
    }

    private void _replaceThisImage(Xobject xobject, ArrayList<XMPcoarray> arrayList) {
        Xobject xobject2;
        int n;
        Xobject xobject3 = xobject.getArg(0);
        XobjList xobjList = (XobjList)xobject.getArg(1);
        int n2 = n = xobjList == null ? 0 : xobjList.Nargs();
        if (n > 2) {
            XMP.error("Too many arguments was found in this_image().");
            return;
        }
        if (!"this_image".equals("THIS_IMAGE_NAME")) {
            xobject2 = Xcons.Symbol(Xcode.IDENT, THIS_IMAGE_NAME);
            xobject.setArg(0, xobject2);
        }
        if (n == 0) {
            return;
        }
        xobject2 = xobjList.getArgWithKeyword("coarray", 0);
        if (xobject2 == null) {
            XMP.error("Argument coarray was not found in this_image().");
            return;
        }
        XMPcoarray xMPcoarray = this._findCoarrayInCoarrays(xobject2, arrayList);
        if (xMPcoarray == null) {
            XMP.error("The argument must be a coarray in this_image().");
            return;
        }
        Ident ident = xMPcoarray.getDescPointerId();
        XobjInt xobjInt = Xcons.IntConstant(xMPcoarray.getCorank());
        XobjList xobjList2 = Xcons.List(ident, xobjInt);
        if (n == 2) {
            Xobject xobject4 = xobjList.getArgWithKeyword("dim", 1);
            if (xobject4 == null) {
                XMP.error("The second argument is illegal in this_image().");
                return;
            }
            ((Xobject)xobjList2).add(xobject4);
        }
        xobject.setArg(1, xobjList2);
    }

    private void _replaceCobound(Xobject xobject, ArrayList<XMPcoarray> arrayList, int n) {
        int n2;
        Xobject xobject2 = xobject.getArg(0);
        XobjList xobjList = (XobjList)xobject.getArg(1);
        int n3 = n2 = xobjList == null ? 0 : xobjList.Nargs();
        if (n2 <= 0) {
            XMP.error("Too few arguments was found in lcobound/ucobound.");
            return;
        }
        if (n2 > 3) {
            XMP.error("Too many arguments was found in lcobound/ucobound.");
            return;
        }
        Xobject xobject3 = xobjList.getArgWithKeyword("coarray", 0);
        if (xobject3 == null) {
            XMP.error("Argument coarray was not found in lcobound/ucobound.");
            return;
        }
        XMPcoarray xMPcoarray = this._findCoarrayInCoarrays(xobject3, arrayList);
        if (xMPcoarray == null) {
            XMP.error("The first argument must be a coarray in this_.");
            return;
        }
        Xobject xobject4 = xobjList.getArgWithKeyword("dim", 1);
        Xobject xobject5 = xobjList.getArgWithKeyword("kind", 2);
        if (xobject5 == null) {
            xobject5 = Xcons.IntConstant(4);
        }
        Ident ident = xMPcoarray.getDescPointerId();
        XobjInt xobjInt = Xcons.IntConstant(n);
        XobjInt xobjInt2 = Xcons.IntConstant(xMPcoarray.getCorank());
        XobjString xobjString = Xcons.Symbol(Xcode.IDENT, COBOUND_NAME);
        XobjList xobjList2 = xobject4 != null ? Xcons.List(ident, xobject4, xobject5, xobjInt, xobjInt2) : Xcons.List(ident, xobject5, xobjInt, xobjInt2);
        xobject.setArg(0, xobjString);
        xobject.setArg(1, xobjList2);
    }

    private void _replaceImageIndex(Xobject xobject, ArrayList<XMPcoarray> arrayList) {
        int n;
        Xobject xobject2 = xobject.getArg(0);
        XobjList xobjList = (XobjList)xobject.getArg(1);
        int n2 = n = xobjList == null ? 0 : xobjList.Nargs();
        if (n != 2) {
            XMP.error("Too few or too many arguments of image_index was found.");
            return;
        }
        Xobject xobject3 = xobjList.getArgWithKeyword("coarray", 0);
        if (xobject3 == null) {
            XMP.error("Argument 'coarray' was not found in the reference of 'image_index'.");
            return;
        }
        XMPcoarray xMPcoarray = this._findCoarrayInCoarrays(xobject3, arrayList);
        if (xMPcoarray == null) {
            XMP.error("The argument of 'image_index' must be a coarray.");
            return;
        }
        Xobject xobject4 = xobjList.getArgWithKeyword("sub", 1);
        if (xobject4 == null) {
            XMP.error("Argument 'sub' was not found in the reference of 'image_index'.");
            return;
        }
        XobjString xobjString = Xcons.Symbol(Xcode.IDENT, IMAGE_INDEX_NAME);
        xobject.setArg(0, xobjString);
        Ident ident = xMPcoarray.getDescPointerId();
        XobjList xobjList2 = Xcons.List(ident, xobject4);
        xobject.setArg(1, xobjList2);
    }

    private void removeDeclOfCoarrays(ArrayList<XMPcoarray> arrayList) {
        for (XMPcoarray xMPcoarray : arrayList) {
            this.removeDeclOfCoarray(xMPcoarray);
        }
    }

    private void removeDeclOfCoarray(XMPcoarray xMPcoarray) {
        this.env.removeIdent(xMPcoarray.getCrayPointerName(), null);
        this.env.removeIdent(xMPcoarray.getDescPointerName(), null);
        this.env.removeIdent(xMPcoarray.getName(), null);
    }

    private void removeDeclOfIntrinsicNames() {
        for (String string : intrinsicProcedureNames) {
            this.env.removeIdent(string, null);
        }
    }

    private String _genNewProcPostfix() {
        return this._genNewProcPostfix(this._getHostNames());
    }

    private String _genNewProcPostfix(String ... stringArray) {
        int n = stringArray.length;
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "_";
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], "_");
            int n2 = stringTokenizer.countTokens() - 1;
            if (n2 > 0) {
                string = string + String.valueOf(n2);
            }
            string = string + stringArray[i];
        }
        return string;
    }

    private String[] _getHostNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.def.getName();
        if (string != null) {
            arrayList.add(string);
        }
        for (XobjectDef xobjectDef = this.def.getParent(); xobjectDef != null; xobjectDef = xobjectDef.getParent()) {
            arrayList.add(xobjectDef.getName());
        }
        int n = arrayList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)arrayList.get(n - i - 1);
        }
        return stringArray;
    }

    private void _check_ifIncludeXmpLib() {
        if (!(this._isCoarrayReferred() || this._isCoarrayIntrinsicUsed() || this._isCoarrayStatementUsed())) {
            return;
        }
        Ident ident = this.def.findIdent(IMAGE_INDEX_NAME);
        if (ident == null) {
            XMP.error("current restriction: 'xmp_coarray.h' must be included to use any coarray features in the procodrure/module: " + this.getName());
        }
    }

    private boolean _isCoarrayReferred() {
        return !this.localCoarrays.isEmpty();
    }

    public static Boolean isCoarrayIntrinsicName(String string) {
        return _coarrayIntrinsicList.contains(string);
    }

    private boolean _isCoarrayIntrinsicUsed() {
        XobjList xobjList = this.def.getDef().getIdentList();
        for (Xobject xobject : xobjList) {
            Ident ident = (Ident)xobject;
            if (!XMPtransCoarrayRun.isCoarrayIntrinsicName(ident.getName()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean _isCoarrayStatementUsed() {
        XobjList xobjList = this.def.getDef().getIdentList();
        for (Xobject xobject : xobjList) {
            Ident ident = (Ident)xobject;
            if (!_coarrayStmtKeywordList.contains(ident.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isMainProgram() {
        Xtype xtype = this.def.getFuncType();
        return xtype != null && xtype.isFprogram();
    }

    private boolean isModule() {
        return this.def.isFmoduleDef();
    }

    private boolean isFunction() {
        return this.def.isFuncDef();
    }

    private boolean isBlockData() {
        return this.def.isBlockData();
    }

    private String getName() {
        return this.name;
    }

    public static void analyzeImageDirective(Xobject xobject, XMPenv xMPenv, PragmaBlock pragmaBlock) {
        String string = xobject.getArg(0).getString();
        Block block = pragmaBlock.getNext();
        while (XMPtransCoarrayRun._isSkippableBlockForImageDir(block).booleanValue()) {
            block = block.getNext();
        }
        if (block == null || !XMPtransCoarrayRun._isTargetStmtOfImageDir(block)) {
            XMP.errorAt(pragmaBlock, "Illegal use of IMAGE directive");
            return;
        }
    }

    private static Boolean _isSkippableBlockForImageDir(Block block) {
        return false;
    }

    private static boolean _isTargetStmtOfImageDir(Block block) {
        String[] stringArray = new String[]{SYNCALL_NAME, SYNCIMAGES_NAME, "xmpf_co_", "xmpf_critical"};
        BasicBlock basicBlock = block.getBasicBlock();
        if (basicBlock == null) {
            return false;
        }
        Statement statement = basicBlock.getHead();
        if (statement == null) {
            return false;
        }
        Xobject xobject = statement.getExpr();
        Xcode xcode = xobject.Opcode();
        if (xcode != Xcode.EXPR_STATEMENT) {
            return false;
        }
        Xobject xobject2 = xobject.getArg(0);
        Xcode xcode2 = xobject2.Opcode();
        if (xcode2 != Xcode.FUNCTION_CALL) {
            return false;
        }
        String string = xobject2.getArg(0).getName();
        for (String string2 : stringArray) {
            if (!string.startsWith(string2)) continue;
            return !string.equals(AUTO_SYNCALL_NAME);
        }
        return false;
    }

    public static Block translateImageDirective(PragmaBlock pragmaBlock, XMPinfo xMPinfo) {
        Block block = Bcons.emptyBlock();
        BasicBlock basicBlock = block.getBasicBlock();
        String string = pragmaBlock.getClauses().getArg(0).getName();
        Xobject xobject = XMPcoarray.makeStmt_setImageNodes(string, xMPinfo.env, pragmaBlock.findParentBlockStmt());
        basicBlock.add(xobject);
        return block;
    }

    private Xobject _convInt4(Xobject xobject) {
        Xobject xobject2;
        if (xobject.Type().isBasic() && xobject.Type().getBasicType() == 7) {
            if (xobject.isIntConstant() && "4".equals(((XobjConst)xobject).getFkind())) {
                return xobject;
            }
            try {
                xobject2 = xobject.Type().getFkind();
                if (xobject2 != null && xobject2.getInt() == 4) {
                    return xobject;
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        xobject2 = this.declIntIntrinsicIdent("int");
        XobjList xobjList = Xcons.List(xobject, Xcons.IntConstant(4));
        return ((Ident)xobject2).Call(xobjList);
    }

    private Xobject _buildKeywordArg(String string, Xobject xobject) {
        XobjList xobjList = Xcons.List(Xcode.F_NAMED_VALUE, Xcons.String(string), xobject);
        return xobjList;
    }

    public String toString() {
        String string = "\n  int version = " + this.version + "\n  XMPenv env = " + this.env + "\n  String name = " + this.name + "\n  XobjectDef def = " + this.def + "\n  FuncDefBlock funcDef = \n  ArrayList<XMPcoarray> localCoarrays = " + this._coarrayNames(this.localCoarrays) + "\n    ArrayList<XMPcoarray> staticLocalCoarrays = " + this._coarrayNames(this.staticLocalCoarrays) + "\n    ArrayList<XMPcoarray> allocatableLocalCoarrays = " + this._coarrayNames(this.allocatableLocalCoarrays) + "\n    ArrayList<XMPcoarray> staticDummyCoarrays = " + this._coarrayNames(this.staticDummyCoarrays) + "\n    ArrayList<XMPcoarray> allocatableDummyCoarrays = " + this._coarrayNames(this.allocatableDummyCoarrays) + "\n    ArrayList<XMPcoarray> moduleCoarrays = " + this._coarrayNames(this.moduleCoarrays) + "\n    ArrayList<XMPcoarray> staticModuleCoarrays = " + this._coarrayNames(this.staticModuleCoarrays) + "\n    ArrayList<XMPcoarray> allocatableModuleCoarrays = " + this._coarrayNames(this.allocatableModuleCoarrays) + "\n  String hostModuleName = " + this.hostModuleName + "\n  String hostProcedureName = " + this.hostProcedureName + "\n  XMPtransCoarrayRun hostModuleRun = " + this.hostModuleRun + "\n  XMPtransCoarrayRun hostProcedureRun = " + this.hostProcedureRun + "\n  ArrayList<XMPcoarray> visibleCoarrays = " + this._coarrayNames(this.visibleCoarrays) + "\n  String traverseCountName = " + this.traverseCountName + "\n  String traverseInitName = " + this.traverseInitName + "\n  Ident _resourceTagId = " + this._resourceTagId + "\n  ArrayList<Xobject> _prologStmts = " + this._prologStmts + "\n  ArrayList<Xobject> _epilogStmts = " + this._epilogStmts + "\n  ArrayList<Xobject> _extraStmts = " + this._extraStmts + "\n  Boolean _autoDealloc = " + this._autoDealloc;
        return string;
    }

    private String _coarrayNames(ArrayList<XMPcoarray> arrayList) {
        String string = "[";
        String string2 = "";
        for (XMPcoarray xMPcoarray : arrayList) {
            string = string + string2 + xMPcoarray.getName();
            string2 = ",";
        }
        return string + "]";
    }

    private Ident getResourceTagId() {
        if (this._resourceTagId == null) {
            BlockList blockList = this.getFblock().getBody();
            this._resourceTagId = blockList.declLocalIdent(VAR_TAG_NAME, BasicType.Fint8Type, StorageClass.FLOCAL, null);
        }
        this.set_autoDealloc(true);
        return this._resourceTagId;
    }

    private Ident declIntIntrinsicIdent(String string) {
        FunctionType functionType = new FunctionType(Xtype.FintType, 524288L);
        Ident ident = this.env.declIntrinsicIdent(string, functionType);
        return ident;
    }

    private Ident declInt8IntrinsicIdent(String string) {
        FunctionType functionType = new FunctionType(Xtype.Fint8Type, 524288L);
        Ident ident = this.env.declIntrinsicIdent(string, functionType);
        return ident;
    }

    private void addPrologStmt(Xobject xobject) {
        this._prologStmts.add(xobject);
    }

    private void insertPrologStmt(Xobject xobject) {
        this._prologStmts.add(0, xobject);
    }

    private void addEpilogStmt(Xobject xobject) {
        this._epilogStmts.add(xobject);
    }

    private void insertEpilogStmt(Xobject xobject) {
        this._epilogStmts.add(0, xobject);
    }

    private void addExtraStmt(Xobject xobject) {
        this._extraStmts.add(xobject);
    }

    private void insertExtraStmt(Xobject xobject) {
        this._extraStmts.add(0, xobject);
    }

    private Boolean get_autoDealloc() {
        return this._autoDealloc;
    }

    private void set_autoDealloc(Boolean bl) {
        this._autoDealloc = bl;
    }

    private FunctionBlock getFblock() {
        return this.funcDef.getBlock();
    }

    private static int get_gen_id() {
        return gen_id++;
    }

    static {
        ancestors = new ArrayList();
    }
}

