/*
 * Decompiled with CFR 0.152.
 */
package exc.xmpF;

import exc.object.Ident;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectDefVisitor;
import exc.object.XobjectFile;
import exc.object.XobjectIterator;
import exc.object.topdownXobjectIterator;
import exc.xmpF.XMP;
import exc.xmpF.XMPenv;
import exc.xmpF.XMPtransCoarrayRun;
import java.util.ArrayList;

public class XMPtransCoarray
implements XobjectDefVisitor {
    XMPenv env;
    private int pass;
    private int version = 3;
    private Boolean useMalloc = true;
    private int optLevel = 0;
    private Boolean onlyCafMode;
    private ArrayList<XMPtransCoarrayRun> pastRuns;
    int _nCoarrays = 0;
    int _nCoidxObjs = 0;
    int _nCoarrayLibs = 0;

    public XMPtransCoarray(XobjectFile xobjectFile, int n, String string, Boolean bl) {
        this.env = new XMPenv(xobjectFile);
        this.pass = n;
        this._set_version(string);
        this.onlyCafMode = bl;
        this.pastRuns = new ArrayList();
    }

    public void finish() {
        this.env.finalizeEnv();
    }

    private void _set_version(String string) {
        if (string == null || "".equals(string)) {
            return;
        }
        for (String string2 : string.split(",", 0)) {
            if ("-O0".equalsIgnoreCase(string2)) {
                this.optLevel = 0;
                continue;
            }
            if ("-O1".equalsIgnoreCase(string2)) {
                this.optLevel = 1;
                continue;
            }
            if ("RA".equalsIgnoreCase(string2)) {
                this.version = 3;
                this.useMalloc = true;
                continue;
            }
            if ("CA".equalsIgnoreCase(string2)) {
                this.version = 4;
                this.useMalloc = false;
                continue;
            }
            if ("3".equals(string2)) {
                this.version = 3;
                this.useMalloc = true;
                continue;
            }
            if ("4".equals(string2)) {
                this.version = 4;
                this.useMalloc = false;
                continue;
            }
            if ("6".equals(string2)) {
                this.version = 6;
                this.useMalloc = false;
                continue;
            }
            if ("7".equals(string2)) {
                this.version = 7;
                this.useMalloc = false;
                continue;
            }
            if ("7g".equals(string2)) {
                this.version = 7;
                this.useMalloc = true;
                continue;
            }
            XMP.fatal("found illegal suboption of coarray. \n  Usage: -fcoarray={{RA|CA}|{-O0|-O1}|{3|4|6|7|7g}},...\n  Default: RA,-O0 and 3");
        }
    }

    @Override
    public void doDef(XobjectDef xobjectDef) {
        boolean bl = xobjectDef.isFmoduleDef();
        XMP.resetError();
        switch (this.pass) {
            case 0: {
                if (bl) {
                    this.errorCheck_module(xobjectDef);
                    break;
                }
                this.errorCheck_procedure(xobjectDef);
                break;
            }
            case 1: {
                XMPtransCoarrayRun xMPtransCoarrayRun = new XMPtransCoarrayRun(xobjectDef, this.env, this.pastRuns, 1, this.version, this.useMalloc, this.onlyCafMode, this.optLevel);
                xMPtransCoarrayRun.run1();
                this.pastRuns.add(xMPtransCoarrayRun);
                break;
            }
            case 2: {
                if (!bl) {
                    return;
                }
                XMPtransCoarrayRun xMPtransCoarrayRun = new XMPtransCoarrayRun(xobjectDef, this.env, this.pastRuns, 2, this.version, this.useMalloc, this.onlyCafMode, this.optLevel);
                xMPtransCoarrayRun.run2();
                break;
            }
            case 3: {
                XMPtransCoarrayRun xMPtransCoarrayRun = new XMPtransCoarrayRun(xobjectDef, this.env, null, 3, this.version, this.useMalloc, this.onlyCafMode, this.optLevel);
                xMPtransCoarrayRun.run3();
                break;
            }
            case 4: {
                XMPtransCoarrayRun xMPtransCoarrayRun = new XMPtransCoarrayRun(xobjectDef, this.env, null, 4, this.version, this.useMalloc, this.onlyCafMode, this.optLevel);
                xMPtransCoarrayRun.run4();
                break;
            }
            default: {
                return;
            }
        }
        if (XMP.hasError()) {
            return;
        }
    }

    private void errorCheck_module(XobjectDef xobjectDef) {
        Xobject xobject = xobjectDef.getFuncIdList();
        for (Xobject xobject2 : (XobjList)xobject) {
            Ident ident = (Ident)xobject2;
            if (!ident.isCoarray()) continue;
            ++this._nCoarrays;
            this.errorCheck_ident(ident, xobjectDef);
        }
    }

    private void errorCheck_procedure(XobjectDef xobjectDef) {
        Xobject xobject = xobjectDef.getFuncIdList();
        for (Xobject xobject2 : (XobjList)xobject) {
            Ident ident = (Ident)xobject2;
            if (!ident.isCoarray()) continue;
            ++this._nCoarrays;
            this.errorCheck_ident(ident, xobjectDef);
        }
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobjectDef.getFuncBody());
        ((XobjectIterator)topdownXobjectIterator2).init();
        while (!((XobjectIterator)topdownXobjectIterator2).end()) {
            Xobject xobject2;
            xobject2 = topdownXobjectIterator2.getXobject();
            if (xobject2 != null) {
                switch (xobject2.Opcode()) {
                    case CO_ARRAY_REF: {
                        ++this._nCoidxObjs;
                        this.errorCheck_coidxObj(xobject2, xobjectDef);
                        break;
                    }
                    case IDENT: {
                        if (!this.isCoarrayIntrinsicName(xobject2.getName())) break;
                        ++this._nCoarrayLibs;
                    }
                }
            }
            ((XobjectIterator)topdownXobjectIterator2).next();
        }
    }

    private void errorCheck_ident(Ident ident, XobjectDef xobjectDef) {
        if (this._isRecursiveProcedure(xobjectDef) && ident.getStorageClass() != StorageClass.FSAVE && !ident.Type().isFallocatable()) {
            XMP.error("Coarray '" + ident.getName() + "' must have SAVE or ALLOCATABLE attribute in recursive procedure.");
        }
    }

    private boolean _isRecursiveProcedure(XobjectDef xobjectDef) {
        Xobject xobject = xobjectDef.getDef();
        if (xobject.Opcode() == Xcode.F_MODULE_DEFINITION) {
            return false;
        }
        Xobject xobject2 = xobject.getArgs().getArg();
        return xobject2.Type().isFrecursive();
    }

    private void errorCheck_coidxObj(Xobject xobject, XobjectDef xobjectDef) {
    }

    private boolean isCoarrayIntrinsicName(String string) {
        return XMPtransCoarrayRun.isCoarrayIntrinsicName(string);
    }

    public boolean containsCoarray() {
        return this._nCoarrays > 0 || this._nCoidxObjs > 0 || this._nCoarrayLibs > 0;
    }
}

