/*
 * Decompiled with CFR 0.152.
 */
package exc.xmpF;

import exc.block.BasicBlock;
import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockList;
import exc.block.PragmaBlock;
import exc.object.Ident;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.xmpF.XMP;
import exc.xmpF.XMPdimInfo;
import exc.xmpF.XMPenv;
import exc.xmpF.XMPnodes;
import exc.xmpF.XMPobject;
import java.util.Vector;

public class XMPtemplate
extends XMPobject {
    public static final int DUPLICATION = 100;
    public static final int BLOCK = 101;
    public static final int CYCLIC = 102;
    public static final int BLOCK_CYCLIC = 103;
    public static final int GBLOCK = 104;
    private boolean isFixed = false;
    private boolean isDistributed = false;
    private XMPnodes ontoNodes = null;
    private Vector<XMPdimInfo> scripts = new Vector();

    public XMPtemplate() {
        super(101);
    }

    public String toString() {
        String string = "{Template(" + this._name + "):";
        if (this.isFixed) {
            string = string + "fixed:";
        }
        if (this.isDistributed) {
            string = string + "distributed:";
        }
        if (this.ontoNodes != null) {
            string = string + "on_ref=" + this.ontoNodes + ":";
        }
        string = string + this.scripts;
        string = string + "}";
        return string;
    }

    public void setIsFixed() {
        this.isFixed = true;
    }

    public void unsetIsFixed() {
        this.isFixed = false;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public void setIsDistributed() {
        this.isDistributed = true;
    }

    public boolean isDistributed() {
        return this.isDistributed;
    }

    public void setOntoNodes(XMPnodes xMPnodes) {
        this.ontoNodes = xMPnodes;
    }

    public XMPnodes getOntoNodes() {
        return this.ontoNodes;
    }

    public void setDistMannerAt(int n, int n2, Xobject xobject) {
        this.scripts.elementAt(n).setDistManner(n2, xobject);
    }

    public int getDistMannerAt(int n) {
        return this.scripts.elementAt(n).getDistManner();
    }

    public Xobject getDistArgAt(int n) {
        return this.scripts.elementAt(n).getDistArg();
    }

    public String getDistMannerStringAt(int n) {
        return XMPtemplate.distMannerName(this.getDistMannerAt(n));
    }

    public static String distMannerName(int n) {
        switch (n) {
            case 100: {
                return new String("DUPLICATION");
            }
            case 101: {
                return new String("BLOCK");
            }
            case 102: {
                return new String("CYCLIC");
            }
        }
        return "???";
    }

    public Xobject getUpperAt(int n) {
        return this.scripts.elementAt(n).getUpper();
    }

    public Xobject getLowerAt(int n) {
        return this.scripts.elementAt(n).getLower();
    }

    public Xobject getSizeAt(int n) {
        return this.scripts.elementAt(n).getSize();
    }

    public static String getDistMannerString(int n) {
        switch (n) {
            case 100: {
                return new String("DUPLICATION");
            }
            case 101: {
                return new String("BLOCK");
            }
            case 102: {
                return new String("CYCLIC");
            }
        }
        XMP.fatal("getDistMannerString: unknown distribute manner");
        return null;
    }

    public static void analyzeTemplate(Xobject xobject, Xobject xobject2, XMPenv xMPenv, PragmaBlock pragmaBlock) {
        XMPtemplate xMPtemplate = new XMPtemplate();
        xMPtemplate.parsePragma(xobject, xobject2, xMPenv, pragmaBlock);
        xMPenv.declXMPobject(xMPtemplate, pragmaBlock);
        if (XMP.debugFlag) {
            System.out.println("tempObject=" + xMPtemplate);
        }
    }

    void parsePragma(Xobject xobject, Xobject xobject2, XMPenv xMPenv, PragmaBlock pragmaBlock) {
        Block block;
        this._name = xobject.getString();
        Block block2 = block = pragmaBlock != null ? pragmaBlock.findParentBlockStmt() : null;
        if (block != null && block.getXMPobject(this._name) != null || block == null && xMPenv.findXMPobject(this._name, pragmaBlock) != null) {
            XMP.errorAt(pragmaBlock, "XMP object '" + this._name + "' is already declared");
            return;
        }
        this._descId = xMPenv.declObjectId("XMP_DESC_" + this._name, pragmaBlock);
        this._dim = 0;
        boolean bl = true;
        for (XobjArgs xobjArgs = xobject2.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            XMPdimInfo xMPdimInfo = XMPdimInfo.parseDecl(xobjArgs.getArg());
            if (xMPdimInfo.isStar() || !xMPdimInfo.hasLower() && !xMPdimInfo.hasUpper()) {
                bl = false;
            }
            this.scripts.add(xMPdimInfo);
            ++this._dim;
        }
        if (bl) {
            this.setIsFixed();
        }
        if (this._dim > 15) {
            XMP.errorAt(pragmaBlock, "template dimension should be less than 16");
            return;
        }
    }

    public static void analyzeDistribute(Xobject xobject, Xobject xobject2, Xobject xobject3, XMPenv xMPenv, PragmaBlock pragmaBlock) {
        String string;
        XMPnodes xMPnodes;
        String string2 = xobject.getString();
        XMPtemplate xMPtemplate = null;
        xMPtemplate = xMPenv.findXMPtemplate(string2, pragmaBlock);
        if (xMPtemplate == null) {
            XMP.errorAt(pragmaBlock, "template '" + string2 + "' is not declared");
            return;
        }
        if (xMPtemplate.isDistributed()) {
            XMP.errorAt(pragmaBlock, "template '" + string2 + "' is already distributed");
        }
        if ((xMPnodes = xMPenv.findXMPnodes(string = xobject3.getString(), pragmaBlock)) == null) {
            XMP.errorAt(pragmaBlock, "nodes '" + string + "' is not declared");
        }
        xMPtemplate.setOntoNodes(xMPnodes);
        int n = xMPtemplate.getDim();
        int n2 = 0;
        int n3 = xMPnodes.getDim();
        int n4 = 0;
        Xobject xobject4 = null;
        for (XobjArgs xobjArgs = xobject2.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            if (n2 >= n) {
                XMP.errorAt(pragmaBlock, "wrong template dimension indicated, too many");
                break;
            }
            int n5 = 100;
            if (xobjArgs.getArg() == null) {
                n5 = 100;
            } else if (xobjArgs.getArg().isIntConstant()) {
                n5 = xobjArgs.getArg().getInt();
            } else {
                String string3 = xobjArgs.getArg().getArg(0).getString();
                if (string3.equalsIgnoreCase("BLOCK")) {
                    n5 = 101;
                } else if (string3.equalsIgnoreCase("CYCLIC")) {
                    n5 = 102;
                } else if (string3.equalsIgnoreCase("GBLOCK")) {
                    n5 = 104;
                    if (xobjArgs.getArg().getArg(1) == null) {
                        xMPtemplate.unsetIsFixed();
                    }
                } else {
                    XMP.fatal("unknown distribution format," + string3);
                }
                xobject4 = xobjArgs.getArg().getArg(1);
            }
            if (n5 != 100) {
                if (n4 >= n3) {
                    XMP.errorAt(pragmaBlock, "the number of <dist-format> (except '*') should be the same with the nodes dimension");
                    return;
                }
                ++n4;
            }
            xMPtemplate.setDistMannerAt(n2, n5, xobject4);
            ++n2;
        }
        if (n4 != n3) {
            XMP.errorAt(pragmaBlock, "the number of <dist-format> (except '*') should be the same with the nodes dimension");
        }
        if (n2 != n) {
            XMP.errorAt(pragmaBlock, "wrong template dimension indicated, too few");
        }
        xMPtemplate.setIsDistributed();
        if (XMP.debugFlag) {
            System.out.println("distribute=" + xMPtemplate);
        }
    }

    @Override
    public void buildConstructor(BlockList blockList, XMPenv xMPenv, Block block) {
        Object object;
        Object object2;
        Object object3;
        if (this._is_saveDesc && !this.isFixed) {
            XMP.fatal("non-fixed template cannot have the save_desc attribute.");
        }
        BlockList blockList2 = this._is_saveDesc && !xMPenv.currentDefIsModule() ? Bcons.emptyBody() : blockList;
        Ident ident = null;
        if (this._is_saveDesc && !xMPenv.currentDefIsModule()) {
            object3 = this._descId.Type().copy();
            ((Xtype)object3).setIsFsave(true);
            this._descId.setType((Xtype)object3);
            object2 = Xtype.FlogicalType.copy();
            ((Xtype)object2).setIsFsave(true);
            object = xMPenv.getCurrentDef().getBlock().getBody();
            ident = ((BlockList)object).declLocalIdent("XMP_SAVE_" + this._name, (Xtype)object2, StorageClass.FSAVE, Xcons.List(Xcode.F_VALUE, Xcons.FlogicalConstant(false)));
        }
        object3 = xMPenv.declInternIdent("xmpf_template_alloc_", Xtype.FsubroutineType, block);
        object2 = this.isFixed ? Xcons.IntConstant(1) : Xcons.IntConstant(0);
        object = Xcons.List(new Xobject[]{this._descId.Ref(), Xcons.IntConstant(this._dim), object2});
        blockList2.add(((Ident)object3).callSubroutine((Xobject)object));
        if (!this.isFixed) {
            return;
        }
        object3 = xMPenv.declInternIdent("xmpf_template_dim_info_", Xtype.FsubroutineType, block);
        for (int i = 0; i < this._dim; ++i) {
            XMPdimInfo xMPdimInfo = this.scripts.elementAt(i);
            Xobject xobject = xMPdimInfo.getDistArg();
            if (xobject == null) {
                xobject = Xcons.IntConstant(0);
            }
            object = Xcons.List(this._descId.Ref(), Xcons.IntConstant(i), xMPdimInfo.getLower(), xMPdimInfo.getUpper(), Xcons.IntConstant(xMPdimInfo.getDistManner()), xobject);
            blockList2.add(((Ident)object3).callSubroutine((Xobject)object));
        }
        object3 = xMPenv.declInternIdent("xmpf_template_init_", Xtype.FsubroutineType, block);
        blockList2.add(((Ident)object3).callSubroutine(Xcons.List(this._descId.Ref(), this.ontoNodes.getDescId().Ref())));
        if (this._is_saveDesc && !xMPenv.currentDefIsModule()) {
            blockList2.add(Xcons.Set(ident.Ref(), Xcons.FlogicalConstant(true)));
            blockList.add(Bcons.IF(BasicBlock.Cond(Xcons.unaryOp(Xcode.LOG_NOT_EXPR, ident.Ref())), blockList2, null));
        }
    }

    @Override
    public void buildDestructor(BlockList blockList, XMPenv xMPenv, Block block) {
        if (!this._is_saveDesc) {
            Ident ident = xMPenv.declInternIdent("xmpf_template_dealloc_", Xtype.FsubroutineType, block);
            XobjList xobjList = Xcons.List(this._descId.Ref());
            blockList.add(ident.callSubroutine(xobjList));
        }
    }
}

