/*
 * Decompiled with CFR 0.152.
 */
package exc.xmpF;

import exc.block.BasicBlock;
import exc.block.Bcons;
import exc.block.Block;
import exc.block.PragmaBlock;
import exc.object.Ident;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.xmpF.XMP;
import exc.xmpF.XMPdimInfo;
import exc.xmpF.XMPenv;
import exc.xmpF.XMPinfo;
import exc.xmpF.XMPnodes;
import exc.xmpF.XMPobject;
import exc.xmpF.XMPtemplate;
import java.util.Vector;

public class XMPobjectsRef {
    Ident descId;
    String refName;
    XMPobject refObject;
    Vector<XMPdimInfo> subscripts;
    Vector<XMPdimInfo> loop_dims;
    private static final int REF_ALL = 0;
    private static final int REF_INDEX = 1;
    private static final int REF_RANGE = 2;
    private static final int REF_RANGE_NOLB = 3;
    private static final int REF_RANGE_NOUB = 4;
    private static final int REF_RANGE_NOLBUB = 5;
    private static final Xobject DUMMY = Xcons.IntConstant(-1);

    public Ident getDescId() {
        return this.descId;
    }

    public XMPtemplate getTemplate() {
        return (XMPtemplate)this.refObject;
    }

    public XMPnodes getNodes() {
        return (XMPnodes)this.refObject;
    }

    public static XMPobjectsRef parseDecl(Xobject xobject, XMPenv xMPenv, PragmaBlock pragmaBlock) {
        if (xobject == null) {
            return null;
        }
        XMPobjectsRef xMPobjectsRef = new XMPobjectsRef();
        xMPobjectsRef.parse(xobject, xMPenv, pragmaBlock);
        return xMPobjectsRef;
    }

    public XMPobject getRefObject() {
        return this.refObject;
    }

    public Vector<XMPdimInfo> getSubscripts() {
        return this.subscripts;
    }

    public int getLoopOnIndex(int n) {
        return this.loop_dims.elementAt(n).getLoopOnIndex();
    }

    public int getOnRefLoopIndex(int n) {
        return this.subscripts.elementAt(n).getOnRefLoopIndex();
    }

    public Xobject getLoopOffset(int n) {
        return this.subscripts.elementAt(n).getOnRefOffset();
    }

    void parse(Xobject xobject, XMPenv xMPenv, PragmaBlock pragmaBlock) {
        if (xobject.getArg(0) == null) {
            this.subscripts = new Vector();
            this.subscripts.add(XMPdimInfo.parseDecl(xobject.getArg(1)));
            this.refName = "xmp_";
        } else {
            this.refName = xobject.getArg(0).getString();
            this.refObject = xMPenv.findXMPobject(this.refName, pragmaBlock);
            if (this.refObject == null) {
                XMP.errorAt(pragmaBlock, "cannot find objects '" + this.refName + "'");
                return;
            }
            Xobject xobject2 = xobject.getArg(1);
            if (xobject2 != null) {
                this.subscripts = XMPdimInfo.parseSubscripts(xobject2);
                if (!xobject2.isEmptyList() && this.subscripts.size() != this.refObject.getDim()) {
                    XMP.errorAt(pragmaBlock, "wrong number of subscripts");
                    return;
                }
            } else {
                this.subscripts = XMPdimInfo.parseSubscripts(Xcons.List());
            }
        }
        this.descId = xMPenv.declObjectId(XMP.genSym("REF_" + this.refName), pragmaBlock);
    }

    public void setLoopDimInfo(Vector<XMPdimInfo> vector) {
        this.loop_dims = vector;
    }

    public Block buildConstructor(XMPenv xMPenv) {
        Ident ident;
        Block block = Bcons.emptyBlock();
        BasicBlock basicBlock = block.getBasicBlock();
        switch (this.refObject.getKind()) {
            case 100: {
                ident = xMPenv.declInternIdent("xmpf_ref_nodes_alloc_", Xtype.FsubroutineType);
                break;
            }
            case 101: {
                ident = xMPenv.declInternIdent("xmpf_ref_templ_alloc_", Xtype.FsubroutineType);
                break;
            }
            default: {
                XMP.fatal("bad object for ref");
                return null;
            }
        }
        XobjList xobjList = Xcons.List(this.descId.Ref(), this.refObject.getDescId().Ref(), Xcons.IntConstant(this.subscripts.size()));
        basicBlock.add(ident.callSubroutine(xobjList));
        ident = xMPenv.declInternIdent("xmpf_ref_set_dim_info_", Xtype.FsubroutineType);
        for (int i = 0; i < this.subscripts.size(); ++i) {
            XMPdimInfo xMPdimInfo = this.subscripts.elementAt(i);
            Xobject xobject = xMPdimInfo.getStride();
            if (xMPdimInfo.isStar()) {
                xobjList = Xcons.List(this.descId.Ref(), Xcons.IntConstant(i), Xcons.IntConstant(0), Xcons.IntConstant(0), Xcons.IntConstant(0), Xcons.IntConstant(0));
            } else if (xMPdimInfo.isScalar()) {
                xobjList = Xcons.List(this.descId.Ref(), Xcons.IntConstant(i), Xcons.IntConstant(1), xMPdimInfo.getIndex(), Xcons.IntConstant(0), Xcons.IntConstant(0));
            } else {
                Xobject xobject2;
                Xobject xobject3;
                Xobject xobject4;
                boolean bl = false;
                boolean bl2 = false;
                if (xMPdimInfo.hasLower()) {
                    xobject4 = xMPdimInfo.getLower();
                } else {
                    if (this.refObject.getKind() == 100) {
                        xobject3 = Xcons.IntConstant(1);
                    } else {
                        xobject3 = ((XMPtemplate)this.refObject).getLowerAt(i);
                        if (xobject3 == null) {
                            xobject3 = DUMMY;
                            bl = true;
                        }
                    }
                    xobject4 = xobject3;
                }
                if (xMPdimInfo.hasUpper()) {
                    xobject2 = xMPdimInfo.getUpper();
                } else {
                    if (this.refObject.getKind() == 100) {
                        xobject3 = ((XMPnodes)this.refObject).getInfoAt(i).getUpper();
                        if (xobject3 == null) {
                            xobject3 = DUMMY;
                            bl2 = true;
                        }
                    } else {
                        xobject3 = ((XMPtemplate)this.refObject).getUpperAt(i);
                        if (xobject3 == null) {
                            xobject3 = DUMMY;
                            bl2 = true;
                        }
                    }
                    xobject2 = xobject3;
                }
                xobject = xMPdimInfo.getStride();
                int n = !bl && !bl2 ? 2 : (bl && !bl2 ? 3 : (!bl && bl2 ? 4 : 5));
                xobjList = Xcons.List(this.descId.Ref(), Xcons.IntConstant(i), Xcons.IntConstant(n), xobject4, xobject2, xobject);
            }
            basicBlock.add(ident.callSubroutine(xobjList));
        }
        ident = xMPenv.declInternIdent("xmpf_ref_init_", Xtype.FsubroutineType);
        basicBlock.add(ident.callSubroutine(Xcons.List(this.descId.Ref())));
        return block;
    }

    public Block buildLoopConstructor(XMPenv xMPenv) {
        Block block = Bcons.emptyBlock();
        BasicBlock basicBlock = block.getBasicBlock();
        Ident ident = xMPenv.declInternIdent("xmpf_ref_templ_alloc_", Xtype.FsubroutineType);
        XobjList xobjList = Xcons.List(this.descId.Ref(), this.refObject.getDescId().Ref(), Xcons.IntConstant(this.subscripts.size()));
        basicBlock.add(ident.callSubroutine(xobjList));
        ident = xMPenv.declInternIdent("xmpf_ref_set_loop_info_", Xtype.FsubroutineType);
        for (int i = 0; i < this.loop_dims.size(); ++i) {
            int n = this.loop_dims.elementAt(i).getLoopOnIndex();
            Xobject xobject = this.subscripts.elementAt(n).getOnRefOffset();
            if (xobject == null) {
                xobject = Xcons.IntConstant(0);
            }
            xobjList = Xcons.List(this.descId.Ref(), Xcons.IntConstant(i), Xcons.IntConstant(n), xobject);
            basicBlock.add(ident.callSubroutine(xobjList));
        }
        ident = xMPenv.declInternIdent("xmpf_ref_init_", Xtype.FsubroutineType);
        basicBlock.add(ident.callSubroutine(Xcons.List(this.descId.Ref())));
        return block;
    }

    public Xobject buildLoopTestFuncCall(XMPenv xMPenv, XMPinfo xMPinfo) {
        Ident ident = xMPenv.declInternIdent("xmpf_loop_test_" + xMPinfo.getLoopDim(), Xtype.FlogicalFunctionType);
        XobjList xobjList = Xcons.List(this.descId);
        for (int i = 0; i < xMPinfo.getLoopDim(); ++i) {
            ((Xobject)xobjList).add(xMPinfo.getLoopVar(i));
        }
        return ident.Call(xobjList);
    }

    public Xobject buildLoopTestSkipFuncCall(XMPenv xMPenv, XMPinfo xMPinfo, int n) {
        Ident ident = xMPenv.declInternIdent("xmpf_loop_test_skip_", Xtype.FlogicalFunctionType);
        XobjList xobjList = Xcons.List(this.descId, Xcons.IntConstant(n), xMPinfo.getLoopVar(n));
        return ident.Call(xobjList);
    }

    public XMPobjectsRef convertLoopToReduction() {
        XMPdimInfo xMPdimInfo;
        int n;
        XMPobjectsRef xMPobjectsRef = new XMPobjectsRef();
        xMPobjectsRef.descId = this.descId;
        xMPobjectsRef.refName = this.refName;
        xMPobjectsRef.refObject = this.refObject;
        xMPobjectsRef.subscripts = new Vector();
        for (n = 0; n < this.subscripts.size(); ++n) {
            xMPdimInfo = this.subscripts.elementAt(n);
            XMPdimInfo xMPdimInfo2 = new XMPdimInfo();
            if (xMPdimInfo.isTriplet()) {
                xMPdimInfo2.setStar();
            } else {
                xMPdimInfo2.setLower(xMPdimInfo.getLower());
                xMPdimInfo2.setUpper(xMPdimInfo.getUpper());
                xMPdimInfo2.setStride(xMPdimInfo.getStride());
                if (xMPdimInfo.isStar()) {
                    xMPdimInfo2.setStar();
                }
            }
            xMPobjectsRef.subscripts.addElement(xMPdimInfo2);
        }
        for (n = 0; n < this.loop_dims.size(); ++n) {
            xMPdimInfo = this.loop_dims.elementAt(n);
            int n2 = xMPdimInfo.getLoopOnIndex();
            if (n2 == -1) continue;
            xMPobjectsRef.subscripts.elementAt(n2).setLower(xMPdimInfo.getLower());
            xMPobjectsRef.subscripts.elementAt(n2).setUpper(xMPdimInfo.getUpper());
            xMPobjectsRef.subscripts.elementAt(n2).setStride(xMPdimInfo.getStride());
        }
        return xMPobjectsRef;
    }
}

