/*
 * Decompiled with CFR 0.152.
 */
package exc.xmpF;

import exc.block.Block;
import exc.object.Ident;
import exc.object.Xcode;
import exc.object.XobjArgs;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.xcodeml.XcodeMLtools_Fmod;
import exc.xmpF.XMP;
import exc.xmpF.XMPanalyzePragma;
import exc.xmpF.XMParray;
import exc.xmpF.XMPenv;
import exc.xmpF.XMPnodes;
import exc.xmpF.XMPobject;
import exc.xmpF.XMPpragma;
import exc.xmpF.XMPsymbolTable;
import exc.xmpF.XMPtemplate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Vector;

public class XMPmodule
extends XMPenv {
    XMPenv parent;
    private String module_name;
    private XMPsymbolTable table;

    public XMPmodule(XMPenv xMPenv) {
        this.parent = xMPenv;
        this.is_module = true;
        this.table = new XMPsymbolTable();
    }

    public String getModuleName() {
        return this.module_name;
    }

    public void inputFile(String string) {
        File file;
        if (XMP.debugFlag) {
            System.out.println("module read begin: " + string);
        }
        String string2 = string + ".xmod";
        BufferedReader bufferedReader = null;
        String string3 = "";
        boolean bl = false;
        for (String object : XcodeMLtools_Fmod.getSearchPath()) {
            string3 = object + "/" + string2;
            file = new File(string3);
            if (!file.exists()) continue;
            bl = true;
            break;
        }
        if (!bl && (file = new File(string3 = string2)).exists()) {
            bl = true;
        }
        if (!bl) {
            XMP.error("module file '" + string2 + "' not found");
            return;
        }
        try {
            bufferedReader = new BufferedReader(new FileReader(string3));
        }
        catch (Exception exception) {
            XMP.error("cannot open module file '" + string2 + "'");
            return;
        }
        XcodeMLtools_Fmod xcodeMLtools_Fmod = new XcodeMLtools_Fmod();
        this.env = xcodeMLtools_Fmod.read(bufferedReader);
        this.module_name = xcodeMLtools_Fmod.getModuleName();
        Vector<Xobject> vector = xcodeMLtools_Fmod.getAuxInfo();
        block13: for (Xobject xobject : vector) {
            if (xobject.Opcode() != Xcode.XMP_PRAGMA) continue;
            XMPpragma xMPpragma = XMPpragma.valueOf(xobject.getArg(0));
            if (XMP.debugFlag) {
                System.out.println("module pragma=" + xobject);
            }
            block2 : switch (xMPpragma) {
                case NODES: {
                    Xobject xobject2 = xobject.getArg(1);
                    XMPnodes.analyzePragma(xobject2, this, null);
                    break;
                }
                case TEMPLATE: {
                    Object object22;
                    Xobject xobject2 = xobject.getArg(1);
                    XobjList xobjList = (XobjList)xobject2.getArg(0);
                    for (Object object22 : xobjList) {
                        XMPtemplate.analyzeTemplate((Xobject)object22, xobject2.getArg(1), this, null);
                    }
                    continue block13;
                }
                case DISTRIBUTE: {
                    Xobject xobject3;
                    Xobject xobject2 = xobject.getArg(1);
                    XobjList xobjList = (XobjList)xobject2.getArg(0);
                    Object object = xobject2.copy();
                    Object object22 = xobjList.iterator();
                    while (object22.hasNext()) {
                        xobject3 = (Xobject)object22.next();
                        XMPtemplate.analyzeDistribute(xobject3, xobject2.getArg(1), xobject2.getArg(2), this, null);
                    }
                    continue block13;
                }
                case ALIGN: {
                    Object object22;
                    Xobject xobject2 = xobject.getArg(1);
                    XobjList xobjList = (XobjList)xobject2.getArg(0);
                    for (Object object22 : xobjList) {
                        XMParray.analyzeAlign((Xobject)object22, xobject2.getArg(1), xobject2.getArg(2), xobject2.getArg(3), this, null);
                        if (!XMP.hasError()) continue;
                        break block2;
                    }
                    continue block13;
                }
                case SHADOW: {
                    Xobject xobject3;
                    Xobject xobject2 = xobject.getArg(1);
                    XobjList xobjList = (XobjList)xobject2.getArg(0);
                    Object object = xobject2.getArg(1);
                    Object object22 = xobjList.iterator();
                    while (object22.hasNext()) {
                        xobject3 = (Xobject)object22.next();
                        XMParray.analyzeShadow(xobject3, (Xobject)object, this, null);
                        if (!XMP.hasError()) continue;
                        break block2;
                    }
                    continue block13;
                }
                case LOCAL_ALIAS: {
                    XMPanalyzePragma.analyzeLocalAlias(xobject.getArg(1), this, null);
                    break;
                }
                default: {
                    XMP.error("directive '" + xobject.getArg(0).getName() + "' appears in module");
                }
            }
        }
        try {
            ((Reader)bufferedReader).close();
        }
        catch (Exception exception) {
            XMP.error("close failed, module file '" + string2 + "'");
            return;
        }
        if (XMP.debugFlag) {
            System.out.println("module read end: " + string);
            this.table.dump("module symbol");
        }
    }

    @Override
    public void useModule(String string) {
        this.table.addUseModule(string);
    }

    @Override
    public XMPsymbolTable getXMPsymbolTable() {
        return this.table;
    }

    @Override
    public void declXMPobject(XMPobject xMPobject, Block block) {
        this.declXMPobject(xMPobject);
    }

    public void declXMPobject(XMPobject xMPobject) {
        this.table.putXMPobject(xMPobject);
    }

    @Override
    public XMPobject findXMPobject(String string, Block block) {
        return this.findXMPobject(string);
    }

    public XMPobject findXMPobject(String string) {
        XMPobject xMPobject = this.table.getXMPobject(string);
        if (xMPobject != null) {
            return xMPobject;
        }
        for (String string2 : this.table.getUsedModules()) {
            XMPmodule xMPmodule = this.parent.findModule(string2);
            xMPobject = xMPmodule.findXMPobject(string);
            if (xMPobject == null) continue;
            return xMPobject;
        }
        return null;
    }

    @Override
    public Ident declIdent(String string, Xtype xtype, boolean bl, Block block) {
        Xobject xobject = this.env.getGlobalIdentList();
        if (xobject != null) {
            for (Xobject xobject2 : (XobjList)xobject) {
                if (!string.equals(xobject2.getName())) continue;
                if (!xtype.equals(xobject2.Type())) {
                    XMP.fatal("declIdent: duplicated declaration: " + string);
                }
                return (Ident)xobject2;
            }
        }
        Ident ident = block == null && bl ? Ident.Fident(string, xtype, this.env) : Ident.FidentNotExternal(string, xtype);
        xobject.add(ident);
        return ident;
    }

    @Override
    public void removeIdent(String string, Block block) {
        Xobject xobject = this.env.getGlobalIdentList();
        if (xobject != null) {
            for (XobjArgs xobjArgs = xobject.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
                if (!string.equals(xobjArgs.getArg().getName())) continue;
                xobject.removeArgs(xobjArgs);
            }
        }
    }

    @Override
    public Ident findVarIdent(String string, Block block) {
        Xobject xobject = this.env.getGlobalIdentList();
        for (Xobject xobject2 : (XobjList)xobject) {
            if (!xobject2.getName().equals(string)) continue;
            return (Ident)xobject2;
        }
        return null;
    }
}

