/*
 * Decompiled with CFR 0.152.
 */
package exc.xmpF;

import exc.block.Block;
import exc.block.BlockList;
import exc.block.FuncDefBlock;
import exc.object.BasicType;
import exc.object.FarrayType;
import exc.object.Ident;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectFile;
import exc.object.Xtype;
import exc.xmpF.XMP;
import exc.xmpF.XMParray;
import exc.xmpF.XMPmodule;
import exc.xmpF.XMPnodes;
import exc.xmpF.XMPobject;
import exc.xmpF.XMPsymbolTable;
import exc.xmpF.XMPtemplate;
import java.util.Vector;

public class XMPenv {
    protected XobjectFile env;
    protected boolean is_module = false;
    private Vector<XMPmodule> modules = new Vector();
    private FuncDefBlock current_def;
    private static final String SYMBOL_TABLE = "XMP_PROP_XMP_SYMBOL_TABLE";

    public XMPenv() {
    }

    public XMPenv(XobjectFile xobjectFile) {
        this.env = xobjectFile;
    }

    public XobjectFile getEnv() {
        return this.env;
    }

    public XMPmodule findModule(String string) {
        for (XMPmodule xMPmodule : this.modules) {
            if (!string.equals(xMPmodule.getModuleName())) continue;
            return xMPmodule;
        }
        XMPmodule xMPmodule = new XMPmodule(this);
        xMPmodule.inputFile(string);
        this.modules.add(xMPmodule);
        return xMPmodule;
    }

    public void useModule(String string) {
        XMPsymbolTable xMPsymbolTable = this.getXMPsymbolTable();
        xMPsymbolTable.addUseModule(string);
    }

    public Vector<XMPmodule> getModules() {
        return this.modules;
    }

    public void setCurrentDef(FuncDefBlock funcDefBlock) {
        this.current_def = funcDefBlock;
        XobjectDef xobjectDef = funcDefBlock.getDef();
        if (xobjectDef.getProp(SYMBOL_TABLE) == null) {
            XMPsymbolTable xMPsymbolTable = new XMPsymbolTable();
            xobjectDef.setProp(SYMBOL_TABLE, xMPsymbolTable);
        }
        this.is_module = funcDefBlock.getDef().isFmoduleDef();
    }

    FuncDefBlock getCurrentDef() {
        return this.current_def;
    }

    public boolean currentDefIsModule() {
        return this.is_module;
    }

    public String currentDefName() {
        return this.current_def.getDef().getName();
    }

    public static XMPsymbolTable getXMPsymbolTable(XobjectDef xobjectDef) {
        return (XMPsymbolTable)xobjectDef.getProp(SYMBOL_TABLE);
    }

    public XMPsymbolTable getXMPsymbolTable() {
        return XMPenv.getXMPsymbolTable(this.current_def.getDef());
    }

    public Ident declExternIdent(String string, Xtype xtype) {
        return this.declIdent(string, xtype, true, null);
    }

    public Ident declInternIdent(String string, Xtype xtype) {
        return this.declIdent(string, xtype, false, null);
    }

    public Ident declInternIdent(String string, Xtype xtype, Block block) {
        return this.declIdent(string, xtype, false, block);
    }

    public Ident declIdent(String string, Xtype xtype, Block block) {
        return this.declIdent(string, xtype, false, block);
    }

    public Ident declIdent(String string, Xtype xtype) {
        return this.declIdent(string, xtype, false, null);
    }

    public Ident declIdent(String string, Xtype xtype, boolean bl, Block block) {
        XobjList xobjList;
        BlockList blockList = null;
        if (block != null) {
            block = block.findParentBlockStmt();
        }
        if ((xobjList = (blockList = block != null ? block.getBody() : this.current_def.getBlock().getBody()).getIdentList()) != null) {
            for (Xobject xobject : xobjList) {
                if (!string.equals(xobject.getName())) continue;
                if (!xtype.equals(xobject.Type())) {
                    XMP.fatal("declIdent: duplicated declaration: " + string);
                }
                return (Ident)xobject;
            }
        }
        Ident ident = block == null && bl ? Ident.Fident(string, xtype, this.env) : Ident.FidentNotExternal(string, xtype);
        blockList.addIdent(ident);
        return ident;
    }

    public void removeIdent(String string, Block block) {
        Object object;
        if (block != null && block.removeVarIdent(string).booleanValue()) {
            return;
        }
        BlockList blockList = this.current_def.getBlock().getBody();
        XobjList xobjList = blockList.getIdentList();
        if (xobjList != null) {
            for (object = ((Xobject)xobjList).getArgs(); object != null; object = ((XobjArgs)object).nextArgs()) {
                if (!string.equals(((XobjArgs)object).getArg().getName())) continue;
                ((Xobject)xobjList).removeArgs((XobjArgs)object);
            }
        }
        if ((object = blockList.getDecls()) != null) {
            for (XobjArgs xobjArgs = ((Xobject)object).getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
                if (xobjArgs.getArg().Opcode() != Xcode.VAR_DECL || !string.equals(xobjArgs.getArg().getArg(0).getName())) continue;
                ((Xobject)object).removeArgs(xobjArgs);
            }
        }
    }

    public Ident declIntrinsicIdent(String string, Xtype xtype) {
        return Ident.Fident(string, xtype, false, false, null);
    }

    public Ident declObjectId(String string, Block block) {
        BasicType basicType = Xtype.Fint8Type;
        return this.declIdent(string, basicType, block);
    }

    public Ident declObjectId(String string, Block block, Xobject xobject) {
        if (block != null) {
            block = block.findParentBlockStmt();
        }
        BlockList blockList = (block != null ? block : this.current_def.getBlock()).getBody();
        return blockList.declLocalIdent(string, Xtype.Fint8Type, StorageClass.FLOCAL, xobject);
    }

    public void finalizeEnv() {
        this.env.collectAllTypes();
        this.env.fixupTypeRef();
    }

    public Ident FintrinsicIdent(Xtype xtype, String string) {
        Xtype xtype2 = xtype.copy();
        xtype2.setIsFintrinsic(true);
        return Ident.Fident(string, xtype2, false, false, this.env);
    }

    public Ident findVarIdent(String string, Block block) {
        Object object;
        Object object2;
        Ident ident;
        block4: {
            ident = null;
            if (block == null || (ident = block.findVarIdent(string)) == null) {
                for (object2 = this.current_def.getDef(); object2 != null; object2 = ((XobjectDef)object2).getParent()) {
                    object = ((XobjectDef)object2).getDef().getArg(1);
                    for (Xobject xobject : (XobjList)object) {
                        if (!xobject.getName().equals(string)) continue;
                        ident = (Ident)xobject;
                        break block4;
                    }
                }
                return null;
            }
        }
        if ((object2 = ident.getFdeclaredModule()) == null) {
            return ident;
        }
        object = this.findModule((String)object2);
        return ((XMPmodule)object).findVarIdent(string, null);
    }

    public Block findVarIdentBlock(String string, Block block) {
        return block != null ? block.findVarIdentBlock(string) : null;
    }

    public void declXMPobject(XMPobject xMPobject, Block block) {
        XMPsymbolTable xMPsymbolTable = null;
        if (block != null && (block = block.findParentBlockStmt()) != null) {
            xMPsymbolTable = block.getXMPsymbolTable();
        }
        if (xMPsymbolTable == null) {
            xMPsymbolTable = this.getXMPsymbolTable();
        }
        xMPsymbolTable.putXMPobject(xMPobject);
    }

    public XMPobject findXMPobject(String string, Block block) {
        XMPsymbolTable xMPsymbolTable;
        XMPobject xMPobject;
        if (block != null && (xMPobject = block.findXMPobject(string)) != null) {
            return xMPobject;
        }
        for (XobjectDef xobjectDef = this.current_def.getDef(); xobjectDef != null && (xMPsymbolTable = XMPenv.getXMPsymbolTable(xobjectDef)) != null; xobjectDef = xobjectDef.getParent()) {
            xMPobject = xMPsymbolTable.getXMPobject(string);
            if (xMPobject != null) {
                return xMPobject;
            }
            for (String string2 : xMPsymbolTable.getUsedModules()) {
                XMPmodule xMPmodule = this.findModule(string2);
                xMPobject = xMPmodule.findXMPobject(string);
                if (xMPobject == null) continue;
                return xMPobject;
            }
        }
        return null;
    }

    public XMPnodes findXMPnodes(String string, Block block) {
        XMPobject xMPobject = this.findXMPobject(string, block);
        if (xMPobject != null && xMPobject.getKind() == 100) {
            return (XMPnodes)xMPobject;
        }
        return null;
    }

    public XMPtemplate findXMPtemplate(String string, Block block) {
        XMPobject xMPobject = this.findXMPobject(string, block);
        if (xMPobject != null && xMPobject.getKind() == 101) {
            return (XMPtemplate)xMPobject;
        }
        return null;
    }

    public void declXMParray(XMParray xMParray, Block block) {
        XMPsymbolTable xMPsymbolTable = null;
        if (block != null && (block = block.findParentBlockStmt()) != null) {
            xMPsymbolTable = block.getXMPsymbolTable();
        }
        if (xMPsymbolTable == null) {
            xMPsymbolTable = this.getXMPsymbolTable();
        }
        xMPsymbolTable.putXMParray(xMParray);
    }

    public Ident declOrGetSizeArray(Block block) {
        Ident ident = this.findVarIdent("xmp_size_array", block);
        if (ident == null) {
            Xobject[] xobjectArray = new Xobject[]{Xcons.FindexRange(Xcons.IntConstant(0), Xcons.IntConstant(XMP.MAX_ASSUMED_SHAPE - 1)), Xcons.FindexRange(Xcons.IntConstant(0), Xcons.IntConstant(14))};
            FarrayType farrayType = Xtype.Farray(Xtype.FintType, xobjectArray);
            ident = this.declIdent("xmp_size_array", farrayType, false, block);
            ident.setStorageClass(StorageClass.FCOMMON);
            Xobject xobject = this.current_def.getBlock().getBody().getDecls();
            xobject.add(Xcons.List(Xcode.F_COMMON_DECL, Xcons.List(Xcode.F_VAR_LIST, Xcons.Symbol(Xcode.IDENT, "XMP_COMMON"), Xcons.List(Xcons.FvarRef(ident)))));
        }
        return ident;
    }

    Ident getNullIdent(Block block) {
        Ident ident = this.findVarIdent("XMP_NULL", block);
        if (ident == null) {
            ident = this.declObjectId("XMP_NULL", block, Xcons.Cast(Xtype.voidPtrType, Xcons.IntConstant(0)));
        }
        return ident;
    }
}

