/*
 * Decompiled with CFR 0.152.
 */
package exc.xmpF;

import exc.block.ForBlock;
import exc.object.Ident;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.Xobject;
import exc.xmpF.XMP;
import exc.xmpF.XMPtemplate;
import java.util.Vector;

public class XMPdimInfo {
    Xobject lower = null;
    Xobject upper = null;
    Xobject stride = null;
    boolean is_star = false;
    int distManner = 0;
    Xobject distArg;
    Ident node_size_var;
    Ident node_rank_var;
    int align_status = 0;
    int align_subscript_index;
    Xobject align_subscript_offset;
    Ident a_dim_size_var;
    Ident a_offset_var;
    Ident a_blk_offset_var;
    static final int ALIGN_NONE = 0;
    static final int ALIGN_SET = 1;
    static final int ALIGN_ANY = 2;
    boolean is_full_shadow = false;
    int shadow_left = 0;
    int shadow_right = 0;
    Xobject loop_var;
    ForBlock loop_block;
    Ident loop_local_var;
    int loop_on_index = -1;
    int on_ref_loop_index = -1;
    Xobject on_ref_offset;

    public Xobject getLower() {
        if (this.lower == null) {
            return Xcons.IntConstant(1);
        }
        return this.lower;
    }

    public void setLower(Xobject xobject) {
        this.lower = xobject;
    }

    public boolean hasLower() {
        return this.lower != null;
    }

    public Xobject getUpper() {
        return this.upper;
    }

    public void setUpper(Xobject xobject) {
        this.upper = xobject;
    }

    public boolean hasUpper() {
        return this.upper != null;
    }

    public Xobject getSize() {
        if (this.lower == null) {
            return this.upper;
        }
        return Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.binaryOp(Xcode.MINUS_EXPR, this.upper, this.lower), Xcons.IntConstant(1));
    }

    public boolean hasStride() {
        return this.stride != null;
    }

    public Xobject getStride() {
        if (this.stride == null) {
            return Xcons.IntConstant(1);
        }
        return this.stride;
    }

    public void setStride(Xobject xobject) {
        this.stride = xobject;
    }

    public boolean isStar() {
        return this.is_star;
    }

    public void setStar() {
        this.is_star = true;
    }

    public boolean isScalar() {
        return this.stride != null && this.stride.isZeroConstant();
    }

    public Xobject getIndex() {
        return this.upper;
    }

    public boolean isTriplet() {
        return !this.is_star && !this.isScalar();
    }

    public void setDistManner(int n, Xobject xobject) {
        this.distManner = n;
        this.distArg = xobject;
    }

    public int getDistManner() {
        return this.distManner;
    }

    public Xobject getDistArg() {
        return this.distArg;
    }

    void setNodeInfoVar(Ident ident, Ident ident2) {
        this.node_size_var = ident;
        this.node_rank_var = ident2;
    }

    Ident getNodeSizeVar() {
        return this.node_size_var;
    }

    Ident getNodeRankVar() {
        return this.node_rank_var;
    }

    public void setAlignSubscript(int n, Xobject xobject) {
        this.align_status = 1;
        this.align_subscript_index = n;
        this.align_subscript_offset = xobject;
    }

    public void setAlignAny() {
        this.align_status = 2;
    }

    public int getAlignSubscriptIndex() {
        return this.align_subscript_index;
    }

    public Xobject getAlignSubscriptOffset() {
        return this.align_subscript_offset;
    }

    public boolean isAlignAny() {
        return this.align_status == 2;
    }

    public void setArrayInfoVar(Ident ident, Ident ident2, Ident ident3) {
        this.a_dim_size_var = ident;
        this.a_offset_var = ident2;
        this.a_blk_offset_var = ident3;
    }

    public Ident getArraySizeVar() {
        return this.a_dim_size_var;
    }

    public Ident getArrayOffsetVar() {
        return this.a_offset_var;
    }

    public Ident getArrayBlkOffsetVar() {
        return this.a_blk_offset_var;
    }

    static XMPdimInfo parseDecl(Xobject xobject) {
        XMPdimInfo xMPdimInfo = new XMPdimInfo();
        xMPdimInfo.parse(xobject);
        return xMPdimInfo;
    }

    void parse(Xobject xobject) {
        if (xobject == null) {
            this.is_star = true;
            return;
        }
        if (xobject.Opcode() != Xcode.LIST) {
            this.upper = xobject;
            this.stride = Xcons.IntConstant(0);
        } else {
            this.lower = xobject.getArg(0);
            this.upper = xobject.getArgOrNull(1);
            this.stride = xobject.getArgOrNull(2);
        }
    }

    public static Vector<XMPdimInfo> parseSubscripts(Xobject xobject) {
        Vector<XMPdimInfo> vector = new Vector<XMPdimInfo>();
        for (XobjArgs xobjArgs = xobject.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            vector.add(XMPdimInfo.parseDecl(xobjArgs.getArg()));
        }
        return vector;
    }

    public static XMPdimInfo createFromRange(Xobject xobject) {
        XMPdimInfo xMPdimInfo = new XMPdimInfo();
        if (xobject.Opcode() != Xcode.F_INDEX_RANGE) {
            XMP.fatal("XMPdimInfo: createFromRage, not F_INDEX_RANGE x=" + xobject);
        }
        xMPdimInfo.lower = xobject.getArg(0);
        xMPdimInfo.upper = xobject.getArg(1);
        xMPdimInfo.stride = xobject.getArg(2);
        return xMPdimInfo;
    }

    public static XMPdimInfo loopInfo(ForBlock forBlock) {
        XMPdimInfo xMPdimInfo = new XMPdimInfo();
        xMPdimInfo.loop_block = forBlock;
        xMPdimInfo.loop_var = forBlock.getInductionVar();
        xMPdimInfo.upper = forBlock.getUpperBound();
        xMPdimInfo.lower = forBlock.getLowerBound();
        xMPdimInfo.stride = forBlock.getStep();
        return xMPdimInfo;
    }

    public Xobject getLoopVar() {
        return this.loop_var;
    }

    public ForBlock getLoopBlock() {
        return this.loop_block;
    }

    public void setLoopLocalVar(Ident ident) {
        this.loop_local_var = ident;
    }

    public Ident getLoopLocalVar() {
        return this.loop_local_var;
    }

    public void setLoopOnIndex(int n) {
        this.loop_on_index = n;
    }

    public int getLoopOnIndex() {
        return this.loop_on_index;
    }

    public void setLoopOnRefInfo(int n, Xobject xobject) {
        this.on_ref_loop_index = n;
        this.on_ref_offset = xobject;
    }

    public int getOnRefLoopIndex() {
        return this.on_ref_loop_index;
    }

    public Xobject getOnRefOffset() {
        return this.on_ref_offset;
    }

    public String toString() {
        String string = "<";
        if (this.lower != null) {
            string = string + this.lower;
        }
        string = string + ":";
        if (this.upper != null) {
            string = string + this.upper;
        }
        if (this.stride != null) {
            string = string + ",stride=";
            string = string + this.stride;
        }
        if (this.distManner != 0) {
            string = string + ",dist(" + XMPtemplate.distMannerName(this.distManner) + ")=";
            if (this.distArg != null) {
                string = string + this.distArg;
            }
        }
        if (this.align_status != 0) {
            string = this.align_status == 2 ? string + ",align(*)" : string + ",align(" + this.align_subscript_index + "," + this.align_subscript_offset + ")";
        }
        string = string + ">";
        return string;
    }
}

