/*
 * Decompiled with CFR 0.152.
 */
package exc.xmpF;

import exc.block.Block;
import exc.block.BlockList;
import exc.object.BasicType;
import exc.object.Ftype;
import exc.object.FunctionType;
import exc.object.Ident;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjInt;
import exc.object.XobjList;
import exc.object.XobjString;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.xmpF.XMP;
import exc.xmpF.XMPcoarray;
import exc.xmpF.XMPenv;
import java.util.ArrayList;

public class XMPcoindexObj {
    static final int GetInterfaceType = 8;
    static final int PutInterfaceType = 8;
    static final String COARRAYPUT_PREFIX = "xmpf_coarray_put";
    static final String COARRAYGET_PREFIX = "xmpf_coarray_get";
    static final String COARRAYGET_GENERIC_NAME = "xmpf_coarray_get_generic";
    static final String COARRAYPUT_GENERIC_NAME = "xmpf_coarray_put_generic";
    static final String COARRAYGETSUB_GENERIC_NAME = "xmpf_coarray_getsub_generic";
    String name;
    Xobject obj;
    Xobject subscripts;
    Xobject cosubscripts;
    int exprRank;
    XMPcoarray coarray;

    public XMPcoindexObj(Xobject xobject, XMPcoarray xMPcoarray) {
        this.obj = xobject;
        this.name = this._getName(xobject);
        this.coarray = xMPcoarray;
        this._initOthers();
    }

    public XMPcoindexObj(Xobject xobject, ArrayList<XMPcoarray> arrayList) {
        this.obj = xobject;
        this.name = this._getName(xobject);
        this.coarray = XMPcoarray.findCoarrayInCoarrays(this.name, arrayList);
        if (this.coarray == null) {
            XMP.fatal("INTERNAL: cannot find the coarray by name in ArrayList");
        }
        this._initOthers();
    }

    private void _initOthers() {
        this.subscripts = this._getSubscripts(this.obj);
        this.cosubscripts = this._getCosubscripts(this.obj);
        this.exprRank = this._getExprRank();
        if (this.subscripts == null && this.exprRank > 0) {
            this.subscripts = this._wholeArraySubscripts(this.exprRank);
        }
    }

    private String _getName(Xobject xobject) {
        switch (xobject.Opcode()) {
            case CO_ARRAY_REF: {
                return this._getName_coarray(xobject);
            }
            case MEMBER_REF: {
                return this._getName(xobject.getArg(0).getArg(0));
            }
            case F_ARRAY_REF: {
                return this._getName(xobject.getArg(0).getArg(0));
            }
        }
        XMP.fatal("INTERNAL: unexpected form of coindexed object: " + xobject);
        return null;
    }

    private String _getName_coarray(Xobject xobject) {
        Xobject xobject2 = xobject.getArg(0).getArg(0);
        switch (xobject2.Opcode()) {
            case F_ARRAY_REF: {
                return xobject2.getArg(0).getArg(0).getName();
            }
            case VAR: {
                return xobject2.getName();
            }
        }
        XMP.fatal("broken Xcode to describe a coindexed object");
        return null;
    }

    private Xobject _getSubscripts(Xobject xobject) {
        return xobject.getSubscripts();
    }

    private Xobject _getCosubscripts(Xobject xobject) {
        switch (xobject.Opcode()) {
            case CO_ARRAY_REF: {
                return xobject.getArg(1);
            }
            case MEMBER_REF: {
                Xobject xobject2 = xobject.getArg(0);
                if (xobject2.Opcode() != Xcode.F_VAR_REF) break;
                Xobject xobject3 = xobject2.getArg(0);
                return this._getCosubscripts(xobject3);
            }
            case F_ARRAY_REF: {
                Xobject xobject4 = xobject.getArg(0);
                if (xobject4.Opcode() != Xcode.F_VAR_REF) break;
                Xobject xobject5 = xobject4.getArg(0);
                return this._getCosubscripts(xobject5);
            }
        }
        return null;
    }

    private Xobject _wholeArraySubscripts(int n) {
        XobjList xobjList = Xcons.List();
        for (int i = 0; i < n; ++i) {
            ((Xobject)xobjList).add(Xcons.FindexRangeOfAssumedShape());
        }
        if (((Xobject)xobjList).hasNullArg()) {
            XMP.fatal("INTERNAL: generated null argument (_wholeArraySubscripts)");
        }
        return xobjList;
    }

    private Xobject _convRhsType(Xobject xobject) {
        return this._typeConv(xobject, this.obj);
    }

    private Xobject _typeConv(Xobject xobject, Xobject xobject2) {
        Ftype ftype = new Ftype(xobject2, this.getBlock());
        return this._typeConv(xobject, ftype);
    }

    private Xobject _typeConv(Xobject xobject, int n, int n2) {
        Ftype ftype = new Ftype(n, n2, this.getBlock());
        return this._typeConv(xobject, ftype);
    }

    private Xobject _typeConv(Xobject xobject, Ftype ftype) {
        Block block = this.getBlock();
        if (ftype.sameTypeAndKind(xobject).booleanValue()) {
            return xobject;
        }
        FunctionType functionType = new FunctionType(ftype.getXtype(), 524288L);
        String string = ftype.getNameOfConvFunction();
        Xobject xobject2 = ftype.getKindExpr();
        Ident ident = this.getEnv().declIntrinsicIdent(string, functionType);
        Xobject xobject3 = ident.Call(Xcons.List(xobject, xobject2));
        return xobject3;
    }

    private int _getExprRank() {
        int n = this.coarray.getRank();
        if (this.subscripts == null) {
            return n;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.isTripletIndex(i).booleanValue()) continue;
            ++n2;
        }
        return n2;
    }

    public Xobject toFuncRef() {
        Xtype xtype = this.getType();
        switch (this.getType().getKind()) {
            case 1: 
            case 3: 
            case 8: {
                Xobject xobject = this.removeCoindex();
                return this.toFuncRef_core(xobject);
            }
        }
        XMP.fatal("INTERNAL: unexpected type kind (XMPcoindexObj:toFuncRef)");
        return this.obj;
    }

    private Xobject toFuncRef_struct___radical____() {
        XobjString xobjString = Xcons.FcharacterConstant(Xtype.FcharacterType, " ", null);
        Xobject xobject = this.toFuncRef_core(xobjString);
        Ident ident = this._declIntIntrinsicIdent("transfer");
        Xobject xobject2 = ident.Call(Xcons.List(xobject, this.getIdent()));
        return xobject2;
    }

    Xobject toFuncRef_core(Xobject xobject) {
        switch (8) {
            case 6: {
                return this.toFuncRef_core_type6(xobject, COARRAYGET_PREFIX);
            }
            case 8: {
                return this.toFuncRef_core_type8(xobject, COARRAYGET_GENERIC_NAME);
            }
        }
        XMP.fatal("INTERNAL: obsoleted Get Interface Type: 8");
        return null;
    }

    private Xobject toFuncRef_core_type8(Xobject xobject, String string) {
        Object object;
        Xobject xobject2 = this._makeActualArgs_type8(xobject);
        Ident ident = this.getEnv().findVarIdent(string, null);
        if (ident == null) {
            object = new BasicType(25);
            FunctionType functionType = Xtype.Function((Xtype)object);
            ident = this.getEnv().declExternIdent(string, functionType);
        }
        object = ident.Call(xobject2);
        return object;
    }

    private Xobject toFuncRef_core_type6(Xobject xobject, String string) {
        Object object;
        Xobject xobject2 = this._makeActualArgs_type6(xobject);
        Xtype xtype = this.getType().copy();
        xtype.removeCodimensions();
        String string2 = string + this.exprRank + "d";
        Ident ident = this.getEnv().findVarIdent(string2, null);
        if (ident == null) {
            object = this._getBasicType(xtype);
            FunctionType functionType = Xtype.Function((Xtype)object);
            ident = this.getEnv().declExternIdent(string2, functionType);
        }
        object = ident.Call(xobject2);
        return object;
    }

    public Xobject toCallStmt(Xobject xobject, Xobject xobject2) {
        Xtype xtype = this.getType();
        Xobject xobject3 = this.removeCoindex();
        switch (8) {
            case 8: {
                return this.toCallStmt_type8(xobject3, xobject, COARRAYPUT_GENERIC_NAME);
            }
            case 7: {
                return this.toCallStmt_type7(xobject, xobject2, COARRAYPUT_PREFIX);
            }
        }
        XMP.fatal("INTERNAL: obsoleted Get Interface Type: 8");
        return null;
    }

    public Xobject toCallStmt_type8(Xobject xobject, Xobject xobject2, String string) {
        Xobject xobject3 = this._makeActualArgs_type8(xobject, this._convRhsType(xobject2));
        Ident ident = this.getEnv().findVarIdent(string, null);
        if (ident == null) {
            ident = this.getEnv().declExternIdent(string, Xtype.FexternalSubroutineType);
        }
        Xobject xobject4 = ident.callSubroutine(xobject3);
        return xobject4;
    }

    public Xobject toCallStmt_type7(Xobject xobject, Xobject xobject2, String string) {
        Xobject xobject3 = this._makeActualArgs_type7(this._convRhsType(xobject), xobject2);
        String string2 = this._selectCoarrayPutPattern(xobject);
        String string3 = string + "_" + string2;
        Ident ident = this.getEnv().findVarIdent(string3, null);
        if (ident == null) {
            ident = this.getEnv().declExternIdent(string3, BasicType.FexternalSubroutineType);
        }
        Xobject xobject4 = ident.callSubroutine(xobject3);
        return xobject4;
    }

    private String _selectCoarrayPutPattern(Xobject xobject) {
        String string = this.exprRank == 0 ? "scalar" : "array";
        return string;
    }

    public Xobject makeActualArgs(Xobject xobject) {
        return this._makeActualArgs_type8(this.removeCoindex(), xobject);
    }

    private Xobject _makeActualArgs_type8(Xobject xobject, Xobject xobject2) {
        Xobject xobject3 = this._makeActualArgs_type8();
        xobject3.add(xobject);
        xobject3.add(xobject2);
        return xobject3;
    }

    private Xobject _makeActualArgs_type8(Xobject xobject) {
        Xobject xobject2 = this._makeActualArgs_type8();
        xobject2.add(xobject);
        return xobject2;
    }

    private Xobject _makeActualArgs_type8() {
        XMPcoarray xMPcoarray = this.getCoarray();
        Xobject xobject = this.getBaseAddr();
        Xobject xobject2 = xMPcoarray.getDescPointerIdExpr(xobject);
        Xobject xobject3 = xMPcoarray.getImageIndex(xobject, this.cosubscripts);
        XobjList xobjList = Xcons.List(xobject2, xobject3);
        if (((Xobject)xobjList).hasNullArg()) {
            XMP.fatal("INTERNAL: generated null argument (_makeActualArgs_type8)");
        }
        return xobjList;
    }

    private Xobject _makeActualArgs_type7(Xobject xobject) {
        return this._makeActualArgs_type7(xobject, null);
    }

    private Xobject _makeActualArgs_type7(Xobject xobject, Xobject xobject2) {
        Xobject xobject3 = this._makeActualArgs_type6(xobject, xobject2);
        Xobject xobject4 = Xcons.FvarRef(this.coarray.getIdent());
        xobject3.add(xobject4);
        return xobject3;
    }

    private Xobject _makeActualArgs_type6(Xobject xobject) {
        return this._makeActualArgs_type6(xobject, null);
    }

    private Xobject _makeActualArgs_type6(Xobject xobject, Xobject xobject2) {
        XMPcoarray xMPcoarray = this.getCoarray();
        Xobject xobject3 = this.getBaseAddr();
        Xobject xobject4 = xMPcoarray.getDescPointerIdExpr(xobject3);
        Xobject xobject5 = this.getBaseAddr_type6();
        Xobject xobject6 = xMPcoarray.getElementLengthExpr_runtime();
        Xobject xobject7 = xMPcoarray.getImageIndex(xobject3, this.cosubscripts);
        XobjList xobjList = Xcons.List(xobject4, xobject5, xobject6, xobject7);
        if (xobject != null) {
            ((Xobject)xobjList).add(xobject);
        }
        if (xobject2 != null) {
            ((Xobject)xobjList).add(xobject2);
        }
        ((Xobject)xobjList).add(Xcons.IntConstant(this.exprRank));
        int n = xMPcoarray.getRank();
        for (int i = 0; i < n; ++i) {
            if (!this.isTripletIndex(i).booleanValue()) continue;
            ((Xobject)xobjList).add(this.getNeighboringAddr_type6(i));
            ((Xobject)xobjList).add(this.getSizeFromTriplet(i));
        }
        if (((Xobject)xobjList).hasNullArg()) {
            XMP.fatal("INTERNAL: generated null argument (_makeActualArgs_type6)");
        }
        return xobjList;
    }

    private Xtype _getBasicType(Xtype xtype) {
        int n = 0;
        switch (xtype.getKind()) {
            case 8: {
                n = xtype.getRef().getBasicType();
                break;
            }
            case 1: {
                n = xtype.getBasicType();
                break;
            }
            case 3: {
                XMP.fatal("internal error: STRUCT unsupported in _getTypeSuffix()");
                break;
            }
            default: {
                XMP.fatal("internal error: unexpected kind in _getTypeSuffix(): xtype.getKind()");
            }
        }
        return new BasicType(n);
    }

    private Xobject _makeActualArgs_type5() {
        return this._makeActualArgs_type5(null, null);
    }

    private Xobject _makeActualArgs_type5(Xobject xobject, Xobject xobject2) {
        XMPcoarray xMPcoarray = this.getCoarray();
        Xobject xobject3 = this.getBaseAddr();
        Xobject xobject4 = xMPcoarray.getDescPointerIdExpr(xobject3);
        Xobject xobject5 = xMPcoarray.getElementLengthExpr_runtime();
        Xobject xobject6 = xMPcoarray.getImageIndex(xobject3, this.cosubscripts);
        XobjList xobjList = Xcons.List(xobject4, xobject3, xobject5, xobject6);
        if (xobject != null) {
            ((Xobject)xobjList).add(this._convRhsType(xobject));
        }
        if (xobject2 != null) {
            ((Xobject)xobjList).add(xobject2);
        }
        ((Xobject)xobjList).add(Xcons.IntConstant(this.exprRank));
        int n = xMPcoarray.getRank();
        for (int i = 0; i < n; ++i) {
            if (!this.isTripletIndex(i).booleanValue()) continue;
            ((Xobject)xobjList).add(this.getNeighboringAddr(i));
            ((Xobject)xobjList).add(this.getSizeFromTriplet(i));
        }
        if (((Xobject)xobjList).hasNullArg()) {
            XMP.fatal("INTERNAL: generated null argument (_makeActualArgs_type5)");
        }
        return xobjList;
    }

    public Xobject getImageIndex() {
        return this.coarray.getImageIndex(this.getBaseAddr(), this.cosubscripts);
    }

    public Boolean isScalarIndex(int n) {
        Xobject xobject = this.subscripts.getArg(n);
        if (xobject.Opcode() != Xcode.F_ARRAY_INDEX) {
            return xobject.getFrank(this.getBlock()) == 0;
        }
        return false;
    }

    public Boolean isVectorIndex(int n) {
        Xobject xobject = this.subscripts.getArg(n);
        if (xobject.Opcode() != Xcode.F_ARRAY_INDEX) {
            switch (xobject.getFrank(this.getBlock())) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            XMP.fatal("unexpected subscript expression: " + xobject);
        }
        return false;
    }

    public Boolean isTripletIndex(int n) {
        Xobject xobject = this.subscripts.getArg(n);
        return xobject.Opcode() == Xcode.F_INDEX_RANGE;
    }

    public Xobject getBaseAddr() {
        return this.getNeighboringAddr(-1);
    }

    public Xobject getBaseAddr_type6() {
        return this.getNeighboringAddr_type6(-1);
    }

    public Xobject getNeighboringAddr(int n) {
        int n2 = this.coarray.getRank();
        if (n2 == 0) {
            return Xcons.FvarRef(this.coarray.getIdent());
        }
        Xobject xobject = Xcons.FarrayRef(this.coarray.getIdent().Ref(), new Xobject[0]);
        for (int i = 0; i < n2; ++i) {
            Xobject xobject2 = this.getStart(i);
            if (i == n) {
                xobject2 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject2, this.getStride(i));
            }
            Xobject xobject3 = Xcons.FarrayIndex(xobject2);
            xobject.getArg(1).setArg(i, xobject3);
        }
        return xobject;
    }

    public Xobject getNeighboringAddr_type6(int n) {
        Xobject xobject = this.getNeighboringAddr(n);
        Ident ident = this._declInt8IntrinsicIdent("loc");
        return ident.Call(Xcons.List(xobject));
    }

    public Xobject getStart(int n) {
        Xobject xobject;
        Xobject xobject2 = this.subscripts.getArg(n);
        switch (xobject2.Opcode()) {
            case F_ARRAY_INDEX: {
                xobject = xobject2.getArg(0);
                break;
            }
            case F_INDEX_RANGE: {
                xobject = xobject2.getArg(0);
                if (xobject != null) break;
                xobject = this.coarray.getLbound(n);
                break;
            }
            default: {
                XMP.fatal("internal error: unexpected Xcode: " + (Object)((Object)xobject2.Opcode()));
                xobject = null;
            }
        }
        return xobject;
    }

    public Xobject getEnd(int n) {
        Xobject xobject;
        Xobject xobject2 = this.subscripts.getArg(n);
        switch (xobject2.Opcode()) {
            case F_ARRAY_INDEX: {
                xobject = xobject2.getArg(0);
                break;
            }
            case F_INDEX_RANGE: {
                xobject = xobject2.getArg(1);
                if (xobject != null) break;
                xobject = this.coarray.getUbound(n);
                break;
            }
            default: {
                XMP.fatal("internal error: unexpected Xcode: " + (Object)((Object)xobject2.Opcode()));
                xobject = null;
            }
        }
        return xobject;
    }

    public Xobject getStride(int n) {
        Xobject xobject;
        Xobject xobject2 = this.subscripts.getArg(n);
        switch (xobject2.Opcode()) {
            case F_ARRAY_INDEX: {
                xobject = Xcons.IntConstant(1);
                break;
            }
            case F_INDEX_RANGE: {
                xobject = xobject2.getArg(2);
                if (xobject != null) break;
                xobject = Xcons.IntConstant(1);
                break;
            }
            default: {
                XMP.fatal("internal error: unexpected Xcode: " + (Object)((Object)xobject2.Opcode()));
                xobject = null;
            }
        }
        return xobject;
    }

    public Xobject getSizeFromTriplet(int n) {
        Xobject xobject;
        Xobject xobject2 = this.subscripts.getArg(n);
        switch (xobject2.Opcode()) {
            case F_ARRAY_INDEX: {
                xobject = Xcons.IntConstant(1);
                break;
            }
            case F_INDEX_RANGE: {
                Xobject xobject3 = xobject2.getArg(0);
                Xobject xobject4 = xobject2.getArg(1);
                Xobject xobject5 = xobject2.getArg(2);
                xobject = this.coarray.getSizeFromTriplet(n, xobject3, xobject4, xobject5);
                if (xobject != null) {
                    Ftype ftype = new Ftype(7, 4, this.getBlock());
                    xobject = this._typeConv(xobject, ftype);
                    break;
                }
                if (xobject3 == null && xobject4 == null && xobject5 == null) {
                    XobjString xobjString = Xcons.Symbol(Xcode.VAR, this.name);
                    XobjInt xobjInt = Xcons.IntConstant(n + 1);
                    Ident ident = this._declIntIntrinsicIdent("size");
                    xobject = ident.Call(Xcons.List(xobjString, xobjInt));
                    break;
                }
                if (xobject3 == null) {
                    xobject3 = this.coarray.getLbound(n);
                }
                if (xobject4 == null) {
                    xobject4 = this.coarray.getUbound(n);
                }
                if ((xobject = this.coarray.getSizeFromTriplet(n, xobject3, xobject4, xobject5)) == null || xobject.Type().isBasic() || xobject.Type().getBasicType() == 7) break;
                Ident ident = this._declIntIntrinsicIdent("int");
                xobject = ident.Call(Xcons.List(xobject));
                break;
            }
            default: {
                XMP.fatal("internal error: maybe vector subscript. Xcode: " + (Object)((Object)xobject2.Opcode()));
                xobject = null;
            }
        }
        return xobject;
    }

    public int getTotalArraySize() {
        return this.getTotalArraySize(this.getBlock());
    }

    public int getTotalArraySize(Block block) {
        Xobject xobject = this.getTotalArraySizeExpr(block);
        if (xobject != null || !xobject.isIntConstant()) {
            return -1;
        }
        return xobject.getInt();
    }

    public Xobject getTotalArraySizeExpr() {
        return this.getTotalArraySizeExpr(this.getBlock());
    }

    public Xobject getTotalArraySizeExpr(Block block) {
        return this.obj.Type().getTotalArraySizeExpr(block);
    }

    private Ident _declIntIntrinsicIdent(String string) {
        FunctionType functionType = new FunctionType(Xtype.FintType, 524288L);
        Ident ident = this.getEnv().declIntrinsicIdent(string, functionType);
        return ident;
    }

    private Ident _declInt8IntrinsicIdent(String string) {
        FunctionType functionType = new FunctionType(Xtype.Fint8Type, 524288L);
        Ident ident = this.getEnv().declIntrinsicIdent(string, functionType);
        return ident;
    }

    public static Boolean isGETfunc(Xobject xobject) {
        if (xobject.Opcode() == Xcode.FUNCTION_CALL && COARRAYGET_GENERIC_NAME.equals(xobject.getName())) {
            return true;
        }
        return false;
    }

    public Xobject getObj() {
        return this.obj;
    }

    public String getName() {
        return this.name;
    }

    public Xtype getType() {
        return this.coarray.getType();
    }

    public Ident getIdent() {
        return this.coarray.getIdent();
    }

    public XMPcoarray getCoarray() {
        return this.coarray;
    }

    public Xobject removeCoindex() {
        this.obj = this._removeCoindex(this.obj);
        return this.obj;
    }

    private Xobject _removeCoindex(Xobject xobject) {
        switch (xobject.Opcode()) {
            case CO_ARRAY_REF: {
                Xobject xobject2 = xobject.getArg(0).getArg(0);
                return xobject2;
            }
            case MEMBER_REF: 
            case F_ARRAY_REF: {
                Xobject xobject3 = xobject.getArg(0);
                Xobject xobject4 = xobject3.getArg(0);
                xobject4 = this._removeCoindex(xobject4);
                xobject3.setArg(0, xobject4);
                return xobject;
            }
        }
        XMP.fatal("INTERNAL: unexpected Opcode (XMPcoindexObj:removeCoindex #3)");
        return xobject;
    }

    public XMPenv getEnv() {
        return this.coarray.getEnv();
    }

    public Block getBlock() {
        return this.coarray.fblock;
    }

    public BlockList getBlockList() {
        return this.coarray.fblock.getBody();
    }

    public Xobject getDecls() {
        return this.getBlockList().getDecls();
    }

    public String toString() {
        return "XMPcoindexObj(" + this.obj.toString() + ")";
    }
}

