/*
 * Decompiled with CFR 0.152.
 */
package exc.xmpF;

import exc.block.Block;
import exc.block.BlockList;
import exc.block.FuncDefBlock;
import exc.block.FunctionBlock;
import exc.block.PragmaBlock;
import exc.object.BasicType;
import exc.object.FarrayType;
import exc.object.FindexRange;
import exc.object.Ftype;
import exc.object.FunctionType;
import exc.object.Ident;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjInt;
import exc.object.XobjList;
import exc.object.XobjString;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.Xtype;
import exc.xmpF.XMP;
import exc.xmpF.XMPenv;
import exc.xmpF.XMPnodes;
import java.util.ArrayList;

public class XMPcoarray {
    private static final Boolean _DEBUG_ALIGN_ON = false;
    private static final String XMP_COARRAY_NODES_PROP = "XMP_COARRAY_NODES_PROP";
    public static final String VAR_DESCPOINTER_PREFIX = "xmpf_descptr";
    public static final String VAR_CRAYPOINTER_PREFIX = "xmpf_crayptr";
    public static final String CBLK_COARRAYS_PREFIX = "xmpf_coarrayvar";
    public static final String VAR_COARRAYCOMM_PREFIX = "xmpf_coarraynodes";
    static final String XMPF_LCOBOUND = "xmpf_lcobound";
    static final String XMPF_UCOBOUND = "xmpf_ucobound";
    static final String XMPF_COSIZE = "xmpf_cosize";
    static final String GET_IMAGE_INDEX_NAME = "xmpf_image_index_generic";
    static final String SET_CORANK_NAME = "xmpf_coarray_set_corank";
    static final String SET_CODIMENSION_NAME = "xmpf_coarray_set_codim";
    static final String SET_VARNAME_NAME = "xmpf_coarray_set_varname";
    static final String GET_DESCR_ID_NAME = "xmpf_get_descr_id";
    static final String SET_NODES_NAME = "xmpf_coarray_set_nodes";
    static final String SET_IMAGE_NODES_NAME = "xmpf_coarray_set_image_nodes";
    static final String COUNT_SIZE_NAME = "xmpf_coarray_count_size";
    static final String ALLOC_STATIC_NAME = "xmpf_coarray_alloc_static";
    static final String REGMEM_STATIC_NAME = "xmpf_coarray_regmem_static";
    private Ident ident;
    private String name;
    private FindexRange indexRange = null;
    private FindexRange coindexRange = null;
    private Boolean isAllocatable;
    private Boolean isPointer;
    private Boolean isUseAssociated;
    private Boolean _wasMovedFromModule = false;
    private String _crayPtrName = null;
    private Ident crayPtrId = null;
    private String _descPtrName = null;
    private Ident descPtrId = null;
    private String homeBlockCodeName = null;
    private String _coarrayCommName = null;
    private Ident coarrayCommId = null;
    private String nodesName = null;
    private Ident nodesDescId = null;
    protected XMPenv env;
    protected XobjectDef def;
    protected FunctionBlock fblock;
    private Boolean useMalloc = true;

    private void _DEBUG_ALIGN(String string) {
        if (_DEBUG_ALIGN_ON.booleanValue()) {
            System.out.println(string);
        }
    }

    public XMPcoarray(Ident ident, XMPenv xMPenv) {
        this(ident, xMPenv.getCurrentDef(), xMPenv);
    }

    public XMPcoarray(Ident ident, FuncDefBlock funcDefBlock, XMPenv xMPenv) {
        this(ident, funcDefBlock.getDef(), funcDefBlock.getBlock(), xMPenv);
    }

    public XMPcoarray(Ident ident, FuncDefBlock funcDefBlock, XMPenv xMPenv, String string) {
        this(ident, funcDefBlock.getDef(), funcDefBlock.getBlock(), xMPenv, string);
    }

    public XMPcoarray(Ident ident, XobjectDef xobjectDef, FunctionBlock functionBlock, XMPenv xMPenv) {
        this.env = xMPenv;
        this.def = xobjectDef;
        this.fblock = functionBlock;
        this.setIdentEtc(ident);
        this._setHomeBlockCodeName();
    }

    public XMPcoarray(Ident ident, XobjectDef xobjectDef, FunctionBlock functionBlock, XMPenv xMPenv, String string) {
        this.env = xMPenv;
        this.def = xobjectDef;
        this.fblock = functionBlock;
        this.setIdentEtc(ident);
        this.homeBlockCodeName = string;
    }

    private void _setHomeBlockCodeName() {
        String string;
        String string2 = this.ident.getFdeclaredModule();
        if (string2 != null) {
            string = this._getCodeFromName(string2);
        } else {
            string2 = this.def.getName();
            string = this._getCodeFromName(string2);
            for (XobjectDef xobjectDef = this.def.getParent(); xobjectDef != null; xobjectDef = xobjectDef.getParent()) {
                string2 = xobjectDef.getName();
                string = this._getCodeFromName(string2) + "_" + string;
            }
        }
        this.homeBlockCodeName = string;
    }

    private String _getCodeFromName(String string) {
        int n = 0;
        int n2 = string.indexOf("_");
        while (n2 >= 0) {
            ++n;
            n2 = string.indexOf("_", n2 + 1);
        }
        if (n == 0) {
            return string;
        }
        return "" + n + string;
    }

    public void setUseMallocWithHint(Boolean bl) {
        if (bl.booleanValue()) {
            this.useMalloc = true;
            return;
        }
        if (this.getIdent().Type().getKind() == 3) {
            this.useMalloc = true;
            return;
        }
        this.useMalloc = false;
    }

    public Boolean usesMalloc() {
        return this.useMalloc;
    }

    public static void analyzeCoarrayDirective(Xobject xobject, XMPenv xMPenv, PragmaBlock pragmaBlock) {
        String string = xobject.getArg(0).getString();
        XobjList xobjList = (XobjList)xobject.getArg(1);
        for (Xobject xobject2 : xobjList) {
            String string2 = xobject2.getString();
            XMPcoarray.analyzeEachCoarray(string2, string, xMPenv, pragmaBlock);
            if (!XMP.hasError()) continue;
            break;
        }
    }

    private static void analyzeEachCoarray(String string, String string2, XMPenv xMPenv, PragmaBlock pragmaBlock) {
        Ident ident = xMPenv.findVarIdent(string, null);
        if (ident == null || !ident.isCoarray()) {
            XMP.errorAt(pragmaBlock, "not declared as a coarray variable: " + string);
            return;
        }
        if (XMPcoarray.getProp_nodes(ident) != null) {
            XMP.errorAt(pragmaBlock, "double-declaration in coarray directives: " + string);
            return;
        }
        XMPcoarray.setProp_nodes(ident, string2);
    }

    public static String getProp_nodes(Ident ident) {
        return (String)ident.getProp(XMP_COARRAY_NODES_PROP);
    }

    public static String getProp_nodes(Xobject xobject) {
        return (String)xobject.getProp(XMP_COARRAY_NODES_PROP);
    }

    private static void setProp_nodes(Ident ident, String string) {
        ident.setProp(XMP_COARRAY_NODES_PROP, string);
    }

    private static void setProp_nodes(Xobject xobject, String string) {
        xobject.setProp(XMP_COARRAY_NODES_PROP, string);
    }

    public void genDecl_crayPointer() {
        this.genDecl_crayPointer(false);
    }

    public void genDecl_crayPointer(Boolean bl) {
        StorageClass storageClass;
        BlockList blockList = this.fblock.getBody();
        String string = this.getCrayPointerName();
        if (bl.booleanValue()) {
            storageClass = StorageClass.FSAVE;
            this._setSaveAttrInType(this.ident.Type());
        } else {
            storageClass = StorageClass.FLOCAL;
        }
        FarrayType farrayType = Xtype.Farray(BasicType.Fint8Type, new Xobject[0]);
        farrayType.setIsFcrayPointer(true);
        this.crayPtrId = blockList.declLocalIdent(string, farrayType, storageClass, Xcons.FvarRef(this.ident));
    }

    public void genDecl_descPointer() {
        if (this.descPtrId != null) {
            return;
        }
        String string = this.getDescPointerName();
        this.descPtrId = this.env.declInternIdent(string, BasicType.Fint8Type);
    }

    public Xobject makeStmt_countCoarrays() {
        BlockList blockList = this.fblock.getBody();
        return this.makeStmt_countCoarrays(blockList);
    }

    public Xobject makeStmt_countCoarrays(BlockList blockList) {
        Xobject xobject = this.getElementLengthExpr_atmost();
        if (xobject == null) {
            XMP.error("current restriction: could not find the element length of: " + this.getName());
        }
        int n = this.getTotalArraySize();
        XobjList xobjList = Xcons.List(Xcons.IntConstant(n), xobject);
        Ident ident = blockList.declLocalIdent(COUNT_SIZE_NAME, BasicType.FexternalSubroutineType);
        return ident.callSubroutine(xobjList);
    }

    public Xobject makeStmt_regmemStatic() {
        BlockList blockList = this.fblock.getBody();
        return this.makeStmt_regmemStatic(blockList);
    }

    public Xobject makeStmt_regmemStatic(BlockList blockList) {
        String string = REGMEM_STATIC_NAME;
        Ident ident = blockList.declLocalIdent(string, BasicType.FexternalSubroutineType);
        FunctionType functionType = new FunctionType(Xtype.Fint8Type, 524288L);
        Ident ident2 = this.env.declIntrinsicIdent("loc", functionType);
        Xobject xobject = ident2.Call(Xcons.List(this.getIdent()));
        Xobject xobject2 = this._getCommonArgs(xobject);
        return ident.callSubroutine(xobject2);
    }

    public Xobject makeStmt_allocStatic() {
        BlockList blockList = this.fblock.getBody();
        return this.makeStmt_allocStatic(blockList);
    }

    public Xobject makeStmt_allocStatic(BlockList blockList) {
        String string = ALLOC_STATIC_NAME;
        Ident ident = blockList.declLocalIdent(string, BasicType.FexternalSubroutineType);
        Ident ident2 = this.getCrayPointerId();
        Xobject xobject = this._getCommonArgs(ident2);
        return ident.callSubroutine(xobject);
    }

    private Xobject _getCommonArgs(Xobject xobject) {
        Ident ident = this.getDescPointerId();
        Xobject xobject2 = this.getTotalArraySizeExpr();
        Xobject xobject3 = this.getElementLengthExpr_atmost();
        if (xobject3 == null) {
            XMP.fatal("elem must not be null.");
        }
        String string = this.getName();
        XobjString xobjString = Xcons.FcharacterConstant(Xtype.FcharacterType, string, null);
        XobjInt xobjInt = Xcons.IntConstant(string.length());
        XobjList xobjList = Xcons.List(ident, xobject, xobject2, xobject3, xobjInt, xobjString);
        if (((Xobject)xobjList).hasNullArg()) {
            XMP.fatal("INTERNAL: contains null argument");
        }
        return xobjList;
    }

    public void addStmts_setCoshapeAndName(BlockList blockList, XMPenv xMPenv) {
        this.addStmts_setCoshape(blockList, xMPenv);
        Xobject xobject = this.makeStmt_setVarName();
        blockList.add(xobject);
    }

    public void addStmts_setCoshape(BlockList blockList) {
        this.addStmts_setCoshape(blockList, this.env);
    }

    public void addStmts_setCoshape(BlockList blockList, XMPenv xMPenv) {
        Xobject xobject = this.makeStmt_setCorank(xMPenv);
        blockList.add(xobject);
        int n = this.getCorank();
        for (int i = 0; i < n; ++i) {
            xobject = this.makeStmt_setCodimension(i, xMPenv);
            blockList.add(xobject);
        }
    }

    public void addStmts_setCoshape(ArrayList<Xobject> arrayList) {
        this.addStmts_setCoshape(arrayList, this.env);
    }

    public void addStmts_setCoshape(ArrayList<Xobject> arrayList, XMPenv xMPenv) {
        Xobject xobject = this.makeStmt_setCorank(xMPenv);
        arrayList.add(xobject);
        int n = this.getCorank();
        for (int i = 0; i < n; ++i) {
            xobject = this.makeStmt_setCodimension(i, xMPenv);
            arrayList.add(xobject);
        }
    }

    public void addStmts_setCoshape(XobjList xobjList) {
        this.addStmts_setCoshape(xobjList, this.env);
    }

    public void addStmts_setCoshape(XobjList xobjList, XMPenv xMPenv) {
        Xobject xobject = this.makeStmt_setCorank(xMPenv);
        xobjList.add(xobject);
        int n = this.getCorank();
        for (int i = 0; i < n; ++i) {
            xobject = this.makeStmt_setCodimension(i, xMPenv);
            xobjList.add(xobject);
        }
    }

    public Xobject makeStmt_setCorank() {
        return this.makeStmt_setCorank(this.env);
    }

    public Xobject makeStmt_setCorank(XMPenv xMPenv) {
        int n = this.getCorank();
        XobjList xobjList = Xcons.List(this.getDescPointerId(), Xcons.IntConstant(n));
        Ident ident = xMPenv.findVarIdent(SET_CORANK_NAME, null);
        if (ident == null) {
            ident = xMPenv.declExternIdent(SET_CORANK_NAME, BasicType.FexternalSubroutineType);
        }
        Xobject xobject = ident.callSubroutine(xobjList);
        return xobject;
    }

    public Xobject makeStmt_setCodimension(int n) {
        return this.makeStmt_setCodimension(n, this.env);
    }

    public Xobject makeStmt_setCodimension(int n, XMPenv xMPenv) {
        int n2 = this.getCorank();
        XobjList xobjList = Xcons.List(this.getDescPointerId(), Xcons.IntConstant(n));
        if (n < n2 - 1) {
            ((Xobject)xobjList).add(this.getLcobound(n));
            ((Xobject)xobjList).add(this.getUcobound(n));
        } else if (n == n2 - 1) {
            ((Xobject)xobjList).add(this.getLcobound(n));
            ((Xobject)xobjList).add(Xcons.IntConstant(-999));
        } else {
            XMP.fatal("INTERNAL: dimension number specified larger than corank xmpf_coarray_set_codim(makeStmt_setCodimension(dim, env))");
        }
        Ident ident = xMPenv.findVarIdent(SET_CODIMENSION_NAME, null);
        if (ident == null) {
            ident = xMPenv.declExternIdent(SET_CODIMENSION_NAME, BasicType.FexternalSubroutineType);
        }
        Xobject xobject = ident.callSubroutine(xobjList);
        return xobject;
    }

    public void addStmts_setCoshape(BlockList blockList, XobjList xobjList) {
        Xobject xobject = this.makeStmt_setCorank(xobjList);
        blockList.add(xobject);
        int n = this.getCorank();
        for (int i = 0; i < n; ++i) {
            xobject = this.makeStmt_setCodimension(i, xobjList);
            blockList.add(xobject);
        }
    }

    public void addStmts_setCoshape(ArrayList<Xobject> arrayList, XobjList xobjList) {
        Xobject xobject = this.makeStmt_setCorank(xobjList);
        arrayList.add(xobject);
        int n = this.getCorank();
        for (int i = 0; i < n; ++i) {
            xobject = this.makeStmt_setCodimension(i, xobjList);
            arrayList.add(xobject);
        }
    }

    public Xobject makeStmt_setCorank(XobjList xobjList) {
        int n = this.getCorank();
        if (n != xobjList.Nargs()) {
            XMP.fatal("number of codimensions not matched with the declaration:" + n + " and " + xobjList.Nargs());
            return null;
        }
        return this.makeStmt_setCorank(this.env);
    }

    public Xobject makeStmt_setCodimension(int n, XobjList xobjList) {
        int n2 = this.getCorank();
        XobjList xobjList2 = Xcons.List(this.getDescPointerId(), Xcons.IntConstant(n));
        if (n < n2 - 1) {
            ((Xobject)xobjList2).add(this._getLboundInIndexRange(xobjList.getArg(n)));
            ((Xobject)xobjList2).add(this._getUboundInIndexRange(xobjList.getArg(n)));
        } else if (n == n2 - 1) {
            ((Xobject)xobjList2).add(this._getLboundInIndexRange(xobjList.getArg(n)));
            ((Xobject)xobjList2).add(Xcons.IntConstant(-998));
        } else {
            XMP.fatal("INTERNAL: dimension number specified larger than corank xmpf_coarray_set_codim(makeStmt_setCodimension(dim, coshape))");
        }
        Ident ident = this.env.findVarIdent(SET_CODIMENSION_NAME, null);
        if (ident == null) {
            ident = this.env.declExternIdent(SET_CODIMENSION_NAME, BasicType.FexternalSubroutineType);
        }
        Xobject xobject = ident.callSubroutine(xobjList2);
        return xobject;
    }

    private Xobject _getLboundInIndexRange(Xobject xobject) {
        Xobject xobject2;
        if (xobject == null) {
            xobject2 = null;
        } else {
            switch (xobject.Opcode()) {
                case F_INDEX_RANGE: {
                    xobject2 = xobject.getArg(0);
                    break;
                }
                case F_ARRAY_INDEX: {
                    xobject2 = null;
                    break;
                }
                default: {
                    xobject2 = null;
                }
            }
        }
        if (xobject2 == null) {
            return Xcons.IntConstant(1);
        }
        return xobject2.cfold(this.fblock);
    }

    private Xobject _getUboundInIndexRange(Xobject xobject) {
        Xobject xobject2;
        if (xobject == null) {
            xobject2 = null;
        } else {
            switch (xobject.Opcode()) {
                case F_INDEX_RANGE: {
                    xobject2 = xobject.getArg(1);
                    break;
                }
                case F_ARRAY_INDEX: {
                    xobject2 = xobject.getArg(0);
                    break;
                }
                default: {
                    xobject2 = xobject;
                }
            }
        }
        if (xobject2 == null) {
            XMP.fatal("illegal upper bound specified in ALLOCATE statement");
        }
        return xobject2.cfold(this.fblock);
    }

    public Xobject makeStmt_setVarName() {
        return this.makeStmt_setVarName(this.env);
    }

    public Xobject makeStmt_setVarName(XMPenv xMPenv) {
        Ident ident;
        String string = this.getName();
        XobjString xobjString = Xcons.FcharacterConstant(Xtype.FcharacterType, string, null);
        XobjInt xobjInt = Xcons.IntConstant(string.length());
        XobjList xobjList = Xcons.List(this.getDescPointerId(), xobjInt, xobjString);
        if (((Xobject)xobjList).hasNullArg()) {
            XMP.fatal("generated null argument xmpf_coarray_set_varname(makeStmt_setVarName)");
        }
        if ((ident = xMPenv.findVarIdent(SET_VARNAME_NAME, null)) == null) {
            ident = xMPenv.declExternIdent(SET_VARNAME_NAME, BasicType.FexternalSubroutineType);
        }
        Xobject xobject = ident.callSubroutine(xobjList);
        return xobject;
    }

    public void build_setMappingNodes(BlockList blockList, Block block) {
        if (this.nodesDescId != null) {
            blockList.add(this.makeStmt_setMappingNodes(block));
        }
    }

    public Xobject makeStmt_setMappingNodes(Block block) {
        if (this.descPtrId == null) {
            this.descPtrId = this.env.findVarIdent(this.getDescPointerName(), block);
        }
        XobjList xobjList = Xcons.List(this.descPtrId, this.nodesDescId);
        Ident ident = this.env.findVarIdent(SET_NODES_NAME, null);
        if (ident == null) {
            ident = block == null ? this.env.declExternIdent(SET_NODES_NAME, BasicType.FexternalSubroutineType) : block.getBody().declLocalIdent(SET_NODES_NAME, BasicType.FexternalSubroutineType);
        }
        Xobject xobject = ident.callSubroutine(xobjList);
        return xobject;
    }

    public static Xobject makeStmt_setImageNodes(String string, XMPenv xMPenv) {
        return XMPcoarray.makeStmt_setImageNodes(string, xMPenv, xMPenv.getCurrentDef().getBlock());
    }

    public static Xobject makeStmt_setImageNodes(String string, XMPenv xMPenv, Block block) {
        XMPnodes xMPnodes = xMPenv.findXMPnodes(string, block);
        Ident ident = xMPnodes.getDescId();
        XobjList xobjList = Xcons.List(ident);
        Ident ident2 = xMPenv.findVarIdent(SET_IMAGE_NODES_NAME, block);
        if (ident2 == null) {
            ident2 = block == null ? xMPenv.declExternIdent(SET_IMAGE_NODES_NAME, BasicType.FexternalSubroutineType) : block.getBody().declLocalIdent(SET_IMAGE_NODES_NAME, BasicType.FexternalSubroutineType);
        }
        Xobject xobject = ident2.callSubroutine(xobjList);
        return xobject;
    }

    public void errorCheck() {
        if (this.ident.isCoarray()) {
            if (this.isPointer().booleanValue()) {
                XMP.error("Coarray variable cannot be a pointer: " + this.name);
            }
            if (!(!this.isDummyArg().booleanValue() || this.isScalar().booleanValue() || this.isExplicitShape().booleanValue() || this.isAssumedSize().booleanValue() || this.isAssumedShape().booleanValue() || this.isAllocatable().booleanValue())) {
                XMP.error("Coarray dummy argument must be of explicit shape, assumed size, assumed shape, or allocatable: " + this.name);
            }
        }
    }

    private void _setIndexRange() {
        Xobject[] xobjectArray = this.getShape();
        this.indexRange = new FindexRange(xobjectArray, (Block)this.fblock, this.env);
    }

    private void _setIndexRange(Block block, XMPenv xMPenv) {
        Xobject[] xobjectArray = this.getShape();
        this.indexRange = new FindexRange(xobjectArray, block, xMPenv);
    }

    public FindexRange getIndexRange() {
        if (this.indexRange == null) {
            this._setIndexRange();
        }
        return this.indexRange;
    }

    private void _setCoindexRange() {
        Xobject[] xobjectArray = this.getCoshape();
        this.coindexRange = new FindexRange(xobjectArray, (Block)this.fblock, this.env);
    }

    private void _setCoindexRange(Block block, XMPenv xMPenv) {
        Xobject[] xobjectArray = this.getCoshape();
        this.coindexRange = new FindexRange(xobjectArray, block, xMPenv);
    }

    public FindexRange getCoindexRange() {
        if (this.coindexRange == null) {
            this._setCoindexRange();
        }
        return this.coindexRange;
    }

    public int getElementLengthOrNot() {
        Xobject xobject = this.getElementLengthExpr_runtime();
        if (xobject == null || !xobject.isIntConstant()) {
            return -1;
        }
        return xobject.getInt();
    }

    public int getElementLength() {
        int n = this.getElementLengthOrNot();
        if (n < 0) {
            XMP.fatal("current restriction: could not numerically evaluate the element length of: " + this.name);
        }
        return n;
    }

    public Xobject getElementLengthExpr_atmost() {
        int n = this.getElementLength_atmost(this.ident.Type());
        return Xcons.IntConstant(n);
    }

    public int getElementLength_atmost(Xtype xtype) {
        switch (xtype.getKind()) {
            case 8: {
                Xtype xtype2 = xtype.getBaseRefType();
                return this._getLength_atmost(xtype2);
            }
        }
        return this._getLength_atmost(xtype);
    }

    private int _getLength_atmost(Xtype xtype) {
        if (xtype.isFpointer()) {
            return this._getPointerComponentLength_atmost(xtype);
        }
        if (xtype.isFallocatable()) {
            return this._getAllocatableComponentLength_atmost(xtype);
        }
        return this._getStaticDataLength_atmost(xtype);
    }

    private int _getPointerComponentLength_atmost(Xtype xtype) {
        int n = this.getRank(xtype);
        int n2 = n == 0 ? 8 : 24 * n + 24;
        return n2;
    }

    private int _getAllocatableComponentLength_atmost(Xtype xtype) {
        return this._getPointerComponentLength_atmost(xtype);
    }

    private int _getStaticDataLength_atmost(Xtype xtype) {
        switch (xtype.getKind()) {
            case 1: {
                return xtype.getElementLength(this.getFblock());
            }
            case 8: {
                Xtype xtype2 = xtype.getBaseRefType();
                int n = this.getElementLength_atmost(xtype2);
                int n2 = this.getTotalArraySize(xtype);
                return n2 * n;
            }
            case 3: {
                this._DEBUG_ALIGN("Into DerivedType " + xtype);
                int n = this._getStructLength_atmost(xtype);
                this._DEBUG_ALIGN("Out of DerivedType " + xtype);
                return n;
            }
        }
        XMP.fatal("INTERNAL: unexpected Xtype kind (" + xtype.getKind() + ")");
        return 0;
    }

    private int _getNumElements(Xtype xtype, Block block) {
        int n = xtype.getKind() == 8 ? this.getTotalArraySize(xtype) : 1;
        return n;
    }

    private int _getStructLength_atmost(Xtype xtype) {
        int n = 0;
        int n2 = 1;
        for (Xobject xobject : xtype.getMemberList()) {
            int n3;
            int n4;
            Xtype xtype2 = xobject.Type();
            if (xtype2.isFpointer()) {
                n4 = this._getPointerComponentLength_atmost(xtype2);
                n3 = 1;
                this._DEBUG_ALIGN("  pointer member:" + xobject + ", length=" + n4);
            } else if (xtype2.isFallocatable()) {
                n4 = this._getAllocatableComponentLength_atmost(xtype2);
                n3 = 1;
                this._DEBUG_ALIGN("  allocatable member:" + xobject + ", length=" + n4);
            } else {
                n4 = this.getElementLength_atmost(xtype2);
                n3 = this._getNumElements(xtype2, this.getFblock());
                this._DEBUG_ALIGN("  static member:" + xobject + ", element length=" + n4 + ", num elements=" + n3);
            }
            int n5 = n4 > 4 ? 8 : (n4 > 2 ? 4 : (n4 > 1 ? 2 : 1));
            if (n % n5 != 0) {
                n = (n / n5 + 1) * n5;
                this._DEBUG_ALIGN("  skip for alignment upto " + n);
            }
            this._DEBUG_ALIGN("  proceed upto " + (n += n4 * n3));
            if (n2 >= n5) continue;
            n2 = n5;
        }
        if (n % n2 != 0) {
            n = (n / n2 + 1) * n2;
        }
        this._DEBUG_ALIGN("  finally proceed upto " + n);
        return n;
    }

    public Xobject getElementLengthExpr_runtime() {
        Xobject xobject = this.ident.Type().getElementLengthExpr(this.getFblock());
        if (xobject != null) {
            return xobject;
        }
        xobject = this._getDerivedTypeLengthExpr_runtime();
        return xobject;
    }

    private Xobject _getDerivedTypeLengthExpr_runtime() {
        Xobject xobject;
        int n = this.getRank();
        if (n == 0) {
            xobject = Xcons.FvarRef(this.ident);
        } else {
            xobject = Xcons.FarrayRef(this.ident.Ref(), new Xobject[0]);
            for (int i = 0; i < n; ++i) {
                Xobject xobject2 = this.getLbound(i);
                Xobject xobject3 = Xcons.FarrayIndex(xobject2);
                xobject.getArg(1).setArg(i, xobject3);
            }
        }
        Xobject xobject4 = this._buildSizeofExpr(xobject);
        return xobject4;
    }

    private Xobject _buildSizeofExpr(Xobject xobject) {
        Ident ident = this.declIntExtendIntrinsicIdent("sizeof");
        Xobject xobject2 = ident.Call(Xcons.List(xobject));
        return xobject2;
    }

    private Xobject _buildSizeofExpr__OLD__(Xobject xobject) {
        Ident ident = this.declIntIntrinsicIdent("size");
        Ident ident2 = this.declIntIntrinsicIdent("transfer");
        XobjString xobjString = Xcons.FcharacterConstant(Xtype.FcharacterType, " ", null);
        XobjList xobjList = Xcons.List(Xcode.F_ARRAY_CONSTRUCTOR, this._getCharFarrayType(1), xobjString);
        Xobject xobject2 = ident2.Call(Xcons.List(xobject, xobjList));
        Xobject xobject3 = ident.Call(Xcons.List(xobject2));
        return xobject3;
    }

    public int getTotalArraySize() {
        return this.getTotalArraySize(this.getIndexRange());
    }

    public int getTotalArraySize(Xtype xtype) {
        if (xtype.getKind() != 8) {
            XMP.fatal("INTERNAL ERROR: FarrayType expected here");
        }
        Xobject[] xobjectArray = this.getShape((FarrayType)xtype);
        FindexRange findexRange = new FindexRange(xobjectArray, (Block)this.getFblock(), this.getEnv());
        return this.getTotalArraySize(findexRange);
    }

    public int getTotalArraySize(FindexRange findexRange) {
        Xobject xobject = this.getTotalArraySizeExpr(findexRange);
        if (!xobject.isIntConstant()) {
            XMP.error("current restriction: cannot numerically evaluate the total size of: " + this.name);
            return 0;
        }
        return xobject.getInt();
    }

    public Xobject getTotalArraySizeExpr() {
        FindexRange findexRange = this.getIndexRange();
        return this.getTotalArraySizeExpr(findexRange);
    }

    public Xobject getTotalArraySizeExpr(Xtype xtype) {
        if (xtype.getKind() != 8) {
            XMP.fatal("INTERNAL ERROR: FarrayType expected here");
        }
        Xobject[] xobjectArray = this.getShape((FarrayType)xtype);
        FindexRange findexRange = new FindexRange(xobjectArray, (Block)this.getFblock(), this.getEnv());
        return this.getTotalArraySizeExpr(findexRange);
    }

    public Xobject getTotalArraySizeExpr(FindexRange findexRange) {
        Xobject xobject = findexRange.getTotalArraySizeExpr();
        if (xobject == null) {
            XMP.error("current restriction: cannot find the total size of: " + this.name);
        }
        return xobject;
    }

    public int getRank() {
        return this.ident.Type().getNumDimensions();
    }

    private int getRank(Xtype xtype) {
        if (xtype.getKind() == 8) {
            return xtype.getNumDimensions();
        }
        return 0;
    }

    public Xobject[] getShape() {
        if (this.getRank() == 0) {
            return new Xobject[0];
        }
        FarrayType farrayType = (FarrayType)this.ident.Type();
        return farrayType.getFarraySizeExpr();
    }

    private Xobject[] getShape(FarrayType farrayType) {
        return farrayType.getFarraySizeExpr();
    }

    public Xobject getLboundStatic(int n) {
        if (this.isExplicitShape().booleanValue()) {
            FarrayType farrayType = (FarrayType)this.ident.Type();
            return farrayType.getLbound(n, this.fblock);
        }
        return null;
    }

    public Xobject getUboundStatic(int n) {
        if (this.isExplicitShape().booleanValue()) {
            FarrayType farrayType = (FarrayType)this.ident.Type();
            return farrayType.getUbound(n, this.fblock);
        }
        return null;
    }

    public Xobject getLbound(int n) {
        Xobject xobject = this.getLboundStatic(n);
        if (xobject == null) {
            XobjString xobjString = Xcons.Symbol(Xcode.VAR, this.name);
            XobjInt xobjInt = Xcons.IntConstant(n + 1);
            Ident ident = this.declIntIntrinsicIdent("lbound");
            xobject = ident.Call(Xcons.List(xobjString, xobjInt));
        }
        return xobject;
    }

    public Xobject getUbound(int n) {
        Xobject xobject = this.getUboundStatic(n);
        if (xobject == null) {
            XobjString xobjString = Xcons.Symbol(Xcode.VAR, this.name);
            XobjInt xobjInt = Xcons.IntConstant(n + 1);
            Ident ident = this.declIntIntrinsicIdent("ubound");
            xobject = ident.Call(Xcons.List(xobjString, xobjInt));
        }
        return xobject;
    }

    public Xobject getSizeFromLbUb(Xobject xobject, Xobject xobject2) {
        return this.getIndexRange().getSizeFromLbUb(xobject, xobject2);
    }

    public Xobject getSizeFromIndexRange(Xobject xobject) {
        Xobject xobject2 = xobject.getArg(0);
        Xobject xobject3 = xobject.getArg(1);
        Xobject xobject4 = xobject.getArg(2);
        return this.getIndexRange().getSizeFromTriplet(xobject2, xobject3, xobject4);
    }

    public Xobject getSizeFromTriplet(int n, Xobject xobject, Xobject xobject2, Xobject xobject3) {
        return this.getIndexRange().getSizeFromTriplet(n, xobject, xobject2, xobject3);
    }

    public int getCorank() {
        return this.ident.Type().getCorank();
    }

    public Xobject[] getCoshape() {
        return this.ident.Type().getCodimensions();
    }

    public Xobject getLcoboundStatic(int n) {
        FindexRange findexRange = this.getCoindexRange();
        return findexRange == null ? null : findexRange.getLbound(n);
    }

    public Xobject getUcoboundStatic(int n) {
        FindexRange findexRange = this.getCoindexRange();
        return findexRange == null ? null : findexRange.getUbound(n);
    }

    public Xobject getCosizeStatic(int n) {
        FindexRange findexRange = this.getCoindexRange();
        return findexRange == null ? null : findexRange.getExtent(n);
    }

    public Xobject getLcobound(int n) {
        Xobject xobject = this.getLcoboundStatic(n);
        if (xobject == null) {
            Ident ident = this.descPtrId;
            XobjInt xobjInt = Xcons.IntConstant(n + 1);
            Ident ident2 = this.getEnv().findVarIdent(XMPF_LCOBOUND, null);
            if (ident2 == null) {
                ident2 = this.getEnv().declExternIdent(XMPF_LCOBOUND, Xtype.FintFunctionType);
            }
            xobject = ident2.Call(Xcons.List(ident, xobjInt));
        }
        return xobject;
    }

    public Xobject getUcobound(int n) {
        Xobject xobject = this.getUcoboundStatic(n);
        if (xobject == null) {
            Ident ident = this.descPtrId;
            XobjInt xobjInt = Xcons.IntConstant(n + 1);
            Ident ident2 = this.getEnv().findVarIdent(XMPF_UCOBOUND, null);
            if (ident2 == null) {
                ident2 = this.getEnv().declExternIdent(XMPF_UCOBOUND, Xtype.FintFunctionType);
            }
            xobject = ident2.Call(Xcons.List(ident, xobjInt));
        }
        return xobject;
    }

    public Xobject getCosize(int n) {
        Xobject xobject = this.getCosizeStatic(n);
        if (xobject == null) {
            Ident ident = this.descPtrId;
            XobjInt xobjInt = Xcons.IntConstant(n + 1);
            Ident ident2 = this.getEnv().findVarIdent(XMPF_COSIZE, null);
            if (ident2 == null) {
                ident2 = this.getEnv().declExternIdent(XMPF_COSIZE, Xtype.FintFunctionType);
            }
            xobject = ident2.Call(Xcons.List(ident, xobjInt));
        }
        return xobject;
    }

    public Xobject getImageIndex(Xobject xobject, Xobject xobject2) {
        Xobject xobject3;
        if (!this.isAllocatable().booleanValue() && (xobject3 = this.getImageIndex_opt(xobject, xobject2)) != null) {
            return xobject3;
        }
        xobject3 = this.getImageIndex_default(xobject, xobject2);
        return xobject3;
    }

    public Xobject getImageIndex_opt(Xobject xobject, Xobject xobject2) {
        Xobject xobject3;
        Xobject xobject4;
        int n = this.getCorank();
        Object var4_4 = null;
        int n2 = n - 1;
        Xobject xobject5 = xobject2.getArg(n2).getArg(0);
        Xobject xobject6 = this._calcMinusExprExpr(xobject5, xobject4 = this.getLcoboundStatic(n2));
        if (xobject6 == null) {
            return null;
        }
        for (n2 = n - 2; n2 >= 0; --n2) {
            Xobject xobject7 = this.getCosizeStatic(n2);
            xobject3 = this._calcTimesExprExpr(xobject6, xobject7);
            if (xobject3 == null) {
                return null;
            }
            xobject5 = xobject2.getArg(n2).getArg(0);
            Xobject xobject8 = this._calcMinusExprExpr(xobject5, xobject4 = this.getLcoboundStatic(n2));
            if (xobject8 == null) {
                return null;
            }
            xobject6 = this._calcPlusExprExpr(xobject3, xobject8);
            if (xobject6 != null) continue;
            return null;
        }
        xobject3 = this._calcIncExpr(xobject6);
        return xobject3;
    }

    public Xobject getImageIndex_default(Xobject xobject, Xobject xobject2) {
        String string = GET_IMAGE_INDEX_NAME;
        Ident ident = this.getEnv().findVarIdent(string, null);
        if (ident == null) {
            ident = this.getEnv().declExternIdent(string, Xtype.FintFunctionType);
        }
        XobjList xobjList = Xcons.List(this.getDescPointerIdExpr(xobject));
        for (Xobject xobject3 : (XobjList)xobject2) {
            xobjList.add(xobject3);
        }
        if (xobjList.hasNullArg()) {
            XMP.fatal("generated null argument " + string + "(getImageIndex)");
        }
        return ident.Call(xobjList);
    }

    Xobject _calcIntDiffExprExpr(Xobject xobject, Xobject xobject2) {
        Xobject xobject3;
        if (xobject == null || xobject2 == null) {
            return null;
        }
        Xobject xobject4 = xobject.cfold(this.fblock);
        Xobject xobject5 = xobject2.cfold(this.fblock);
        if (xobject5.equals(xobject4)) {
            return Xcons.IntConstant(1);
        }
        if (xobject4.isIntConstant()) {
            if (xobject5.isIntConstant()) {
                int n = xobject5.getInt() - xobject4.getInt() + 1;
                return Xcons.IntConstant(n);
            }
            XobjInt xobjInt = Xcons.IntConstant(xobject4.getInt() - 1);
            xobject3 = Xcons.binaryOp(Xcode.MINUS_EXPR, xobject5, xobjInt);
        } else if (xobject5.isIntConstant()) {
            XobjInt xobjInt = Xcons.IntConstant(xobject5.getInt() + 1);
            xobject3 = Xcons.binaryOp(Xcode.MINUS_EXPR, xobjInt, xobject4);
        } else {
            Xobject xobject6 = Xcons.binaryOp(Xcode.MINUS_EXPR, xobject5, xobject4);
            xobject3 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject6, Xcons.IntConstant(1));
        }
        return xobject3.cfold(this.fblock);
    }

    Xobject _calcTimesExprExpr(Xobject xobject, Xobject xobject2) {
        if (xobject == null || xobject2 == null) {
            return null;
        }
        Xobject xobject3 = xobject.cfold(this.fblock);
        Xobject xobject4 = xobject2.cfold(this.fblock);
        if (xobject3.isIntConstant()) {
            if (xobject4.isIntConstant()) {
                int n = xobject3.getInt() * xobject4.getInt();
                return Xcons.IntConstant(n);
            }
            int n = xobject3.getInt();
            if (n == 1) {
                return xobject4;
            }
            if (n == 0) {
                return xobject3;
            }
        } else if (xobject4.isIntConstant()) {
            int n = xobject4.getInt();
            if (n == 1) {
                return xobject3;
            }
            if (n == 0) {
                return xobject4;
            }
        }
        Xobject xobject5 = Xcons.binaryOp(Xcode.MUL_EXPR, xobject3, xobject4);
        return xobject5.cfold(this.fblock);
    }

    Xobject _calcPlusExprExpr(Xobject xobject, Xobject xobject2) {
        int n;
        if (xobject == null || xobject2 == null) {
            return null;
        }
        Xobject xobject3 = xobject.cfold(this.fblock);
        Xobject xobject4 = xobject2.cfold(this.fblock);
        if (xobject3.isIntConstant()) {
            if (xobject4.isIntConstant()) {
                int n2 = xobject3.getInt() + xobject4.getInt();
                return Xcons.IntConstant(n2);
            }
            int n3 = xobject3.getInt();
            if (n3 == 0) {
                return xobject4;
            }
        } else if (xobject4.isIntConstant() && (n = xobject4.getInt()) == 0) {
            return xobject3;
        }
        Xobject xobject5 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject3, xobject4);
        return xobject5.cfold(this.fblock);
    }

    Xobject _calcMinusExprExpr(Xobject xobject, Xobject xobject2) {
        if (xobject == null || xobject2 == null) {
            return null;
        }
        Xobject xobject3 = xobject.cfold(this.fblock);
        Xobject xobject4 = xobject2.cfold(this.fblock);
        if (xobject3.isIntConstant()) {
            if (xobject4.isIntConstant()) {
                int n = xobject3.getInt() - xobject4.getInt();
                return Xcons.IntConstant(n);
            }
        } else if (xobject4.isIntConstant() && xobject4.getInt() == 0) {
            return xobject3;
        }
        Xobject xobject5 = Xcons.binaryOp(Xcode.MINUS_EXPR, xobject3, xobject4);
        return xobject5.cfold(this.fblock);
    }

    Xobject _calcIncExpr(Xobject xobject) {
        if (xobject == null) {
            return null;
        }
        Xobject xobject2 = xobject.cfold(this.fblock);
        if (xobject2.isIntConstant()) {
            int n = xobject2.getInt() + 1;
            return Xcons.IntConstant(n);
        }
        Xobject xobject3 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject2, Xcons.IntConstant(1));
        return xobject3.cfold(this.fblock);
    }

    private Ident declIntIntrinsicIdent(String string) {
        FunctionType functionType = new FunctionType(Xtype.FintType, 524288L);
        Ident ident = this.getEnv().declIntrinsicIdent(string, functionType);
        return ident;
    }

    private Ident declIntExtendIntrinsicIdent(String string) {
        FunctionType functionType = new FunctionType(Xtype.FintType, 524288L);
        Ident ident = this.getEnv().declIntrinsicIdent(string, functionType);
        return ident;
    }

    public Boolean isScalar() {
        return this.ident.Type().getNumDimensions() == 0;
    }

    public Boolean isAllocatable() {
        return this.isAllocatable;
    }

    public void setAllocatable() {
        this.ident.Type().setIsFallocatable(true);
    }

    public void resetAllocatable() {
        Xtype xtype = this.ident.Type();
        while (xtype != null) {
            xtype.setIsFallocatable(false);
            if (xtype.copied != null) {
                xtype = xtype.copied;
                continue;
            }
            if (xtype.isBasic() || xtype.isStruct()) break;
            xtype = xtype.getRef();
        }
    }

    public void resetSaveAttr() {
        this._resetSaveAttrInType(this.ident.Type());
        if (this.ident.getStorageClass() == StorageClass.FSAVE) {
            this.ident.setStorageClass(StorageClass.FLOCAL);
        }
    }

    public void setSaveAttr() {
        this._setSaveAttrInType(this.ident.Type());
        this.ident.setStorageClass(StorageClass.FSAVE);
    }

    public void setSaveAttrToDescPointer() {
        this._setSaveAttrInType(this.getDescPointerId().Type());
        this.getDescPointerId().setStorageClass(StorageClass.FSAVE);
    }

    public void setZeroToDescPointer() {
        XobjInt xobjInt = Xcons.IntConstant(0, Xtype.intType, "8");
        this.getDescPointerId().setFparamValue(Xcons.List(xobjInt, null));
    }

    private void _setSaveAttrInType(Xtype xtype) {
        xtype.setIsFsave(true);
    }

    private void _resetSaveAttrInType(Xtype xtype) {
        xtype.setIsFsave(false);
        if (xtype.copied != null) {
            this._resetSaveAttrInType(xtype.copied);
        }
        if (xtype.isArray() || xtype.isFarray()) {
            this._resetSaveAttrInType(xtype.getRef());
        }
    }

    public Boolean isPointer() {
        return this.isPointer;
    }

    public void setPointer() {
        this.ident.Type().setIsFpointer(true);
    }

    public void resetPointer() {
        Xtype xtype = this.ident.Type();
        while (xtype != null) {
            xtype.setIsFpointer(false);
            if (xtype.copied != null) {
                xtype = xtype.copied;
                continue;
            }
            if (xtype.isBasic()) break;
            xtype = xtype.getRef();
        }
    }

    public Boolean isDummyArg() {
        if (this.ident.getStorageClass() == StorageClass.FPARAM) {
            return true;
        }
        return false;
    }

    public Boolean isAssumedSize() {
        return this.ident.Type().isFassumedSize();
    }

    public Boolean isAssumedShape() {
        return this.ident.Type().isFassumedShape();
    }

    public Boolean isExplicitShape() {
        return this.isAssumedSize() == false && this.isAssumedShape() == false && this.isAllocatable() == false && this.isPointer() == false;
    }

    public Boolean isUseAssociated() {
        return this.isUseAssociated;
    }

    public Ident getIdent() {
        return this.ident;
    }

    public void setIdentEtc(Ident ident) {
        this.ident = ident;
        this.name = ident.getName();
        this.isAllocatable = ident.Type().isFallocatable();
        this.isPointer = ident.Type().isFpointer();
        this.isUseAssociated = ident.getFdeclaredModule() != null;
        this.nodesName = XMPcoarray.getProp_nodes(ident);
        this.nodesDescId = this._getNodesDescIdByName(this.nodesName);
    }

    private Ident _getNodesDescIdByName(String string) {
        return this._getNodesDescIdByName(string, this.env, this.fblock);
    }

    private Ident _getNodesDescIdByName(String string, XMPenv xMPenv, FunctionBlock functionBlock) {
        if (string != null) {
            XMPnodes xMPnodes = xMPenv.findXMPnodes(string, this.ident.getDeclaredBlock() != null ? this.ident.getDeclaredBlock().getParent() : functionBlock);
            return xMPnodes.getDescId();
        }
        return null;
    }

    public XobjectDef getDef() {
        return this.def;
    }

    public FunctionBlock getFblock() {
        return this.fblock;
    }

    public XMPenv getEnv() {
        return this.env;
    }

    public String getHomeBlockCodeName() {
        return this.homeBlockCodeName;
    }

    public String getDescCommonName() {
        String string = "xmpf_descptr_" + this.homeBlockCodeName + "_" + this._getCodeFromName(this.getName());
        return string;
    }

    public String getCrayCommonName() {
        String string = "xmpf_crayptr_" + this.homeBlockCodeName + "_" + this._getCodeFromName(this.getName());
        return string;
    }

    public String getCoarrayCommonName() {
        String string = "xmpf_coarrayvar_" + this.homeBlockCodeName + "_" + this._getCodeFromName(this.getName());
        return string;
    }

    public String getCrayPointerName() {
        if (this._crayPtrName == null) {
            this._crayPtrName = "xmpf_crayptr_" + this.name;
        }
        return this._crayPtrName;
    }

    public Ident getCrayPointerId() {
        if (this.descPtrId == null) {
            XMP.warning("INTERNAL: illegal null crayPtrId (XMPcoppy.getCrayPointerId)");
            return null;
        }
        return this.crayPtrId;
    }

    public String getDescPointerName() {
        if (this._descPtrName == null) {
            this._descPtrName = "xmpf_descptr_" + this.name;
        }
        return this._descPtrName;
    }

    public Ident getDescPointerId() {
        Ident ident = this.env.findVarIdent(this._descPtrName, this.fblock);
        return ident;
    }

    public String getCoarrayCommName() {
        if (this._coarrayCommName == null) {
            this._coarrayCommName = "xmpf_coarraynodes_" + this.name;
        }
        return this._coarrayCommName;
    }

    public Ident getCoarrayCommId() {
        if (this.coarrayCommId == null) {
            XMP.warning("INTERNAL: illegal null coarrayCommId (XMPcoppy.getCoarrayCommId)");
            return null;
        }
        return this.coarrayCommId;
    }

    public Xobject getDescPointerIdExpr(Xobject xobject) {
        if (this.descPtrId != null) {
            return this.descPtrId;
        }
        Ident ident = this.getEnv().declExternIdent(GET_DESCR_ID_NAME, Xtype.FintFunctionType);
        Xobject xobject2 = ident.Call(Xcons.List(xobject));
        return xobject2;
    }

    public Xobject[] getCodimensions() {
        Xobject[] xobjectArray = this.ident.Type().getCodimensions();
        return xobjectArray;
    }

    public void setCodimensions(Xobject[] xobjectArray) {
        this.ident.Type().setCodimensions(xobjectArray);
    }

    public void removeCodimensions() {
        this.ident.Type().removeCodimensions();
    }

    public void hideCodimensions() {
        this.ident.Type().setIsCoarray(false);
    }

    public String getName() {
        return this.ident.getName();
    }

    public Xtype getType() {
        return this.ident.Type();
    }

    public void setWasMovedFromModule(Boolean bl) {
        this._wasMovedFromModule = bl;
    }

    public Boolean wasMovedFromModule() {
        return this._wasMovedFromModule;
    }

    public static XMPcoarray findCoarrayInCoarrays(String string, ArrayList<XMPcoarray> arrayList) {
        for (XMPcoarray xMPcoarray : arrayList) {
            if (xMPcoarray.getName() != string) continue;
            return xMPcoarray;
        }
        return null;
    }

    public String toString() {
        String string = "\n  Ident ident = " + this.ident + "\n  String name = " + this.name + "\n  FindexRange indexRange = " + this.indexRange + "\n  FindexRange coindexRange = " + this.coindexRange + "\n  Boolean isAllocatable = " + this.isAllocatable + "\n  Boolean isPointer = " + this.isPointer + "\n  Boolean isUseAssociated = " + this.isUseAssociated + "\n  Boolean useMalloc = " + this.useMalloc + "\n  Boolean _wasMovedFromModule = " + this._wasMovedFromModule + "\n  String _crayPtrName = " + this._crayPtrName + "\n  Ident crayPtrId = " + this.crayPtrId + "\n  String _descPtrName = " + this._descPtrName + "\n  Ident descPtrId = " + this.descPtrId + "\n  String homeBlockCodeName = " + this.homeBlockCodeName + "\n  XMPenv env = " + this.env + "\n  XobjectDef def = " + this.def + ": name=" + this.def.getName() + "\n  FunctionBlock fblock: name=" + this.def.getName();
        return string;
    }

    public Ident unlinkIdent() {
        return this.unlinkIdent(this.def);
    }

    public Ident unlinkIdent(XobjectDef xobjectDef) {
        return this.unlinkIdent((XobjList)xobjectDef.getDef());
    }

    public Ident unlinkIdent(XobjList xobjList) {
        XobjArgs xobjArgs = xobjList.getIdentList().getArgs();
        XobjArgs xobjArgs2 = null;
        XobjArgs xobjArgs3 = null;
        for (XobjArgs xobjArgs4 = xobjArgs; xobjArgs4 != null; xobjArgs4 = xobjArgs4.nextArgs()) {
            Xobject xobject = xobjArgs4.getArg();
            Ident ident = (Ident)xobject;
            if (ident == this.ident) {
                xobjArgs3 = xobjArgs4;
                break;
            }
            if (ident.getName().equals(this.name)) {
                XMP.fatal("unexpected matching of ident names: " + this.name);
                xobjArgs3 = xobjArgs4;
                break;
            }
            xobjArgs2 = xobjArgs4;
        }
        if (xobjArgs3 == null) {
            return null;
        }
        if (xobjArgs2 == null) {
            xobjList.getIdentList().setArgs(xobjArgs3.nextArgs());
        } else {
            xobjArgs2.setNext(xobjArgs3.nextArgs());
        }
        xobjArgs3.setNext(null);
        return (Ident)xobjArgs3.getArg();
    }

    private Xtype _getXtype() {
        Xtype xtype = this.ident.Type();
        if (xtype.getKind() == 8) {
            xtype = xtype.getRef();
        }
        return xtype;
    }

    public int getFtypeNumber() {
        return this._getXtype().getBasicType();
    }

    public Xobject getFkind() {
        return this._getXtype().getFkind();
    }

    public String getFtypeString() {
        return this.getFtypeString(this._getXtype());
    }

    public String getFtypeString(Xtype xtype) {
        Ftype ftype = new Ftype(xtype, (Block)this.fblock);
        return ftype.getNameOfConvFunction();
    }

    private Xtype _getCharFarrayType(int n) {
        BasicType basicType = Xtype.FcharacterType;
        FarrayType farrayType = Xtype.Farray(basicType, Xcons.IntConstant(n));
        return farrayType;
    }
}

