/*
 * Decompiled with CFR 0.152.
 */
package exc.xmpF;

import exc.block.BasicBlock;
import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockList;
import exc.block.PragmaBlock;
import exc.block.Statement;
import exc.object.Ident;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.xmpF.XMP;
import exc.xmpF.XMPdimInfo;
import exc.xmpF.XMPenv;
import exc.xmpF.XMPtemplate;
import java.util.Vector;

public class XMParray {
    private static final String XMP_ARRAY_PROP = "XMP_ARRAY_PROP";
    private Ident arrayId;
    private Block arrayIdBlock;
    private String name;
    private Xtype type;
    private Xtype elementType;
    private Ident localId;
    private Vector<XMPdimInfo> dims;
    private Ident descId;
    private XMPtemplate template;
    StorageClass sclass;
    boolean is_linearized = false;
    private int NthAssumedShape = -1;
    boolean shadow_declared = false;
    boolean is_saveDesc = false;

    public XMParray() {
    }

    public XMParray(XMParray xMParray, Ident ident, String string, Ident ident2) {
        this.arrayId = ident;
        this.name = string;
        this.type = xMParray.type;
        this.elementType = xMParray.elementType;
        this.localId = ident2;
        this.dims = xMParray.dims;
        this.descId = xMParray.descId;
        this.template = xMParray.template;
        this.sclass = xMParray.sclass;
    }

    public String toString() {
        String string = "{Array(" + this.name + ", id=" + this.arrayId + "):";
        string = string + this.dims;
        string = string + " localId:" + this.localId;
        return string + "}";
    }

    public String getName() {
        return this.name;
    }

    public Xtype getType() {
        return this.type;
    }

    public int getDim() {
        return this.dims.size();
    }

    public boolean isDistributed(int n) {
        int n2 = this.dims.elementAt(n).getAlignSubscriptIndex();
        if (n2 < 0) {
            return false;
        }
        return this.template.getDistMannerAt(n2) != 100;
    }

    public int getDistMannerAt(int n) {
        int n2 = this.dims.elementAt(n).getAlignSubscriptIndex();
        if (n2 < 0) {
            return -1;
        }
        return this.template.getDistMannerAt(n2);
    }

    public void setAlignSubscriptIndexAt(int n, int n2) {
        this.dims.elementAt((int)n2).align_subscript_index = n;
    }

    public int getAlignSubscriptIndexAt(int n) {
        return this.dims.elementAt((int)n).align_subscript_index;
    }

    public void setAlignSubscriptOffsetAt(Xobject xobject, int n) {
        this.dims.elementAt((int)n).align_subscript_offset = xobject;
    }

    public Xobject getAlignSubscriptOffsetAt(int n) {
        return this.dims.elementAt((int)n).align_subscript_offset;
    }

    public Ident getBlkOffsetVarAt(int n) {
        return this.dims.elementAt(n).getArrayBlkOffsetVar();
    }

    public void setShadow(int n, int n2, int n3) {
        this.dims.elementAt((int)n3).shadow_left = n;
        this.dims.elementAt((int)n3).shadow_right = n2;
    }

    public void setFullShadow(int n) {
        this.dims.elementAt((int)n).is_full_shadow = true;
    }

    public boolean isFullShadow(int n) {
        return this.dims.elementAt((int)n).is_full_shadow;
    }

    public boolean hasShadow(int n) {
        return this.dims.elementAt((int)n).is_full_shadow || this.dims.elementAt((int)n).shadow_left != 0 || this.dims.elementAt((int)n).shadow_right != 0;
    }

    public boolean hasShadow() {
        for (int i = 0; i < this.dims.size(); ++i) {
            if (!this.hasShadow(i)) continue;
            return true;
        }
        return false;
    }

    public int getShadowLeft(int n) {
        return this.dims.elementAt((int)n).shadow_left;
    }

    public int getShadowRight(int n) {
        return this.dims.elementAt((int)n).shadow_right;
    }

    public Ident getSizeVarAt(int n) {
        return this.dims.elementAt((int)n).a_dim_size_var;
    }

    public Ident getArrayId() {
        return this.arrayId;
    }

    public Ident getDescId() {
        return this.descId;
    }

    public XMPtemplate getAlignTemplate() {
        return this.template;
    }

    public Ident getLocalId() {
        return this.localId;
    }

    public void setLocalId(Ident ident) {
        this.localId = ident;
    }

    public Xtype getLocalType() {
        return this.localId.Type();
    }

    public String getLocalName() {
        return this.localId.getName();
    }

    public static XMParray getArray(Xobject xobject) {
        return (XMParray)xobject.getProp(XMP_ARRAY_PROP);
    }

    public static void setArray(Xobject xobject, XMParray xMParray) {
        xobject.setProp(XMP_ARRAY_PROP, xMParray);
    }

    public void setLinearized(boolean bl) {
        this.is_linearized = bl;
    }

    public boolean isSaveDesc() {
        return this.is_saveDesc;
    }

    public void setSaveDesc(boolean bl) {
        this.is_saveDesc = bl;
    }

    public boolean isLinearized() {
        return this.is_linearized;
    }

    public static void analyzeAlign(Xobject xobject, Xobject xobject2, Xobject xobject3, Xobject xobject4, XMPenv xMPenv, PragmaBlock pragmaBlock) {
        XMParray xMParray = new XMParray();
        xMParray.parseAlign(xobject, xobject2, xobject3, xobject4, xMPenv, pragmaBlock);
        xMPenv.declXMParray(xMParray, pragmaBlock);
    }

    /*
     * WARNING - void declaration
     */
    void parseAlign(Xobject xobject, Xobject xobject2, Xobject xobject3, Xobject xobject4, XMPenv xMPenv, PragmaBlock pragmaBlock) {
        int n;
        Xobject xobject5;
        this.name = xobject.getString();
        this.arrayId = xMPenv.findVarIdent(this.name, pragmaBlock);
        if (this.arrayId == null) {
            XMP.errorAt(pragmaBlock, "array '" + this.name + "' is not declared");
            return;
        }
        this.arrayIdBlock = xMPenv.findVarIdentBlock(this.name, pragmaBlock);
        this.type = this.arrayId.Type();
        if (this.type.getKind() != 8) {
            XMP.errorAt(pragmaBlock, this.name + " is not an array");
            return;
        }
        if (XMParray.getArray(this.arrayId) != null) {
            XMP.errorAt(pragmaBlock, "array '" + this.name + "' is already aligned");
            return;
        }
        if (XMP.debugFlag) {
            System.out.println("arrayId=" + this.arrayId);
        }
        this.sclass = this.arrayId.getStorageClass();
        if (XMP.debugFlag) {
            System.out.println("sclass=" + (Object)((Object)this.sclass));
        }
        switch (this.sclass) {
            case PARAM: 
            case EXTDEF: 
            case EXTERN: 
            case FLOCAL: 
            case FPARAM: 
            case FSAVE: {
                break;
            }
            default: {
                XMP.errorAt(pragmaBlock, "bad storage class of XMP array");
            }
        }
        String string = xobject3.getString();
        this.template = xMPenv.findXMPtemplate(string, pragmaBlock);
        if (this.template == null) {
            XMP.errorAt(pragmaBlock, "template '" + string + "' is not declared");
        }
        if (!this.template.isDistributed() && !this.type.isFallocatable()) {
            XMP.errorAt(pragmaBlock, "template '" + string + "' is not distributed");
        }
        if (XMP.hasError()) {
            return;
        }
        int n2 = this.template.getDim();
        int n3 = this.type.getNumDimensions();
        if (n3 > 15) {
            XMP.errorAt(pragmaBlock, "array dimension should be less than 16");
            return;
        }
        String string2 = "XMP_DESC_" + this.name;
        this.descId = xMPenv.declObjectId(string2, this.arrayIdBlock);
        this.elementType = this.type.getRef();
        Vector<XMPdimInfo> vector = XMPdimInfo.parseSubscripts(xobject2);
        Vector<XMPdimInfo> vector2 = XMPdimInfo.parseSubscripts(xobject4);
        for (XMPdimInfo xMPdimInfo : vector) {
            if (xMPdimInfo.isStar()) continue;
            if (xMPdimInfo.isTriplet()) {
                XMP.errorAt(pragmaBlock, "bad syntax in align source script");
                break;
            }
            xobject5 = xMPdimInfo.getIndex();
            if (xobject5.isVariable()) {
                for (XMPdimInfo object2 : vector) {
                    if (object2.isStar() || xobject5 == object2.getIndex() || !xobject5.equals(object2.getIndex())) continue;
                    XMP.errorAt(pragmaBlock, "same variable is found for '" + xobject5.getName() + "'");
                    break;
                }
                if (!XMP.hasError()) continue;
                break;
            }
            XMP.errorAt(pragmaBlock, "align source script must be variable");
        }
        block12: for (XMPdimInfo xMPdimInfo : vector2) {
            if (xMPdimInfo.isStar()) continue;
            if (xMPdimInfo.isTriplet()) {
                XMP.errorAt(pragmaBlock, "bad syntax in align script");
                break;
            }
            xobject5 = xMPdimInfo.getIndex();
            if (xobject5.isVariable()) continue;
            switch (xobject5.Opcode()) {
                case PLUS_EXPR: 
                case MINUS_EXPR: {
                    if (xobject5.left().isVariable()) continue block12;
                    XMP.errorAt(pragmaBlock, "left hand-side in align-subscript must be a variable");
                    continue block12;
                }
            }
            XMP.errorAt(pragmaBlock, "bad expression in align-subsript");
        }
        if (vector.size() != n3) {
            XMP.errorAt(pragmaBlock, "source dimension is different from array dimension");
        }
        if (XMP.hasError()) {
            return;
        }
        this.dims = new Vector();
        for (Xobject string3 : this.type.getFarraySizeExpr()) {
            this.dims.add(XMPdimInfo.createFromRange(string3));
        }
        for (n = 0; n < vector.size(); ++n) {
            void var18_33;
            XMPdimInfo xMPdimInfo = vector.elementAt(n);
            if (xMPdimInfo.isStar()) {
                this.dims.elementAt(n).setAlignSubscript(-1, null);
                continue;
            }
            xobject5 = xMPdimInfo.getIndex();
            int n4 = -1;
            Object var18_30 = null;
            for (int i = 0; i < vector2.size(); ++i) {
                Xobject xobject6 = vector2.elementAt(i).getIndex();
                if (xobject6 == null) continue;
                if (xobject6.isVariable()) {
                    if (!xobject6.equals(xobject5)) continue;
                    n4 = i;
                    break;
                }
                if (!xobject6.left().equals(xobject5)) continue;
                n4 = i;
                Xobject xobject7 = xobject6.right();
                if (xobject6.Opcode() != Xcode.MINUS_EXPR) break;
                Xobject xobject8 = Xcons.unaryOp(Xcode.UNARY_MINUS_EXPR, xobject7);
                break;
            }
            if (n4 < 0) {
                XMP.errorAt(pragmaBlock, "the associated align-subscript not found:" + xobject5.getName());
                continue;
            }
            this.dims.elementAt(n).setAlignSubscript(n4, (Xobject)var18_33);
        }
        n = 0;
        for (XMPdimInfo xMPdimInfo : this.dims) {
            xMPdimInfo.setArrayInfoVar(xMPenv.declIdent(string2 + "_size_" + n, Xtype.FintType, this.arrayIdBlock), xMPenv.declIdent(string2 + "_off_" + n, Xtype.FintType, this.arrayIdBlock), xMPenv.declIdent(string2 + "_blkoff_" + n, Xtype.FintType, this.arrayIdBlock));
            ++n;
        }
        Object object3 = null;
        switch (this.sclass) {
            case FPARAM: {
                Xtype xtype;
                if (this.type.isFallocatable()) {
                    XMP.errorAt(pragmaBlock, "allocatable dummy arrays cannot be distributed.");
                }
                if ((xtype = xMPenv.getCurrentDef().getDef().getNameObj().Type()).isFunction() && !xtype.isFsubroutine() && this.type.isFassumedShape()) {
                    XMP.fatal("assumed-shape distributed arrays in functions are not supported.");
                }
                if (xtype.isFsubroutine() && this.type.isFassumedShape()) {
                    XobjList xobjList = xMPenv.getCurrentDef().getBlock().getBody().getIdentList();
                    int n4 = 0;
                    for (Xobject xobject9 : xobjList) {
                        Ident ident = (Ident)xobject9;
                        if (!ident.Type().isFassumedShape()) continue;
                        if (ident.getSym().equals(this.name)) {
                            this.NthAssumedShape = n4;
                            break;
                        }
                        ++n4;
                    }
                    if (this.NthAssumedShape == -1) {
                        XMP.fatal("non-dummy argument cannot have a deferred shape.");
                    }
                    if (this.NthAssumedShape >= XMP.MAX_ASSUMED_SHAPE) {
                        XMP.fatal("too many assumed-shape arguments (MAX = " + XMP.MAX_ASSUMED_SHAPE + ").");
                    }
                }
                if (xMPenv.getCurrentDef().getDef().getParent() != null || this.NthAssumedShape >= 0 && this.NthAssumedShape < XMP.MAX_ASSUMED_SHAPE) {
                    Xobject[] xobjectArray = new Xobject[n3];
                    for (int i = 0; i < n3; ++i) {
                        xobjectArray[i] = this.isDistributed(i) ? Xcons.FindexRangeOfAssumedShape(Xcons.IntConstant(0)) : Xcons.FindexRangeOfAssumedShape(this.type.getFarraySizeExpr()[i].getArg(0));
                    }
                    object3 = Xtype.Farray(this.elementType, xobjectArray);
                    ((Xtype)object3).setTypeQualFlags(this.type.getTypeQualFlags());
                    break;
                }
                Xobject[] xobjectArray = new Xobject[]{Xcons.FindexRange(Xcons.IntConstant(0), Xcons.IntConstant(1))};
                object3 = Xtype.Farray(this.elementType, xobjectArray);
                this.setLinearized(true);
                break;
            }
            case FLOCAL: 
            case FSAVE: {
                void var18_36;
                Xobject[] xobjectArray = new Xobject[n3];
                boolean bl = false;
                while (var18_36 < n3) {
                    xobjectArray[var18_36] = Xcons.FindexRangeOfAssumedShape();
                    ++var18_36;
                }
                object3 = Xtype.Farray(this.elementType, xobjectArray);
                ((Xtype)object3).setTypeQualFlags(this.type.getTypeQualFlags());
                ((Xtype)object3).setIsFallocatable(true);
                break;
            }
            default: {
                XMP.fatal("XMP_array: unknown sclass");
            }
        }
        String string3 = "XMP__" + this.name;
        this.localId = xMPenv.declIdent(string3, (Xtype)object3, false, this.arrayIdBlock);
        this.localId.setStorageClass(this.arrayId.getStorageClass());
        this.localId.setValue(Xcons.Symbol(Xcode.VAR, (Xtype)object3, string3));
        XMParray.setArray(this.arrayId, this);
    }

    public static void analyzeShadow(Xobject xobject, Xobject xobject2, XMPenv xMPenv, PragmaBlock pragmaBlock) {
        if (!xobject.isVariable()) {
            XMP.errorAt(pragmaBlock, "shadow cannot applied to non-array");
            return;
        }
        String string = xobject.getString();
        Ident ident = xMPenv.findVarIdent(string, pragmaBlock);
        if (ident == null) {
            XMP.errorAt(pragmaBlock, "variable '" + string + "'for shadow  is not declared");
            return;
        }
        XMParray xMParray = XMParray.getArray(ident);
        if (xMParray == null) {
            XMP.errorAt(pragmaBlock, "array '" + string + "'for shadow  is not declared");
            return;
        }
        Vector<XMPdimInfo> vector = XMPdimInfo.parseSubscripts(xobject2);
        if (vector.size() != xMParray.getDim()) {
            XMP.errorAt(pragmaBlock, "shadow dimension size is different from array dimension");
            return;
        }
        if (xMParray.shadow_declared) {
            XMP.errorAt(pragmaBlock, "variable '" + string + "' already has shadow region");
        }
        xMParray.shadow_declared = true;
        for (int i = 0; i < vector.size(); ++i) {
            XMPdimInfo xMPdimInfo = vector.elementAt(i);
            int n = 0;
            int n2 = 0;
            if (xMPdimInfo.isStar()) {
                xMParray.setFullShadow(i);
                continue;
            }
            if (xMPdimInfo.isScalar()) {
                if (xMPdimInfo.getIndex().isIntConstant()) {
                    n2 = n = xMPdimInfo.getIndex().getInt();
                } else {
                    XMP.errorAt(pragmaBlock, "shadow width is not integer constant");
                }
            } else if (!xMPdimInfo.hasStride()) {
                if (xMPdimInfo.hasLower()) {
                    if (xMPdimInfo.getLower().isIntConstant()) {
                        n2 = xMPdimInfo.getLower().getInt();
                    } else {
                        XMP.errorAt(pragmaBlock, "shadow width(left) is not integer constant");
                    }
                } else {
                    XMP.errorAt(pragmaBlock, "no shadow width(left) is specified.");
                }
                if (xMPdimInfo.hasLower()) {
                    if (xMPdimInfo.getUpper().isIntConstant()) {
                        n = xMPdimInfo.getUpper().getInt();
                    } else {
                        XMP.errorAt(pragmaBlock, "shadow width(right) is not integer constant");
                    }
                } else {
                    XMP.errorAt(pragmaBlock, "no shadow width(right) is specified.");
                }
            } else {
                XMP.errorAt(pragmaBlock, "bad syntax in shadow");
                continue;
            }
            xMParray.setShadow(n2, n, i);
        }
    }

    public void buildConstructor(BlockList blockList, XMPenv xMPenv, Block block) {
        Xobject xobject;
        Xobject xobject2;
        Object object;
        int n;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (this.is_saveDesc && this.type.isFallocatable()) {
            XMP.fatal("an allocatable array cannot have the save_desc attribute.");
        }
        BlockList blockList2 = this.is_saveDesc && !xMPenv.currentDefIsModule() ? Bcons.emptyBody() : blockList;
        Ident ident = null;
        if (this.is_saveDesc && !xMPenv.currentDefIsModule()) {
            object6 = this.descId.Type().copy();
            ((Xtype)object6).setIsFsave(true);
            this.descId.setType((Xtype)object6);
            for (int i = 0; i < this.dims.size(); ++i) {
                object5 = this.dims.elementAt(i);
                Xtype xtype = ((XMPdimInfo)object5).getArraySizeVar().Type().copy();
                xtype.setIsFsave(true);
                ((XMPdimInfo)object5).getArraySizeVar().setType(xtype);
                object4 = ((XMPdimInfo)object5).getArrayOffsetVar().Type().copy();
                ((Xtype)object4).setIsFsave(true);
                ((XMPdimInfo)object5).getArrayOffsetVar().setType((Xtype)object4);
                object3 = ((XMPdimInfo)object5).getArrayBlkOffsetVar().Type().copy();
                ((Xtype)object3).setIsFsave(true);
                ((XMPdimInfo)object5).getArrayBlkOffsetVar().setType((Xtype)object3);
            }
            object2 = Xtype.FlogicalType.copy();
            ((Xtype)object2).setIsFsave(true);
            object5 = xMPenv.getCurrentDef().getBlock().getBody();
            ident = ((BlockList)object5).declLocalIdent("XMP_SAVE_" + this.name, (Xtype)object2, StorageClass.FSAVE, Xcons.List(Xcode.F_VALUE, Xcons.FlogicalConstant(false)));
        }
        object6 = xMPenv.declInternIdent("xmpf_array_alloc_", Xtype.FsubroutineType, block);
        object2 = Xcons.List(this.descId.Ref(), Xcons.IntConstant(this.dims.size()), XMP.typeIntConstant(this.elementType), this.template.getDescId().Ref());
        blockList2.add(((Ident)object6).callSubroutine((Xobject)object2));
        object6 = xMPenv.declInternIdent("xmp_f_init_allocated_", Xtype.FsubroutineType, block);
        object2 = Xcons.List(this.descId.Ref());
        blockList2.add(((Ident)object6).callSubroutine((Xobject)object2));
        if (this.type.isFallocatable()) {
            return;
        }
        object5 = null;
        if (this.type.isFassumedShape()) {
            object5 = xMPenv.declOrGetSizeArray(block);
        }
        object6 = xMPenv.declInternIdent("xmpf_align_info_", Xtype.FsubroutineType, block);
        for (n = 0; n < this.dims.size(); ++n) {
            object4 = this.dims.elementAt(n);
            object3 = ((XMPdimInfo)object4).getLower();
            object = null;
            if (((XMPdimInfo)object4).getUpper() == null && this.NthAssumedShape >= 0 && this.NthAssumedShape < XMP.MAX_ASSUMED_SHAPE) {
                object = Xcons.FarrayRef(((Ident)object5).Ref(), Xcons.IntConstant(this.NthAssumedShape), Xcons.IntConstant(n));
                object = Xcons.binaryOp(Xcode.PLUS_EXPR, (Xobject)object, (Xobject)object3);
                object = Xcons.binaryOp(Xcode.MINUS_EXPR, (Xobject)object, Xcons.IntConstant(1));
            } else {
                object = ((XMPdimInfo)object4).getUpper();
            }
            if (((XMPdimInfo)object4).isAlignAny()) {
                object2 = Xcons.List(new Xobject[]{this.descId.Ref(), Xcons.IntConstant(n), object3, object, Xcons.IntConstant(-1), Xcons.IntConstant(0)});
            } else {
                xobject2 = ((XMPdimInfo)object4).getAlignSubscriptOffset();
                if (xobject2 == null) {
                    xobject2 = Xcons.IntConstant(0);
                }
                object2 = Xcons.List(new Xobject[]{this.descId.Ref(), Xcons.IntConstant(n), object3, object, Xcons.IntConstant(((XMPdimInfo)object4).getAlignSubscriptIndex()), xobject2});
            }
            blockList2.add(((Ident)object6).callSubroutine((Xobject)object2));
        }
        if (this.hasShadow()) {
            object6 = xMPenv.declInternIdent("xmpf_array_init_shadow_", Xtype.FsubroutineType, block);
            for (n = 0; n < this.dims.size(); ++n) {
                if (!this.hasShadow(n)) continue;
                int n2 = this.getShadowLeft(n);
                int n3 = this.getShadowRight(n);
                if (this.isFullShadow(n)) {
                    n3 = -1;
                    n2 = -1;
                }
                object2 = Xcons.List(this.descId.Ref(), Xcons.IntConstant(n), Xcons.IntConstant(n2), Xcons.IntConstant(n3));
                blockList2.add(((Ident)object6).callSubroutine((Xobject)object2));
            }
        }
        object6 = xMPenv.declInternIdent("xmpf_array_init_", Xtype.FsubroutineType, block);
        blockList2.add(((Ident)object6).callSubroutine(Xcons.List(this.descId.Ref())));
        Xobject xobject3 = null;
        if (this.isLinearized()) {
            xobject = null;
            for (int i = 0; i < this.dims.size(); ++i) {
                object = this.dims.elementAt(i);
                object6 = xMPenv.declInternIdent("xmpf_array_get_local_size_off_", Xtype.FsubroutineType, block);
                blockList2.add(((Ident)object6).callSubroutine(Xcons.List(this.descId.Ref(), Xcons.IntConstant(i), ((XMPdimInfo)object).getArraySizeVar().Ref(), ((XMPdimInfo)object).getArrayOffsetVar().Ref(), ((XMPdimInfo)object).getArrayBlkOffsetVar().Ref())));
                xobject = xobject == null ? ((XMPdimInfo)object).getArraySizeVar().Ref() : Xcons.binaryOp(Xcode.MUL_EXPR, xobject, ((XMPdimInfo)object).getArraySizeVar().Ref());
            }
            Xobject xobject4 = Xcons.binaryOp(Xcode.MINUS_EXPR, xobject, Xcons.IntConstant(1));
            xobject3 = Xcons.Fallocate(this.localId.Ref(), Xcons.FindexRange(Xcons.IntConstant(0), xobject4));
        } else {
            xobject = Xcons.List();
            for (int i = 0; i < this.dims.size(); ++i) {
                object = this.dims.elementAt(i);
                object6 = xMPenv.declInternIdent("xmpf_array_get_local_size_off_", Xtype.FsubroutineType, block);
                blockList2.add(((Ident)object6).callSubroutine(Xcons.List(this.descId.Ref(), Xcons.IntConstant(i), ((XMPdimInfo)object).getArraySizeVar().Ref(), ((XMPdimInfo)object).getArrayOffsetVar().Ref(), ((XMPdimInfo)object).getArrayBlkOffsetVar().Ref())));
                if (this.isDistributed(i)) {
                    xobject2 = Xcons.binaryOp(Xcode.MINUS_EXPR, ((XMPdimInfo)object).getArraySizeVar().Ref(), Xcons.IntConstant(1));
                    ((XobjList)xobject).add(Xcons.FindexRange(Xcons.IntConstant(0), xobject2));
                    continue;
                }
                ((XobjList)xobject).add(Xcons.FindexRange(((XMPdimInfo)object).getLower(), ((XMPdimInfo)object).getArraySizeVar().Ref()));
            }
            xobject3 = Xcons.FallocateByList(this.localId.Ref(), (XobjList)xobject);
        }
        if (this.is_saveDesc && !xMPenv.currentDefIsModule()) {
            blockList2.add(Xcons.Set(ident.Ref(), Xcons.FlogicalConstant(true)));
            blockList.add(Bcons.IF(BasicBlock.Cond(Xcons.unaryOp(Xcode.LOG_NOT_EXPR, ident.Ref())), blockList2, null));
        }
        switch (this.sclass) {
            case FLOCAL: {
                blockList.add(xobject3);
                break;
            }
            case FSAVE: {
                xobject = xMPenv.FintrinsicIdent(Xtype.FlogicalFunctionType, "allocated").Call(Xcons.List(this.localId.Ref()));
                blockList.add(Bcons.IF(Xcons.unaryOp(Xcode.LOG_NOT_EXPR, xobject), xobject3, null));
            }
        }
        object6 = xMPenv.declInternIdent("xmpf_array_set_local_array_", Xtype.FsubroutineType, block);
        xobject = this.sclass == StorageClass.FSAVE ? Xcons.IntConstant(1) : Xcons.IntConstant(0);
        blockList.add(((Ident)object6).callSubroutine(Xcons.List(this.descId.Ref(), this.localId.Ref(), xobject)));
    }

    public void rewriteAllocate(XobjList xobjList, Statement statement, Block block, XMPenv xMPenv) {
        Xobject xobject;
        Xobject xobject2;
        int n;
        XobjList xobjList2 = (XobjList)xobjList.getArg(1);
        Xobject[] xobjectArray = new Xobject[this.dims.size()];
        Ident ident = xMPenv.declInternIdent("xmp_f_init_allocated_", Xtype.FsubroutineType, block);
        XobjList xobjList3 = Xcons.List(this.descId.Ref());
        statement.insert(ident.callSubroutine(xobjList3));
        ident = xMPenv.declInternIdent("xmpf_align_info_", Xtype.FsubroutineType, block);
        for (n = 0; n < this.dims.size(); ++n) {
            Xobject xobject3;
            XobjList xobjList4 = (XobjList)xobjList2.getArg(n);
            if (xobjList4.Nargs() == 1) {
                xobject3 = Xcons.IntConstant(1);
                xobject2 = xobjList4.getArg(0);
            } else {
                xobject3 = xobjList4.getArg(0);
                xobject2 = xobjList4.getArg(1);
            }
            xobjectArray[n] = xobject3;
            XMPdimInfo xMPdimInfo = this.dims.elementAt(n);
            if (xMPdimInfo.isAlignAny()) {
                xobjList3 = Xcons.List(this.descId.Ref(), Xcons.IntConstant(n), xobject3, xobject2, Xcons.IntConstant(-1), Xcons.IntConstant(0));
            } else {
                Xobject xobject4 = xMPdimInfo.getAlignSubscriptOffset();
                if (xobject4 == null) {
                    xobject4 = Xcons.IntConstant(0);
                }
                xobjList3 = Xcons.List(this.descId.Ref(), Xcons.IntConstant(n), xobject3, xobject2, Xcons.IntConstant(xMPdimInfo.getAlignSubscriptIndex()), xobject4);
            }
            statement.insert(ident.callSubroutine(xobjList3));
        }
        if (this.hasShadow()) {
            ident = xMPenv.declInternIdent("xmpf_array_init_shadow_", Xtype.FsubroutineType, block);
            for (n = 0; n < this.dims.size(); ++n) {
                if (!this.hasShadow(n)) continue;
                int n2 = this.getShadowLeft(n);
                int n3 = this.getShadowRight(n);
                if (this.isFullShadow(n)) {
                    n3 = -1;
                    n2 = -1;
                }
                xobjList3 = Xcons.List(this.descId.Ref(), Xcons.IntConstant(n), Xcons.IntConstant(n2), Xcons.IntConstant(n3));
                statement.insert(ident.callSubroutine(xobjList3));
            }
        }
        ident = xMPenv.declInternIdent("xmpf_array_init_", Xtype.FsubroutineType, block);
        statement.insert(ident.callSubroutine(Xcons.List(this.descId.Ref())));
        if (this.isLinearized()) {
            xobject = null;
            for (int i = 0; i < this.dims.size(); ++i) {
                XMPdimInfo xMPdimInfo = this.dims.elementAt(i);
                ident = xMPenv.declInternIdent("xmpf_array_get_local_size_off_", Xtype.FsubroutineType, block);
                statement.insert(ident.callSubroutine(Xcons.List(this.descId.Ref(), Xcons.IntConstant(i), xMPdimInfo.getArraySizeVar().Ref(), xMPdimInfo.getArrayOffsetVar().Ref(), xMPdimInfo.getArrayBlkOffsetVar().Ref())));
                xobject = xobject == null ? xMPdimInfo.getArraySizeVar().Ref() : Xcons.binaryOp(Xcode.MUL_EXPR, xobject, xMPdimInfo.getArraySizeVar().Ref());
            }
            Xobject xobject5 = Xcons.binaryOp(Xcode.MINUS_EXPR, xobject, Xcons.IntConstant(1));
            xobjList.setArg(0, this.localId.Ref());
            xobjList.setArg(1, Xcons.FindexRange(Xcons.IntConstant(0), xobject5));
        } else {
            xobject = Xcons.List();
            for (int i = 0; i < this.dims.size(); ++i) {
                XMPdimInfo xMPdimInfo = this.dims.elementAt(i);
                ident = xMPenv.declInternIdent("xmpf_array_get_local_size_off_", Xtype.FsubroutineType, block);
                statement.insert(ident.callSubroutine(Xcons.List(this.descId.Ref(), Xcons.IntConstant(i), xMPdimInfo.getArraySizeVar().Ref(), xMPdimInfo.getArrayOffsetVar().Ref(), xMPdimInfo.getArrayBlkOffsetVar().Ref())));
                if (this.isDistributed(i)) {
                    xobject2 = Xcons.binaryOp(Xcode.MINUS_EXPR, xMPdimInfo.getArraySizeVar().Ref(), Xcons.IntConstant(1));
                    ((XobjList)xobject).add(Xcons.FindexRange(Xcons.IntConstant(0), xobject2));
                    continue;
                }
                ((XobjList)xobject).add(Xcons.FindexRange(xobjectArray[i], xMPdimInfo.getArraySizeVar().Ref()));
            }
            xobjList.setArg(0, this.localId.Ref());
            xobjList.setArg(1, xobject);
        }
        ident = xMPenv.declInternIdent("xmpf_array_set_local_array_", Xtype.FsubroutineType, block);
        xobject = this.sclass == StorageClass.FSAVE ? Xcons.IntConstant(1) : Xcons.IntConstant(0);
        statement.add(ident.callSubroutine(Xcons.List(this.descId.Ref(), this.localId.Ref(), xobject)));
    }

    public void rewriteDeallocate(XobjList xobjList, Statement statement, Block block, XMPenv xMPenv) {
        Ident ident = xMPenv.declInternIdent("xmpf_array_deallocate_", Xtype.FsubroutineType, block);
        statement.insert(ident.callSubroutine(Xcons.List(this.descId.Ref())));
        xobjList.setArg(0, this.localId.Ref());
    }

    public void buildSetup(BlockList blockList, XMPenv xMPenv) {
    }

    public void buildDestructor(BlockList blockList, XMPenv xMPenv, Block block) {
        if (!this.is_saveDesc) {
            Ident ident = xMPenv.declInternIdent("xmpf_array_dealloc_", Xtype.FsubroutineType, block);
            XobjList xobjList = Xcons.List(this.descId.Ref());
            blockList.add(ident.callSubroutine(xobjList));
        }
    }

    public Xobject convertOffset(int n) {
        XMPdimInfo xMPdimInfo = this.dims.elementAt(n);
        if (!this.isDistributed(n)) {
            if (this.is_linearized) {
                return xMPdimInfo.getLower();
            }
            return null;
        }
        Xobject xobject = xMPdimInfo.getAlignSubscriptOffset();
        Xobject xobject2 = xMPdimInfo.getLower();
        Xobject xobject3 = this.getAlignTemplate().getLowerAt(xMPdimInfo.getAlignSubscriptIndex());
        if (xobject != null && !xobject.isZeroConstant() || !xobject2.equals(xobject3) || !this.getAlignTemplate().isFixed()) {
            return xMPdimInfo.getArrayOffsetVar().Ref();
        }
        return null;
    }

    public Xobject conertSize(int n) {
        XMPdimInfo xMPdimInfo = this.dims.elementAt(n);
        return xMPdimInfo.getArraySizeVar().Ref();
    }

    public Xobject convertLinearIndex(Xobject xobject) {
        Xobject xobject2 = null;
        for (int i = this.dims.size() - 1; i >= 0; --i) {
            XMPdimInfo xMPdimInfo = this.dims.elementAt(i);
            Xobject xobject3 = xobject.getArg(i);
            if (xobject3.Opcode() != Xcode.F_ARRAY_INDEX) {
                XMP.fatal("convertLinearIndex: not F_ARRAY_INDEX");
            }
            xobject3 = xobject3.getArg(0);
            xobject2 = xobject2 == null ? xobject3 : Xcons.binaryOp(Xcode.PLUS_EXPR, xobject2, xobject3);
            if (i == 0) continue;
            Xobject xobject4 = this.dims.elementAt(i - 1).getArraySizeVar().Ref();
            xobject2 = Xcons.binaryOp(Xcode.MUL_EXPR, xobject2, xobject4);
        }
        return Xcons.List(Xcons.FarrayIndex(xobject2));
    }
}

