/*
 * Decompiled with CFR 0.152.
 */
package exc.xmpF;

import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockIterator;
import exc.block.BlockList;
import exc.block.ForBlock;
import exc.block.FuncDefBlock;
import exc.block.FunctionBlock;
import exc.block.PragmaBlock;
import exc.block.Statement;
import exc.block.topdownBlockIterator;
import exc.object.FarrayType;
import exc.object.Ident;
import exc.object.PropObject;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjInt;
import exc.object.XobjList;
import exc.object.XobjString;
import exc.object.Xobject;
import exc.object.XobjectIterator;
import exc.object.Xtype;
import exc.object.topdownXobjectIterator;
import exc.xcalablemp.XMPutil;
import exc.xmpF.XMP;
import exc.xmpF.XMParray;
import exc.xmpF.XMPcoarray;
import exc.xmpF.XMPdimInfo;
import exc.xmpF.XMPenv;
import exc.xmpF.XMPinfo;
import exc.xmpF.XMPnodes;
import exc.xmpF.XMPobject;
import exc.xmpF.XMPobjectsRef;
import exc.xmpF.XMPpragma;
import exc.xmpF.XMPtemplate;
import exc.xmpF.XMPtransCoarrayRun;
import java.util.ArrayList;
import java.util.Vector;
import xcodeml.util.XmOption;

public class XMPanalyzePragma {
    XMPenv env;

    public void run(FuncDefBlock funcDefBlock, XMPenv xMPenv) {
        this.env = xMPenv;
        xMPenv.setCurrentDef(funcDefBlock);
        FunctionBlock functionBlock = funcDefBlock.getBlock();
        XMP.debug("pass1:");
        this.checkUseDecl(((Block)functionBlock).getBody().getDecls());
        Block block = ((Block)functionBlock).getBody().getHead();
        if (block == null) {
            return;
        }
        block.setProp("XMPprop", new XMPinfo(XMPpragma.FUNCTION_BODY, null, block, xMPenv));
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(functionBlock);
        ((BlockIterator)topdownBlockIterator2).init();
        while (!((BlockIterator)topdownBlockIterator2).end()) {
            block = topdownBlockIterator2.getBlock();
            if (XMP.debugFlag) {
                System.out.println("pass1=" + block);
            }
            if (block.Opcode() == Xcode.XMP_PRAGMA) {
                PragmaBlock pragmaBlock = (PragmaBlock)block;
                if (XMPpragma.valueOf(pragmaBlock.getPragma()) == XMPpragma.GMOVE) {
                    this.analyzePragma(pragmaBlock);
                }
                if (XMPpragma.valueOf(pragmaBlock.getPragma()) == XMPpragma.ARRAY && (block = this.analyzeArray(pragmaBlock)) != null) {
                    topdownBlockIterator2.setBlock(block);
                }
                this.analyzePragma((PragmaBlock)block);
            }
            ((BlockIterator)topdownBlockIterator2).next();
        }
    }

    private void checkUseDecl(Xobject xobject) {
        if (xobject == null) {
            return;
        }
        for (Xobject xobject2 : (XobjList)xobject) {
            if (xobject2.Opcode() != Xcode.F_USE_DECL) continue;
            String string = xobject2.getArg(0).getName();
            this.env.useModule(string);
            this.env.findModule(string);
        }
    }

    private void analyzePragma(PragmaBlock pragmaBlock) {
        Object object;
        String string = pragmaBlock.getPragma();
        if (XMP.debugFlag) {
            System.out.println("Pragma: " + string);
            System.out.println(" Clause= " + pragmaBlock.getClauses());
            System.out.println(" Body= " + pragmaBlock.getBody());
        }
        XMPinfo xMPinfo = null;
        for (object = pragmaBlock.getParentBlock(); object != null; object = ((Block)object).getParentBlock()) {
            if (((Block)object).Opcode() != Xcode.XMP_PRAGMA) continue;
            xMPinfo = (XMPinfo)((PropObject)object).getProp("XMPprop");
        }
        object = new XMPinfo(XMPpragma.valueOf(pragmaBlock.getPragma()), xMPinfo, pragmaBlock, this.env);
        pragmaBlock.setProp("XMPprop", object);
        XMPpragma xMPpragma = ((XMPinfo)object).pragma;
        block0 : switch (xMPpragma) {
            case NODES: {
                Xobject xobject = pragmaBlock.getClauses();
                XMPnodes.analyzePragma(xobject, this.env, pragmaBlock);
                break;
            }
            case TEMPLATE: {
                Xobject xobject = pragmaBlock.getClauses();
                XobjList xobjList = (XobjList)xobject.getArg(0);
                for (Xobject xobject2 : xobjList) {
                    XMPtemplate.analyzeTemplate(xobject2, xobject.getArg(1), this.env, pragmaBlock);
                }
                break;
            }
            case DISTRIBUTE: {
                Xobject xobject = pragmaBlock.getClauses();
                XobjList xobjList = (XobjList)xobject.getArg(0);
                Xobject xobject3 = xobject.copy();
                for (Xobject xobject4 : xobjList) {
                    XMPtemplate.analyzeDistribute(xobject4, xobject.getArg(1), xobject.getArg(2), this.env, pragmaBlock);
                }
                break;
            }
            case ALIGN: {
                Xobject xobject = pragmaBlock.getClauses();
                XobjList xobjList = (XobjList)xobject.getArg(0);
                for (Xobject xobject5 : xobjList) {
                    XMParray.analyzeAlign(xobject5, xobject.getArg(1), xobject.getArg(2), xobject.getArg(3), this.env, pragmaBlock);
                    if (!XMP.hasError()) continue;
                    break block0;
                }
                break;
            }
            case SHADOW: {
                Xobject xobject = pragmaBlock.getClauses();
                XobjList xobjList = (XobjList)xobject.getArg(0);
                Xobject xobject6 = xobject.getArg(1);
                for (Xobject xobject7 : xobjList) {
                    XMParray.analyzeShadow(xobject7, xobject6, this.env, pragmaBlock);
                    if (!XMP.hasError()) continue;
                    break block0;
                }
                break;
            }
            case LOCAL_ALIAS: {
                XMPanalyzePragma.analyzeLocalAlias(pragmaBlock.getClauses(), this.env, pragmaBlock);
                break;
            }
            case SAVE_DESC: {
                XobjList xobjList = (XobjList)pragmaBlock.getClauses();
                for (Xobject xobject : xobjList) {
                    String string2 = xobject.getString();
                    XMPobject xMPobject = this.env.findXMPobject(string2, pragmaBlock);
                    if (xMPobject != null) {
                        xMPobject.setSaveDesc(true);
                        continue;
                    }
                    Ident ident = this.env.findVarIdent(string2, pragmaBlock);
                    if (ident != null) {
                        XMParray xMParray = XMParray.getArray(ident);
                        if (xMParray != null) {
                            xMParray.setSaveDesc(true);
                            continue;
                        }
                        XMP.errorAt(pragmaBlock, "object '" + string2 + "' is not an aligned array");
                        continue;
                    }
                    XMP.errorAt(pragmaBlock, "object '" + string2 + "' is not declared");
                }
                break;
            }
            case TEMPLATE_FIX: {
                this.analyzeTemplateFix(pragmaBlock.getClauses(), (XMPinfo)object, pragmaBlock);
                break;
            }
            case LOOP: {
                Block block = null;
                XobjList xobjList = (XobjList)pragmaBlock.getClauses().getArg(2);
                if (xobjList != null && !xobjList.hasNullArg()) {
                    if (xobjList.getArg(0).getInt() == 411) {
                        block = XMPanalyzePragma.divideMarginLoop(pragmaBlock);
                    } else if (xobjList.getArg(0).getInt() == 412) {
                        block = XMPanalyzePragma.peelLoop(pragmaBlock);
                    }
                }
                if (block != null) {
                    Block block2 = block.getBody().getHead();
                    while (block2 != null) {
                        Block block3 = block2.getNext();
                        this.analyzePragma((PragmaBlock)block2);
                        block2 = block3;
                    }
                    pragmaBlock.replace(block);
                    break;
                }
                this.analyzeLoop(pragmaBlock.getClauses(), pragmaBlock.getBody(), pragmaBlock, (XMPinfo)object);
                break;
            }
            case REFLECT: 
            case REDUCE_SHADOW: {
                this.analyzeReflect(pragmaBlock.getClauses(), (XMPinfo)object, pragmaBlock);
                break;
            }
            case BARRIER: {
                this.analyzeBarrier(pragmaBlock.getClauses(), (XMPinfo)object, pragmaBlock);
                break;
            }
            case REDUCTION: {
                this.analyzeReduction(pragmaBlock.getClauses(), (XMPinfo)object, pragmaBlock);
                break;
            }
            case BCAST: {
                this.analyzeBcast(pragmaBlock.getClauses(), (XMPinfo)object, pragmaBlock);
                break;
            }
            case WAIT_ASYNC: {
                this.analyzeWaitAsync(pragmaBlock.getClauses(), (XMPinfo)object, pragmaBlock);
                break;
            }
            case TASK: {
                this.analyzeTask(pragmaBlock.getClauses(), pragmaBlock.getBody(), (XMPinfo)object, pragmaBlock);
                break;
            }
            case TASKS: {
                this.analyzeTasks(pragmaBlock.getClauses(), pragmaBlock.getBody(), (XMPinfo)object, pragmaBlock);
                break;
            }
            case GMOVE: {
                this.analyzeGmove(pragmaBlock.getClauses(), pragmaBlock.getBody(), (XMPinfo)object, pragmaBlock);
                break;
            }
            case COARRAY: {
                if (XmOption.isCoarray()) {
                    XMPcoarray.analyzeCoarrayDirective(pragmaBlock.getClauses(), this.env, pragmaBlock);
                    break;
                }
                XMP.error("coarray directive is specified.");
                break;
            }
            case IMAGE: {
                if (XmOption.isCoarray()) {
                    XMPtransCoarrayRun.analyzeImageDirective(pragmaBlock.getClauses(), this.env, pragmaBlock);
                    break;
                }
                XMP.error("image directive is specified.");
                break;
            }
            case ARRAY: {
                break;
            }
            default: {
                XMP.fatal("'" + string.toLowerCase() + "' directive is not supported yet");
            }
        }
    }

    private static boolean isEqualVar(Xobject xobject, Xobject xobject2) {
        return xobject.isVariable() && xobject2.isVariable() && xobject.getName().equals(xobject2.getName());
    }

    public static void analyzeLocalAlias(Xobject xobject, XMPenv xMPenv, PragmaBlock pragmaBlock) {
        String string = xobject.getArg(1).getName();
        Ident ident = xMPenv.findVarIdent(string, pragmaBlock);
        if (ident == null) {
            XMP.errorAt(pragmaBlock, "global array '" + string + "' is not declared");
            return;
        }
        XMParray xMParray = XMParray.getArray(ident);
        if (xMParray == null) {
            XMP.errorAt(pragmaBlock, "global array '" + string + "' is not aligned");
            return;
        }
        String string2 = xobject.getArg(0).getName();
        Ident ident2 = xMPenv.findVarIdent(string2, pragmaBlock);
        if (ident2 == null) {
            XMP.errorAt(pragmaBlock, "local alias '" + string2 + "' is not declared");
            return;
        }
        XMParray xMParray2 = XMParray.getArray(ident2);
        if (xMParray2 != null) {
            XMP.errorAt(pragmaBlock, "local alias '" + string2 + "' is aligned");
            return;
        }
        FarrayType farrayType = (FarrayType)ident.Type();
        FarrayType farrayType2 = (FarrayType)ident2.Type();
        if (!farrayType2.isFassumedShape()) {
            XMP.errorAt(pragmaBlock, "local alias must be declared as an assumed-shape array.");
            return;
        }
        if (farrayType.getNumDimensions() != farrayType2.getNumDimensions()) {
            XMP.errorAt(pragmaBlock, "The rank is different between the global array and the local alias");
            return;
        }
        if (!farrayType.getRef().equals(farrayType2.getRef())) {
            XMP.errorAt(pragmaBlock, "The element type unmatched between the global array and the local alias");
            return;
        }
        Ident ident3 = xMParray.getLocalId();
        Xtype xtype = ident3.Type();
        StorageClass storageClass = ident3.getStorageClass();
        xMPenv.removeIdent(string2, pragmaBlock);
        xMPenv.removeIdent(ident3.getName(), pragmaBlock);
        Ident ident4 = xMPenv.declIdent(string2, xtype, false, pragmaBlock);
        ident4.setStorageClass(storageClass);
        ident4.setValue(Xcons.Symbol(Xcode.VAR, xtype, string2));
        xMParray.setLocalId(ident4);
    }

    private void analyzeTemplateFix(Xobject xobject, XMPinfo xMPinfo, PragmaBlock pragmaBlock) {
        XobjList xobjList = (XobjList)xobject.getArg(0);
        Xobject xobject2 = xobject.getArg(1);
        XobjList xobjList2 = (XobjList)xobject.getArg(2);
        String string = xobject2.getString();
        XMPtemplate xMPtemplate = this.env.findXMPtemplate(string, pragmaBlock);
        if (xMPtemplate == null) {
            XMP.errorAt(pragmaBlock, "template '" + string + "' is not declared");
            return;
        }
        if (xMPtemplate.isFixed()) {
            XMP.errorAt(pragmaBlock, "template '" + string + "' is alreday fixed");
        }
        if (!xobjList2.isEmptyList()) {
            for (int i = 0; i < xMPtemplate.getDim(); ++i) {
                if (xobjList2.getArg(i).Opcode() == Xcode.LIST) continue;
                xobjList2.setArg(i, Xcons.List(Xcons.IntConstant(1), xobjList2.getArg(i)));
            }
        }
        xMPinfo.setTemplateFix(xMPtemplate, xobjList2, xobjList);
    }

    void analyzeLoop(Xobject xobject, BlockList blockList, PragmaBlock pragmaBlock, XMPinfo xMPinfo) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Vector<XMPdimInfo> vector = new Vector<XMPdimInfo>();
        XobjList xobjList = (XobjList)xobject.getArg(0);
        if (xobjList == null || xobjList.Nargs() == 0) {
            object3 = (XobjList)xobject.getArg(1);
            Xobject xobject2 = (XobjList)((XobjList)object3).getArg(1);
            xobjList = XMPutil.getLoopIterListFromOnRef((XobjList)xobject2);
        }
        while ((object3 = XMPanalyzePragma.getOutermostLoopBlock(blockList)) != null) {
            boolean bl = false;
            for (Object object4 : xobjList) {
                if (((Xobject)object4).Opcode() == Xcode.LIST) {
                    object4 = ((Xobject)object4).getArg(0);
                }
                if (!XMPanalyzePragma.isEqualVar(object3.getInductionVar(), (Xobject)object4)) continue;
                bl = true;
                break;
            }
            if (bl) {
                vector.add(XMPdimInfo.loopInfo(object3));
            }
            blockList = object3.getBody();
        }
        for (Xobject xobject2 : xobjList) {
            if (xobject2.Opcode() == Xcode.LIST) {
                if (xobject2.getArgOrNull(1) != null || xobject2.getArgOrNull(2) != null) {
                    XMP.errorAt(pragmaBlock, "bad syntax in loop directive");
                }
                xobject2 = xobject2.getArg(0);
            }
            boolean bl = false;
            for (XMPdimInfo xMPdimInfo : vector) {
                if (!XMPanalyzePragma.isEqualVar(xMPdimInfo.getLoopVar(), xobject2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            XMP.errorAt(pragmaBlock, "loop index is not found in loop varaibles");
        }
        object3 = XMPobjectsRef.parseDecl(xobject.getArg(1), this.env, pragmaBlock);
        if (XMP.hasError()) {
            return;
        }
        boolean bl = false;
        Vector<XMPdimInfo> vector2 = ((XMPobjectsRef)object3).getSubscripts();
        for (int i = 0; i < vector2.size(); ++i) {
            XMPdimInfo xMPdimInfo;
            xMPdimInfo = vector2.elementAt(i);
            if (xMPdimInfo.isStar() || xMPdimInfo.isTriplet() || (object2 = xMPdimInfo.getIndex()) == null) continue;
            object = null;
            Xobject xobject3 = null;
            if (((Xobject)object2).isVariable()) {
                object = object2;
            } else {
                switch (((Xobject)object2).Opcode()) {
                    case PLUS_EXPR: 
                    case MINUS_EXPR: {
                        if (!((Xobject)object2).left().isVariable()) {
                            XMP.errorAt(pragmaBlock, "left-hand side in align-subscript must be a variable");
                            break;
                        }
                        object = ((Xobject)object2).left();
                        xobject3 = ((Xobject)object2).right();
                        if (((Xobject)object2).Opcode() != Xcode.MINUS_EXPR) break;
                        xobject3 = Xcons.unaryOp(Xcode.UNARY_MINUS_EXPR, xobject3);
                        break;
                    }
                    default: {
                        XMP.errorAt(pragmaBlock, "bad expression in subsript of on-ref");
                    }
                }
            }
            if (object == null) continue;
            int n2 = -1;
            for (int j = 0; j < vector.size(); ++j) {
                if (!XMPanalyzePragma.isEqualVar((Xobject)object, vector.elementAt(j).getLoopVar())) continue;
                n2 = j;
                vector.elementAt(j).setLoopOnIndex(i);
                break;
            }
            if (n2 < 0) {
                XMP.errorAt(pragmaBlock, "loop variable is not found in on_ref: '" + ((Xobject)object).getName() + "'");
            }
            xMPdimInfo.setLoopOnRefInfo(n2, xobject3);
        }
        XobjList xobjList2 = (XobjList)xobject.getArg(2);
        object2 = new Vector();
        if (xobjList2 == null || xobjList2.hasNullArg()) {
            n = 413;
        } else {
            n = xobjList2.getArg(0).getInt();
            for (Xobject xobject3 : (XobjList)xobjList2.getArg(1)) {
                XMPdimInfo xMPdimInfo = new XMPdimInfo();
                if (XMP.debugFlag) {
                    System.out.println("width = (" + xobject3.getArg(0) + ":" + xobject3.getArg(1) + ":" + xobject3.getArg(2) + ")");
                }
                xMPdimInfo.parse(xobject3);
                ((Vector)object2).add(xMPdimInfo);
            }
        }
        object = xobject.getArg(3);
        if (object != null) {
            this.analyzeReductionSpec(xMPinfo, (Xobject)object, pragmaBlock);
        }
        ((XMPobjectsRef)object3).setLoopDimInfo(vector);
        this.checkLocalizableLoop(vector, (XMPobjectsRef)object3, pragmaBlock);
        xMPinfo.setBody(blockList);
        xMPinfo.setLoopInfo(vector, (XMPobjectsRef)object3, n, (Vector<XMPdimInfo>)object2);
    }

    private static Block divideMarginLoop(PragmaBlock pragmaBlock) {
        BlockList blockList = Bcons.emptyBody();
        boolean bl = false;
        XobjList xobjList = (XobjList)pragmaBlock.getClauses().getArg(2);
        XobjList xobjList2 = null;
        XobjList xobjList3 = null;
        for (int i = 0; i < xobjList.getArg(1).Nargs(); ++i) {
            Xobject xobject;
            int n;
            Xobject xobject2 = xobjList.getArg(1).getArg(i);
            Xobject xobject3 = xobject2.getArg(0);
            Xobject xobject4 = xobject2.getArg(1);
            Xobject xobject5 = xobject2.getArg(2);
            if (xobject5.isIntConstant() && xobject5.getInt() == -1 || xobject3.isZeroConstant() || xobject4.isZeroConstant()) continue;
            bl = true;
            PragmaBlock pragmaBlock2 = (PragmaBlock)pragmaBlock.copy();
            xobjList2 = (XobjList)pragmaBlock2.getClauses().getArg(2);
            for (n = 0; n < xobjList2.getArg(1).Nargs(); ++n) {
                xobject = xobjList2.getArg(1).getArg(n);
                if (n == i) {
                    xobject.setArg(0, xobject3);
                    xobject.setArg(1, Xcons.IntConstant(0));
                    continue;
                }
                if (n > i) {
                    xobject.setArg(2, Xcons.IntConstant(-1));
                    continue;
                }
                xobject.setArg(0, Xcons.IntConstant(0));
                xobject.setArg(1, Xcons.IntConstant(0));
            }
            blockList.add(pragmaBlock2);
            PragmaBlock pragmaBlock3 = (PragmaBlock)pragmaBlock.copy();
            xobjList3 = (XobjList)pragmaBlock3.getClauses().getArg(2);
            for (n = 0; n < xobjList2.getArg(1).Nargs(); ++n) {
                xobject = xobjList3.getArg(1).getArg(n);
                if (n == i) {
                    xobject.setArg(0, Xcons.IntConstant(0));
                    xobject.setArg(1, xobject4);
                    continue;
                }
                if (n > i) {
                    xobject.setArg(2, Xcons.IntConstant(-1));
                    continue;
                }
                xobject.setArg(0, Xcons.IntConstant(0));
                xobject.setArg(1, Xcons.IntConstant(0));
            }
            blockList.add(pragmaBlock3);
        }
        if (bl) {
            return Bcons.COMPOUND(blockList);
        }
        return null;
    }

    private static Block peelLoop(PragmaBlock pragmaBlock) {
        BlockList blockList = Bcons.emptyBody();
        PragmaBlock pragmaBlock2 = (PragmaBlock)pragmaBlock.copy();
        pragmaBlock2.getClauses().getArg(2).setArg(0, Xcons.IntConstant(410));
        pragmaBlock2.getClauses().getArg(2).setArg(1, pragmaBlock.getClauses().getArg(2).getArg(2));
        blockList.add(pragmaBlock2);
        XobjList xobjList = Xcons.List();
        xobjList.add(Xcons.List(pragmaBlock.getClauses().getArg(2).getArg(1)));
        xobjList.add(null);
        PragmaBlock pragmaBlock3 = new PragmaBlock(Xcode.XMP_PRAGMA, "WAIT_ASYNC", xobjList, null);
        blockList.add(pragmaBlock3);
        PragmaBlock pragmaBlock4 = (PragmaBlock)pragmaBlock.copy();
        pragmaBlock4.getClauses().getArg(2).setArg(0, Xcons.IntConstant(411));
        pragmaBlock4.getClauses().getArg(2).setArg(1, pragmaBlock.getClauses().getArg(2).getArg(2));
        blockList.add(pragmaBlock4);
        return Bcons.COMPOUND(blockList);
    }

    private static ForBlock getOutermostLoopBlock(BlockList blockList) {
        for (Block block = blockList.getHead(); block != null; block = block.getNext()) {
            if (block.Opcode() == Xcode.F_DO_STATEMENT) {
                ForBlock forBlock = (ForBlock)((Object)block);
                forBlock.Canonicalize();
                if (!forBlock.isCanonical()) {
                    return null;
                }
                return forBlock;
            }
            if (block.Opcode() == Xcode.COMPOUND_STATEMENT) {
                return XMPanalyzePragma.getOutermostLoopBlock(block.getBody());
            }
            if (block.Opcode() != Xcode.OMP_PRAGMA && block.Opcode() != Xcode.ACC_PRAGMA) continue;
            return XMPanalyzePragma.getOutermostLoopBlock(block.getBody());
        }
        return null;
    }

    private void checkLocalizableLoop(Vector<XMPdimInfo> vector, XMPobjectsRef xMPobjectsRef, Block block) {
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            boolean bl = false;
            XMPdimInfo xMPdimInfo = vector.elementAt(i);
            if (xMPdimInfo.getStride().isOneConstant()) {
                bl = true;
            } else {
                if (!(xMPobjectsRef.getRefObject() instanceof XMPtemplate)) continue;
                object = (XMPtemplate)xMPobjectsRef.getRefObject();
                if (((XMPtemplate)object).isDistributed()) {
                    if (((XMPtemplate)object).getDistMannerAt(xMPdimInfo.getLoopOnIndex()) == 101) {
                        bl = true;
                    }
                } else {
                    XMP.errorAt(block, "template '" + ((XMPobject)object).getName() + "' is not distributed");
                }
            }
            if (XMP.debugFlag) {
                System.out.println("localizable(i=" + i + ")=" + bl);
            }
            if (!bl) continue;
            object = xMPdimInfo.getLoopVar();
            Ident ident = this.env.declIdent(XMP.genSym(((Xobject)object).getName()), ((Xobject)object).Type(), block);
            xMPdimInfo.setLoopLocalVar(ident);
        }
    }

    private void analyzeReflect(Xobject xobject, XMPinfo xMPinfo, PragmaBlock pragmaBlock) {
        Object object;
        XobjList xobjList = (XobjList)xobject.getArg(0);
        XobjList xobjList2 = (XobjList)xobject.getArg(1);
        Xobject xobject2 = xobject.getArg(2);
        Xobject xobject3 = xobject.getArg(3);
        Vector<XMParray> vector = new Vector<XMParray>();
        for (Object object2 : xobjList) {
            if (!((Xobject)object2).isVariable()) {
                XMP.errorAt(pragmaBlock, "Bad array name in reflect name list");
                continue;
            }
            Object object3 = ((Xobject)object2).getName();
            object = this.env.findVarIdent((String)object3, pragmaBlock);
            if (object == null) {
                XMP.errorAt(pragmaBlock, "variable '" + (String)object3 + "'for reflect is not declared");
                continue;
            }
            XMParray xMParray = XMParray.getArray((Xobject)object);
            if (xMParray == null) {
                XMP.errorAt(pragmaBlock, "array '" + (String)object3 + "'for reflect is not declared");
                continue;
            }
            vector.add(xMParray);
        }
        Vector vector2 = new Vector();
        for (Object object3 : xobjList2) {
            object = new XMPdimInfo();
            if (XMP.debugFlag) {
                System.out.println("width = (" + ((Xobject)object3).getArg(0) + ":" + ((Xobject)object3).getArg(1) + ":" + ((Xobject)object3).getArg(2) + ")");
            }
            ((XMPdimInfo)object).parse((Xobject)object3);
            vector2.add(object);
        }
        xMPinfo.setReflectArrays(vector, vector2);
        xMPinfo.setAsyncId(xobject2);
        xMPinfo.setAcc(xobject3);
        if (xMPinfo.isAcc() && !XmOption.isXcalableACC()) {
            XMP.errorAt(pragmaBlock, "Enable XcalableACC to use the acc clause");
        }
    }

    void analyzeBarrier(Xobject xobject, XMPinfo xMPinfo, PragmaBlock pragmaBlock) {
        Xobject xobject2 = xobject.getArg(0);
        Xobject xobject3 = xobject.getArg(1);
        if (xobject3 != null) {
            System.out.println("opt=" + xobject3);
            XMP.fatal("barrier opt is not supported yet, sorry!");
            return;
        }
        xMPinfo.setOnRef(XMPobjectsRef.parseDecl(xobject2, this.env, pragmaBlock));
    }

    void analyzeReduction(Xobject xobject, XMPinfo xMPinfo, PragmaBlock pragmaBlock) {
        Xobject xobject2 = xobject.getArg(0);
        Xobject xobject3 = xobject.getArg(1);
        Xobject xobject4 = xobject.getArg(2);
        Xobject xobject5 = xobject.getArg(3);
        this.analyzeReductionSpec(xMPinfo, xobject2, pragmaBlock);
        xMPinfo.setOnRef(XMPobjectsRef.parseDecl(xobject3, this.env, pragmaBlock));
        if (xobject4 != null && !XmOption.isAsync()) {
            XMP.errorAt(pragmaBlock, "MPI-3 is required to use the async clause on a reduction directive");
        }
        xMPinfo.setAsyncId(xobject4);
        xMPinfo.setAcc(xobject5);
        if (xMPinfo.isAcc() && !XmOption.isXcalableACC()) {
            XMP.errorAt(pragmaBlock, "Enable XcalableACC to use the acc clause");
        }
    }

    private void analyzeReductionSpec(XMPinfo xMPinfo, Xobject xobject, PragmaBlock pragmaBlock) {
        Xobject xobject2 = xobject.getArg(0);
        if (!xobject2.isIntConstant()) {
            XMP.fatal("reduction: op is not INT");
        }
        Vector<Ident> vector = new Vector<Ident>();
        Vector<Vector<Ident>> vector2 = new Vector<Vector<Ident>>();
        for (Xobject xobject3 : (XobjList)xobject.getArg(1)) {
            Ident ident;
            Xobject xobject4 = xobject3.getArg(0);
            if (!xobject4.isVariable()) {
                XMP.errorAt(pragmaBlock, "not variable in reduction spec list");
            }
            if ((ident = this.env.findVarIdent(xobject4.getName(), pragmaBlock)) == null) {
                XMP.errorAt(pragmaBlock, "variable '" + xobject4.getName() + "' in reduction is not found");
            }
            vector.add(ident);
            Vector<Ident> vector3 = new Vector<Ident>();
            if (xobject3.getArg(1) != null) {
                for (Xobject xobject5 : (XobjList)xobject3.getArg(1)) {
                    Ident ident2 = this.env.findVarIdent(xobject5.getName(), pragmaBlock);
                    if (ident2 == null) {
                        XMP.errorAt(pragmaBlock, "variable '" + xobject5.getName() + "' in reduction is not found");
                    }
                    vector3.add(ident2);
                }
            }
            vector2.add(vector3);
        }
        xMPinfo.setReductionInfo(xobject2.getInt(), vector, vector2);
    }

    private void analyzeBcast(Xobject xobject, XMPinfo xMPinfo, PragmaBlock pragmaBlock) {
        XobjList xobjList = (XobjList)xobject.getArg(0);
        Xobject xobject2 = xobject.getArg(1);
        Xobject xobject3 = xobject.getArg(2);
        Xobject xobject4 = xobject.getArg(3);
        Xobject xobject5 = xobject.getArg(4);
        Vector<Ident> vector = new Vector<Ident>();
        for (Xobject xobject6 : xobjList) {
            Ident ident;
            if (!xobject6.isVariable()) {
                XMP.errorAt(pragmaBlock, "not variable in bcast variable list");
            }
            if ((ident = this.env.findVarIdent(xobject6.getName(), pragmaBlock)) == null) {
                XMP.errorAt(pragmaBlock, "variable '" + xobject6.getName() + "' in reduction is not found");
            }
            vector.add(ident);
        }
        xMPinfo.setBcastInfo(XMPobjectsRef.parseDecl(xobject2, this.env, pragmaBlock), XMPobjectsRef.parseDecl(xobject3, this.env, pragmaBlock), vector);
        if (xobject4 != null && !XmOption.isAsync()) {
            XMP.errorAt(pragmaBlock, "MPI-3 is required to use the async clause on a bcast directive");
        }
        xMPinfo.setAsyncId(xobject4);
        xMPinfo.setAcc(xobject5);
        if (xMPinfo.isAcc() && !XmOption.isXcalableACC()) {
            XMP.errorAt(pragmaBlock, "Enable XcalableACC to use the acc clause");
        }
    }

    private void analyzeWaitAsync(Xobject xobject, XMPinfo xMPinfo, PragmaBlock pragmaBlock) {
        XobjList xobjList = (XobjList)xobject.getArg(0);
        Vector<Xobject> vector = new Vector<Xobject>();
        for (Xobject xobject2 : xobjList) {
            vector.add(xobject2);
        }
        xMPinfo.setWaitAsyncIds(vector);
        Xobject xobject3 = xobject.getArg(1);
        xMPinfo.setOnRef(XMPobjectsRef.parseDecl(xobject3, this.env, pragmaBlock));
    }

    void analyzeTask(Xobject xobject, BlockList blockList, XMPinfo xMPinfo, PragmaBlock pragmaBlock) {
        Xobject xobject2 = xobject.getArg(0);
        Xobject xobject3 = xobject.getArg(1);
        xMPinfo.setOnRef(XMPobjectsRef.parseDecl(xobject2, this.env, pragmaBlock));
        xMPinfo.setNocomm(xobject3);
    }

    private void analyzeTasks(Xobject xobject, BlockList blockList, XMPinfo xMPinfo, PragmaBlock pragmaBlock) {
    }

    private void analyzeGmove(Xobject xobject, BlockList blockList, XMPinfo xMPinfo, PragmaBlock pragmaBlock) {
        Xobject xobject2;
        Xobject xobject3 = xobject.getArg(0);
        Xobject xobject4 = xobject.getArg(1);
        Xobject xobject5 = xobject.getArg(2);
        Block block = blockList.getHead();
        if (block.getNext() != null) {
            XMP.fatal("not single block for Gmove");
        }
        Statement statement = block.getBasicBlock().getHead();
        if (block.Opcode() != Xcode.F_STATEMENT_LIST || statement.getNext() != null) {
            XMP.fatal("not single statment for Gmove");
        }
        if ((xobject2 = statement.getExpr()).Opcode() != Xcode.F_ASSIGN_STATEMENT) {
            XMP.fatal("not assignment for Gmove");
        }
        Xobject xobject6 = xobject2.left();
        Xobject xobject7 = xobject2.right();
        boolean bl = this.checkGmoveOperand(xobject6, xobject3.getInt() == 402, pragmaBlock);
        boolean bl2 = this.checkGmoveOperand(xobject7, xobject3.getInt() == 401, pragmaBlock);
        boolean bl3 = this.isScalar(xobject6);
        boolean bl4 = this.isScalar(xobject7);
        if (bl3 && !bl4) {
            XMP.fatal("Incompatible ranks in assignment.");
        }
        if (!bl2 && xobject3.getInt() == 401) {
            XMP.errorAt(pragmaBlock, "RHS should be global in GMOVE IN.");
        }
        if (!bl && xobject3.getInt() == 402) {
            XMP.errorAt(pragmaBlock, "LHS should be global in GMOVE OUT.");
        }
        if (!bl) {
            if (!bl2) {
                xMPinfo.setGmoveOperands(null, null);
                return;
            }
        } else if (bl && !bl2 && xobject3.getInt() == 400 && !bl3 && this.convertGmoveToArray(pragmaBlock, xobject6, xobject7)) {
            return;
        }
        if (XMP.hasError()) {
            return;
        }
        xMPinfo.setGmoveOperands(xobject6, xobject7);
        xMPinfo.setGmoveOpt(xobject3);
        if (xobject4 != null && !XmOption.isAsync()) {
            XMP.errorAt(pragmaBlock, "MPI-3 is required to use the async clause on a gmove directive");
        }
        xMPinfo.setAsyncId(xobject4);
        xMPinfo.setAcc(xobject5);
        if (xMPinfo.isAcc() && !XmOption.isXcalableACC()) {
            XMP.errorAt(pragmaBlock, "Enable XcalableACC to use the acc clause");
        }
    }

    private boolean checkGmoveOperand(Xobject xobject, boolean bl, PragmaBlock pragmaBlock) {
        Ident ident = null;
        XMParray xMParray = null;
        switch (xobject.Opcode()) {
            case F_ARRAY_REF: {
                Xobject xobject2 = xobject.getArg(0);
                if (xobject2.Opcode() != Xcode.F_VAR_REF) {
                    XMP.fatal("not F_VAR_REF for F_ARRAY_REF");
                }
                if ((xobject2 = xobject2.getArg(0)).Opcode() != Xcode.VAR) {
                    XMP.fatal("not VAR for F_VAR_REF");
                }
                if ((ident = this.env.findVarIdent(xobject2.getName(), pragmaBlock)) == null) {
                    XMP.fatal("array in F_ARRAY_REF is not declared");
                }
                if ((xMParray = XMParray.getArray(ident)) == null) break;
                if (bl && ident.getStorageClass() != StorageClass.FSAVE) {
                    XMP.fatal("Current limitation: Only a SAVE or MODULE variable can be the target of gmove in/out.");
                }
                if (XMPpragma.valueOf(pragmaBlock.getPragma()) != XMPpragma.ARRAY) {
                    xobject2.setProp("XMPRWprotected", xMParray);
                }
                return true;
            }
            case VAR: {
                ident = this.env.findVarIdent(xobject.getName(), pragmaBlock);
                if (ident == null) {
                    XMP.fatal("variable" + xobject.getName() + "is not declared");
                }
                if ((xMParray = XMParray.getArray(ident)) == null) break;
                if (bl && ident.getStorageClass() != StorageClass.FSAVE) {
                    XMP.fatal("Current limitation: Only a SAVE or MODULE variable can be the target of gmove in/out.");
                }
                if (XMPpragma.valueOf(pragmaBlock.getPragma()) != XMPpragma.ARRAY) {
                    xobject.setProp("XMPRWprotected", xMParray);
                }
                return true;
            }
            case F_LOGICAL_CONSTATNT: 
            case F_CHARACTER_CONSTATNT: 
            case F_COMPLEX_CONSTATNT: 
            case STRING_CONSTANT: 
            case INT_CONSTANT: 
            case FLOAT_CONSTANT: 
            case LONGLONG_CONSTANT: 
            case MOE_CONSTANT: {
                return false;
            }
            default: {
                XMP.errorAt(pragmaBlock, "gmove must be followed by simple assignment");
            }
        }
        return false;
    }

    private boolean isScalar(Xobject xobject) {
        switch (xobject.Opcode()) {
            case F_ARRAY_REF: {
                XobjList xobjList = (XobjList)xobject.getArg(1);
                Xobject xobject2 = xobject.getArg(0).getArg(0);
                int n = xobject2.Type().getNumDimensions();
                for (int i = 0; i < n; ++i) {
                    Xobject xobject3 = xobjList.getArg(i);
                    if (xobject3.Opcode() != Xcode.F_INDEX_RANGE) continue;
                    return false;
                }
                break;
            }
            case VAR: {
                if (xobject.Type().getKind() != 8) break;
                return false;
            }
        }
        return true;
    }

    private boolean convertGmoveToArray(PragmaBlock pragmaBlock, Xobject xobject, Xobject xobject2) {
        int n;
        pragmaBlock.setPragma("ARRAY");
        XobjList xobjList = Xcons.List();
        Xobject xobject3 = xobject.getArg(0).getArg(0);
        xobject3.remProp("XMPRWprotected");
        Ident ident = this.env.findVarIdent(xobject3.getName(), pragmaBlock);
        assert (ident != null);
        XMParray xMParray = XMParray.getArray(ident);
        assert (xMParray != null);
        XobjString xobjString = Xcons.Symbol(Xcode.VAR, xMParray.getAlignTemplate().getName());
        ((Xobject)xobjList).add(xobjString);
        XobjList xobjList2 = Xcons.List();
        for (n = 0; n < xMParray.getAlignTemplate().getDim(); ++n) {
            ((Xobject)xobjList2).add(null);
        }
        for (n = 0; n < xMParray.getDim(); ++n) {
            int n2 = xMParray.getAlignSubscriptIndexAt(n);
            Xobject xobject4 = xMParray.getAlignSubscriptOffsetAt(n);
            Xobject xobject5 = xobject.getArg(1).getArg(n).getArg(0);
            if (xobject4 != null) {
                xobject5 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject5, xobject4);
            }
            Xobject xobject6 = xobject.getArg(1).getArg(n).getArg(1);
            if (xobject4 != null) {
                xobject6 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject6, xobject4);
            }
            Xobject xobject7 = xobject.getArg(1).getArg(n).getArg(2);
            XobjList xobjList3 = Xcons.List(xobject5, xobject6, xobject7);
            ((Xobject)xobjList2).setArg(n2, xobjList3);
        }
        ((Xobject)xobjList).add(xobjList2);
        XobjList xobjList4 = Xcons.List(xobjList);
        pragmaBlock.setClauses(xobjList4);
        return true;
    }

    private Block analyzeArray(PragmaBlock pragmaBlock) {
        Xobject xobject;
        Xobject xobject2;
        Object object;
        Xobject xobject3 = pragmaBlock.getClauses();
        BlockList blockList = pragmaBlock.getBody();
        XMPinfo xMPinfo = null;
        for (object = pragmaBlock.getParentBlock(); object != null; object = ((Block)object).getParentBlock()) {
            if (((Block)object).Opcode() != Xcode.XMP_PRAGMA) continue;
            xMPinfo = (XMPinfo)((PropObject)object).getProp("XMPprop");
        }
        object = new XMPinfo(XMPpragma.ARRAY, xMPinfo, pragmaBlock, this.env);
        pragmaBlock.setProp("XMPprop", object);
        Xobject xobject4 = xobject3.getArg(0);
        Block block = blockList.getHead();
        if (block.getNext() != null) {
            XMP.fatal("not single block for Array");
        }
        Statement statement = block.getBasicBlock().getHead();
        if (block.Opcode() != Xcode.F_STATEMENT_LIST || statement.getNext() != null) {
            XMP.fatal("not single statment for Array");
        }
        if ((xobject2 = statement.getExpr()).Opcode() != Xcode.F_ASSIGN_STATEMENT) {
            XMP.fatal("not assignment for Array");
        }
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject2);
        ((XobjectIterator)topdownXobjectIterator2).init();
        while (!((XobjectIterator)topdownXobjectIterator2).end()) {
            xobject = topdownXobjectIterator2.getXobject();
            if (xobject != null && xobject.Opcode() == Xcode.VAR && xobject.Type().isFarray() && (((XobjectIterator)topdownXobjectIterator2).getParent() == null || ((XobjectIterator)topdownXobjectIterator2).getParent().Opcode() != Xcode.F_VAR_REF)) {
                ((XobjectIterator)topdownXobjectIterator2).setXobject(Xcons.FarrayRef(xobject, new Xobject[0]));
            }
            ((XobjectIterator)topdownXobjectIterator2).next();
        }
        xobject = xobject2.left();
        Xobject xobject5 = xobject2.right();
        boolean bl = this.checkGmoveOperand(xobject, false, pragmaBlock);
        if (XMP.hasError()) {
            return null;
        }
        ((XMPinfo)object).setGmoveOperands(xobject, xobject5);
        ((XMPinfo)object).setOnRef(XMPobjectsRef.parseDecl(xobject4, this.env, pragmaBlock));
        return this.convertArrayToLoop(pragmaBlock, (XMPinfo)object);
    }

    private Block convertArrayToLoop(PragmaBlock pragmaBlock, XMPinfo xMPinfo) {
        Object object;
        Object object2;
        Xobject xobject;
        Xobject xobject2;
        Object object3;
        Object object4;
        Object object5;
        Xobject xobject3;
        Xobject xobject4;
        Object object6;
        ArrayList<Ident> arrayList = new ArrayList<Ident>();
        ArrayList<Ident> arrayList2 = new ArrayList<Ident>(15);
        for (int i = 0; i < 15; ++i) {
            arrayList2.add(null);
        }
        ArrayList<Xobject> arrayList3 = new ArrayList<Xobject>();
        ArrayList<Xobject> arrayList4 = new ArrayList<Xobject>();
        ArrayList<Xobject[]> arrayList5 = new ArrayList<Xobject[]>();
        Xobject xobject5 = xMPinfo.getGmoveLeft();
        if (xobject5.Opcode() != Xcode.F_ARRAY_REF) {
            XMP.fatal(pragmaBlock, "ARRAY not followed by array ref.");
        }
        Xobject xobject6 = xobject5.getArg(0).getArg(0);
        int n = xobject6.Type().getNumDimensions();
        XobjList xobjList = (XobjList)xobject5.getArg(1);
        Xobject[] xobjectArray = xobject6.Type().getFarraySizeExpr();
        String string = xobject6.getName();
        Ident ident = this.env.findVarIdent(string, pragmaBlock);
        XMParray xMParray = XMParray.getArray(ident);
        for (int i = 0; i < n; ++i) {
            int n2;
            object6 = xobjList.getArg(i);
            if (((Xobject)object6).Opcode() == Xcode.F_ARRAY_INDEX || ((Xobject)object6).Opcode() != Xcode.F_INDEX_RANGE || (n2 = xMParray.getAlignSubscriptIndexAt(i)) == -1) continue;
            Ident ident2 = this.env.declIdent(XMP.genSym("loop_i"), Xtype.intType, pragmaBlock);
            arrayList.add(ident2);
            arrayList2.set(n2, ident2);
            xobject4 = ((XobjList)object6).getArg(0);
            if (xobject4 == null) {
                if (!xobject6.Type().isFallocatable()) {
                    xobject4 = xobjectArray[i].getArg(0);
                }
                if (xobject4 == null) {
                    xobject4 = this.env.declInternIdent("xmp_lbound", Xtype.FintFunctionType).Call(Xcons.List(xMParray.getDescId().Ref(), Xcons.IntConstant(i + 1)));
                }
            }
            if ((xobject3 = ((XobjList)object6).getArg(1)) == null) {
                if (!xobject6.Type().isFallocatable()) {
                    xobject3 = xobjectArray[i].getArg(1);
                }
                if (xobject3 == null) {
                    xobject3 = this.env.declInternIdent("xmp_ubound", Xtype.FintFunctionType).Call(Xcons.List(xMParray.getDescId().Ref(), Xcons.IntConstant(i + 1)));
                }
            }
            if ((object5 = ((XobjList)object6).getArg(2)) == null) {
                object5 = Xcons.IntConstant(1);
            }
            arrayList3.add(xobject4);
            arrayList4.add(xobject3);
            arrayList5.add((Xobject[])object5);
            object4 = Xcons.binaryOp(Xcode.MUL_EXPR, ident2.Ref(), (Xobject)object5);
            object4 = Xcons.binaryOp(Xcode.PLUS_EXPR, (Xobject)object4, xobject4);
            xobjList.setArg(i, Xcons.FarrayIndex((Xobject)object4));
        }
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xMPinfo.getGmoveRight());
        ((XobjectIterator)topdownXobjectIterator2).init();
        while (!((XobjectIterator)topdownXobjectIterator2).end()) {
            object6 = topdownXobjectIterator2.getXobject();
            if (((Xobject)object6).Opcode() == Xcode.F_ARRAY_REF) {
                int n3 = 0;
                xobject4 = ((Xobject)object6).getArg(0).getArg(0);
                xobject3 = (XobjList)((Xobject)object6).getArg(1);
                object5 = xobject4.Type().getFarraySizeExpr();
                String string2 = xobject4.getName();
                object4 = this.env.findVarIdent(string2, pragmaBlock);
                object3 = XMParray.getArray((Xobject)object4);
                for (int i = 0; i < xobject4.Type().getNumDimensions(); ++i) {
                    Xobject xobject7 = ((XobjList)xobject3).getArg(i);
                    if (xobject7.Opcode() != Xcode.F_INDEX_RANGE) continue;
                    xobject2 = ((XobjList)xobject7).getArg(0);
                    if (xobject2 == null) {
                        if (!xobject4.Type().isFallocatable()) {
                            xobject2 = object5[i].getArg(0);
                        }
                        if (xobject2 == null) {
                            xobject2 = this.env.declInternIdent("xmp_lbound", Xtype.FintFunctionType).Call(Xcons.List(((XMParray)object3).getDescId().Ref(), Xcons.IntConstant(i + 1)));
                        }
                    }
                    if ((xobject = ((XobjList)xobject7).getArg(2)) == null) {
                        xobject = Xcons.IntConstant(1);
                    }
                    if (object3 != null) {
                        int n4 = ((XMParray)object3).getAlignSubscriptIndexAt(i);
                        object2 = (Ident)arrayList2.get(n4);
                    } else {
                        object2 = (Ident)arrayList.get(n3);
                    }
                    if (object2 == null) {
                        XMP.fatal("array on rhs does not conform to that on lhs.");
                    }
                    object = Xcons.binaryOp(Xcode.MUL_EXPR, ((Ident)object2).Ref(), xobject);
                    object = Xcons.binaryOp(Xcode.PLUS_EXPR, (Xobject)object, xobject2);
                    ((XobjList)xobject3).setArg(i, Xcons.FarrayIndex((Xobject)object));
                    ++n3;
                }
            }
            ((XobjectIterator)topdownXobjectIterator2).next();
        }
        object6 = null;
        Object object7 = Bcons.emptyBody();
        ((BlockList)object7).add(Xcons.Set(xMPinfo.getGmoveLeft(), xMPinfo.getGmoveRight()));
        for (int i = 0; i < arrayList.size(); ++i) {
            object6 = Bcons.emptyBody();
            xobject3 = Xcons.binaryOp(Xcode.MINUS_EXPR, (Xobject)arrayList4.get(i), (Xobject)arrayList3.get(i));
            xobject3 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject3, (Xobject)arrayList5.get(i));
            xobject3 = Xcons.binaryOp(Xcode.DIV_EXPR, xobject3, (Xobject)arrayList5.get(i));
            xobject3 = Xcons.binaryOp(Xcode.MINUS_EXPR, xobject3, Xcons.IntConstant(1));
            ((BlockList)object6).add(Bcons.Fdo(((Ident)arrayList.get(i)).Ref(), Xcons.List(Xcons.IntConstant(0), xobject3, Xcons.IntConstant(1)), (BlockList)object7, null));
            object7 = object6;
        }
        XobjList xobjList2 = Xcons.List();
        xobject3 = Xcons.List();
        for (int i = 0; i < arrayList.size(); ++i) {
            ((XobjList)xobject3).add(((Ident)arrayList.get(i)).Ref());
        }
        ((Xobject)xobjList2).add(xobject3);
        XobjList xobjList3 = Xcons.List();
        String string3 = pragmaBlock.getClauses().getArg(0).getArg(0).getName();
        object4 = this.env.findXMPtemplate(string3, pragmaBlock);
        if (object4 == null) {
            XMP.errorAt(pragmaBlock, "template '" + string3 + "' not found");
        }
        ((Xobject)xobjList3).add(pragmaBlock.getClauses().getArg(0).getArg(0));
        object3 = Xcons.List();
        Xobject xobject8 = pragmaBlock.getClauses().getArg(0).getArg(1);
        if (xobject8 != null && !xobject8.isEmptyList()) {
            for (int i = 0; i < xobject8.Nargs(); ++i) {
                xobject2 = xobject8.getArg(i);
                if (xobject2.Opcode() == Xcode.LIST) {
                    Xobject xobject9;
                    xobject = ((XobjList)xobject2).getArg(0);
                    if (xobject == null) {
                        if (((XMPtemplate)object4).isFixed()) {
                            xobject = ((XMPtemplate)object4).getLowerAt(i);
                        } else {
                            object = this.env.declIdent(XMP.genSym("ret_"), Xtype.intType, pragmaBlock);
                            object2 = this.env.declIdent(XMP.genSym(((XMPobject)object4).getName() + "_lb"), Xtype.intType, pragmaBlock);
                            xobject9 = this.env.declInternIdent("xmp_template_lbound", Xtype.FintFunctionType);
                            XobjList xobjList4 = Xcons.List(((XMPobject)object4).getDescId().Ref(), Xcons.IntConstant(i + 1), ((Ident)object2).Ref());
                            pragmaBlock.insert(Xcons.Set(((Ident)object).Ref(), ((Ident)xobject9).Call(xobjList4)));
                            xobject = ((Ident)object2).Ref();
                        }
                    } else if (xobject.Opcode() == Xcode.VAR) {
                        object = xobject.getString();
                        object2 = this.env.findVarIdent((String)object, pragmaBlock);
                        if (object2 == null) {
                            XMP.errorAt(pragmaBlock, "variable '" + (String)object + "' is not declared");
                            return null;
                        }
                        xobject = ((Ident)object2).Ref();
                    }
                    object = ((XobjList)xobject2).getArg(2);
                    if (object != null) {
                        if (((Xobject)object).Opcode() == Xcode.INT_CONSTANT && ((XobjInt)object).getInt() == 0) {
                            ((Xobject)object3).add(xobject2);
                            continue;
                        }
                        if (((Xobject)object).Opcode() == Xcode.VAR) {
                            object2 = ((Xobject)object).getString();
                            xobject9 = this.env.findVarIdent((String)object2, pragmaBlock);
                            if (xobject9 == null) {
                                XMP.errorAt(pragmaBlock, "variable '" + (String)object2 + "' is not declared");
                                return null;
                            }
                            object = ((Ident)xobject9).Ref();
                        }
                    } else {
                        object = Xcons.IntConstant(1);
                    }
                    if ((object2 = (Ident)arrayList2.get(i)) != null) {
                        xobject9 = Xcons.binaryOp(Xcode.MUL_EXPR, ((Ident)object2).Ref(), (Xobject)object);
                        xobject9 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject9, xobject);
                        ((Xobject)object3).add(xobject9);
                        continue;
                    }
                    ((Xobject)object3).add(null);
                    continue;
                }
                ((Xobject)object3).add(xobject2);
            }
        } else {
            for (int i = 0; i < ((XMPobject)object4).getDim(); ++i) {
                if (((XMPtemplate)object4).isFixed()) {
                    xobject2 = ((XMPtemplate)object4).getLowerAt(i);
                } else {
                    xobject = this.env.declIdent(XMP.genSym("ret_"), Xtype.intType, pragmaBlock);
                    object = this.env.declIdent(XMP.genSym(((XMPobject)object4).getName() + "_lb"), Xtype.intType, pragmaBlock);
                    object2 = this.env.declInternIdent("xmp_template_lbound", Xtype.FintFunctionType);
                    XobjList xobjList5 = Xcons.List(((XMPobject)object4).getDescId().Ref(), Xcons.IntConstant(i + 1), ((Ident)object).Ref());
                    pragmaBlock.insert(Xcons.Set(((Ident)xobject).Ref(), ((Ident)object2).Call(xobjList5)));
                    xobject2 = ((Ident)object).Ref();
                }
                xobject = (Ident)arrayList2.get(i);
                if (xobject != null) {
                    object = Xcons.binaryOp(Xcode.PLUS_EXPR, ((Ident)xobject).Ref(), xobject2);
                    ((Xobject)object3).add((Xobject)object);
                    continue;
                }
                ((Xobject)object3).add(null);
            }
        }
        ((Xobject)xobjList3).add((Xobject)object3);
        ((Xobject)xobjList2).add(xobjList3);
        ((Xobject)xobjList2).add(null);
        ((Xobject)xobjList2).add(null);
        return Bcons.PRAGMA(Xcode.XMP_PRAGMA, "LOOP", xobjList2, (BlockList)object6);
    }
}

