/*
 * Decompiled with CFR 0.152.
 */
package exc.xcodeml;

import exc.object.BasicType;
import exc.object.CompositeType;
import exc.object.Ident;
import exc.object.PropObject;
import exc.object.StorageClass;
import exc.object.StructType;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjInt;
import exc.object.XobjList;
import exc.object.XobjString;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectDefEnv;
import exc.object.Xtype;
import exc.xcodeml.XcodeMLNameTable_C;
import exc.xcodeml.XmXobjectToXcodeTranslator;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import xcodeml.util.IXobject;
import xcodeml.util.XmLog;

public class XmcXobjectToXcodeTranslator
extends XmXobjectToXcodeTranslator {
    private XcodeMLNameTable_C nameTable = new XcodeMLNameTable_C();

    private Element transName(Xobject xobject) {
        Element element;
        if (xobject == null) {
            return null;
        }
        Element element2 = element = xobject instanceof XobjString && ((XobjString)xobject).isOp() ? this.createElement("operator", new String[0]) : this.createElement("name", new String[0]);
        if (xobject.Type() != null) {
            this.addAttributes(element, "type", xobject.Type().getXcodeCId());
        }
        if (xobject instanceof XobjString) {
            this.addAttributes(element, "fullName", ((XobjString)xobject).getAlias());
        }
        this.addChildNodes(element, this.trans(xobject.getString()));
        return element;
    }

    private Element transBody(Xobject xobject) {
        Element element = this.createElement("body", new String[0]);
        if (xobject != null) {
            if (xobject.Opcode() == Xcode.LIST) {
                for (Xobject xobject2 : (XobjList)xobject) {
                    this.addChildNodes(element, this.trans(xobject2));
                }
            } else {
                this.addChildNodes(element, this.trans(xobject));
            }
        }
        return element;
    }

    private Element transSymbols(Xobject xobject) {
        XobjList xobjList = (XobjList)xobject;
        Element element = this.createElement("symbols", new String[0]);
        if (xobjList != null) {
            for (Xobject xobject2 : xobjList) {
                this.addChildNodes(element, this.transIdent((Ident)xobject2));
            }
        }
        return element;
    }

    @Override
    protected Element transIdent(Ident ident) {
        if (ident == null) {
            return null;
        }
        Element element = this.createElement("id", new String[0]);
        if (ident.Type() != null) {
            this.addAttributes(element, "type", ident.Type().getXcodeCId());
        }
        Element element2 = ident.isOp() ? this.createElement("operator", new String[0]) : this.createElement("name", new String[0]);
        String string = ident.getFullName();
        if (string != null) {
            this.addAttributes(element2, "fullName", string);
        }
        this.addChildNodes(element, this.addChildNodes(element2, this.trans(ident.getName())));
        this.addAttributes(element, "access", ident.getAccessStr());
        if (ident.getStorageClass() != null) {
            this.addAttributes(element, "sclass", ident.getStorageClass().toXcodeString());
        }
        if (ident.getBitField() > 0) {
            this.addAttributes(element, "bit_field", "" + ident.getBitField());
        } else if (ident.getBitFieldExpr() != null) {
            this.addAttributes(element, "bit_field", "*");
            this.addChildNodes(element, this.addChildNodes(this.createElement("bitField", new String[0]), this.trans(ident.getBitFieldExpr())));
        }
        if (ident.isGccThread()) {
            this.addAttributes(element, "is_gccThread", "1");
        }
        if (ident.isGccExtension()) {
            this.addAttributes(element, "is_gccExtension", "1");
        }
        this.addChildNodes(element, this.transValue(ident.getEnumValue()));
        this.addChildNodes(element, this.transCodimensions(ident.getCodimensions()));
        this.addChildNodes(element, this.trans(ident.getGccAttributes()));
        return element;
    }

    private Node transValue(Xobject xobject) {
        if (xobject == null) {
            return null;
        }
        return this.addChildNodes(this.createElement("value", new String[0]), this.transValueChild(xobject));
    }

    private Node transValueChild(Xobject xobject) {
        if (xobject.Opcode() == Xcode.LIST) {
            Element element = this.createElement("value", new String[0]);
            for (Xobject xobject2 : (XobjList)xobject) {
                Node node = this.transValueChild(xobject2);
                if (node == null) continue;
                this.addChildNodes(element, node);
            }
            return element;
        }
        return this.trans(xobject);
    }

    private Node transCodimensions(Xobject xobject) {
        if (xobject == null) {
            return null;
        }
        Element element = this.createElement("codimensions", new String[0]);
        for (Xobject xobject2 : (XobjList)xobject) {
            if (xobject2.Opcode() == Xcode.LIST) {
                this.addChildNodes(element, this.createElement("list", new String[0]));
                continue;
            }
            this.addChildNodes(element, this.transExprOrError(xobject2));
        }
        return element;
    }

    private Element transFuncDefParams(XobjList xobjList, XobjList xobjList2) {
        Object object;
        Object object2;
        Element element = this.createElement("params", new String[0]);
        if (xobjList != null) {
            for (Xobject xobject : xobjList) {
                if (xobject == null) {
                    this.addChildNodes(element, this.createElement("ellipsis", new String[0]));
                    break;
                }
                if (xobject.Opcode() != Xcode.VAR_DECL) {
                    XmLog.fatal((String)("not VAR_DECL : " + xobject.toString()));
                }
                object2 = xobject.getArg(0).getName();
                object = null;
                for (Xobject xobject2 : xobjList2) {
                    if (!xobject2.getName().equals(object2)) continue;
                    object = xobject2.Type();
                    break;
                }
                Element element2 = this.addChildNodes(this.createElement("name", "type", ((Xtype)object).getXcodeCId()), this.trans((String)object2));
                this.addChildNodes(element, element2);
            }
        }
        if (xobjList2 != null) {
            for (Xobject xobject : xobjList2) {
                object2 = (Ident)xobject;
                if (((Ident)object2).isDeclared() || ((Ident)object2).getStorageClass() != StorageClass.PARAM) continue;
                object = this.addChildNodes(this.createElement("name", "type", ((Xobject)object2).Type().getXcodeCId()), this.trans(((Ident)object2).getName()));
                this.addChildNodes(element, new Node[]{object});
            }
        }
        return element;
    }

    private Element transDeclarations(Xobject xobject) {
        Element element = this.createElement("declarations", new String[0]);
        if (xobject != null) {
            for (Xobject xobject2 : (XobjList)xobject) {
                this.addChildNodes(element, this.transOrError(xobject2));
            }
        }
        return element;
    }

    private Element transExpr(Xobject xobject) {
        return this.trans(xobject);
    }

    private Node transCondition(Xobject xobject) {
        if (xobject == null) {
            return null;
        }
        return this.addChildNodes(this.createElement("condition", new String[0]), this.transExpr(xobject));
    }

    private Element transOrError(Xobject xobject) {
        if (xobject.Opcode() == Xcode.LIST && xobject.Nargs() == 0) {
            return null;
        }
        if (xobject == null) {
            throw new NullPointerException("xobj");
        }
        Element element = this.trans(xobject);
        if (element == null) {
            throw new NullPointerException("xobj : " + xobject.toString());
        }
        return element;
    }

    private Element transExprOrError(Xobject xobject) {
        return this.transOrError(xobject);
    }

    @Override
    protected Element transType(Xtype xtype) {
        Element element = null;
        if (xtype.copied != null) {
            element = this.createTypeElement("basicType", xtype, "name", xtype.copied.getXcodeCId());
        } else {
            switch (xtype.getKind()) {
                case 1: {
                    element = this.createTypeElement("basicType", xtype, "name", BasicType.getTypeInfo((int)xtype.getBasicType()).cname);
                    break;
                }
                case 2: {
                    element = this.addChildNodes(this.createTypeElement("enumType", xtype, new String[0]), this.transSymbols(xtype.getMemberList()));
                    break;
                }
                case 3: {
                    element = ((StructType)xtype).isClass() ? this.createTypeElement("classType", xtype, new String[0]) : this.createTypeElement("structType", xtype, new String[0]);
                    XobjString xobjString = ((CompositeType)xtype).getTagNames();
                    if (xobjString != null) {
                        Element element2 = this.transName(xobjString);
                        element = this.addChildNodes(element, element2);
                    }
                    element = this.addChildNodes(element, this.transSymbols(xtype.getMemberList()));
                    break;
                }
                case 4: {
                    element = this.addChildNodes(this.createTypeElement("unionType", xtype, new String[0]), this.transSymbols(xtype.getMemberList()));
                    break;
                }
                case 6: {
                    element = this.createTypeElement("arrayType", xtype, "element_type", xtype.getRef().getXcodeCId());
                    if (xtype.getArraySize() >= 0L) {
                        this.addAttributes(element, "array_size", "" + xtype.getArraySize());
                    } else if (xtype.getArraySizeExpr() != null) {
                        this.addAttributes(element, "array_size", "*");
                        this.addChildNodes(element, this.transArraySize(xtype.getArraySizeExpr()));
                    }
                    this.addAttributes(element, "is_static", this.toBoolStr(xtype.isArrayStatic()));
                    break;
                }
                case 5: {
                    element = this.createTypeElement("functionType", xtype, "return_type", xtype.getRef().getXcodeCId(), "is_static", this.toBoolStr(xtype.isFuncStatic()), "is_inline", this.toBoolStr(xtype.isInline()));
                    this.addChildNodes(element, this.transFuncTypeParams((XobjList)xtype.getFuncParam()));
                    break;
                }
                case 7: {
                    element = this.createTypeElement("pointerType", xtype, "ref", xtype.getRef().getXcodeCId());
                    break;
                }
                case 9: {
                    element = this.createTypeElement("coArrayType", xtype, "element_type", xtype.getRef().getXcodeCId());
                    if (xtype.getArraySize() >= 0L) {
                        this.addAttributes(element, "array_size", "" + xtype.getArraySize());
                        break;
                    }
                    if (xtype.getArraySizeExpr() == null) break;
                    this.addAttributes(element, "array_size", "*");
                    this.addChildNodes(element, this.transArraySize(xtype.getArraySizeExpr()));
                    break;
                }
                default: {
                    XmLog.fatal((String)("cannot convert type_kind:" + xtype.getKind()));
                }
            }
        }
        this.addAttributes(element, "type", xtype.getXcodeCId(), "is_const", this.toBoolStr(xtype.isConst()), "is_restrict", this.toBoolStr(xtype.isRestrict()), "is_volatile", this.toBoolStr(xtype.isVolatile()));
        return element;
    }

    private Node transArraySize(Xobject xobject) {
        if (xobject == null) {
            return null;
        }
        return this.addChildNodes(this.createElement("arraySize", new String[0]), this.transExpr(xobject));
    }

    private Node transFuncTypeParams(XobjList xobjList) {
        Element element = this.createElement("params", new String[0]);
        if (xobjList != null) {
            if (xobjList.isEmpty()) {
                Element element2 = this.createElement("name", "type", BasicType.getTypeInfo((int)1).cname);
                this.addChildNodes(element, element2);
            } else {
                for (Xobject xobject : xobjList) {
                    if (xobject == null) {
                        this.addChildNodes(element, this.createElement("ellipsis", new String[0]));
                        continue;
                    }
                    this.addChildNodes(element, this.transName(xobject));
                }
            }
        }
        return element;
    }

    private Element transSizeOrAlignOf(Xobject xobject) {
        String string = this.nameTable.getName(xobject.Opcode());
        return this.addChildNodes(this.createElement(string, new String[0]), this.transOrError(xobject.getArg(0)));
    }

    @Override
    void transGlobalDeclarations(Element element, XobjectDefEnv xobjectDefEnv) {
        XobjList xobjList = XmcXobjectToXcodeTranslator.getDeclForNotDeclared((XobjList)xobjectDefEnv.getGlobalIdentList());
        if (xobjList != null) {
            xobjList.reverse();
            for (PropObject propObject : xobjList) {
                xobjectDefEnv.insert((Xobject)propObject);
            }
        }
        for (PropObject propObject : xobjectDefEnv) {
            if (propObject == null) {
                XmLog.fatal((String)"def is null");
            }
            Xobject xobject = ((XobjectDef)propObject).getDef();
            Element element2 = null;
            element2 = xobject == null ? null : this.transOrError(xobject);
            this.addChildNodes(element, element2);
        }
    }

    @Override
    public Element trans(Xobject xobject) {
        Object object;
        if (xobject == null) {
            return null;
        }
        if (xobject instanceof Ident) {
            Element element = this.addChildNodes(this.createElement("Var", new String[0]), this.trans(xobject.getName()));
            return element;
        }
        String string = this.nameTable.getName(xobject.Opcode());
        Object object2 = null;
        switch (xobject.Opcode()) {
            case LIST: {
                switch (xobject.Nargs()) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return this.trans(xobject.getArg(0));
                    }
                }
                object2 = this.addChildNodes(this.createElement("compoundStatement", new String[0]), this.transSymbols(null), this.transDeclarations(null));
                object = this.transBody(null);
                for (Xobject xobject2 : (XobjList)xobject) {
                    this.addChildNodes((Element)object, this.trans(xobject2));
                }
                this.addChildNodes((Element)object2, new Node[]{object});
                break;
            }
            case INT_CONSTANT: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.trans(Integer.toString(xobject.getInt())));
                break;
            }
            case FLOAT_CONSTANT: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.trans(xobject.getFloatString()));
                break;
            }
            case LONGLONG_CONSTANT: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.trans("0x" + Integer.toHexString((int)xobject.getLongHigh()) + " 0x" + Integer.toHexString((int)xobject.getLongLow())));
                break;
            }
            case STRING_CONSTANT: 
            case STRING: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.trans(xobject.getString()));
                break;
            }
            case MOE_CONSTANT: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.trans(xobject.getString()));
                break;
            }
            case FUNCTION_DEFINITION: {
                object = (XobjList)xobject.getArg(1);
                XobjList xobjList = (XobjList)xobject.getArg(2);
                XobjList xobjList2 = (XobjList)xobject.getArgOrNull(3);
                Xobject xobject3 = xobject.getArgOrNull(4);
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transName(xobject.getArg(0)), this.trans(xobject3), this.transSymbols((Xobject)object), this.transFuncDefParams(xobjList, (XobjList)object), this.transBody(xobjList2));
                break;
            }
            case VAR_DECL: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transName(xobject.getArg(0)), this.transValue(xobject.getArgOrNull(1)), this.trans(xobject.getArgOrNull(2)));
                break;
            }
            case FUNCTION_DECL: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transName(xobject.getArg(0)), this.trans(xobject.getArgOrNull(1)), this.trans(xobject.getArgOrNull(2)));
                break;
            }
            case COMPOUND_STATEMENT: {
                object = (XobjList)xobject.getArg(0);
                XobjList xobjList = (XobjList)xobject.getArg(1);
                XobjList xobjList3 = XmcXobjectToXcodeTranslator.getDeclForNotDeclared(object);
                if (xobjList3 != null) {
                    if (xobjList == null) {
                        xobjList = Xcons.List();
                    }
                    xobjList3.reverse();
                    for (Xobject xobject4 : xobjList3) {
                        xobjList.insert(xobject4);
                    }
                }
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transSymbols((Xobject)object), this.transDeclarations(xobjList), this.transBody(xobject.getArg(2)));
                break;
            }
            case EXPR_STATEMENT: {
                if (xobject.getArg(0).Opcode() == Xcode.GCC_ASM_STATEMENT) {
                    return this.trans(xobject.getArg(0));
                }
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transExpr(xobject.getArg(0)));
                break;
            }
            case IF_STATEMENT: {
                object = this.transCondition(xobject.getArg(0));
                Element element = this.addChildNodes(this.createElement("then", new String[0]), this.trans(xobject.getArg(1)));
                Element element2 = this.createElement("else", new String[0]);
                Xobject xobject5 = xobject.getArgOrNull(2);
                if (xobject5 != null) {
                    this.addChildNodes(element2, this.trans(xobject.getArg(2)));
                }
                object2 = this.addChildNodes(this.createElement(string, new String[0]), new Node[]{object, element, element2});
                break;
            }
            case WHILE_STATEMENT: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transCondition(xobject.getArg(0)), this.transBody(xobject.getArg(1)));
                break;
            }
            case DO_STATEMENT: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transBody(xobject.getArg(0)), this.transCondition(xobject.getArg(1)));
                break;
            }
            case FOR_STATEMENT: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.addChildNodes(this.createElement("init", new String[0]), this.transExpr(xobject.getArg(0))), this.transCondition(xobject.getArg(1)), this.addChildNodes(this.createElement("iter", new String[0]), this.transExpr(xobject.getArg(2))), this.transBody(xobject.getArg(3)));
                break;
            }
            case SWITCH_STATEMENT: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transValue(xobject.getArg(0)), this.transBody(xobject.getArg(1)));
                break;
            }
            case BREAK_STATEMENT: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), new Node[0]);
                break;
            }
            case CONTINUE_STATEMENT: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), new Node[0]);
                break;
            }
            case RETURN_STATEMENT: {
                object = xobject.getArgOrNull(0);
                if (object != null) {
                    object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transExpr((Xobject)object));
                    break;
                }
                object2 = this.addChildNodes(this.createElement(string, new String[0]), new Node[0]);
                break;
            }
            case GOTO_STATEMENT: {
                object2 = this.createElement(string, new String[0]);
                object = xobject.getArg(0);
                if (((Xobject)object).Opcode() == Xcode.IDENT) {
                    this.addChildNodes((Element)object2, this.transName((Xobject)object));
                    break;
                }
                this.addChildNodes((Element)object2, this.transExpr((Xobject)object));
                break;
            }
            case STATEMENT_LABEL: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transName(xobject.getArg(0)));
                break;
            }
            case CASE_LABEL: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transValue(xobject.getArg(0)));
                break;
            }
            case DEFAULT_LABEL: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), new Node[0]);
                break;
            }
            case CONDITIONAL_EXPR: {
                object = xobject.getArg(1);
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transExprOrError(xobject.getArg(0)), this.transExprOrError(((Xobject)object).getArg(0)), this.transExprOrError(((Xobject)object).getArg(1)));
                break;
            }
            case COMMA_EXPR: {
                object2 = this.createElement(string, new String[0]);
                for (Xobject xobject6 : (XobjList)xobject) {
                    this.addChildNodes((Element)object2, this.transExprOrError(xobject6));
                }
                break;
            }
            case DESIGNATED_VALUE: {
                object = xobject.getArg(1);
                Node node = null;
                node = ((Xobject)object).Opcode() == Xcode.LIST ? this.transValue((Xobject)object) : this.transExpr((Xobject)object);
                object2 = this.addChildNodes(this.createElement(string, "member", xobject.getArg(0).getName()), node);
                break;
            }
            case COMPOUND_VALUE: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transValue(xobject.getArg(0)));
                break;
            }
            case COMPOUND_VALUE_ADDR: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transValue(xobject.getArg(0)));
                break;
            }
            case ADDR_OF: {
                object = null;
                Element element = null;
                Boolean bl = false;
                Xobject xobject7 = xobject.operand();
                switch (xobject7.Opcode()) {
                    case VAR: 
                    case VAR_ADDR: {
                        object = this.createElement("varAddr", new String[0]);
                        if (xobject7.getScope() == null) break;
                        this.addAttributes((Element)object, "scope", xobject7.getScope().toXcodeString());
                        break;
                    }
                    case ARRAY_REF: {
                        bl = true;
                        break;
                    }
                    case ARRAY_ADDR: {
                        object = this.createElement("arrayAddr", new String[0]);
                        if (xobject7.getScope() == null) break;
                        this.addAttributes((Element)object, "scope", xobject7.getScope().toXcodeString());
                        break;
                    }
                    case FUNC_ADDR: {
                        object = this.createElement("funcAddr", new String[0]);
                        break;
                    }
                    case MEMBER_REF: 
                    case MEMBER_ADDR: {
                        element = this.createElement("memberAddr", new String[0]);
                        break;
                    }
                    case MEMBER_ARRAY_REF: 
                    case MEMBER_ARRAY_ADDR: {
                        element = this.createElement("memberArrayAddr", new String[0]);
                        break;
                    }
                    case POINTER_REF: {
                        return this.transOrError(xobject7.getArg(0));
                    }
                    default: {
                        XmLog.fatal((String)("cannot apply ADDR_OF to " + xobject7.toString()));
                    }
                }
                if (bl.booleanValue()) {
                    object2 = this.addChildNodes(this.createElement("addrOfExpr", new String[0]), this.transOrError(xobject.getArg(0)));
                    break;
                }
                if (object != null) {
                    this.addChildNodes((Element)object, this.trans(xobject7.getName()));
                    object2 = object;
                    break;
                }
                this.addAttributes(element, "member", xobject7.getArg(1).getName());
                this.addChildNodes(element, this.transExpr(xobject7.getArg(0)));
                object2 = element;
                break;
            }
            case FUNCTION_CALL: {
                object2 = this.createElement(string, new String[0]);
                switch (xobject.getArg(0).Opcode()) {
                    case MEMBER_REF: 
                    case CPP_OPERATOR_ADDR: {
                        object = this.transExprOrError(xobject.getArg(0));
                        break;
                    }
                    default: {
                        object = this.createElement("function", new String[0]);
                        this.addChildNodes((Element)object, this.transExprOrError(xobject.getArg(0)));
                    }
                }
                Element element = this.createElement("arguments", new String[0]);
                XobjList xobjList = (XobjList)xobject.getArg(1);
                if (xobjList != null) {
                    for (Xobject xobject8 : xobjList) {
                        this.addChildNodes(element, this.transExprOrError(xobject8));
                    }
                }
                this.addChildNodes((Element)object2, new Node[]{object, element});
                break;
            }
            case SIZE_OF_EXPR: {
                object2 = this.transSizeOrAlignOf(xobject);
                break;
            }
            case CAST_EXPR: 
            case CPP_CONST_CAST_EXPR: 
            case CPP_STATIC_CAST_EXPR: 
            case CPP_REINTERPRET_CAST_EXPR: 
            case CPP_DYNAMIC_CAST_EXPR: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transOrError(xobject.getArg(0)));
                break;
            }
            case TYPE_NAME: {
                object2 = this.createElement(string, "type", xobject.Type().getXcodeCId());
                break;
            }
            case BUILTIN_OP: {
                object2 = this.createElement(string, "name", xobject.getArg(0).getName(), "is_id", this.intFlagToBoolStr(xobject.getArg(1)), "is_addrOf", this.intFlagToBoolStr(xobject.getArg(2)));
                object = (XobjList)xobject.getArgOrNull(3);
                if (object == null) break;
                Iterator<Xobject> iterator = ((XobjList)object).iterator();
                while (iterator.hasNext()) {
                    Xobject xobject9 = iterator.next();
                    this.addChildNodes((Element)object2, this.transOrError(xobject9));
                }
                break;
            }
            case POINTER_REF: {
                if (xobject.getArg(0).Opcode() == Xcode.ADDR_OF) {
                    return this.transOrError(xobject.getArg(0).getArg(0));
                }
            }
            case UNARY_MINUS_EXPR: 
            case LOG_NOT_EXPR: 
            case BIT_NOT_EXPR: 
            case PRE_INCR_EXPR: 
            case PRE_DECR_EXPR: 
            case POST_INCR_EXPR: 
            case POST_DECR_EXPR: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transOrError(xobject.getArg(0)));
                break;
            }
            case ASSIGN_EXPR: 
            case PLUS_EXPR: 
            case ASG_PLUS_EXPR: 
            case MINUS_EXPR: 
            case ASG_MINUS_EXPR: 
            case MUL_EXPR: 
            case ASG_MUL_EXPR: 
            case DIV_EXPR: 
            case ASG_DIV_EXPR: 
            case MOD_EXPR: 
            case ASG_MOD_EXPR: 
            case LSHIFT_EXPR: 
            case ASG_LSHIFT_EXPR: 
            case RSHIFT_EXPR: 
            case ASG_RSHIFT_EXPR: 
            case BIT_AND_EXPR: 
            case ASG_BIT_AND_EXPR: 
            case BIT_OR_EXPR: 
            case ASG_BIT_OR_EXPR: 
            case BIT_XOR_EXPR: 
            case ASG_BIT_XOR_EXPR: 
            case LOG_EQ_EXPR: 
            case LOG_NEQ_EXPR: 
            case LOG_GE_EXPR: 
            case LOG_GT_EXPR: 
            case LOG_LE_EXPR: 
            case LOG_LT_EXPR: 
            case LOG_AND_EXPR: 
            case LOG_OR_EXPR: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transOrError(xobject.getArg(0)), this.transOrError(xobject.getArg(1)));
                break;
            }
            case VAR: 
            case VAR_ADDR: 
            case ARRAY_ADDR: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.trans(xobject.getName()));
                if (xobject.getScope() == null) break;
                this.addAttributes((Element)object2, "scope", xobject.getScope().toXcodeString());
                break;
            }
            case FUNC_ADDR: 
            case CPP_OPERATOR_ADDR: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.trans(xobject.getName()));
                break;
            }
            case MEMBER_REF: 
            case MEMBER_ADDR: 
            case MEMBER_ARRAY_REF: 
            case MEMBER_ARRAY_ADDR: {
                object2 = this.addChildNodes(this.createElement(string, "member", xobject.getArg(1).getString()), this.transExpr(xobject.getArg(0)));
                break;
            }
            case GCC_ATTRIBUTES: {
                object2 = this.createElement(string, new String[0]);
                for (Xobject xobject10 : (XobjList)xobject) {
                    this.addChildNodes((Element)object2, this.trans(xobject10));
                }
                break;
            }
            case GCC_ATTRIBUTE: {
                object2 = this.createElement(string, "name", xobject.getArg(0).getString());
                for (Xobject xobject11 : (XobjList)xobject.getArg(1)) {
                    this.addChildNodes((Element)object2, this.transExprOrError(xobject11));
                }
                break;
            }
            case GCC_ASM: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.trans(xobject.getArg(0)));
                break;
            }
            case GCC_ASM_DEFINITION: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.trans(xobject.getArg(0)));
                break;
            }
            case GCC_ASM_STATEMENT: {
                object2 = this.addChildNodes(this.createElement(string, "is_volatile", this.intFlagToBoolStr(xobject.getArg(0))), this.transExpr(xobject.getArg(1)), this.trans(xobject.getArgOrNull(2)), this.trans(xobject.getArgOrNull(3)), this.trans(xobject.getArgOrNull(4)));
                break;
            }
            case GCC_ASM_OPERANDS: {
                object2 = this.createElement(string, new String[0]);
                for (Xobject xobject12 : (XobjList)xobject) {
                    this.addChildNodes((Element)object2, this.trans(xobject12));
                }
                break;
            }
            case GCC_ASM_OPERAND: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transExpr(xobject.getArg(0)));
                if (xobject.getArg(1) != null) {
                    this.addAttributes((Element)object2, "match", xobject.getArg(1).getString());
                }
                if (xobject.getArg(2) == null) break;
                this.addAttributes((Element)object2, "constraint", xobject.getArg(2).getString());
                break;
            }
            case GCC_ASM_CLOBBERS: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.trans(xobject.getArg(0)));
                break;
            }
            case GCC_ALIGN_OF_EXPR: {
                object2 = this.transSizeOrAlignOf(xobject);
                break;
            }
            case GCC_MEMBER_DESIGNATOR: {
                object2 = this.addChildNodes(this.createElement(string, "member", xobject.getArg(1).getName(), "ref", xobject.getArg(0).Type().getXcodeCId()), this.transExpr(xobject.getArg(2)), this.trans(xobject.getArg(3)));
                break;
            }
            case GCC_LABEL_ADDR: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.trans(xobject.getName()));
                break;
            }
            case GCC_COMPOUND_EXPR: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.trans(xobject.getArg(0)));
                break;
            }
            case GCC_RANGED_CASE_LABEL: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transValue(xobject.getArg(0)), this.transValue(xobject.getArg(0)));
                break;
            }
            case ARRAY_REF: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.trans(xobject.getArg(0)));
                object = (XobjList)xobject.getArg(1);
                int n = ((XobjList)object).Nargs();
                for (int i = 0; i < n; ++i) {
                    this.addChildNodes((Element)object2, this.transExpr(((XobjList)object).getArg(i)));
                }
                break;
            }
            case SUB_ARRAY_REF: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.trans(xobject.getArg(0)));
                object = (XobjList)xobject.getArg(1);
                int n = ((XobjList)object).Nargs();
                for (int i = 0; i < n; ++i) {
                    this.addChildNodes((Element)object2, this.trans(((XobjList)object).getArg(i)));
                }
                break;
            }
            case CO_ARRAY_REF: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transExpr(xobject.getArg(0)));
                for (Xobject xobject13 : (XobjList)xobject.getArg(1)) {
                    this.addChildNodes((Element)object2, this.transExpr(xobject13));
                }
                if (xobject.getScope() == null) break;
                this.addAttributes((Element)object2, "scope", xobject.getScope().toXcodeString());
                break;
            }
            case CO_ARRAY_ASSIGN_EXPR: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.transExpr(xobject.getArg(0)), this.transExpr(xobject.getArg(1)));
                break;
            }
            case PRAGMA_LINE: 
            case TEXT: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.trans(xobject.getArg(0).getString()));
                break;
            }
            case LINEMARKER: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), new Node[0]);
                this.addAttributes((Element)object2, "flag", xobject.getArg(0).getString());
                break;
            }
            case OMP_PRAGMA: {
                Xobject xobject142;
                object2 = this.createElement(string, new String[0]);
                object = this.createElement("string", new String[0]);
                this.addChildNode((Element)object, this.trans(xobject.getArg(0).getString()));
                this.addChildNode((Element)object2, (Node)object);
                Element element = this.createElement("list", new String[0]);
                Xobject xobject15 = xobject.getArg(1);
                if (xobject15 != null) {
                    for (Xobject xobject142 : (XobjList)xobject15) {
                        Xobject xobject16;
                        if (xobject142 instanceof XobjString) {
                            this.addChildNode(element, this.trans(xobject142));
                            continue;
                        }
                        Element element3 = this.createElement("list", new String[0]);
                        this.addChildNode(element3, this.trans(xobject142.getArg(0).getString()));
                        if (xobject142.Nargs() > 1 && (xobject16 = xobject142.getArg(1)) != null) {
                            if (xobject16 instanceof XobjString || xobject16 instanceof XobjInt) {
                                this.addChildNode(element3, this.trans(xobject16));
                            } else {
                                Element element4 = this.createElement("list", new String[0]);
                                for (Xobject xobject17 : (XobjList)xobject16) {
                                    this.addChildNode(element4, this.trans(xobject17));
                                }
                                this.addChildNode(element3, element4);
                            }
                        }
                        this.addChildNode(element, element3);
                    }
                }
                this.addChildNode((Element)object2, element);
                if (xobject.Nargs() < 3) break;
                Element element5 = this.createElement("list", new String[0]);
                xobject142 = xobject.getArg(2);
                if (xobject142 != null) {
                    if (xobject142.Opcode() == Xcode.F_STATEMENT_LIST) {
                        for (Xobject xobject16 : (XobjList)xobject142) {
                            if (xobject16.Opcode() == Xcode.F_STATEMENT_LIST) {
                                for (Object object3 : (XobjList)xobject16) {
                                    this.addChildNode(element5, this.trans((Xobject)object3));
                                }
                                continue;
                            }
                            this.addChildNode(element5, this.trans(xobject16));
                        }
                    } else {
                        this.addChildNode(element5, this.trans(xobject142));
                    }
                }
                this.addChildNode((Element)object2, element5);
                break;
            }
            case ACC_PRAGMA: {
                Element element;
                object2 = this.createElement(string, new String[0]);
                object = this.createElement("string", new String[0]);
                this.addChildNode((Element)object, this.trans(xobject.getArg(0).getString()));
                this.addChildNode((Element)object2, (Node)object);
                Xobject xobject18 = xobject.getArg(1);
                if (xobject18 != null) {
                    if (xobject18.Opcode() == Xcode.LIST) {
                        element = this.createElement("list", new String[0]);
                        for (Object object4 : (XobjList)xobject18) {
                            if (((Xobject)object4).Opcode() == Xcode.LIST) {
                                Object object5 = this.createElement("list", new String[0]);
                                Element element6 = this.createElement("string", new String[0]);
                                this.addChildNode(element6, this.trans(((Xobject)object4).getArg(0).getString()));
                                this.addChildNode((Element)object5, element6);
                                Xobject xobject19 = ((Xobject)object4).getArgOrNull(1);
                                if (xobject19 != null) {
                                    if (xobject19.Opcode() == Xcode.LIST) {
                                        Element element7 = this.createElement("list", new String[0]);
                                        for (Xobject xobject20 : (XobjList)xobject19) {
                                            this.addChildNode(element7, this.transACCPragmaVarOrArray(xobject20));
                                        }
                                        this.addChildNode((Element)object5, element7);
                                    } else {
                                        this.addChildNode((Element)object5, this.transExpr(xobject19));
                                    }
                                }
                                this.addChildNode(element, (Node)object5);
                                continue;
                            }
                            this.addChildNode(element, this.transACCPragmaVarOrArray((Xobject)object4));
                        }
                        this.addChildNode((Element)object2, element);
                    } else {
                        this.addChildNode((Element)object2, this.transExpr(xobject18));
                    }
                }
                element = this.createElement("list", new String[0]);
                Xobject xobject21 = xobject.getArgOrNull(2);
                if (xobject21 != null) {
                    if (xobject21.Opcode() == Xcode.F_STATEMENT_LIST) {
                        for (Object object5 : (XobjList)xobject21) {
                            if (((Xobject)object5).Opcode() == Xcode.F_STATEMENT_LIST) {
                                for (Xobject xobject19 : (XobjList)object5) {
                                    this.addChildNode(element, this.trans(xobject19));
                                }
                                continue;
                            }
                            this.addChildNode(element, this.trans((Xobject)object5));
                        }
                    } else {
                        this.addChildNode(element, this.trans(xobject21));
                    }
                }
                this.addChildNode((Element)object2, element);
                break;
            }
            case XMP_PRAGMA: {
                object2 = this.addChildNodes(this.createElement("text", new String[0]), this.trans("/* ignored Xcode." + xobject.Opcode().toXcodeString() + " */"));
                break;
            }
            case INDEX_RANGE: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.addChildNode(this.createElement("base", new String[0]), this.trans(xobject.getArg(0))), this.addChildNode(this.createElement("length", new String[0]), this.trans(xobject.getArg(1))), this.addChildNode(this.createElement("step", new String[0]), this.trans(xobject.getArg(2))));
                break;
            }
            case LOWER_BOUND: 
            case UPPER_BOUND: 
            case STEP: {
                object2 = this.addChildNodes(this.createElement(string, new String[0]), this.trans(xobject.getArg(0)));
                break;
            }
            case CPP_DECL_NAMESPACE: 
            case CPP_CLASS_DECL: {
                object2 = this.createElement(string, new String[0]);
                for (Xobject xobject22 : (XobjList)xobject) {
                    Element element = xobject22 instanceof Ident ? this.transIdent((Ident)xobject22) : this.trans(xobject22);
                    this.addChildNode((Element)object2, element);
                }
                break;
            }
            case CPP_CONSTRUCT_EXPR_CLASS_STATEMENT: 
            case CPP_THIS_EXPR: 
            case CPP_NESTEDNAMESPECIFIER_TYPESPEC: {
                object2 = this.createElement(string, new String[0]);
                break;
            }
            default: {
                XmLog.fatal_dump((String)"cannot convert Xcode to XcodeML.", (IXobject)xobject);
            }
        }
        if (xobject.Type() != null) {
            this.addAttributes((Element)object2, "type", xobject.Type().getXcodeCId());
        }
        if (xobject.getLineNo() != null) {
            object = xobject.getLineNo();
            this.addAttributes((Element)object2, "lineno", Integer.toString(object.lineNo()), "file", object.fileName());
        }
        if (xobject.isGccSyntax()) {
            this.addAttributes((Element)object2, "is_gccSyntax", "1");
        }
        if (xobject.isSyntaxModified()) {
            this.addAttributes((Element)object2, "is_modified", "1");
        }
        if (xobject.isGccExtension()) {
            this.addAttributes((Element)object2, "is_gccExtension", "1");
        }
        return object2;
    }

    private Element createTypeElement(String string, Xtype xtype, String ... stringArray) {
        Element element = this.createElement(string, stringArray);
        return this.addChildNodes(element, this.trans(xtype.getGccAttributes()));
    }

    public static XobjList getDeclForNotDeclared(XobjList xobjList) {
        if (xobjList == null) {
            return null;
        }
        XobjList xobjList2 = Xcons.List();
        for (Xobject xobject : xobjList) {
            Ident ident = (Ident)xobject;
            if (ident.isDeclared() || !ident.getStorageClass().isVarOrFunc()) continue;
            Xtype xtype = ident.Type();
            Xcode xcode = xtype.isFunction() ? Xcode.FUNCTION_DECL : Xcode.VAR_DECL;
            xobjList2.add(Xcons.List(xcode, Xcons.Symbol(Xcode.IDENT, ident.getName()), null));
        }
        if (xobjList2.isEmpty()) {
            return null;
        }
        return xobjList2;
    }

    private Node transACCPragmaVarOrArray(Xobject xobject) {
        if (xobject == null) {
            return null;
        }
        if (xobject.Opcode() != Xcode.LIST) {
            return this.trans(xobject);
        }
        Element element = this.createElement("list", new String[0]);
        for (Xobject xobject2 : (XobjList)xobject) {
            if (xobject2.Opcode() != Xcode.LIST) {
                this.addChildNode(element, this.trans(xobject2));
                continue;
            }
            Element element2 = this.createElement("list", new String[0]);
            for (Xobject xobject3 : (XobjList)xobject2) {
                this.addChildNode(element2, this.trans(xobject3));
            }
            this.addChildNode(element, element2);
        }
        return element;
    }
}

