/*
 * Decompiled with CFR 0.152.
 */
package exc.xcodeml;

import exc.object.Ident;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.XobjectDefEnv;
import exc.object.XobjectFile;
import exc.object.Xtype;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import xcodeml.util.XmException;

public abstract class XmXobjectToXcodeTranslator {
    protected static final String TRUE_STR = "1";
    protected Document doc;

    public Document write(XobjectFile xobjectFile) throws XmException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.doc = documentBuilder.newDocument();
            this.preprocess(xobjectFile);
            Element element = this.createElement("XcodeProgram", "language", xobjectFile.getLanguageAttribute(), "version", xobjectFile.getVersion(), "compiler-info", xobjectFile.getCompilerInfo(), "source", xobjectFile.getSourceFileName(), "time", xobjectFile.getTime());
            Element element2 = this.transTypeTable(xobjectFile.getTypeList());
            Element element3 = this.transGlobalSymbols(xobjectFile.getGlobalIdentList());
            Element element4 = this.createElement("globalDeclarations", new String[0]);
            this.addChildNodes(element4, this.transLines(xobjectFile.getHeaderLines()));
            this.transGlobalDeclarations(element4, xobjectFile);
            this.addChildNodes(element, element2, element3, element4);
            this.addChildNodes(element4, this.transLines(xobjectFile.getTailerLines()));
            this.doc.appendChild(element);
            this.postprocess(xobjectFile);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XmException((Throwable)parserConfigurationException);
        }
        return this.doc;
    }

    abstract Node trans(Xobject var1);

    protected Node trans(String string) {
        return this.doc.createTextNode(string);
    }

    abstract void transGlobalDeclarations(Element var1, XobjectDefEnv var2);

    protected abstract Element transType(Xtype var1);

    protected abstract Element transIdent(Ident var1);

    protected Element transTypeTable(List<Xtype> list) {
        Element element = this.createElement("typeTable", new String[0]);
        for (int i = 0; i < list.size(); ++i) {
            Xtype xtype = list.get(i);
            this.addChildNodes(element, this.transType(xtype));
        }
        return element;
    }

    protected Element transGlobalSymbols(Xobject xobject) {
        XobjList xobjList = (XobjList)xobject;
        Element element = this.createElement("globalSymbols", new String[0]);
        for (Xobject xobject2 : xobjList) {
            this.addChildNodes(element, this.transIdent((Ident)xobject2));
        }
        return element;
    }

    protected void preprocess(XobjectFile xobjectFile) {
    }

    protected void postprocess(XobjectFile xobjectFile) {
    }

    protected Element createElement(String string, String ... stringArray) {
        return this.addAttributes(this.doc.createElement(string), stringArray);
    }

    protected Element addAttributes(Element element, String ... stringArray) {
        int n = stringArray.length;
        assert (n % 2 == 0);
        for (int i = 0; i < n; i += 2) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            if (string2 == null) continue;
            element.setAttribute(string, string2);
        }
        return element;
    }

    protected Element addChildNode(Element element, Node node) {
        if (node != null) {
            element.appendChild(node);
        }
        return element;
    }

    protected Element addChildNodes(Element element, Node ... nodeArray) {
        for (Node node : nodeArray) {
            this.addChildNode(element, node);
        }
        return element;
    }

    protected Node[] transLines(List<String> list) {
        ArrayList<Element> arrayList = new ArrayList<Element>(list != null ? list.size() : 0);
        if (list != null) {
            for (String string : list) {
                String[] stringArray;
                if (string == null) continue;
                for (String string2 : stringArray = string.split("\n")) {
                    arrayList.add(this.addChildNode(this.createElement("text", new String[0]), this.doc.createTextNode(string2)));
                }
            }
        }
        return arrayList.toArray(new Node[0]);
    }

    protected String toBoolStr(boolean bl) {
        return bl ? TRUE_STR : null;
    }

    protected String intFlagToBoolStr(Xobject xobject) {
        if (xobject == null) {
            return null;
        }
        return xobject.getInt() == 1 ? TRUE_STR : null;
    }
}

