/*
 * Decompiled with CFR 0.152.
 */
package exc.xcodeml;

import exc.object.Ident;
import exc.object.LineNo;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectFile;
import exc.object.Xtype;
import exc.object.topdownXobjectDefIterator;
import java.io.BufferedReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import xcodeml.util.XmDomUtil;

public abstract class XcodeMLtools {
    protected XobjectFile xobjFile;

    public Document readDocument(Reader reader) {
        Document document = null;
        String string = null;
        try {
            StringBuilder stringBuilder = new StringBuilder(4096);
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
                stringBuilder.append("\n");
            }
            string = stringBuilder.toString();
            stringBuilder = null;
            StringReader stringReader = new StringReader(string);
            InputSource inputSource = new InputSource(stringReader);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputSource);
        }
        catch (Exception exception) {
            XcodeMLtools.fatal("error in DOM read e=" + exception);
            System.exit(1);
        }
        return document;
    }

    Xobject getAttrIntFlag(Node node, String string) {
        if (node == null) {
            return Xcons.Int(Xcode.INT_CONSTANT, 0);
        }
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            return Xcons.Int(Xcode.INT_CONSTANT, 1);
        }
        return Xcons.Int(Xcode.INT_CONSTANT, 0);
    }

    abstract void enterType(Node var1);

    abstract void enterGlobalIdent(Node var1);

    abstract void enterGlobalDecl(Node var1);

    abstract Xobject toIdent(Node var1);

    abstract Xobject toXobject(Node var1);

    public XobjectFile read(Reader reader) {
        Node node;
        int n;
        Document document = this.readDocument(reader);
        Element element = document.getDocumentElement();
        if (element.getNodeName() != "XcodeProgram") {
            XcodeMLtools.fatal("Toplevel must be XcodeProgram");
        }
        this.xobjFile = new XobjectFile();
        this.xobjFile.setProgramAttributes(XmDomUtil.getAttr((Node)element, (String)"source"), XmDomUtil.getAttr((Node)element, (String)"language"), XmDomUtil.getAttr((Node)element, (String)"compiler-info"), XmDomUtil.getAttr((Node)element, (String)"version"), XmDomUtil.getAttr((Node)element, (String)"time"));
        Node node2 = XmDomUtil.getElement((Node)element, (String)"typeTable");
        NodeList nodeList = node2.getChildNodes();
        int n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            node = nodeList.item(n);
            if (node.getNodeType() != 1) continue;
            this.enterType(node);
        }
        this.xobjFile.fixupTypeRef();
        node2 = XmDomUtil.getElement((Node)element, (String)"globalSymbols");
        this.xobjFile.setIdentList(this.toIdentList(node2));
        node2 = XmDomUtil.getElement((Node)element, (String)"globalDeclarations");
        nodeList = node2.getChildNodes();
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            node = nodeList.item(n);
            if (node.getNodeType() != 1) continue;
            this.enterGlobalDecl(node);
        }
        this.setIdentDecl(this.xobjFile);
        this.xobjFile.setParentRecursively(null);
        return this.xobjFile;
    }

    Xobject toIdentList(Node node) {
        XobjList xobjList = new XobjList(Xcode.ID_LIST);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            ((Xobject)xobjList).add(this.toIdent(node2));
        }
        return xobjList;
    }

    protected void setIdentDecl(XobjectFile xobjectFile) {
        topdownXobjectDefIterator topdownXobjectDefIterator2 = new topdownXobjectDefIterator(xobjectFile);
        topdownXobjectDefIterator2.init();
        while (!topdownXobjectDefIterator2.end()) {
            Xobject xobject;
            XobjectDef xobjectDef = topdownXobjectDefIterator2.getDef();
            if ((xobjectDef.isFuncDef() || xobjectDef.isFmoduleDef()) && (xobject = xobjectDef.getFuncDecls()) != null) {
                for (Xobject xobject2 : (XobjList)xobject) {
                    String string;
                    Ident ident;
                    if (xobject2 == null || xobject2.Opcode() != Xcode.VAR_DECL || (ident = xobjectDef.findIdent(string = xobject2.getArg(0).getName(), 1)) == null || ident.Type() == null || !ident.Type().isFparameter()) continue;
                    ident.setFparamValue(xobject2.getArgOrNull(1));
                }
            }
            topdownXobjectDefIterator2.next();
        }
    }

    Xtype getType(String string) {
        return this.xobjFile.findType(string);
    }

    Xobject setCommonAttributes(Node node, Xobject xobject) {
        String string = XmDomUtil.getAttr((Node)node, (String)"file");
        String string2 = XmDomUtil.getAttr((Node)node, (String)"lineno");
        if (string2 != null) {
            xobject.setLineNo(new LineNo(string, Integer.parseInt(string2)));
        }
        return xobject;
    }

    XobjList getChildList(Node node) {
        return this.getChildList(node, null);
    }

    XobjList getChildList(Node node, XobjList xobjList) {
        if (xobjList == null) {
            xobjList = new XobjList();
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            xobjList.add(this.toXobject(node2));
        }
        return xobjList;
    }

    static void printXML(Document document, OutputStream outputStream) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            System.err.println("error:" + transformerException);
        }
    }

    static void fatal(String string) {
        System.err.println("Fatal XcodeMLtools: " + string);
        Thread.dumpStack();
        System.exit(1);
    }
}

