/*
 * Decompiled with CFR 0.152.
 */
package exc.xcodeml;

import exc.object.Xcode;
import java.util.Hashtable;
import xcodeml.util.XmLog;

public abstract class XcodeMLNameTable {
    Hashtable<String, Xcode> ht;
    protected XcodeMLName[] opcodeToNameTable;

    protected void initHTable(XcodeMLName[] xcodeMLNameArray) {
        this.ht = new Hashtable();
        for (XcodeMLName xcodeMLName : xcodeMLNameArray) {
            this.ht.put(xcodeMLName.name, xcodeMLName.code);
        }
    }

    public Xcode getXcode(String string) {
        return this.ht.get(string);
    }

    protected void initOpcodeToNameTable(XcodeMLName[] xcodeMLNameArray) {
        Xcode[] xcodeArray = Xcode.values();
        this.opcodeToNameTable = new XcodeMLName[xcodeArray.length];
        XcodeMLName[] xcodeMLNameArray2 = xcodeMLNameArray;
        int n = xcodeMLNameArray2.length;
        for (int i = 0; i < n; ++i) {
            XcodeMLName xcodeMLName;
            this.opcodeToNameTable[xcodeMLName.code.ordinal()] = xcodeMLName = xcodeMLNameArray2[i];
        }
    }

    public String getName(Xcode xcode) {
        XcodeMLName xcodeMLName = this.opcodeToNameTable[xcode.ordinal()];
        if (xcodeMLName == null) {
            XmLog.fatal((String)("Unknown xcode: " + (Object)((Object)xcode)));
        }
        return xcodeMLName.name;
    }

    protected class XcodeMLName {
        Xcode code;
        String name;

        XcodeMLName(Xcode xcode, String string) {
            this.code = xcode;
            this.name = string;
        }
    }
}

