/*
 * Decompiled with CFR 0.152.
 */
package exc.xcalablemp;

import exc.block.CforBlock;
import exc.block.PragmaBlock;
import exc.object.ArrayType;
import exc.object.Ident;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.object.topdownXobjectIterator;
import exc.xcalablemp.XMPalignedArray;
import exc.xcalablemp.XMPexception;
import exc.xcalablemp.XMPglobalDecl;
import exc.xcalablemp.XMPnodes;
import exc.xcalablemp.XMPpair;
import exc.xcalablemp.XMPsymbolTable;
import exc.xcalablemp.XMPtemplate;
import java.util.HashMap;
import java.util.Iterator;

public class XMPutil {
    private static final String LOOP_ITER = "XCALABLEMP_LOOP_ITER_PROP";

    public static XobjList castList(Xtype xtype, XobjList xobjList) {
        XobjList xobjList2 = Xcons.List();
        for (Xobject xobject : xobjList) {
            xobjList2.add(Xcons.Cast(xtype, xobject));
        }
        return xobjList2;
    }

    public static Xobject getArrayElmtsObj(Xtype xtype) throws XMPexception {
        if (xtype.isArray()) {
            ArrayType arrayType = (ArrayType)xtype;
            long l = arrayType.getArraySize();
            if (l == 0L || l == -1L) {
                throw new XMPexception("array size should be declared statically");
            }
            return Xcons.binaryOp(Xcode.MUL_EXPR, Xcons.LongLongConstant(0L, l), XMPutil.getArrayElmtsObj(arrayType.getRef()));
        }
        return Xcons.LongLongConstant(0L, 1L);
    }

    public static String getXobjSymbolName(Xobject xobject) throws XMPexception {
        switch (xobject.Opcode()) {
            case VAR: {
                return xobject.getSym();
            }
            case ARRAY_REF: 
            case SUB_ARRAY_REF: {
                return xobject.getArg(0).getSym();
            }
        }
        throw new XMPexception("cannot get the symbol name of " + xobject.toString());
    }

    public static XMPalignedArray findXMPalignedArray(String string, XMPglobalDecl xMPglobalDecl, XMPsymbolTable xMPsymbolTable) {
        XMPalignedArray xMPalignedArray = null;
        if (xMPsymbolTable != null) {
            xMPalignedArray = xMPsymbolTable.getXMPalignedArray(string);
        }
        if (xMPalignedArray == null) {
            xMPalignedArray = xMPglobalDecl.getXMPalignedArray(string);
        }
        return xMPalignedArray;
    }

    public static void putLoopIter(CforBlock cforBlock, String string, XobjList xobjList) {
        HashMap<String, XobjList> hashMap = new HashMap<String, XobjList>();
        hashMap.put(string, (XobjList)cforBlock.getProp(LOOP_ITER));
        if (hashMap == null) {
            hashMap = new HashMap();
            cforBlock.setProp(LOOP_ITER, hashMap);
        }
        hashMap.put(string, xobjList);
    }

    public static XobjList getLoopIter(CforBlock cforBlock, String string) {
        HashMap<String, XobjList> hashMap = new HashMap<String, XobjList>();
        hashMap.put(string, (XobjList)cforBlock.getProp(LOOP_ITER));
        if (hashMap == null) {
            return null;
        }
        return (XobjList)hashMap.get(string);
    }

    public static long getArrayElmtCount(Xtype xtype) throws XMPexception {
        if (xtype.isArray()) {
            ArrayType arrayType = (ArrayType)xtype;
            long l = arrayType.getArraySize();
            if (l == 0L || l == -1L) {
                throw new XMPexception("array size should be declared statically");
            }
            return l * XMPutil.getArrayElmtCount(arrayType.getRef());
        }
        return 1L;
    }

    public static Xobject getArrayElmt(Xtype xtype, int n) throws XMPexception {
        if (n < 0) {
            throw new XMPexception("int dim must be more than 0");
        }
        if (!xtype.isArray()) {
            return Xcons.IntConstant(1);
        }
        ArrayType arrayType = (ArrayType)xtype;
        for (int i = 0; i < n; ++i) {
            arrayType = (ArrayType)arrayType.getRef();
        }
        long l = arrayType.getArraySize();
        if (l == 0L || l == -1L) {
            return arrayType.getArraySizeExpr();
        }
        return Xcons.IntConstant((int)arrayType.getArraySize());
    }

    public static XMPpair<Ident, Xtype> findTypedVar(String string, PragmaBlock pragmaBlock) throws XMPexception {
        Ident ident = pragmaBlock.findVarIdent(string);
        if (ident == null) {
            throw new XMPexception("cannot find '" + string + "'");
        }
        Xtype xtype = ident.Type();
        if (xtype == null) {
            throw new XMPexception("'" + string + "' has no type");
        }
        return new XMPpair<Ident, Xtype>(ident, xtype);
    }

    public static boolean isIntegerType(Xtype xtype) {
        if (xtype.getKind() == 1) {
            switch (xtype.getBasicType()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static String getTypeName(Xtype xtype) {
        if (xtype.getKind() == 1) {
            switch (xtype.getBasicType()) {
                case 2: {
                    return new String("BOOL");
                }
                case 3: {
                    return new String("CHAR");
                }
                case 4: {
                    return new String("UNSIGNED_CHAR");
                }
                case 5: {
                    return new String("SHORT");
                }
                case 6: {
                    return new String("UNSIGNED_SHORT");
                }
                case 7: {
                    return new String("INT");
                }
                case 8: {
                    return new String("UNSIGNED_INT");
                }
                case 9: {
                    return new String("LONG");
                }
                case 10: {
                    return new String("UNSIGNED_LONG");
                }
                case 11: {
                    return new String("LONGLONG");
                }
                case 12: {
                    return new String("UNSIGNED_LONGLONG");
                }
                case 13: {
                    return new String("FLOAT");
                }
                case 14: {
                    return new String("DOUBLE");
                }
                case 15: {
                    return new String("LONG_DOUBLE");
                }
                case 16: {
                    return new String("FLOAT_IMAGINARY");
                }
                case 17: {
                    return new String("DOUBLE_IMAGINARY");
                }
                case 18: {
                    return new String("LONG_DOUBLE_IMAGINARY");
                }
                case 19: {
                    return new String("FLOAT_COMPLEX");
                }
                case 20: {
                    return new String("DOUBLE_COMPLEX");
                }
                case 21: {
                    return new String("LONG_DOUBLE_COMPLEX");
                }
            }
            return null;
        }
        return null;
    }

    public static int countElmts(XobjList xobjList) {
        int n = 0;
        Iterator<Xobject> iterator = xobjList.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    public static int countElmts(XobjList xobjList, int n) {
        int n2 = 0;
        for (Xobject xobject : xobjList) {
            if (xobject == null || xobject.Opcode() != Xcode.INT_CONSTANT || xobject.getInt() != n) continue;
            ++n2;
        }
        return n2;
    }

    public static int countElmts(XobjList xobjList, String string) {
        int n = 0;
        for (Xobject xobject : xobjList) {
            if (xobject == null) continue;
            if (xobject.Opcode() == Xcode.STRING) {
                if (!xobject.getString().equals(string)) continue;
                ++n;
                continue;
            }
            if (xobject.Opcode() != Xcode.VAR || !xobject.getString().equals(string)) continue;
            ++n;
        }
        return n;
    }

    public static boolean hasElmt(XobjList xobjList, int n) {
        for (Xobject xobject : xobjList) {
            if (xobject == null || xobject.Opcode() != Xcode.INT_CONSTANT || xobject.getInt() != n) continue;
            return true;
        }
        return false;
    }

    public static boolean hasElmt(XobjList xobjList, String string) {
        for (Xobject xobject : xobjList) {
            if (xobject == null || !(xobject.Opcode() == Xcode.STRING ? xobject.getString().equals(string) : xobject.Opcode() == Xcode.VAR && xobject.getString().equals(string))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasIdent(XobjList xobjList, String string) {
        for (Ident ident : xobjList) {
            if (ident == null || !ident.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static int getFirstIndex(XobjList xobjList, int n) throws XMPexception {
        int n2 = 0;
        for (Xobject xobject : xobjList) {
            if (xobject != null && xobject.Opcode() == Xcode.INT_CONSTANT && xobject.getInt() == n) {
                return n2;
            }
            ++n2;
        }
        throw new XMPexception("exception in exc.xcalablemp.XMPutil.getFirstIndex(), element does not exist");
    }

    public static int getFirstIndex(XobjList xobjList, String string) throws XMPexception {
        int n = 0;
        for (Xobject xobject : xobjList) {
            if (xobject != null && (xobject.Opcode() == Xcode.STRING ? xobject.getString().equals(string) : xobject.Opcode() == Xcode.VAR && xobject.getString().equals(string))) {
                return n;
            }
            ++n;
        }
        throw new XMPexception("exception in exc.xcalablemp.XMPutil.getFirstIndex(), element does not exist");
    }

    public static int getLastIndex(XobjList xobjList, int n) throws XMPexception {
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        for (Xobject xobject : xobjList) {
            if (xobject != null && xobject.Opcode() == Xcode.INT_CONSTANT && xobject.getInt() == n) {
                bl = true;
                n2 = n3;
            }
            ++n3;
        }
        if (bl) {
            return n2;
        }
        throw new XMPexception("exception in exc.xcalablemp.XMPutil.getLastIndex(), element does not exist");
    }

    public static int getLastIndex(XobjList xobjList, String string) throws XMPexception {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        for (Xobject xobject : xobjList) {
            if (xobject != null && xobject.Opcode() == Xcode.STRING && xobject.getString().equals(string)) {
                bl = true;
                n = n2;
            }
            ++n2;
        }
        if (bl) {
            return n;
        }
        throw new XMPexception("exception in exc.xcalablemp.XMPutil.getLastIndex(), element does not exist");
    }

    public static Xobject foldIntConstant(Xobject xobject) {
        if (xobject.isBinaryOp()) {
            Xcode xcode = xobject.Opcode();
            Xobject xobject2 = XMPutil.foldIntConstant(xobject.left());
            Xobject xobject3 = XMPutil.foldIntConstant(xobject.right());
            if (xobject2.isIntConstant() && xobject3.isIntConstant()) {
                switch (xcode) {
                    case PLUS_EXPR: {
                        return Xcons.IntConstant(xobject2.getInt() + xobject3.getInt());
                    }
                    case MINUS_EXPR: {
                        return Xcons.IntConstant(xobject2.getInt() - xobject3.getInt());
                    }
                    case MUL_EXPR: {
                        return Xcons.IntConstant(xobject2.getInt() * xobject3.getInt());
                    }
                    case DIV_EXPR: {
                        return Xcons.IntConstant(xobject2.getInt() / xobject3.getInt());
                    }
                }
            }
        }
        return xobject;
    }

    public static Boolean is_Constant(Xobject xobject, int n) {
        topdownXobjectIterator topdownXobjectIterator2 = xobject.topdownIterator();
        topdownXobjectIterator2.init();
        while (!topdownXobjectIterator2.end()) {
            Xobject xobject2 = topdownXobjectIterator2.getXobject();
            Xcode xcode = xobject2.Opcode();
            if (xcode != Xcode.PLUS_EXPR && xcode != Xcode.MINUS_EXPR && xcode != Xcode.MUL_EXPR && xcode != Xcode.DIV_EXPR && !xobject2.isConstant()) {
                return false;
            }
            topdownXobjectIterator2.next();
        }
        return true;
    }

    public static Xobject getVar(Xobject xobject) {
        topdownXobjectIterator topdownXobjectIterator2 = xobject.topdownIterator();
        topdownXobjectIterator2.init();
        while (!topdownXobjectIterator2.end()) {
            Xobject xobject2 = topdownXobjectIterator2.getXobject();
            Xcode xcode = xobject2.Opcode();
            if (xcode == Xcode.VAR) {
                return xobject2;
            }
            topdownXobjectIterator2.next();
        }
        return xobject;
    }

    private static boolean is_F_colon(Xobject xobject) {
        if (!(xobject instanceof XobjList)) {
            return false;
        }
        if (xobject.Nargs() != 3) {
            return false;
        }
        return xobject.getArg(0) == null && xobject.getArg(1) == null && xobject.getArg(2) == null;
    }

    public static XobjList getLoopIterListFromOnRef(XobjList xobjList) {
        XobjList xobjList2 = Xcons.List();
        for (int i = 0; i < xobjList.Nargs(); ++i) {
            Xobject xobject = xobjList.getArg(i);
            if (xobject == null || xobject.equals(Xcons.StringConstant(": @{COLON}@")) || xobject.equals(Xcons.StringConstant("* @{ASTERISK}@")) || XMPutil.is_F_colon(xobject)) continue;
            xobjList2.add(XMPutil.getVar(xobject));
        }
        return xobjList2;
    }

    public static Boolean is_AllConstant(XMPnodes xMPnodes) {
        for (int i = 0; i < xMPnodes.getDim(); ++i) {
            if (XMPutil.is_Constant(xMPnodes.getSizeAt(i), i).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static Boolean is_AllConstant(XMPtemplate xMPtemplate) {
        for (int i = 0; i < xMPtemplate.getDim(); ++i) {
            if (XMPutil.is_Constant(xMPtemplate.getSizeAt(i), i).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

