/*
 * Decompiled with CFR 0.152.
 */
package exc.xcalablemp;

import exc.block.BasicBlock;
import exc.block.BasicBlockExprIterator;
import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockIterator;
import exc.block.BlockList;
import exc.block.CforBlock;
import exc.block.FuncDefBlock;
import exc.block.FunctionBlock;
import exc.block.IfBlock;
import exc.block.PragmaBlock;
import exc.block.SimpleBlock;
import exc.block.Statement;
import exc.block.topdownBlockIterator;
import exc.object.ArrayType;
import exc.object.BasicType;
import exc.object.Ident;
import exc.object.LineNo;
import exc.object.PointerType;
import exc.object.PropObject;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjConst;
import exc.object.XobjFloat;
import exc.object.XobjInt;
import exc.object.XobjList;
import exc.object.XobjLong;
import exc.object.XobjString;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectIterator;
import exc.object.Xtype;
import exc.object.topdownXobjectIterator;
import exc.openmp.OMPpragma;
import exc.xcalablemp.XMP;
import exc.xcalablemp.XMPalignedArray;
import exc.xcalablemp.XMPcoarray;
import exc.xcalablemp.XMPexception;
import exc.xcalablemp.XMPgenSym;
import exc.xcalablemp.XMPglobalDecl;
import exc.xcalablemp.XMPgpuData;
import exc.xcalablemp.XMPgpuDataTable;
import exc.xcalablemp.XMPgpuDecompiler;
import exc.xcalablemp.XMPlocalDecl;
import exc.xcalablemp.XMPnodes;
import exc.xcalablemp.XMPobject;
import exc.xcalablemp.XMPpair;
import exc.xcalablemp.XMPpragma;
import exc.xcalablemp.XMPquadruplet;
import exc.xcalablemp.XMPrewriteExpr;
import exc.xcalablemp.XMPshadow;
import exc.xcalablemp.XMPsymbolTable;
import exc.xcalablemp.XMPtemplate;
import exc.xcalablemp.XMPutil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import xcodeml.util.XmOption;

public class XMPtranslateLocalPragma {
    private XMPglobalDecl _globalDecl;
    private boolean _all_profile = false;
    private boolean _selective_profile = false;
    private boolean doScalasca = false;
    private boolean doTlog = false;
    private XobjectDef currentDef;
    private XMPgenSym tmpSym;
    private static final int LOOP_EXPAND = 410;
    private static final int LOOP_MARGIN = 411;
    private static final int LOOP_PEEL_AND_WAIT = 412;
    private static final int LOOP_NONE = 413;
    private static final int GMOVE_ALL = 0;
    private static final int GMOVE_INDEX = 1;
    private static final int GMOVE_RANGE = 2;
    private static final int GMOVE_COLL = 400;
    private static final int GMOVE_IN = 401;
    private static final int GMOVE_OUT = 402;

    public XMPtranslateLocalPragma(XMPglobalDecl xMPglobalDecl) {
        this._globalDecl = xMPglobalDecl;
        this.tmpSym = new XMPgenSym();
    }

    public void translate(FuncDefBlock funcDefBlock) {
        Object object;
        Block block;
        FunctionBlock functionBlock = funcDefBlock.getBlock();
        this.currentDef = funcDefBlock.getDef();
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(functionBlock);
        ((BlockIterator)topdownBlockIterator2).init();
        while (!((BlockIterator)topdownBlockIterator2).end()) {
            block = topdownBlockIterator2.getBlock();
            if (block.Opcode() == Xcode.XMP_PRAGMA && XMPpragma.valueOf((String)(object = ((PragmaBlock)block).getPragma())) == XMPpragma.STATIC_DESC) {
                this.analyzeStaticDesc((PragmaBlock)block);
                block.remove();
            }
            ((BlockIterator)topdownBlockIterator2).next();
        }
        ((BlockIterator)topdownBlockIterator2).init();
        while (!((BlockIterator)topdownBlockIterator2).end()) {
            block = topdownBlockIterator2.getBlock();
            if (block.Opcode() == Xcode.XMP_PRAGMA) {
                object = (PragmaBlock)block;
                try {
                    this.translatePragma((PragmaBlock)object);
                }
                catch (XMPexception xMPexception) {
                    XMP.error(((Block)object).getLineNo(), xMPexception.getMessage());
                }
            }
            ((BlockIterator)topdownBlockIterator2).next();
        }
        ((BlockIterator)topdownBlockIterator2).init();
        while (!((BlockIterator)topdownBlockIterator2).end()) {
            block = topdownBlockIterator2.getBlock();
            if (block.Opcode() == Xcode.XMP_PRAGMA && XMPpragma.valueOf((String)(object = ((PragmaBlock)block).getPragma())) == XMPpragma.TASKS) {
                block.replace(Bcons.COMPOUND(block.getBody()));
            }
            ((BlockIterator)topdownBlockIterator2).next();
        }
        funcDefBlock.finalizeBlock();
    }

    private void translatePragma(PragmaBlock pragmaBlock) throws XMPexception {
        String string = pragmaBlock.getPragma();
        switch (XMPpragma.valueOf(string)) {
            case NODES: {
                this.translateNodes(pragmaBlock);
                break;
            }
            case TEMPLATE: {
                this.translateTemplate(pragmaBlock);
                break;
            }
            case DISTRIBUTE: {
                this.translateDistribute(pragmaBlock);
                break;
            }
            case ALIGN: {
                this.translateAlign(pragmaBlock);
                break;
            }
            case SHADOW: {
                this.translateShadow(pragmaBlock);
                break;
            }
            case STATIC_DESC: {
                break;
            }
            case TASK: {
                this.translateTask(pragmaBlock);
                break;
            }
            case TASKS: {
                this.translateTasks(pragmaBlock);
                break;
            }
            case LOOP: {
                this.translateLoop(pragmaBlock, true);
                break;
            }
            case REFLECT: {
                this.translateReflect(pragmaBlock);
                break;
            }
            case REDUCE_SHADOW: {
                this.translateReduceShadow(pragmaBlock);
                break;
            }
            case BARRIER: {
                this.translateBarrier(pragmaBlock);
                break;
            }
            case REDUCTION: {
                this.translateReduction(pragmaBlock);
                break;
            }
            case BCAST: {
                this.translateBcast(pragmaBlock);
                break;
            }
            case GMOVE: {
                this.translateGmove(pragmaBlock);
                break;
            }
            case ARRAY: {
                this.translateArray(pragmaBlock);
                break;
            }
            case POST: {
                this.translatePost(pragmaBlock);
                break;
            }
            case WAIT: {
                this.translateWait(pragmaBlock);
                break;
            }
            case LOCK: {
                this.translateLockUnlock(pragmaBlock, "_XMP_lock_");
                break;
            }
            case UNLOCK: {
                this.translateLockUnlock(pragmaBlock, "_XMP_unlock_");
                break;
            }
            case LOCAL_ALIAS: {
                this.translateLocalAlias(pragmaBlock);
                break;
            }
            case WAIT_ASYNC: {
                this.translateWaitAsync(pragmaBlock);
                break;
            }
            case TEMPLATE_FIX: {
                this.translateTemplateFix(pragmaBlock);
                break;
            }
            case REFLECT_INIT: {
                this.translateReflectInit(pragmaBlock);
                break;
            }
            case REFLECT_DO: {
                this.translateReflectDo(pragmaBlock);
                break;
            }
            case GPU_REPLICATE: {
                this.translateGpuData(pragmaBlock);
                break;
            }
            case GPU_REPLICATE_SYNC: {
                this.translateGpuSync(pragmaBlock);
                break;
            }
            case GPU_REFLECT: {
                this.translateGpuReflect(pragmaBlock);
                break;
            }
            case GPU_BARRIER: {
                break;
            }
            case GPU_LOOP: {
                this.translateGpuLoop(pragmaBlock);
                break;
            }
            default: {
                throw new XMPexception("'" + string.toLowerCase() + "' directive is not supported yet");
            }
        }
    }

    private void addProfileFunctions(Xobject xobject, Block block, String string, PragmaBlock pragmaBlock) throws XMPexception {
        boolean bl = false;
        if (xobject != null && xobject.Opcode() == Xcode.VAR && xobject.getName() == "profile") {
            bl = true;
        }
        boolean bl2 = bl = bl && this._selective_profile;
        if (this._all_profile || bl) {
            if (this.doScalasca) {
                String string2 = string.toLowerCase();
                XobjList xobjList = Xcons.List(Xcons.StringConstant("#xmp " + string2 + ":" + pragmaBlock.getLineNo()));
                block.insert(this.createScalascaStartProfileCall(xobjList));
                block.add(this.createScalascaEndProfileCall(xobjList));
            } else if (this.doTlog) {
                String string3 = string.toUpperCase();
                block.insert(this.createTlogMacroInvoke("_XMP_M_TLOG_" + string3 + "_IN", null));
                block.add(this.createTlogMacroInvoke("_XMP_M_TLOG_" + string3 + "_OUT", null));
            }
        } else if (bl && !this.doTlog) {
            block.insert(this.createScalascaProfileOffCall(null));
            block.add(this.createScalascaProfileOnfCall(null));
        }
    }

    private void translateNodes(PragmaBlock pragmaBlock) throws XMPexception {
        XMPtranslateLocalPragma.checkDeclPragmaLocation(pragmaBlock);
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        XobjList xobjList3 = (XobjList)xobjList.copy();
        for (Xobject xobject : xobjList2) {
            xobjList3.setArg(0, xobject);
            XMPnodes.translateNodes(xobjList3, this._globalDecl, true, pragmaBlock);
        }
    }

    private void translateTemplate(PragmaBlock pragmaBlock) throws XMPexception {
        XMPtranslateLocalPragma.checkDeclPragmaLocation(pragmaBlock);
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        XobjList xobjList3 = (XobjList)xobjList.copy();
        for (Xobject xobject : xobjList2) {
            xobjList3.setArg(0, xobject);
            XMPtemplate.translateTemplate(xobjList3, this._globalDecl, true, pragmaBlock);
        }
    }

    private void translateTemplateFix(PragmaBlock pragmaBlock) throws XMPexception {
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XobjList xobjList2 = (XobjList)xobjList.getArg(1);
        XobjList xobjList3 = (XobjList)xobjList.copy();
        for (Xobject xobject : xobjList2) {
            xobjList3.setArg(1, xobject);
            XMPtemplate.translateTemplateFix(xobjList3, this._globalDecl, pragmaBlock);
        }
    }

    private void translateReflectInit(PragmaBlock pragmaBlock) throws XMPexception {
        XobjList xobjList = (XobjList)pragmaBlock.getClauses().getArg(0);
        XobjList xobjList2 = (XobjList)pragmaBlock.getClauses().getArg(1);
        XobjList xobjList3 = (XobjList)pragmaBlock.getClauses().getArg(2);
        XobjList xobjList4 = (XobjList)pragmaBlock.getClauses().getArg(3);
        BlockList blockList = Bcons.emptyBody();
        boolean bl = false;
        boolean bl2 = false;
        if (xobjList3.Nargs() == 0 && xobjList4.Nargs() == 0) {
            bl = true;
        } else {
            if (xobjList3.Nargs() != 0) {
                if (xobjList3.getArg(0).getName() == "acc") {
                    bl2 = true;
                } else if (xobjList3.getArg(0).getName() == "host") {
                    bl = true;
                }
            }
            if (xobjList4.Nargs() != 0) {
                if (xobjList4.getArg(0).getName() == "acc") {
                    bl2 = true;
                } else if (xobjList4.getArg(0).getName() == "host") {
                    bl = true;
                }
            }
        }
        if (bl) {
            XMP.fatal("reflect_init for host has been not developed yet.");
        }
        Ident ident = this._globalDecl.declExternFunc("_XMP_reflect_init_acc");
        XobjList xobjList5 = Xcons.List();
        xobjList5.add(Xcons.String("USE_DEVICE"));
        for (int i = 0; i < xobjList.Nargs(); ++i) {
            Xobject xobject = xobjList.getArg(i);
            String string = xobject.getString();
            Ident ident2 = this._globalDecl.findVarIdent("_XMP_ADDR_" + string);
            xobjList5.add(Xcons.List(ident2.Ref()));
            XMPalignedArray xMPalignedArray = this._globalDecl.getXMPalignedArray(string, pragmaBlock);
            if (xMPalignedArray == null) {
                XMP.fatal(string + " is not aligned.");
            }
            if (!xMPalignedArray.hasShadow()) {
                XMP.fatal(string + " is not shadowed.");
            }
            for (int j = 0; j < xobjList2.Nargs(); ++j) {
                XobjList xobjList6 = (XobjList)xobjList2.getArg(j);
                if (xobjList6.getArg(2).getInt() == 1 && xMPalignedArray.getShadowAt(j).getType() == 402) {
                    throw new XMPexception("Periodic reflect cannot be specified for a dimension with full shadow.");
                }
                Ident ident3 = this._globalDecl.declExternFunc("_XMP_set_reflect_acc__");
                XobjList xobjList7 = Xcons.List(xMPalignedArray.getDescId().Ref(), Xcons.IntConstant(j), xobjList6.getArg(0), xobjList6.getArg(1), xobjList6.getArg(2));
                blockList.add(Bcons.Statement(ident3.Call(xobjList7)));
            }
            Ident ident4 = this._globalDecl.findVarIdent("_XMP_DESC_" + string);
            blockList.add(Bcons.Statement(ident.Call(Xcons.List(xobject, ident4.Ref()))));
        }
        Block block = Bcons.PRAGMA(Xcode.ACC_PRAGMA, "HOST_DATA", Xcons.List(xobjList5), blockList);
        pragmaBlock.replace(block);
    }

    private void translateReflectDo(PragmaBlock pragmaBlock) throws XMPexception {
        XobjList xobjList = (XobjList)pragmaBlock.getClauses().getArg(0);
        XobjList xobjList2 = (XobjList)pragmaBlock.getClauses().getArg(1);
        XobjList xobjList3 = (XobjList)pragmaBlock.getClauses().getArg(2);
        boolean bl = false;
        boolean bl2 = false;
        if (xobjList2.Nargs() == 0 && xobjList3.Nargs() == 0) {
            bl = true;
        } else {
            if (xobjList2.Nargs() != 0) {
                if (xobjList2.getArg(0).getName() == "acc") {
                    bl2 = true;
                } else if (xobjList2.getArg(0).getName() == "host") {
                    bl = true;
                }
            }
            if (xobjList3.Nargs() != 0) {
                if (xobjList3.getArg(0).getName() == "acc") {
                    bl2 = true;
                } else if (xobjList3.getArg(0).getName() == "host") {
                    bl = true;
                }
            }
        }
        if (bl) {
            XMP.fatal("reflect_do for host has been not developed yet.");
        }
        Ident ident = this._globalDecl.declExternFunc("_XMP_reflect_do_acc");
        Block block = Bcons.emptyBlock();
        for (int i = 0; i < xobjList.Nargs(); ++i) {
            Xobject xobject = xobjList.getArg(i);
            String string = xobject.getString();
            XMPalignedArray xMPalignedArray = this._globalDecl.getXMPalignedArray(string, pragmaBlock);
            if (xMPalignedArray == null) {
                XMP.fatal(string + " is not aligned.");
            }
            if (!xMPalignedArray.hasShadow()) {
                XMP.fatal(string + " is not shadowed.");
            }
            Ident ident2 = this._globalDecl.findVarIdent("_XMP_DESC_" + string);
            block.add(ident.Call(Xcons.List(ident2.Ref())));
        }
        pragmaBlock.replace(block);
    }

    private void translateDistribute(PragmaBlock pragmaBlock) throws XMPexception {
        XMPtranslateLocalPragma.checkDeclPragmaLocation(pragmaBlock);
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        XobjList xobjList3 = (XobjList)xobjList.copy();
        for (Xobject xobject : xobjList2) {
            xobjList3.setArg(0, xobject);
            XMPtemplate.translateDistribute(xobjList3, this._globalDecl, true, pragmaBlock);
        }
    }

    private void translateAlign(PragmaBlock pragmaBlock) throws XMPexception {
        XMPtranslateLocalPragma.checkDeclPragmaLocation(pragmaBlock);
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        XobjList xobjList3 = (XobjList)xobjList.getArg(3);
        XobjList xobjList4 = (XobjList)xobjList3.left();
        String string = xobjList3.getTail().getString();
        boolean bl = string.equals("SQUARE");
        xobjList3.removeLastArgs();
        if (bl) {
            xobjList4.reverse();
        }
        XobjList xobjList5 = (XobjList)xobjList.copy();
        for (Xobject xobject : xobjList2) {
            xobjList5.setArg(0, xobject);
            XMPalignedArray.translateAlign(xobjList5, this._globalDecl, true, pragmaBlock);
        }
    }

    private void translateLockUnlock(PragmaBlock pragmaBlock, String string) throws XMPexception {
        int n;
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        String string2 = XMPutil.getXobjSymbolName(xobjList2.getArg(0));
        XMPcoarray xMPcoarray = this._globalDecl.getXMPcoarray(string2);
        if (xMPcoarray == null) {
            throw new XMPexception("Variable in #pragma xmp lock() must be coarray");
        }
        int n2 = 0;
        if (xobjList.Nargs() != 1) {
            n2 = xobjList.getArg(1).Nargs();
        }
        if (n2 != 0 && xobjList.getArg(1).Nargs() != xMPcoarray.getImageDim()) {
            throw new XMPexception("Invalid number of dimensions of '" + string2 + "'");
        }
        XobjList xobjList3 = Xcons.List();
        xobjList3.add(Xcons.SymbolRef(xMPcoarray.getDescId()));
        int n3 = xobjList2.Nargs() - 1;
        Xobject xobject = null;
        for (n = 0; n < n3; ++n) {
            Xobject xobject2 = xobjList2.getArg(n + 1);
            for (int i = n + 1; i < n3; ++i) {
                xobject2 = Xcons.binaryOp(Xcode.MUL_EXPR, xobject2, Xcons.IntConstant((int)xMPcoarray.getSizeAt(i)));
            }
            xobject = xobject == null ? xobject2 : Xcons.binaryOp(Xcode.PLUS_EXPR, xobject, xobject2);
        }
        if (xobject == null) {
            xobjList3.add(Xcons.IntConstant(0));
        } else {
            xobjList3.add(xobject);
        }
        if (n2 != 0) {
            for (n = 0; n < xobjList.getArg(1).Nargs(); ++n) {
                xobjList3.add(xobjList.getArg(1).getArg(n));
            }
        }
        String string3 = string + String.valueOf(n2);
        pragmaBlock.replace(this._globalDecl.createFuncCallBlock(string3, xobjList3));
    }

    private void translatePost(PragmaBlock pragmaBlock) throws XMPexception {
        XMPtranslateLocalPragma.checkDeclPragmaLocation(pragmaBlock);
        XobjList xobjList = null;
        XobjList xobjList2 = (XobjList)pragmaBlock.getClauses();
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(pragmaBlock);
        XobjList xobjList3 = (XobjList)xobjList2.getArg(0);
        String string = xobjList3.getArg(0).getString();
        XMPnodes xMPnodes = this._globalDecl.getXMPnodes(string, pragmaBlock);
        if (xMPnodes == null) {
            throw new XMPexception("cannot find '" + string + "' nodes");
        }
        xobjList = Xcons.List(xMPnodes.getDescId().Ref());
        XobjList xobjList4 = (XobjList)xobjList3.getArg(1);
        String string2 = xobjList4.getTail().getString();
        boolean bl = string2.equals("SQUARE");
        xobjList4.removeLastArgs();
        if (bl) {
            xobjList4.reverse();
        }
        if (xMPnodes.getDim() != xobjList4.Nargs()) {
            throw new XMPexception("Error. Dimension of node is different.");
        }
        String string3 = "_XMP_post_" + String.valueOf(xMPnodes.getDim());
        for (int i = 0; i < xMPnodes.getDim(); ++i) {
            Xobject xobject = xobjList4.getArg(i).getArg(0);
            if (bl) {
                xobject = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject, Xcons.IntConstant(1));
            }
            xobjList.add(xobject);
        }
        Xobject xobject = xobjList2.getArg(1);
        xobjList.add(xobject);
        pragmaBlock.replace(this._globalDecl.createFuncCallBlock(string3, xobjList));
    }

    private void translateWait(PragmaBlock pragmaBlock) throws XMPexception {
        XMPtranslateLocalPragma.checkDeclPragmaLocation(pragmaBlock);
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        int n = xobjList.Nargs();
        if (n == 0) {
            pragmaBlock.replace(this._globalDecl.createFuncCallBlock("_XMP_wait_noargs", null));
            return;
        }
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        String string = xobjList2.getArg(0).getString();
        XobjList xobjList3 = (XobjList)xobjList2.getArg(1);
        XMPnodes xMPnodes = this._globalDecl.getXMPnodes(string, pragmaBlock);
        String string2 = null;
        XobjList xobjList4 = Xcons.List(xMPnodes.getDescId().Ref());
        String string3 = xobjList3.getTail().getString();
        boolean bl = string3.equals("SQUARE");
        xobjList3.removeLastArgs();
        if (bl) {
            xobjList3.reverse();
        }
        if (xMPnodes == null) {
            throw new XMPexception("cannot find '" + string + "' nodes");
        }
        if (xMPnodes.getDim() != xobjList3.Nargs()) {
            throw new XMPexception("Error. Dimension of node is different.");
        }
        for (int i = 0; i < xMPnodes.getDim(); ++i) {
            Xobject xobject = xobjList3.getArg(i);
            if (bl) {
                xobject = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject, Xcons.IntConstant(1));
            }
            xobjList4.add(xobject);
        }
        if (n == 1) {
            string2 = "_XMP_wait_node_" + String.valueOf(xMPnodes.getDim());
            pragmaBlock.replace(this._globalDecl.createFuncCallBlock(string2, xobjList4));
            return;
        }
        if (n == 2) {
            string2 = "_XMP_wait_" + String.valueOf(xMPnodes.getDim());
            Xobject xobject = xobjList.getArg(1);
            xobjList4.add(xobject);
            pragmaBlock.replace(this._globalDecl.createFuncCallBlock(string2, xobjList4));
            return;
        }
    }

    private void translateLocalAlias(PragmaBlock pragmaBlock) throws XMPexception {
        XMPtranslateLocalPragma.checkDeclPragmaLocation(pragmaBlock);
        XMPalignedArray.translateLocalAlias((XobjList)pragmaBlock.getClauses(), this._globalDecl, true, pragmaBlock);
    }

    private void translateWaitAsync(PragmaBlock pragmaBlock) throws XMPexception {
        Object object;
        Xobject xobject2;
        Ident ident = this._globalDecl.declExternFunc("_XMP_wait_async__");
        XobjList xobjList = (XobjList)pragmaBlock.getClauses().getArg(0);
        BlockList blockList = Bcons.emptyBody();
        for (Xobject xobject2 : xobjList) {
            blockList.add(Bcons.Statement(ident.Call(Xcons.List(xobject2))));
        }
        Object object2 = Bcons.COMPOUND(blockList);
        xobject2 = (XobjList)pragmaBlock.getClauses().getArg(1);
        if (xobject2 != null && ((XobjList)xobject2).getArgs() != null) {
            object = this.createExecOnRefArgs((XobjList)xobject2, pragmaBlock);
            String string = (String)((XMPquadruplet)object).getFirst();
            boolean bl = (Boolean)((XMPquadruplet)object).getSecond();
            XobjList xobjList2 = (XobjList)((XMPquadruplet)object).getThird();
            if (bl) {
                BlockList blockList2 = Bcons.blockList(new Block[]{object2});
                object2 = this.createCommTaskBlock(blockList2, string, xobjList2);
            }
        }
        object = ((Block)object2).getBody();
        for (Xobject xobject3 : xobjList) {
            ((BlockList)object).add(this._globalDecl.declExternFunc("xmpc_end_async").Call(Xcons.List(xobject3)));
        }
        pragmaBlock.replace((Block)object2);
    }

    private void translateShadow(PragmaBlock pragmaBlock) throws XMPexception {
        XMPtranslateLocalPragma.checkDeclPragmaLocation(pragmaBlock);
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        XobjList xobjList3 = (XobjList)xobjList.copy();
        for (Xobject xobject : xobjList2) {
            xobjList3.setArg(0, xobject);
            XMPshadow.translateShadow(xobjList3, this._globalDecl, true, pragmaBlock);
        }
    }

    private void translateReflect(PragmaBlock pragmaBlock) throws XMPexception {
        XobjList xobjList = (XobjList)pragmaBlock.getClauses().getArg(3);
        boolean bl = xobjList.hasIdent("acc");
        Block block = XMPshadow.translateReflect(pragmaBlock, this._globalDecl, bl);
        Xobject xobject = pragmaBlock.getClauses().getArg(4);
        this.addProfileFunctions(xobject, block, "reflect", pragmaBlock);
    }

    private void translateReduceShadow(PragmaBlock pragmaBlock) throws XMPexception {
        XobjList xobjList = (XobjList)pragmaBlock.getClauses().getArg(3);
        boolean bl = xobjList.hasIdent("acc");
        Block block = XMPshadow.translateReduceShadow(pragmaBlock, this._globalDecl, bl);
        Xobject xobject = pragmaBlock.getClauses().getArg(4);
        this.addProfileFunctions(xobject, block, "reflect", pragmaBlock);
    }

    static Block encloseWithAccHostDataDirective(Block block, XobjList xobjList) throws XMPexception {
        if (xobjList == null || xobjList.isEmpty()) {
            throw new XMPexception("empty argument for use_device clause");
        }
        return Bcons.PRAGMA(Xcode.ACC_PRAGMA, "HOST_DATA", Xcons.List(Xcons.List(Xcons.String("USE_DEVICE"), xobjList)), Bcons.blockList(block));
    }

    private void translateGpuData(PragmaBlock pragmaBlock) throws XMPexception {
        XMPgpuData.translateGpuData(pragmaBlock, this._globalDecl);
    }

    private void translateGpuSync(PragmaBlock pragmaBlock) throws XMPexception {
        XMPgpuData.translateGpuSync(pragmaBlock, this._globalDecl);
    }

    private void translateGpuReflect(PragmaBlock pragmaBlock) throws XMPexception {
        if (!XmOption.isXcalableMPGPU()) {
            XMP.warning("use -enable-gpu option to enable 'acc relfect' directive");
            this.translateReflect(pragmaBlock);
        } else {
            XMPshadow.translateGpuReflect(pragmaBlock, this._globalDecl);
        }
    }

    private void translateGpuLoop(PragmaBlock pragmaBlock) throws XMPexception {
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        BlockList blockList = pragmaBlock.getBody();
        if (!XmOption.isXcalableMPGPU()) {
            XMP.warning("use -enable-gpu option to use 'acc loop' directive");
            pragmaBlock.replace(Bcons.COMPOUND(blockList));
            return;
        }
        CforBlock cforBlock = XMPtranslateLocalPragma.getOutermostLoopBlock(blockList);
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        XobjList xobjList3 = (XobjList)xobjList.getArg(1);
        XobjList xobjList4 = (XobjList)xobjList3.getArg(1);
        if (xobjList2 == null || xobjList2.Nargs() == 0) {
            xobjList2 = XMPutil.getLoopIterListFromOnRef(xobjList4);
        }
        this.translateMultipleLoop(pragmaBlock, cforBlock, xobjList2);
        Block block = this.translateGpuClause(pragmaBlock, null, cforBlock);
        cforBlock.replace(block);
        Block block2 = Bcons.COMPOUND(blockList);
        pragmaBlock.replace(block2);
    }

    private void analyzeFollowingGpuLoop(PragmaBlock pragmaBlock, CforBlock cforBlock) throws XMPexception {
        this.analyzeGpuLoop(pragmaBlock, cforBlock, cforBlock);
    }

    private void analyzeMultipleGpuLoop(PragmaBlock pragmaBlock, CforBlock cforBlock) throws XMPexception {
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        BlockList blockList = pragmaBlock.getBody();
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        Vector<CforBlock> vector = new Vector<CforBlock>(XMPutil.countElmts(xobjList2));
        for (Object object = xobjList2.getArgs(); object != null; object = ((XobjArgs)object).nextArgs()) {
            vector.add(XMPtranslateLocalPragma.findLoopBlock(blockList, ((XobjArgs)object).getArg().getString()));
        }
        for (CforBlock cforBlock2 : vector) {
            this.analyzeGpuLoop(pragmaBlock, cforBlock2, cforBlock);
        }
    }

    private void analyzeGpuLoop(PragmaBlock pragmaBlock, CforBlock cforBlock, CforBlock cforBlock2) throws XMPexception {
        Xobject xobject = cforBlock.getInductionVar();
        String string = xobject.getSym();
        Ident ident = XMPtranslateLocalPragma.declIdentWithBlock(cforBlock2, "_XMP_loop_init_" + string, Xtype.intType);
        Ident ident2 = XMPtranslateLocalPragma.declIdentWithBlock(cforBlock2, "_XMP_loop_cond_" + string, Xtype.intType);
        Ident ident3 = XMPtranslateLocalPragma.declIdentWithBlock(cforBlock2, "_XMP_loop_step_" + string, Xtype.intType);
        cforBlock2.insert(Xcons.Set(ident.Ref(), cforBlock.getLowerBound()));
        cforBlock2.insert(Xcons.Set(ident2.Ref(), cforBlock.getUpperBound()));
        cforBlock2.insert(Xcons.Set(ident3.Ref(), cforBlock.getStep()));
        XMPutil.putLoopIter(cforBlock2, string, Xcons.List(ident, ident2, ident3));
    }

    private void translateTask(PragmaBlock pragmaBlock) throws XMPexception {
        Block block;
        Xobject xobject;
        Object object;
        String string;
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(pragmaBlock);
        BlockList blockList = pragmaBlock.getBody();
        Block block2 = pragmaBlock.getParentBlock();
        boolean bl = false;
        if (block2 != null && block2.Opcode() == Xcode.XMP_PRAGMA && XMPpragma.valueOf(string = ((PragmaBlock)block2).getPragma()) == XMPpragma.TASKS) {
            bl = true;
        }
        boolean bl2 = ((XobjInt)xobjList.getArg(1)).getInt() == 1;
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        XMPquadruplet<String, Boolean, XobjList, XMPobject> xMPquadruplet = this.createExecOnRefArgs(xobjList2, pragmaBlock);
        String string2 = xMPquadruplet.getFirst();
        if (bl2) {
            string2 = string2 + "_nocomm";
        }
        XobjList xobjList3 = xMPquadruplet.getThird();
        XMPobject xMPobject = xMPquadruplet.getForth();
        if (!bl2) {
            object = this._globalDecl.declExternFunc("_XMP_pop_nodes");
            this.setupFinalizer(blockList, (Ident)object, null);
        }
        object = Bcons.emptyBody();
        Ident ident = null;
        if (!bl2) {
            ident = bl ? block2.getBody().declLocalIdent(this.tmpSym.getStr("_XMP_TASK_desc"), Xtype.voidPtrType, StorageClass.AUTO, Xcons.Cast(Xtype.voidPtrType, Xcons.IntConstant(0))) : ((BlockList)object).declLocalIdent(this.tmpSym.getStr("_XMP_TASK_desc"), Xtype.voidPtrType, StorageClass.AUTO, Xcons.Cast(Xtype.voidPtrType, Xcons.IntConstant(0)));
            xobjList3.cons(ident.getAddr());
        }
        Ident ident2 = this._globalDecl.declExternFunc("_XMP_exec_task_" + string2, Xtype.intType);
        if (bl) {
            xobject = block2.getBody().declLocalIdent(this.tmpSym.getStr("_XMP_is_member"), Xtype.intType);
            block2.getBody().insert(Xcons.Set(xobject.Ref(), ident2.Call(xobjList3)));
            block = Bcons.IF(BasicBlock.Cond(xobject.Ref()), blockList, null);
        } else {
            block = Bcons.IF(BasicBlock.Cond(ident2.Call(xobjList3)), blockList, null);
        }
        ((BlockList)object).add(block);
        pragmaBlock.replace(Bcons.COMPOUND((BlockList)object));
        if (!bl2) {
            xobject = Xcons.List(Xcode.POINTER_REF, ident.Ref());
            ((BlockList)object).add(this._globalDecl.createFuncCallBlock("_XMP_exec_task_NODES_FINALIZE", (XobjList)xobject));
        }
        xobject = xobjList.getArg(3);
        this.addProfileFunctions(xobject, block, "task", pragmaBlock);
    }

    private void translateTasks(PragmaBlock pragmaBlock) {
    }

    private void translateLoop(PragmaBlock pragmaBlock, boolean bl) throws XMPexception {
        PropObject propObject;
        PropObject propObject2;
        Object object;
        XobjList xobjList;
        XobjList xobjList2 = (XobjList)pragmaBlock.getClauses();
        BlockList blockList = pragmaBlock.getBody();
        Block block = null;
        XobjList xobjList3 = (XobjList)xobjList2.getArg(5);
        if (xobjList3 != null && !xobjList3.hasNullArg() && !xobjList3.isEmptyList()) {
            if (xobjList3.getArg(0).getInt() == 411) {
                block = XMPtranslateLocalPragma.divideMarginLoop(pragmaBlock);
            } else if (xobjList3.getArg(0).getInt() == 412) {
                block = XMPtranslateLocalPragma.peelLoop(pragmaBlock);
            }
        }
        if (block != null) {
            pragmaBlock.replace(block);
            Block block2 = block.getBody().getHead();
            while (block2 != null) {
                Block block3 = block2.getNext();
                if (block2 instanceof PragmaBlock) {
                    this.translatePragma((PragmaBlock)block2);
                }
                block2 = block3;
            }
            return;
        }
        CforBlock cforBlock = XMPtranslateLocalPragma.getOutermostLoopBlock(blockList);
        XobjList xobjList4 = (XobjList)xobjList2.getArg(0);
        XobjList xobjList5 = (XobjList)xobjList2.getArg(1);
        XobjList xobjList6 = (XobjList)xobjList5.getArg(1);
        String string = xobjList6.getTail().getString();
        boolean bl2 = string.equals("SQUARE");
        xobjList6.removeLastArgs();
        if (bl) {
            xobjList4.removeLastArgs();
            if (bl2) {
                xobjList6.reverse();
            }
        }
        if (xobjList4 == null || xobjList4.Nargs() == 0) {
            xobjList4 = XMPutil.getLoopIterListFromOnRef(xobjList6);
        }
        this.translateMultipleLoop(pragmaBlock, cforBlock, xobjList4);
        XobjList xobjList7 = (XobjList)xobjList2.getArg(2);
        if (xobjList7 != null && xobjList7.Nargs() > 0) {
            xobjList = null;
            xobjList = xobjList2.getArg(0) == null ? Xcons.List(Xcons.String(cforBlock.getInductionVar().getSym())) : (XobjList)xobjList4.copy();
            object = this.createReductionClauseBody(pragmaBlock, xobjList7, cforBlock);
            cforBlock.getParentBlock().add(this.createReductionClauseBlock(pragmaBlock, (BlockList)object, xobjList));
        }
        if ((xobjList = (XobjList)xobjList2.getArg(3)) != null && xobjList.Nargs() > 0) {
            object = xobjList.getArg(0).getString();
            if (((String)object).equals("acc")) {
                if (XmOption.isXcalableMPGPU()) {
                    propObject2 = this.translateGpuClause(pragmaBlock, xobjList7, cforBlock);
                    cforBlock.replace((Block)propObject2);
                } else {
                    XMP.warning("use '-enable-gpu' compiler option to use gpu clause");
                }
            } else if (((String)object).equals("threads")) {
                if (XmOption.isXcalableMPthreads()) {
                    propObject2 = (XobjList)xobjList.getArg(1);
                    propObject = this.translateThreadsClauseToOMPpragma((XobjList)propObject2, xobjList7, cforBlock, xobjList4);
                    cforBlock.replace((Block)propObject);
                } else {
                    XMP.warning("use '-enable-threads' compiler option to use 'threads' clause");
                }
            } else {
                throw new XMPexception("unknown clause in loop directive");
            }
        }
        object = new topdownXobjectIterator(XMPtranslateLocalPragma.getLoopBody(cforBlock).toXobject());
        ((topdownXobjectIterator)object).init();
        while (!((topdownXobjectIterator)object).end()) {
            XMPrewriteExpr.rewriteArrayRefInLoop(((XobjectIterator)object).getXobject(), this._globalDecl, cforBlock, blockList);
            ((topdownXobjectIterator)object).next();
        }
        propObject2 = Bcons.COMPOUND(blockList);
        pragmaBlock.replace((Block)propObject2);
        propObject = null;
        if (xobjList2.Nargs() > 4) {
            propObject = xobjList2.getArg(4);
        }
        this.addProfileFunctions((Xobject)propObject, (Block)propObject2, "loop", pragmaBlock);
    }

    private Block translateGpuClause(PragmaBlock pragmaBlock, XobjList xobjList, CforBlock cforBlock) throws XMPexception {
        Ident ident = this._globalDecl.declExternIdent(this._globalDecl.genSym("_XMP_GPU_FUNC"), Xtype.Function(Xtype.voidType));
        XobjList xobjList2 = this.setupGPUparallelFunc(ident, cforBlock, pragmaBlock);
        return this._globalDecl.createFuncCallBlock(ident.getName(), xobjList2);
    }

    private XobjList setupGPUparallelFunc(Ident ident, CforBlock cforBlock, PragmaBlock pragmaBlock) throws XMPexception {
        XobjList xobjList = (XobjList)((XobjList)pragmaBlock.getClauses()).getArg(0);
        XobjList xobjList2 = this.setupGpuLoopBlock(Xcons.List(cforBlock.findVarIdent(cforBlock.getInductionVar().getSym())), xobjList, cforBlock.getBody().getHead());
        XobjList xobjList3 = this.getGPUfuncParams(cforBlock, pragmaBlock);
        XMPgpuDecompiler.decompile(ident, xobjList3, this.getXMPalignedArrays(cforBlock), cforBlock, xobjList2, pragmaBlock, this._globalDecl.getEnv());
        XobjList xobjList4 = Xcons.List();
        for (XobjArgs xobjArgs = xobjList3.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            Ident ident2 = (Ident)xobjArgs.getArg();
            String string = ident2.getName();
            XMPgpuData xMPgpuData = XMPgpuDataTable.findXMPgpuData(ident2.getName(), cforBlock);
            if (xMPgpuData == null) {
                if (ident2.Type().isArray()) {
                    throw new XMPexception("array '" + string + "' should be declared as a gpuData");
                }
                xobjList4.add(ident2.Ref());
                continue;
            }
            XMPalignedArray xMPalignedArray = xMPgpuData.getXMPalignedArray();
            xobjList4.add(xMPgpuData.getDeviceAddrId().Ref());
        }
        return xobjList4;
    }

    private XobjList setupGpuLoopBlock(XobjList xobjList, XobjList xobjList2, Block block) throws XMPexception {
        switch (block.Opcode()) {
            case FOR_STATEMENT: {
                CforBlock cforBlock = (CforBlock)block;
                if (!cforBlock.isCanonical()) {
                    cforBlock.Canonicalize();
                }
                Block block2 = block.getBody().getHead();
                String string = cforBlock.getInductionVar().getSym();
                if (XMPutil.hasElmt(xobjList2, string)) {
                    xobjList.insert(block.findVarIdent(string));
                    block.getParentBlock().setBody(cforBlock.getBody());
                }
                return this.setupGpuLoopBlock(xobjList, xobjList2, block2);
            }
            case COMPOUND_STATEMENT: {
                return this.setupGpuLoopBlock(xobjList, xobjList2, block.getBody().getHead());
            }
        }
        return xobjList;
    }

    private ArrayList<XMPalignedArray> getXMPalignedArrays(CforBlock cforBlock) throws XMPexception {
        ArrayList<XMPalignedArray> arrayList = new ArrayList<XMPalignedArray>();
        XobjList xobjList = Xcons.List();
        BasicBlockExprIterator basicBlockExprIterator = new BasicBlockExprIterator(cforBlock.getBody());
        basicBlockExprIterator.init();
        while (!basicBlockExprIterator.end()) {
            Xobject xobject = basicBlockExprIterator.getExpr();
            topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject);
            topdownXobjectIterator2.init();
            while (!topdownXobjectIterator2.end()) {
                Xobject xobject2 = topdownXobjectIterator2.getXobject();
                switch (xobject2.Opcode()) {
                    case ARRAY_REF: {
                        String string = xobject2.getArg(0).getSym();
                        if (XMPutil.hasElmt(xobjList, string)) break;
                        xobjList.add(Xcons.String(string));
                        XMPgpuData xMPgpuData = XMPgpuDataTable.findXMPgpuData(string, cforBlock);
                        if (xMPgpuData == null) {
                            throw new XMPexception("array '" + string + "' shoud be declared as a gpuData");
                        }
                        XMPalignedArray xMPalignedArray = xMPgpuData.getXMPalignedArray();
                        if (xMPalignedArray == null) break;
                        arrayList.add(xMPalignedArray);
                        break;
                    }
                }
                topdownXobjectIterator2.next();
            }
            basicBlockExprIterator.next();
        }
        return arrayList;
    }

    private XobjList getGPUfuncParams(CforBlock cforBlock, PragmaBlock pragmaBlock) throws XMPexception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Xobject xobject;
        Object object5;
        Xobject xobject2;
        XobjList xobjList = Xcons.List();
        XobjList xobjList2 = Xcons.List();
        BasicBlockExprIterator basicBlockExprIterator = new BasicBlockExprIterator(cforBlock.getBody());
        basicBlockExprIterator.init();
        while (!basicBlockExprIterator.end()) {
            xobject2 = basicBlockExprIterator.getExpr();
            object5 = new topdownXobjectIterator(xobject2);
            ((topdownXobjectIterator)object5).init();
            while (!((topdownXobjectIterator)object5).end()) {
                xobject = ((XobjectIterator)object5).getXobject();
                switch (xobject.Opcode()) {
                    case VAR: {
                        object4 = xobject.getName();
                        if (XMPutil.hasIdent(xobjList, (String)object4) || XMPutil.hasElmt(xobjList2, (String)object4)) break;
                        object3 = XMPutil.getLoopIter(cforBlock, (String)object4);
                        if (object3 == null) {
                            object2 = cforBlock.findVarIdent((String)object4);
                            if (object2 == null) break;
                            xobjList.add(Ident.Param((String)object4, ((Xobject)object2).Type()));
                            break;
                        }
                        xobjList2.add(Xcons.String((String)object4));
                        break;
                    }
                    case ARRAY_REF: {
                        object4 = xobject.getArg(0).getSym();
                        if (XMPutil.hasIdent(xobjList, (String)object4)) break;
                        object3 = XMPgpuDataTable.findXMPgpuData((String)object4, cforBlock);
                        if (object3 == null) {
                            throw new XMPexception("array '" + (String)object4 + "' shoud be declared as a gpuData");
                        }
                        object2 = ((XMPgpuData)object3).getXMPalignedArray();
                        if (object2 == null) {
                            object = cforBlock.findVarIdent((String)object4);
                            xobjList.add(Ident.Param((String)object4, ((Xobject)object).Type()));
                            break;
                        }
                        object = null;
                        object = ((XMPalignedArray)object2).realloc() ? ((XMPalignedArray)object2).getAddrId().Type() : ((XMPalignedArray)object2).getArrayId().Type();
                        xobjList.add(Ident.Param((String)object4, (Xtype)object));
                        xobjList.add(Ident.Param("_XMP_GPU_DEVICE_DESC_" + (String)object4, Xtype.voidPtrType));
                        break;
                    }
                }
                ((topdownXobjectIterator)object5).next();
            }
            basicBlockExprIterator.next();
        }
        xobject2 = (XobjList)pragmaBlock.getClauses().getArg(0);
        object5 = ((XobjList)xobject2).iterator();
        while (object5.hasNext()) {
            xobject = (Xobject)object5.next();
            object4 = XMPutil.getLoopIter(cforBlock, xobject.getName());
            object3 = (Ident)((XobjList)object4).getArg(0);
            xobjList.add(Ident.Param(((Ident)object3).getName(), ((Xobject)object3).Type()));
            object2 = (Ident)((XobjList)object4).getArg(1);
            xobjList.add(Ident.Param(((Ident)object2).getName(), ((Xobject)object2).Type()));
            object = (Ident)((XobjList)object4).getArg(2);
            xobjList.add(Ident.Param(((Ident)object).getName(), ((Xobject)object).Type()));
        }
        return xobjList;
    }

    private Block createOMPpragmaBlock(OMPpragma oMPpragma, Xobject xobject, Block block) {
        return Bcons.PRAGMA(Xcode.OMP_PRAGMA, oMPpragma.toString(), xobject, Bcons.blockList(block));
    }

    private Block translateThreadsClauseToOMPpragma(XobjList xobjList, XobjList xobjList2, CforBlock cforBlock, XobjList xobjList3) throws XMPexception {
        Object object;
        Xobject xobject = Xcons.statementList();
        XobjList xobjList4 = Xcons.List();
        if (xobjList != null) {
            block4: for (Xobject xobject2 : xobjList) {
                object = OMPpragma.valueOf(xobject2.getArg(0));
                switch (1.$SwitchMap$exc$openmp$OMPpragma[((Enum)object).ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.compile_THREADS_name_list(xobject2.getArg(1));
                        xobjList4.add(xobject2);
                        continue block4;
                    }
                    case 4: 
                    case 5: {
                        xobject.add(xobject2);
                        continue block4;
                    }
                }
                throw new XMPexception("unknown threads clause");
            }
        }
        if (xobjList3 != null) {
            Xobject xobject2;
            String string = cforBlock.getInductionVar().getSym();
            xobject2 = Xcons.List();
            object = Xcons.List();
            for (Xobject xobject3 : xobjList3) {
                String string2 = xobject3.getName();
                if (string2.equals(string)) continue;
                ((XobjList)xobject2).add(Xcons.Symbol(Xcode.IDENT, string2));
                ((XobjList)object).add(Xcons.Symbol(Xcode.IDENT, "_XMP_loop_init_" + string2));
                ((XobjList)object).add(Xcons.Symbol(Xcode.IDENT, "_XMP_loop_cond_" + string2));
                ((XobjList)object).add(Xcons.Symbol(Xcode.IDENT, "_XMP_loop_step_" + string2));
            }
            xobjList4.add(Xcons.List(Xcode.LIST, Xcons.String(OMPpragma.DATA_PRIVATE.toString()), xobject2));
            xobjList4.add(Xcons.List(Xcode.LIST, new Xobject[]{Xcons.String(OMPpragma.DATA_FIRSTPRIVATE.toString()), object}));
        }
        this.addReductionClauseToOMPclause(xobjList4, xobjList2);
        return this.createOMPpragmaBlock(OMPpragma.PARALLEL, xobject, this.createOMPpragmaBlock(OMPpragma.FOR, xobjList4, cforBlock));
    }

    private void addReductionClauseToOMPclause(XobjList xobjList, XobjList xobjList2) throws XMPexception {
        if (xobjList2 == null) {
            return;
        }
        for (Xobject xobject : xobjList2) {
            OMPpragma oMPpragma = null;
            XobjInt xobjInt = (XobjInt)xobject.getArg(0);
            switch (xobjInt.getInt()) {
                case 300: {
                    oMPpragma = OMPpragma.DATA_REDUCTION_PLUS;
                    break;
                }
                case 316: {
                    oMPpragma = OMPpragma.DATA_REDUCTION_MINUS;
                    break;
                }
                case 301: {
                    oMPpragma = OMPpragma.DATA_REDUCTION_MUL;
                    break;
                }
                case 302: {
                    oMPpragma = OMPpragma.DATA_REDUCTION_BITAND;
                    break;
                }
                case 303: {
                    oMPpragma = OMPpragma.DATA_REDUCTION_LOGAND;
                    break;
                }
                case 304: {
                    oMPpragma = OMPpragma.DATA_REDUCTION_BITOR;
                    break;
                }
                case 305: {
                    oMPpragma = OMPpragma.DATA_REDUCTION_LOGOR;
                    break;
                }
                case 306: {
                    oMPpragma = OMPpragma.DATA_REDUCTION_BITXOR;
                    break;
                }
                case 307: 
                case 308: 
                case 309: 
                case 310: 
                case 311: 
                case 312: 
                case 313: {
                    throw new XMPexception("the operation cannot be translated to OpenMP clause");
                }
                default: {
                    throw new XMPexception("unknown reduction operation");
                }
            }
            XobjList xobjList3 = Xcons.List();
            for (Xobject xobject2 : (XobjList)xobject.getArg(1)) {
                xobjList3.add(Xcons.Symbol(Xcode.IDENT, xobject2.getArg(0).getName()));
            }
            xobjList.add(this.omp_pg_list(oMPpragma, xobjList3));
        }
    }

    private Xobject omp_pg_list(OMPpragma oMPpragma, Xobject xobject) {
        return Xcons.List(Xcode.LIST, Xcons.String(oMPpragma.toString()), xobject);
    }

    private void compile_THREADS_name_list(Xobject xobject) throws XMPexception {
        if (xobject == null) {
            return;
        }
    }

    private Block createReductionClauseBlock(PragmaBlock pragmaBlock, BlockList blockList, XobjList xobjList) throws XMPexception {
        Object object;
        Object object2;
        XobjList xobjList2 = (XobjList)pragmaBlock.getClauses();
        XobjList xobjList3 = (XobjList)xobjList2.getArg(1);
        String string = xobjList3.getArg(0).getString();
        XobjList xobjList4 = (XobjList)xobjList3.getArg(1);
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(pragmaBlock);
        XMPobject xMPobject = this._globalDecl.getXMPobject(string, pragmaBlock);
        if (xMPobject == null) {
            throw new XMPexception("cannot find '" + string + "' nodes/template");
        }
        String string2 = null;
        switch (xMPobject.getKind()) {
            case 101: {
                string2 = "TEMPLATE";
                break;
            }
            case 100: {
                string2 = "NODES";
                break;
            }
            default: {
                throw new XMPexception("unknown object type");
            }
        }
        XobjList xobjList5 = Xcons.List(xMPobject.getDescId().Ref());
        boolean bl = false;
        for (object2 = xobjList4.getArgs(); object2 != null; object2 = ((XobjArgs)object2).nextArgs()) {
            object = ((XobjArgs)object2).getArg().getString();
            if (XMPutil.hasElmt(xobjList, (String)object)) {
                xobjList5.add(Xcons.Cast(Xtype.intType, Xcons.IntConstant(0)));
                continue;
            }
            bl = true;
            xobjList5.add(Xcons.Cast(Xtype.intType, Xcons.IntConstant(1)));
        }
        if (bl) {
            object2 = this._globalDecl.declExternFunc("_XMP_pop_n_free_nodes");
            this.setupFinalizer(blockList, (Ident)object2, null);
            object = this._globalDecl.declExternFunc("_XMP_init_reduce_comm_" + string2, Xtype.intType);
            return Bcons.IF(BasicBlock.Cond(((Ident)object).Call(xobjList5)), blockList, null);
        }
        return Bcons.COMPOUND(blockList);
    }

    private void translateMultipleLoop(PragmaBlock pragmaBlock, CforBlock cforBlock, XobjList xobjList) throws XMPexception {
        CforBlock cforBlock2;
        Iterator iterator;
        XobjList xobjList2 = (XobjList)pragmaBlock.getClauses();
        BlockList blockList = pragmaBlock.getBody();
        Vector<CforBlock> vector = new Vector<CforBlock>(XMPutil.countElmts(xobjList));
        int n = 0;
        for (iterator = xobjList.getArgs(); iterator != null; iterator = ((XobjArgs)((Object)iterator)).nextArgs()) {
            vector.add(XMPtranslateLocalPragma.findLoopBlock(blockList, ((XobjArgs)((Object)iterator)).getArg().getString()));
            ++n;
        }
        iterator = vector.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (iterator.hasNext()) {
            cforBlock2 = (CforBlock)iterator.next();
            blArray[n2++] = this.scheduleLoop(pragmaBlock, cforBlock2, cforBlock, arrayList);
        }
        iterator = vector.iterator();
        n2 = 0;
        while (iterator.hasNext()) {
            cforBlock2 = (CforBlock)iterator.next();
            if (blArray[n2++]) continue;
            this.insertScheduleIndexFunction(pragmaBlock, cforBlock2, cforBlock, arrayList);
        }
    }

    private void insertScheduleIndexFunction(PragmaBlock pragmaBlock, CforBlock cforBlock, CforBlock cforBlock2, ArrayList arrayList) throws XMPexception {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(cforBlock2);
        Xobject xobject = xobjList.getArg(1);
        String string = xobject.getArg(0).getString();
        XMPobject xMPobject = this._globalDecl.getXMPobject(string, cforBlock2);
        XMPtemplate xMPtemplate = (XMPtemplate)xMPobject;
        XobjList xobjList2 = (XobjList)xobject.getArg(1);
        Xobject xobject2 = cforBlock.getInductionVar();
        String string2 = xobject2.getSym();
        XobjList xobjList3 = Xcons.List();
        Xobject xobject3 = cforBlock.getLowerBound();
        Xobject xobject4 = cforBlock.getUpperBound();
        Xobject xobject5 = cforBlock.getStep();
        xobjList3.add(xobject3);
        xobjList3.add(xobject4);
        xobjList3.add(xobject5);
        Ident ident = XMPtranslateLocalPragma.declIdentWithBlock(cforBlock2, "_XMP_loop_init_" + string2, Xtype.intType);
        Ident ident2 = XMPtranslateLocalPragma.declIdentWithBlock(cforBlock2, "_XMP_loop_cond_" + string2, Xtype.intType);
        Ident ident3 = XMPtranslateLocalPragma.declIdentWithBlock(cforBlock2, "_XMP_loop_step_" + string2, Xtype.intType);
        xobjList3.add(ident.getAddr());
        xobjList3.add(ident2.getAddr());
        xobjList3.add(ident3.getAddr());
        XobjInt xobjInt = null;
        int n = 0;
        int n2 = 0;
        String string3 = null;
        for (object3 = xobjList2.getArgs(); object3 != null; object3 = ((XobjArgs)object3).nextArgs()) {
            String string4 = ((XobjArgs)object3).getArg().getString();
            if (string4.equals(string2)) {
                xobjInt = Xcons.IntConstant(n);
                n2 = xMPtemplate.getDistMannerAt(n);
                string3 = xMPtemplate.getDistMannerStringAt(n);
            }
            ++n;
        }
        xobjList3.add(xMPtemplate.getDescId().Ref());
        xobjList3.add(xobjInt);
        object3 = xobjList.getArg(5);
        if (object3 != null && !((Xobject)object3).isEmptyList()) {
            Xobject xobject6;
            int n3 = ((Xobject)object3).getArg(0).getInt();
            if (n3 == 412) {
                Xobject xobject7 = ((Xobject)object3).getArg(1);
                xobject6 = ((Xobject)object3).getArg(2);
            } else {
                xobject6 = ((Xobject)object3).getArg(1);
            }
            int n4 = xobjInt.getInt();
            object2 = xobject6.getArg(n4).getArg(0);
            object = xobject6.getArg(n4).getArg(1);
            stringArray = xobject6.getArg(n4).getArg(2);
            int n5 = n3 == 411 && stringArray.getInt() == -1 ? 410 : n3;
            xobjList3.add(Xcons.IntConstant(n5));
            xobjList3.add((Xobject)object2);
            xobjList3.add((Xobject)object);
            xobjList3.add((Xobject)stringArray);
        } else {
            xobjList3.add(Xcons.IntConstant(413));
            xobjList3.add(Xcons.IntConstant(0));
            xobjList3.add(Xcons.IntConstant(0));
            xobjList3.add(Xcons.IntConstant(0));
        }
        Ident ident4 = this._globalDecl.declExternFunc("xmpc_loop_sched");
        object2 = new int[]{arrayList.size()};
        object = new boolean[]{false, false, false};
        stringArray = new String[3];
        object[0] = this.getPositionInsertScheFuncion(xobject3, 0, (int[])object2, arrayList, stringArray);
        object[1] = this.getPositionInsertScheFuncion(xobject4, 1, (int[])object2, arrayList, stringArray);
        object[2] = this.getPositionInsertScheFuncion(xobject5, 2, (int[])object2, arrayList, stringArray);
        if (object2[0] == arrayList.size()) {
            Block block = XMPtranslateLocalPragma.getOuterSchedPoint(cforBlock2);
            block.insert(ident4.Call(xobjList3));
        } else {
            if (object[0] != false) {
                this.insertScheFuncion(xobject3, (boolean[])object, (int)object2[0], 0, cforBlock2, xobjList3, xMPtemplate, ident4, arrayList, stringArray);
            }
            if (object[1] != false) {
                this.insertScheFuncion(xobject4, (boolean[])object, (int)object2[0], 1, cforBlock2, xobjList3, xMPtemplate, ident4, arrayList, stringArray);
            }
            if (object[2] != false) {
                this.insertScheFuncion(xobject5, (boolean[])object, (int)object2[0], 2, cforBlock2, xobjList3, xMPtemplate, ident4, arrayList, stringArray);
            }
        }
    }

    private void insertScheFuncion(Xobject xobject, boolean[] blArray, int n, int n2, Block block, XobjList xobjList, XMPtemplate xMPtemplate, Ident ident, ArrayList arrayList, String[] stringArray) throws XMPexception {
        Block block2 = XMPtranslateLocalPragma.getOuterSchedPoint(block);
        for (int i = 0; i < arrayList.size() - n; ++i) {
            block2 = block2.getBody().getHead();
        }
        Xobject xobject2 = ident.Call(xobjList);
        int n3 = 0;
        String string = stringArray[n2];
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList.get(i).toString().equals(string)) continue;
            n3 = i;
        }
        xobject = XMPrewriteExpr.calcLtoG(xMPtemplate, n3, xobject, this._globalDecl);
        xobjList.setArg(n2, xobject);
        if (n2 == 0) {
            block2.insert(xobject2);
            return;
        }
        if (n2 == 1) {
            if (blArray[0]) {
                return;
            }
            block2.insert(xobject2);
            return;
        }
        if (n2 == 2) {
            if (blArray[0] || blArray[1]) {
                return;
            }
            block2.insert(xobject2);
            return;
        }
    }

    private boolean getPositionInsertScheFuncion(Xobject xobject, int n, int[] nArray, ArrayList arrayList, String[] stringArray) throws XMPexception {
        if (xobject.Opcode() != Xcode.INT_CONSTANT) {
            XobjList xobjList = null;
            xobjList = xobject.isVariable() || xobject instanceof XobjConst ? Xcons.List(xobject) : this.XobjArgs2XobjList(xobject, Xcons.List());
            for (XobjArgs xobjArgs = xobjList.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
                if (!xobjArgs.getArg().isVariable()) continue;
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!xobjArgs.getArg().getSym().equals(arrayList.get(i))) continue;
                    if (nArray[0] > i) {
                        nArray[0] = i;
                    }
                    stringArray[n] = arrayList.get(i).toString();
                    return true;
                }
            }
        }
        return false;
    }

    private XobjList XobjArgs2XobjList(Xobject xobject, XobjList xobjList) {
        for (XobjArgs xobjArgs = xobject.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            if (xobjArgs.getArg().isBinaryOp()) {
                this.XobjArgs2XobjList(xobjArgs.getArg(), xobjList);
                continue;
            }
            xobjList.add(xobjArgs.getArg());
        }
        return xobjList;
    }

    private BlockList createReductionClauseBody(PragmaBlock pragmaBlock, XobjList xobjList, CforBlock cforBlock) throws XMPexception {
        Ident ident = this._globalDecl.declExternFunc("_XMP_get_execution_nodes_rank", Xtype.intType);
        IfBlock ifBlock = (IfBlock)Bcons.IF(BasicBlock.Cond(Xcons.binaryOp(Xcode.LOG_NEQ_EXPR, ident.Call(null), Xcons.IntConstant(0))), null, null);
        Iterator<Xobject> iterator = xobjList.iterator();
        BlockList blockList = Bcons.emptyBody();
        while (iterator.hasNext()) {
            XobjList xobjList2 = (XobjList)iterator.next();
            Vector<XobjList> vector = this.createReductionArgsList(xobjList2, pragmaBlock, true, cforBlock, ifBlock);
            String string = this.createReductionFuncType(xobjList2, pragmaBlock, false);
            blockList.add(this.createReductionFuncCallBlock(false, string + "_CLAUSE", null, vector));
        }
        if (ifBlock.getThenBody() != null) {
            cforBlock.getParentBlock().insert(ifBlock);
        }
        return blockList;
    }

    private boolean scheduleLoop(PragmaBlock pragmaBlock, CforBlock cforBlock, CforBlock cforBlock2, ArrayList<String> arrayList) throws XMPexception {
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(cforBlock2);
        Xobject xobject = xobjList.getArg(1);
        String string = xobject.getArg(0).getString();
        XMPobject xMPobject = this._globalDecl.getXMPobject(string, cforBlock2);
        if (xMPobject == null) {
            throw new XMPexception("cannot find '" + string + "' nodes/template");
        }
        switch (xMPobject.getKind()) {
            case 101: {
                XMPtemplate xMPtemplate = (XMPtemplate)xMPobject;
                if (!xMPtemplate.isDistributed()) {
                    throw new XMPexception("template '" + string + "' is not distributed");
                }
                Xobject xobject2 = xobjList.getArg(5);
                boolean bl = xobject2 != null && !xobject2.isEmptyList();
                return this.callLoopSchedFuncTemplate(xMPtemplate, (XobjList)xobject.getArg(1), cforBlock, cforBlock2, arrayList, bl);
            }
            case 100: {
                this.callLoopSchedFuncNodes((XMPnodes)xMPobject, (XobjList)xobject.getArg(1), cforBlock, cforBlock2);
                return false;
            }
        }
        throw new XMPexception("unknown object type");
    }

    private static Block getOuterSchedPoint(Block block) {
        for (Block block2 = block.getParentBlock(); block2 != null; block2 = block2.getParentBlock()) {
            if (block2.Opcode() != Xcode.OMP_PRAGMA && block2.Opcode() != Xcode.ACC_PRAGMA) continue;
            return block2;
        }
        return block;
    }

    private static CforBlock getOutermostLoopBlock(BlockList blockList) throws XMPexception {
        Block block = blockList.getHead();
        if (block != null) {
            if (block.Opcode() == Xcode.FOR_STATEMENT) {
                LineNo lineNo = block.getLineNo();
                if (block.getNext() != null) {
                    throw new XMPexception("only one loop statement is allowed in loop directive");
                }
                CforBlock cforBlock = (CforBlock)block;
                cforBlock.Canonicalize();
                if (cforBlock.isCanonical()) {
                    return cforBlock;
                }
                throw new XMPexception("loop statement is not canonical");
            }
            if (block.Opcode() == Xcode.COMPOUND_STATEMENT || block.Opcode() == Xcode.OMP_PRAGMA || block.Opcode() == Xcode.ACC_PRAGMA) {
                return XMPtranslateLocalPragma.getOutermostLoopBlock(block.getBody());
            }
        }
        throw new XMPexception("cannot find the loop statement");
    }

    private static BlockList getLoopBody(Block block) throws XMPexception {
        return block.getBody();
    }

    private static CforBlock findLoopBlock(BlockList blockList, String string) throws XMPexception {
        Block block = blockList.getHead();
        if (block != null) {
            switch (block.Opcode()) {
                case FOR_STATEMENT: {
                    CforBlock cforBlock = (CforBlock)block;
                    cforBlock.Canonicalize();
                    if (!cforBlock.isCanonical()) {
                        throw new XMPexception("loop is not canonical");
                    }
                    if (cforBlock.getInductionVar().getSym().equals(string)) {
                        return (CforBlock)block;
                    }
                    return XMPtranslateLocalPragma.findLoopBlock(cforBlock.getBody(), string);
                }
                case COMPOUND_STATEMENT: {
                    return XMPtranslateLocalPragma.findLoopBlock(block.getBody(), string);
                }
                case XMP_PRAGMA: {
                    throw new XMPexception("reached to a xcalablemp directive");
                }
                case OMP_PRAGMA: 
                case ACC_PRAGMA: {
                    return XMPtranslateLocalPragma.findLoopBlock(block.getBody(), string);
                }
            }
        }
        throw new XMPexception("cannot find the loop statement");
    }

    private int calcParallelCond(XMPtemplate xMPtemplate, int n, int n2) throws XMPexception {
        XMPnodes xMPnodes = xMPtemplate.getOntoNodes();
        int n3 = XMPutil.foldIntConstant(xMPtemplate.getSizeAt(n)).getInt();
        if (n2 == 100) {
            return n3;
        }
        int n4 = xMPtemplate.getOntoNodesIndexAt(n).getInt();
        int n5 = XMPutil.foldIntConstant(xMPnodes.getSizeAt(n4)).getInt();
        return n3 / n5;
    }

    private boolean is_parallelCondConstant(XMPtemplate xMPtemplate, CforBlock cforBlock, int n, int n2) throws XMPexception {
        int n3;
        int n4;
        int n5;
        XMPnodes xMPnodes = xMPtemplate.getOntoNodes();
        if (xMPnodes.isInherit()) {
            return false;
        }
        if (n2 == 104) {
            return false;
        }
        if (!XMPutil.is_Constant(xMPtemplate.getSizeAt(n), n).booleanValue()) {
            return false;
        }
        if (!XMPutil.is_Constant(cforBlock.getUpperBound(), n).booleanValue()) {
            return false;
        }
        if (n2 != 100 && !XMPutil.is_Constant(xMPnodes.getSizeAt(n5 = xMPtemplate.getOntoNodesIndexAt(n).getInt()), n5).booleanValue()) {
            return false;
        }
        if (n2 == 103 && !XMPutil.is_Constant(xMPtemplate.getWidthAt(n), n).booleanValue()) {
            return false;
        }
        n5 = XMPutil.foldIntConstant(xMPtemplate.getSizeAt(n)).getInt();
        if (n5 != (n4 = XMPutil.foldIntConstant(cforBlock.getUpperBound()).getInt())) {
            return false;
        }
        int n6 = n3 = n2 == 103 ? XMPutil.foldIntConstant(xMPtemplate.getWidthAt(n)).getInt() : 1;
        if (n2 == 100) {
            return true;
        }
        int n7 = xMPtemplate.getOntoNodesIndexAt(n).getInt();
        int n8 = XMPutil.foldIntConstant(xMPnodes.getSizeAt(n7)).getInt();
        return n5 % (n8 * n3) == 0;
    }

    private boolean callLoopSchedFuncTemplate(XMPtemplate xMPtemplate, XobjList xobjList, CforBlock cforBlock, CforBlock cforBlock2, ArrayList<String> arrayList, boolean bl) throws XMPexception {
        Xobject xobject;
        Xobject xobject2;
        Object object;
        Xobject xobject3 = cforBlock.getInductionVar();
        String string = xobject3.getSym();
        arrayList.add(string);
        int n = 0;
        int n2 = xMPtemplate.getDim();
        XobjInt xobjInt = null;
        int n3 = 0;
        String string2 = null;
        int n4 = 0;
        for (XobjArgs xobjArgs = xobjList.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            if (n >= n2) {
                throw new XMPexception("wrong template dimensions, too many");
            }
            if (xobjArgs.getArg() != null && ((String)(object = xobjArgs.getArg().getString())).equals(string)) {
                if (xobjInt != null) {
                    throw new XMPexception("loop index '" + string + "' is already described");
                }
                xobjInt = Xcons.IntConstant(n);
                n3 = xMPtemplate.getDistMannerAt(n);
                string2 = xMPtemplate.getDistMannerStringAt(n);
                n4 = n;
            }
            ++n;
        }
        if (xobjInt == null) {
            throw new XMPexception("cannot find index '" + string + "' reference in <on-ref>");
        }
        if (n != n2) {
            throw new XMPexception("wrong template dimensions, too few");
        }
        boolean bl2 = true;
        if (!bl && cforBlock.getLowerBound().equals(Xcons.IntConstant(0))) {
            object = Xcons.IntConstant(0);
        } else {
            object = XMPtranslateLocalPragma.declIdentWithBlock(cforBlock2, "_XMP_loop_init_" + string, Xtype.intType).Ref();
            bl2 = false;
        }
        if (xMPtemplate.isFixed() && !bl && this.is_parallelCondConstant(xMPtemplate, cforBlock, n4, n3)) {
            xobject2 = Xcons.IntConstant(this.calcParallelCond(xMPtemplate, n4, n3));
        } else {
            xobject2 = XMPtranslateLocalPragma.declIdentWithBlock(cforBlock2, "_XMP_loop_cond_" + string, Xtype.intType).Ref();
            bl2 = false;
        }
        if (!bl && cforBlock.getStep().equals(Xcons.IntConstant(1))) {
            xobject = Xcons.IntConstant(1);
        } else if (!bl && cforBlock.getStep().equals(Xcons.IntConstant(-1))) {
            xobject = Xcons.IntConstant(-1);
        } else {
            xobject = XMPtranslateLocalPragma.declIdentWithBlock(cforBlock2, "_XMP_loop_step_" + string, Xtype.intType).Ref();
            bl2 = false;
        }
        XMPutil.putLoopIter(cforBlock2, string, Xcons.List(new Xobject[]{object, xobject2, xobject}));
        switch (n3) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                cforBlock.setLowerBound((Xobject)object);
                cforBlock.setUpperBound(xobject2);
                cforBlock.setStep(xobject);
                break;
            }
            default: {
                throw new XMPexception("unknown distribute manner");
            }
        }
        BasicBlockExprIterator basicBlockExprIterator = new BasicBlockExprIterator(XMPtranslateLocalPragma.getLoopBody(cforBlock));
        basicBlockExprIterator.init();
        while (!basicBlockExprIterator.end()) {
            XMPrewriteExpr.rewriteLoopIndexInLoop(basicBlockExprIterator.getExpr(), string, xMPtemplate, xobjInt.getInt(), this._globalDecl, cforBlock);
            basicBlockExprIterator.next();
        }
        BlockList blockList = XMPtranslateLocalPragma.getLoopBody(cforBlock);
        do {
            for (Block block = blockList.getHead(); block != null; block = block.getNext()) {
                if (block.getBody() == null) continue;
                topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(block.getBody().getDecls());
                topdownXobjectIterator2.init();
                while (!topdownXobjectIterator2.end()) {
                    int n5 = 0;
                    for (XobjArgs xobjArgs = xobjList.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
                        String string3 = xobjArgs.getArg().getString();
                        XMPrewriteExpr.rewriteLoopIndexInLoop(topdownXobjectIterator2.getXobject(), string3, xMPtemplate, n5, this._globalDecl, cforBlock);
                        ++n5;
                    }
                    topdownXobjectIterator2.next();
                }
            }
        } while ((blockList = blockList.getHead().getBody()) != null && blockList.getHead() != null);
        return bl2;
    }

    private void callLoopSchedFuncNodes(XMPnodes xMPnodes, XobjList xobjList, CforBlock cforBlock, CforBlock cforBlock2) throws XMPexception {
        Object object;
        Object object2;
        Xobject xobject = cforBlock.getInductionVar();
        Xtype xtype = xobject.Type();
        if (!XMPutil.isIntegerType(xtype)) {
            throw new XMPexception("loop index variable has a non-integer type");
        }
        String string = xobject.getSym();
        int n = 0;
        int n2 = xMPnodes.getDim();
        XobjInt xobjInt = null;
        for (object2 = xobjList.getArgs(); object2 != null; object2 = ((XobjArgs)object2).nextArgs()) {
            if (n >= n2) {
                throw new XMPexception("wrong nodes dimensions, too many");
            }
            object = ((XobjArgs)object2).getArg().getString();
            if (((String)object).equals(string)) {
                if (xobjInt != null) {
                    throw new XMPexception("loop index '" + string + "' is already described");
                }
                xobjInt = Xcons.IntConstant(n);
            }
            ++n;
        }
        if (xobjInt == null) {
            throw new XMPexception("cannot find index '" + string + "' reference in <on-ref>");
        }
        if (n != n2) {
            throw new XMPexception("wrong nodes dimensions, too few");
        }
        object2 = XMPtranslateLocalPragma.declIdentWithBlock(cforBlock2, "_XMP_loop_init_" + string, xtype);
        object = XMPtranslateLocalPragma.declIdentWithBlock(cforBlock2, "_XMP_loop_cond_" + string, xtype);
        Ident ident = XMPtranslateLocalPragma.declIdentWithBlock(cforBlock2, "_XMP_loop_step_" + string, xtype);
        XMPutil.putLoopIter(cforBlock2, string, Xcons.List(new Xobject[]{object2, object, ident}));
        cforBlock.setLowerBound(((Ident)object2).Ref());
        cforBlock.setUpperBound(((Ident)object).Ref());
        cforBlock.setStep(ident.Ref());
        cforBlock.getCondBBlock().setExpr(Xcons.binaryOp(Xcode.LOG_LT_EXPR, xobject, ((Ident)object).Ref()));
    }

    static Ident declIdentWithBlock(Block block, String string, Xtype xtype) {
        Block block2 = XMPtranslateLocalPragma.getOuterSchedPoint(block);
        BlockList blockList = block2.getParent();
        return blockList.declLocalIdent(string, xtype);
    }

    private Block createCommTaskBlock(BlockList blockList, String string, XobjList xobjList) throws XMPexception {
        this.setupFinalizer(blockList, this._globalDecl.declExternFunc("_XMP_pop_nodes"), null);
        BlockList blockList2 = Bcons.emptyBody();
        Ident ident = blockList2.declLocalIdent("_XMP_TASK_desc", Xtype.voidPtrType, StorageClass.AUTO, Xcons.Cast(Xtype.voidPtrType, Xcons.IntConstant(0)));
        xobjList.cons(ident.getAddr());
        Ident ident2 = this._globalDecl.declExternFunc("_XMP_exec_task_" + string, Xtype.intType);
        Block block = Bcons.IF(BasicBlock.Cond(ident2.Call(xobjList)), blockList, null);
        blockList2.add(block);
        Ident ident3 = this._globalDecl.declExternFunc("_XMP_exec_task_NODES_FINALIZE", Xtype.voidType);
        XobjList xobjList2 = Xcons.List(Xcode.POINTER_REF, ident.Ref());
        blockList2.add(ident3.Call(xobjList2));
        return Bcons.COMPOUND(blockList2);
    }

    private void translateBarrier(PragmaBlock pragmaBlock) throws XMPexception {
        Object object;
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(pragmaBlock);
        Block block = null;
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        if (xobjList2 == null || xobjList2.Nargs() == 0) {
            block = this._globalDecl.createFuncCallBlock("_XMP_barrier_EXEC", null);
        } else {
            object = this.createExecOnRefArgs(xobjList2, pragmaBlock);
            String string = ((XMPquadruplet)object).getFirst();
            boolean bl = ((XMPquadruplet)object).getSecond();
            XobjList xobjList3 = (XobjList)((XMPquadruplet)object).getThird();
            if (bl) {
                BlockList blockList = Bcons.blockList(this._globalDecl.createFuncCallBlock("_XMP_barrier_EXEC", null));
                block = this.createCommTaskBlock(blockList, string, xobjList3);
            } else {
                block = this._globalDecl.createFuncCallBlock("_XMP_barrier_" + string, xobjList3);
            }
        }
        pragmaBlock.replace(block);
        object = xobjList.getArg(1);
        this.addProfileFunctions((Xobject)object, block, "barrier", pragmaBlock);
    }

    private Xobject setStartLengthSize(Xobject xobject, Xtype xtype, int n, Xobject[] xobjectArray, Xobject[] xobjectArray2, Xobject[] xobjectArray3) throws XMPexception {
        Xobject xobject2 = null;
        for (int i = 0; i < n; ++i) {
            Xobject xobject3 = xobject.getArg(1).getArg(i);
            xobjectArray3[i] = XMPutil.getArrayElmt(xtype, i);
            if (xobject3.isVariable() || xobject3.isIntConstant()) {
                xobjectArray[i] = xobject3;
                xobjectArray2[i] = Xcons.IntConstant(1);
            } else {
                xobjectArray[i] = xobject3.getArg(0);
                xobjectArray2[i] = xobject3.getArg(1).isVariable() || xobject3.getArg(1).isIntConstant() ? xobject3.getArg(1) : (xobject3.getArg(1) == null || xobject3.getArg(1).isEmpty() ? Xcons.binaryOp(Xcode.MINUS_EXPR, xobjectArray3[i], xobjectArray[i]) : xobject3.getArg(1));
            }
            xobject2 = i == 0 ? xobjectArray2[i] : Xcons.binaryOp(Xcode.MUL_EXPR, xobject2, xobjectArray2[i]);
        }
        return xobject2;
    }

    private void setAccSize(int n, Xobject[] xobjectArray, Xobject[] xobjectArray2) {
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                xobjectArray2[i] = j == i + 1 ? xobjectArray[j] : Xcons.binaryOp(Xcode.MUL_EXPR, xobjectArray2[i], xobjectArray[j]);
            }
        }
        xobjectArray2[n - 1] = Xcons.IntConstant(1);
    }

    private Xobject calcOffsetSize(int n, Xobject[] xobjectArray, Xobject[] xobjectArray2, Xtype xtype) {
        Xobject xobject = Xcons.binaryOp(Xcode.MUL_EXPR, xobjectArray[0], xobjectArray2[0]);
        for (int i = 1; i < n; ++i) {
            xobject = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject, Xcons.binaryOp(Xcode.MUL_EXPR, xobjectArray[i], xobjectArray2[i]));
        }
        return Xcons.binaryOp(Xcode.MUL_EXPR, xobject, Xcons.SizeOf(xtype.getArrayElementType()));
    }

    private void createLocReduction(PragmaBlock pragmaBlock, XobjList xobjList, Xobject xobject, XobjList xobjList2) throws XMPexception {
        Xobject xobject2;
        Object object;
        Xobject xobject3 = xobjList.getArg(1).getArg(0).getArg(0);
        int n = xobjList.getArg(1).Nargs() - 1;
        BlockList blockList = Bcons.emptyBody();
        String string = xobject3.getName();
        Ident ident = pragmaBlock.findVarIdent(string);
        Xtype xtype = ident.Type();
        XobjList xobjList3 = Xcons.List(Xcons.IntConstant(n), Xcons.Cast(BasicType.longdoubleType, xobject3), ident.getAddr(), XMP.createBasicTypeConstantObj(xtype));
        blockList.add(this._globalDecl.createFuncCallBlock("xmp_reduce_loc_init", xobjList3));
        for (int i = 0; i < n; ++i) {
            Xobject xobject4;
            Xobject xobject5;
            Xtype xtype2;
            Ident ident2;
            String string2;
            object = xobjList.getArg(1).getArg(i + 1);
            boolean bl = ((Xobject)object).isVarRef();
            if (bl) {
                string2 = ((Xobject)object).getName();
                ident2 = pragmaBlock.findVarIdent(string2);
                xtype2 = ident2.Type();
                xobject5 = ident2.getAddr();
                xobject2 = Xcons.IntConstant(1);
                xobject4 = Xcons.SizeOf(xtype2);
            } else {
                string2 = ((Xobject)object).getArg(0).getName();
                ident2 = pragmaBlock.findVarIdent(string2);
                xtype2 = ident2.Type();
                int n2 = xtype2.getNumDimensions();
                Xobject[] xobjectArray = new Xobject[n2];
                Xobject[] xobjectArray2 = new Xobject[n2];
                Xobject[] xobjectArray3 = new Xobject[n2];
                Xobject xobject6 = this.setStartLengthSize((Xobject)object, xtype2, n2, xobjectArray, xobjectArray2, xobjectArray3);
                if (!this.check_contiguous_of_array(n2, xobjectArray2, xobjectArray3)) {
                    throw new XMPexception("Stride bcast operation is not supported");
                }
                Xobject[] xobjectArray4 = new Xobject[n2];
                this.setAccSize(n2, xobjectArray3, xobjectArray4);
                Xobject xobject7 = this.calcOffsetSize(n2, xobjectArray, xobjectArray4, xtype2);
                xobject5 = Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.Cast(Xtype.Pointer(BasicType.charType), ident2.Ref()), xobject7);
                xobject2 = xobject6;
                xobject4 = Xcons.SizeOf(xtype2.getArrayElementType());
            }
            xobjList3 = Xcons.List(xobject5, xobject2, xobject4);
            blockList.add(this._globalDecl.createFuncCallBlock("xmp_reduce_loc_set", xobjList3));
        }
        xobjList3 = Xcons.List(xobject);
        blockList.add(this._globalDecl.createFuncCallBlock("xmp_reduce_loc_execute", xobjList3));
        Block block = null;
        if (xobjList2 != null && xobjList2.Nargs() != 0) {
            object = this.createExecOnRefArgs(xobjList2, pragmaBlock);
            String string3 = (String)((XMPquadruplet)object).getFirst();
            boolean bl = (Boolean)((XMPquadruplet)object).getSecond();
            xobject2 = (XobjList)((XMPquadruplet)object).getThird();
            block = bl ? this.createCommTaskBlock(blockList, string3, (XobjList)xobject2) : Bcons.COMPOUND(blockList);
        } else {
            block = Bcons.COMPOUND(blockList);
        }
        pragmaBlock.replace(block);
    }

    private void translateReduction(PragmaBlock pragmaBlock) throws XMPexception {
        Xobject xobject;
        Object object;
        Object object2;
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(pragmaBlock);
        XobjList xobjList2 = (XobjList)xobjList.getArg(3);
        boolean bl = xobjList2.hasIdent("host");
        boolean bl2 = xobjList2.hasIdent("acc");
        if (!bl && !bl2) {
            bl = true;
        } else if (bl && bl2) {
            throw new XMPexception(pragmaBlock.getLineNo(), "reduction for both acc and host is unimplemented");
        }
        XobjList xobjList3 = (XobjList)xobjList.getArg(0);
        XobjInt xobjInt = (XobjInt)xobjList3.getArg(0);
        XobjList xobjList4 = (XobjList)xobjList.getArg(1);
        if (xobjInt.getInt() == 317 || xobjInt.getInt() == 318) {
            this.createLocReduction(pragmaBlock, xobjList3, xobjInt, xobjList4);
            return;
        }
        Block block = null;
        Vector<XobjList> vector = this.createReductionArgsList(xobjList3, pragmaBlock, false, null, null);
        String string = this.createReductionFuncType(xobjList3, pragmaBlock, bl2);
        if (xobjList4 == null || xobjList4.Nargs() == 0) {
            block = this.createReductionFuncCallBlock(true, string + "_EXEC", null, vector);
        } else {
            object2 = this.createExecOnRefArgs(xobjList4, pragmaBlock);
            object = ((XMPquadruplet)object2).getFirst();
            boolean bl3 = ((XMPquadruplet)object2).getSecond();
            xobject = ((XMPquadruplet)object2).getThird();
            if (bl3) {
                BlockList blockList = Bcons.blockList(this.createReductionFuncCallBlock(true, string + "_EXEC", null, vector));
                block = this.createCommTaskBlock(blockList, (String)object, (XobjList)xobject);
            } else {
                block = this.createReductionFuncCallBlock(false, string + "_" + (String)object, ((XobjList)xobject).operand(), vector);
            }
        }
        if (bl2) {
            object2 = Xcons.List();
            object = (XobjList)xobjList3.getArg(1);
            Iterator<Xobject> iterator = ((XobjList)object).iterator();
            while (iterator.hasNext()) {
                xobject = iterator.next();
                ((XobjList)object2).add(xobject.getArg(0));
            }
            block = Bcons.PRAGMA(Xcode.ACC_PRAGMA, "HOST_DATA", Xcons.List(Xcons.List(new Xobject[]{Xcons.String("USE_DEVICE"), object2})), Bcons.blockList(block));
        }
        if (((Xobject)(object2 = xobjList.getArg(2))).Opcode() != Xcode.LIST) {
            if (!XmOption.isAsync()) {
                XMP.error(pragmaBlock.getLineNo(), "MPI-3 is required to use the async clause on a reduction directive");
            }
            object = block.getBody();
            ((BlockList)object).insert(this._globalDecl.declExternFunc("xmpc_init_async").Call(Xcons.List(new Xobject[]{object2})));
            ((BlockList)object).add(this._globalDecl.declExternFunc("xmpc_start_async").Call(Xcons.List()));
        }
        pragmaBlock.replace(block);
        object = xobjList.getArg(4);
        this.addProfileFunctions((Xobject)object, block, "reduction", pragmaBlock);
    }

    private String createReductionFuncType(XobjList xobjList, PragmaBlock pragmaBlock, boolean bl) throws XMPexception {
        XobjInt xobjInt = (XobjInt)xobjList.getArg(0);
        switch (xobjInt.getInt()) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 316: 
            case 317: 
            case 318: {
                return bl ? new String("reduce_acc") : new String("reduce");
            }
            case 310: 
            case 311: 
            case 312: 
            case 313: {
                return bl ? new String("reduce_acc_FLMM") : new String("reduce_FLMM");
            }
        }
        throw new XMPexception("unknown reduce operation");
    }

    private Vector<XobjList> createReductionArgsList(XobjList xobjList, PragmaBlock pragmaBlock, boolean bl, CforBlock cforBlock, IfBlock ifBlock) throws XMPexception {
        Vector<XobjList> vector = new Vector<XobjList>();
        XobjInt xobjInt = (XobjInt)xobjList.getArg(0);
        XobjList xobjList2 = (XobjList)xobjList.getArg(1);
        for (XobjArgs xobjArgs = xobjList2.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            Object object;
            Object object2;
            Xtype xtype;
            Ident ident;
            XobjList xobjList3 = (XobjList)xobjArgs.getArg();
            String string = xobjList3.getArg(0).getString();
            XMPalignedArray xMPalignedArray = this._globalDecl.getXMPalignedArray(string, pragmaBlock);
            if (xMPalignedArray != null) {
                ident = xMPalignedArray.getAddrId();
                xtype = xMPalignedArray.getArrayType();
            } else {
                XMPpair<Ident, Xtype> xMPpair = XMPutil.findTypedVar(string, pragmaBlock);
                ident = xMPpair.getFirst();
                xtype = xMPpair.getSecond();
            }
            boolean bl2 = false;
            boolean bl3 = false;
            Xobject xobject = null;
            Xobject xobject2 = null;
            Xobject xobject3 = null;
            BasicType basicType = null;
            switch (xtype.getKind()) {
                case 1: {
                    basicType = (BasicType)xtype;
                    this.checkReductionType(string, basicType);
                    xobject = ident.getAddr();
                    xobject2 = Xcons.LongLongConstant(0L, 1L);
                    xobject3 = XMP.createBasicTypeConstantObj(basicType);
                    break;
                }
                case 6: {
                    bl2 = true;
                    object2 = (ArrayType)xtype;
                    if (((ArrayType)object2).getArrayElementType().getKind() != 1) {
                        throw new XMPexception("array '" + string + "' has a wrong data type for reduction");
                    }
                    basicType = (BasicType)((ArrayType)object2).getArrayElementType();
                    this.checkReductionType(string, basicType);
                    object = XMPlocalDecl.declXMPsymbolTable(pragmaBlock);
                    if (xMPalignedArray == null) {
                        xobject = ident.Ref();
                        xobject2 = Xcons.LongLongConstant(0L, XMPutil.getArrayElmtCount((Xtype)object2));
                    } else {
                        if (bl) {
                            throw new XMPexception("aligned arrays cannot be used in reduction clause");
                        }
                        if (xMPalignedArray.hasShadow()) {
                            throw new XMPexception("arrays which have shadow cannot be used in reduction directive/clause");
                        }
                        xobject = xMPalignedArray.getAddrIdVoidRef();
                        Ident ident2 = this._globalDecl.declExternFunc("_XMP_get_array_total_elmts", Xtype.unsignedlonglongType);
                        xobject2 = ident2.Call(Xcons.List(xMPalignedArray.getDescId().Ref()));
                    }
                    xobject3 = XMP.createBasicTypeConstantObj(basicType);
                    break;
                }
                case 7: {
                    bl3 = true;
                    basicType = (BasicType)xtype.getRef();
                    xobject = ident.getAddr();
                    xobject2 = Xcons.LongLongConstant(0L, 1L);
                    xobject3 = XMP.createBasicTypeConstantObj(basicType);
                    break;
                }
                default: {
                    throw new XMPexception("'" + string + "' has a wrong data type for reduction");
                }
            }
            object2 = Xcons.List(xobject, xobject2, xobject3, xobjInt);
            if (bl) {
                this.createReductionInitStatement(ident, bl2, xobject2, basicType, xobjInt.getInt(), cforBlock, ifBlock);
            }
            if (bl3) {
                object = ((XobjList)object2).getArg(0);
                ((XobjList)object2).setArg(0, Xcons.PointerRef((Xobject)object));
            }
            this.createFLMMreductionArgs(xobjInt.getInt(), (XobjList)xobjList3.getArg(1), (XobjList)object2, pragmaBlock);
            vector.add((XobjList)object2);
        }
        return vector;
    }

    private void createReductionInitStatement(Ident ident, boolean bl, Xobject xobject, BasicType basicType, int n, CforBlock cforBlock, IfBlock ifBlock) throws XMPexception {
        if (!this.needsInitialization(n)) {
            return;
        }
        BlockList blockList = ifBlock.getThenBody();
        if (blockList == null) {
            blockList = Bcons.emptyBody();
            ifBlock.setThenBody(blockList);
        }
        Object var9_9 = null;
        if (bl) {
            Ident ident2 = XMPtranslateLocalPragma.declIdentWithBlock(cforBlock, this._globalDecl.genSym("_XMP_TEMP"), Xtype.unsignedlonglongType);
            blockList.add(this.createReductionArrayInit(ident, this.createReductionInitValueObj(ident, basicType, n), xobject, basicType, ident2));
        } else {
            blockList.add(Xcons.Set(ident.Ref(), this.createReductionInitValueObj(ident, basicType, n)));
        }
    }

    private boolean needsInitialization(int n) throws XMPexception {
        switch (n) {
            case 300: 
            case 301: 
            case 306: 
            case 307: 
            case 316: {
                return true;
            }
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: {
                return false;
            }
        }
        throw new XMPexception("unknown reduce operation");
    }

    private Block createReductionArrayInit(Ident ident, Xobject xobject, Xobject xobject2, BasicType basicType, Ident ident2) {
        Xobject xobject3 = ident2.Ref();
        Xobject xobject4 = Xcons.PointerRef(Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.Cast(Xtype.Pointer(basicType), ident.Ref()), xobject3));
        Block block = Bcons.FOR(Xcons.Set(xobject3, Xcons.IntConstant(0)), Xcons.binaryOp(Xcode.LOG_LT_EXPR, xobject3, xobject2), Xcons.asgOp(Xcode.ASG_PLUS_EXPR, xobject3, Xcons.IntConstant(1)), Bcons.Statement(Xcons.Set(xobject4, xobject)));
        return block;
    }

    private Xobject createReductionInitValueObj(Ident ident, BasicType basicType, int n) throws XMPexception {
        Xobject xobject = ident.Ref();
        XobjInt xobjInt = Xcons.IntConstant(0);
        XobjInt xobjInt2 = Xcons.IntConstant(1);
        XobjFloat xobjFloat = Xcons.FloatConstant(0.0);
        XobjFloat xobjFloat2 = Xcons.FloatConstant(1.0);
        switch (basicType.getBasicType()) {
            case 2: {
                return this.selectReductionInitValueObj(n, xobject, xobjInt, xobjInt2);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return this.selectReductionInitValueObj(n, xobject, xobjInt, xobjInt2);
            }
            case 13: 
            case 14: 
            case 15: {
                return this.selectReductionInitValueObj(n, xobject, xobjFloat, xobjFloat2);
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                throw new XMPexception("not implemented yet");
            }
        }
        throw new XMPexception("wrong data type for reduction");
    }

    private Xobject selectReductionInitValueObj(int n, Xobject xobject, Xobject xobject2, Xobject xobject3) throws XMPexception {
        switch (n) {
            case 300: 
            case 316: {
                return xobject2;
            }
            case 301: {
                return xobject3;
            }
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: {
                throw new XMPexception("the operation does not need initialization");
            }
            case 306: {
                return Xcons.unaryOp(Xcode.BIT_NOT_EXPR, xobject);
            }
            case 307: {
                return Xcons.unaryOp(Xcode.LOG_NOT_EXPR, xobject);
            }
        }
        throw new XMPexception("unknown reduce operation");
    }

    private void createFLMMreductionArgs(int n, XobjList xobjList, XobjList xobjList2, PragmaBlock pragmaBlock) throws XMPexception {
        switch (n) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 316: 
            case 317: 
            case 318: {
                return;
            }
            case 310: 
            case 311: 
            case 312: 
            case 313: {
                break;
            }
            default: {
                throw new XMPexception("unknown reduce operation");
            }
        }
        xobjList2.add(Xcons.IntConstant(XMPutil.countElmts(xobjList)));
        block9: for (XobjArgs xobjArgs = xobjList.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            String string = xobjArgs.getArg().getString();
            XMPpair<Ident, Xtype> xMPpair = XMPutil.findTypedVar(string, pragmaBlock);
            Ident ident = xMPpair.getFirst();
            Xtype xtype = xMPpair.getSecond();
            switch (xtype.getKind()) {
                case 1: {
                    Xtype xtype2 = (BasicType)xtype;
                    xobjList2.add(Xcons.Cast(Xtype.voidPtrType, ident.getAddr()));
                    xobjList2.add(Xcons.Cast(Xtype.intType, XMP.createBasicTypeConstantObj(xtype2)));
                    continue block9;
                }
                case 6: {
                    Xtype xtype2 = (ArrayType)xtype;
                    if (((ArrayType)xtype2).getArrayElementType().getKind() != 1) {
                        throw new XMPexception("array '" + string + "' has has a wrong data type for reduction");
                    }
                    BasicType basicType = (BasicType)((ArrayType)xtype2).getArrayElementType();
                    if (!XMPutil.isIntegerType(basicType)) {
                        throw new XMPexception("'" + string + "' should have a integer type for reduction");
                    }
                    xobjList2.add(Xcons.Cast(Xtype.voidPtrType, ident.Ref()));
                    xobjList2.add(Xcons.Cast(Xtype.intType, XMP.createBasicTypeConstantObj(basicType)));
                    continue block9;
                }
                case 7: {
                    Xtype xtype2 = (PointerType)xtype;
                    BasicType basicType = (BasicType)((PointerType)xtype2).getRef();
                    xobjList2.add(Xcons.Cast(Xtype.voidPtrType, ident.Ref()));
                    xobjList2.add(Xcons.Cast(Xtype.intType, XMP.createBasicTypeConstantObj(basicType)));
                    continue block9;
                }
                default: {
                    throw new XMPexception("'" + string + "' has a wrong data type for reduction");
                }
            }
        }
    }

    private void checkReductionType(String string, BasicType basicType) throws XMPexception {
        switch (basicType.getBasicType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            default: {
                throw new XMPexception("'" + string + "' has a wrong data type for reduction");
            }
        }
    }

    private Block createReductionFuncCallBlock(boolean bl, String string, Xobject xobject, Vector<XobjList> vector) {
        Ident ident = null;
        ident = bl ? XMP.getMacroId("_XMP_M_" + string.toUpperCase()) : this._globalDecl.declExternFunc("_XMP_" + string);
        BlockList blockList = Bcons.emptyBody();
        for (XobjList xobjList : vector) {
            if (xobject != null) {
                xobjList.cons(xobject);
            }
            blockList.add(Bcons.Statement(ident.Call(xobjList)));
        }
        return Bcons.COMPOUND(blockList);
    }

    private void translateBcast(PragmaBlock pragmaBlock) throws XMPexception {
        Object object;
        Object object2;
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(pragmaBlock);
        XobjList xobjList2 = (XobjList)xobjList.getArg(4);
        boolean bl = xobjList2.hasIdent("acc");
        boolean bl2 = xobjList2.hasIdent("host");
        if (!bl && !bl2) {
            bl2 = true;
        }
        if (bl && bl2) {
            throw new XMPexception(pragmaBlock.getLineNo(), "bcast for both acc and host is unimplemented");
        }
        XobjList xobjList3 = (XobjList)xobjList.getArg(0);
        Vector<XobjList> vector = this.createBcastArgsList(xobjList3, pragmaBlock);
        Block block = null;
        XobjList xobjList4 = (XobjList)xobjList.getArg(1);
        XMPpair<String, XobjList> xMPpair = null;
        if (xobjList4 != null && xobjList4.Nargs() != 0) {
            xMPpair = this.createExecFromRefArgs(xobjList4, pragmaBlock);
        }
        XobjList xobjList5 = (XobjList)xobjList.getArg(2);
        boolean bl3 = false;
        if (xobjList5 == null || xobjList5.getArgs() == null) {
            block = this.createBcastFuncCallBlock(true, "EXEC", null, vector, xMPpair, bl);
        } else {
            object2 = this.createExecOnRefArgs(xobjList5, pragmaBlock);
            object = ((XMPquadruplet)object2).getFirst();
            bl3 = ((XMPquadruplet)object2).getSecond();
            XobjList xobjList6 = (XobjList)((XMPquadruplet)object2).getThird();
            if (bl3) {
                BlockList blockList = Bcons.blockList(this.createBcastFuncCallBlock(true, "EXEC", null, vector, xMPpair, bl));
                block = this.createCommTaskBlock(blockList, (String)object, xobjList6);
            } else {
                block = this.createBcastFuncCallBlock(false, (String)object, xobjList6.operand(), vector, xMPpair, bl);
            }
        }
        if (bl) {
            block = Bcons.PRAGMA(Xcode.ACC_PRAGMA, "HOST_DATA", Xcons.List(Xcons.List(Xcons.String("USE_DEVICE"), xobjList3)), Bcons.blockList(block));
        }
        if (((Xobject)(object2 = xobjList.getArg(3))).Opcode() != Xcode.LIST) {
            if (!XmOption.isAsync()) {
                XMP.error(pragmaBlock.getLineNo(), "MPI-3 is required to use the async clause on a bcast directive");
            }
            object = block.getBody();
            ((BlockList)object).insert(this._globalDecl.declExternFunc("xmpc_init_async").Call(Xcons.List(new Xobject[]{object2})));
            ((BlockList)object).add(this._globalDecl.declExternFunc("xmpc_start_async").Call(Xcons.List()));
        }
        pragmaBlock.replace(block);
        object = xobjList.getArg(5);
        this.addProfileFunctions((Xobject)object, block, "bcast", pragmaBlock);
    }

    private boolean check_all(Xobject xobject, Xobject xobject2) {
        return xobject.equals(xobject2);
    }

    private boolean check_one(Xobject xobject) {
        return xobject.equals(Xcons.IntConstant(1));
    }

    private boolean check_contiguous_of_array(int n, Xobject[] xobjectArray, Xobject[] xobjectArray2) throws XMPexception {
        boolean bl = false;
        switch (n) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                if (!this.check_one(xobjectArray[0]) && !this.check_all(xobjectArray[1], xobjectArray2[1])) break;
                bl = true;
                break;
            }
            case 3: {
                if (!(this.check_one(xobjectArray[0]) && this.check_one(xobjectArray[1]) || this.check_one(xobjectArray[0]) && this.check_all(xobjectArray[2], xobjectArray2[2])) && (!this.check_all(xobjectArray[1], xobjectArray2[1]) || !this.check_all(xobjectArray[2], xobjectArray2[2]))) break;
                bl = true;
                break;
            }
            case 4: {
                if (!(this.check_one(xobjectArray[0]) && this.check_one(xobjectArray[1]) && this.check_one(xobjectArray[2]) || this.check_one(xobjectArray[0]) && this.check_one(xobjectArray[1]) && this.check_all(xobjectArray[3], xobjectArray2[3]) || this.check_one(xobjectArray[0]) && this.check_all(xobjectArray[2], xobjectArray2[2]) && this.check_all(xobjectArray[3], xobjectArray2[3])) && (!this.check_all(xobjectArray[1], xobjectArray2[1]) || !this.check_all(xobjectArray[2], xobjectArray2[2]) || !this.check_all(xobjectArray[3], xobjectArray2[3]))) break;
                bl = true;
                break;
            }
            case 5: {
                if (!(this.check_one(xobjectArray[0]) && this.check_one(xobjectArray[1]) && this.check_one(xobjectArray[2]) && this.check_one(xobjectArray[3]) || this.check_one(xobjectArray[0]) && this.check_one(xobjectArray[1]) && this.check_one(xobjectArray[2]) && this.check_all(xobjectArray[4], xobjectArray2[4]) || this.check_one(xobjectArray[0]) && this.check_one(xobjectArray[1]) && this.check_all(xobjectArray[3], xobjectArray2[3]) && this.check_all(xobjectArray[4], xobjectArray2[4]) || this.check_one(xobjectArray[0]) && this.check_all(xobjectArray[2], xobjectArray2[2]) && this.check_all(xobjectArray[3], xobjectArray2[3]) && this.check_all(xobjectArray[4], xobjectArray2[4])) && (!this.check_all(xobjectArray[1], xobjectArray2[1]) || !this.check_all(xobjectArray[2], xobjectArray2[2]) || !this.check_all(xobjectArray[3], xobjectArray2[3]) || !this.check_all(xobjectArray[4], xobjectArray2[4]))) break;
                bl = true;
                break;
            }
            case 6: {
                if (!(this.check_one(xobjectArray[0]) && this.check_one(xobjectArray[1]) && this.check_one(xobjectArray[2]) && this.check_one(xobjectArray[3]) && this.check_one(xobjectArray[4]) || this.check_one(xobjectArray[0]) && this.check_one(xobjectArray[1]) && this.check_one(xobjectArray[2]) && this.check_one(xobjectArray[3]) && this.check_all(xobjectArray[5], xobjectArray2[5]) || this.check_one(xobjectArray[0]) && this.check_one(xobjectArray[1]) && this.check_one(xobjectArray[2]) && this.check_all(xobjectArray[4], xobjectArray2[4]) && this.check_all(xobjectArray[5], xobjectArray2[5]) || this.check_one(xobjectArray[0]) && this.check_one(xobjectArray[1]) && this.check_all(xobjectArray[3], xobjectArray2[3]) && this.check_all(xobjectArray[4], xobjectArray2[4]) && this.check_all(xobjectArray[5], xobjectArray2[5]) || this.check_one(xobjectArray[0]) && this.check_all(xobjectArray[2], xobjectArray2[2]) && this.check_all(xobjectArray[3], xobjectArray2[3]) && this.check_all(xobjectArray[4], xobjectArray2[4]) && this.check_all(xobjectArray[5], xobjectArray2[5])) && (!this.check_all(xobjectArray[1], xobjectArray2[1]) || !this.check_all(xobjectArray[2], xobjectArray2[2]) || !this.check_all(xobjectArray[3], xobjectArray2[3]) || !this.check_all(xobjectArray[4], xobjectArray2[4]) || !this.check_all(xobjectArray[5], xobjectArray2[5]))) break;
                bl = true;
                break;
            }
            case 7: {
                if (!(this.check_one(xobjectArray[0]) && this.check_one(xobjectArray[1]) && this.check_one(xobjectArray[2]) && this.check_one(xobjectArray[3]) && this.check_one(xobjectArray[4]) && this.check_one(xobjectArray[5]) || this.check_one(xobjectArray[0]) && this.check_one(xobjectArray[1]) && this.check_one(xobjectArray[2]) && this.check_one(xobjectArray[3]) && this.check_one(xobjectArray[4]) && this.check_all(xobjectArray[6], xobjectArray2[6]) || this.check_one(xobjectArray[0]) && this.check_one(xobjectArray[1]) && this.check_one(xobjectArray[2]) && this.check_one(xobjectArray[3]) && this.check_all(xobjectArray[5], xobjectArray2[5]) && this.check_all(xobjectArray[6], xobjectArray2[6]) || this.check_one(xobjectArray[0]) && this.check_one(xobjectArray[1]) && this.check_one(xobjectArray[2]) && this.check_all(xobjectArray[4], xobjectArray2[4]) && this.check_all(xobjectArray[5], xobjectArray2[5]) && this.check_all(xobjectArray[6], xobjectArray2[6]) || this.check_one(xobjectArray[0]) && this.check_one(xobjectArray[1]) && this.check_all(xobjectArray[3], xobjectArray2[3]) && this.check_all(xobjectArray[4], xobjectArray2[4]) && this.check_all(xobjectArray[5], xobjectArray2[5]) && this.check_all(xobjectArray[6], xobjectArray2[6]) || this.check_one(xobjectArray[0]) && this.check_all(xobjectArray[2], xobjectArray2[2]) && this.check_all(xobjectArray[3], xobjectArray2[3]) && this.check_all(xobjectArray[4], xobjectArray2[4]) && this.check_all(xobjectArray[5], xobjectArray2[5]) && this.check_all(xobjectArray[6], xobjectArray2[6])) && (!this.check_all(xobjectArray[1], xobjectArray2[1]) || !this.check_all(xobjectArray[2], xobjectArray2[2]) || !this.check_all(xobjectArray[3], xobjectArray2[3]) || !this.check_all(xobjectArray[4], xobjectArray2[4]) || !this.check_all(xobjectArray[5], xobjectArray2[5]) || !this.check_all(xobjectArray[6], xobjectArray2[6]))) break;
                bl = true;
                break;
            }
            default: {
                throw new XMPexception("A wrong data type for broadcast");
            }
        }
        return bl;
    }

    private Vector<XobjList> createBcastArgsList(XobjList xobjList, PragmaBlock pragmaBlock) throws XMPexception {
        Vector<XobjList> vector = new Vector<XobjList>();
        for (XobjArgs xobjArgs = xobjList.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            Object object;
            Xobject[] xobjectArray;
            Xobject[] xobjectArray2;
            Xobject[] xobjectArray3;
            Xtype xtype;
            Ident ident;
            XMPpair<Ident, Xtype> xMPpair;
            String string;
            if (xobjArgs.getArg().isVariable()) {
                string = xobjArgs.getArg().getString();
                xMPpair = XMPutil.findTypedVar(string, pragmaBlock);
                ident = xMPpair.getFirst();
                xtype = xMPpair.getSecond();
                XobjLong xobjLong = null;
                switch (xtype.getKind()) {
                    case 1: 
                    case 3: 
                    case 4: {
                        xobjLong = Xcons.LongLongConstant(0L, 1L);
                        vector.add(Xcons.List(ident.getAddr(), xobjLong, Xcons.SizeOf(xtype)));
                        break;
                    }
                    case 7: {
                        xobjLong = Xcons.LongLongConstant(0L, 1L);
                        vector.add(Xcons.List(ident.Ref(), xobjLong, Xcons.SizeOf(xtype)));
                        break;
                    }
                    case 6: {
                        xobjectArray3 = (Xobject[])xtype;
                        switch (xobjectArray3.getArrayElementType().getKind()) {
                            case 1: 
                            case 3: 
                            case 4: {
                                break;
                            }
                            default: {
                                throw new XMPexception("array '" + string + "' has has a wrong data type for broadcast");
                            }
                        }
                        if (xobjectArray3.getArraySizeExpr() == null) {
                            xobjLong = Xcons.LongLongConstant(0L, XMPutil.getArrayElmtCount((Xtype)xobjectArray3));
                            vector.add(Xcons.List(ident.Ref(), xobjLong, Xcons.SizeOf(xobjectArray3.getArrayElementType())));
                            break;
                        }
                        xobjectArray2 = Xcons.SizeOf(xobjectArray3.getArrayElementType());
                        xobjectArray = xobjectArray3.getArraySizeExpr();
                        object = xobjectArray3;
                        for (int i = 1; i < xobjectArray3.getNumDimensions(); ++i) {
                            object = (ArrayType)xobjectArray3.getRef();
                            xobjectArray = Xcons.binaryOp(Xcode.MUL_EXPR, (Xobject)xobjectArray, ((ArrayType)object).getArraySizeExpr());
                        }
                        vector.add(Xcons.List(ident.Ref(), xobjectArray, xobjectArray2));
                        break;
                    }
                    default: {
                        throw new XMPexception("'" + string + "' has a wrong data type for broadcast");
                    }
                }
                continue;
            }
            string = xobjArgs.getArg().getArg(0).getString();
            xMPpair = XMPutil.findTypedVar(string, pragmaBlock);
            ident = xMPpair.getFirst();
            xtype = xMPpair.getSecond();
            int n = xtype.getNumDimensions();
            if (n != xobjArgs.getArg().getArg(1).Nargs()) {
                throw new XMPexception(string + " has a wrong dimension");
            }
            xobjectArray3 = new Xobject[n];
            xobjectArray2 = new Xobject[n];
            xobjectArray = new Xobject[n];
            object = this.setStartLengthSize(xobjArgs.getArg(), xtype, n, xobjectArray3, xobjectArray2, xobjectArray);
            if (!this.check_contiguous_of_array(n, xobjectArray2, xobjectArray)) {
                throw new XMPexception("Stride bcast operation is not supported");
            }
            Xobject[] xobjectArray4 = new Xobject[n];
            this.setAccSize(n, xobjectArray, xobjectArray4);
            Xobject xobject = this.calcOffsetSize(n, xobjectArray3, xobjectArray4, xtype);
            vector.add(Xcons.List(new Xobject[]{Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.Cast(Xtype.Pointer(BasicType.charType), ident.Ref()), xobject), object, Xcons.SizeOf(xtype.getArrayElementType())}));
        }
        return vector;
    }

    private Block createBcastFuncCallBlock(boolean bl, String string, Xobject xobject, Vector<XobjList> vector, XMPpair<String, XobjList> xMPpair, boolean bl2) throws XMPexception {
        String string2 = null;
        XobjList xobjList = null;
        if (xMPpair == null) {
            string2 = new String(string + "_OMITTED");
        } else {
            string2 = new String(string + "_" + xMPpair.getFirst());
            xobjList = xMPpair.getSecond();
        }
        String string3 = bl2 ? "acc_" : "";
        Ident ident = null;
        ident = bl ? XMP.getMacroId("_XMP_M_BCAST_" + string3.toUpperCase() + string2) : this._globalDecl.declExternFunc("_XMP_bcast_" + string3 + string2);
        BlockList blockList = Bcons.emptyBody();
        for (XobjList xobjList2 : vector) {
            if (xobject != null) {
                xobjList2.cons(xobject);
            }
            if (xMPpair != null) {
                xobjList2.mergeList(xobjList);
            }
            blockList.add(Bcons.Statement(ident.Call(xobjList2)));
        }
        return Bcons.COMPOUND(blockList);
    }

    private XMPpair<String, XobjList> createExecFromRefArgs(XobjList xobjList, Block block) throws XMPexception {
        if (xobjList.getArg(0) == null) {
            XobjList xobjList2 = (XobjList)xobjList.getArg(1);
            XobjList xobjList3 = Xcons.List();
            if (xobjList2.getArg(0) == null) {
                throw new XMPexception("lower bound cannot be omitted in <from-ref>");
            }
            xobjList3.add(xobjList2.getArg(0));
            if (xobjList2.getArg(1) == null) {
                throw new XMPexception("upper bound cannot be omitted in <from-ref>");
            }
            xobjList3.add(xobjList2.getArg(1));
            if (xobjList2.getArg(2) == null) {
                xobjList3.add(Xcons.IntConstant(1));
            } else {
                xobjList3.add(xobjList2.getArg(2));
            }
            return new XMPpair<String, XobjList>(new String("GLOBAL"), xobjList3);
        }
        String string = xobjList.getArg(0).getString();
        XMPobject xMPobject = this._globalDecl.getXMPobject(string, block);
        if (xMPobject == null) {
            throw new XMPexception("cannot find '" + string + "' nodes/template");
        }
        if (xMPobject.getKind() == 101) {
            throw new XMPexception("template cannot be used in <from-ref>");
        }
        String string2 = xobjList.getArg(1).getTail().getString();
        boolean bl = string2.equals("SQUARE");
        xobjList.getArg(1).removeLastArgs();
        if (bl) {
            ((XobjList)xobjList.getArg(1)).reverse();
        }
        if (xobjList.getArg(1) == null) {
            throw new XMPexception("multiple source nodes indicated in bcast directive");
        }
        XobjList xobjList4 = Xcons.List(xMPobject.getDescId().Ref());
        int n = 0;
        int n2 = xMPobject.getDim();
        for (XobjArgs xobjArgs = xobjList.getArg(1).getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            if (n == n2) {
                throw new XMPexception("wrong nodes dimension indicated, too many");
            }
            XobjList xobjList5 = (XobjList)xobjArgs.getArg();
            if (xobjList5 == null || xobjList5.isEmptyList()) {
                xobjList4.add(Xcons.Cast(Xtype.intType, Xcons.IntConstant(1)));
            } else {
                Xobject xobject = null;
                Xobject xobject2 = null;
                Xobject xobject3 = null;
                xobjList4.add(Xcons.Cast(Xtype.intType, Xcons.IntConstant(0)));
                if (xobjList5.getArg(0) == null) {
                    throw new XMPexception("lower bound cannot be omitted in <from-ref>");
                }
                xobject = xobjList5.getArg(0);
                if (xMPobject.getKind() == 100 && bl) {
                    xobject = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject, Xcons.IntConstant(1));
                }
                if (xobjList5.getArg(1) == null) {
                    throw new XMPexception("upper bound cannot be omitted in <from-ref>");
                }
                xobject2 = xobjList5.getArg(1);
                if (xMPobject.getKind() == 100 && bl) {
                    xobject2 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobjList5.getArg(0), xobjList5.getArg(1));
                }
                xobject3 = xobjList5.getArg(2) == null ? Xcons.IntConstant(1) : xobjList5.getArg(2);
                xobjList4.add(Xcons.Cast(Xtype.intType, xobject));
                xobjList4.add(Xcons.Cast(Xtype.intType, xobject2));
                xobjList4.add(Xcons.Cast(Xtype.intType, xobject3));
            }
            ++n;
        }
        if (n != n2) {
            throw new XMPexception("the number of <nodes/template-subscript> should be the same with the dimension");
        }
        return new XMPpair<String, XobjList>(new String("NODES"), xobjList4);
    }

    private boolean istheSameShape(Xobject xobject, Xobject xobject2) {
        int n;
        if (xobject2.Opcode() == Xcode.ARRAY_REF || xobject2.Opcode() == Xcode.VAR) {
            return true;
        }
        if (xobject2.Opcode() != xobject.Opcode()) {
            return false;
        }
        int n2 = xobject.getArg(1).Nargs();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (xobject.getArg(1).getArg(n).Opcode() != Xcode.INDEX_RANGE) continue;
            ++n3;
        }
        n = xobject2.getArg(1).Nargs();
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            if (xobject2.getArg(1).getArg(i).Opcode() != Xcode.INDEX_RANGE) continue;
            ++n4;
        }
        return n3 == n4;
    }

    private void translateGmove(PragmaBlock pragmaBlock) throws XMPexception {
        PropObject propObject;
        Xobject xobject;
        Object object;
        Object object2;
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(pragmaBlock);
        BlockList blockList = pragmaBlock.getBody();
        Block block = Bcons.emptyBlock();
        BasicBlock basicBlock = block.getBasicBlock();
        Xobject xobject2 = xobjList.getArg(0);
        Xobject xobject3 = xobjList.getArg(1);
        XobjList xobjList2 = (XobjList)xobjList.getArg(2);
        boolean bl = xobjList2.hasIdent("acc");
        boolean bl2 = xobjList2.hasIdent("host");
        if (!bl && !bl2) {
            bl2 = true;
        } else if (bl2 && bl) {
            throw new XMPexception(pragmaBlock.getLineNo(), "gmove for both acc and host is unimplemented");
        }
        String string = "_XMP_gmove_";
        if (bl) {
            string = string + "acc_";
        }
        Xobject xobject4 = null;
        String string2 = new String("gmove directive should be written before one assign statement");
        Block block2 = blockList.getHead();
        if (block2 instanceof SimpleBlock) {
            if (block2.getNext() != null) {
                throw new XMPexception(string2);
            }
            object2 = block2.getBasicBlock().getHead();
            if (((Statement)object2).getNext() != null) {
                throw new XMPexception(string2);
            }
            if (((Statement)object2).getExpr().Opcode() != Xcode.ASSIGN_EXPR) {
                throw new XMPexception(string2);
            }
        } else {
            throw new XMPexception(string2);
        }
        xobject4 = ((Statement)object2).getExpr();
        object2 = xobject4.left();
        XMPpair<XMPalignedArray, XobjList> xMPpair = this.getXMPalignedArrayExpr(pragmaBlock, (Xobject)object2);
        XMPalignedArray xMPalignedArray = null;
        if (xMPpair != null) {
            xMPalignedArray = xMPpair.getFirst();
        }
        Xobject xobject5 = xobject4.right();
        XMPpair<XMPalignedArray, XobjList> xMPpair2 = this.getXMPalignedArrayExpr(pragmaBlock, xobject4.right());
        XMPalignedArray xMPalignedArray2 = null;
        if (xMPpair2 != null) {
            xMPalignedArray2 = xMPpair2.getFirst();
        }
        if (xMPalignedArray2 == null && xMPalignedArray == null) {
            pragmaBlock.replace(pragmaBlock.getBody().getHead());
            return;
        }
        if (xMPalignedArray2 != null) {
            object = xMPalignedArray2.getArrayId().getStorageClass();
            if (xobject2.getInt() == 401 && object != StorageClass.EXTDEF && object != StorageClass.EXTERN) {
                XMP.fatal("Current limitation: Only a SAVE or MODULE variable can be the target of gmove in/out.");
            }
        }
        if (xMPalignedArray != null) {
            object = xMPalignedArray.getArrayId().getStorageClass();
            if (xobject2.getInt() == 402 && object != StorageClass.EXTDEF && object != StorageClass.EXTERN) {
                XMP.fatal("Current limitation: Only a SAVE or MODULE variable can be the target of gmove in/out.");
            }
        }
        if (!this.istheSameShape((Xobject)object2, xobject4.right())) {
            throw new XMPexception("The shape of the right side and the shape of the left side are different.");
        }
        if (xMPalignedArray2 == null && xobject2.getInt() == 401) {
            XMP.fatal("gmove in cannot be applied to a local rhs.");
        }
        if (xMPalignedArray == null && xobject2.getInt() == 402) {
            XMP.fatal("gmove out cannot be applied to a local lhs.");
        }
        if (((Xobject)object2).Opcode() == Xcode.SUB_ARRAY_REF && xMPalignedArray != null && xMPalignedArray2 == null && xobject2.getInt() == 400) {
            object = this.convertGmoveToArray(pragmaBlock, xMPalignedArray, (Xobject)object2, xobject5);
            pragmaBlock.replace((Block)object);
            this.translateArray((PragmaBlock)object);
            return;
        }
        object = this.buildGmoveDesc((Xobject)object2, basicBlock, pragmaBlock, bl);
        Ident ident = this.buildGmoveDesc(xobject5, basicBlock, pragmaBlock, bl);
        Ident ident2 = this._globalDecl.declExternFunc(bl ? "xmpc_gmv_do_acc" : "xmpc_gmv_do", Xtype.FsubroutineType);
        XobjList xobjList3 = Xcons.List(((Ident)object).Ref(), ident.Ref(), xobject2);
        basicBlock.add(ident2.callSubroutine(xobjList3));
        Ident ident3 = this._globalDecl.declExternFunc("xmpc_gmv_dealloc", Xtype.FsubroutineType);
        XobjList xobjList4 = Xcons.List(((Ident)object).Ref());
        basicBlock.add(ident3.callSubroutine(xobjList4));
        XobjList xobjList5 = Xcons.List(ident.Ref());
        basicBlock.add(ident3.callSubroutine(xobjList5));
        if (xobject3.Opcode() != Xcode.LIST) {
            xobject = Xcons.List(xobject3);
            propObject = this._globalDecl.declExternFunc("xmpc_init_async", Xtype.FsubroutineType);
            basicBlock.insert(((Ident)propObject).callSubroutine(xobject));
            propObject = this._globalDecl.declExternFunc("xmpc_start_async", Xtype.FsubroutineType);
            basicBlock.add(((Ident)propObject).callSubroutine(xobject));
        }
        if (bl) {
            propObject = Xcons.List();
            ((XobjList)propObject).add(Xcons.Symbol(Xcode.VAR, xMPalignedArray.getName()));
            ((XobjList)propObject).add(Xcons.Symbol(Xcode.VAR, xMPalignedArray2.getName()));
            block = Bcons.PRAGMA(Xcode.ACC_PRAGMA, "HOST_DATA", Xcons.List(Xcons.List(new Xobject[]{Xcons.String("USE_DEVICE"), propObject})), Bcons.blockList(block));
        }
        propObject = Bcons.COMPOUND(Bcons.blockList(block));
        pragmaBlock.replace((Block)propObject);
        xobject = xobjList.getArg(3);
        this.addProfileFunctions(xobject, block, "gmove", pragmaBlock);
    }

    private Ident buildGmoveDesc(Xobject xobject, BasicBlock basicBlock, PragmaBlock pragmaBlock, boolean bl) throws XMPexception {
        Ident ident = pragmaBlock.getParentBlock().getBody().declLocalIdent(this.tmpSym.getStr("gmv"), Xtype.voidPtrType);
        XMPalignedArray xMPalignedArray = null;
        switch (xobject.Opcode()) {
            case ARRAY_REF: 
            case SUB_ARRAY_REF: {
                Xobject xobject2 = xobject.getArg(0);
                String string = this.getArrayName(xobject);
                xMPalignedArray = this._globalDecl.getXMPalignedArray(string, pragmaBlock);
                Xtype xtype = xMPalignedArray != null ? xMPalignedArray.getArrayType() : xobject2.Type();
                int n = xtype.getNumDimensions();
                if (xMPalignedArray != null) {
                    Ident ident2 = this._globalDecl.declExternFunc(bl ? "xmpc_gmv_g_alloc_acc" : "xmpc_gmv_g_alloc", Xtype.FsubroutineType);
                    XobjList xobjList = Xcons.List(ident.getAddr(), xMPalignedArray.getDescId().Ref());
                    if (bl) {
                        ((Xobject)xobjList).add(xMPalignedArray.getAddrId().Ref());
                    }
                    basicBlock.add(ident2.callSubroutine(xobjList));
                    XobjList xobjList2 = (XobjList)xobject.getArg(1);
                    ident2 = this._globalDecl.declExternFunc("xmpc_gmv_g_dim_info", Xtype.FsubroutineType);
                    int n2 = 0;
                    while (n2 < n) {
                        Xobject xobject3 = xobjList2.getArg(n2);
                        if (!xobject3.isIndexRange()) {
                            xobjList = Xcons.List(ident.Ref(), Xcons.IntConstant(n2), Xcons.IntConstant(1), xobject3, Xcons.IntConstant(0), Xcons.IntConstant(0));
                        } else {
                            Xobject xobject4 = ((XobjList)xobject3).getArg(0);
                            if (xobject4 == null) {
                                xobject4 = Xcons.IntConstant(0);
                            }
                            Xobject xobject5 = ((XobjList)xobject3).getArg(1);
                            Xobject xobject6 = ((XobjList)xobject3).getArg(2);
                            if (xobject6 == null) {
                                xobject6 = Xcons.IntConstant(1);
                            }
                            xobjList = Xcons.List(ident.Ref(), Xcons.IntConstant(n2), Xcons.IntConstant(2), xobject4, xobject5, xobject6);
                        }
                        basicBlock.add(ident2.callSubroutine(xobjList));
                        ++n2;
                        xtype = xtype.getRef();
                    }
                } else {
                    Ident ident3 = this._globalDecl.declExternFunc("xmpc_gmv_l_alloc", Xtype.FsubroutineType);
                    xtype = xobject2.Type();
                    if (!xtype.isArray()) {
                        if (xtype.isPointer()) {
                            n = 1;
                        } else {
                            XMP.fatal("buildGmoveDesc: SUB_ARRAY_REF for non-array");
                        }
                    }
                    XobjList xobjList = Xcons.List(ident.getAddr(), xobject2, Xcons.IntConstant(n));
                    basicBlock.add(ident3.callSubroutine(xobjList));
                    XobjInt xobjInt = Xcons.IntConstant(0);
                    XobjList xobjList3 = (XobjList)xobject.getArg(1);
                    ident3 = this._globalDecl.declExternFunc("xmpc_gmv_l_dim_info", Xtype.FsubroutineType);
                    int n3 = 0;
                    while (n3 < n) {
                        Xobject xobject7;
                        Xobject xobject8;
                        Xobject xobject9;
                        if (xtype.getKind() == 7) {
                            xobject9 = Xcons.LongLongConstant(0L, 1L);
                        } else {
                            long l = xtype.getArraySize();
                            if (l == 0L) {
                                xobject8 = XMPtranslateLocalPragma.declIdentWithBlock(pragmaBlock, "XMP_" + string + "_ret" + Integer.toString(n3), Xtype.intType);
                                xobject7 = XMPtranslateLocalPragma.declIdentWithBlock(pragmaBlock, "XMP_" + string + "_len" + Integer.toString(n3), Xtype.intType);
                                ident3 = this._globalDecl.declExternFunc("xmp_array_ubound", Xtype.intType);
                                xobjList = Xcons.List(xMPalignedArray.getDescId().Ref(), Xcons.IntConstant(n3 + 1), ((Ident)xobject7).getAddr());
                                pragmaBlock.insert(Xcons.Set(((Ident)xobject8).Ref(), Xcons.binaryOp(Xcode.MINUS_EXPR, ident3.Call(xobjList), Xcons.IntConstant(1))));
                                xobject9 = ((Ident)xobject7).Ref();
                            } else {
                                xobject9 = l == -1L ? xtype.getArraySizeExpr() : Xcons.LongLongConstant(0L, l);
                            }
                        }
                        Xobject xobject10 = xobjList3.getArg(n3);
                        if (!xobject10.isIndexRange()) {
                            xobjList = Xcons.List(ident.Ref(), Xcons.IntConstant(n3), xobjInt, xobject9, Xcons.IntConstant(1), xobject10, Xcons.IntConstant(0), Xcons.IntConstant(0));
                        } else {
                            Xobject xobject11 = ((XobjList)xobject10).getArg(0);
                            if (xobject11 == null) {
                                xobject11 = Xcons.IntConstant(0);
                            }
                            xobject8 = ((XobjList)xobject10).getArg(1);
                            xobject7 = ((XobjList)xobject10).getArg(2);
                            if (xobject7 == null) {
                                xobject7 = Xcons.IntConstant(1);
                            }
                            xobjList = Xcons.List(ident.Ref(), Xcons.IntConstant(n3), xobjInt, xobject9, Xcons.IntConstant(1), xobject11, xobject8, xobject7);
                        }
                        basicBlock.add(ident3.callSubroutine(xobjList));
                        ++n3;
                        xtype = xtype.getRef();
                    }
                }
                break;
            }
            case VAR: {
                String string = xobject.getName();
                xMPalignedArray = this._globalDecl.getXMPalignedArray(string, pragmaBlock);
                if (xMPalignedArray != null) {
                    Ident ident4 = this._globalDecl.declExternFunc("xmpc_gmv_g_alloc", Xtype.FsubroutineType);
                    XobjList xobjList = Xcons.List(ident.getAddr(), xMPalignedArray.getDescId().Ref());
                    basicBlock.add(ident4.callSubroutine(xobjList));
                    ident4 = this._globalDecl.declExternFunc("xmpc_gmv_g_dim_info", Xtype.FsubroutineType);
                    for (int i = 0; i < xMPalignedArray.getDim(); ++i) {
                        xobjList = Xcons.List(ident.Ref(), Xcons.IntConstant(i), Xcons.IntConstant(0), Xcons.IntConstant(0), Xcons.IntConstant(0), Xcons.IntConstant(0));
                        basicBlock.add(ident4.callSubroutine(xobjList));
                    }
                    break;
                }
                Ident ident5 = this._globalDecl.declExternFunc(bl ? "xmpc_gmv_l_alloc_acc" : "xmpc_gmv_l_alloc", Xtype.FsubroutineType);
                XobjList xobjList = Xcons.List(ident.Ref(), Xcons.AddrOf(xobject), Xcons.IntConstant(0));
                basicBlock.add(ident5.callSubroutine(xobjList));
                break;
            }
            default: {
                XMP.fatal("gmove must be followed by a simple assignment");
            }
        }
        return ident;
    }

    private Block convertGmoveToArray(PragmaBlock pragmaBlock, XMPalignedArray xMPalignedArray, Xobject xobject, Xobject xobject2) {
        XobjList xobjList = Xcons.List();
        XobjString xobjString = Xcons.Symbol(Xcode.VAR, xMPalignedArray.getAlignTemplate().getName());
        ((Xobject)xobjList).add(xobjString);
        XobjList xobjList2 = Xcons.List();
        for (int i = 0; i < xMPalignedArray.getAlignTemplate().getDim(); ++i) {
            ((Xobject)xobjList2).add(null);
        }
        XobjList xobjList3 = (XobjList)xobject.getArg(1);
        for (int i = 0; i < xMPalignedArray.getDim(); ++i) {
            XobjList xobjList4;
            Xobject xobject3;
            Xobject xobject4;
            Xobject xobject5;
            int n = xMPalignedArray.getAlignSubscriptIndexAt(i);
            Xobject xobject6 = xMPalignedArray.getAlignSubscriptExprAt(i);
            Xobject xobject7 = xobjList3.getArg(i);
            if (xobject7.isIndexRange()) {
                xobject5 = xobject7.getArg(0);
                if (xobject6 != null) {
                    xobject5 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject5, xobject6);
                }
                xobject4 = xobject7.getArg(1);
                xobject3 = xobject7.getArg(2);
                xobjList4 = Xcons.List(xobject5, xobject4, xobject3);
            } else {
                xobject5 = xobject7.getArg(0);
                if (xobject6 != null) {
                    xobject5 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject5, xobject6);
                }
                xobject4 = xobject5;
                xobject3 = Xcons.IntConstant(1);
                xobjList4 = Xcons.List(xobject5, xobject4, xobject3);
            }
            ((Xobject)xobjList2).setArg(n, xobjList4);
        }
        ((Xobject)xobjList).add(xobjList2);
        XobjList xobjList5 = Xcons.List(xobjList);
        return Bcons.PRAGMA(Xcode.XMP_PRAGMA, "LOOP", xobjList5, pragmaBlock.getBody());
    }

    private XMPpair<XMPalignedArray, XobjList> getXMPalignedArrayExpr(PragmaBlock pragmaBlock, Xobject xobject) throws XMPexception {
        switch (xobject.Opcode()) {
            case ARRAY_REF: {
                return this.parseArrayRefExpr(pragmaBlock, xobject);
            }
            case SUB_ARRAY_REF: {
                return this.parseSubArrayRefExpr(pragmaBlock, xobject, this.getArrayAccList(pragmaBlock, xobject));
            }
            case VAR: {
                return null;
            }
        }
        throw new XMPexception("unsupported expression: gmove");
    }

    private String getArrayName(Xobject xobject) throws XMPexception {
        if (xobject.Opcode() == Xcode.ARRAY_REF || xobject.Opcode() == Xcode.SUB_ARRAY_REF) {
            return xobject.getArg(0).getSym();
        }
        throw new XMPexception("cannot find array ref");
    }

    private XobjList getArrayAccList(PragmaBlock pragmaBlock, Xobject xobject) throws XMPexception {
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(pragmaBlock);
        XobjList xobjList = Xcons.List();
        String string = xobject.getArg(0).getSym();
        XMPalignedArray xMPalignedArray = this._globalDecl.getXMPalignedArray(string, pragmaBlock);
        if (xMPalignedArray == null) {
            Ident ident = pragmaBlock.findVarIdent(string);
            Xtype xtype = ident.Type();
            int n = xtype.getNumDimensions();
            if (n > 7) {
                throw new XMPexception("array dimension should be less than 8");
            }
            xtype = xtype.getRef();
            int n2 = 0;
            while (n2 < n - 1) {
                xobjList.add(XMPutil.getArrayElmtsObj(xtype));
                ++n2;
                xtype = xtype.getRef();
            }
            xobjList.add(Xcons.IntConstant(1));
        } else {
            int n = xMPalignedArray.getDim();
            for (int i = 0; i < n; ++i) {
                xobjList.add(xMPalignedArray.getAccIdAt(i).Ref());
            }
        }
        return xobjList;
    }

    private XMPpair<XMPalignedArray, XobjList> parseSubArrayRefExpr(PragmaBlock pragmaBlock, Xobject xobject, XobjList xobjList) throws XMPexception {
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(pragmaBlock);
        Xobject xobject2 = xobject.getArg(0);
        String string = xobject2.getSym();
        XMPalignedArray xMPalignedArray = this._globalDecl.getXMPalignedArray(string, pragmaBlock);
        XobjList xobjList2 = (XobjList)xobject.getArg(1);
        XobjList xobjList3 = Xcons.List();
        int n = 0;
        if (xobjList2 != null) {
            for (Xobject xobject3 : xobjList2) {
                if (xobject3.isIndexRange()) {
                    xobjList3.add(Xcons.Cast(Xtype.intType, xobject3.getArg(0)));
                    xobjList3.add(Xcons.Cast(Xtype.intType, xobject3.getArg(1)));
                    xobjList3.add(Xcons.Cast(Xtype.intType, xobject3.getArg(2)));
                    xobjList3.add(Xcons.Cast(Xtype.unsignedlonglongType, xobjList.getArg(n)));
                } else {
                    xobjList3.add(Xcons.Cast(Xtype.intType, xobject3));
                    xobjList3.add(Xcons.Cast(Xtype.intType, Xcons.IntConstant(1)));
                    xobjList3.add(Xcons.Cast(Xtype.intType, Xcons.IntConstant(0)));
                    xobjList3.add(Xcons.Cast(Xtype.unsignedlonglongType, xobjList.getArg(n)));
                }
                ++n;
            }
        }
        if (xMPalignedArray == null) {
            xobjList3.cons(Xcons.Cast(Xtype.intType, Xcons.IntConstant(n)));
            xobjList3.cons(Xcons.Cast(Xtype.voidPtrType, xobject2));
        }
        return new XMPpair<XMPalignedArray, XobjList>(xMPalignedArray, xobjList3);
    }

    private XMPpair<XMPalignedArray, XobjList> parseArrayRefExpr(PragmaBlock pragmaBlock, Xobject xobject) throws XMPexception {
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(pragmaBlock);
        String string = xobject.getArg(0).getSym();
        XMPalignedArray xMPalignedArray = this._globalDecl.getXMPalignedArray(string, pragmaBlock);
        XobjList xobjList = Xcons.List();
        XobjList xobjList2 = (XobjList)xobject.getArg(1);
        if (xobjList2 != null) {
            for (Xobject xobject2 : xobjList2) {
                xobjList.add(Xcons.Cast(Xtype.intType, xobject2));
            }
        }
        return new XMPpair<XMPalignedArray, XobjList>(xMPalignedArray, xobjList);
    }

    private XMPquadruplet<String, Boolean, XobjList, XMPobject> createExecOnRefArgs(XobjList xobjList, Block block) throws XMPexception {
        XobjList xobjList2;
        Object object;
        if (xobjList.getArg(0) == null) {
            XobjList xobjList3 = (XobjList)xobjList.getArg(1);
            boolean bl = false;
            XobjList xobjList4 = Xcons.List();
            if (xobjList3.getArg(0) == null) {
                xobjList4.add(Xcons.IntConstant(1));
            } else {
                bl = true;
                xobjList4.add(xobjList3.getArg(0));
            }
            if (xobjList3.getArg(1) == null) {
                xobjList4.add(this._globalDecl.getWorldSizeId().Ref());
            } else {
                bl = true;
                xobjList4.add(xobjList3.getArg(1));
            }
            if (xobjList3.getArg(2) == null) {
                xobjList4.add(Xcons.IntConstant(1));
            } else {
                bl = true;
                xobjList4.add(xobjList3.getArg(2));
            }
            String string = null;
            XobjList xobjList5 = null;
            if (bl) {
                string = "GLOBAL_PART";
                xobjList5 = xobjList4;
            } else {
                string = "NODES_ENTIRE";
                xobjList5 = Xcons.List(this._globalDecl.getWorldDescId().Ref());
            }
            return new XMPquadruplet<String, Boolean, XobjList, Object>(string, new Boolean(bl), xobjList5, null);
        }
        String string = xobjList.getArg(0).getString();
        XMPobject xMPobject = this._globalDecl.getXMPobject(string, block);
        if (xMPobject == null) {
            throw new XMPexception("cannot find '" + string + "' nodes/template");
        }
        Xobject xobject = null;
        BasicType basicType = null;
        switch (xMPobject.getKind()) {
            case 100: {
                xobject = xMPobject.getDescId().Ref();
                basicType = Xtype.intType;
                break;
            }
            case 101: {
                XMPtemplate xMPtemplate = (XMPtemplate)xMPobject;
                if (!xMPtemplate.isDistributed()) {
                    throw new XMPexception("template '" + string + "' is not distributed");
                }
                XMPnodes xMPnodes = ((XMPtemplate)xMPobject).getOntoNodes();
                xobject = xMPnodes.getDescId().Ref();
                basicType = Xtype.longlongType;
                break;
            }
            default: {
                throw new XMPexception("unknown object type");
            }
        }
        if (xobjList.getArg(1) == null || xobjList.getArg(1).getArgs() == null) {
            return new XMPquadruplet<String, Boolean, XobjList, XMPobject>(new String("NODES_ENTIRE"), new Boolean(false), Xcons.List(xobject), xMPobject);
        }
        boolean bl = false;
        int n = 0;
        int n2 = xMPobject.getDim();
        String string2 = xobjList.getArg(1).getTail().getString();
        boolean bl2 = string2.equals("SQUARE");
        xobjList.getArg(1).removeLastArgs();
        if (bl2) {
            ((XobjList)xobjList.getArg(1)).reverse();
        }
        XobjList xobjList6 = Xcons.List();
        for (object = xobjList.getArg(1).getArgs(); object != null; object = ((XobjArgs)object).nextArgs()) {
            if (n == n2) {
                throw new XMPexception("wrong nodes dimension indicated, too many");
            }
            xobjList2 = (XobjList)((XobjArgs)object).getArg();
            if (xobjList2 == null || xobjList2.getArgs() == null) {
                bl = true;
                xobjList6.add(Xcons.Cast(Xtype.intType, Xcons.IntConstant(1)));
            } else {
                Xobject xobject2 = null;
                Xobject xobject3 = null;
                Xobject xobject4 = null;
                xobjList6.add(Xcons.Cast(Xtype.intType, Xcons.IntConstant(0)));
                if (xobjList2.getArg(0) == null || xobjList2.getArg(0) instanceof XobjList && xobjList2.getArg(0).getArgs() == null) {
                    xobject2 = xMPobject.getLowerAt(n);
                } else {
                    bl = true;
                    xobject2 = xobjList2.getArg(0);
                    if (xMPobject.getKind() == 100 && bl2) {
                        xobject2 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject2, Xcons.IntConstant(1));
                    }
                }
                if (xobjList2.getArg(1) == null || xobjList2.getArg(0) instanceof XobjList && xobjList2.getArg(1).getArgs() == null) {
                    xobject3 = xMPobject.getUpperAt(n);
                } else {
                    bl = true;
                    if (xMPobject.getKind() == 100 && bl2) {
                        xobject3 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobjList2.getArg(0), xobjList2.getArg(1));
                    } else if (xMPobject.getKind() == 101 && bl2) {
                        xobject3 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject2, xobjList2.getArg(1));
                        xobject3 = Xcons.binaryOp(Xcode.MINUS_EXPR, xobject3, Xcons.IntConstant(1));
                    } else {
                        xobject3 = xobjList2.getArg(1);
                    }
                }
                if (xobjList2.getArg(2) == null || xobjList2.getArg(2).equals(Xcons.IntConstant(1))) {
                    xobject4 = Xcons.IntConstant(1);
                } else {
                    bl = true;
                    xobject4 = xobjList2.getArg(2);
                }
                xobjList6.add(Xcons.Cast(basicType, xobject2));
                xobjList6.add(Xcons.Cast(basicType, xobject3));
                xobjList6.add(Xcons.Cast(basicType, xobject4));
            }
            ++n;
        }
        if (n != n2) {
            throw new XMPexception("the number of <nodes/template-subscript> should be the same with the dimension");
        }
        if (bl) {
            object = null;
            xobjList2 = null;
            xobjList2 = xobjList6;
            switch (xMPobject.getKind()) {
                case 100: {
                    object = "NODES_PART";
                    xobjList2.cons(xobject);
                    break;
                }
                case 101: {
                    object = "TEMPLATE_PART";
                    xobjList2.cons(((XMPtemplate)xMPobject).getDescId().Ref());
                    break;
                }
                default: {
                    throw new XMPexception("unknown object type");
                }
            }
            return new XMPquadruplet<Object, Boolean, XobjList, XMPobject>(object, new Boolean(bl), xobjList2, xMPobject);
        }
        return new XMPquadruplet<String, Boolean, XobjList, XMPobject>(new String("NODES_ENTIRE"), new Boolean(bl), Xcons.List(xobject), xMPobject);
    }

    private void translateArray(PragmaBlock pragmaBlock) throws XMPexception {
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(pragmaBlock);
        BlockList blockList = pragmaBlock.getBody();
        Statement statement = null;
        Xobject xobject = null;
        String string = new String("array directive should be written before one assign statement");
        Block block = blockList.getHead();
        if (block instanceof SimpleBlock) {
            if (block.getNext() != null) {
                throw new XMPexception(string);
            }
            statement = block.getBasicBlock().getHead();
            if (statement.getNext() != null) {
                throw new XMPexception(string);
            }
            if (statement.getExpr().Opcode() != Xcode.ASSIGN_EXPR) {
                throw new XMPexception(string);
            }
        } else {
            throw new XMPexception(string);
        }
        xobject = statement.getExpr();
        Block block2 = this.convertArrayToLoop(pragmaBlock, statement);
        pragmaBlock.replace(block2);
        this.translateLoop((PragmaBlock)block2, false);
    }

    private Block convertArrayToLoop(PragmaBlock pragmaBlock, Statement statement) throws XMPexception {
        Xobject xobject;
        Xobject xobject2;
        Xobject xobject3;
        Xobject xobject4;
        Object object;
        Xobject xobject5;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Xobject xobject6 = statement.getExpr();
        Xobject xobject7 = xobject6.left();
        XMPpair<XMPalignedArray, XobjList> xMPpair = this.getXMPalignedArrayExpr(pragmaBlock, xobject7);
        XMPalignedArray xMPalignedArray = xMPpair.getFirst();
        ArrayList<Object> arrayList = new ArrayList<Object>(7);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(7);
        for (int i = 0; i < 7; ++i) {
            arrayList2.add(null);
        }
        ArrayList<Object> arrayList3 = new ArrayList<Object>(7);
        ArrayList<Object> arrayList4 = new ArrayList<Object>(7);
        ArrayList<Xobject> arrayList5 = new ArrayList<Xobject>(7);
        if (xobject7.Opcode() != Xcode.SUB_ARRAY_REF) {
            throw new XMPexception("ARRAY not followed by array ref.");
        }
        String string = this.getArrayName(xobject7);
        XMPalignedArray xMPalignedArray2 = this._globalDecl.getXMPalignedArray(string, pragmaBlock);
        Xtype xtype = null;
        if (xMPalignedArray2 != null) {
            xtype = xMPalignedArray2.getArrayType();
        } else {
            object6 = pragmaBlock.findVarIdent(string);
            if (object6 != null) {
                xtype = ((Xobject)object6).Type();
            }
        }
        if (xtype == null) {
            throw new XMPexception("array should be declared statically");
        }
        object6 = xtype.getArrayElementType();
        int n = xtype.getNumDimensions();
        XobjList xobjList = (XobjList)xobject7.getArg(1);
        int n2 = 0;
        while (n2 < n) {
            Object object7;
            long l = xtype.getArraySize();
            if (l == 0L || xtype.getKind() == 7) {
                object5 = XMPtranslateLocalPragma.declIdentWithBlock(pragmaBlock, "XMP_" + string + "_ret" + Integer.toString(n2), Xtype.intType);
                object4 = XMPtranslateLocalPragma.declIdentWithBlock(pragmaBlock, "XMP_" + string + "_ub" + Integer.toString(n2), Xtype.intType);
                object3 = this._globalDecl.declExternFunc("xmp_array_ubound", Xtype.intType);
                object2 = Xcons.List(xMPalignedArray2.getDescId().Ref(), Xcons.IntConstant(n2 + 1), ((Ident)object4).getAddr());
                pragmaBlock.insert(Xcons.Set(((Ident)object5).Ref(), Xcons.binaryOp(Xcode.PLUS_EXPR, ((Ident)object3).Call((Xobject)object2), Xcons.IntConstant(n2 + 1))));
                object7 = object4;
            } else {
                object7 = l == -1L ? xtype.getArraySizeExpr() : Xcons.LongLongConstant(0L, l);
            }
            object5 = xobjList.getArg(n2);
            if (((Xobject)object5).isIndexRange()) {
                Xobject xobject8;
                object4 = XMPtranslateLocalPragma.declIdentWithBlock(pragmaBlock, "_XMP_loop_i" + Integer.toString(n2), Xtype.intType);
                arrayList.add(object4);
                if (xMPalignedArray.getAlignMannerAt(n2) != 200) {
                    arrayList2.set(xMPalignedArray.getAlignSubscriptIndexAt(n2), object4);
                }
                if ((object3 = ((XobjList)object5).getArg(0)) == null) {
                    object3 = Xcons.IntConstant(0);
                }
                if ((object2 = ((XobjList)object5).getArg(1)) == null) {
                    object2 = object7;
                }
                if ((xobject8 = ((XobjList)object5).getArg(2)) == null) {
                    xobject8 = Xcons.IntConstant(1);
                }
                arrayList3.add(object3);
                arrayList4.add(object2);
                arrayList5.add(xobject8);
                xobject5 = Xcons.binaryOp(Xcode.MUL_EXPR, ((Ident)object4).Ref(), xobject8);
                xobject5 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject5, (Xobject)object3);
                xobjList.setArg(n2, xobject5);
            }
            ++n2;
            xtype = xtype.getRef();
        }
        Xobject xobject9 = Xcons.arrayRef((Xtype)object6, xobject7.getArg(0), xobjList);
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject6);
        ((XobjectIterator)topdownXobjectIterator2).init();
        while (!((XobjectIterator)topdownXobjectIterator2).end()) {
            object = topdownXobjectIterator2.getXobject();
            if (((Xobject)object).Opcode() == Xcode.SUB_ARRAY_REF) {
                int n3 = 0;
                object5 = this.getArrayName((Xobject)object);
                object4 = this._globalDecl.getXMPalignedArray((String)object5, pragmaBlock);
                object3 = null;
                if (object4 != null) {
                    object3 = ((XMPalignedArray)object4).getArrayType();
                } else {
                    object2 = pragmaBlock.findVarIdent((String)object5);
                    if (object2 != null) {
                        object3 = ((Xobject)object2).Type();
                    }
                }
                if (object3 == null) {
                    throw new XMPexception("array should be declared statically");
                }
                object2 = ((Xtype)object3).getArrayElementType();
                int n4 = ((Xtype)object3).getNumDimensions();
                xobject5 = (XobjList)((Xobject)object).getArg(1);
                int n5 = 0;
                while (n5 < n4) {
                    Xobject xobject10 = ((XobjList)xobject5).getArg(n5);
                    if (xobject10.isIndexRange()) {
                        xobject4 = ((XobjList)xobject10).getArg(0);
                        if (xobject4 == null) {
                            xobject4 = Xcons.IntConstant(0);
                        }
                        if ((xobject3 = ((XobjList)xobject10).getArg(2)) == null) {
                            xobject3 = Xcons.IntConstant(1);
                        }
                        xobject2 = Xcons.binaryOp(Xcode.MUL_EXPR, ((Ident)arrayList.get(n3)).Ref(), xobject3);
                        xobject2 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject2, xobject4);
                        ((XobjList)xobject5).setArg(n5, xobject2);
                        ++n3;
                    }
                    ++n5;
                    object3 = ((Xtype)object3).getRef();
                }
                xobject = Xcons.arrayRef((Xtype)object2, ((Xobject)object).getArg(0), (XobjList)xobject5);
                ((XobjectIterator)topdownXobjectIterator2).setXobject(xobject);
            }
            ((XobjectIterator)topdownXobjectIterator2).next();
        }
        object = null;
        Object object8 = Bcons.emptyBody();
        ((BlockList)object8).add(Xcons.Set(xobject9, xobject6.right()));
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            object = Bcons.emptyBody();
            ((BlockList)object).add(Bcons.FORall(((Ident)arrayList.get(i)).Ref(), Xcons.IntConstant(0), (Xobject)arrayList4.get(i), Xcons.IntConstant(1), Xcode.LOG_LT_EXPR, (BlockList)object8));
            object8 = object;
        }
        XobjList xobjList2 = Xcons.List();
        object4 = Xcons.List();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (xMPalignedArray.getAlignMannerAt(i) == 200) continue;
            ((XobjList)object4).add(((Ident)arrayList.get(i)).Ref());
        }
        ((Xobject)xobjList2).add((Xobject)object4);
        XobjList xobjList3 = Xcons.List();
        object2 = pragmaBlock.getClauses().getArg(0).getArg(0).getName();
        XMPtemplate xMPtemplate = this._globalDecl.getXMPtemplate((String)object2, pragmaBlock);
        if (xMPtemplate == null) {
            throw new XMPexception("template '" + (String)object2 + "' not found");
        }
        ((Xobject)xobjList3).add(pragmaBlock.getClauses().getArg(0).getArg(0));
        xobject5 = Xcons.List();
        xobject = pragmaBlock.getClauses().getArg(0).getArg(1);
        if (xobject != null) {
            for (int i = 0; i < xobject.Nargs(); ++i) {
                Xobject xobject11 = xobject.getArg(i);
                if (xobject11.Opcode() == Xcode.LIST) {
                    Xobject xobject12;
                    xobject4 = ((XobjList)xobject11).getArg(0);
                    if (xobject4 == null || xobject4.Opcode() == Xcode.LIST && xobject4.Nargs() == 0) {
                        if (xMPtemplate.isFixed()) {
                            xobject4 = xMPtemplate.getLowerAt(i);
                        } else {
                            xobject3 = XMPtranslateLocalPragma.declIdentWithBlock(pragmaBlock, "XMP_" + xMPtemplate.getName() + "_ret" + Integer.toString(i), Xtype.intType);
                            xobject2 = XMPtranslateLocalPragma.declIdentWithBlock(pragmaBlock, "XMP_" + xMPtemplate.getName() + "_lb" + Integer.toString(i), Xtype.intType);
                            xobject12 = this._globalDecl.declExternFunc("xmp_template_lbound", Xtype.intType);
                            XobjList xobjList4 = Xcons.List(xMPtemplate.getDescId().Ref(), Xcons.IntConstant(i + 1), ((Ident)xobject2).getAddr());
                            pragmaBlock.insert(Xcons.Set(((Ident)xobject3).Ref(), ((Ident)xobject12).Call(xobjList4)));
                            xobject4 = ((Ident)xobject2).Ref();
                        }
                    }
                    if ((xobject3 = ((XobjList)xobject11).getArg(2)) != null) {
                        if (xobject3.Opcode() == Xcode.INT_CONSTANT && ((XobjInt)xobject3).getInt() == 0) {
                            xobject5.add(xobject11);
                            continue;
                        }
                    } else {
                        xobject3 = Xcons.IntConstant(1);
                    }
                    if ((xobject2 = (Ident)arrayList2.get(i)) != null) {
                        xobject12 = Xcons.binaryOp(Xcode.MUL_EXPR, ((Ident)xobject2).Ref(), xobject3);
                        xobject12 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject12, xobject4);
                        xobject5.add(xobject12);
                        continue;
                    }
                    xobject5.add(null);
                    continue;
                }
                xobject5.add(xobject11);
            }
        } else {
            for (int i = 0; i < xMPtemplate.getDim(); ++i) {
                Xobject xobject13;
                if (xMPtemplate.isFixed()) {
                    xobject13 = xMPtemplate.getLowerAt(i);
                } else {
                    xobject4 = XMPtranslateLocalPragma.declIdentWithBlock(pragmaBlock, "XMP_" + xMPtemplate.getName() + "_ret" + Integer.toString(i), Xtype.intType);
                    xobject3 = XMPtranslateLocalPragma.declIdentWithBlock(pragmaBlock, "XMP_" + xMPtemplate.getName() + "_lb" + Integer.toString(i), Xtype.intType);
                    xobject2 = this._globalDecl.declExternFunc("xmp_template_lbound", Xtype.intType);
                    XobjList xobjList5 = Xcons.List(xMPtemplate.getDescId().Ref(), Xcons.IntConstant(i + 1), ((Ident)xobject3).getAddr());
                    pragmaBlock.insert(Xcons.Set(((Ident)xobject4).Ref(), ((Ident)xobject2).Call(xobjList5)));
                    xobject13 = ((Ident)xobject3).Ref();
                }
                xobject4 = (Ident)arrayList2.get(i);
                if (xobject4 != null) {
                    xobject3 = Xcons.binaryOp(Xcode.PLUS_EXPR, ((Ident)xobject4).Ref(), xobject13);
                    xobject5.add(xobject3);
                    continue;
                }
                xobject5.add(null);
            }
        }
        ((Xobject)xobjList3).add(xobject5);
        ((Xobject)xobjList2).add(xobjList3);
        ((Xobject)xobjList2).add(null);
        ((Xobject)xobjList2).add(null);
        ((Xobject)xobjList2).add(null);
        ((Xobject)xobjList2).add(null);
        return Bcons.PRAGMA(Xcode.XMP_PRAGMA, "LOOP", xobjList2, (BlockList)object);
    }

    private void analyzeStaticDesc(PragmaBlock pragmaBlock) {
        Block block = pragmaBlock.getParentBlock();
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable2(block);
        XobjList xobjList = (XobjList)pragmaBlock.getClauses().getArg(0);
        for (Xobject xobject : xobjList) {
            String string = xobject.getString();
            xMPsymbolTable.putStaticDesc(string);
        }
    }

    private void setupFinalizer(BlockList blockList, Ident ident, XobjList xobjList) throws XMPexception {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(blockList);
        ((BlockIterator)topdownBlockIterator2).init();
        while (!((BlockIterator)topdownBlockIterator2).end()) {
            Block block = topdownBlockIterator2.getBlock();
            if (block.Opcode() == Xcode.GOTO_STATEMENT) {
                throw new XMPexception("cannot use goto statement here");
            }
            if (block.Opcode() == Xcode.RETURN_STATEMENT) {
                block.insert(ident.Call(xobjList));
            }
            ((BlockIterator)topdownBlockIterator2).next();
        }
        blockList.add(ident.Call(xobjList));
    }

    public static void checkDeclPragmaLocation(PragmaBlock pragmaBlock) throws XMPexception {
    }

    public void set_all_profile() {
        this._all_profile = true;
    }

    public void set_selective_profile() {
        this._selective_profile = true;
    }

    public void setScalascaEnabled(boolean bl) {
        this.doScalasca = bl;
    }

    public void setTlogEnabled(boolean bl) {
        this.doTlog = bl;
    }

    private Block createScalascaStartProfileCall(XobjList xobjList) {
        Ident ident = XMP.getMacroId("_XMP_M_EPIK_USER_START");
        BlockList blockList = Bcons.emptyBody();
        blockList.add(Bcons.Statement(ident.Call(xobjList)));
        return Bcons.COMPOUND(blockList);
    }

    private Block createScalascaEndProfileCall(XobjList xobjList) {
        Ident ident = XMP.getMacroId("_XMP_M_EPIK_USER_END");
        BlockList blockList = Bcons.emptyBody();
        blockList.add(Bcons.Statement(ident.Call(xobjList)));
        return Bcons.COMPOUND(blockList);
    }

    private Block createScalascaProfileOffCall(XobjList xobjList) {
        Ident ident = XMP.getMacroId("_XMP_M_EPIK_GEN_OFF");
        BlockList blockList = Bcons.emptyBody();
        blockList.add(Bcons.Statement(ident.Call(xobjList)));
        return Bcons.COMPOUND(blockList);
    }

    private Block createScalascaProfileOnfCall(XobjList xobjList) {
        Ident ident = XMP.getMacroId("_XMP_M_EPIK_GEN_ON");
        BlockList blockList = Bcons.emptyBody();
        blockList.add(Bcons.Statement(ident.Call(xobjList)));
        return Bcons.COMPOUND(blockList);
    }

    private Block createTlogMacroInvoke(String string, XobjList xobjList) {
        Ident ident = XMP.getMacroId(string);
        BlockList blockList = Bcons.emptyBody();
        blockList.add(Bcons.Statement(ident.Call(xobjList)));
        return Bcons.COMPOUND(blockList);
    }

    private static Block divideMarginLoop(PragmaBlock pragmaBlock) {
        BlockList blockList = Bcons.emptyBody();
        boolean bl = false;
        XobjList xobjList = (XobjList)pragmaBlock.getClauses().getArg(5);
        XobjList xobjList2 = null;
        XobjList xobjList3 = null;
        for (int i = 0; i < xobjList.getArg(1).Nargs(); ++i) {
            Xobject xobject;
            int n;
            Xobject xobject2 = xobjList.getArg(1).getArg(i);
            Xobject xobject3 = xobject2.getArg(0);
            Xobject xobject4 = xobject2.getArg(1);
            Xobject xobject5 = xobject2.getArg(2);
            if (xobject5.isIntConstant() && xobject5.getInt() == -1 || xobject3.isZeroConstant() || xobject4.isZeroConstant()) continue;
            bl = true;
            PragmaBlock pragmaBlock2 = (PragmaBlock)pragmaBlock.copy();
            xobjList2 = (XobjList)pragmaBlock2.getClauses().getArg(5);
            for (n = 0; n < xobjList2.getArg(1).Nargs(); ++n) {
                xobject = xobjList2.getArg(1).getArg(n);
                if (n == i) {
                    xobject.setArg(0, xobject3);
                    xobject.setArg(1, Xcons.IntConstant(0));
                    continue;
                }
                if (n > i) {
                    xobject.setArg(2, Xcons.IntConstant(-1));
                    continue;
                }
                xobject.setArg(0, Xcons.IntConstant(0));
                xobject.setArg(1, Xcons.IntConstant(0));
            }
            blockList.add(pragmaBlock2);
            PragmaBlock pragmaBlock3 = (PragmaBlock)pragmaBlock.copy();
            xobjList3 = (XobjList)pragmaBlock3.getClauses().getArg(5);
            for (n = 0; n < xobjList2.getArg(1).Nargs(); ++n) {
                xobject = xobjList3.getArg(1).getArg(n);
                if (n == i) {
                    xobject.setArg(0, Xcons.IntConstant(0));
                    xobject.setArg(1, xobject4);
                    continue;
                }
                if (n > i) {
                    xobject.setArg(2, Xcons.IntConstant(-1));
                    continue;
                }
                xobject.setArg(0, Xcons.IntConstant(0));
                xobject.setArg(1, Xcons.IntConstant(0));
            }
            blockList.add(pragmaBlock3);
        }
        if (bl) {
            return Bcons.COMPOUND(blockList);
        }
        return null;
    }

    private static Block peelLoop(PragmaBlock pragmaBlock) {
        BlockList blockList = Bcons.emptyBody();
        PragmaBlock pragmaBlock2 = (PragmaBlock)pragmaBlock.copy();
        pragmaBlock2.getClauses().getArg(5).setArg(0, Xcons.IntConstant(410));
        pragmaBlock2.getClauses().getArg(5).setArg(1, pragmaBlock.getClauses().getArg(5).getArg(2));
        blockList.add(pragmaBlock2);
        XobjList xobjList = Xcons.List();
        xobjList.add(Xcons.List(pragmaBlock.getClauses().getArg(5).getArg(1)));
        xobjList.add(null);
        PragmaBlock pragmaBlock3 = new PragmaBlock(Xcode.XMP_PRAGMA, "WAIT_ASYNC", xobjList, null);
        blockList.add(pragmaBlock3);
        PragmaBlock pragmaBlock4 = (PragmaBlock)pragmaBlock.copy();
        pragmaBlock4.getClauses().getArg(5).setArg(0, Xcons.IntConstant(411));
        pragmaBlock4.getClauses().getArg(5).setArg(1, pragmaBlock.getClauses().getArg(5).getArg(2));
        blockList.add(pragmaBlock4);
        return Bcons.COMPOUND(blockList);
    }
}

