/*
 * Decompiled with CFR 0.152.
 */
package exc.xcalablemp;

import exc.object.XobjList;
import exc.object.Xobject;
import exc.xcalablemp.XMP;
import exc.xcalablemp.XMPalignedArray;
import exc.xcalablemp.XMPcoarray;
import exc.xcalablemp.XMPexception;
import exc.xcalablemp.XMPglobalDecl;
import exc.xcalablemp.XMPnodes;
import exc.xcalablemp.XMPpragma;
import exc.xcalablemp.XMPshadow;
import exc.xcalablemp.XMPtemplate;

public class XMPtranslateGlobalPragma {
    private XMPglobalDecl _globalDecl;

    public XMPtranslateGlobalPragma(XMPglobalDecl xMPglobalDecl) {
        this._globalDecl = xMPglobalDecl;
    }

    public void translate(Xobject xobject) {
        try {
            this.translatePragma(xobject);
        }
        catch (XMPexception xMPexception) {
            XMP.error(xobject.getLineNo(), xMPexception.getMessage());
        }
    }

    public void translatePragma(Xobject xobject) throws XMPexception {
        String string = xobject.getArg(0).getString();
        switch (XMPpragma.valueOf(string)) {
            case NODES: {
                this.translateNodes(xobject);
                break;
            }
            case TEMPLATE: {
                this.translateTemplate(xobject);
                break;
            }
            case DISTRIBUTE: {
                this.translateDistribute(xobject);
                break;
            }
            case ALIGN: {
                this.translateAlign(xobject);
                break;
            }
            case SHADOW: {
                this.translateShadow(xobject);
                break;
            }
            case COARRAY: {
                this.translateCoarray(xobject);
                break;
            }
            case LOCAL_ALIAS: {
                this.translateLocalAlias(xobject);
                break;
            }
            default: {
                throw new XMPexception("'" + string.toLowerCase() + "' directive is not supported yet");
            }
        }
    }

    private void translateNodes(Xobject xobject) throws XMPexception {
        XobjList xobjList = (XobjList)xobject.getArg(1);
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        XobjList xobjList3 = (XobjList)xobjList.copy();
        for (Xobject xobject2 : xobjList2) {
            xobjList3.setArg(0, xobject2);
            XMPnodes.translateNodes(xobjList3, this._globalDecl, false, null);
        }
    }

    private void translateTemplate(Xobject xobject) throws XMPexception {
        XobjList xobjList = (XobjList)xobject.getArg(1);
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        XobjList xobjList3 = (XobjList)xobjList.copy();
        for (Xobject xobject2 : xobjList2) {
            xobjList3.setArg(0, xobject2);
            XMPtemplate.translateTemplate(xobjList3, this._globalDecl, false, null);
        }
    }

    private void translateDistribute(Xobject xobject) throws XMPexception {
        XobjList xobjList = (XobjList)xobject.getArg(1);
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        XobjList xobjList3 = (XobjList)xobjList.copy();
        for (Xobject xobject2 : xobjList2) {
            xobjList3.setArg(0, xobject2);
            XMPtemplate.translateDistribute(xobjList3, this._globalDecl, false, null);
        }
    }

    private void translateAlign(Xobject xobject) throws XMPexception {
        XobjList xobjList = (XobjList)xobject.getArg(1);
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        XobjList xobjList3 = (XobjList)xobjList.getArg(3);
        XobjList xobjList4 = (XobjList)xobjList3.left();
        String string = xobjList3.getTail().getString();
        boolean bl = string.equals("SQUARE");
        xobjList3.removeLastArgs();
        if (bl) {
            xobjList4.reverse();
        }
        XobjList xobjList5 = (XobjList)xobjList.copy();
        for (Xobject xobject2 : xobjList2) {
            xobjList5.setArg(0, xobject2);
            XMPalignedArray.translateAlign(xobjList5, this._globalDecl, false, null);
        }
    }

    private void translateLocalAlias(Xobject xobject) throws XMPexception {
        XMPalignedArray.translateLocalAlias((XobjList)xobject.getArg(1), this._globalDecl, false, null);
    }

    private void translateShadow(Xobject xobject) throws XMPexception {
        XobjList xobjList = (XobjList)xobject.getArg(1);
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        XobjList xobjList3 = (XobjList)xobjList.copy();
        for (Xobject xobject2 : xobjList2) {
            xobjList3.setArg(0, xobject2);
            XMPshadow.translateShadow(xobjList3, this._globalDecl, false, null);
        }
    }

    private void translateCoarray(Xobject xobject) throws XMPexception {
        XobjList xobjList = (XobjList)xobject.getArg(1);
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        XobjList xobjList3 = (XobjList)xobjList.copy();
        for (Xobject xobject2 : xobjList2) {
            xobjList3.setArg(0, xobject2);
            XMPcoarray.translateCoarray(xobjList3, this._globalDecl, false, null);
        }
    }
}

