/*
 * Decompiled with CFR 0.152.
 */
package exc.xcalablemp;

import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockIterator;
import exc.block.BlockList;
import exc.block.FuncDefBlock;
import exc.block.FunctionBlock;
import exc.block.bottomupBlockIterator;
import exc.object.FunctionType;
import exc.object.Ident;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectDefVisitor;
import exc.object.XobjectFile;
import exc.object.XobjectIterator;
import exc.object.Xtype;
import exc.object.bottomupXobjectIterator;
import exc.xcalablemp.XMP;
import exc.xcalablemp.XMPexception;
import exc.xcalablemp.XMPglobalDecl;
import exc.xcalablemp.XMPrewriteExpr;
import exc.xcalablemp.XMPtranslateGlobalPragma;
import exc.xcalablemp.XMPtranslateLocalPragma;
import xcodeml.util.XmOption;

public class XMPtranslate
implements XobjectDefVisitor {
    private XMPglobalDecl _globalDecl;
    private XMPtranslateGlobalPragma _translateGlobalPragma;
    private XMPtranslateLocalPragma _translateLocalPragma;
    private XMPrewriteExpr _rewriteExpr;
    private boolean _all_profile;
    private boolean _selective_profile;

    public XMPtranslate(XMPglobalDecl xMPglobalDecl) {
        if (!XmOption.isLanguageC()) {
            XMP.fatal("current version only supports C language.");
        }
        this._globalDecl = xMPglobalDecl;
        this._translateGlobalPragma = new XMPtranslateGlobalPragma(xMPglobalDecl);
        this._translateLocalPragma = new XMPtranslateLocalPragma(xMPglobalDecl);
        this._rewriteExpr = new XMPrewriteExpr(xMPglobalDecl);
        this._all_profile = false;
        this._selective_profile = false;
    }

    public void finish() {
        this._globalDecl.finalizeGlobalDecl();
    }

    @Override
    public void doDef(XobjectDef xobjectDef) {
        this.translate(xobjectDef);
    }

    private void translate(XobjectDef xobjectDef) {
        if (!xobjectDef.isFuncDef()) {
            Xobject xobject = xobjectDef.getDef();
            switch (xobject.Opcode()) {
                case XMP_PRAGMA: {
                    this._translateGlobalPragma.translate(xobject);
                    break;
                }
                case VAR_DECL: {
                    this._rewriteExpr.rewriteVarDecl(xobject, false);
                    break;
                }
                case ACC_PRAGMA: {
                    this._rewriteExpr.rewriteACCPragma(xobjectDef);
                }
            }
            return;
        }
        FuncDefBlock funcDefBlock = new FuncDefBlock(xobjectDef);
        this.fixSubArrayRef(funcDefBlock);
        this._translateLocalPragma.translate(funcDefBlock);
        this._rewriteExpr.rewrite(funcDefBlock);
        String string = funcDefBlock.getBlock().getName();
        if (string == "main") {
            try {
                this.add_args_into_main(funcDefBlock);
                this.create_new_main(funcDefBlock);
            }
            catch (XMPexception xMPexception) {
                FunctionBlock functionBlock = funcDefBlock.getBlock();
                XMP.error(functionBlock.getLineNo(), xMPexception.getMessage());
            }
        }
    }

    private void first_arg_check(Xobject xobject) throws XMPexception {
        if (!xobject.Type().isBasic()) {
            throw new XMPexception("Type of first argument in main() must be an interger.");
        }
        if (xobject.Type().getBasicType() != 7) {
            throw new XMPexception("Type of first argument in main() must be an interger.");
        }
    }

    private void second_arg_check(Xobject xobject) throws XMPexception {
        if (!xobject.Type().isPointer()) {
            throw new XMPexception("Type of second argument in main() must be char **.");
        }
        boolean bl = false;
        if (xobject.Type().getRef().isPointer() && xobject.Type().getRef().getRef().isBasic() && xobject.Type().getRef().getRef().getBasicType() == 3) {
            bl = true;
        }
        if (!bl) {
            throw new XMPexception("Type of second argument in main() must be char **.");
        }
    }

    private void create_new_main(FuncDefBlock funcDefBlock) throws XMPexception {
        Xobject xobject;
        XobjectFile xobjectFile = this._globalDecl.getEnv();
        Ident ident = this._globalDecl.findVarIdent("main");
        Xtype xtype = ((FunctionType)ident.Type()).getBaseRefType();
        if (!XmOption.getMainName().equals("")) {
            ident = xobjectFile.declGlobalIdent(XmOption.getMainName(), Xtype.Function(xtype));
        }
        Xobject xobject2 = funcDefBlock.getDef().getFuncIdList();
        Xobject xobject3 = funcDefBlock.getDef().getFuncDecls();
        Xobject xobject4 = funcDefBlock.getDef().getFuncBody();
        Ident ident2 = xobjectFile.declExternIdent("xmp_init_all", Xtype.Function(Xtype.voidType));
        Ident ident3 = xobjectFile.declStaticIdent("xmpc_main", Xtype.Function(xtype));
        Ident ident4 = xobjectFile.declExternIdent("xmp_finalize_all", Xtype.Function(Xtype.voidType));
        xobjectFile.add(XobjectDef.Func(ident3, xobject2, xobject3, xobject4));
        XobjectDef xobjectDef = funcDefBlock.getDef();
        BlockList blockList = Bcons.emptyBody();
        blockList.setIdentList(Xcons.IDList());
        blockList.setDecls(Xcons.List());
        Ident ident5 = (Ident)funcDefBlock.getDef().getFuncIdList().getArg(0);
        Ident ident6 = (Ident)funcDefBlock.getDef().getFuncIdList().getArg(1);
        XobjList xobjList = Xcons.List(ident5, ident6);
        blockList.add(ident2.Call(xobjList));
        if (xtype.equals(Xtype.voidType)) {
            blockList.add(ident3.Call(xobject2));
            blockList.add(ident4.Call(null));
        } else {
            xobject = Ident.Local("r", xtype);
            blockList.addIdent((Ident)xobject);
            blockList.add(Xcons.Set(xobject.Ref(), ident3.Call(xobject2)));
            blockList.add(ident4.Call(null));
            blockList.add(Xcons.List(Xcode.RETURN_STATEMENT, xobject.Ref()));
        }
        xobject = Xcons.List(Xcode.FUNCTION_DEFINITION, ident, xobject2, xobject3, blockList.toXobject());
        xobjectDef.setDef(xobject);
    }

    private void add_args_into_main(FuncDefBlock funcDefBlock) throws XMPexception {
        Xobject xobject = funcDefBlock.getDef().getFuncIdList();
        int n = xobject.Nargs();
        Ident ident = Ident.Param("argc", Xtype.intType);
        Ident ident2 = Ident.Param("argv", Xtype.Pointer(Xtype.Pointer(Xtype.charType)));
        Ident ident3 = this._globalDecl.findVarIdent("main");
        if (n == 1) {
            xobject.add(ident2);
            ((FunctionType)ident3.Type()).setFuncParamIdList(xobject);
        } else if (n == 0) {
            xobject.add(ident);
            xobject.add(ident2);
            ((FunctionType)ident3.Type()).setFuncParamIdList(xobject);
        }
        Xobject xobject2 = xobject.getArgOrNull(0);
        Xobject xobject3 = xobject.getArgOrNull(1);
        this.first_arg_check(xobject2);
        this.second_arg_check(xobject3);
    }

    public void set_all_profile() {
        this._all_profile = true;
        this._translateLocalPragma.set_all_profile();
    }

    public void set_selective_profile() {
        this._selective_profile = true;
        this._translateLocalPragma.set_selective_profile();
    }

    public void setScalascaEnabled(boolean bl) {
        this._translateLocalPragma.setScalascaEnabled(bl);
    }

    public void setTlogEnabled(boolean bl) {
        this._translateLocalPragma.setTlogEnabled(bl);
    }

    private void fixSubArrayRef(FuncDefBlock funcDefBlock) {
        FunctionBlock functionBlock = funcDefBlock.getBlock();
        if (functionBlock == null) {
            return;
        }
        bottomupBlockIterator bottomupBlockIterator2 = new bottomupBlockIterator(functionBlock);
        ((BlockIterator)bottomupBlockIterator2).init();
        while (!((BlockIterator)bottomupBlockIterator2).end()) {
            Block block = bottomupBlockIterator2.getBlock();
            bottomupXobjectIterator bottomupXobjectIterator2 = new bottomupXobjectIterator(block.toXobject());
            ((XobjectIterator)bottomupXobjectIterator2).init();
            while (!((XobjectIterator)bottomupXobjectIterator2).end()) {
                Xobject xobject = bottomupXobjectIterator2.getXobject();
                if (xobject != null && xobject.Opcode() == Xcode.SUB_ARRAY_REF) {
                    String string = xobject.getArg(0).getSym();
                    Ident ident = null;
                    if (block.getBody() != null) {
                        ident = block.getBody().findLocalIdent(string);
                    }
                    if (ident == null) {
                        ident = block.findVarIdent(string);
                    }
                    if (ident == null) {
                        ident = this._globalDecl.findVarIdent(string);
                    }
                    if (ident != null) {
                        Xtype xtype = ident.Type();
                        int n = xtype.getNumDimensions();
                        XobjList xobjList = (XobjList)xobject.getArg(1);
                        int n2 = 0;
                        while (n2 < n) {
                            if (xobjList.Nargs() == n2) {
                                XMP.fatal(block.getLineNo(), "Invalid access of array");
                            } else {
                                long l = xtype.getArraySize();
                                if (l != 0L && xtype.getKind() != 7) {
                                    Xobject xobject2 = l == -1L ? xtype.getArraySizeExpr() : Xcons.IntConstant((int)l);
                                    Xobject xobject3 = xobjList.getArg(n2);
                                    if (xobject3.isIndexRange()) {
                                        Xobject xobject4;
                                        Xobject xobject5;
                                        Xobject xobject6 = ((XobjList)xobject3).getArg(0);
                                        if (xobject6 == null) {
                                            xobject6 = Xcons.IntConstant(0);
                                        }
                                        if ((xobject5 = ((XobjList)xobject3).getArg(1)) == null) {
                                            xobject5 = xobject2;
                                        }
                                        if ((xobject4 = ((XobjList)xobject3).getArg(2)) == null) {
                                            xobject4 = Xcons.IntConstant(1);
                                        }
                                        xobjList.setArg(n2, Xcons.List(Xcode.INDEX_RANGE, xobject6, xobject5, xobject4));
                                    }
                                }
                            }
                            ++n2;
                            xtype = xtype.getRef();
                        }
                    }
                }
                ((XobjectIterator)bottomupXobjectIterator2).next();
            }
            ((BlockIterator)bottomupBlockIterator2).next();
        }
    }
}

