/*
 * Decompiled with CFR 0.152.
 */
package exc.xcalablemp;

import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockList;
import exc.block.PragmaBlock;
import exc.object.Ident;
import exc.object.PropObject;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjInt;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.xcalablemp.XMPexception;
import exc.xcalablemp.XMPglobalDecl;
import exc.xcalablemp.XMPlocalDecl;
import exc.xcalablemp.XMPnodes;
import exc.xcalablemp.XMPobject;
import exc.xcalablemp.XMPsymbolTable;
import java.util.Vector;

public class XMPtemplate
extends XMPobject {
    public static final int DUPLICATION = 100;
    public static final int BLOCK = 101;
    public static final int CYCLIC = 102;
    public static final int BLOCK_CYCLIC = 103;
    public static final int GBLOCK = 104;
    private boolean _isFixed = false;
    private boolean _isDistributed = false;
    private boolean _distributionIsFixed = true;
    private XMPnodes _ontoNodes = null;
    private Vector<XobjInt> _ontoNodesIndexVector = new Vector();
    private Vector<Integer> _distMannerVector = new Vector();
    private Vector<Xobject> _sizeVector = new Vector();
    private Vector<Xobject> _widthVector = new Vector();
    private XobjList _decl;
    private XobjList _distDecl;
    private Vector<Ident> _gtolTemp0IdVector = new Vector();
    private boolean _isStaticDesc = false;
    private Ident _flagId = null;

    public XMPtemplate(String string, int n, Ident ident) {
        super(101, string, n, ident);
        for (int i = 0; i < n; ++i) {
            this._ontoNodesIndexVector.add(null);
            this._distMannerVector.add(null);
            this._widthVector.add(null);
            this._gtolTemp0IdVector.add(null);
        }
        this._decl = null;
        this._distDecl = null;
    }

    public void setIsFixed() {
        this._isFixed = true;
    }

    public boolean isFixed() {
        return this._isFixed;
    }

    public void setIsDistributed() {
        this._isDistributed = true;
    }

    public boolean isDistributed() {
        return this._isDistributed;
    }

    public void setDistributionIsFixed(boolean bl) {
        this._distributionIsFixed = bl;
    }

    public void setDistributionIsFixed() {
        this._distributionIsFixed = true;
    }

    public boolean distributionIsFixed() {
        return this._distributionIsFixed;
    }

    public void setOntoNodes(XMPnodes xMPnodes) {
        this._ontoNodes = xMPnodes;
    }

    public XMPnodes getOntoNodes() {
        return this._ontoNodes;
    }

    public void setOntoNodesIndexAt(int n, int n2) {
        this._ontoNodesIndexVector.setElementAt(Xcons.IntConstant(n), n2);
    }

    public XobjInt getOntoNodesIndexAt(int n) {
        return this._ontoNodesIndexVector.get(n);
    }

    public void setDistMannerAt(int n, int n2) {
        this._distMannerVector.setElementAt(new Integer(n), n2);
    }

    public int getDistMannerAt(int n) throws XMPexception {
        if (!this._isDistributed) {
            throw new XMPexception("template " + this.getName() + " is not distributed");
        }
        return this._distMannerVector.get(n);
    }

    public String getDistMannerStringAt(int n) throws XMPexception {
        if (!this._isDistributed) {
            throw new XMPexception("template " + this.getName() + " is not distributed");
        }
        return XMPtemplate.getDistMannerString(this.getDistMannerAt(n));
    }

    public void createSizeVector() {
        for (int i = 0; i < this.getDim(); ++i) {
            this._sizeVector.add(Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.binaryOp(Xcode.MINUS_EXPR, this.getUpperAt(i), this.getLowerAt(i)), Xcons.IntConstant(1)));
        }
    }

    public Xobject getSizeAt(int n) {
        return this._sizeVector.get(n);
    }

    public void setWidthAt(Xobject xobject, int n) {
        this._widthVector.setElementAt(xobject, n);
    }

    public Xobject getWidthAt(int n) throws XMPexception {
        return this._widthVector.get(n);
    }

    public static String getDistMannerString(int n) throws XMPexception {
        switch (n) {
            case 100: {
                return new String("DUPLICATION");
            }
            case 101: {
                return new String("BLOCK");
            }
            case 102: {
                return new String("CYCLIC");
            }
            case 103: {
                return new String("BLOCK_CYCLIC");
            }
            case 104: {
                return new String("GBLOCK");
            }
        }
        throw new XMPexception("unknown distribute manner");
    }

    public void setDecl(XobjList xobjList) {
        this._decl = xobjList;
    }

    public XobjList getDecl() {
        return this._decl;
    }

    public void setDistDecl(XobjList xobjList) {
        this._distDecl = xobjList;
    }

    public XobjList getDistDecl() {
        return this._distDecl;
    }

    public void setGtolTemp0IdAt(Ident ident, int n) {
        this._gtolTemp0IdVector.setElementAt(ident, n);
    }

    public Ident getGtolTemp0IdAt(int n) {
        return this._gtolTemp0IdVector.get(n);
    }

    public void setIsStaticDesc(boolean bl) {
        this._isStaticDesc = bl;
    }

    public boolean isStaticDesc() {
        return this._isStaticDesc;
    }

    public void setFlagId(Ident ident) {
        this._flagId = ident;
    }

    public Ident getFlagId() {
        return this._flagId;
    }

    @Override
    public boolean checkInheritExec() {
        return this._ontoNodes.checkInheritExec();
    }

    public static void translateTemplate(XobjList xobjList, XMPglobalDecl xMPglobalDecl, boolean bl, PragmaBlock pragmaBlock) throws XMPexception {
        Xobject xobject;
        Object object;
        Object object2;
        XMPsymbolTable xMPsymbolTable = null;
        Block block = null;
        boolean bl2 = false;
        if (bl) {
            block = pragmaBlock.getParentBlock();
            xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable2(block);
        }
        String string = xobjList.getArg(0).getString();
        if (bl) {
            XMPlocalDecl.checkObjectNameCollision(string, block.getBody(), xMPsymbolTable);
            bl2 = xMPsymbolTable.isStaticDesc(string);
        } else {
            xMPglobalDecl.checkObjectNameCollision(string);
        }
        Ident ident = null;
        ident = bl ? XMPlocalDecl.addObjectId2("_XMP_DESC_" + string, block) : xMPglobalDecl.declStaticIdent("_XMP_DESC_" + string, Xtype.voidPtrType);
        if (bl2) {
            ident.setStorageClass(StorageClass.STATIC);
        }
        String string2 = xobjList.getArg(1).getTail().getString();
        boolean bl3 = string2.equals("SQUARE");
        xobjList.getArg(1).removeLastArgs();
        int n = 0;
        for (object2 = xobjList.getArg(1).getArgs(); object2 != null; object2 = ((XobjArgs)object2).nextArgs()) {
            ++n;
        }
        if (n > 7) {
            throw new XMPexception("template dimension should be less than 8");
        }
        object2 = new XMPtemplate(string, n, ident);
        if (bl) {
            xMPsymbolTable.putXMPobject((XMPobject)object2);
        } else {
            xMPglobalDecl.putXMPobject((XMPobject)object2);
        }
        ((XMPtemplate)object2).setDecl(xobjList);
        boolean bl4 = true;
        XobjList xobjList2 = Xcons.List(ident.getAddr(), Xcons.IntConstant(n));
        if (bl3) {
            ((XobjList)xobjList.getArg(1)).reverse();
        }
        for (object = xobjList.getArg(1).getArgs(); object != null; object = ((XobjArgs)object).nextArgs()) {
            Xobject xobject2;
            xobject = ((XobjArgs)object).getArg();
            if (xobject == null || xobject instanceof XobjList && xobject.Nargs() == 0) {
                bl4 = false;
                continue;
            }
            if (!bl4) {
                throw new XMPexception("Every <template-spec> shall be either [int-expr :] int-expr or ':'");
            }
            Xobject xobject3 = xobject.left();
            if (bl3) {
                Xobject xobject4 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject3, xobject.right());
                xobject2 = Xcons.binaryOp(Xcode.MINUS_EXPR, xobject4, Xcons.IntConstant(1));
            } else {
                xobject2 = xobject.right();
            }
            xobjList2.add(Xcons.Cast(Xtype.longlongType, xobject3));
            xobjList2.add(Xcons.Cast(Xtype.longlongType, xobject2));
            ((XMPobject)object2).addLower(xobject3);
            ((XMPobject)object2).addUpper(xobject2);
        }
        if (bl) {
            ((XMPtemplate)object2).setIsStaticDesc(bl2);
        }
        if (!bl4 && bl2) {
            throw new XMPexception("non-fixed template cannot have the static_desc attribute.");
        }
        if (bl4) {
            ((XMPtemplate)object2).createSizeVector();
        }
        object = new String("_XMP_init_template_");
        if (bl4) {
            ((XMPtemplate)object2).setIsFixed();
            object = (String)object + "FIXED";
        } else {
            object = (String)object + "UNFIXED";
        }
        if (bl) {
            if (bl2) {
                xobject = block.getBody().declLocalIdent("_XMP_STATIC_" + string, Xtype.intType, StorageClass.STATIC, Xcons.IntConstant(0));
                ((XMPtemplate)object2).setFlagId((Ident)xobject);
                XMPlocalDecl.addConstructorCall2_staticDesc((String)object, xobjList2, xMPglobalDecl, block, (Ident)xobject, false);
            } else {
                XMPlocalDecl.addConstructorCall2((String)object, xobjList2, xMPglobalDecl, block);
            }
            if (!bl2) {
                XMPlocalDecl.insertDestructorCall2("_XMP_finalize_template", Xcons.List(ident.Ref()), xMPglobalDecl, block);
            }
        } else {
            xMPglobalDecl.addGlobalInitFuncCall((String)object, xobjList2);
        }
    }

    public static void translateDistribute(XobjList xobjList, XMPglobalDecl xMPglobalDecl, boolean bl, PragmaBlock pragmaBlock) throws XMPexception {
        XMPsymbolTable xMPsymbolTable = null;
        Block block = null;
        if (bl) {
            block = pragmaBlock.getParentBlock();
            xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable2(block);
        }
        String string = xobjList.getArg(0).getString();
        XMPtemplate xMPtemplate = null;
        xMPtemplate = xMPglobalDecl.getXMPtemplate(string, pragmaBlock);
        if (xMPtemplate == null) {
            throw new XMPexception("template '" + string + "' is not declared");
        }
        xMPtemplate.setDistDecl(xobjList);
        if (xMPtemplate.isDistributed()) {
            throw new XMPexception("template '" + string + "' is already distributed");
        }
        String string2 = xobjList.getArg(2).getString();
        XMPnodes xMPnodes = null;
        xMPnodes = xMPglobalDecl.getXMPnodes(string2, pragmaBlock);
        if (xMPnodes == null) {
            throw new XMPexception("nodes '" + string2 + "' is not declared");
        }
        xMPtemplate.setOntoNodes(xMPnodes);
        if (xMPtemplate.isFixed()) {
            if (bl) {
                if (xMPtemplate.isStaticDesc()) {
                    XMPlocalDecl.addConstructorCall2_staticDesc("_XMP_init_template_chunk", Xcons.List(xMPtemplate.getDescId().Ref(), xMPnodes.getDescId().Ref()), xMPglobalDecl, block, xMPtemplate.getFlagId(), false);
                } else {
                    XMPlocalDecl.addConstructorCall2("_XMP_init_template_chunk", Xcons.List(xMPtemplate.getDescId().Ref(), xMPnodes.getDescId().Ref()), xMPglobalDecl, block);
                }
            } else {
                xMPglobalDecl.addGlobalInitFuncCall("_XMP_init_template_chunk", Xcons.List(xMPtemplate.getDescId().Ref(), xMPnodes.getDescId().Ref()));
            }
        }
        int n = xMPtemplate.getDim();
        int n2 = 0;
        int n3 = xMPnodes.getDim();
        int n4 = 0;
        String string3 = xobjList.getArg(1).getTail().getString();
        boolean bl2 = string3.equals("SQUARE");
        xobjList.getArg(1).removeLastArgs();
        if (bl2) {
            ((XobjList)xobjList.getArg(1)).reverse();
        }
        for (XobjArgs xobjArgs = xobjList.getArg(1).getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            if (n2 == n) {
                throw new XMPexception("wrong template dimension indicated, too many");
            }
            XobjList xobjList2 = (XobjList)xobjArgs.getArg();
            XMPtemplate.setupDistribution(xobjList2, xMPtemplate, n2, n4, xMPglobalDecl, bl, false, pragmaBlock);
            int n5 = xobjList2.getArg(0).getInt();
            switch (n5) {
                case 101: 
                case 102: 
                case 103: 
                case 104: {
                    if (n4 == n3) {
                        throw new XMPexception("the number of <dist-format> (except '*') should be the same with the nodes dimension");
                    }
                    ++n4;
                    break;
                }
            }
            ++n2;
        }
        if (n4 != n3) {
            throw new XMPexception("the number of <dist-format> (except '*') should be the same with the nodes dimension");
        }
        if (n2 != n) {
            throw new XMPexception("wrong template dimension indicated, too few");
        }
        xMPtemplate.setIsDistributed();
    }

    private static Block setupDistribution(XobjList xobjList, XMPtemplate xMPtemplate, int n, int n2, XMPglobalDecl xMPglobalDecl, boolean bl, boolean bl2, PragmaBlock pragmaBlock) throws XMPexception {
        PropObject propObject;
        XobjList xobjList2 = null;
        int n3 = xobjList.getArg(0).getInt();
        String string = XMPtemplate.getDistMannerString(n3);
        switch (n3) {
            case 100: {
                xobjList2 = Xcons.List(xMPtemplate.getDescId().Ref(), Xcons.IntConstant(n));
                break;
            }
            case 101: {
                xobjList2 = Xcons.List(xMPtemplate.getDescId().Ref(), Xcons.IntConstant(n), Xcons.IntConstant(n2));
                xMPtemplate.setOntoNodesIndexAt(n2, n);
                break;
            }
            case 102: {
                xobjList2 = Xcons.List(xMPtemplate.getDescId().Ref(), Xcons.IntConstant(n), Xcons.IntConstant(n2));
                xMPtemplate.setOntoNodesIndexAt(n2, n);
                break;
            }
            case 103: {
                propObject = xobjList.getArg(1);
                xobjList2 = Xcons.List(new Xobject[]{xMPtemplate.getDescId().Ref(), Xcons.IntConstant(n), Xcons.IntConstant(n2), propObject});
                xMPtemplate.setOntoNodesIndexAt(n2, n);
                xMPtemplate.setWidthAt((Xobject)propObject, n);
                break;
            }
            case 104: {
                Xobject xobject;
                Xobject xobject2 = xobject = xobjList.getArg(1);
                if (xobject instanceof XobjList && xobject.Nargs() == 0) {
                    xobject2 = Xcons.Cast(Xtype.voidPtrType, Xcons.IntConstant(0));
                    xMPtemplate.setDistributionIsFixed(false);
                }
                if (xMPtemplate.isFixed() || bl2) {
                    Ident ident = null;
                    String string2 = "_XMP_GTOL_temp0_" + xMPtemplate.getName() + "_" + n;
                    if (bl) {
                        Block block = pragmaBlock.getParentBlock();
                        ident = XMPlocalDecl.addObjectId2(string2, Xtype.intType, block);
                        if (xMPtemplate.isStaticDesc()) {
                            ident.setStorageClass(StorageClass.STATIC);
                        }
                    } else {
                        ident = xMPglobalDecl.declStaticIdent(string2, Xtype.intType);
                    }
                    xMPtemplate.setGtolTemp0IdAt(ident, n);
                    xobjList2 = Xcons.List(xMPtemplate.getDescId().Ref(), Xcons.IntConstant(n), Xcons.IntConstant(n2), xobject2, ident.getAddr());
                }
                xMPtemplate.setOntoNodesIndexAt(n2, n);
                xMPtemplate.setWidthAt(xobject, n);
                break;
            }
            default: {
                throw new XMPexception("unknown distribute manner");
            }
        }
        if (xMPtemplate.isFixed()) {
            if (bl) {
                propObject = pragmaBlock.getParentBlock();
                if (xMPtemplate.isStaticDesc()) {
                    XMPlocalDecl.addConstructorCall2_staticDesc("_XMP_dist_template_" + string, xobjList2, xMPglobalDecl, (Block)propObject, xMPtemplate.getFlagId(), n == xMPtemplate.getDim() - 1);
                } else {
                    XMPlocalDecl.addConstructorCall2("_XMP_dist_template_" + string, xobjList2, xMPglobalDecl, (Block)propObject);
                }
            } else {
                xMPglobalDecl.addGlobalInitFuncCall("_XMP_dist_template_" + string, xobjList2);
            }
        } else if (bl2) {
            propObject = xMPglobalDecl.declExternFunc("_XMP_dist_template_" + string);
            return Bcons.Statement(((Ident)propObject).Call(xobjList2));
        }
        xMPtemplate.setDistMannerAt(n3, n);
        return null;
    }

    public static void translateTemplateFix(XobjList xobjList, XMPglobalDecl xMPglobalDecl, PragmaBlock pragmaBlock) throws XMPexception {
        Xobject xobject;
        Object object;
        Xobject xobject2;
        XobjArgs xobjArgs;
        BlockList blockList = Bcons.emptyBody();
        Block block = pragmaBlock.getParentBlock();
        String string = xobjList.getArg(1).getString();
        XMPtemplate xMPtemplate = xMPglobalDecl.getXMPtemplate(string, pragmaBlock);
        if (xMPtemplate == null) {
            throw new XMPexception("template '" + string + "' is not declared");
        }
        if (xMPtemplate.isFixed() && xMPtemplate.distributionIsFixed()) {
            throw new XMPexception("template '" + string + "' is already fixed");
        }
        String string2 = xobjList.getTail().getTail().getString();
        boolean bl = string2.equals("SQUARE");
        xobjList.getArg(0).removeLastArgs();
        xobjList.getArg(2).removeLastArgs();
        if (bl) {
            ((XobjList)xobjList.getArg(0)).reverse();
        }
        if (bl) {
            ((XobjList)xobjList.getArg(2)).reverse();
        }
        if (bl) {
            ((XobjList)xMPtemplate.getDecl().getArg(1)).reverse();
        }
        XobjArgs xobjArgs2 = xMPtemplate.getDecl().getArg(1).getArgs();
        XobjArgs xobjArgs3 = xobjList.getArg(2).getArgs();
        if (xMPtemplate.getDistDecl() == null) {
            throw new XMPexception("template '" + string + "' is not distributed");
        }
        XobjArgs xobjArgs4 = xMPtemplate.getDistDecl().getArg(1).getArgs();
        XobjArgs xobjArgs5 = xobjList.getArg(0).getArgs();
        if (!xMPtemplate.isFixed() && xobjArgs3 == null) {
            throw new XMPexception("No <template-spec> specified for a non-fixed template '" + string + "'");
        }
        if (!xMPtemplate.distributionIsFixed() && xobjArgs5 == null) {
            throw new XMPexception("No <dist-format> specified for a non-fixed template '" + string + "'");
        }
        int n = xMPtemplate.getDim();
        XMPnodes xMPnodes = xMPtemplate.getOntoNodes();
        Object object2 = xobjArgs2;
        for (xobjArgs = xobjArgs3; object2 != null || xobjArgs != null; object2 = ((XobjArgs)object2).nextArgs(), xobjArgs = xobjArgs.nextArgs()) {
            if (object2 != null && xobjArgs != null) continue;
            throw new XMPexception("the number of <template-spec> is different from that in the declaration");
        }
        XobjArgs xobjArgs6 = xMPtemplate.isFixed() ? xobjArgs2 : xobjArgs3;
        XobjList xobjList2 = Xcons.List(xMPtemplate.getDescId().Ref(), Xcons.IntConstant(n));
        for (object2 = xobjArgs6; object2 != null; object2 = ((XobjArgs)object2).nextArgs()) {
            Xobject xobject3;
            xobject2 = ((XobjArgs)object2).getArg();
            object = xobject2.left();
            if (bl) {
                xobject = Xcons.binaryOp(Xcode.PLUS_EXPR, (Xobject)object, xobject2.right());
                xobject3 = Xcons.binaryOp(Xcode.MINUS_EXPR, xobject, Xcons.IntConstant(1));
            } else {
                xobject3 = xobject2.right();
            }
            xobjList2.add(Xcons.Cast(Xtype.longlongType, (Xobject)object));
            xobjList2.add(Xcons.Cast(Xtype.longlongType, xobject3));
            xMPtemplate.addLower((Xobject)object);
            xMPtemplate.addUpper(xobject3);
        }
        xMPtemplate.createSizeVector();
        xobject2 = xMPglobalDecl.declExternFunc("_XMP_set_template_size");
        blockList.add(Bcons.Statement(((Ident)xobject2).Call(xobjList2)));
        xobject2 = xMPglobalDecl.declExternFunc("_XMP_init_template_chunk");
        blockList.add(Bcons.Statement(((Ident)xobject2).Call(Xcons.List(xMPtemplate.getDescId().Ref(), xMPnodes.getDescId().Ref()))));
        object2 = xobjArgs4;
        for (xobjArgs = xobjArgs5; object2 != null && xobjArgs != null; object2 = ((XobjArgs)object2).nextArgs(), xobjArgs = xobjArgs.nextArgs()) {
            object = (XobjList)((XobjArgs)object2).getArg();
            int n2 = ((XobjList)object).getArg(0).getInt();
            xobject = ((XobjList)object).getArg(1);
            XobjList xobjList3 = (XobjList)xobjArgs.getArg();
            int n3 = xobjList3.getArg(0).getInt();
            Xobject xobject4 = xobjList3.getArg(1);
            if (n2 == n3 && (n2 != 104 || xobject instanceof XobjList && xobject.Nargs() == 0)) continue;
            throw new XMPexception("<dist-format> not match that of the distribute directives");
        }
        object = xMPtemplate.distributionIsFixed() ? xobjArgs4 : xobjArgs5;
        int n4 = 0;
        int n5 = xMPnodes.getDim();
        int n6 = 0;
        for (object2 = object; object2 != null; object2 = ((XobjArgs)object2).nextArgs()) {
            if (n4 == n) {
                throw new XMPexception("wrong template dimension indicated, too many");
            }
            XobjList xobjList4 = (XobjList)((XobjArgs)object2).getArg();
            int n7 = xobjList4.getArg(0).getInt();
            Block block2 = XMPtemplate.setupDistribution(xobjList4, xMPtemplate, n4, n6, xMPglobalDecl, true, true, pragmaBlock);
            blockList.add(block2);
            switch (n7) {
                case 101: 
                case 102: 
                case 103: 
                case 104: {
                    if (n6 == n5) {
                        throw new XMPexception("the number of <dist-format> (except '*') should be the same with the nodes dimension");
                    }
                    ++n6;
                    break;
                }
            }
            ++n4;
        }
        if (n6 != n5) {
            throw new XMPexception("the number of <dist-format> (except '*') should be the same with the nodes dimension");
        }
        if (n4 != n) {
            throw new XMPexception("wrong template dimension indicated, too few");
        }
        xMPtemplate.setIsFixed();
        xMPtemplate.setDistributionIsFixed();
        Block block3 = Bcons.COMPOUND(blockList);
        pragmaBlock.replace(block3);
    }
}

