/*
 * Decompiled with CFR 0.152.
 */
package exc.xcalablemp;

import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockList;
import exc.block.PragmaBlock;
import exc.object.Ident;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjInt;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.xcalablemp.XMPalignedArray;
import exc.xcalablemp.XMPexception;
import exc.xcalablemp.XMPglobalDecl;
import exc.xcalablemp.XMPgpuData;
import exc.xcalablemp.XMPgpuDataTable;
import exc.xcalablemp.XMPlocalDecl;
import exc.xcalablemp.XMPsymbolTable;
import exc.xcalablemp.XMPtranslateLocalPragma;

public class XMPshadow {
    public static final int SHADOW_NONE = 400;
    public static final int SHADOW_NORMAL = 401;
    public static final int SHADOW_FULL = 402;
    private int _type;
    private Xobject _lo;
    private Xobject _hi;

    public XMPshadow(int n, Xobject xobject, Xobject xobject2) {
        this._type = n;
        this._lo = xobject;
        this._hi = xobject2;
    }

    public int getType() {
        return this._type;
    }

    public Xobject getLo() {
        return this._lo;
    }

    public Xobject getHi() {
        return this._hi;
    }

    public static void translateShadow(XobjList xobjList, XMPglobalDecl xMPglobalDecl, boolean bl, PragmaBlock pragmaBlock) throws XMPexception {
        Object object;
        XMPalignedArray xMPalignedArray;
        String string = xobjList.getArg(0).getString();
        Object var5_5 = null;
        Block block = null;
        Boolean bl2 = false;
        if (bl) {
            block = pragmaBlock.getParentBlock();
        }
        if ((xMPalignedArray = xMPglobalDecl.getXMPalignedArray(string, pragmaBlock)) == null) {
            throw new XMPexception("the aligned array '" + string + "' is not found");
        }
        if (xMPalignedArray.hasShadow()) {
            throw new XMPexception("the aligned array '" + string + "' has the shadow declaration already");
        }
        Boolean bl3 = xMPalignedArray.getArrayId().Type().getKind() == 7;
        XobjList xobjList2 = Xcons.List(xMPalignedArray.getDescId().Ref());
        int n = 0;
        int n2 = xMPalignedArray.getDim();
        for (object = xobjList.getArg(1).getArgs(); object != null; object = ((XobjArgs)object).nextArgs()) {
            if (n == n2) {
                throw new XMPexception("wrong shadow dimension indicated, too many");
            }
            XobjList xobjList3 = (XobjList)((XobjArgs)object).getArg();
            XobjInt xobjInt = (XobjInt)xobjList3.getArg(0);
            XobjList xobjList4 = (XobjList)xobjList3.getArg(1);
            switch (xobjInt.getInt()) {
                case 400: {
                    xobjList2.add(Xcons.Cast(Xtype.intType, Xcons.IntConstant(400)));
                    xMPalignedArray.setShadowAt(new XMPshadow(400, null, null), n);
                    break;
                }
                case 401: {
                    Xobject xobject = xobjList4.left();
                    Xobject xobject2 = xobjList4.right();
                    if (xobject.isZeroConstant() && xobject2.isZeroConstant()) {
                        xobjList2.add(Xcons.Cast(Xtype.intType, Xcons.IntConstant(400)));
                        xMPalignedArray.setShadowAt(new XMPshadow(400, null, null), n);
                        break;
                    }
                    if (xMPalignedArray.getAlignMannerAt(n) == 200) {
                        throw new XMPexception("indicated dimension is not aligned");
                    }
                    if (xMPalignedArray.getAlignMannerAt(n) == 201) {
                        throw new XMPexception("indicated dimension is not distributed");
                    }
                    if (xMPalignedArray.getAlignMannerAt(n) != 202 && xMPalignedArray.getAlignMannerAt(n) != 205) {
                        throw new XMPexception("shadow should be declared on block or gblock distbirution");
                    }
                    xobjList2.add(Xcons.Cast(Xtype.intType, Xcons.IntConstant(401)));
                    xobjList2.add(Xcons.Cast(Xtype.intType, xobject));
                    xobjList2.add(Xcons.Cast(Xtype.intType, xobject2));
                    xMPalignedArray.setShadowAt(new XMPshadow(401, xobject, xobject2), n);
                    break;
                }
                case 402: {
                    if (xMPalignedArray.getAlignMannerAt(n) == 200) {
                        throw new XMPexception("indicated dimension is not aligned");
                    }
                    if (xMPalignedArray.getAlignMannerAt(n) == 201) {
                        throw new XMPexception("indicated dimension is not distributed");
                    }
                    xobjList2.add(Xcons.Cast(Xtype.intType, Xcons.IntConstant(402)));
                    xMPalignedArray.setShadowAt(new XMPshadow(402, null, null), n);
                    break;
                }
                default: {
                    throw new XMPexception("unknown shadow type");
                }
            }
            ++n;
        }
        if (n != n2) {
            throw new XMPexception("the number of <nodes/template-subscript> should be the same with the dimension");
        }
        Object object2 = object = bl3 != false ? "_XMP_init_shadow_noalloc" : "_XMP_init_shadow";
        if (bl) {
            if (xMPalignedArray.isStaticDesc()) {
                XMPlocalDecl.addConstructorCall2_staticDesc((String)object, xobjList2, xMPglobalDecl, block, xMPalignedArray.getFlagId(), false);
            } else {
                XMPlocalDecl.addConstructorCall2((String)object, xobjList2, xMPglobalDecl, block);
            }
        } else {
            xMPglobalDecl.addGlobalInitFuncCall((String)object, xobjList2);
        }
        xMPalignedArray.setHasShadow();
    }

    public static Block translateReflect(PragmaBlock pragmaBlock, XMPglobalDecl xMPglobalDecl, boolean bl) throws XMPexception {
        Object object;
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(pragmaBlock);
        BlockList blockList = Bcons.emptyBody();
        XobjList xobjList2 = Xcons.List();
        XobjList xobjList3 = (XobjList)xobjList.getArg(0);
        for (object = xobjList3.getArgs(); object != null; object = ((XobjArgs)object).nextArgs()) {
            XobjList xobjList4;
            Xobject xobject;
            Xobject xobject2;
            Xobject xobject3;
            Xobject xobject4;
            String string = ((XobjArgs)object).getArg().getString();
            XMPalignedArray xMPalignedArray = xMPglobalDecl.getXMPalignedArray(string, pragmaBlock);
            if (xMPalignedArray == null) {
                throw new XMPexception("the aligned array '" + string + "' is not found");
            }
            if (!xMPalignedArray.hasShadow()) {
                throw new XMPexception("the aligned array '" + string + "' has no shadow declaration");
            }
            Xobject xobject5 = null;
            if (xobjList.Nargs() > 2) {
                if (xobjList.getArg(1) != null) {
                    xobject4 = (XobjList)xobjList.getArg(1);
                    for (int i = 0; i < ((XobjList)xobject4).Nargs(); ++i) {
                        xobject3 = (XobjList)((XobjList)xobject4).getArg(i);
                        if (((XobjList)xobject3).getArg(2).getInt() == 1 && xMPalignedArray.getShadowAt(i).getType() == 402) {
                            throw new XMPexception("Periodic reflect cannot be specified for a dimension with full shadow.");
                        }
                        xobject2 = xMPglobalDecl.declExternFunc(bl ? "_XMP_set_reflect_acc__" : "_XMP_set_reflect__");
                        xobject = Xcons.List(xMPalignedArray.getDescId().Ref(), Xcons.IntConstant(i), ((XobjList)xobject3).getArg(0), ((XobjList)xobject3).getArg(1), ((XobjList)xobject3).getArg(2));
                        blockList.add(Bcons.Statement(((Ident)xobject2).Call(xobject)));
                    }
                }
                if (!(xobjList.getArg(2) == null || xobjList.getArg(2) instanceof XobjList && xobjList.getArg(2).Nargs() == 0)) {
                    xobject5 = xobjList.getArg(2);
                }
            }
            if (xobject5 != null) {
                xobject4 = xMPglobalDecl.declExternFunc("xmpc_init_async");
                xobjList4 = Xcons.List(xobject5);
                xobject3 = xMPglobalDecl.declExternFunc("_XMP_reflect_async__");
                xobject2 = Xcons.List(xMPalignedArray.getDescId().Ref(), xobject5);
                xobject = xMPglobalDecl.declExternFunc("xmpc_start_async");
                XobjList xobjList5 = Xcons.List();
                blockList.add(Bcons.Statement(((Ident)xobject4).Call(xobjList4)));
                blockList.add(Bcons.Statement(((Ident)xobject3).Call(xobject2)));
                blockList.add(Bcons.Statement(xobject.Call(xobjList5)));
                continue;
            }
            xobject4 = xMPglobalDecl.declExternFunc(bl ? "_XMP_reflect_acc__" : "_XMP_reflect__");
            xobjList4 = Xcons.List(xMPalignedArray.getDescId().Ref());
            if (bl) {
                xobject3 = xMPalignedArray.getAddrId().Ref();
                xobjList4.cons(xobject3);
                xobjList2.add(xobject3);
            }
            blockList.add(Bcons.Statement(((Ident)xobject4).Call(xobjList4)));
        }
        object = Bcons.COMPOUND(blockList);
        if (bl && !xobjList2.isEmpty()) {
            object = XMPtranslateLocalPragma.encloseWithAccHostDataDirective((Block)object, xobjList2);
        }
        pragmaBlock.replace((Block)object);
        return object;
    }

    public static Block translateReduceShadow(PragmaBlock pragmaBlock, XMPglobalDecl xMPglobalDecl, boolean bl) throws XMPexception {
        Object object;
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(pragmaBlock);
        BlockList blockList = Bcons.emptyBody();
        XobjList xobjList2 = Xcons.List();
        XobjList xobjList3 = (XobjList)xobjList.getArg(0);
        for (object = xobjList3.getArgs(); object != null; object = ((XobjArgs)object).nextArgs()) {
            XobjList xobjList4;
            Xobject xobject;
            Xobject xobject2;
            Xobject xobject3;
            Xobject xobject4;
            String string = ((XobjArgs)object).getArg().getString();
            XMPalignedArray xMPalignedArray = xMPglobalDecl.getXMPalignedArray(string, pragmaBlock);
            if (xMPalignedArray == null) {
                throw new XMPexception("the aligned array '" + string + "' is not found");
            }
            if (!xMPalignedArray.hasShadow()) {
                throw new XMPexception("the aligned array '" + string + "' has no shadow declaration");
            }
            Xobject xobject5 = null;
            if (xobjList.Nargs() > 2) {
                if (xobjList.getArg(1) != null) {
                    xobject4 = (XobjList)xobjList.getArg(1);
                    for (int i = 0; i < ((XobjList)xobject4).Nargs(); ++i) {
                        xobject3 = (XobjList)((XobjList)xobject4).getArg(i);
                        if (((XobjList)xobject3).getArg(2).getInt() == 1 && xMPalignedArray.getShadowAt(i).getType() == 402) {
                            throw new XMPexception("Periodic reduceShadow cannot be specified for a dimension with full shadow.");
                        }
                        xobject2 = xMPglobalDecl.declExternFunc(bl ? "_XMP_set_reduce_shadow_acc__" : "_XMP_set_reduce_shadow__");
                        xobject = Xcons.List(xMPalignedArray.getDescId().Ref(), Xcons.IntConstant(i), ((XobjList)xobject3).getArg(0), ((XobjList)xobject3).getArg(1), ((XobjList)xobject3).getArg(2));
                        blockList.add(Bcons.Statement(((Ident)xobject2).Call(xobject)));
                    }
                }
                if (!(xobjList.getArg(2) == null || xobjList.getArg(2) instanceof XobjList && xobjList.getArg(2).Nargs() == 0)) {
                    xobject5 = xobjList.getArg(2);
                }
            }
            if (xobject5 != null) {
                xobject4 = xMPglobalDecl.declExternFunc("xmpc_init_async");
                xobjList4 = Xcons.List(xobject5);
                xobject3 = xMPglobalDecl.declExternFunc("_XMP_reduce_shadow__");
                xobject2 = Xcons.List(xMPalignedArray.getDescId().Ref());
                xobject = xMPglobalDecl.declExternFunc("xmpc_start_async");
                XobjList xobjList5 = Xcons.List();
                blockList.add(Bcons.Statement(((Ident)xobject4).Call(xobjList4)));
                blockList.add(Bcons.Statement(((Ident)xobject3).Call(xobject2)));
                blockList.add(Bcons.Statement(xobject.Call(xobjList5)));
                continue;
            }
            xobject4 = xMPglobalDecl.declExternFunc(bl ? "_XMP_reduce_shadow_acc__" : "_XMP_reduce_shadow__");
            xobjList4 = Xcons.List(xMPalignedArray.getDescId().Ref());
            if (bl) {
                xobject3 = xMPalignedArray.getAddrId().Ref();
                xobjList4.cons(xobject3);
                xobjList2.add(xobject3);
            }
            blockList.add(Bcons.Statement(((Ident)xobject4).Call(xobjList4)));
        }
        object = Bcons.COMPOUND(blockList);
        if (bl && !xobjList2.isEmpty()) {
            object = XMPtranslateLocalPragma.encloseWithAccHostDataDirective((Block)object, xobjList2);
        }
        pragmaBlock.replace((Block)object);
        return object;
    }

    public static Block translateGpuReflect(PragmaBlock pragmaBlock, XMPglobalDecl xMPglobalDecl) throws XMPexception {
        Object object;
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(pragmaBlock);
        BlockList blockList = Bcons.emptyBody();
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        for (object = xobjList2.getArgs(); object != null; object = ((XobjArgs)object).nextArgs()) {
            String string = ((XobjArgs)object).getArg().getString();
            XMPgpuData xMPgpuData = XMPgpuDataTable.findXMPgpuData(string, pragmaBlock);
            if (xMPgpuData == null) {
                throw new XMPexception("'" + string + "' is not allocated on the accelerator");
            }
            XMPalignedArray xMPalignedArray = xMPgpuData.getXMPalignedArray();
            if (xMPalignedArray == null) {
                throw new XMPexception("the aligned array '" + string + "' is not found");
            }
            if (!xMPalignedArray.hasShadow()) {
                throw new XMPexception("the aligned array '" + string + "' has no shadow declaration");
            }
            int n = xMPalignedArray.getDim();
            block6: for (int i = 0; i < n; ++i) {
                XMPshadow xMPshadow = xMPalignedArray.getShadowAt(i);
                switch (xMPshadow.getType()) {
                    case 400: {
                        continue block6;
                    }
                    case 401: {
                        XMPshadow.createGpuReflectNormalShadowFunc(pragmaBlock, xMPglobalDecl, xMPgpuData, i, blockList);
                        continue block6;
                    }
                    case 402: {
                        throw new XMPexception("not implemented yet");
                    }
                    default: {
                        throw new XMPexception("unknown shadow type");
                    }
                }
            }
        }
        object = Bcons.COMPOUND(blockList);
        pragmaBlock.replace((Block)object);
        return object;
    }

    private static void createGpuReflectNormalShadowFunc(PragmaBlock pragmaBlock, XMPglobalDecl xMPglobalDecl, XMPgpuData xMPgpuData, int n, BlockList blockList) {
        XMPalignedArray xMPalignedArray = xMPgpuData.getXMPalignedArray();
        String string = xMPalignedArray.getName();
        Ident ident = blockList.declLocalIdent("_XMP_gpu_reflect_LO_SEND_" + string, Xtype.voidPtrType);
        Ident ident2 = blockList.declLocalIdent("_XMP_gpu_reflect_LO_RECV_" + string, Xtype.voidPtrType);
        Ident ident3 = blockList.declLocalIdent("_XMP_gpu_reflect_HI_SEND_" + string, Xtype.voidPtrType);
        Ident ident4 = blockList.declLocalIdent("_XMP_gpu_reflect_HI_RECV_" + string, Xtype.voidPtrType);
        Ident ident5 = xMPglobalDecl.declExternFunc("_XMP_gpu_pack_shadow_NORMAL");
        XobjList xobjList = Xcons.List(xMPgpuData.getHostDescId().Ref(), ident.getAddr(), ident3.getAddr(), Xcons.IntConstant(n));
        blockList.add(Bcons.Statement(ident5.Call(xobjList)));
        Ident ident6 = xMPglobalDecl.declExternFunc("_XMP_exchange_shadow_NORMAL");
        XobjList xobjList2 = Xcons.List(ident2.getAddr(), ident4.getAddr(), ident.Ref(), ident3.Ref());
        xobjList2.add(xMPalignedArray.getDescId().Ref());
        xobjList2.add(Xcons.IntConstant(n));
        blockList.add(Bcons.Statement(ident6.Call(xobjList2)));
        Ident ident7 = xMPglobalDecl.declExternFunc("_XMP_gpu_unpack_shadow_NORMAL");
        XobjList xobjList3 = Xcons.List(xMPgpuData.getHostDescId().Ref(), ident2.Ref(), ident4.Ref(), Xcons.IntConstant(n));
        blockList.add(Bcons.Statement(ident7.Call(xobjList3)));
    }
}

