/*
 * Decompiled with CFR 0.152.
 */
package exc.xcalablemp;

import exc.block.BasicBlock;
import exc.block.BasicBlockExprIterator;
import exc.block.BasicBlockIterator;
import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockList;
import exc.block.ForBlock;
import exc.block.FuncDefBlock;
import exc.block.FunctionBlock;
import exc.block.PragmaBlock;
import exc.block.Statement;
import exc.block.topdownBlockIterator;
import exc.object.Ident;
import exc.object.PropObject;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectIterator;
import exc.object.Xtype;
import exc.object.bottomupXobjectIterator;
import exc.object.topdownXobjectIterator;
import exc.xcalablemp.XMP;
import exc.xcalablemp.XMPalignedArray;
import exc.xcalablemp.XMPcoarray;
import exc.xcalablemp.XMPexception;
import exc.xcalablemp.XMPglobalDecl;
import exc.xcalablemp.XMPlocalDecl;
import exc.xcalablemp.XMPnodes;
import exc.xcalablemp.XMPobject;
import exc.xcalablemp.XMPshadow;
import exc.xcalablemp.XMPsymbolTable;
import exc.xcalablemp.XMPtemplate;
import exc.xcalablemp.XMPutil;
import java.util.ArrayList;
import java.util.HashMap;

public class XMPrewriteExpr {
    private XMPglobalDecl _globalDecl;

    public XMPrewriteExpr(XMPglobalDecl xMPglobalDecl) {
        this._globalDecl = xMPglobalDecl;
    }

    public void rewrite(FuncDefBlock funcDefBlock) {
        FunctionBlock functionBlock = funcDefBlock.getBlock();
        if (functionBlock == null) {
            return;
        }
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(functionBlock);
        this.rewriteParams(functionBlock, xMPsymbolTable);
        this.rewriteDecls(functionBlock, xMPsymbolTable);
        this.rewriteStmts(functionBlock, xMPsymbolTable);
        this.rewriteFuncExprs(functionBlock, xMPsymbolTable);
        this.rewriteOMPpragma(functionBlock, xMPsymbolTable);
        this.rewriteACCpragma(functionBlock, xMPsymbolTable);
        XMPlocalDecl.setupObjectId(functionBlock);
        XMPlocalDecl.setupConstructor(functionBlock);
        XMPlocalDecl.setupDestructor(functionBlock);
        if (functionBlock.getName() == "main") {
            this.addBarrier(functionBlock);
        }
        funcDefBlock.finalizeBlock();
    }

    private void rewriteParams(FunctionBlock functionBlock, XMPsymbolTable xMPsymbolTable) {
        XobjList xobjList = functionBlock.getBody().getIdentList();
        if (xobjList == null) {
            return;
        }
        for (Xobject xobject : xobjList) {
            Ident ident = (Ident)xobject;
            XMPalignedArray xMPalignedArray = xMPsymbolTable.getXMPalignedArray(ident.getName());
            if (xMPalignedArray == null) continue;
            ident.setType(Xtype.Pointer(xMPalignedArray.getType()));
        }
    }

    private void rewriteDecls(FunctionBlock functionBlock, XMPsymbolTable xMPsymbolTable) {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(functionBlock);
        topdownBlockIterator2.init();
        while (!topdownBlockIterator2.end()) {
            XobjList xobjList;
            Block block = topdownBlockIterator2.getBlock();
            BlockList blockList = block.getBody();
            if (blockList != null && (xobjList = (XobjList)blockList.getDecls()) != null) {
                try {
                    for (Xobject xobject : xobjList) {
                        if (Xcode.VAR_DECL != xobject.Opcode()) continue;
                        Xobject xobject2 = xobject.getArg(1);
                        xobject.setArg(1, this.rewriteExpr(xobject2, block));
                    }
                }
                catch (XMPexception xMPexception) {
                    XMP.error(block.getLineNo(), xMPexception.getMessage());
                }
            }
            topdownBlockIterator2.next();
        }
    }

    private void rewriteFuncExprs(FunctionBlock functionBlock, XMPsymbolTable xMPsymbolTable) {
        BasicBlockExprIterator basicBlockExprIterator = new BasicBlockExprIterator(functionBlock);
        basicBlockExprIterator.init();
        while (!basicBlockExprIterator.end()) {
            Xobject xobject = basicBlockExprIterator.getExpr();
            try {
                switch (xobject.Opcode()) {
                    case ASSIGN_EXPR: {
                        basicBlockExprIterator.setExpr(this.rewriteAssignExpr(xobject, basicBlockExprIterator.getBasicBlock().getParent(), xMPsymbolTable, basicBlockExprIterator));
                        break;
                    }
                    default: {
                        basicBlockExprIterator.setExpr(this.rewriteExpr(xobject, basicBlockExprIterator.getBasicBlock().getParent()));
                        break;
                    }
                }
            }
            catch (XMPexception xMPexception) {
                XMP.error(xobject.getLineNo(), xMPexception.getMessage());
            }
            basicBlockExprIterator.next();
        }
    }

    private Xobject rewriteAssignExpr(Xobject xobject, Block block, XMPsymbolTable xMPsymbolTable, BasicBlockExprIterator basicBlockExprIterator) throws XMPexception {
        assert (xobject.Opcode() == Xcode.ASSIGN_EXPR);
        Xobject xobject2 = xobject.getArg(0);
        Xobject xobject3 = xobject.getArg(1);
        if (xobject2.Opcode() == Xcode.CO_ARRAY_REF && xobject3.Opcode() == Xcode.CO_ARRAY_REF) {
            throw new XMPexception("unknown co-array expression");
        }
        if (xobject2.Opcode() == Xcode.CO_ARRAY_REF || xobject3.Opcode() == Xcode.CO_ARRAY_REF) {
            return this.rewriteCoarrayAssignExpr(xobject, block, xMPsymbolTable, basicBlockExprIterator);
        }
        return this.rewriteExpr(xobject, block);
    }

    private Xobject createContiguousCoarray(int n, XobjList xobjList, String string, XMPcoarray xMPcoarray, XMPcoarray xMPcoarray2, Xobject xobject, Xobject xobject2, boolean bl, boolean bl2) throws XMPexception {
        Xobject xobject3;
        Xobject xobject4;
        int n2;
        int n3;
        Xobject xobject5;
        int n4;
        int n5;
        int n6;
        boolean bl3 = bl || bl2;
        String string2 = "_XMP_coarray_contiguous_" + string;
        if (bl3) {
            string2 = string2 + "_acc";
        }
        Ident ident = this._globalDecl.declExternFunc(string2);
        XobjList xobjList2 = Xcons.List();
        XMPcoarray xMPcoarray3 = string == "put" ? xMPcoarray : xMPcoarray2;
        int[] nArray = new int[n];
        for (int i = 0; i < n - 1; ++i) {
            nArray[i] = 1;
            for (n6 = 0; n6 < n - 1 - i; ++n6) {
                int n7 = i;
                nArray[n7] = nArray[n7] * xMPcoarray3.getImageAt(n6);
            }
        }
        nArray[n - 1] = 1;
        Xobject xobject6 = xobjList.getArg(0);
        for (n6 = 1; n6 < n; ++n6) {
            Xobject xobject7 = Xcons.binaryOp(Xcode.MUL_EXPR, xobjList.getArg(n6), Xcons.IntConstant(nArray[n - 1 - n6]));
            xobject6 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject7, xobject6);
        }
        xobjList2.add(xobject6);
        xobjList2.add(Xcons.SymbolRef(xMPcoarray.getDescId()));
        xobjList2.add(Xcons.SymbolRef(xMPcoarray2.getDescId()));
        n6 = xMPcoarray.getVarDim();
        int n8 = xMPcoarray2.getVarDim();
        int[] nArray2 = new int[n6];
        int[] nArray3 = new int[n8];
        if (xobject.Opcode() == Xcode.VAR) {
            nArray2[0] = 1;
        } else {
            for (n5 = 0; n5 < n6; ++n5) {
                nArray2[n5] = 1;
                for (n4 = n5 + 1; n4 < n6; ++n4) {
                    int n9 = n5;
                    nArray2[n9] = nArray2[n9] * (int)xMPcoarray.getSizeAt(n4);
                }
            }
        }
        if (xobject2.Opcode() == Xcode.VAR) {
            nArray3[0] = 1;
        } else {
            for (n5 = 0; n5 < n8; ++n5) {
                nArray3[n5] = 1;
                for (n4 = n5 + 1; n4 < n8; ++n4) {
                    int n10 = n5;
                    nArray3[n10] = nArray3[n10] * (int)xMPcoarray2.getSizeAt(n4);
                }
            }
        }
        n5 = n6;
        if (xobject.Opcode() == Xcode.SUB_ARRAY_REF) {
            Ident ident2 = xMPcoarray.getVarId();
            xobject5 = (XobjList)xobject.getArg(1);
            for (n3 = n6 - 1; n3 >= 0; --n3) {
                if (!this.is_all_element(n3, (XobjList)xobject5, ident2)) continue;
                n5 = n3;
            }
        }
        int n11 = n8;
        if (xobject2.Opcode() == Xcode.SUB_ARRAY_REF) {
            xobject5 = xMPcoarray2.getVarId();
            XobjList xobjList3 = (XobjList)xobject2.getArg(1);
            for (n2 = n8 - 1; n2 >= 0; --n2) {
                if (!this.is_all_element(n2, xobjList3, (Ident)xobject5)) continue;
                n11 = n2;
            }
        }
        xobject5 = null;
        if (xobject.Opcode() == Xcode.SUB_ARRAY_REF) {
            for (n3 = 0; n3 < n6; ++n3) {
                Xobject xobject8 = xobject.getArg(1).getArg(n3);
                if (!xobject8.isIndexRange()) {
                    xobject4 = Xcons.binaryOp(Xcode.MUL_EXPR, xobject8, Xcons.IntConstant(nArray2[n3]));
                } else {
                    xobject3 = ((XobjList)xobject8).getArg(0);
                    xobject4 = Xcons.binaryOp(Xcode.MUL_EXPR, xobject3, Xcons.IntConstant(nArray2[n3]));
                }
                xobject5 = n3 == 0 ? xobject4 : Xcons.binaryOp(Xcode.PLUS_EXPR, xobject5, xobject4);
            }
        } else if (xobject.Opcode() == Xcode.ARRAY_REF) {
            for (n3 = 0; n3 < n6; ++n3) {
                Xobject xobject9 = Xcons.binaryOp(Xcode.MUL_EXPR, xobject.getArg(1).getArg(n3), Xcons.IntConstant(nArray2[n3]));
                xobject5 = n3 == 0 ? xobject9 : Xcons.binaryOp(Xcode.PLUS_EXPR, xobject5, xobject9);
            }
        } else if (xobject.Opcode() == Xcode.VAR) {
            xobject5 = Xcons.IntConstant(0);
        } else {
            throw new XMPexception("Not supported this coarray Syntax");
        }
        Xtype xtype = xMPcoarray.getElmtType();
        xobject5 = Xcons.binaryOp(Xcode.MUL_EXPR, xobject5, Xcons.SizeOf(xtype));
        xobjList2.add(xobject5);
        xobject5 = null;
        if (xobject2.Opcode() == Xcode.SUB_ARRAY_REF) {
            for (n2 = 0; n2 < n8; ++n2) {
                xobject4 = xobject2.getArg(1).getArg(n2);
                if (!xobject4.isIndexRange()) {
                    xobject3 = Xcons.binaryOp(Xcode.MUL_EXPR, xobject4, Xcons.IntConstant(nArray3[n2]));
                } else {
                    Xobject xobject10 = ((XobjList)xobject4).getArg(0);
                    xobject3 = Xcons.binaryOp(Xcode.MUL_EXPR, xobject10, Xcons.IntConstant(nArray3[n2]));
                }
                xobject5 = n2 == 0 ? xobject3 : Xcons.binaryOp(Xcode.PLUS_EXPR, xobject5, xobject3);
            }
        } else if (xobject2.Opcode() == Xcode.ARRAY_REF) {
            for (n2 = 0; n2 < n8; ++n2) {
                xobject4 = Xcons.binaryOp(Xcode.MUL_EXPR, xobject2.getArg(1).getArg(n2), Xcons.IntConstant(nArray3[n2]));
                xobject5 = n2 == 0 ? xobject4 : Xcons.binaryOp(Xcode.PLUS_EXPR, xobject5, xobject4);
            }
        } else if (xobject2.Opcode() == Xcode.VAR) {
            xobject5 = Xcons.IntConstant(0);
        } else {
            throw new XMPexception("Not supported this coarray Syntax");
        }
        xobject5 = Xcons.binaryOp(Xcode.MUL_EXPR, xobject5, Xcons.SizeOf(xtype));
        xobjList2.add(xobject5);
        Xobject xobject11 = null;
        if (xobject.Opcode() == Xcode.SUB_ARRAY_REF) {
            xobject11 = n5 == 0 ? Xcons.IntConstant((int)xMPcoarray.getSizeAt(0) * nArray2[0]) : (!(xobject4 = xobject.getArg(1).getArg(n5 - 1)).isIndexRange() ? Xcons.IntConstant(nArray2[n5 - 1]) : Xcons.binaryOp(Xcode.MUL_EXPR, ((XobjList)xobject4).getArg(1), Xcons.IntConstant(nArray2[n5 - 1])));
        } else if (xobject.Opcode() == Xcode.ARRAY_REF || xobject.Opcode() == Xcode.VAR) {
            xobject11 = Xcons.IntConstant(1);
        } else {
            throw new XMPexception("Not supported this coarray Syntax");
        }
        xobjList2.add(xobject11);
        xobject4 = null;
        if (xobject2.Opcode() == Xcode.SUB_ARRAY_REF) {
            xobject4 = n11 == 0 ? Xcons.IntConstant((int)xMPcoarray2.getSizeAt(0) * nArray3[0]) : (!(xobject3 = xobject2.getArg(1).getArg(n11 - 1)).isIndexRange() ? Xcons.IntConstant(nArray3[n11 - 1]) : Xcons.binaryOp(Xcode.MUL_EXPR, ((XobjList)xobject3).getArg(1), Xcons.IntConstant(nArray3[n11 - 1])));
        } else if (xobject2.Opcode() == Xcode.ARRAY_REF || xobject2.Opcode() == Xcode.VAR) {
            xobject4 = Xcons.IntConstant(1);
        } else {
            throw new XMPexception("Not supported this coarray Syntax");
        }
        xobjList2.add(xobject4);
        if (bl3) {
            xobjList2.add(Xcons.IntConstant(bl ? 1 : 0));
            xobjList2.add(Xcons.IntConstant(bl2 ? 1 : 0));
        }
        xobject3 = ident.Call(xobjList2);
        xobject3.setIsRewrittedByXmp(true);
        return xobject3;
    }

    private Xobject rewriteCoarrayAssignExpr(Xobject xobject, Block block, XMPsymbolTable xMPsymbolTable, BasicBlockExprIterator basicBlockExprIterator) throws XMPexception {
        boolean bl;
        int n;
        Object object;
        Object object2;
        Object object3;
        int n2;
        Ident ident;
        Xobject xobject2;
        int n3;
        Xobject xobject3;
        String string;
        boolean bl2;
        assert (xobject.Opcode() == Xcode.ASSIGN_EXPR);
        Xobject xobject4 = xobject.getArg(0);
        Xobject xobject5 = xobject.getArg(1);
        Xobject xobject6 = null;
        Xobject xobject7 = null;
        if (xobject4.Opcode() == Xcode.CO_ARRAY_REF) {
            xobject6 = xobject4;
            xobject7 = xobject5;
        } else {
            xobject6 = xobject5;
            xobject7 = xobject4;
        }
        String string2 = XMPutil.getXobjSymbolName(xobject6.getArg(0));
        XMPcoarray xMPcoarray = this._globalDecl.getXMPcoarray(string2, block);
        if (xMPcoarray == null) {
            throw new XMPexception("cannot find coarray '" + string2 + "'");
        }
        XobjList xobjList = Xcons.List();
        int n4 = xMPcoarray.getVarDim();
        if (xobject7.Opcode() == Xcode.SUB_ARRAY_REF || xobject7.Opcode() == Xcode.ARRAY_REF) {
            bl2 = true;
            string = xobject7.getArg(0).getName();
            xobject3 = xobject7.findVarIdent(string);
            n3 = xobject3.Type().getNumDimensions();
        } else if (xobject7.Opcode() == Xcode.VAR || xobject7.Opcode() == Xcode.POINTER_REF) {
            string = xobject7.Opcode() == Xcode.VAR ? xobject7.getName() : xobject7.getArg(0).getName();
            bl2 = false;
            n3 = 1;
        } else {
            if (xobject7.Opcode() == Xcode.ARRAY_ADDR) {
                throw new XMPexception("Array pointer is used at coarray Syntax");
            }
            if (xobject7.isConstant()) {
                throw new XMPexception("Not supported a Constant Value at coarray Syntax");
            }
            throw new XMPexception("Not supported this coarray Syntax");
        }
        xobject3 = (XobjList)xobject6.getArg(1);
        int n5 = xMPcoarray.getImageDim();
        if (this.isContiguousArray(xobject6, block) && this.isContiguousArray(xobject7, block) && this.isCoarray(xobject7, block)) {
            XMPcoarray xMPcoarray2 = xMPcoarray;
            XMPcoarray xMPcoarray3 = this._globalDecl.getXMPcoarray(string, block);
            boolean bl3 = this.isUseDevice(xMPcoarray2.getName(), block);
            boolean bl4 = this.isUseDevice(xMPcoarray3.getName(), block);
            if (xobject4.Opcode() == Xcode.CO_ARRAY_REF) {
                return this.createContiguousCoarray(n5, (XobjList)xobject3, "put", xMPcoarray2, xMPcoarray3, xobject6.getArg(0), xobject7, bl3, bl4);
            }
            return this.createContiguousCoarray(n5, (XobjList)xobject3, "get", xMPcoarray3, xMPcoarray2, xobject7, xobject6.getArg(0), bl3, bl4);
        }
        xobjList = Xcons.List();
        if (xobject6.getArg(0).Opcode() == Xcode.SUB_ARRAY_REF) {
            xobject2 = (XobjList)xobject6.getArg(0).getArg(1);
            ident = this._globalDecl.declExternFunc("_XMP_coarray_rdma_coarray_set_" + Integer.toString(((XobjList)xobject2).Nargs()));
            for (n2 = 0; n2 < ((XobjList)xobject2).Nargs(); ++n2) {
                if (!((XobjList)xobject2).getArg(n2).isIndexRange()) {
                    xobjList.add(((XobjList)xobject2).getArg(n2));
                    xobjList.add(Xcons.IntConstant(1));
                    xobjList.add(Xcons.IntConstant(1));
                    continue;
                }
                for (int i = 0; i < 3; ++i) {
                    xobjList.add(((XobjList)xobject2).getArg(n2).getArg(i));
                }
            }
        } else if (xobject6.getArg(0).Opcode() == Xcode.ARRAY_REF) {
            ident = this._globalDecl.declExternFunc("_XMP_coarray_rdma_coarray_set_1");
            xobject2 = (XobjList)xobject6.getArg(0).getArg(1);
            ident = this._globalDecl.declExternFunc("_XMP_coarray_rdma_coarray_set_" + Integer.toString(((XobjList)xobject2).Nargs()));
            for (n2 = 0; n2 < ((XobjList)xobject2).Nargs(); ++n2) {
                xobjList.add(((XobjList)xobject2).getArg(n2));
                xobjList.add(Xcons.IntConstant(1));
                xobjList.add(Xcons.IntConstant(1));
            }
        } else if (xobject6.getArg(0).Opcode() == Xcode.VAR) {
            ident = this._globalDecl.declExternFunc("_XMP_coarray_rdma_coarray_set_1");
            xobjList.add(Xcons.IntConstant(0));
            xobjList.add(Xcons.IntConstant(1));
            xobjList.add(Xcons.IntConstant(1));
        } else {
            throw new XMPexception("Not supported this coarray Syntax");
        }
        xobject2 = ident.Call(xobjList);
        xobject2.setIsRewrittedByXmp(true);
        basicBlockExprIterator.insertStatement(xobject2);
        xobjList = Xcons.List();
        if (bl2) {
            int n6;
            String string3 = xobject7.getArg(0).getName();
            Ident ident2 = xobject7.findVarIdent(string3);
            object3 = ident2.Type();
            object2 = ((Xtype)object3).getArrayElementType();
            int n7 = ((Xtype)object3).getNumDimensions();
            ident = this._globalDecl.declExternFunc("_XMP_coarray_rdma_array_set_" + Integer.toString(n7));
            object = new Integer[n7];
            int n8 = 0;
            while (n8 < n7) {
                n6 = (int)((Xtype)object3).getArraySize();
                if (n6 == 0 || n6 == -1) {
                    throw new XMPexception("array size should be declared statically");
                }
                object[n8] = n6;
                ++n8;
                object3 = ((Xtype)object3).getRef();
            }
            XobjList xobjList2 = (XobjList)xobject7.getArg(1);
            for (n6 = 0; n6 < xobjList2.Nargs(); ++n6) {
                if (!xobjList2.getArg(n6).isIndexRange()) {
                    xobjList.add(xobjList2.getArg(n6));
                    xobjList.add(Xcons.IntConstant(1));
                    xobjList.add(Xcons.IntConstant(1));
                    xobjList.add(Xcons.IntConstant(object[n6]));
                    continue;
                }
                for (int i = 0; i < 3; ++i) {
                    xobjList.add(xobjList2.getArg(n6).getArg(i));
                }
                xobjList.add(Xcons.IntConstant(object[n6]));
            }
            xobjList.add(Xcons.SizeOf((Xtype)object2));
        } else {
            ident = this._globalDecl.declExternFunc("_XMP_coarray_rdma_array_set_1");
            xobjList.add(Xcons.IntConstant(0));
            xobjList.add(Xcons.IntConstant(1));
            xobjList.add(Xcons.IntConstant(1));
            xobjList.add(Xcons.IntConstant(1));
            xobjList.add(Xcons.SizeOf(xobject7.Type()));
        }
        xobject2 = ident.Call(xobjList);
        xobject2.setIsRewrittedByXmp(true);
        basicBlockExprIterator.insertStatement(xobject2);
        ident = this._globalDecl.declExternFunc("_XMP_coarray_rdma_image_set_" + Integer.toString(n5));
        xobjList = Xcons.List();
        for (n = 0; n < n5; ++n) {
            xobjList.add(((XobjList)xobject3).getArg(n));
        }
        xobject2 = ident.Call(xobjList);
        xobject2.setIsRewrittedByXmp(true);
        basicBlockExprIterator.insertStatement(xobject2);
        xobjList = Xcons.List();
        n = 0;
        boolean bl5 = false;
        xobjList.add(Xcons.SymbolRef(xMPcoarray.getDescId()));
        bl5 = this.isUseDevice(xMPcoarray.getName(), block);
        if (xobject7.Opcode() == Xcode.SUB_ARRAY_REF || xobject7.Opcode() == Xcode.ARRAY_REF) {
            object3 = xobject7.getArg(0);
            object2 = ((Xobject)object3).getName();
            n = this.isUseDevice((String)object2, block) ? 1 : 0;
            XMPcoarray xMPcoarray4 = this._globalDecl.getXMPcoarray((String)object2, block);
            if (xMPcoarray4 == null) {
                xobjList.add((Xobject)object3);
                object = Xcons.Cast(Xtype.voidPtrType, Xcons.IntConstant(0));
                xobjList.add((Xobject)object);
            } else {
                xobjList.add(Xcons.SymbolRef(this._globalDecl.findVarIdent("_XMP_COARRAY_ADDR_" + ((Xobject)object3).getName())));
                xobjList.add(Xcons.SymbolRef(xMPcoarray4.getDescId()));
            }
        } else if (xobject7.Opcode() == Xcode.VAR || xobject7.Opcode() == Xcode.POINTER_REF) {
            object3 = xobject7.Opcode() == Xcode.VAR ? xobject7.getName() : xobject7.getArg(0).getName();
            n = this.isUseDevice((String)object3, block) ? 1 : 0;
            object2 = this._globalDecl.getXMPcoarray((String)object3, block);
            if (object2 == null) {
                Xobject xobject8 = Xcons.AddrOf(xobject7);
                xobjList.add(xobject8);
                object = Xcons.Cast(Xtype.voidPtrType, Xcons.IntConstant(0));
                xobjList.add((Xobject)object);
            } else {
                xobjList.add(Xcons.SymbolRef(this._globalDecl.findVarIdent("_XMP_COARRAY_ADDR_" + (String)object3)));
                xobjList.add(Xcons.SymbolRef(((XMPcoarray)object2).getDescId()));
            }
        } else {
            if (xobject7.isConstant()) {
                throw new XMPexception("Not supported a Constant Value at coarray Syntax");
            }
            throw new XMPexception("Not supported this coarray Syntax");
        }
        boolean bl6 = bl = bl5 || n != 0;
        if (bl) {
            ident = xobject4.Opcode() == Xcode.CO_ARRAY_REF ? this._globalDecl.declExternFunc("_XMP_coarray_put_acc") : this._globalDecl.declExternFunc("_XMP_coarray_get_acc");
            xobjList.add(Xcons.IntConstant(bl5 ? 1 : 0));
            xobjList.add(Xcons.IntConstant(n != 0 ? 1 : 0));
        } else {
            ident = xobject4.Opcode() == Xcode.CO_ARRAY_REF ? this._globalDecl.declExternFunc("_XMP_coarray_put") : this._globalDecl.declExternFunc("_XMP_coarray_get");
        }
        xobject2 = ident.Call(xobjList);
        xobject2.setIsRewrittedByXmp(true);
        basicBlockExprIterator.insertStatement(xobject2);
        return null;
    }

    private boolean is_stride_1(int n, XobjList xobjList) {
        if (!xobjList.getArg(n).isIndexRange()) {
            return true;
        }
        Xobject xobject = xobjList.getArg(n).getArg(2);
        return xobject.isConstant() && xobject.getInt() == 1;
    }

    private boolean is_start_0(int n, XobjList xobjList) {
        Xobject xobject;
        if (xobjList.getArg(n).isVariable()) {
            return false;
        }
        if (xobjList.getArg(n).isConstant()) {
            return xobjList.getArg(n).getInt() == 0;
        }
        return xobjList.getArg(n).isIndexRange() && (xobject = xobjList.getArg(n).getArg(0)).isConstant() && xobject.getInt() == 0;
    }

    private boolean is_length_all(int n, XobjList xobjList, Ident ident) {
        if (!xobjList.getArg(n).isIndexRange()) {
            return false;
        }
        Xtype xtype = ident.Type();
        for (int i = 0; i < n; ++i) {
            xtype = xtype.getRef();
        }
        long l = xtype.getArraySize();
        Xobject xobject = xobjList.getArg(n).getArg(1);
        XobjList xobjList2 = Xcons.List(Xcode.MINUS_EXPR, (Xtype)Xtype.intType, Xcons.IntConstant((int)l), Xcons.IntConstant(0));
        if (((Xobject)xobjList2).equals(xobject)) {
            return true;
        }
        return xobject.Opcode() == Xcode.INT_CONSTANT && xobject.getInt() == (int)l;
    }

    private boolean is_all_element(int n, XobjList xobjList, Ident ident) {
        return this.is_start_0(n, xobjList) && this.is_length_all(n, xobjList, ident);
    }

    private boolean is_length_1(int n, XobjList xobjList) {
        if (!xobjList.getArg(n).isIndexRange()) {
            return true;
        }
        Xobject xobject = xobjList.getArg(n).getArg(1);
        return xobject.isConstant() && xobject.getInt() == 1;
    }

    private boolean isContiguousArray(Xobject xobject, Block block) throws XMPexception {
        if (xobject.Opcode() == Xcode.CO_ARRAY_REF) {
            xobject = xobject.getArg(0);
        }
        if (xobject.Opcode() == Xcode.VAR || xobject.Opcode() == Xcode.ARRAY_REF || xobject.Opcode() == Xcode.POINTER_REF) {
            return true;
        }
        if (xobject.Opcode() == Xcode.SUB_ARRAY_REF) {
            XobjList xobjList = (XobjList)xobject.getArg(1);
            String string = xobject.getArg(0).getName();
            Ident ident = xobject.findVarIdent(string);
            Xtype xtype = ident.Type();
            int n = xtype.getNumDimensions();
            if (n == 1) {
                return this.is_stride_1(0, xobjList);
            }
            if (n == 2) {
                if (!this.is_stride_1(0, xobjList) || !this.is_stride_1(1, xobjList)) {
                    return false;
                }
                if (this.is_all_element(1, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList)) {
                    return true;
                }
            } else if (n == 3) {
                if (!(this.is_stride_1(0, xobjList) && this.is_stride_1(1, xobjList) && this.is_stride_1(2, xobjList))) {
                    return false;
                }
                if (this.is_all_element(1, xobjList, ident) && this.is_all_element(2, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_all_element(2, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_length_1(1, xobjList)) {
                    return true;
                }
            } else if (n == 4) {
                if (!(this.is_stride_1(0, xobjList) && this.is_stride_1(1, xobjList) && this.is_stride_1(2, xobjList) && this.is_stride_1(3, xobjList))) {
                    return false;
                }
                if (this.is_all_element(1, xobjList, ident) && this.is_all_element(2, xobjList, ident) && this.is_all_element(3, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_all_element(2, xobjList, ident) && this.is_all_element(3, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_length_1(1, xobjList) && this.is_all_element(3, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_length_1(1, xobjList) && this.is_length_1(2, xobjList)) {
                    return true;
                }
            } else if (n == 5) {
                if (!(this.is_stride_1(0, xobjList) && this.is_stride_1(1, xobjList) && this.is_stride_1(2, xobjList) && this.is_stride_1(3, xobjList) && this.is_stride_1(4, xobjList))) {
                    return false;
                }
                if (this.is_all_element(1, xobjList, ident) && this.is_all_element(2, xobjList, ident) && this.is_all_element(3, xobjList, ident) && this.is_all_element(4, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_all_element(2, xobjList, ident) && this.is_all_element(3, xobjList, ident) && this.is_all_element(4, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_length_1(1, xobjList) && this.is_all_element(3, xobjList, ident) && this.is_all_element(4, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_length_1(1, xobjList) && this.is_length_1(2, xobjList) && this.is_all_element(4, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_length_1(1, xobjList) && this.is_length_1(2, xobjList) && this.is_length_1(3, xobjList)) {
                    return true;
                }
            } else if (n == 6) {
                if (!(this.is_stride_1(0, xobjList) && this.is_stride_1(1, xobjList) && this.is_stride_1(2, xobjList) && this.is_stride_1(3, xobjList) && this.is_stride_1(4, xobjList) && this.is_stride_1(5, xobjList))) {
                    return false;
                }
                if (this.is_all_element(1, xobjList, ident) && this.is_all_element(2, xobjList, ident) && this.is_all_element(3, xobjList, ident) && this.is_all_element(4, xobjList, ident) && this.is_all_element(5, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_all_element(2, xobjList, ident) && this.is_all_element(3, xobjList, ident) && this.is_all_element(4, xobjList, ident) && this.is_all_element(5, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_length_1(1, xobjList) && this.is_all_element(3, xobjList, ident) && this.is_all_element(4, xobjList, ident) && this.is_all_element(5, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_length_1(1, xobjList) && this.is_length_1(2, xobjList) && this.is_all_element(4, xobjList, ident) && this.is_all_element(5, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_length_1(1, xobjList) && this.is_length_1(2, xobjList) && this.is_length_1(3, xobjList) && this.is_all_element(5, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_length_1(1, xobjList) && this.is_length_1(2, xobjList) && this.is_length_1(3, xobjList) && this.is_length_1(4, xobjList)) {
                    return true;
                }
            } else if (n == 7) {
                if (!(this.is_stride_1(0, xobjList) && this.is_stride_1(1, xobjList) && this.is_stride_1(2, xobjList) && this.is_stride_1(3, xobjList) && this.is_stride_1(4, xobjList) && this.is_stride_1(5, xobjList) && this.is_stride_1(6, xobjList))) {
                    return false;
                }
                if (this.is_all_element(1, xobjList, ident) && this.is_all_element(2, xobjList, ident) && this.is_all_element(3, xobjList, ident) && this.is_all_element(4, xobjList, ident) && this.is_all_element(5, xobjList, ident) && this.is_all_element(6, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_all_element(2, xobjList, ident) && this.is_all_element(3, xobjList, ident) && this.is_all_element(4, xobjList, ident) && this.is_all_element(5, xobjList, ident) && this.is_all_element(6, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_length_1(1, xobjList) && this.is_all_element(3, xobjList, ident) && this.is_all_element(4, xobjList, ident) && this.is_all_element(5, xobjList, ident) && this.is_all_element(6, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_length_1(1, xobjList) && this.is_length_1(2, xobjList) && this.is_all_element(4, xobjList, ident) && this.is_all_element(5, xobjList, ident) && this.is_all_element(6, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_length_1(1, xobjList) && this.is_length_1(2, xobjList) && this.is_length_1(3, xobjList) && this.is_all_element(5, xobjList, ident) && this.is_all_element(6, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_length_1(1, xobjList) && this.is_length_1(2, xobjList) && this.is_length_1(3, xobjList) && this.is_length_1(4, xobjList) && this.is_all_element(6, xobjList, ident)) {
                    return true;
                }
                if (this.is_length_1(0, xobjList) && this.is_length_1(1, xobjList) && this.is_length_1(2, xobjList) && this.is_length_1(3, xobjList) && this.is_length_1(4, xobjList) && this.is_length_1(5, xobjList)) {
                    return true;
                }
            }
        } else {
            throw new XMPexception("Not supported this coarray Syntax");
        }
        return false;
    }

    private boolean isCoarray(Xobject xobject, Block block) {
        XMPcoarray xMPcoarray;
        if (xobject.Opcode() == Xcode.ARRAY_REF || xobject.Opcode() == Xcode.SUB_ARRAY_REF || xobject.Opcode() == Xcode.ADDR_OF) {
            xobject = xobject.getArg(0);
        }
        if (xobject.Opcode() == Xcode.POINTER_REF || xobject.Opcode() == Xcode.ARRAY_REF) {
            xobject = xobject.getArg(0);
        }
        return (xMPcoarray = this._globalDecl.getXMPcoarray(xobject.getSym(), block)) != null;
    }

    private void rewriteStmts(FunctionBlock functionBlock, XMPsymbolTable xMPsymbolTable) {
        BasicBlockIterator basicBlockIterator = new BasicBlockIterator(functionBlock);
        basicBlockIterator.init();
        while (!basicBlockIterator.end()) {
            BasicBlock basicBlock = basicBlockIterator.getBasicBlock();
            for (Statement statement = basicBlock.getHead(); statement != null; statement = statement.getNext()) {
                Xobject xobject = statement.getExpr();
                try {
                    if (xobject.Opcode() != Xcode.ASSIGN_EXPR || xobject.getArg(0).Opcode() != Xcode.SUB_ARRAY_REF || xobject.getArg(1).Opcode() == Xcode.CO_ARRAY_REF) continue;
                    Block block = this.rewriteSubarrayToLoop(xobject, basicBlock.getParent());
                    statement.insertBlock(block);
                    statement.remove();
                    continue;
                }
                catch (XMPexception xMPexception) {
                    XMP.error(xobject.getLineNo(), xMPexception.getMessage());
                }
            }
            basicBlockIterator.next();
        }
    }

    private Block rewriteSubarrayToLoop(Xobject xobject, Block block) throws XMPexception {
        Xobject xobject2;
        Xobject xobject3;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Xtype xtype;
        ArrayList<Ident> arrayList = new ArrayList<Ident>(7);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(7);
        ArrayList<Object> arrayList3 = new ArrayList<Object>(7);
        ArrayList<Xobject> arrayList4 = new ArrayList<Xobject>(7);
        BlockList blockList = Bcons.emptyBody();
        Xobject xobject4 = xobject.left();
        assert (xobject4.Opcode() == Xcode.SUB_ARRAY_REF);
        String string = xobject4.getArg(0).getSym();
        Ident ident = block.findVarIdent(string);
        Xtype xtype2 = xtype = ident != null ? ident.Type() : null;
        if (xtype == null) {
            throw new XMPexception("array should be declared statically");
        }
        int n = xtype.getNumDimensions();
        if (n == 0) {
            throw new XMPexception("array should be declared statically");
        }
        Xtype xtype3 = xtype.getArrayElementType();
        XobjList xobjList = (XobjList)xobject4.getArg(1);
        Xobject xobject5 = Xcons.IntConstant(1);
        int n2 = 0;
        while (n2 < n) {
            long l = xtype.getArraySize();
            if (l == 0L || xtype.getKind() == 7) {
                throw new XMPexception("array size should be declared statically");
            }
            Xobject xobject6 = l == -1L ? xtype.getArraySizeExpr() : Xcons.LongLongConstant(0L, l);
            object4 = xobjList.getArg(n2);
            if (((Xobject)object4).isIndexRange()) {
                Xobject xobject7;
                object3 = blockList.declLocalIdent("_XMP_loop_i" + Integer.toString(n2), Xtype.intType);
                arrayList.add((Ident)object3);
                object2 = ((XobjList)object4).getArg(0);
                if (object2 == null) {
                    object2 = Xcons.IntConstant(0);
                }
                if ((object = ((XobjList)object4).getArg(1)) == null) {
                    object = xobject6;
                }
                if ((xobject7 = ((XobjList)object4).getArg(2)) == null) {
                    xobject7 = Xcons.IntConstant(1);
                }
                arrayList2.add(object2);
                arrayList3.add(object);
                xobject5 = Xcons.binaryOp(Xcode.MUL_EXPR, xobject5, (Xobject)object);
                arrayList4.add(xobject7);
                xobject3 = Xcons.binaryOp(Xcode.MUL_EXPR, ((Ident)object3).Ref(), xobject7);
                xobject3 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject3, (Xobject)object2);
                xobjList.setArg(n2, xobject3);
            }
            ++n2;
            xtype = xtype.getRef();
        }
        Xobject xobject8 = Xcons.arrayRef(xtype3, xobject4.getArg(0), xobjList);
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject);
        ((XobjectIterator)topdownXobjectIterator2).init();
        while (!((XobjectIterator)topdownXobjectIterator2).end()) {
            xobject2 = topdownXobjectIterator2.getXobject();
            if (xobject2.Opcode() == Xcode.SUB_ARRAY_REF) {
                int n3 = 0;
                object4 = xobject2.getArg(0).getSym();
                object3 = block.findVarIdent((String)object4);
                Object object5 = object2 = object3 != null ? ((Xobject)object3).Type() : null;
                if (object2 == null) {
                    throw new XMPexception("array should be declared statically");
                }
                object = ((Xtype)object2).getArrayElementType();
                int n4 = ((Xtype)object2).getNumDimensions();
                xobject3 = (XobjList)xobject2.getArg(1);
                int n5 = 0;
                while (n5 < n4) {
                    Xobject xobject9 = ((XobjList)xobject3).getArg(n5);
                    if (xobject9.isIndexRange()) {
                        Ident ident2;
                        Xobject xobject10;
                        Xobject xobject11 = ((XobjList)xobject9).getArg(0);
                        if (xobject11 == null) {
                            xobject11 = Xcons.IntConstant(0);
                        }
                        if ((xobject10 = ((XobjList)xobject9).getArg(2)) == null) {
                            xobject10 = Xcons.IntConstant(1);
                        }
                        if ((ident2 = (Ident)arrayList.get(n3)) == null) {
                            XMP.fatal("array on rhs does not conform to that on lhs.");
                        }
                        Xobject xobject12 = Xcons.binaryOp(Xcode.MUL_EXPR, ident2.Ref(), xobject10);
                        xobject12 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject12, xobject11);
                        ((XobjList)xobject3).setArg(n5, xobject12);
                        ++n3;
                    }
                    ++n5;
                    object2 = ((Xtype)object2).getRef();
                }
                Xobject xobject13 = Xcons.arrayRef((Xtype)object, xobject2.getArg(0), (XobjList)xobject3);
                ((XobjectIterator)topdownXobjectIterator2).setXobject(xobject13);
            }
            ((XobjectIterator)topdownXobjectIterator2).next();
        }
        xobject2 = blockList.declLocalIdent("_XMP_buf", Xtype.Array(xtype3, xobject5));
        Xobject xobject14 = blockList.declLocalIdent("_XMP_iter_buf", Xtype.intType, StorageClass.AUTO, Xcons.IntConstant(0)).Ref();
        object4 = Bcons.emptyBody();
        ((BlockList)object4).add(Xcons.Set(((Ident)xobject2).Index(xobject14), xobject.right()));
        ((BlockList)object4).add(Xcons.Set(xobject14, Xcons.binaryOp(Xcode.PLUS_EXPR, xobject14, Xcons.IntConstant(1))));
        object3 = Bcons.emptyBody();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            object3 = Bcons.emptyBody();
            ((BlockList)object3).add(Bcons.FORall(((Ident)arrayList.get(i)).Ref(), Xcons.IntConstant(0), (Xobject)arrayList3.get(i), Xcons.IntConstant(1), Xcode.LOG_LT_EXPR, (BlockList)object4));
            object4 = object3;
        }
        ((BlockList)object3).setIdentList(blockList.getIdentList());
        ((BlockList)object3).setDecls(blockList.getDecls());
        Object object6 = Bcons.emptyBody();
        ((BlockList)object6).add(Xcons.Set(xobject8, ((Ident)xobject2).Index(xobject14)));
        ((BlockList)object6).add(Xcons.Set(xobject14, Xcons.binaryOp(Xcode.PLUS_EXPR, xobject14, Xcons.IntConstant(1))));
        object = Bcons.emptyBody();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            object = Bcons.emptyBody();
            ((BlockList)object).add(Bcons.FORall(((Ident)arrayList.get(i)).Ref(), Xcons.IntConstant(0), (Xobject)arrayList3.get(i), Xcons.IntConstant(1), Xcode.LOG_LT_EXPR, (BlockList)object6));
            object6 = object;
        }
        ((BlockList)object3).add(Xcons.Set(xobject14, Xcons.IntConstant(0)));
        ((BlockList)object3).add(Bcons.COMPOUND((BlockList)object6));
        return Bcons.COMPOUND((BlockList)object3);
    }

    private Xobject rewriteExpr(Xobject xobject, Block block) throws XMPexception {
        if (xobject == null) {
            return null;
        }
        switch (xobject.Opcode()) {
            case ARRAY_REF: {
                return this.rewriteArrayRef(xobject, block);
            }
            case VAR: {
                return this.rewriteVarRef(xobject, block, true);
            }
            case ARRAY_ADDR: {
                return this.rewriteVarRef(xobject, block, false);
            }
            case POINTER_REF: {
                return this.rewritePointerRef(xobject, block);
            }
        }
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject);
        topdownXobjectIterator2.init();
        while (!topdownXobjectIterator2.end()) {
            Xobject xobject2 = topdownXobjectIterator2.getXobject();
            if (xobject2 != null && !xobject2.isRewrittedByXmp()) {
                switch (xobject2.Opcode()) {
                    case ARRAY_ADDR: {
                        topdownXobjectIterator2.setXobject(this.rewriteArrayAddr(xobject2, block));
                        break;
                    }
                    case ARRAY_REF: {
                        topdownXobjectIterator2.setXobject(this.rewriteArrayRef(xobject2, block));
                        break;
                    }
                    case SUB_ARRAY_REF: {
                        break;
                    }
                    case XMP_DESC_OF: {
                        topdownXobjectIterator2.setXobject(this.rewriteXmpDescOf(xobject2, block));
                        break;
                    }
                    case VAR: {
                        topdownXobjectIterator2.setXobject(this.rewriteVarRef(xobject2, block, true));
                        break;
                    }
                    case POINTER_REF: {
                        topdownXobjectIterator2.setXobject(this.rewritePointerRef(xobject2, block));
                        break;
                    }
                    case FUNCTION_CALL: {
                        Xobject xobject3 = xobject2.getArg(0);
                        if (xobject3.Opcode() == Xcode.FUNC_ADDR && xobject3.getString().equals("xmp_malloc")) {
                            Xtype xtype;
                            Xobject xobject4 = topdownXobjectIterator2.getParent();
                            if (xobject4.Opcode() != Xcode.CAST_EXPR || !(xtype = xobject4.Type()).isPointer()) break;
                            Xtype xtype2 = xtype.getRef();
                            if (xtype2.isArray()) {
                                xtype2 = xtype2.getArrayElementType();
                            }
                            xobject4.setType(Xtype.Pointer(xtype2));
                            break;
                        }
                        if (xobject3.Opcode() == Xcode.FUNC_ADDR && xobject3.getString().equals("xmp_atomic_define")) {
                            topdownXobjectIterator2.setXobject(this.rewriteXmpAtomicDefine(xobject2, block));
                            break;
                        }
                        if (xobject3.Opcode() != Xcode.FUNC_ADDR || !xobject3.getString().equals("xmp_atomic_ref")) break;
                        topdownXobjectIterator2.setXobject(this.rewriteXmpAtomicRef(xobject2, block));
                    }
                }
            }
            topdownXobjectIterator2.next();
        }
        return xobject;
    }

    private boolean isOneElement(Xobject xobject) throws XMPexception {
        Xcode xcode;
        if (xobject.Opcode() == Xcode.CO_ARRAY_REF) {
            xobject = xobject.getArg(0);
        }
        if ((xcode = xobject.Opcode()) == Xcode.VAR || xcode == Xcode.ARRAY_REF || xcode == Xcode.ADDR_OF || xcode == Xcode.INT_CONSTANT) {
            return true;
        }
        if (xcode == Xcode.SUB_ARRAY_REF) {
            return false;
        }
        throw new XMPexception("Unexpected value.");
    }

    private Xobject rewriteXmpAtomicRef(Xobject xobject, Block block) throws XMPexception {
        String string;
        Xobject xobject2 = xobject.getArg(1).getArg(0);
        Xobject xobject3 = xobject.getArg(1).getArg(1);
        if (xobject3.Opcode() == Xcode.CO_ARRAY_REF) {
            string = XMPutil.getXobjSymbolName(xobject3.getArg(0));
        } else if (xobject3.Opcode() == Xcode.VAR) {
            string = xobject3.getName();
        } else if (Xcode.ARRAY_REF == Xcode.ARRAY_REF) {
            string = xobject3.getArg(0).getName();
        } else {
            throw new XMPexception("UNKNOWN DATA TYPE of the 1st argument in xmp_atomic_ref().");
        }
        XMPcoarray xMPcoarray = this._globalDecl.getXMPcoarray(string, block);
        XobjList xobjList = Xcons.List(xMPcoarray.getDescId());
        if (xMPcoarray == null) {
            throw new XMPexception("cannot find coarray '" + string + "'");
        }
        if (!xobject2.Type().isPointer()) {
            throw new XMPexception("The first argument of atomic_ref() must be an int-type pointer.");
        }
        if (xMPcoarray.getElmtType() != Xtype.intType) {
            throw new XMPexception("The second argument of atomic_ref() must be an int-type.");
        }
        if (!this.isOneElement(xobject3) || !this.isOneElement(xobject2)) {
            throw new XMPexception("An argument of atomic_ref() must be a scalar coarray or coindexed object.");
        }
        xobjList.add(this.getCoarrayOffset(xobject3, xMPcoarray));
        int n = xobject3.Opcode() == Xcode.CO_ARRAY_REF ? xMPcoarray.getImageDim() : 0;
        String string2 = "_XMP_atomic_ref_" + n;
        Ident ident = this._globalDecl.declExternFunc(string2);
        for (int i = 0; i < n; ++i) {
            xobjList.add(xobject3.getArg(1).getArg(i));
        }
        if (this.isCoarray(xobject2, block)) {
            if ((xobject2 = xobject2.getArg(0)).Opcode() == Xcode.VAR) {
                xobjList.add(this.rewriteVarRef(xobject2, block, false));
            } else {
                xobjList.add(Xcons.AddrOf(this.rewriteArrayRef(xobject2, block)));
            }
            String string3 = xobject2.Opcode() == Xcode.VAR ? xobject2.getName() : xobject2.getArg(0).getName();
            xobjList.add(this._globalDecl.getXMPcoarray(string3, block).getDescId());
            xobjList.add(this.getCoarrayOffset(xobject2, this._globalDecl.getXMPcoarray(string3, block)));
        } else {
            xobjList.add(xobject2);
            xobjList.add(Xcons.Cast(Xtype.voidPtrType, Xcons.IntConstant(0)));
            xobjList.add(Xcons.IntConstant(0));
        }
        xobjList.add(Xcons.SizeOf(Xtype.intType));
        return ident.Call(xobjList);
    }

    private Xobject rewriteXmpAtomicDefine(Xobject xobject, Block block) throws XMPexception {
        String string;
        Xobject xobject2 = xobject.getArg(1).getArg(0);
        Xobject xobject3 = xobject.getArg(1).getArg(1);
        if (xobject2.Opcode() == Xcode.CO_ARRAY_REF) {
            string = XMPutil.getXobjSymbolName(xobject2.getArg(0));
        } else if (xobject2.Opcode() == Xcode.VAR) {
            string = xobject2.getName();
        } else if (Xcode.ARRAY_REF == Xcode.ARRAY_REF) {
            string = xobject2.getArg(0).getName();
        } else {
            throw new XMPexception("UNKNOWN DATA TYPE of the 1st argument in xmp_atomic_define().");
        }
        XMPcoarray xMPcoarray = this._globalDecl.getXMPcoarray(string, block);
        XobjList xobjList = Xcons.List(xMPcoarray.getDescId());
        if (xMPcoarray == null) {
            throw new XMPexception("cannot find coarray '" + string + "'");
        }
        if (xMPcoarray.getElmtType() != Xtype.intType || xobject3.Type() != Xtype.intType) {
            throw new XMPexception("An argument of atomic_define() must be an int-type.");
        }
        if (!this.isOneElement(xobject2) || !this.isOneElement(xobject3)) {
            throw new XMPexception("An argument of atomic_define() must be a scalar coarray or coindexed object.");
        }
        xobjList.add(this.getCoarrayOffset(xobject2, xMPcoarray));
        int n = xobject2.Opcode() == Xcode.CO_ARRAY_REF ? xMPcoarray.getImageDim() : 0;
        String string2 = "_XMP_atomic_define_" + n;
        Ident ident = this._globalDecl.declExternFunc(string2);
        for (int i = 0; i < n; ++i) {
            xobjList.add(xobject2.getArg(1).getArg(i));
        }
        if (xobject3.Opcode() == Xcode.INT_CONSTANT) {
            xobjList.add(xobject3);
            xobjList.add(Xcons.Cast(Xtype.voidPtrType, Xcons.IntConstant(0)));
            xobjList.add(Xcons.IntConstant(0));
        } else if (this.isCoarray(xobject3, block)) {
            if (xobject3.Opcode() == Xcode.VAR) {
                xobjList.add(this.rewriteVarRef(xobject3, block, true));
            } else {
                xobjList.add(this.rewriteArrayRef(xobject3, block));
            }
            String string3 = xobject3.Opcode() == Xcode.VAR ? xobject3.getName() : xobject3.getArg(0).getName();
            xobjList.add(this._globalDecl.getXMPcoarray(string3, block).getDescId());
            xobjList.add(this.getCoarrayOffset(xobject3, this._globalDecl.getXMPcoarray(string3, block)));
        } else {
            xobjList.add(xobject3);
            xobjList.add(Xcons.Cast(Xtype.voidPtrType, Xcons.IntConstant(0)));
            xobjList.add(Xcons.IntConstant(0));
        }
        xobjList.add(Xcons.SizeOf(Xtype.intType));
        return ident.Call(xobjList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Xobject rewriteXmpDescOf(Xobject xobject, Block block) throws XMPexception {
        String string = xobject.getArg(0).getName();
        XMPobject xMPobject = this._globalDecl.getXMPobject(string, block);
        Xobject xobject2 = null;
        if (xMPobject != null) {
            if (xMPobject.getKind() != 101) {
                if (xMPobject.getKind() != 100) throw new XMPexception("Bad entity name for xmp_desc_of()");
            }
            Ident ident = this._globalDecl.declExternFunc("_XMP_desc_of", xobject.Type());
            return ident.Call(Xcons.List(xMPobject.getDescId().Ref()));
        }
        String string2 = xobject.getArg(0).getSym();
        XMPalignedArray xMPalignedArray = this._globalDecl.getXMPalignedArray(string2, block);
        if (xMPalignedArray == null) {
            throw new XMPexception(string2 + " is not aligned global array or tempalte descriptor.");
        }
        Ident ident = this._globalDecl.declExternFunc("_XMP_desc_of", xobject.Type());
        return ident.Call(Xcons.List(xMPalignedArray.getDescId().Ref()));
    }

    private Xobject rewriteArrayAddr(Xobject xobject, Block block) throws XMPexception {
        XMPalignedArray xMPalignedArray = this._globalDecl.getXMPalignedArray(xobject.getSym(), block);
        XMPcoarray xMPcoarray = this._globalDecl.getXMPcoarray(xobject.getSym(), block);
        if (xMPalignedArray == null && xMPcoarray == null) {
            return xobject;
        }
        if (xMPalignedArray != null && xMPcoarray == null) {
            if (xMPalignedArray.checkRealloc() || xMPalignedArray.isLocal() && !xMPalignedArray.isParameter() || xMPalignedArray.isParameter()) {
                Xobject xobject2 = xMPalignedArray.getAddrId().Ref();
                xobject2.setIsRewrittedByXmp(true);
                return xobject2;
            }
            return xobject;
        }
        if (xMPalignedArray == null && xMPcoarray != null) {
            return this.rewriteVarRef(xobject, block, false);
        }
        return xobject;
    }

    private Xobject rewriteVarRef(Xobject xobject, Block block, boolean bl) throws XMPexception {
        String string = xobject.getSym();
        XMPalignedArray xMPalignedArray = this._globalDecl.getXMPalignedArray(string, block);
        XMPcoarray xMPcoarray = this._globalDecl.getXMPcoarray(string, block);
        if (xMPalignedArray != null && xMPcoarray == null) {
            return xMPalignedArray.getAddrId().Ref();
        }
        if (xMPalignedArray == null && xMPcoarray != null) {
            Ident ident;
            Ident ident2 = this._globalDecl.getXMPcoarray(string).getVarId();
            if (ident2 != (ident = XMPlocalDecl.findLocalIdent(block, string))) {
                return xobject;
            }
            Xobject xobject2 = this._globalDecl.findVarIdent("_XMP_COARRAY_ADDR_" + string).getValue();
            xobject2 = Xcons.PointerRef(xobject2);
            if (bl) {
                xobject2 = Xcons.PointerRef(xobject2);
            }
            return xobject2;
        }
        return xobject;
    }

    private Xobject rewriteArrayRef(Xobject xobject, Block block) throws XMPexception {
        Xobject xobject2 = xobject.getArg(0);
        if (xobject2.Opcode() != Xcode.ARRAY_ADDR && xobject2.Opcode() != Xcode.VAR) {
            return xobject;
        }
        String string = xobject2.getSym();
        XMPalignedArray xMPalignedArray = this._globalDecl.getXMPalignedArray(string, block);
        XMPcoarray xMPcoarray = this._globalDecl.getXMPcoarray(string, block);
        if (xMPalignedArray == null && xMPcoarray == null) {
            return xobject;
        }
        if (xMPalignedArray != null && xMPcoarray == null) {
            Xobject xobject3 = null;
            XobjList xobjList = XMPrewriteExpr.normArrayRefList((XobjList)xobject.getArg(1), xMPalignedArray);
            xobject3 = xMPalignedArray.checkRealloc() || xMPalignedArray.isLocal() && !xMPalignedArray.isParameter() || xMPalignedArray.isParameter() ? this.rewriteAlignedArrayExpr(xobjList, xMPalignedArray) : Xcons.arrayRef(xobject.Type(), xobject2, xobjList);
            xobject3.setIsRewrittedByXmp(true);
            return xobject3;
        }
        if (xMPalignedArray == null && xMPcoarray != null) {
            Xobject xobject4 = this.translateCoarrayRef(xobject.getArg(1), xMPcoarray);
            if (this.isAddrCoarray((XobjList)xobject.getArg(1), xMPcoarray)) {
                return Xcons.AddrOf(xobject4);
            }
            return xobject4;
        }
        return xobject;
    }

    private Xobject rewritePointerRef(Xobject xobject, Block block) throws XMPexception {
        Xobject xobject2 = xobject.getArg(0);
        if (xobject2.Opcode() == Xcode.PLUS_EXPR) {
            Xobject xobject3 = xobject2.getArg(0);
            Xobject xobject4 = xobject2.getArg(1);
            if (xobject3.Opcode() == Xcode.VAR) {
                XMPalignedArray xMPalignedArray = this._globalDecl.getXMPalignedArray(xobject3.getSym(), block);
                XMPcoarray xMPcoarray = this._globalDecl.getXMPcoarray(xobject3.getSym(), block);
                if (xMPalignedArray != null && xMPcoarray == null) {
                    xobject2.setArg(0, xMPalignedArray.getAddrId().Ref());
                    xobject2.setArg(1, this.getCalcIndexFuncRef(xMPalignedArray, 0, xobject4));
                } else if (xMPalignedArray != null || xMPcoarray != null) {
                    // empty if block
                }
            }
        }
        return xobject;
    }

    private boolean isAddrCoarray(XobjList xobjList, XMPcoarray xMPcoarray) {
        return xobjList.getArgOrNull(xMPcoarray.getVarDim() - 1) == null;
    }

    private Xobject getCoarrayOffset(Xobject xobject, XMPcoarray xMPcoarray) {
        if (xobject.Opcode() == Xcode.VAR) {
            return Xcons.Int(Xcode.INT_CONSTANT, 0);
        }
        if (xobject.Opcode() == Xcode.ARRAY_REF) {
            xobject = xobject.getArg(1);
        } else if (xobject.Opcode() == Xcode.CO_ARRAY_REF) {
            if (xobject.getArg(0).Opcode() == Xcode.VAR) {
                return Xcons.Int(Xcode.INT_CONSTANT, 0);
            }
            xobject = xobject.getArg(0).getArg(1);
        }
        Xobject xobject2 = null;
        for (int i = 0; i < xMPcoarray.getVarDim(); ++i) {
            Xobject xobject3 = null;
            for (int j = xMPcoarray.getVarDim() - 1; j > i; --j) {
                int n = (int)xMPcoarray.getSizeAt(j);
                xobject3 = xobject3 == null ? Xcons.Int(Xcode.INT_CONSTANT, n) : Xcons.binaryOp(Xcode.MUL_EXPR, Xcons.Int(Xcode.INT_CONSTANT, n), xobject3);
            }
            if (xobject.getArgOrNull(i) == null) break;
            Xobject xobject4 = xobject.getArg(i);
            if (xobject3 != null) {
                xobject4 = Xcons.binaryOp(Xcode.MUL_EXPR, xobject3, xobject4);
            }
            xobject2 = xobject2 == null ? xobject4.copy() : Xcons.binaryOp(Xcode.PLUS_EXPR, xobject2, xobject4);
        }
        return xobject2;
    }

    private Xobject translateCoarrayRef(Xobject xobject, XMPcoarray xMPcoarray) {
        Xobject xobject2 = this.getCoarrayOffset(xobject, xMPcoarray);
        int n = -999;
        if (xobject2.Opcode() == Xcode.INT_CONSTANT) {
            n = xobject2.getInt();
        }
        if (n == 0) {
            Ident ident = this._globalDecl.findVarIdent("_XMP_COARRAY_ADDR_" + xMPcoarray.getName());
            xobject2 = Xcons.PointerRef(ident.Ref());
        } else {
            xobject2 = Xcons.binaryOp(Xcode.PLUS_EXPR, this._globalDecl.findVarIdent("_XMP_COARRAY_ADDR_" + xMPcoarray.getName()).Ref(), xobject2);
            xobject2 = Xcons.PointerRef(xobject2);
        }
        return xobject2;
    }

    public static XobjList normArrayRefList(XobjList xobjList, XMPalignedArray xMPalignedArray) {
        if (xobjList == null) {
            return null;
        }
        XobjList xobjList2 = Xcons.List();
        int n = 0;
        for (Xobject xobject : xobjList) {
            Xobject xobject2 = xMPalignedArray.getAlignNormExprAt(n);
            if (xobject2 != null) {
                xobjList2.add(Xcons.binaryOp(Xcode.PLUS_EXPR, xobject, xobject2));
            } else {
                xobjList2.add(xobject);
            }
            ++n;
        }
        return xobjList2;
    }

    private Xobject rewriteAlignedArrayExpr(XobjList xobjList, XMPalignedArray xMPalignedArray) throws XMPexception {
        int n = 0;
        XobjList xobjList2 = Xcons.List(xMPalignedArray.getAddrId().Ref());
        if (xobjList != null) {
            for (Xobject xobject : xobjList) {
                xobjList2.add(this.getCalcIndexFuncRef(xMPalignedArray, n, xobject));
                ++n;
            }
        }
        return XMPrewriteExpr.createRewriteAlignedArrayFunc(xMPalignedArray, n, xobjList2, false);
    }

    public static Xobject createRewriteAlignedArrayFunc(XMPalignedArray xMPalignedArray, int n, XobjList xobjList, boolean bl) throws XMPexception {
        int n2;
        Object object;
        int n3 = xMPalignedArray.getDim();
        if (n3 < n) {
            throw new XMPexception("wrong array ref");
        }
        XobjList xobjList2 = Xcons.List();
        if (xMPalignedArray.canOptimized()) {
            if (bl) {
                for (int i = 1; i < xobjList.Nargs(); ++i) {
                    xobjList2.add(xobjList.getArg(i));
                }
                return Xcons.arrayRef(XMPrewriteExpr.createNewType(xMPalignedArray), xMPalignedArray.getMultiArrayId().Ref(), xobjList2);
            }
            object = xMPalignedArray.getAlignTemplate();
            XMPnodes xMPnodes = ((XMPtemplate)object).getOntoNodes();
            XobjList xobjList3 = Xcons.List();
            Xtype xtype = xMPalignedArray.getArrayType();
            int n4 = 0;
            while (n4 < n3) {
                int n5 = xMPalignedArray.getAlignMannerAt(n4);
                switch (n5) {
                    case 202: 
                    case 203: 
                    case 204: {
                        XMPshadow xMPshadow;
                        Xobject xobject = xtype.getArraySizeExpr();
                        int n6 = xMPalignedArray.getAlignSubscriptIndexAt(n4);
                        int n7 = ((XMPtemplate)object).getOntoNodesIndexAt(n6).getInt();
                        xobject = Xcons.binaryOp(Xcode.DIV_EXPR, xobject, xMPnodes.getSizeAt(n7));
                        if (xMPalignedArray.hasShadow() && (xMPshadow = xMPalignedArray.getShadowAt(n4)).getHi() != null && xMPshadow.getLo() != null) {
                            Xobject xobject2 = Xcons.binaryOp(Xcode.PLUS_EXPR, xMPshadow.getHi(), xMPshadow.getLo());
                            xobject = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject, xobject2);
                        }
                        xobjList3.add(xobject);
                        break;
                    }
                    case 201: {
                        xobjList3.add(xtype.getArraySizeExpr());
                        break;
                    }
                    case 200: {
                        int n8 = (int)xtype.getArraySize();
                        xobjList3.add(Xcons.IntConstant(n8));
                    }
                }
                ++n4;
                xtype = xtype.getRef();
            }
            for (n4 = 1; n4 < n3; ++n4) {
                Xobject xobject = xobjList3.getArg(n4);
                for (int i = n4 + 1; i < n3; ++i) {
                    xobject = Xcons.binaryOp(Xcode.MUL_EXPR, xobject, xobjList3.getArg(i));
                }
                xobjList2.add(xobject);
            }
        }
        object = null;
        if (n3 == n) {
            object = XMP.getMacroId("_XMP_M_GET_ADDR_E_" + n3, Xtype.Pointer(xMPalignedArray.getType()));
            for (n2 = 0; n2 < n3 - 1; ++n2) {
                if (xMPalignedArray.canOptimized()) {
                    xobjList.add(xobjList2.getArg(n2));
                    continue;
                }
                xobjList.add(xMPalignedArray.getAccIdAt(n2).Ref());
            }
        } else {
            object = XMP.getMacroId("_XMP_M_GET_ADDR_" + n, Xtype.Pointer(xMPalignedArray.getType()));
            for (n2 = 0; n2 < n; ++n2) {
                xobjList.add(xMPalignedArray.getAccIdAt(n2).Ref());
            }
        }
        Xobject xobject = ((Ident)object).Call(xobjList);
        if (n3 == n) {
            return Xcons.PointerRef(xobject);
        }
        return xobject;
    }

    private Xobject getCalcIndexFuncRef(XMPalignedArray xMPalignedArray, int n, Xobject xobject) throws XMPexception {
        switch (xMPalignedArray.getAlignMannerAt(n)) {
            case 200: 
            case 201: {
                return xobject;
            }
            case 202: {
                if (xMPalignedArray.hasShadow()) {
                    XMPshadow xMPshadow = xMPalignedArray.getShadowAt(n);
                    switch (xMPshadow.getType()) {
                        case 400: 
                        case 401: {
                            XobjList xobjList = Xcons.List(xobject, xMPalignedArray.getGtolTemp0IdAt(n).Ref());
                            return XMP.getMacroId("_XMP_M_CALC_INDEX_BLOCK").Call(xobjList);
                        }
                        case 402: {
                            return xobject;
                        }
                    }
                    throw new XMPexception("unknown shadow type");
                }
                XobjList xobjList = Xcons.List(xobject, xMPalignedArray.getGtolTemp0IdAt(n).Ref());
                return XMP.getMacroId("_XMP_M_CALC_INDEX_BLOCK").Call(xobjList);
            }
            case 203: {
                if (xMPalignedArray.hasShadow()) {
                    XMPshadow xMPshadow = xMPalignedArray.getShadowAt(n);
                    switch (xMPshadow.getType()) {
                        case 400: {
                            XobjList xobjList = Xcons.List(xobject, xMPalignedArray.getGtolTemp0IdAt(n).Ref());
                            return XMP.getMacroId("_XMP_M_CALC_INDEX_CYCLIC").Call(xobjList);
                        }
                        case 402: {
                            return xobject;
                        }
                        case 401: {
                            throw new XMPexception("only block distribution allows shadow");
                        }
                    }
                    throw new XMPexception("unknown shadow type");
                }
                XobjList xobjList = Xcons.List(xobject, xMPalignedArray.getGtolTemp0IdAt(n).Ref());
                return XMP.getMacroId("_XMP_M_CALC_INDEX_CYCLIC").Call(xobjList);
            }
            case 204: {
                XMPtemplate xMPtemplate = xMPalignedArray.getAlignTemplate();
                int n2 = xMPalignedArray.getAlignSubscriptIndexAt(n);
                XMPnodes xMPnodes = xMPtemplate.getOntoNodes();
                int n3 = xMPtemplate.getOntoNodesIndexAt(n2).getInt();
                if (xMPalignedArray.hasShadow()) {
                    XMPshadow xMPshadow = xMPalignedArray.getShadowAt(n);
                    switch (xMPshadow.getType()) {
                        case 400: {
                            XobjList xobjList = Xcons.List(xobject, xMPnodes.getSizeAt(n3), xMPtemplate.getWidthAt(n2));
                            return XMP.getMacroId("_XMP_M_CALC_INDEX_BLOCK_CYCLIC").Call(xobjList);
                        }
                        case 402: {
                            return xobject;
                        }
                        case 401: {
                            throw new XMPexception("only block distribution allows shadow");
                        }
                    }
                    throw new XMPexception("unknown shadow type");
                }
                XobjList xobjList = Xcons.List(xobject, xMPnodes.getSizeAt(n3), xMPtemplate.getWidthAt(n2));
                return XMP.getMacroId("_XMP_M_CALC_INDEX_BLOCK_CYCLIC").Call(xobjList);
            }
            case 205: {
                if (xMPalignedArray.hasShadow()) {
                    XMPshadow xMPshadow = xMPalignedArray.getShadowAt(n);
                    switch (xMPshadow.getType()) {
                        case 400: 
                        case 401: {
                            XobjList xobjList = Xcons.List(xobject, xMPalignedArray.getGtolTemp0IdAt(n).Ref());
                            return XMP.getMacroId("_XMP_M_CALC_INDEX_GBLOCK").Call(xobjList);
                        }
                        case 402: {
                            return xobject;
                        }
                    }
                    throw new XMPexception("unknown shadow type");
                }
                XobjList xobjList = Xcons.List(xobject, xMPalignedArray.getGtolTemp0IdAt(n).Ref());
                return XMP.getMacroId("_XMP_M_CALC_INDEX_GBLOCK").Call(xobjList);
            }
        }
        throw new XMPexception("unknown align manner for array '" + xMPalignedArray.getName() + "'");
    }

    private static Xtype createNewType(XMPalignedArray xMPalignedArray) {
        int n;
        XMPtemplate xMPtemplate = xMPalignedArray.getAlignTemplate();
        XMPnodes xMPnodes = xMPtemplate.getOntoNodes();
        Xtype xtype = xMPalignedArray.getArrayType();
        int n2 = xtype.getNumDimensions();
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            n = xMPalignedArray.getAlignMannerAt(n3);
            switch (n) {
                case 202: 
                case 203: 
                case 204: {
                    XMPshadow xMPshadow;
                    long l = xtype.getArraySize();
                    if (l == -1L) {
                        l = xtype.getArraySizeExpr().getLongLow();
                    }
                    int n4 = xMPalignedArray.getAlignSubscriptIndexAt(n3);
                    int n5 = xMPtemplate.getOntoNodesIndexAt(n4).getInt();
                    int n6 = xMPnodes.getSizeAt(n5).getInt();
                    nArray[n3] = (int)(l / (long)n6);
                    if (!xMPalignedArray.hasShadow() || (xMPshadow = xMPalignedArray.getShadowAt(n3)).getHi() == null || xMPshadow.getLo() == null) break;
                    int n7 = n3;
                    nArray[n7] = nArray[n7] + (xMPshadow.getHi().getInt() + xMPshadow.getLo().getInt());
                    break;
                }
                case 200: 
                case 201: {
                    nArray[n3] = (int)xtype.getArraySize();
                    if (nArray[n3] != -1) break;
                    nArray[n3] = (int)xtype.getArraySizeExpr().getLongLow();
                }
            }
            ++n3;
            xtype = xtype.getRef();
        }
        Xtype xtype2 = xMPalignedArray.getType();
        for (n = n2 - 1; n > 0; --n) {
            xtype2 = Xtype.Array(xtype2, nArray[n]);
        }
        return Xtype.Pointer(xtype2);
    }

    public static void rewriteArrayRefInLoop(Xobject xobject, XMPglobalDecl xMPglobalDecl, Block block, BlockList blockList) throws XMPexception {
        if (xobject == null) {
            return;
        }
        HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject);
        topdownXobjectIterator2.init();
        while (!topdownXobjectIterator2.end()) {
            Xobject xobject2 = topdownXobjectIterator2.getXobject();
            if (xobject2 != null && !xobject2.isRewrittedByXmp()) {
                switch (xobject2.Opcode()) {
                    case ARRAY_REF: {
                        Xobject xobject3;
                        Xobject xobject4;
                        Object object;
                        Xobject xobject5 = xobject2.getArg(0);
                        Object object2 = xobject5.getSym();
                        Object object3 = xMPglobalDecl.getXMPalignedArray((String)object2, block);
                        if (object3 == null) break;
                        if (((XMPalignedArray)object3).canOptimized() && hashMap.get(object3) == null) {
                            object = XMPrewriteExpr.createNewType((XMPalignedArray)object3);
                            xobject4 = Xcons.Cast((Xtype)object, ((XMPalignedArray)object3).getAddrId().Ref());
                            xobject3 = blockList.declLocalIdent("_XMP_MULTI_ADDR_" + (String)object2, (Xtype)object, StorageClass.AUTO, xobject4);
                            ((XMPalignedArray)object3).setMultiArrayId((Ident)xobject3);
                            hashMap.put(object3, true);
                        }
                        object = null;
                        xobject4 = XMPrewriteExpr.normArrayRefList((XobjList)xobject2.getArg(1), (XMPalignedArray)object3);
                        object = ((XMPalignedArray)object3).checkRealloc() || ((XMPalignedArray)object3).isLocal() && !((XMPalignedArray)object3).isParameter() || ((XMPalignedArray)object3).isParameter() ? XMPrewriteExpr.rewriteAlignedArrayExprInLoop((XobjList)xobject4, (XMPalignedArray)object3) : Xcons.arrayRef(xobject2.Type(), xobject5, (XobjList)xobject4);
                        ((Xobject)object).setIsRewrittedByXmp(true);
                        topdownXobjectIterator2.setXobject((Xobject)object);
                        break;
                    }
                    case POINTER_REF: {
                        Xobject xobject3;
                        Object object;
                        Xobject xobject5 = xobject2.getArg(0);
                        if (xobject5.Opcode() != Xcode.PLUS_EXPR) break;
                        Object object2 = xobject5.getArg(0);
                        Object object3 = xobject5.getArg(1);
                        if (((Xobject)object2).Opcode() != Xcode.VAR || (object = xMPglobalDecl.getXMPalignedArray(((Xobject)object2).getSym(), block)) == null) break;
                        Xobject xobject4 = XMPrewriteExpr.normArrayRefList(Xcons.List(new Xobject[]{object3}), (XMPalignedArray)object);
                        if (((XMPalignedArray)object).checkRealloc() || ((XMPalignedArray)object).isLocal() && !((XMPalignedArray)object).isParameter() || ((XMPalignedArray)object).isParameter()) {
                            xobject3 = XMPrewriteExpr.rewriteAlignedArrayExprInLoop((XobjList)xobject4, (XMPalignedArray)object);
                            xobject3.setIsRewrittedByXmp(true);
                            topdownXobjectIterator2.setXobject(xobject3);
                            break;
                        }
                        xobject5.setArg(1, ((XobjList)xobject4).getArg(0));
                        break;
                    }
                }
            }
            topdownXobjectIterator2.next();
        }
    }

    private static Xobject rewriteAlignedArrayExprInLoop(XobjList xobjList, XMPalignedArray xMPalignedArray) throws XMPexception {
        int n = 0;
        XobjList xobjList2 = Xcons.List(xMPalignedArray.getAddrId().Ref());
        if (xobjList != null) {
            for (Xobject xobject : xobjList) {
                xobjList2.add(xobject);
                ++n;
            }
        }
        return XMPrewriteExpr.createRewriteAlignedArrayFunc(xMPalignedArray, n, xobjList2, true);
    }

    public static void rewriteLoopIndexInLoop(Xobject xobject, String string, XMPtemplate xMPtemplate, int n, XMPglobalDecl xMPglobalDecl, Block block) throws XMPexception {
        if (xobject == null) {
            return;
        }
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject);
        topdownXobjectIterator2.init();
        while (!topdownXobjectIterator2.end()) {
            Xobject xobject2 = topdownXobjectIterator2.getXobject();
            if (xobject2 != null) {
                Object object;
                Object object2;
                if (xobject2.Opcode() == Xcode.ARRAY_REF) {
                    object2 = xobject2.getArg(0).getSym();
                    if (((String)object2).startsWith("_XMP_MULTI_ADDR_")) {
                        object2 = ((String)object2).substring("_XMP_MULTI_ADDR_".length());
                    }
                    if ((object = xMPglobalDecl.getXMPalignedArray((String)object2, block)) == null) {
                        XMPrewriteExpr.rewriteLoopIndexVar(xMPtemplate, n, string, xobject2, xMPglobalDecl);
                    } else {
                        xobject2.setArg(1, XMPrewriteExpr.rewriteLoopIndexArrayRefList(xMPtemplate, n, (XMPalignedArray)object, string, (XobjList)xobject2.getArg(1), xMPglobalDecl));
                    }
                } else if (!xobject2.isRewrittedByXmp()) {
                    switch (xobject2.Opcode()) {
                        case VAR: {
                            if (!string.equals(xobject2.getSym())) break;
                            topdownXobjectIterator2.setXobject(XMPrewriteExpr.calcLtoG(xMPtemplate, n, xobject2, xMPglobalDecl));
                            break;
                        }
                        case POINTER_REF: {
                            object2 = null;
                            object = Xcons.List();
                            Xobject xobject3 = xobject2;
                            while (xobject3.Opcode() == Xcode.POINTER_REF) {
                                if ((xobject3 = xobject3.getArg(0)).Opcode() == Xcode.PLUS_EXPR) {
                                    ((XobjList)object).cons(xobject3.getArg(1));
                                    xobject3 = xobject3.getArg(0);
                                }
                                if (xobject3.Opcode() != Xcode.VAR) continue;
                                object2 = xMPglobalDecl.getXMPalignedArray(xobject3.getSym(), block);
                                break;
                            }
                            if (object2 == null) break;
                            Xobject xobject4 = Xcons.arrayRef(((XMPalignedArray)object2).getType(), ((XMPalignedArray)object2).getAddrId().Ref(), XMPrewriteExpr.rewriteLoopIndexArrayRefList(xMPtemplate, n, (XMPalignedArray)object2, string, (XobjList)object, xMPglobalDecl));
                            topdownXobjectIterator2.setXobject(xobject4);
                            break;
                        }
                    }
                }
            }
            topdownXobjectIterator2.next();
        }
    }

    private static void rewriteLoopIndexVar(XMPtemplate xMPtemplate, int n, String string, Xobject xobject, XMPglobalDecl xMPglobalDecl) throws XMPexception {
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject);
        topdownXobjectIterator2.init();
        while (!topdownXobjectIterator2.end()) {
            Xobject xobject2 = topdownXobjectIterator2.getXobject();
            if (xobject2 != null && !xobject2.isRewrittedByXmp()) {
                switch (xobject2.Opcode()) {
                    case VAR: {
                        if (!string.equals(xobject2.getString())) break;
                        Xobject xobject3 = XMPrewriteExpr.calcLtoG(xMPtemplate, n, xobject2, xMPglobalDecl);
                        topdownXobjectIterator2.setXobject(xobject3);
                        break;
                    }
                }
            }
            topdownXobjectIterator2.next();
        }
    }

    private static XobjList rewriteLoopIndexArrayRefList(XMPtemplate xMPtemplate, int n, XMPalignedArray xMPalignedArray, String string, XobjList xobjList, XMPglobalDecl xMPglobalDecl) throws XMPexception {
        if (xobjList == null) {
            return null;
        }
        XobjList xobjList2 = Xcons.List();
        int n2 = 0;
        for (Xobject xobject : xobjList) {
            xobjList2.add(XMPrewriteExpr.rewriteLoopIndexArrayRef(xMPtemplate, n, xMPalignedArray, n2, string, xobject, xMPglobalDecl));
            ++n2;
            xobject.setIsRewrittedByXmp(true);
        }
        return xobjList2;
    }

    private static Xobject rewriteLoopIndexArrayRef(XMPtemplate xMPtemplate, int n, XMPalignedArray xMPalignedArray, int n2, String string, Xobject xobject, XMPglobalDecl xMPglobalDecl) throws XMPexception {
        if (xobject.Opcode() == Xcode.VAR && (xMPalignedArray.getShadowAt(n2).getType() != 402 || string.equals(xobject.getString()))) {
            return XMPrewriteExpr.calcShadow(xMPtemplate, n, xMPalignedArray, n2, xobject, xMPglobalDecl);
        }
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject);
        topdownXobjectIterator2.init();
        while (!topdownXobjectIterator2.end()) {
            Xobject xobject2 = topdownXobjectIterator2.getXobject();
            if (xobject2 != null && !xobject2.isRewrittedByXmp()) {
                switch (xobject2.Opcode()) {
                    case VAR: {
                        if (!string.equals(xobject2.getString())) break;
                        topdownXobjectIterator2.setXobject(XMPrewriteExpr.calcShadow(xMPtemplate, n, xMPalignedArray, n2, xobject2, xMPglobalDecl));
                        break;
                    }
                }
            }
            topdownXobjectIterator2.next();
        }
        return xobject;
    }

    private static Xobject calcShadow(XMPtemplate xMPtemplate, int n, XMPalignedArray xMPalignedArray, int n2, Xobject xobject, XMPglobalDecl xMPglobalDecl) throws XMPexception {
        xobject.setIsRewrittedByXmp(true);
        if (xMPalignedArray.getAlignSubscriptIndexAt(n2) != null && n != xMPalignedArray.getAlignSubscriptIndexAt(n2)) {
            return xobject;
        }
        XMPshadow xMPshadow = xMPalignedArray.getShadowAt(n2);
        switch (xMPshadow.getType()) {
            case 400: {
                return xobject;
            }
            case 401: {
                return Xcons.binaryOp(Xcode.PLUS_EXPR, xobject, xMPshadow.getLo());
            }
            case 402: {
                return XMPrewriteExpr.calcLtoG(xMPtemplate, n, xobject, xMPglobalDecl);
            }
        }
        throw new XMPexception("unknown shadow type");
    }

    public static Xobject calcLtoG(XMPtemplate xMPtemplate, int n, Xobject xobject, XMPglobalDecl xMPglobalDecl) throws XMPexception {
        xobject.setIsRewrittedByXmp(true);
        if (!xMPtemplate.isDistributed()) {
            return xobject;
        }
        XMPnodes xMPnodes = xMPtemplate.getOntoNodes();
        int n2 = -1;
        if (xMPtemplate.getDistMannerAt(n) != 100) {
            n2 = xMPtemplate.getOntoNodesIndexAt(n).getInt();
        }
        XobjList xobjList = null;
        if (!xMPtemplate.isFixed()) {
            xobjList = Xcons.List(xobject, xMPtemplate.getDescId().Ref(), Xcons.IntConstant(n), Xcons.IntConstant(0));
            Ident ident = xMPglobalDecl.declExternFunc("xmpc_ltog", Xtype.intType);
            return ident.Call(xobjList);
        }
        switch (xMPtemplate.getDistMannerAt(n)) {
            case 100: {
                return xobject;
            }
            case 101: {
                xobjList = Xcons.List(xobject, xMPtemplate.getLowerAt(n), xMPtemplate.getSizeAt(n), xMPnodes.getSizeAt(n2), xMPnodes.getRankAt(n2));
                break;
            }
            case 102: {
                xobjList = Xcons.List(xobject, xMPtemplate.getLowerAt(n), xMPnodes.getSizeAt(n2), xMPnodes.getRankAt(n2));
                break;
            }
            case 103: {
                xobjList = Xcons.List(xobject, xMPtemplate.getWidthAt(n), xMPtemplate.getLowerAt(n), xMPnodes.getSizeAt(n2), xMPnodes.getRankAt(n2));
                break;
            }
            case 104: {
                xobjList = Xcons.List(xobject, xMPtemplate.getGtolTemp0IdAt(n).Ref());
                break;
            }
            default: {
                throw new XMPexception("unknown distribution manner");
            }
        }
        return XMP.getMacroId("_XMP_M_LTOG_TEMPLATE_" + xMPtemplate.getDistMannerStringAt(n), Xtype.intType).Call(xobjList);
    }

    private void rewriteOMPpragma(FunctionBlock functionBlock, XMPsymbolTable xMPsymbolTable) {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(functionBlock);
        topdownBlockIterator2.init();
        while (!topdownBlockIterator2.end()) {
            Block block = topdownBlockIterator2.getBlock();
            if (block.Opcode() == Xcode.OMP_PRAGMA) {
                BlockList blockList;
                PragmaBlock pragmaBlock = (PragmaBlock)block;
                Xobject xobject = pragmaBlock.getClauses();
                if (xobject != null) {
                    this.rewriteOmpClauses(xobject, (PragmaBlock)block, functionBlock, xMPsymbolTable);
                }
                if ((pragmaBlock.getPragma().equals("PARALLEL_FOR") || pragmaBlock.getPragma().equals("FOR")) && (blockList = pragmaBlock.getBody()).getDecls() != null) {
                    BlockList blockList2 = Bcons.emptyBody(blockList.getIdentList().copy(), blockList.getDecls().copy());
                    blockList.setIdentList(null);
                    blockList.setDecls(null);
                    blockList2.add(Bcons.PRAGMA(Xcode.OMP_PRAGMA, pragmaBlock.getPragma(), pragmaBlock.getClauses(), blockList));
                    pragmaBlock.replace(Bcons.COMPOUND(blockList2));
                }
            }
            topdownBlockIterator2.next();
        }
    }

    private void rewriteOmpClauses(Xobject xobject, PragmaBlock pragmaBlock, Block block, XMPsymbolTable xMPsymbolTable) {
        bottomupXobjectIterator bottomupXobjectIterator2 = new bottomupXobjectIterator(xobject);
        bottomupXobjectIterator2.init();
        while (!bottomupXobjectIterator2.end()) {
            Xobject xobject2 = bottomupXobjectIterator2.getXobject();
            if (xobject2 != null) {
                if (xobject2.Opcode() == Xcode.VAR) {
                    try {
                        bottomupXobjectIterator2.setXobject(this.rewriteArrayAddr(xobject2, pragmaBlock));
                    }
                    catch (XMPexception xMPexception) {
                        XMP.error(xobject2.getLineNo(), xMPexception.getMessage());
                    }
                } else if (xobject2.Opcode() == Xcode.LIST && xobject2.left() != null && xobject2.left().Opcode() == Xcode.STRING && xobject2.left().getString().equals("DATA_PRIVATE") && pragmaBlock.getPragma().equals("FOR")) {
                    XobjList xobjList = (XobjList)xobject2.right();
                    Xobject xobject3 = null;
                    BasicBlockIterator basicBlockIterator = new BasicBlockIterator(pragmaBlock.getBody());
                    for (Block block2 = pragmaBlock.getBody().getHead(); block2 != null; block2 = block2.getNext()) {
                        if (block2.Opcode() != Xcode.FOR_STATEMENT) continue;
                        xobject3 = ((ForBlock)((Object)block2)).getInductionVar();
                    }
                    if (xobject3 != null) {
                        boolean bl = false;
                        for (Xobject xobject4 : xobjList) {
                            if (!xobject4.getName().equals(xobject3.getName())) continue;
                            bl = true;
                        }
                        if (!bl) {
                            xobjList.add(xobject3);
                        }
                    }
                }
            }
            bottomupXobjectIterator2.next();
        }
    }

    private void rewriteACCpragma(FunctionBlock functionBlock, XMPsymbolTable xMPsymbolTable) {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(functionBlock);
        topdownBlockIterator2.init();
        while (!topdownBlockIterator2.end()) {
            Block block = topdownBlockIterator2.getBlock();
            if (block.Opcode() == Xcode.ACC_PRAGMA) {
                BlockList blockList;
                PragmaBlock pragmaBlock = (PragmaBlock)block;
                Xobject xobject = pragmaBlock.getClauses();
                if (xobject != null) {
                    blockList = Bcons.emptyBody();
                    this.rewriteACCClauses(xobject, pragmaBlock, functionBlock, xMPsymbolTable, blockList);
                    if (!blockList.isEmpty()) {
                        topdownBlockIterator2.setBlock(Bcons.COMPOUND(blockList));
                        blockList.add(block);
                    }
                }
                if (pragmaBlock.getPragma().equals("PARALLEL_LOOP") && (blockList = pragmaBlock.getBody()).getDecls() != null) {
                    BlockList blockList2 = Bcons.emptyBody(blockList.getIdentList().copy(), blockList.getDecls().copy());
                    blockList.setIdentList(null);
                    blockList.setDecls(null);
                    blockList2.add(Bcons.PRAGMA(Xcode.ACC_PRAGMA, pragmaBlock.getPragma(), pragmaBlock.getClauses(), blockList));
                    pragmaBlock.replace(Bcons.COMPOUND(blockList2));
                }
            }
            topdownBlockIterator2.next();
        }
    }

    /*
     * Exception decompiling
     */
    private void rewriteACCClauses(Xobject var1_1, PragmaBlock var2_2, Block var3_3, XMPsymbolTable var4_4, BlockList var5_5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Xobject rewriteACCArrayAddr(Xobject xobject, Block block, BlockList blockList) throws XMPexception {
        XMPalignedArray xMPalignedArray = this._globalDecl.getXMPalignedArray(xobject.getSym(), block);
        XMPcoarray xMPcoarray = this._globalDecl.getXMPcoarray(xobject.getSym(), block);
        if (xMPalignedArray == null && xMPcoarray == null) {
            return xobject;
        }
        if (xMPalignedArray != null && xMPcoarray == null) {
            if (xMPalignedArray.checkRealloc() || xMPalignedArray.isLocal() && !xMPalignedArray.isParameter() || xMPalignedArray.isParameter()) {
                Xobject xobject2 = xMPalignedArray.getAddrId().Ref();
                Ident ident = xMPalignedArray.getDescId();
                String string = "_ACC_size_" + xobject.getSym();
                Ident ident2 = blockList.declLocalIdent(string, Xtype.unsignedlonglongType);
                Block block2 = this._globalDecl.createFuncCallBlock("_XMP_get_array_total_elmts", Xcons.List(ident.Ref()));
                blockList.insert(Xcons.Set(ident2.Ref(), block2.toXobject()));
                XobjList xobjList = Xcons.List(xobject2, Xcons.List(Xcons.IntConstant(0), ident2.Ref()));
                xobjList.setIsRewrittedByXmp(true);
                return xobjList;
            }
            return xobject;
        }
        if (xMPalignedArray == null && xMPcoarray != null) {
            Xobject xobject3 = this._globalDecl.findVarIdent("_XMP_COARRAY_ADDR_" + xobject.getSym()).Ref();
            Ident ident = xMPcoarray.getDescId();
            String string = "_ACC_size_" + xobject.getSym();
            Ident ident3 = blockList.declLocalIdent(string, Xtype.unsignedlonglongType);
            Block block3 = this._globalDecl.createFuncCallBlock("_XMP_coarray_get_total_elmts", Xcons.List(ident.Ref()));
            blockList.insert(Xcons.Set(ident3.Ref(), block3.toXobject()));
            XobjList xobjList = Xcons.List(xobject3, Xcons.List(Xcons.IntConstant(0), ident3.Ref()));
            xobjList.setIsRewrittedByXmp(true);
            return xobjList;
        }
        return xobject;
    }

    private Xobject rewriteACCArrayRef(Xobject xobject, Block block, BlockList blockList) throws XMPexception {
        Xobject xobject2 = xobject.getArg(0);
        XMPalignedArray xMPalignedArray = this._globalDecl.getXMPalignedArray(xobject2.getSym(), block);
        XMPcoarray xMPcoarray = this._globalDecl.getXMPcoarray(xobject2.getSym(), block);
        if (xMPalignedArray != null && xMPcoarray == null) {
            Xobject xobject3 = xMPalignedArray.getAddrId().Ref();
            xobject.setArg(0, xobject3);
        } else if (xMPalignedArray == null && xMPcoarray != null) {
            Xobject xobject4 = this._globalDecl.findVarIdent("_XMP_COARRAY_ADDR_" + xobject2.getSym()).Ref();
            xobject.setArg(0, xobject4);
        }
        return xobject;
    }

    void rewriteACCPragma(XobjectDef xobjectDef) {
        Xobject xobject = xobjectDef.getDef();
        Xobject xobject2 = xobject.getArg(0);
        if (!xobject2.getString().equals("DECLARE")) {
            return;
        }
        XobjList xobjList = (XobjList)xobject.getArg(1);
        for (XobjArgs xobjArgs = xobjList.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            Xobject xobject3 = xobjArgs.getArg();
            Xobject xobject4 = xobject3.getArg(0);
            if (!xobject4.getString().equals("CREATE")) {
                XMP.fatal("'" + xobject4.getString() + "' clause for coarray is not implemented yet");
            }
            XobjList xobjList2 = (XobjList)xobject3.getArg(1);
            for (XobjArgs xobjArgs2 = xobjList2.getArgs(); xobjArgs2 != null; xobjArgs2 = xobjArgs2.nextArgs()) {
                Xobject xobject5 = xobjArgs2.getArg();
                String string = xobject5.getName();
                XMPcoarray xMPcoarray = this._globalDecl.getXMPcoarray(string);
                if (xMPcoarray == null) continue;
                if (xMPcoarray.getVarId().getStorageClass() != StorageClass.EXTERN) {
                    Xtype xtype = xMPcoarray.getElmtType();
                    Ident ident = this._globalDecl.declStaticIdent("_XMP_COARRAY_ADDR_DEV_" + string, Xtype.Pointer(xtype));
                    String string2 = "_XMP_coarray_malloc_acc";
                    XobjList xobjList3 = Xcons.List(xMPcoarray.getDescId().getAddr(), ident.getAddr());
                    this._globalDecl.addGlobalInitFuncCall(string2, xobjList3);
                    Ident ident2 = this._globalDecl.declExternFunc("_XMP_coarray_get_total_elmts", Xtype.intType);
                    Xobject xobject6 = ident2.Call(Xcons.List(xMPcoarray.getDescId().Ref()));
                    Ident ident3 = this._globalDecl.findVarIdent("_XMP_COARRAY_ADDR_" + string);
                    string2 = "acc_map_data";
                    xobjList3 = Xcons.List(ident3.Ref(), ident.Ref(), Xcons.binaryOp(Xcode.MUL_EXPR, Xcons.SizeOf(xtype), xobject6));
                    this._globalDecl.addGlobalInitFuncCall(string2, xobjList3);
                }
                xobjList2.removeArgs(xobjArgs2);
            }
            if (!xobjList2.isEmpty()) continue;
            xobjList.removeArgs(xobjArgs);
        }
        if (xobjList.isEmpty()) {
            xobjectDef.setDef(Xcons.List(Xcode.TEXT, Xcons.String("/* OpenACC declare directive is removed by XcalableACC */")));
        }
    }

    private boolean isUseDevice(String string, Block block) {
        Ident ident = block.findVarIdent(string);
        if (ident == null) {
            return false;
        }
        for (Block block2 = block; block2 != null; block2 = block2.getParentBlock()) {
            PragmaBlock pragmaBlock;
            if (block2.Opcode() != Xcode.ACC_PRAGMA || !(pragmaBlock = (PragmaBlock)block2).getPragma().equals("HOST_DATA")) continue;
            for (Xobject xobject : (XobjList)pragmaBlock.getClauses()) {
                if (!xobject.getArg(0).getString().equals("USE_DEVICE")) continue;
                for (Xobject xobject2 : (XobjList)xobject.getArg(1)) {
                    if (!xobject2.getSym().equals(string) || block2.findVarIdent(string) != ident) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void rewriteVarDecl(Xobject xobject, boolean bl) {
        assert (xobject.Opcode() == Xcode.VAR_DECL);
        String string = xobject.getArg(0).getName();
        Ident ident = this._globalDecl.findVarIdent(string);
        if (ident.isCoarray()) {
            XobjList xobjList = (XobjList)ident.getCodimensions();
            if (xobjList.getTail() == null || xobjList.getTail().getInt() != -1) {
                xobjList.add(Xcons.IntConstant(-1));
            }
            try {
                XMPcoarray.translateCoarray_core(ident, string, xobjList, this._globalDecl, bl);
            }
            catch (XMPexception xMPexception) {
                XMP.error(xobject.getLineNo(), xMPexception.getMessage());
            }
        }
    }

    private void addBarrier(FunctionBlock functionBlock) {
        Object object;
        PropObject propObject;
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(functionBlock);
        topdownBlockIterator2.init();
        while (!topdownBlockIterator2.end()) {
            propObject = topdownBlockIterator2.getBlock();
            if (((Block)propObject).Opcode() == Xcode.RETURN_STATEMENT) {
                object = this._globalDecl.declExternFunc("_XMP_barrier_EXEC", Xtype.Function(Xtype.voidType));
                ((Block)propObject).insert(((Ident)object).Call(Xcons.List()));
            }
            topdownBlockIterator2.next();
        }
        propObject = this._globalDecl.declExternFunc("_XMP_barrier_EXEC", Xtype.Function(Xtype.voidType));
        object = functionBlock.getBody().getHead().getBody();
        ((BlockList)object).add(((Ident)propObject).Call(Xcons.List()));
    }
}

