/*
 * Decompiled with CFR 0.152.
 */
package exc.xcalablemp;

import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectDefVisitor;
import exc.object.Xtype;
import exc.xcalablemp.XMP;
import exc.xcalablemp.XMPalignedArray;
import exc.xcalablemp.XMPcoarray;
import exc.xcalablemp.XMPexception;
import exc.xcalablemp.XMPglobalDecl;

public class XMPrealloc
implements XobjectDefVisitor {
    private XMPglobalDecl _globalDecl;

    public XMPrealloc(XMPglobalDecl xMPglobalDecl) {
        this._globalDecl = xMPglobalDecl;
    }

    @Override
    public void doDef(XobjectDef xobjectDef) {
        try {
            this.alignArrayRealloc(xobjectDef);
            this.originalCoarrayDelete(xobjectDef);
        }
        catch (XMPexception xMPexception) {
            XMP.error(xobjectDef.getLineNo(), xMPexception.getMessage());
        }
    }

    private void originalCoarrayDelete(XobjectDef xobjectDef) throws XMPexception {
        String string;
        XMPcoarray xMPcoarray;
        if (xobjectDef.isVarDecl() && (xMPcoarray = this._globalDecl.getXMPcoarray(string = xobjectDef.getName())) != null) {
            xobjectDef.setDef(Xcons.List(Xcode.TEXT, Xcons.String("/* array '" + string + "' is removed by XcalableMP coarray directive */")));
        }
    }

    private void alignArrayRealloc(XobjectDef xobjectDef) throws XMPexception {
        if (!xobjectDef.isVarDecl()) {
            return;
        }
        String string = xobjectDef.getName();
        XMPalignedArray xMPalignedArray = this._globalDecl.getXMPalignedArray(string);
        if (xMPalignedArray == null) {
            return;
        }
        if (xMPalignedArray.isPointer()) {
            return;
        }
        if (xMPalignedArray.realloc()) {
            XobjList xobjList = Xcons.List(xMPalignedArray.getAddrIdVoidAddr(), xMPalignedArray.getDescId().Ref());
            if (xMPalignedArray.getAddrId().getStorageClass() != StorageClass.EXTERN) {
                xobjList.add(Xcons.IntConstant(1));
            }
            for (int i = xMPalignedArray.getDim() - 1; i >= 0; --i) {
                xobjList.add(Xcons.Cast(Xtype.Pointer(Xtype.unsignedlonglongType), xMPalignedArray.getAccIdAt(i).getAddr()));
            }
            if (xMPalignedArray.getAddrId().getStorageClass() == StorageClass.EXTERN) {
                this._globalDecl.addGlobalInitFuncCall("_XMP_alloc_array_EXTERN", xobjList);
            } else {
                this._globalDecl.addGlobalInitFuncCall("_XMP_alloc_array", xobjList);
            }
            xobjectDef.setDef(Xcons.List(Xcode.TEXT, Xcons.String("/* array '" + string + "' is removed by XMP align directive */")));
        } else {
            Xobject xobject = xMPalignedArray.getAddrIdVoidAddr();
            Xobject xobject2 = xMPalignedArray.getArrayId().Ref();
            Xobject xobject3 = xMPalignedArray.getDescId().Ref();
            XobjList xobjList = Xcons.List(xobject, xobject2, xobject3);
            for (int i = xMPalignedArray.getDim() - 1; i >= 0; --i) {
                xobjList.add(Xcons.Cast(Xtype.Pointer(Xtype.unsignedlonglongType), xMPalignedArray.getAccIdAt(i).getAddr()));
            }
            this._globalDecl.addGlobalInitFuncCall("_XMP_init_array_addr", xobjList);
        }
    }
}

