/*
 * Decompiled with CFR 0.152.
 */
package exc.xcalablemp;

import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockIterator;
import exc.block.BlockList;
import exc.block.FunctionBlock;
import exc.block.bottomupBlockIterator;
import exc.block.topdownBlockIterator;
import exc.object.Ident;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.xcalablemp.XMPexception;
import exc.xcalablemp.XMPglobalDecl;
import exc.xcalablemp.XMPsymbolTable;

public class XMPlocalDecl {
    private static final String XMP_SYMBOL_TABLE = "XCALABLEMP_PROP_LOCAL_XMP_SYMBOL_TABLE";
    private static final String OBJECT_ID_LIST = "XCALABLEMP_PROP_LOCAL_OBJECT_ID_LIST";
    private static final String CONSTRUCTOR = "XCALABLEMP_PROP_LOCAL_CONSTRUCTOR";
    private static final String ALLOC = "XCALABLEMP_PROP_LOCAL_ALLOC";
    private static final String DESTRUCTOR = "XCALABLEMP_PROP_LOCAL_DESTRUCTOR";

    public static void checkObjectNameCollision(String string, BlockList blockList, XMPsymbolTable xMPsymbolTable) throws XMPexception {
        if (blockList.findLocalIdent(string) != null) {
            throw new XMPexception("'" + string + "' is already declared");
        }
        if (xMPsymbolTable.getXMPobject(string) != null) {
            throw new XMPexception("'" + string + "' is already declared");
        }
        if (blockList.findLocalIdent("_XMP_DESC_" + string) != null) {
            throw new XMPexception("cannot declare template desciptor, '_XMP_DESC_" + string + "' is already declared");
        }
    }

    public static FunctionBlock findParentFunctionBlock(Block block) {
        if (block == null) {
            return null;
        }
        for (Block block2 = block; block2 != null; block2 = block2.getParentBlock()) {
            if (block2.Opcode() != Xcode.FUNCTION_DEFINITION) continue;
            return (FunctionBlock)block2;
        }
        return null;
    }

    public static Ident findLocalIdent(Block block, String string) {
        if (block == null) {
            return null;
        }
        for (Block block2 = block; block2 != null; block2 = block2.getParentBlock()) {
            Ident ident = block2.findVarIdent(string);
            if (ident == null) continue;
            return ident;
        }
        return null;
    }

    public static void removeLocalIdent(Block block, String string) {
        if (block == null) {
            return;
        }
        for (Block block2 = block; block2 != null; block2 = block2.getParentBlock()) {
            if (!block2.removeVarIdent(string).booleanValue()) continue;
            return;
        }
    }

    public static XMPsymbolTable getXMPsymbolTable(Block block) {
        FunctionBlock functionBlock = XMPlocalDecl.findParentFunctionBlock(block);
        if (functionBlock == null) {
            return null;
        }
        return (XMPsymbolTable)functionBlock.getProp(XMP_SYMBOL_TABLE);
    }

    public static XMPsymbolTable declXMPsymbolTable(Block block) {
        FunctionBlock functionBlock = XMPlocalDecl.findParentFunctionBlock(block);
        if (functionBlock == null) {
            return null;
        }
        XMPsymbolTable xMPsymbolTable = (XMPsymbolTable)functionBlock.getProp(XMP_SYMBOL_TABLE);
        if (xMPsymbolTable == null) {
            xMPsymbolTable = new XMPsymbolTable();
            functionBlock.setProp(XMP_SYMBOL_TABLE, xMPsymbolTable);
        }
        return xMPsymbolTable;
    }

    public static Ident addObjectId(String string, Xtype xtype, Block block) {
        FunctionBlock functionBlock = XMPlocalDecl.findParentFunctionBlock(block);
        XobjList xobjList = (XobjList)functionBlock.getProp(OBJECT_ID_LIST);
        if (xobjList == null) {
            xobjList = Xcons.List(Xcode.LIST);
            functionBlock.setProp(OBJECT_ID_LIST, xobjList);
        }
        Ident ident = Ident.Local(string, xtype);
        xobjList.add(ident);
        return ident;
    }

    public static Ident addObjectId(String string, Block block) {
        return XMPlocalDecl.addObjectId(string, Xtype.voidPtrType, block);
    }

    public static void addConstructorCall(String string, Xobject xobject, XMPglobalDecl xMPglobalDecl, Block block) {
        FunctionBlock functionBlock = XMPlocalDecl.findParentFunctionBlock(block);
        XobjList xobjList = (XobjList)functionBlock.getProp(CONSTRUCTOR);
        if (xobjList == null) {
            xobjList = Xcons.List(Xcode.LIST);
            functionBlock.setProp(CONSTRUCTOR, xobjList);
        }
        Ident ident = xMPglobalDecl.declExternFunc(string);
        xobjList.add(Xcons.List(Xcode.EXPR_STATEMENT, ident.Call(xobject)));
    }

    public static void addAllocCall(String string, Xobject xobject, XMPglobalDecl xMPglobalDecl, Block block) {
        FunctionBlock functionBlock = XMPlocalDecl.findParentFunctionBlock(block);
        XobjList xobjList = (XobjList)functionBlock.getProp(ALLOC);
        if (xobjList == null) {
            xobjList = Xcons.List(Xcode.LIST);
            functionBlock.setProp(ALLOC, xobjList);
        }
        Ident ident = xMPglobalDecl.declExternFunc(string);
        xobjList.add(Xcons.List(Xcode.EXPR_STATEMENT, ident.Call(xobject)));
    }

    public static void insertDestructorCall(String string, Xobject xobject, XMPglobalDecl xMPglobalDecl, Block block) {
        FunctionBlock functionBlock = XMPlocalDecl.findParentFunctionBlock(block);
        XobjList xobjList = (XobjList)functionBlock.getProp(DESTRUCTOR);
        if (xobjList == null) {
            xobjList = Xcons.List(Xcode.LIST);
            functionBlock.setProp(DESTRUCTOR, xobjList);
        }
        Ident ident = xMPglobalDecl.declExternFunc(string);
        xobjList.cons(Xcons.List(Xcode.EXPR_STATEMENT, ident.Call(xobject)));
    }

    public static void setupObjectId(FunctionBlock functionBlock) {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(functionBlock);
        topdownBlockIterator2.init();
        while (!topdownBlockIterator2.end()) {
            Block block = topdownBlockIterator2.getBlock();
            BlockList blockList = block.getBody();
            XobjList xobjList = (XobjList)block.getProp(OBJECT_ID_LIST);
            if (xobjList != null) {
                for (XobjArgs xobjArgs = xobjList.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
                    Ident ident = (Ident)xobjArgs.getArg();
                    blockList.addIdent(ident);
                }
            }
            topdownBlockIterator2.next();
        }
    }

    public static void setupConstructor(FunctionBlock functionBlock) {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(functionBlock);
        topdownBlockIterator2.init();
        while (!topdownBlockIterator2.end()) {
            XobjList xobjList;
            Block block = topdownBlockIterator2.getBlock();
            BlockList blockList = block.getBody();
            XobjList xobjList2 = (XobjList)block.getProp(ALLOC);
            if (xobjList2 != null) {
                blockList.insert(Bcons.buildBlock(Xcons.List(Xcode.COMPOUND_STATEMENT, new Xobject[]{null, null, xobjList2})));
            }
            if ((xobjList = (XobjList)block.getProp(CONSTRUCTOR)) != null) {
                blockList.insert(Bcons.buildBlock(Xcons.List(Xcode.COMPOUND_STATEMENT, new Xobject[]{null, null, xobjList})));
            }
            topdownBlockIterator2.next();
        }
    }

    public static void setupDestructor(FunctionBlock functionBlock) {
        bottomupBlockIterator bottomupBlockIterator2 = new bottomupBlockIterator(functionBlock);
        bottomupBlockIterator2.init();
        while (!bottomupBlockIterator2.end()) {
            Block block = bottomupBlockIterator2.getBlock();
            BlockList blockList = block.getBody();
            XobjList xobjList = (XobjList)block.getProp(DESTRUCTOR);
            if (xobjList != null) {
                topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(block);
                ((BlockIterator)topdownBlockIterator2).init();
                while (!((BlockIterator)topdownBlockIterator2).end()) {
                    Block block2 = topdownBlockIterator2.getBlock();
                    if (block2.Opcode() == Xcode.RETURN_STATEMENT) {
                        block2.insert(Bcons.buildBlock(Xcons.List(Xcode.COMPOUND_STATEMENT, new Xobject[]{null, null, xobjList})));
                    }
                    ((BlockIterator)topdownBlockIterator2).next();
                }
                blockList.add(Bcons.buildBlock(Xcons.List(Xcode.COMPOUND_STATEMENT, new Xobject[]{null, null, xobjList})));
            }
            bottomupBlockIterator2.next();
        }
    }

    public static XMPsymbolTable getXMPsymbolTable2(Block block) {
        if (block == null) {
            return null;
        }
        return (XMPsymbolTable)block.getProp(XMP_SYMBOL_TABLE);
    }

    public static XMPsymbolTable declXMPsymbolTable2(Block block) {
        if (block == null) {
            return null;
        }
        XMPsymbolTable xMPsymbolTable = (XMPsymbolTable)block.getProp(XMP_SYMBOL_TABLE);
        if (xMPsymbolTable == null) {
            xMPsymbolTable = new XMPsymbolTable();
            block.setProp(XMP_SYMBOL_TABLE, xMPsymbolTable);
        }
        return xMPsymbolTable;
    }

    public static Ident addObjectId2(String string, Xtype xtype, Block block) {
        XobjList xobjList = (XobjList)block.getProp(OBJECT_ID_LIST);
        if (xobjList == null) {
            xobjList = Xcons.List(Xcode.LIST);
            block.setProp(OBJECT_ID_LIST, xobjList);
        }
        Ident ident = Ident.Local(string, xtype);
        xobjList.add(ident);
        return ident;
    }

    public static Ident addObjectId2(String string, Block block) {
        return XMPlocalDecl.addObjectId2(string, Xtype.voidPtrType, block);
    }

    public static void addConstructorCall2(String string, Xobject xobject, XMPglobalDecl xMPglobalDecl, Block block) {
        XobjList xobjList = (XobjList)block.getProp(CONSTRUCTOR);
        if (xobjList == null) {
            xobjList = Xcons.List(Xcode.LIST);
            block.setProp(CONSTRUCTOR, xobjList);
        }
        Ident ident = xMPglobalDecl.declExternFunc(string);
        xobjList.add(Xcons.List(Xcode.EXPR_STATEMENT, ident.Call(xobject)));
    }

    public static void addConstructorCall2_staticDesc(String string, Xobject xobject, XMPglobalDecl xMPglobalDecl, Block block, Ident ident, boolean bl) {
        XobjList xobjList = (XobjList)block.getProp(CONSTRUCTOR);
        if (xobjList == null) {
            xobjList = Xcons.List(Xcode.LIST);
            block.setProp(CONSTRUCTOR, xobjList);
        }
        Ident ident2 = xMPglobalDecl.declExternFunc(string);
        XobjList xobjList2 = Xcons.List();
        xobjList2.add(Xcons.List(Xcode.EXPR_STATEMENT, ident2.Call(xobject)));
        if (bl) {
            xobjList2.add(Xcons.List(Xcode.EXPR_STATEMENT, Xcons.Set(ident.Ref(), Xcons.IntConstant(1))));
        }
        XobjList xobjList3 = Xcons.List(Xcode.IF_STATEMENT, Xcons.unaryOp(Xcode.LOG_NOT_EXPR, ident.Ref()), xobjList2, null);
        xobjList.add(xobjList3);
    }

    public static void addAllocCall2(String string, Xobject xobject, XMPglobalDecl xMPglobalDecl, Block block) {
        XobjList xobjList = (XobjList)block.getProp(ALLOC);
        if (xobjList == null) {
            xobjList = Xcons.List(Xcode.LIST);
            block.setProp(ALLOC, xobjList);
        }
        Ident ident = xMPglobalDecl.declExternFunc(string);
        xobjList.add(Xcons.List(Xcode.EXPR_STATEMENT, ident.Call(xobject)));
    }

    public static void insertDestructorCall2(String string, Xobject xobject, XMPglobalDecl xMPglobalDecl, Block block) {
        XobjList xobjList = (XobjList)block.getProp(DESTRUCTOR);
        if (xobjList == null) {
            xobjList = Xcons.List(Xcode.LIST);
            block.setProp(DESTRUCTOR, xobjList);
        }
        Ident ident = xMPglobalDecl.declExternFunc(string);
        xobjList.cons(Xcons.List(Xcode.EXPR_STATEMENT, ident.Call(xobject)));
    }
}

