/*
 * Decompiled with CFR 0.152.
 */
package exc.xcalablemp;

import exc.block.BasicBlockExprIterator;
import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockList;
import exc.block.CforBlock;
import exc.block.PragmaBlock;
import exc.block.topdownBlockIterator;
import exc.object.FunctionType;
import exc.object.Ident;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectFile;
import exc.object.Xtype;
import exc.object.bottomupXobjectIterator;
import exc.object.topdownXobjectIterator;
import exc.xcalablemp.XMP;
import exc.xcalablemp.XMPalignedArray;
import exc.xcalablemp.XMPexception;
import exc.xcalablemp.XMPgpuData;
import exc.xcalablemp.XMPgpuDataTable;
import exc.xcalablemp.XMPgpuDecompileWriter;
import exc.xcalablemp.XMPpair;
import exc.xcalablemp.XMPpragma;
import exc.xcalablemp.XMPshadow;
import exc.xcalablemp.XMPutil;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;

public class XMPgpuDecompiler {
    public static final String GPU_FUNC_CONF = "XCALABLEMP_GPU_FUNC_CONF_PROP";
    public static final String GPU_INDEX_TABLE = "XCALABLEMP_GPU_INDEX_TABLE_PROP";
    private static XMPgpuDecompileWriter out = null;
    private static final int BUFFER_SIZE = 4096;
    private static final String GPU_SRC_EXTENSION = ".cu";
    private static HashMap<String, XobjList> _gtolIdHash = null;
    private static HashMap<String, XobjList> _accIdHash = null;

    /*
     * WARNING - void declaration
     */
    public static void decompile(Ident ident, XobjList xobjList, ArrayList<XMPalignedArray> arrayList, CforBlock cforBlock, XobjList xobjList2, PragmaBlock pragmaBlock, XobjectFile xobjectFile) throws XMPexception {
        Object object8;
        Object object2;
        Object object3;
        Object object4;
        Xobject xobject4;
        XobjList xobjList3;
        Xobject xobject2;
        Ident ident2;
        Ident ident3;
        Ident ident4;
        Object object5;
        Xobject xobject32;
        XobjList xobjList4 = (XobjList)pragmaBlock.getClauses();
        XobjList xobjList5 = (XobjList)xobjList4.getArg(3).getArg(1);
        XMPpair<XobjList, XobjList> xMPpair = new XMPpair<XobjList, XobjList>(Xcons.List(), Xcons.List());
        _gtolIdHash = new HashMap();
        _accIdHash = new HashMap();
        for (XMPalignedArray object72 : arrayList) {
            int xobjList7 = object72.getDim();
            String string = object72.getName();
            xobject32 = Xcons.List();
            object5 = Xcons.List();
            for (int i = 0; i < xobjList7; ++i) {
                ident4 = Ident.Local(new String("_XMP_GPU_" + (String)string + "_GTOL_" + i), Xtype.intType);
                ((XobjList)xobject32).add(ident4);
                if (i == xobjList7 - 1) continue;
                ident3 = Ident.Local(new String("_XMP_GPU_" + (String)string + "_ACC_" + i), Xtype.unsignedlonglongType);
                ((XobjList)object5).add(ident3);
            }
            _gtolIdHash.put(string, (XobjList)xobject32);
            _accIdHash.put(string, (XobjList)object5);
        }
        XobjList xobjList6 = Xcons.List();
        XobjList xobjList7 = Xcons.List();
        XobjList xobjList8 = Xcons.List();
        for (Xobject xobject32 : xobjList2) {
            object5 = ((Ident)xobject32).getSym();
            XMPgpuDecompiler.addLocalVar((Ident)xobject32, xMPpair);
            XobjList ident5 = XMPutil.getLoopIter(cforBlock, (String)object5);
            ident4 = (Ident)ident5.getArg(0);
            ident3 = (Ident)ident5.getArg(1);
            ident2 = (Ident)ident5.getArg(2);
            xobjList6.add(((Ident)xobject32).Ref());
            xobjList7.add(((Ident)xobject32).getAddr());
            xobjList8.add(ident4.Ref());
            xobjList8.add(ident3.Ref());
            xobjList8.add(ident2.Ref());
        }
        xobject32 = Ident.Local("_XMP_GPU_DIM3_block_x", Xtype.intType);
        object5 = Ident.Local("_XMP_GPU_DIM3_block_y", Xtype.intType);
        Ident ident5 = Ident.Local("_XMP_GPU_DIM3_block_z", Xtype.intType);
        ident4 = Ident.Local("_XMP_GPU_DIM3_thread_x", Xtype.intType);
        ident3 = Ident.Local("_XMP_GPU_DIM3_thread_y", Xtype.intType);
        ident2 = Ident.Local("_XMP_GPU_DIM3_thread_z", Xtype.intType);
        Ident ident6 = null;
        XobjList xobjList9 = Xcons.List(new Xobject[]{xobject32, object5, ident5, ident4, ident3, ident2});
        XobjList xobjList10 = Xcons.List(Xcons.List(Xcode.VAR_DECL, xobject32, null, null), Xcons.List(Xcode.VAR_DECL, new Xobject[]{object5, null, null}), Xcons.List(Xcode.VAR_DECL, ident5, null, null), Xcons.List(Xcode.VAR_DECL, ident4, null, null), Xcons.List(Xcode.VAR_DECL, ident3, null, null), Xcons.List(Xcode.VAR_DECL, ident2, null, null));
        XobjList xobjList11 = XMPgpuDecompiler.getNumThreads(xobjList5);
        XobjList xobjList12 = null;
        Object object6 = null;
        if (xobjList11 == null) {
            ident6 = Ident.Local("_XMP_GPU_TOTAL_ITER", Xtype.unsignedlonglongType);
            xobjList9.add(ident6);
            xobjList10.add(Xcons.List(Xcode.VAR_DECL, ident6, null, null));
            object6 = new String("_XMP_gpu_calc_config_params");
            xobject2 = XMP.getMacroId((String)object6);
            xobjList3 = Xcons.List(ident6.getAddr(), ((Ident)xobject32).getAddr(), ((Ident)object5).getAddr(), ident5.getAddr(), ident4.getAddr(), ident3.getAddr(), ident2.getAddr());
            xobjList3.mergeList(xobjList8);
            xobjList12 = Xcons.List(Xcode.EXPR_STATEMENT, ((Ident)xobject2).Call(xobjList3));
        } else {
            object6 = new String("_XMP_gpu_calc_config_params_MAP_THREADS");
            xobject2 = XMP.getMacroId((String)object6);
            xobjList3 = Xcons.List(((Ident)xobject32).getAddr(), ((Ident)object5).getAddr(), ident5.getAddr(), ident4.getAddr(), ident3.getAddr(), ident2.getAddr());
            for (Xobject xobject4 : xobjList11) {
                if (xobject4 == null) continue;
                xobjList3.add(((XobjList)xobject4).getArg(1));
            }
            xobjList3.mergeList(xobjList8);
            xobjList12 = Xcons.List(Xcode.EXPR_STATEMENT, ((Ident)xobject2).Call(xobjList3));
        }
        object6 = XMPgpuDecompiler.genDeviceFuncParamArgs(xobjList, xobjList11);
        xobject2 = (XobjList)((XMPpair)object6).getFirst();
        xobjList3 = (XobjList)((XMPpair)object6).getSecond();
        Ident ident7 = XMP.getMacroId(ident.getName() + "_DEVICE");
        ((FunctionType)ident7.Type()).setFuncParamIdList(xobject2);
        xobject4 = ident7.Call(xobjList3);
        xobject4.setProp(GPU_FUNC_CONF, Xcons.List(new Xobject[]{xobject32, object5, ident5, ident4, ident3, ident2}));
        XMPgpuDecompiler.rewriteLoopBody(cforBlock);
        ArrayList<XobjList> arrayList2 = new ArrayList<XobjList>();
        ArrayList<XobjList> arrayList3 = new ArrayList<XobjList>();
        for (XMPalignedArray xMPalignedArray : arrayList) {
            Xobject xobject5;
            Object object7;
            object4 = xMPalignedArray.getName();
            object3 = XMPgpuDataTable.findXMPgpuData((String)object4, cforBlock);
            Xobject xobject9 = ((XMPgpuData)object3).getDeviceDescId().Ref();
            object2 = _gtolIdHash.get(object4);
            int n = 0;
            object8 = ((XobjList)object2).iterator();
            while (object8.hasNext()) {
                object7 = object8.next();
                xobject5 = (Ident)object7;
                if (XMPgpuDecompiler.hasVarRef(((Ident)xobject5).getName(), cforBlock)) {
                    XMPgpuDecompiler.addLocalVar((Ident)xobject5, xMPpair);
                    arrayList2.add(Xcons.List(((Ident)xobject5).Ref(), xobject9, Xcons.IntConstant(n)));
                }
                ++n;
            }
            object8 = _accIdHash.get(object4);
            n = 0;
            object7 = ((XobjList)object8).iterator();
            while (object7.hasNext()) {
                xobject5 = (Xobject)object7.next();
                Xobject xobject6 = xobject5;
                if (XMPgpuDecompiler.hasVarRef(((Ident)xobject6).getName(), cforBlock)) {
                    XMPgpuDecompiler.addLocalVar((Ident)xobject6, xMPpair);
                    arrayList3.add(Xcons.List(((Ident)xobject6).Ref(), xobject9, Xcons.IntConstant(n)));
                }
                ++n;
            }
        }
        Xobject xobject7 = Xcons.CompoundStatement(xobjList9, xobjList10, Xcons.List(xobjList12, xobject4));
        ((FunctionType)ident.Type()).setFuncParamIdList(xobjList);
        XobjectDef xobjectDef = XobjectDef.Func(ident, xobjList, null, xobject7);
        Ident ident8 = null;
        if (xobjList11 == null) {
            ident8 = Ident.Local("_XMP_GPU_THREAD_ID", Xtype.unsignedlonglongType);
            XMPgpuDecompiler.addLocalVar(ident8, xMPpair);
        }
        object4 = Bcons.emptyBody(xMPpair.getFirst(), xMPpair.getSecond());
        for (XobjList xobjList13 : arrayList2) {
            ((BlockList)object4).add(XMPgpuDecompiler.createFuncCallBlock("_XMP_GPU_M_GET_ARRAY_GTOL", xobjList13));
        }
        for (XobjList xobjList14 : arrayList3) {
            ((BlockList)object4).add(XMPgpuDecompiler.createFuncCallBlock("_XMP_GPU_M_GET_ARRAY_ACC", xobjList14));
        }
        object3 = null;
        if (xobjList11 == null) {
            ((BlockList)object4).add(XMPgpuDecompiler.createFuncCallBlock("_XMP_gpu_calc_thread_id", Xcons.List(ident8.getAddr())));
            XobjList xobjList15 = Xcons.List(ident8.Ref());
            xobjList15.mergeList(xobjList8);
            xobjList15.mergeList(xobjList7);
            ((BlockList)object4).add(XMPgpuDecompiler.createFuncCallBlock("_XMP_gpu_calc_iter", xobjList15));
            object3 = Xcons.List(Xcode.IF_STATEMENT, Xcons.binaryOp(Xcode.LOG_LT_EXPR, ident8.Ref(), ident6.Ref()), cforBlock.getBody().toXobject(), null);
        } else {
            void var37_51;
            boolean bl = false;
            for (Object object8 : xobjList11) {
                if (object8 == null) continue;
                ++var37_51;
            }
            object2 = Xcons.List();
            ((XobjList)object2).mergeList(xobjList8);
            ((XobjList)object2).mergeList(xobjList6);
            ((BlockList)object4).add(XMPgpuDecompiler.createFuncCallBlock(new String("_XMP_gpu_calc_iter_MAP_THREADS_" + (int)var37_51), (XobjList)object2));
            object3 = cforBlock.getBody().toXobject();
        }
        ((BlockList)object4).add((Xobject)object3);
        Xobject xobject8 = ((BlockList)object4).toXobject();
        object2 = XobjectDef.Func(ident7, xobject2, null, xobject8);
        try {
            if (out == null) {
                object8 = new BufferedWriter(new FileWriter(XMPgpuDecompiler.getSrcName(xobjectFile.getSourceFileName()) + GPU_SRC_EXTENSION), 4096);
                out = new XMPgpuDecompileWriter((Writer)object8, xobjectFile);
            }
            out.println("#include \"xmp_gpu_func.hpp\"");
            out.println("#include \"xmp_index_macro.h\"");
            out.println();
            out.printDeviceFunc((XobjectDef)object2, ident7);
            out.println();
            out.printHostFunc(xobjectDef);
            out.println();
            out.flush();
        }
        catch (IOException iOException) {
            throw new XMPexception("error in gpu decompiler: " + iOException.getMessage());
        }
    }

    private static void addLocalVar(Ident ident, XMPpair<XobjList, XobjList> xMPpair) {
        xMPpair.getFirst().add(ident);
        xMPpair.getSecond().add(Xcons.List(Xcode.VAR_DECL, ident, null, null));
    }

    private static Block createFuncCallBlock(String string, XobjList xobjList) {
        Ident ident = XMP.getMacroId(string);
        return Bcons.Statement(ident.Call(xobjList));
    }

    private static String getSrcName(String string) {
        String string2 = "";
        String[] stringArray = string.split("\\.");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            string2 = string2 + stringArray[i];
        }
        return string2;
    }

    private static XMPpair<XobjList, XobjList> genDeviceFuncParamArgs(XobjList xobjList, XobjList xobjList2) {
        Object object;
        XobjList xobjList3 = Xcons.List();
        XobjList xobjList4 = Xcons.List();
        for (object = xobjList.getArgs(); object != null; object = ((XobjArgs)object).nextArgs()) {
            Ident ident = (Ident)((XobjArgs)object).getArg();
            xobjList3.add(ident);
            if (ident.Type().isArray()) {
                xobjList4.add(ident.getValue());
                continue;
            }
            xobjList4.add(ident.Ref());
        }
        if (xobjList2 == null) {
            object = Ident.Param("_XMP_GPU_TOTAL_ITER", Xtype.unsignedlonglongType);
            xobjList3.add((Xobject)object);
            xobjList4.add(((Ident)object).Ref());
        }
        return new XMPpair<XobjList, XobjList>(xobjList3, xobjList4);
    }

    private static XobjList getNumThreads(XobjList xobjList) {
        XobjList xobjList2 = null;
        for (Xobject xobject : xobjList) {
            XMPpragma xMPpragma = XMPpragma.valueOf(xobject.getArg(0));
            switch (xMPpragma) {
                case GPU_MAP_THREADS: {
                    xobjList2 = (XobjList)xobject.getArg(1);
                }
            }
        }
        return xobjList2;
    }

    private static boolean hasVarRef(String string, CforBlock cforBlock) throws XMPexception {
        BasicBlockExprIterator basicBlockExprIterator = new BasicBlockExprIterator(cforBlock.getBody());
        basicBlockExprIterator.init();
        while (!basicBlockExprIterator.end()) {
            Xobject xobject = basicBlockExprIterator.getExpr();
            if (xobject != null) {
                bottomupXobjectIterator bottomupXobjectIterator2 = new bottomupXobjectIterator(xobject);
                bottomupXobjectIterator2.init();
                while (!bottomupXobjectIterator2.end()) {
                    Xobject xobject2 = bottomupXobjectIterator2.getXobject();
                    if (xobject2 != null && xobject2.Opcode() == Xcode.VAR && xobject2.getName().equals(string)) {
                        return true;
                    }
                    bottomupXobjectIterator2.next();
                }
            }
            basicBlockExprIterator.next();
        }
        return false;
    }

    private static void rewriteLoopBody(CforBlock cforBlock) throws XMPexception {
        XMPgpuDecompiler.rewriteDecls(cforBlock);
        BasicBlockExprIterator basicBlockExprIterator = new BasicBlockExprIterator(cforBlock.getBody());
        basicBlockExprIterator.init();
        while (!basicBlockExprIterator.end()) {
            XMPgpuDecompiler.rewriteExpr(basicBlockExprIterator.getExpr(), cforBlock);
            basicBlockExprIterator.next();
        }
    }

    private static void rewriteDecls(CforBlock cforBlock) {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(cforBlock);
        topdownBlockIterator2.init();
        while (!topdownBlockIterator2.end()) {
            XobjList xobjList;
            Block block = topdownBlockIterator2.getBlock();
            BlockList blockList = block.getBody();
            if (blockList != null && (xobjList = (XobjList)blockList.getDecls()) != null) {
                try {
                    for (Xobject xobject : xobjList) {
                        XMPgpuDecompiler.rewriteExpr(xobject.getArg(1), cforBlock);
                    }
                }
                catch (XMPexception xMPexception) {
                    XMP.error(block.getLineNo(), xMPexception.getMessage());
                }
            }
            topdownBlockIterator2.next();
        }
    }

    private static void rewriteExpr(Xobject xobject, CforBlock cforBlock) throws XMPexception {
        if (xobject == null) {
            return;
        }
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject);
        topdownXobjectIterator2.init();
        while (!topdownXobjectIterator2.end()) {
            Xobject xobject2 = topdownXobjectIterator2.getXobject();
            if (xobject2 != null) {
                switch (xobject2.Opcode()) {
                    case ARRAY_REF: {
                        String string = xobject2.getArg(0).getSym();
                        XMPgpuData xMPgpuData = XMPgpuDataTable.findXMPgpuData(string, cforBlock);
                        if (xMPgpuData == null) {
                            throw new XMPexception("array '" + string + "' is not allocated on the device memory");
                        }
                        XMPalignedArray xMPalignedArray = xMPgpuData.getXMPalignedArray();
                        if (xMPalignedArray == null || !xMPalignedArray.realloc()) break;
                        topdownXobjectIterator2.setXobject(XMPgpuDecompiler.rewriteAlignedArrayExpr((XobjList)xobject2.getArg(1), xMPgpuData));
                        break;
                    }
                }
            }
            topdownXobjectIterator2.next();
        }
    }

    private static Xobject rewriteAlignedArrayExpr(XobjList xobjList, XMPgpuData xMPgpuData) throws XMPexception {
        int n = 0;
        XobjList xobjList2 = Xcons.List(xMPgpuData.getHostId().getAddr());
        if (xobjList != null) {
            for (Xobject xobject : xobjList) {
                xobjList2.add(xobject);
                ++n;
            }
        }
        return XMPgpuDecompiler.createRewriteAlignedArrayFunc(xMPgpuData, n, xobjList2);
    }

    private static Xobject createRewriteAlignedArrayFunc(XMPgpuData xMPgpuData, int n, XobjList xobjList) throws XMPexception {
        int n2;
        XMPalignedArray xMPalignedArray = xMPgpuData.getXMPalignedArray();
        int n3 = xMPalignedArray.getDim();
        XobjList xobjList2 = _accIdHash.get(xMPalignedArray.getName());
        Ident ident = null;
        if (n3 < n) {
            throw new XMPexception("wrong array ref");
        }
        if (n3 == n) {
            ident = XMP.getMacroId("_XMP_M_GET_ADDR_E_" + n3, Xtype.Pointer(xMPalignedArray.getType()));
            for (n2 = 0; n2 < n3 - 1; ++n2) {
                xobjList.add(((Ident)xobjList2.getArg(n2)).Ref());
            }
        } else {
            ident = XMP.getMacroId("_XMP_M_GET_ADDR_" + n, Xtype.Pointer(xMPalignedArray.getType()));
            for (n2 = 0; n2 < n; ++n2) {
                xobjList.add(((Ident)xobjList2.getArg(n2)).Ref());
            }
        }
        Xobject xobject = ident.Call(xobjList);
        if (n3 == n) {
            return Xcons.PointerRef(xobject);
        }
        return xobject;
    }

    private static Xobject getCalcIndexFuncRef(XMPgpuData xMPgpuData, int n, Xobject xobject) throws XMPexception {
        XMPalignedArray xMPalignedArray = xMPgpuData.getXMPalignedArray();
        XobjList xobjList = _gtolIdHash.get(xMPalignedArray.getName());
        switch (xMPalignedArray.getAlignMannerAt(n)) {
            case 200: 
            case 201: {
                return xobject;
            }
            case 202: {
                if (xMPalignedArray.hasShadow()) {
                    XMPshadow xMPshadow = xMPalignedArray.getShadowAt(n);
                    switch (xMPshadow.getType()) {
                        case 400: 
                        case 401: {
                            XobjList xobjList2 = Xcons.List(xobject, ((Ident)xobjList.getArg(n)).Ref());
                            return XMP.getMacroId("_XMP_M_CALC_INDEX_BLOCK").Call(xobjList2);
                        }
                        case 402: {
                            return xobject;
                        }
                    }
                    throw new XMPexception("unknown shadow type");
                }
                XobjList xobjList3 = Xcons.List(xobject, ((Ident)xobjList.getArg(n)).Ref());
                return XMP.getMacroId("_XMP_M_CALC_INDEX_BLOCK").Call(xobjList3);
            }
            case 203: {
                if (xMPalignedArray.hasShadow()) {
                    XMPshadow xMPshadow = xMPalignedArray.getShadowAt(n);
                    switch (xMPshadow.getType()) {
                        case 400: {
                            XobjList xobjList4 = Xcons.List(xobject, ((Ident)xobjList.getArg(n)).Ref());
                            return XMP.getMacroId("_XMP_M_CALC_INDEX_CYCLIC").Call(xobjList4);
                        }
                        case 402: {
                            return xobject;
                        }
                        case 401: {
                            throw new XMPexception("only block distribution allows shadow");
                        }
                    }
                    throw new XMPexception("unknown shadow type");
                }
                XobjList xobjList5 = Xcons.List(xobject, ((Ident)xobjList.getArg(n)).Ref());
                return XMP.getMacroId("_XMP_M_CALC_INDEX_CYCLIC").Call(xobjList5);
            }
        }
        throw new XMPexception("unknown align manner for array '" + xMPalignedArray.getName() + "'");
    }
}

