/*
 * Decompiled with CFR 0.152.
 */
package exc.xcalablemp;

import exc.object.Ident;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.XobjArgs;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectFile;
import exc.object.Xtype;
import exc.xcalablemp.XMPpragma;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;

public class XMPgpuDecompileWriter
extends PrintWriter {
    private XobjectFile _env = null;

    public XMPgpuDecompileWriter(Writer writer, XobjectFile xobjectFile) {
        super(writer);
        this._env = xobjectFile;
    }

    public void printDeviceFunc(XobjectDef xobjectDef, Ident ident) {
        this.printWithIdentList(xobjectDef.getDef(), this._env.getGlobalIdentList(), true, ident);
    }

    public void printHostFunc(XobjectDef xobjectDef) {
        this.printWithIdentList(xobjectDef.getDef(), this._env.getGlobalIdentList(), false, null);
    }

    private void fatal(String string) {
        System.err.println("Fatal XobjectDecompileStream: " + string);
        System.exit(1);
    }

    private void printWithIdentList(Xobject xobject, Xobject xobject2, boolean bl, Ident ident) {
        Ident ident2 = null;
        Ident ident3 = null;
        String string = null;
        if (xobject == null) {
            return;
        }
        switch (xobject.Opcode()) {
            case FUNCTION_DEFINITION: {
                if (bl) {
                    ident2 = ident;
                } else {
                    ident2 = this.findIdent(xobject2, xobject.getArg(0));
                    if (ident2 == null) {
                        this.fatal("Function id is not found");
                    }
                }
                String string2 = ident2.getName();
                if (ident2.Type().isFuncProto() && ident2.Type().getFuncParam() != null) {
                    XobjArgs xobjArgs = ident2.Type().getFuncParam().getArgs();
                    XobjArgs xobjArgs2 = xobject.getArg(1).getArgs();
                    if (xobjArgs2 == null) {
                        string = xobjArgs != null && xobjArgs.getArg() == null ? "(...)" : "(void)";
                    } else {
                        string = "(";
                        while (xobjArgs2 != null) {
                            ident3 = (Ident)xobjArgs2.getArg();
                            string = string + this.makeDeclType(ident3.Type(), ident3.getName());
                            if (xobjArgs2.nextArgs() != null) {
                                string = string + ", ";
                            }
                            xobjArgs = xobjArgs.nextArgs();
                            xobjArgs2 = xobjArgs2.nextArgs();
                        }
                        if (xobjArgs != null && xobjArgs.getArg() == null) {
                            string = string + ", ...";
                        }
                        string = string + ")";
                    }
                    if (bl) {
                        this.println("__global__ static");
                    } else {
                        this.println("extern \"C\"");
                    }
                    this.printDeclType(ident2.Type().getRef(), string2 + string);
                } else {
                    string = "(";
                    if (xobject.getArg(1) != null) {
                        for (XobjArgs xobjArgs = xobject.getArg(1).getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
                            ident3 = (Ident)xobjArgs.getArg();
                            string = string + ident3.getName();
                            if (xobjArgs.nextArgs() == null) continue;
                            string = string + ",";
                        }
                    }
                    string = string + ")";
                    if (bl) {
                        this.println("__global__ static");
                    } else {
                        this.println("extern \"C\"");
                    }
                    this.printDeclType(ident2.Type().getRef(), string2 + string);
                    this.printIdentList(xobject.getArg(1));
                    this.printDeclList(xobject.getArg(2), xobject.getArg(1));
                }
                this.printBody(xobject.getArg(3));
                this.println();
                break;
            }
            default: {
                this.fatal("wrong operation");
            }
        }
    }

    private void print(Xobject xobject) {
        if (xobject == null) {
            return;
        }
        block0 : switch (xobject.Opcode()) {
            case LIST: {
                for (XobjArgs xobjArgs = xobject.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
                    this.print(xobjArgs.getArg());
                }
                break;
            }
            case COMPOUND_STATEMENT: {
                this.println();
                this.println("{");
                this.printIdentList(xobject.getArg(0));
                this.printDeclList(xobject.getArg(1), xobject.getArg(0));
                this.print(xobject.getArg(2));
                this.println();
                this.print("}");
                break;
            }
            case IF_STATEMENT: {
                this.println();
                this.print("if(");
                this.print(xobject.getArg(0));
                this.print(")");
                this.printBody(xobject.getArg(1));
                if (xobject.getArg(2) == null) break;
                this.print(" else ");
                this.printBody(xobject.getArg(2));
                break;
            }
            case WHILE_STATEMENT: {
                this.println();
                this.print("while(");
                this.print(xobject.getArg(0));
                this.print(")");
                this.printBody(xobject.getArg(1));
                break;
            }
            case FOR_STATEMENT: {
                this.println();
                this.print("for(");
                this.print(xobject.getArg(0));
                this.print(";");
                this.print(xobject.getArg(1));
                this.print(";");
                this.print(xobject.getArg(2));
                this.print(")");
                this.printBody(xobject.getArg(3));
                break;
            }
            case DO_STATEMENT: {
                this.println();
                this.print("do ");
                this.printBody(xobject.getArg(0));
                this.print(" while(");
                this.print(xobject.getArg(1));
                this.print(");");
                break;
            }
            case BREAK_STATEMENT: {
                this.println();
                this.print("break; ");
                break;
            }
            case CONTINUE_STATEMENT: {
                this.println();
                this.print("continue; ");
                break;
            }
            case GOTO_STATEMENT: {
                this.println();
                this.print("goto ");
                this.print(xobject.getArg(0).getSym());
                this.print(";");
                break;
            }
            case STATEMENT_LABEL: {
                this.println();
                this.print(xobject.getArg(0).getSym());
                this.print(":;");
                break;
            }
            case SWITCH_STATEMENT: {
                this.println();
                this.print("switch(");
                this.print(xobject.getArg(0));
                this.print(")");
                this.printBody(xobject.getArg(1));
                break;
            }
            case CASE_LABEL: {
                this.println();
                this.print("case ");
                this.print(xobject.getArg(0));
                this.print(":");
                break;
            }
            case DEFAULT_LABEL: {
                this.println();
                this.print("default:");
                break;
            }
            case RETURN_STATEMENT: {
                this.println();
                this.print("return ");
                if (xobject.getArg(0) != null) {
                    this.print(xobject.getArg(0));
                }
                this.print(";");
                break;
            }
            case EXPR_STATEMENT: {
                this.println();
                this.print(xobject.getArg(0));
                this.print(";");
                break;
            }
            case STRING_CONSTANT: {
                this.print("\"");
                String string = xobject.getString();
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c < ' ' || c == '\"') {
                        if (c < '\b') {
                            this.print("\\00" + Integer.toOctalString(c));
                            continue;
                        }
                        this.print("\\0" + Integer.toOctalString(c));
                        continue;
                    }
                    if (c == '\\') {
                        this.print("\\\\");
                        continue;
                    }
                    this.print(c);
                }
                this.print("\"");
                break;
            }
            case INT_CONSTANT: {
                if (xobject.Type().isUnsigned()) {
                    this.print("((unsigned)0x" + Integer.toHexString(xobject.getInt()) + ")");
                    break;
                }
                this.print(xobject.getInt());
                break;
            }
            case FLOAT_CONSTANT: {
                this.print(xobject.getFloatString());
                break;
            }
            case LONGLONG_CONSTANT: {
                this.print("0x" + Long.toHexString(xobject.getLong()));
                break;
            }
            case VAR_ADDR: {
                this.print("&" + xobject.getSym());
                break;
            }
            case VAR: 
            case ARRAY_ADDR: 
            case FUNC_ADDR: 
            case MOE_CONSTANT: {
                this.print(xobject.getSym());
                break;
            }
            case REG: {
                this.print(xobject.getName());
                break;
            }
            case POINTER_REF: {
                switch (xobject.left().Opcode()) {
                    case VAR_ADDR: {
                        this.print(xobject.left().getSym());
                        break block0;
                    }
                    case VAR: {
                        this.print("*");
                        this.print(xobject.left());
                        break block0;
                    }
                    case MEMBER_ADDR: {
                        this.print("(");
                        this.print(xobject.left().left());
                        this.print(")->");
                        this.print(xobject.left().getArg(1).getSym());
                        break block0;
                    }
                }
                this.print("*(");
                this.print(xobject.left());
                this.print(")");
                break;
            }
            case MEMBER_REF: {
                this.print("((");
                this.print(xobject.left());
                this.print(").");
                this.print(xobject.getArg(1).getSym());
                this.print(")");
                break;
            }
            case MEMBER_ADDR: {
                this.print("&((");
                this.print(xobject.left());
                this.print(")->");
                this.print(xobject.getArg(1).getSym());
                this.print(")");
                break;
            }
            case MEMBER_ARRAY_ADDR: {
                this.print("(");
                this.print(xobject.left());
                this.print(")->");
                this.print(xobject.getArg(1).getSym());
                break;
            }
            case ARRAY_REF: {
                this.print(xobject.getArg(0).getSym());
                XobjList xobjList = (XobjList)xobject.getArg(1);
                if (xobjList == null) break;
                for (Xobject xobject2 : xobjList) {
                    this.print("[");
                    this.print(xobject2);
                    this.print("]");
                }
                break;
            }
            case ADDR_OF: {
                this.print("&(");
                this.print(xobject.left());
                this.print(")");
                break;
            }
            case COMMA_EXPR: {
                this.print("(");
                for (XobjArgs xobjArgs = xobject.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
                    this.print(xobjArgs.getArg());
                    if (xobjArgs.nextArgs() == null) continue;
                    this.print(",");
                }
                this.print(")");
                break;
            }
            case FUNCTION_CALL: {
                XobjList xobjList = (XobjList)xobject.getProp("XCALABLEMP_GPU_FUNC_CONF_PROP");
                String string = null;
                if (xobject.left().Opcode() == Xcode.FUNC_ADDR) {
                    string = xobject.left().getSym();
                } else {
                    this.fatal("cannot decompile XMP-ACC code");
                }
                if (xobjList != null) {
                    this.println();
                    this.println("{");
                    this.println("dim3 _XMP_GPU_DIM3_block(" + xobjList.getArg(0).getName() + ", " + xobjList.getArg(1).getName() + ", " + xobjList.getArg(2).getName() + ");");
                    this.println("dim3 _XMP_GPU_DIM3_thread(" + xobjList.getArg(3).getName() + ", " + xobjList.getArg(4).getName() + ", " + xobjList.getArg(5).getName() + ");");
                }
                this.print(string);
                if (xobjList != null) {
                    this.print("<<<_XMP_GPU_DIM3_block, _XMP_GPU_DIM3_thread>>>");
                }
                this.printArgList(xobject.right());
                if (xobjList == null) break;
                this.println(";");
                this.println("_XMP_GPU_M_BARRIER_KERNEL();");
                this.print("}");
                break;
            }
            case POST_INCR_EXPR: {
                this.print("(");
                this.print(xobject.left());
                this.print(")++");
                break;
            }
            case POST_DECR_EXPR: {
                this.print("(");
                this.print(xobject.left());
                this.print(")--");
                break;
            }
            case SIZE_OF_EXPR: {
                this.print("sizeof(");
                this.printDeclType(xobject.Type(), null);
                this.print(")");
                break;
            }
            case CAST_EXPR: {
                this.print("((");
                this.printDeclType(xobject.Type(), null);
                this.print(")(");
                this.print(xobject.left());
                this.print("))");
                break;
            }
            case CONDITIONAL_EXPR: {
                this.print("(");
                this.print(xobject.left());
                this.print(")?(");
                this.print(xobject.right().left());
                this.print("):(");
                this.print(xobject.right().right());
                this.print(")");
                break;
            }
            case ASSIGN_EXPR: {
                String string = "=";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case ASG_PLUS_EXPR: {
                String string = "+=";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case ASG_MINUS_EXPR: {
                String string = "-=";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case PLUS_EXPR: {
                String string = "+";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case MINUS_EXPR: {
                String string = "-";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case ASG_DIV_EXPR: {
                String string = "/=";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case ASG_MUL_EXPR: {
                String string = "*=";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case DIV_EXPR: {
                String string = "/";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case MUL_EXPR: {
                String string = "*";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case UNARY_MINUS_EXPR: {
                String string = "-";
                this.printUnaryExpr(string, xobject.left());
                break;
            }
            case ASG_MOD_EXPR: {
                String string = "%=";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case ASG_BIT_AND_EXPR: {
                String string = "&=";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case ASG_BIT_OR_EXPR: {
                String string = "|=";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case ASG_BIT_XOR_EXPR: {
                String string = "^=";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case MOD_EXPR: {
                String string = "%";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case BIT_AND_EXPR: {
                String string = "&";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case BIT_OR_EXPR: {
                String string = "|";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case BIT_XOR_EXPR: {
                String string = "^";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case BIT_NOT_EXPR: {
                String string = "~";
                this.printUnaryExpr(string, xobject.left());
                break;
            }
            case ASG_LSHIFT_EXPR: {
                String string = "<<=";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case ASG_RSHIFT_EXPR: {
                String string = ">>=";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case LSHIFT_EXPR: {
                String string = "<<";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case RSHIFT_EXPR: {
                String string = ">>";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case LOG_GE_EXPR: {
                String string = ">=";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case LOG_GT_EXPR: {
                String string = ">";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case LOG_LE_EXPR: {
                String string = "<=";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case LOG_LT_EXPR: {
                String string = "<";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case LOG_EQ_EXPR: {
                String string = "==";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case LOG_NEQ_EXPR: {
                String string = "!=";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case LOG_AND_EXPR: {
                String string = "&&";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case LOG_OR_EXPR: {
                String string = "||";
                this.printBinaryExpr(string, xobject.left(), xobject.right());
                break;
            }
            case LOG_NOT_EXPR: {
                String string = "!";
                this.printUnaryExpr(string, xobject.left());
                break;
            }
            case OMP_PRAGMA: 
            case XMP_PRAGMA: {
                String string = xobject.getArg(0).getString();
                switch (XMPpragma.valueOf(string)) {
                    case GPU_BARRIER: {
                        this.println();
                        this.print("_XMP_GPU_M_BARRIER_THREADS();");
                        break block0;
                    }
                }
                this.fatal(string + " directive is not available in GPU kernel");
                break;
            }
            default: {
                this.printUserCode(xobject);
            }
        }
    }

    private void printStorageClass(Ident ident) {
        switch (ident.getStorageClass()) {
            case AUTO: {
                break;
            }
            case SNULL: {
                this.printDeclType(ident.Type(), ident.getName());
                if (ident.getBitField() != 0) {
                    this.print(":" + ident.getBitField());
                }
                return;
            }
            case PARAM: 
            case EXTDEF: 
            case MEMBER: {
                break;
            }
            case EXTERN: {
                this.print("extern ");
                break;
            }
            case STATIC: {
                this.print("static ");
                break;
            }
            case REGISTER: {
                this.print("register ");
                break;
            }
            case REG: {
                this.printDeclType(ident.Type(), ident.getName());
                return;
            }
            default: {
                this.fatal("printStorageClass: bad class," + ident.getStorageClass().toXcodeString());
                return;
            }
        }
    }

    private void printTypeName(Xtype xtype) {
        this.print(this.makeTypeName(xtype));
    }

    private String makeTypeName(Xtype xtype) {
        String string = "";
        if (xtype.copied != null) {
            xtype = xtype.copied;
        }
        switch (xtype.getKind()) {
            case 1: {
                switch (xtype.getBasicType()) {
                    case 1: {
                        string = string + "void";
                        break;
                    }
                    case 3: {
                        string = string + "char";
                        break;
                    }
                    case 5: {
                        string = string + "short";
                        break;
                    }
                    case 9: {
                        string = string + "long";
                        break;
                    }
                    case 11: {
                        string = string + "long long";
                        break;
                    }
                    case 4: {
                        string = string + "unsigned char";
                        break;
                    }
                    case 6: {
                        string = string + "unsigned short";
                        break;
                    }
                    case 10: {
                        string = string + "unsigned long";
                        break;
                    }
                    case 12: {
                        string = string + "unsigned long long";
                        break;
                    }
                    case 13: {
                        string = string + "float";
                        break;
                    }
                    case 14: {
                        string = string + "double";
                        break;
                    }
                    case 15: {
                        string = string + "long double";
                        break;
                    }
                    case 8: {
                        string = string + "unsigned";
                        break;
                    }
                    case 7: {
                        string = string + "int";
                        break;
                    }
                    default: {
                        this.fatal("makeTypeName: bad basic type " + xtype);
                    }
                }
                return string;
            }
            case 3: {
                string = string + "struct ";
                if (xtype.getTagName() != null) {
                    string = string + xtype.getTagName();
                    break;
                }
                string = string + "_S" + Integer.toHexString(Integer.parseInt(xtype.Id()));
                break;
            }
            case 4: {
                string = string + "union ";
                if (xtype.getTagName() != null) {
                    string = string + xtype.getTagName();
                    break;
                }
                string = string + "_U" + Integer.toHexString(Integer.parseInt(xtype.Id()));
                break;
            }
            case 2: {
                string = string + "enum ";
                if (xtype.getTagName() != null) {
                    string = string + xtype.getTagName();
                    break;
                }
                string = string + "_E" + Integer.toHexString(Integer.parseInt(xtype.Id()));
                break;
            }
            default: {
                this.fatal("makeTypeName: undefined Type found");
            }
        }
        return string;
    }

    private Ident findIdent(Xobject xobject, Xobject xobject2) {
        if (xobject == null || xobject2 == null) {
            return null;
        }
        for (XobjArgs xobjArgs = xobject.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            Ident ident = (Ident)xobjArgs.getArg();
            if (ident.getStorageClass() == StorageClass.TAGNAME || !xobject2.getSym().equals(ident.getName())) continue;
            return ident;
        }
        return null;
    }

    private void printDeclType(Xtype xtype, String string) {
        this.print(this.makeDeclType(xtype, string));
    }

    private String makeDeclType(Xtype xtype, String string) {
        Xtype xtype2;
        String string2 = "";
        Stack<Xtype> stack = new Stack<Xtype>();
        for (xtype2 = xtype; xtype2 != null && (xtype2.getKind() == 7 || xtype2.getKind() == 5 || xtype2.getKind() == 6); xtype2 = xtype2.getRef()) {
            stack.push(xtype2);
        }
        if (xtype2 == null) {
            this.fatal("makeDeclType: no base type");
        } else {
            if (xtype2.isConst()) {
                string2 = string2 + "const ";
            }
            if (xtype2.isVolatile()) {
                string2 = string2 + "volatile ";
            }
            string2 = string2 + this.makeTypeName(xtype2);
        }
        string2 = string2 + " " + this.makeDeclaratorRec(stack, string);
        return string2;
    }

    private String makeDeclaratorRec(Stack stack, String string) {
        String string2 = "";
        boolean bl = false;
        if (stack.empty()) {
            if (string != null) {
                return string;
            }
            return "";
        }
        Xtype xtype = (Xtype)stack.pop();
        if (!stack.empty() && xtype.getKind() != 7 && ((Xtype)stack.peek()).getKind() == 7) {
            bl = true;
        }
        switch (xtype.getKind()) {
            case 7: {
                string2 = string2 + "*";
                if (xtype.isConst()) {
                    string2 = string2 + "const ";
                }
                if (xtype.isVolatile()) {
                    string2 = string2 + "volatile ";
                }
                string2 = string2 + this.makeDeclaratorRec(stack, string);
                break;
            }
            case 5: {
                if (bl) {
                    string2 = string2 + "(";
                }
                string2 = string2 + this.makeDeclaratorRec(stack, string);
                if (bl) {
                    string2 = string2 + ")";
                }
                if (xtype.isFuncProto() && xtype.getFuncParam() != null) {
                    string2 = string2 + this.makeFuncProtoArgs(xtype.getFuncParam());
                    break;
                }
                string2 = string2 + "()";
                break;
            }
            case 6: {
                if (!stack.empty() && ((Xtype)stack.peek()).getKind() == 5) {
                    string2 = string2 + "*";
                    string2 = string2 + this.makeDeclaratorRec(stack, string);
                    break;
                }
                if (xtype.getArraySize() < 0L) {
                    string2 = string2 + "(";
                    string2 = string2 + "*";
                    string2 = string2 + this.makeDeclaratorRec(stack, string);
                    string2 = string2 + ")";
                    break;
                }
                if (bl) {
                    string2 = string2 + "(";
                }
                string2 = string2 + this.makeDeclaratorRec(stack, string);
                if (bl) {
                    string2 = string2 + ")";
                }
                if (xtype.getArraySize() <= 0L) {
                    string2 = string2 + "[]";
                    break;
                }
                string2 = string2 + "[" + xtype.getArraySize() + "]";
                break;
            }
            default: {
                this.fatal("printDeclaratorRec");
            }
        }
        return string2;
    }

    private String makeFuncProtoArgs(Xobject xobject) {
        String string;
        if (xobject.getArgs() == null) {
            string = "(void)";
        } else {
            string = "(";
            for (XobjArgs xobjArgs = xobject.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
                if (xobjArgs.getArg() == null) {
                    string = string + "...";
                    break;
                }
                string = xobjArgs.getArg().Opcode() == Xcode.IDENT ? string + this.makeDeclType(xobjArgs.getArg().Type(), xobjArgs.getArg().getName()) : string + this.makeDeclType(xobjArgs.getArg().Type(), null);
                if (xobjArgs.nextArgs() == null) continue;
                string = string + ",";
            }
            string = string + ")";
        }
        return string;
    }

    private void printInitializer(Xobject xobject) {
        if (xobject.Opcode() == Xcode.LIST) {
            int n = 0;
            this.print("{");
            for (XobjArgs xobjArgs = xobject.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
                this.printInitializer(xobjArgs.getArg());
                this.print(",");
                if (++n % 16 != 0) continue;
                this.print("\n");
            }
            this.print("}");
        } else {
            this.print(xobject);
        }
    }

    private void printBinaryExpr(String string, Xobject xobject, Xobject xobject2) {
        this.print("(");
        this.print(xobject);
        this.print(")");
        this.print(string);
        this.print("(");
        this.print(xobject2);
        this.print(")");
    }

    private void printUnaryExpr(String string, Xobject xobject) {
        this.print(string);
        this.print("(");
        this.print(xobject);
        this.print(")");
    }

    private void printIdentDecl(Ident ident) {
        switch (ident.getStorageClass()) {
            case AUTO: {
                break;
            }
            case SNULL: {
                this.printDeclType(ident.Type(), ident.getName());
                if (ident.getBitField() != 0) {
                    this.print(":" + ident.getBitField());
                }
                return;
            }
            case PARAM: 
            case EXTDEF: 
            case MEMBER: {
                break;
            }
            case EXTERN: {
                this.print("extern ");
                break;
            }
            case STATIC: {
                this.print("static ");
                break;
            }
            case REGISTER: {
                this.print("register ");
                break;
            }
            case REG: {
                this.printDeclType(ident.Type(), ident.getName());
                return;
            }
            case TYPEDEF_NAME: {
                return;
            }
            default: {
                this.fatal("printIdentDecl: bad class," + ident.getStorageClass().toXcodeString());
                return;
            }
        }
        this.printDeclType(ident.Type(), ident.getName());
    }

    private void printIdentList(Xobject xobject) {
        if (xobject == null) {
            return;
        }
        this.printStructTAGNAME(xobject);
    }

    private void printStructTAGNAME(Xobject xobject) {
        Xtype xtype;
        Ident ident;
        XobjArgs xobjArgs;
        block7: for (xobjArgs = xobject.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            ident = (Ident)xobjArgs.getArg();
            if (ident.getStorageClass() != StorageClass.TAGNAME) continue;
            xtype = ident.Type();
            switch (xtype.getKind()) {
                case 3: 
                case 4: {
                    this.printTypeName(xtype);
                    this.println(";");
                    continue block7;
                }
            }
        }
        block8: for (xobjArgs = xobject.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            ident = (Ident)xobjArgs.getArg();
            if (ident.getStorageClass() != StorageClass.TAGNAME) continue;
            xtype = ident.Type();
            switch (xtype.getKind()) {
                case 3: 
                case 4: {
                    XobjArgs xobjArgs2;
                    if (xtype.getMemberList().getArgs() == null) continue block8;
                    this.printTypeName(xtype);
                    this.println(" {");
                    for (xobjArgs2 = xtype.getMemberList().getArgs(); xobjArgs2 != null; xobjArgs2 = xobjArgs2.nextArgs()) {
                        this.printIdentDecl((Ident)xobjArgs2.getArg());
                        this.println(";");
                    }
                    this.println(" };");
                    continue block8;
                }
                case 2: {
                    XobjArgs xobjArgs2;
                    if (xtype.getMemberList() == null) continue block8;
                    this.printTypeName(xtype);
                    this.println(" {");
                    for (xobjArgs2 = xtype.getMemberList().getArgs(); xobjArgs2 != null; xobjArgs2 = xobjArgs2.nextArgs()) {
                        ident = this.findIdent(xobject, xobjArgs2.getArg());
                        if (ident == null) {
                            this.fatal("Enum ID is not found");
                        }
                        this.print(xobjArgs2.getArg().getSym());
                        if (ident.getValue() != null) {
                            this.print("=");
                            this.print(ident.getAddr());
                        }
                        this.println(",");
                    }
                    this.println(" };");
                    continue block8;
                }
            }
        }
    }

    private void printUserCode(Xobject xobject) {
        this.print("_user_xcode(/* " + xobject.toString() + " */)");
    }

    private void printArgList(Xobject xobject) {
        this.print("(");
        if (xobject != null) {
            for (XobjArgs xobjArgs = xobject.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
                this.print(xobjArgs.getArg());
                if (xobjArgs.nextArgs() == null) continue;
                this.print(",");
            }
        }
        this.print(")");
    }

    private void printBody(Xobject xobject) {
        if (xobject == null) {
            this.print("{}");
            return;
        }
        if (xobject.Opcode() == Xcode.LIST) {
            this.print("{");
            this.print(xobject);
            this.println();
            this.print("}");
        } else {
            this.print(xobject);
        }
    }

    private void printDeclList(Xobject xobject, Xobject xobject2) {
        if (xobject == null) {
            return;
        }
        switch (xobject.Opcode()) {
            case LIST: {
                for (XobjArgs xobjArgs = xobject.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
                    this.printDeclList(xobjArgs.getArg(), xobject2);
                }
                break;
            }
            case VAR_DECL: {
                Xobject xobject3 = xobject.getArg(0);
                Ident ident = this.findIdent(xobject2, xobject3);
                if (ident == null && (ident = this.findIdent(this._env.getGlobalIdentList(), xobject3)) == null) {
                    this.fatal("Variable id is not found, " + xobject3);
                }
                if (ident.getStorageClass() == StorageClass.SNULL) break;
                if (ident.getStorageClass() == StorageClass.EXTDEF) {
                    this.print("extern ");
                }
                this.printIdentDecl(ident);
                if (xobject.getArg(1) != null) {
                    this.print("=");
                    this.printInitializer(xobject.getArg(1));
                }
                this.println(";");
                break;
            }
        }
    }
}

