/*
 * Decompiled with CFR 0.152.
 */
package exc.xcalablemp;

import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockList;
import exc.block.PragmaBlock;
import exc.object.ArrayType;
import exc.object.Ident;
import exc.object.PropObject;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjInt;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.xcalablemp.XMP;
import exc.xcalablemp.XMPalignedArray;
import exc.xcalablemp.XMPexception;
import exc.xcalablemp.XMPglobalDecl;
import exc.xcalablemp.XMPgpuDataTable;
import exc.xcalablemp.XMPlocalDecl;
import exc.xcalablemp.XMPpair;
import exc.xcalablemp.XMPsymbolTable;
import exc.xcalablemp.XMPutil;
import xcodeml.util.XmOption;

public class XMPgpuData {
    public static int GPU_SYNC_IN = 600;
    public static int GPU_SYNC_OUT = 601;
    private String _name;
    private Ident _hostDescId;
    private Ident _hostId;
    private Ident _deviceDescId;
    private Ident _deviceAddrId;
    private XMPalignedArray _alignedArray;

    public XMPgpuData(String string, Ident ident, Ident ident2, Ident ident3, Ident ident4, XMPalignedArray xMPalignedArray) {
        this._name = string;
        this._hostDescId = ident;
        this._hostId = ident2;
        this._deviceDescId = ident3;
        this._deviceAddrId = ident4;
        this._alignedArray = xMPalignedArray;
    }

    public String getName() {
        return this._name;
    }

    public Ident getHostDescId() {
        return this._hostDescId;
    }

    public Ident getHostId() {
        return this._hostId;
    }

    public Ident getDeviceDescId() {
        return this._deviceDescId;
    }

    public Ident getDeviceAddrId() {
        return this._deviceAddrId;
    }

    public XMPalignedArray getXMPalignedArray() {
        return this._alignedArray;
    }

    public static void translateGpuData(PragmaBlock pragmaBlock, XMPglobalDecl xMPglobalDecl) throws XMPexception {
        Object object;
        BlockList blockList = pragmaBlock.getBody();
        if (!XmOption.isXcalableMPGPU()) {
            XMP.warning("use -enable-gpu option to use 'acc replicate' directive");
            pragmaBlock.replace(Bcons.COMPOUND(blockList));
            return;
        }
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(pragmaBlock);
        XMPgpuDataTable xMPgpuDataTable = new XMPgpuDataTable();
        BlockList blockList2 = Bcons.emptyBody();
        BlockList blockList3 = Bcons.emptyBody();
        BlockList blockList4 = Bcons.emptyBody();
        XobjList xobjList2 = (XobjList)xobjList.getArg(0);
        for (object = xobjList2.getArgs(); object != null; object = ((XobjArgs)object).nextArgs()) {
            String string = ((XobjArgs)object).getArg().getString();
            XMPgpuData xMPgpuData = xMPgpuDataTable.getXMPgpuData(string);
            if (xMPgpuData != null) {
                throw new XMPexception("acc replicate '" + string + "' is already declared");
            }
            XMPpair<Ident, Xtype> xMPpair = XMPutil.findTypedVar(string, pragmaBlock);
            Ident ident = xMPpair.getFirst();
            Xtype xtype = xMPpair.getSecond();
            xMPgpuData = XMPgpuDataTable.findXMPgpuData(string, pragmaBlock.getParentBlock());
            if (xMPgpuData != null && xMPgpuData.getHostId() == ident) {
                throw new XMPexception("acc replicate '" + string + "' is already declared");
            }
            Ident ident2 = blockList4.declLocalIdent("_XMP_GPU_HOST_DESC_" + string, Xtype.voidPtrType);
            Ident ident3 = null;
            Ident ident4 = blockList4.declLocalIdent("_XMP_GPU_DEVICE_ADDR_" + string, Xtype.voidPtrType);
            XMPalignedArray xMPalignedArray = xMPglobalDecl.getXMPalignedArray(string, pragmaBlock);
            if (xMPalignedArray == null) {
                Xobject xobject = null;
                Xobject xobject2 = null;
                switch (xtype.getKind()) {
                    case 1: 
                    case 3: 
                    case 4: {
                        xobject = ident.getAddr();
                        xobject2 = Xcons.SizeOf(xtype);
                        break;
                    }
                    case 6: {
                        ArrayType arrayType = (ArrayType)xtype;
                        switch (arrayType.getArrayElementType().getKind()) {
                            case 1: 
                            case 3: 
                            case 4: {
                                break;
                            }
                            default: {
                                throw new XMPexception("array '" + string + "' has has a wrong data type for acc replicate");
                            }
                        }
                        xobject = ident.Ref();
                        xobject2 = Xcons.binaryOp(Xcode.MUL_EXPR, Xcons.LongLongConstant(0L, XMPutil.getArrayElmtCount(arrayType)), Xcons.SizeOf(((ArrayType)xtype).getArrayElementType()));
                        break;
                    }
                    default: {
                        throw new XMPexception("'" + string + "' has a wrong data type for acc replicate");
                    }
                }
                blockList2.add(xMPglobalDecl.createFuncCallBlock("_XMP_gpu_init_data_NOT_ALIGNED", Xcons.List(ident2.getAddr(), ident4.getAddr(), xobject, xobject2)));
            } else {
                ident3 = blockList4.declLocalIdent("_XMP_GPU_DEVICE_DESC_" + string, Xtype.voidPtrType);
                blockList2.add(xMPglobalDecl.createFuncCallBlock("_XMP_gpu_init_data_ALIGNED", Xcons.List(ident2.getAddr(), ident3.getAddr(), ident4.getAddr(), xMPalignedArray.getAddrIdVoidRef(), xMPalignedArray.getDescId().Ref())));
            }
            blockList3.add(xMPglobalDecl.createFuncCallBlock("_XMP_gpu_finalize_data", Xcons.List(ident2.Ref())));
            xMPgpuDataTable.putXMPgpuData(new XMPgpuData(string, ident2, ident, ident3, ident4, xMPalignedArray));
        }
        blockList4.add(Bcons.COMPOUND(blockList2));
        blockList4.add(Bcons.COMPOUND(blockList));
        blockList4.add(Bcons.COMPOUND(blockList3));
        object = Bcons.COMPOUND(blockList4);
        ((PropObject)object).setProp(XMPgpuDataTable.PROP, xMPgpuDataTable);
        pragmaBlock.replace((Block)object);
    }

    public static void translateGpuSync(PragmaBlock pragmaBlock, XMPglobalDecl xMPglobalDecl) throws XMPexception {
        if (!XmOption.isXcalableMPGPU()) {
            XMP.warning("use -enable-gpu option to use 'acc replicate_sync' directive");
            return;
        }
        XobjList xobjList = (XobjList)pragmaBlock.getClauses();
        XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(pragmaBlock);
        BlockList blockList = Bcons.emptyBody();
        for (XobjArgs xobjArgs = xobjList.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            XobjList xobjList2 = (XobjList)xobjArgs.getArg();
            XobjInt xobjInt = null;
            String string = xobjList2.getArg(0).getString();
            if (string.equals("in")) {
                xobjInt = Xcons.IntConstant(GPU_SYNC_IN);
            } else if (string.equals("out")) {
                xobjInt = Xcons.IntConstant(GPU_SYNC_OUT);
            } else {
                throw new XMPexception("unknown clause for 'acc replicate_sync'");
            }
            XobjList xobjList3 = (XobjList)xobjList2.getArg(1);
            for (XobjArgs xobjArgs2 = xobjList3.getArgs(); xobjArgs2 != null; xobjArgs2 = xobjArgs2.nextArgs()) {
                String string2 = xobjArgs2.getArg().getString();
                XMPgpuData xMPgpuData = XMPgpuDataTable.findXMPgpuData(string2, pragmaBlock);
                if (xMPgpuData == null) {
                    throw new XMPexception("acc replicate '" + string2 + "' is not declared");
                }
                blockList.add(xMPglobalDecl.createFuncCallBlock("_XMP_gpu_sync", Xcons.List(xMPgpuData.getHostDescId().Ref(), xobjInt)));
            }
        }
        pragmaBlock.replace(Bcons.COMPOUND(blockList));
    }
}

