/*
 * Decompiled with CFR 0.152.
 */
package exc.xcalablemp;

import exc.block.Bcons;
import exc.block.Block;
import exc.object.FunctionType;
import exc.object.Ident;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectFile;
import exc.object.Xtype;
import exc.xcalablemp.XMP;
import exc.xcalablemp.XMPalignedArray;
import exc.xcalablemp.XMPcoarray;
import exc.xcalablemp.XMPexception;
import exc.xcalablemp.XMPlocalDecl;
import exc.xcalablemp.XMPnodes;
import exc.xcalablemp.XMPobject;
import exc.xcalablemp.XMPsymbolTable;
import exc.xcalablemp.XMPtemplate;
import xcodeml.util.XmOption;

public class XMPglobalDecl {
    private XobjectFile _env;
    private XMPsymbolTable _globalObjectTable;
    private XobjList _globalConstructorFuncBody;
    private XobjList _globalDestructorFuncBody;

    public XMPglobalDecl(XobjectFile xobjectFile) {
        this._env = xobjectFile;
        this._globalObjectTable = new XMPsymbolTable();
        this._globalConstructorFuncBody = Xcons.List();
        this._globalDestructorFuncBody = Xcons.List();
    }

    public void checkObjectNameCollision(String string) throws XMPexception {
        if (this._env.findVarIdent(string) != null) {
            throw new XMPexception("'" + string + "' is already declared");
        }
        if (this._globalObjectTable.getXMPobject(string) != null) {
            throw new XMPexception("'" + string + "' is already declared");
        }
        if (this._env.findVarIdent("_XMP_DESC_" + string) != null) {
            throw new XMPexception("cannot declare desciptor, '_XMP_DESC_" + string + "' is already declared");
        }
    }

    public XobjectFile getEnv() {
        return this._env;
    }

    public String genSym(String string) {
        return this._env.genSym(string);
    }

    public Ident getWorldDescId() {
        return this._env.declExternIdent("_XMP_world_nodes", Xtype.voidPtrType);
    }

    public Ident getWorldSizeId() {
        return this._env.declExternIdent("_XMP_world_size", Xtype.intType);
    }

    public Ident getWorldRankId() {
        return this._env.declExternIdent("_XMP_world_rank", Xtype.intType);
    }

    public void setupGlobalConstructor() {
        if (XmOption.tlogMPIisEnable()) {
            this._globalConstructorFuncBody.cons(Xcons.List(Xcode.EXPR_STATEMENT, this.declExternFunc("_XMP_tlog_init").Call(null)));
        }
        if (XmOption.isXcalableMPGPU()) {
            this._globalConstructorFuncBody.cons(Xcons.List(Xcode.EXPR_STATEMENT, this.declExternFunc("_XMP_gpu_init").Call(null)));
        }
        if (XmOption.isXcalableMPthreads()) {
            this._globalConstructorFuncBody.cons(Xcons.List(Xcode.EXPR_STATEMENT, this.declExternFunc("_XMP_threads_init").Call(null)));
        }
        String string = this._env.getSourceFileName();
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(47);
        String string2 = string.substring(n2 + 1, n);
        string2 = "xmpc_traverse_init_file_" + string2;
        FunctionType functionType = Xtype.Function(Xtype.voidType);
        Ident ident = this._env.declExternIdent(string2, functionType);
        this._env.add(XobjectDef.Func(ident, null, null, Xcons.List(Xcode.COMPOUND_STATEMENT, new Xobject[]{null, null, this._globalConstructorFuncBody})));
    }

    public void setupGlobalDestructor() {
        if (XmOption.tlogMPIisEnable()) {
            this._globalDestructorFuncBody.add(Xcons.List(Xcode.EXPR_STATEMENT, this.declExternFunc("_XMP_tlog_finalize").Call(null)));
        }
        if (XmOption.isXcalableMPGPU()) {
            this._globalDestructorFuncBody.add(Xcons.List(Xcode.EXPR_STATEMENT, this.declExternFunc("_XMP_gpu_finalize").Call(null)));
        }
        if (XmOption.isXcalableMPthreads()) {
            this._globalDestructorFuncBody.add(Xcons.List(Xcode.EXPR_STATEMENT, this.declExternFunc("_XMP_threads_finalize").Call(null)));
        }
        FunctionType functionType = Xtype.Function(Xtype.voidType);
        String string = this._env.getSourceFileName();
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(47);
        String string2 = string.substring(n2 + 1, n);
        string2 = "xmpc_traverse_finalize_file_" + string2;
        Ident ident = this._env.declExternIdent(string2, functionType);
        this._env.add(XobjectDef.Func(ident, null, null, Xcons.List(Xcode.COMPOUND_STATEMENT, new Xobject[]{null, null, this._globalDestructorFuncBody})));
    }

    public Ident declExternFunc(String string) {
        return XMP.getMacroId(string, Xtype.voidType);
    }

    public Ident declExternFunc(String string, Xtype xtype) {
        return XMP.getMacroId(string, xtype);
    }

    public void addGlobalInitFuncCall(String string, Xobject xobject) {
        Ident ident = this.declExternFunc(string);
        this._globalConstructorFuncBody.add(Xcons.List(Xcode.EXPR_STATEMENT, ident.Call(xobject)));
    }

    public void addGlobalFinalizeFuncCall(String string, Xobject xobject) {
        Ident ident = this.declExternFunc(string);
        this._globalDestructorFuncBody.add(Xcons.List(Xcode.EXPR_STATEMENT, ident.Call(xobject)));
    }

    public Ident declGlobalIdent(String string, Xtype xtype) {
        return this._env.declGlobalIdent(string, xtype);
    }

    public Ident declStaticIdent(String string, Xtype xtype) {
        return this._env.declStaticIdent(string, xtype);
    }

    public Ident declExternIdent(String string, Xtype xtype) {
        return this._env.declExternIdent(string, xtype);
    }

    public Ident findVarIdent(String string) {
        return this._env.findVarIdent(string);
    }

    public Block createFuncCallBlock(String string, XobjList xobjList) {
        Ident ident = this.declExternFunc(string);
        return Bcons.Statement(ident.Call(xobjList));
    }

    public void putXMPobject(XMPobject xMPobject) {
        this._globalObjectTable.putXMPobject(xMPobject);
    }

    public XMPobject getXMPobject(String string) {
        return this._globalObjectTable.getXMPobject(string);
    }

    public XMPobject getXMPobject(String string, Block block) {
        Object object;
        XMPobject xMPobject = null;
        for (object = block; object != null; object = ((Block)object).getParentBlock()) {
            XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable2((Block)object);
            if (xMPsymbolTable != null) {
                xMPobject = xMPsymbolTable.getXMPobject(string);
            }
            if (xMPobject == null) continue;
            return xMPobject;
        }
        object = XMPlocalDecl.getXMPsymbolTable(block);
        if (object != null) {
            xMPobject = ((XMPsymbolTable)object).getXMPobject(string);
        }
        if (xMPobject != null) {
            return xMPobject;
        }
        xMPobject = this.getXMPobject(string);
        if (xMPobject != null) {
            return xMPobject;
        }
        return null;
    }

    public XMPnodes getXMPnodes(String string) {
        return this._globalObjectTable.getXMPnodes(string);
    }

    public XMPnodes getXMPnodes(String string, Block block) {
        Object object;
        XMPnodes xMPnodes = null;
        for (object = block; object != null; object = ((Block)object).getParentBlock()) {
            XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable2((Block)object);
            if (xMPsymbolTable != null) {
                xMPnodes = xMPsymbolTable.getXMPnodes(string);
            }
            if (xMPnodes == null) continue;
            return xMPnodes;
        }
        object = XMPlocalDecl.getXMPsymbolTable(block);
        if (object != null) {
            xMPnodes = ((XMPsymbolTable)object).getXMPnodes(string);
        }
        if (xMPnodes != null) {
            return xMPnodes;
        }
        xMPnodes = this.getXMPnodes(string);
        if (xMPnodes != null) {
            return xMPnodes;
        }
        return null;
    }

    public XMPtemplate getXMPtemplate(String string) {
        return this._globalObjectTable.getXMPtemplate(string);
    }

    public XMPtemplate getXMPtemplate(String string, Block block) {
        Object object;
        XMPtemplate xMPtemplate = null;
        for (object = block; object != null; object = ((Block)object).getParentBlock()) {
            XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable2((Block)object);
            if (xMPsymbolTable != null) {
                xMPtemplate = xMPsymbolTable.getXMPtemplate(string);
            }
            if (xMPtemplate == null) continue;
            return xMPtemplate;
        }
        object = XMPlocalDecl.getXMPsymbolTable(block);
        if (object != null) {
            xMPtemplate = ((XMPsymbolTable)object).getXMPtemplate(string);
        }
        if (xMPtemplate != null) {
            return xMPtemplate;
        }
        xMPtemplate = this.getXMPtemplate(string);
        if (xMPtemplate != null) {
            return xMPtemplate;
        }
        return null;
    }

    public void putXMPalignedArray(XMPalignedArray xMPalignedArray) {
        this._globalObjectTable.putXMPalignedArray(xMPalignedArray);
    }

    public XMPalignedArray getXMPalignedArray(String string) {
        return this._globalObjectTable.getXMPalignedArray(string);
    }

    public XMPalignedArray getXMPalignedArray(String string, Block block) {
        Object object;
        XMPalignedArray xMPalignedArray = null;
        Ident ident = block != null ? block.findVarIdent(string) : this.findVarIdent(string);
        for (object = block; object != null; object = ((Block)object).getParentBlock()) {
            XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable2((Block)object);
            if (xMPsymbolTable != null) {
                xMPalignedArray = xMPsymbolTable.getXMPalignedArray(string);
            }
            if (xMPalignedArray == null || ident != null && xMPalignedArray.getArrayId() != ident) continue;
            return xMPalignedArray;
        }
        object = XMPlocalDecl.getXMPsymbolTable(block);
        if (object != null) {
            xMPalignedArray = ((XMPsymbolTable)object).getXMPalignedArray(string);
        }
        if (xMPalignedArray != null && xMPalignedArray.getArrayId() == ident) {
            return xMPalignedArray;
        }
        xMPalignedArray = this.getXMPalignedArray(string);
        if (xMPalignedArray != null && xMPalignedArray.getArrayId() == ident) {
            return xMPalignedArray;
        }
        return null;
    }

    public void putXMPcoarray(XMPcoarray xMPcoarray) {
        this._globalObjectTable.putXMPcoarray(xMPcoarray);
    }

    public XMPcoarray getXMPcoarray(String string) {
        return this._globalObjectTable.getXMPcoarray(string);
    }

    public XMPcoarray getXMPcoarray(String string, Block block) {
        Object object;
        XMPcoarray xMPcoarray = null;
        for (object = block; object != null; object = ((Block)object).getParentBlock()) {
            XMPsymbolTable xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable2((Block)object);
            if (xMPsymbolTable != null) {
                xMPcoarray = xMPsymbolTable.getXMPcoarray(string);
            }
            if (xMPcoarray == null) continue;
            return xMPcoarray;
        }
        object = XMPlocalDecl.getXMPsymbolTable(block);
        if (object != null) {
            xMPcoarray = ((XMPsymbolTable)object).getXMPcoarray(string);
        }
        if (xMPcoarray != null) {
            return xMPcoarray;
        }
        xMPcoarray = this.getXMPcoarray(string);
        if (xMPcoarray != null) {
            return xMPcoarray;
        }
        return null;
    }

    public void finalizeGlobalDecl() {
        this._env.collectAllTypes();
        this._env.fixupTypeRef();
    }
}

