/*
 * Decompiled with CFR 0.152.
 */
package exc.xcalablemp;

import exc.object.Ident;
import exc.object.PointerType;
import exc.object.PropObject;
import exc.object.StorageClass;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.XobjectDefEnv;
import exc.object.Xtype;
import exc.xcalablemp.XMP;
import exc.xcalablemp.XMPexception;
import exc.xcalablemp.XMPglobalDecl;
import exc.xcalablemp.XMPsymbolTable;
import exc.xcalablemp.XMPutil;
import java.util.Vector;

public class XMPcoarray {
    public static final int ASTERISK = -1;
    public static final int ACC_BIT_XOR = 1;
    private String _name;
    private Xtype _elmtType;
    private int _varDim;
    private Vector<Long> _sizeVector;
    private int _imageDim;
    private Vector<Integer> _imageVector;
    private Xobject _varAddr;
    private Ident _varId;
    private Ident _descId;

    public XMPcoarray(String string, Xtype xtype, int n, Vector<Long> vector, int n2, Vector<Integer> vector2, Xobject xobject, Ident ident, Ident ident2) {
        this._name = string;
        this._elmtType = xtype;
        this._varDim = n;
        this._sizeVector = vector;
        this._imageDim = n2;
        this._imageVector = vector2;
        this._varAddr = xobject;
        this._varId = ident;
        this._descId = ident2;
    }

    public String getName() {
        return this._name;
    }

    public Xtype getElmtType() {
        return this._elmtType;
    }

    public int getVarDim() {
        return this._varDim;
    }

    public long getSizeAt(int n) {
        return this._sizeVector.get(n).intValue();
    }

    public int getImageDim() {
        return this._imageDim;
    }

    public int getImageAt(int n) {
        return this._imageVector.get(n);
    }

    public Xobject getVarAddr() {
        return this._varAddr;
    }

    public Ident getVarId() {
        return this._varId;
    }

    public Ident getDescId() {
        return this._descId;
    }

    public static void translateCoarray(XobjList xobjList, XMPglobalDecl xMPglobalDecl, boolean bl, XMPsymbolTable xMPsymbolTable) throws XMPexception {
        String string = xobjList.getArg(0).getString();
        if (xMPglobalDecl.getXMPcoarray(string) != null) {
            throw new XMPexception("coarray " + string + " is already declared");
        }
        if (xMPglobalDecl.getXMPalignedArray(string) != null) {
            throw new XMPexception("an aligned array cannot be declared as a coarray");
        }
        Ident ident = xMPglobalDecl.findVarIdent(string);
        if (ident == null) {
            throw new XMPexception("coarray '" + string + "' is not declared");
        }
        XobjList xobjList2 = (XobjList)xobjList.getArg(1);
        XMPcoarray.translateCoarray_core(ident, string, xobjList2, xMPglobalDecl, bl);
    }

    public static void translateCoarray_core(Ident ident, String string, XobjList xobjList, XMPglobalDecl xMPglobalDecl, boolean bl) throws XMPexception {
        Ident ident2;
        Ident ident3;
        Ident ident4;
        PropObject propObject;
        Object object;
        boolean bl2 = true;
        if (ident.getStorageClass() == StorageClass.EXTERN) {
            bl2 = false;
        }
        int n = XMPutil.countElmts(xobjList);
        boolean bl3 = false;
        int n2 = 0;
        Xtype xtype = null;
        Xtype xtype2 = ident.Type();
        Xobject xobject = null;
        if (xtype2.getKind() == 6) {
            bl3 = true;
            n2 = xtype2.getNumDimensions();
            xtype = xtype2.getArrayElementType();
            xobject = ident.Ref();
        } else {
            n2 = 1;
            xtype = xtype2;
            xobject = ident.getAddr();
        }
        Xobject xobject2 = null;
        xobject2 = xtype.getKind() == 1 ? XMP.createBasicTypeConstantObj(xtype) : Xcons.IntConstant(599);
        XobjList xobjList2 = xobjList;
        int n3 = xobjList2.Nargs();
        if (n3 > 7) {
            throw new XMPexception("coarray dimension should be less than 8");
        }
        String string2 = new String("_XMP_coarray_malloc_info_");
        string2 = string2 + Integer.toString(n2);
        XobjList xobjList3 = Xcons.List();
        XobjList xobjList4 = Xcons.List();
        Vector<Long> vector = new Vector<Long>(n2);
        if (!bl3) {
            vector.add(new Long(1L));
            object = Xcons.Cast(Xtype.unsignedType, Xcons.LongLongConstant(0L, 1L));
            xobjList3.add((Xobject)object);
            xobjList4.add((Xobject)object);
        } else {
            int n4 = 0;
            while (n4 < n2) {
                long l = xtype2.getArraySize();
                if (l == 0L || l == -1L) {
                    throw new XMPexception("array size should be declared statically");
                }
                vector.add(new Long(l));
                propObject = Xcons.Cast(Xtype.unsignedType, Xcons.LongLongConstant(0L, l));
                xobjList3.add((Xobject)propObject);
                xobjList4.add((Xobject)propObject);
                ++n4;
                xtype2 = xtype2.getRef();
            }
        }
        xobjList3.add(Xcons.SizeOf(xtype));
        if (bl2) {
            xMPglobalDecl.addGlobalInitFuncCall(string2, xobjList3);
        }
        if (bl2) {
            string2 = new String("_XMP_coarray_malloc_image_info_");
            string2 = string2 + Integer.toString(n);
            xobjList3 = Xcons.List();
            for (int i = 0; i < n - 1; ++i) {
                xobjList3.add(xobjList.getArg(i));
            }
            xMPglobalDecl.addGlobalInitFuncCall(string2, xobjList3);
        }
        object = new Vector(n);
        for (int i = 0; i < n - 1; ++i) {
            ((Vector)object).add(xobjList.getArg(i).getInt());
        }
        ((Vector)object).add(-1);
        string2 = new String("_XMP_coarray_malloc");
        if (ident.getStorageClass() == StorageClass.EXTERN) {
            ident4 = xMPglobalDecl.declExternIdent("_XMP_COARRAY_DESC_" + string, Xtype.voidPtrType);
            ident3 = xMPglobalDecl.declExternIdent("_XMP_COARRAY_ADDR_" + string, new PointerType(xtype));
        } else if (ident.getStorageClass() == StorageClass.STATIC) {
            ident4 = xMPglobalDecl.declStaticIdent("_XMP_COARRAY_DESC_" + string, Xtype.voidPtrType);
            ident3 = xMPglobalDecl.declStaticIdent("_XMP_COARRAY_ADDR_" + string, new PointerType(xtype));
        } else if (ident.getStorageClass() == StorageClass.EXTDEF) {
            ident4 = xMPglobalDecl.declGlobalIdent("_XMP_COARRAY_DESC_" + string, Xtype.voidPtrType);
            ident3 = xMPglobalDecl.declGlobalIdent("_XMP_COARRAY_ADDR_" + string, new PointerType(xtype));
        } else {
            throw new XMPexception("cannot coarray '" + string + "', wrong storage class");
        }
        xobjList3 = Xcons.List(ident4.getAddr(), ident3.getAddr());
        if (bl2) {
            xMPglobalDecl.addGlobalInitFuncCall(string2, xobjList3);
        }
        if ((ident2 = ((XobjectDefEnv)(propObject = xMPglobalDecl.getEnv())).findIdent("xmp_lock_t", 3)) != null && ident2.Type() == xtype) {
            string2 = new String("_XMP_lock_initialize_");
            string2 = string2 + Integer.toString(n2);
            xobjList4.insert(ident3);
            if (bl2) {
                xMPglobalDecl.addGlobalInitFuncCall(string2, xobjList4);
            }
        }
        XMPcoarray xMPcoarray = new XMPcoarray(string, xtype, n2, vector, n, (Vector<Integer>)object, xobject, ident, ident4);
        xMPglobalDecl.putXMPcoarray(xMPcoarray);
    }
}

