/*
 * Decompiled with CFR 0.152.
 */
package exc.xcalablemp;

import exc.block.Block;
import exc.block.PragmaBlock;
import exc.object.ArrayType;
import exc.object.Ident;
import exc.object.StorageClass;
import exc.object.VarScope;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.xcalablemp.XMP;
import exc.xcalablemp.XMPexception;
import exc.xcalablemp.XMPglobalDecl;
import exc.xcalablemp.XMPlocalDecl;
import exc.xcalablemp.XMPnodes;
import exc.xcalablemp.XMPshadow;
import exc.xcalablemp.XMPsymbolTable;
import exc.xcalablemp.XMPtemplate;
import exc.xcalablemp.XMPutil;
import java.util.Vector;

public class XMPalignedArray {
    public static final int NOT_ALIGNED = 200;
    public static final int DUPLICATION = 201;
    public static final int BLOCK = 202;
    public static final int CYCLIC = 203;
    public static final int BLOCK_CYCLIC = 204;
    public static final int GBLOCK = 205;
    private String _name;
    private Xtype _type;
    private ArrayType _arrayType;
    private int _dim;
    private Vector<XMPshadow> _shadowVector;
    private Vector<Integer> _alignMannerVector;
    private Vector<Ident> _accIdVector;
    private Vector<Ident> _gtolTemp0IdVector;
    private Vector<Integer> _alignSubscriptIndexVector;
    private Vector<Xobject> _alignSubscriptExprVector;
    private Vector<Xobject> _alignNormExprVector;
    private Ident _arrayId;
    private Ident _descId;
    private Ident _addrId;
    private Ident _multiAddrId = null;
    private boolean _hasShadow;
    private boolean _reallocChecked;
    private boolean _realloc;
    private XMPtemplate _alignTemplate;
    private boolean _isParameter;
    private boolean _isLocal;
    private boolean _isPointer;
    private boolean _isStaticDesc = false;
    private Ident _flagId = null;
    private boolean _canOptimized = false;

    public void setMultiArrayId(Ident ident) {
        this._multiAddrId = ident;
    }

    public Ident getMultiArrayId() {
        return this._multiAddrId;
    }

    public boolean canOptimized() {
        return this._canOptimized;
    }

    public void setOptimized(boolean bl) {
        this._canOptimized = bl;
    }

    public static int convertDistMannerToAlignManner(int n) throws XMPexception {
        switch (n) {
            case 100: {
                return 201;
            }
            case 101: {
                return 202;
            }
            case 102: {
                return 203;
            }
            case 103: {
                return 204;
            }
            case 104: {
                return 205;
            }
        }
        throw new XMPexception("unknown dist manner");
    }

    public XMPalignedArray(String string, Xtype xtype, ArrayType arrayType, int n, Vector<Ident> vector, Ident ident, Ident ident2, Ident ident3, XMPtemplate xMPtemplate) {
        this._name = string;
        this._type = xtype;
        this._arrayType = arrayType;
        this._dim = n;
        this._shadowVector = new Vector(7);
        this._alignMannerVector = new Vector(7);
        this._accIdVector = vector;
        this._gtolTemp0IdVector = new Vector(7);
        this._alignSubscriptIndexVector = new Vector(7);
        this._alignSubscriptExprVector = new Vector(7);
        this._alignNormExprVector = new Vector(7);
        for (int i = 0; i < n; ++i) {
            this._shadowVector.add(new XMPshadow(400, null, null));
            this._alignMannerVector.add(null);
            this._gtolTemp0IdVector.add(null);
            this._alignSubscriptIndexVector.add(null);
            this._alignSubscriptExprVector.add(null);
            this._alignNormExprVector.add(null);
        }
        this._arrayId = ident;
        this._descId = ident2;
        this._addrId = ident3;
        this._hasShadow = false;
        this._reallocChecked = false;
        this._alignTemplate = xMPtemplate;
        this._isParameter = false;
        this._isLocal = false;
        this._isPointer = false;
    }

    public String getName() {
        return this._name;
    }

    public Xtype getType() {
        return this._type;
    }

    public Xtype getArrayType() {
        return this._arrayType;
    }

    public int getDim() {
        return this._dim;
    }

    public void setAlignMannerAt(int n, int n2) {
        this._alignMannerVector.setElementAt(new Integer(n), n2);
    }

    public int getAlignMannerAt(int n) {
        return this._alignMannerVector.get(n);
    }

    public String getAlignMannerStringAt(int n) throws XMPexception {
        switch (this.getAlignMannerAt(n)) {
            case 200: {
                return new String("NOT_ALIGNED");
            }
            case 201: {
                return new String("DUPLICATION");
            }
            case 202: {
                return new String("BLOCK");
            }
            case 203: {
                return new String("CYCLIC");
            }
            case 204: {
                return new String("BLOCK_CYCLIC");
            }
            case 205: {
                return new String("GBLOCK");
            }
        }
        throw new XMPexception("unknown align manner");
    }

    public Vector<Ident> getAccIdVector() {
        return this._accIdVector;
    }

    public Ident getAccIdAt(int n) {
        return this._accIdVector.get(n);
    }

    public void setGtolTemp0IdAt(Ident ident, int n) {
        this._gtolTemp0IdVector.setElementAt(ident, n);
    }

    public Ident getGtolTemp0IdAt(int n) {
        return this._gtolTemp0IdVector.get(n);
    }

    public void setAlignSubscriptIndexAt(int n, int n2) {
        this._alignSubscriptIndexVector.setElementAt(new Integer(n), n2);
    }

    public Integer getAlignSubscriptIndexAt(int n) {
        return this._alignSubscriptIndexVector.get(n);
    }

    public void setAlignSubscriptExprAt(Xobject xobject, int n) {
        this._alignSubscriptExprVector.setElementAt(xobject, n);
    }

    public Xobject getAlignSubscriptExprAt(int n) {
        return this._alignSubscriptExprVector.get(n);
    }

    public void setAlignNormExprAt(Xobject xobject, int n) {
        this._alignNormExprVector.setElementAt(xobject, n);
    }

    public Xobject getAlignNormExprAt(int n) {
        return this._alignNormExprVector.get(n);
    }

    public Ident getArrayId() {
        return this._arrayId;
    }

    public Ident getDescId() {
        return this._descId;
    }

    public Ident getAddrId() {
        return this._addrId;
    }

    public Xobject getAddrIdVoidRef() {
        return Xcons.Cast(Xtype.voidPtrType, this._addrId.Ref());
    }

    public Xobject getAddrIdVoidAddr() {
        return Xcons.Cast(Xtype.Pointer(Xtype.voidPtrType), this._addrId.getAddr());
    }

    public void setHasShadow() {
        this._hasShadow = true;
    }

    public boolean hasShadow() {
        return this._hasShadow;
    }

    public void setIsParameter() {
        this._isParameter = true;
    }

    public boolean isParameter() {
        return this._isParameter;
    }

    public void setIsLocal() {
        this._isLocal = true;
    }

    public boolean isLocal() {
        return this._isLocal;
    }

    public void setIsPointer() {
        this._isPointer = true;
    }

    public boolean isPointer() {
        return this._isPointer;
    }

    public void setShadowAt(XMPshadow xMPshadow, int n) {
        this._shadowVector.setElementAt(xMPshadow, n);
    }

    public XMPshadow getShadowAt(int n) {
        return this._shadowVector.get(n);
    }

    public XMPtemplate getAlignTemplate() {
        return this._alignTemplate;
    }

    public void setIsStaticDesc(boolean bl) {
        this._isStaticDesc = bl;
    }

    public boolean isStaticDesc() {
        return this._isStaticDesc;
    }

    public void setFlagId(Ident ident) {
        this._flagId = ident;
    }

    public Ident getFlagId() {
        return this._flagId;
    }

    public boolean checkRealloc() throws XMPexception {
        if (this._reallocChecked) {
            return this._realloc;
        }
        if (this._hasShadow) {
            block12: for (int i = 0; i < this._dim; ++i) {
                switch (this.getAlignMannerAt(i)) {
                    case 200: 
                    case 201: {
                        continue block12;
                    }
                    case 202: 
                    case 203: 
                    case 204: 
                    case 205: {
                        XMPshadow xMPshadow = this.getShadowAt(i);
                        switch (xMPshadow.getType()) {
                            case 402: {
                                continue block12;
                            }
                            case 400: 
                            case 401: {
                                this._reallocChecked = true;
                                this._realloc = true;
                                return this._realloc;
                            }
                        }
                        throw new XMPexception("unknown shadow type");
                    }
                    default: {
                        throw new XMPexception("unknown align manner");
                    }
                }
            }
            this._reallocChecked = true;
            this._realloc = false;
            return this._realloc;
        }
        block13: for (int i = 0; i < this._dim; ++i) {
            switch (this.getAlignMannerAt(i)) {
                case 200: 
                case 201: {
                    continue block13;
                }
                case 202: 
                case 203: 
                case 204: 
                case 205: {
                    this._reallocChecked = true;
                    this._realloc = true;
                    return this._realloc;
                }
                default: {
                    throw new XMPexception("unknown align manner");
                }
            }
        }
        this._reallocChecked = true;
        this._realloc = false;
        return this._realloc;
    }

    public boolean realloc() throws XMPexception {
        if (this._reallocChecked) {
            return this._realloc;
        }
        return this.checkRealloc();
    }

    public void normArraySize(int n, Xobject xobject) throws XMPexception {
        ArrayType arrayType = this._arrayType;
        for (int i = 0; i < n; ++i) {
            arrayType = (ArrayType)arrayType.getRef();
        }
        long l = arrayType.getArraySize();
        if (l == -1L) {
            arrayType.setArraySizeExpr(Xcons.binaryOp(Xcode.PLUS_EXPR, arrayType.getArraySizeExpr(), xobject));
        } else {
            arrayType.setArraySize(-1L);
            arrayType.setArraySizeExpr(Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.LongLongConstant(0L, l), xobject));
        }
    }

    private static Boolean is_SameSizeTemplateArray(XMPalignedArray xMPalignedArray) throws XMPexception {
        XMPtemplate xMPtemplate = xMPalignedArray.getAlignTemplate();
        int n = xMPalignedArray.getDim();
        Xtype xtype = xMPalignedArray.getArrayType();
        int n2 = 0;
        while (n2 < n) {
            if (xtype.getArraySize() == 0L) {
                return false;
            }
            switch (xMPalignedArray.getAlignMannerAt(n2)) {
                case 104: {
                    return false;
                }
                case 202: 
                case 203: 
                case 204: {
                    Xobject xobject = xtype.getArraySizeExpr();
                    if (!xobject.isConstant()) {
                        return false;
                    }
                    if (xobject.getLongHigh() != 0L) {
                        return false;
                    }
                    int n3 = xMPalignedArray.getAlignSubscriptIndexAt(n2);
                    int n4 = XMPutil.foldIntConstant(xMPtemplate.getSizeAt(n3)).getInt();
                    if ((int)xobject.getLongLow() == n4) break;
                    return false;
                }
            }
            ++n2;
            xtype = xtype.getRef();
        }
        return true;
    }

    private static Boolean is_divisible_size(XMPalignedArray xMPalignedArray) throws XMPexception {
        XMPtemplate xMPtemplate = xMPalignedArray.getAlignTemplate();
        XMPnodes xMPnodes = xMPtemplate.getOntoNodes();
        if (!XMPutil.is_AllConstant(xMPtemplate).booleanValue()) {
            return false;
        }
        if (!XMPutil.is_AllConstant(xMPnodes).booleanValue()) {
            return false;
        }
        if (!XMPalignedArray.is_SameSizeTemplateArray(xMPalignedArray).booleanValue()) {
            return false;
        }
        block4: for (int i = 0; i < xMPtemplate.getDim(); ++i) {
            int n = xMPtemplate.getDistMannerAt(i);
            switch (n) {
                case 104: {
                    return false;
                }
                case 101: 
                case 102: 
                case 103: {
                    int n2 = XMPutil.foldIntConstant(xMPtemplate.getSizeAt(i)).getInt();
                    int n3 = n == 103 ? XMPutil.foldIntConstant(xMPtemplate.getWidthAt(i)).getInt() : 1;
                    int n4 = xMPtemplate.getOntoNodesIndexAt(i).getInt();
                    int n5 = XMPutil.foldIntConstant(xMPnodes.getSizeAt(n4)).getInt();
                    if (n2 % (n5 * n3) == 0) continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void translateAlign(XobjList xobjList, XMPglobalDecl xMPglobalDecl, boolean bl, PragmaBlock pragmaBlock) throws XMPexception {
        Object object;
        String string;
        XobjArgs xobjArgs;
        Xobject xobject;
        int n;
        Xtype xtype;
        String string2 = xobjList.getArg(0).getString();
        XMPsymbolTable xMPsymbolTable = null;
        Ident ident = null;
        Block block = null;
        Boolean bl2 = false;
        boolean bl3 = false;
        Boolean bl4 = bl;
        if (bl) {
            ident = XMPlocalDecl.findLocalIdent(pragmaBlock, string2);
            if (ident != null) {
                bl4 = ident.getStorageClass() == StorageClass.PARAM;
            }
            block = pragmaBlock.getParentBlock();
            xMPsymbolTable = bl4 != false ? XMPlocalDecl.declXMPsymbolTable(pragmaBlock) : XMPlocalDecl.declXMPsymbolTable2(block);
            bl3 = XMPlocalDecl.declXMPsymbolTable2(block).isStaticDesc(string2);
        } else {
            ident = xMPglobalDecl.findVarIdent(string2);
        }
        if (ident == null) {
            throw new XMPexception("array '" + string2 + "' is not declared");
        }
        XMPalignedArray xMPalignedArray = null;
        xMPalignedArray = bl ? xMPsymbolTable.getXMPalignedArray(string2) : xMPglobalDecl.getXMPalignedArray(string2);
        if (xMPalignedArray != null) {
            throw new XMPexception("array '" + string2 + "' is already aligned");
        }
        Xtype xtype2 = ident.Type();
        if (xtype2.getKind() != 6) {
            if (xtype2.getKind() != 7) throw new XMPexception(string2 + " is neither an array nor pointer");
            bl2 = true;
            xtype2 = new ArrayType(xtype2.getRef(), 0L);
        }
        Xtype xtype3 = xtype2.getArrayElementType();
        Xobject xobject2 = null;
        xobject2 = xtype3.getKind() == 1 ? XMP.createBasicTypeConstantObj(xtype3) : Xcons.IntConstant(599);
        if (xMPglobalDecl.getXMPcoarray(string2, pragmaBlock) != null) {
            throw new XMPexception("array '" + string2 + "' is declared as a coarray, cannot be aligned");
        }
        String string3 = xobjList.getArg(2).getString();
        XMPtemplate xMPtemplate = xMPglobalDecl.getXMPtemplate(string3, pragmaBlock);
        if (xMPtemplate == null) {
            throw new XMPexception("template '" + string3 + "' is not declared");
        }
        if (!xMPtemplate.isDistributed()) {
            throw new XMPexception("template '" + string3 + "' is not distributed");
        }
        int n2 = xMPtemplate.getDim();
        Ident ident2 = ident;
        Ident ident3 = null;
        if (bl) {
            if (!bl2.booleanValue()) {
                ident2 = XMPlocalDecl.addObjectId2("_XMP_ADDR_" + string2, Xtype.Pointer(xtype3), block);
            } else {
                xtype = Xtype.Pointer(xtype3);
                ident2.setType(xtype);
                ident2.setValue(Xcons.Symbol(Xcode.VAR_ADDR, Xtype.Pointer(xtype), ident2.getSym(), VarScope.LOCAL));
            }
            ident3 = XMPlocalDecl.addObjectId2("_XMP_DESC_" + string2, block);
        } else {
            if (!bl2.booleanValue()) {
                if (ident.getStorageClass() == StorageClass.EXTERN) {
                    ident2 = xMPglobalDecl.declExternIdent("_XMP_ADDR_" + string2, Xtype.Pointer(xtype3));
                } else if (ident.getStorageClass() == StorageClass.STATIC) {
                    ident2 = xMPglobalDecl.declStaticIdent("_XMP_ADDR_" + string2, Xtype.Pointer(xtype3));
                } else {
                    if (ident.getStorageClass() != StorageClass.EXTDEF) throw new XMPexception("cannot align array '" + string2 + "', wrong storage class");
                    ident2 = xMPglobalDecl.declGlobalIdent("_XMP_ADDR_" + string2, Xtype.Pointer(xtype3));
                }
            } else {
                xtype = Xtype.Pointer(xtype3);
                ident2.setType(xtype);
                ident2.setValue(Xcons.Symbol(Xcode.VAR_ADDR, Xtype.Pointer(xtype), ident2.getSym(), VarScope.GLOBAL));
            }
            ident3 = xMPglobalDecl.declStaticIdent("_XMP_DESC_" + string2, Xtype.voidPtrType);
        }
        if (bl3) {
            ident3.setStorageClass(StorageClass.STATIC);
        }
        if ((n = xtype2.getNumDimensions()) > 7) {
            throw new XMPexception("array dimension should be less than 8");
        }
        XobjList xobjList2 = Xcons.List(ident3.getAddr(), xMPtemplate.getDescId().Ref(), Xcons.IntConstant(n), xobject2, Xcons.SizeOf(xtype3));
        Vector<Ident> vector = new Vector<Ident>(n);
        for (int i = 0; i < n; ++i) {
            xobject = null;
            if (bl) {
                xobject = XMPlocalDecl.addObjectId2("_XMP_GTOL_acc_" + string2 + "_" + i, Xtype.unsignedlonglongType, block);
                if (bl3) {
                    ((Ident)xobject).setStorageClass(StorageClass.STATIC);
                }
            } else {
                xobject = xMPglobalDecl.declStaticIdent("_XMP_GTOL_acc_" + string2 + "_" + i, Xtype.unsignedlonglongType);
            }
            vector.add((Ident)xobject);
        }
        xMPalignedArray = new XMPalignedArray(string2, xtype3, (ArrayType)xtype2, n, vector, ident, ident3, ident2, xMPtemplate);
        if (bl) {
            xMPalignedArray.setIsLocal();
            xMPalignedArray.setIsStaticDesc(bl3);
        }
        if (bl4.booleanValue()) {
            xMPalignedArray.setIsParameter();
        }
        if (bl2.booleanValue()) {
            xMPalignedArray.setIsPointer();
        }
        if (bl3 && bl2.booleanValue()) {
            throw new XMPexception("a pointer cannot have the static_desc attribute.");
        }
        if (bl) {
            if (bl3) {
                Ident ident4 = block.getBody().declLocalIdent("_XMP_STATIC_" + string2, Xtype.intType, StorageClass.STATIC, Xcons.IntConstant(0));
                xMPalignedArray.setFlagId(ident4);
                XMPlocalDecl.addConstructorCall2_staticDesc("_XMP_init_array_desc", xobjList2, xMPglobalDecl, block, ident4, false);
            } else {
                XMPlocalDecl.addConstructorCall2("_XMP_init_array_desc", xobjList2, xMPglobalDecl, block);
            }
            if (!bl3) {
                XMPlocalDecl.insertDestructorCall2("_XMP_finalize_array_desc", Xcons.List(ident3.Ref()), xMPglobalDecl, block);
            }
            xMPsymbolTable.putXMPalignedArray(xMPalignedArray);
        } else {
            xMPglobalDecl.addGlobalInitFuncCall("_XMP_init_array_desc", xobjList2);
            xMPglobalDecl.putXMPalignedArray(xMPalignedArray);
        }
        XobjList xobjList3 = (XobjList)xobjList.getArg(1);
        xobject = (XobjList)xobjList.getArg(3);
        XobjList xobjList4 = (XobjList)((XobjList)xobject).left();
        XobjList xobjList5 = (XobjList)((XobjList)xobject).right();
        if (xtype2.getRef().getKind() == 7) {
            throw new XMPexception("Pointer to pointer \"" + string2 + "\" can not be used.");
        }
        if (XMPutil.countElmts(xobjList3) != n) {
            throw new XMPexception("the number of <align-source>s is not the same with array dimension");
        }
        if (XMPutil.countElmts(xobjList3, "* @{ASTERISK}@") == n) {
            throw new XMPexception("array " + string2 + " is not aligned on any dimension");
        }
        if (XMPutil.countElmts(xobjList4) != n2) {
            throw new XMPexception("the number of <align-subscript>s is not the same with template dimension");
        }
        if (XMPutil.countElmts(xobjList3, ": @{COLON}@") != XMPutil.countElmts(xobjList4, ": @{COLON}@")) {
            throw new XMPexception("the number of ':' in <align-source> list is not the same with <align-subscript> list");
        }
        int n3 = 0;
        for (xobjArgs = xobjList3.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            int n4;
            string = xobjArgs.getArg().getString();
            if (string.equals("* @{ASTERISK}@")) {
                if (!bl2.booleanValue()) {
                    XMPalignedArray.declNotAlignFunc(xMPalignedArray, n3, xMPglobalDecl, bl, pragmaBlock);
                } else {
                    XMPalignedArray.declAlignFunc_pointer(xMPalignedArray, n3, null, -1, Xcons.IntConstant(0), xMPglobalDecl, bl, pragmaBlock);
                }
            } else if (string.equals(": @{COLON}@")) {
                if (!XMPutil.hasElmt(xobjList4, ": @{COLON}@")) {
                    throw new XMPexception("cannot find ':' in <align-subscript> list");
                }
                n4 = XMPutil.getLastIndex(xobjList4, ": @{COLON}@");
                xobjList4.setArg(n4, null);
                if (!bl2.booleanValue()) {
                    XMPalignedArray.declAlignFunc(xMPalignedArray, n3, xMPtemplate, n4, xobjList5.getArg(n4), xMPglobalDecl, bl, pragmaBlock);
                } else {
                    XMPalignedArray.declAlignFunc_pointer(xMPalignedArray, n3, xMPtemplate, n4, xobjList5.getArg(n4), xMPglobalDecl, bl, pragmaBlock);
                }
            } else {
                if (XMPutil.countElmts(xobjList3, string) != 1) {
                    throw new XMPexception("multiple '" + string + "' indicated in <align-source> list");
                }
                if (!XMPutil.hasElmt(xobjList4, string)) throw new XMPexception("cannot find '" + string + "' in <align-subscript> list");
                if (XMPutil.countElmts(xobjList4, string) != 1) {
                    throw new XMPexception("multiple '" + string + "' indicated in <align-subscript> list");
                }
                n4 = XMPutil.getFirstIndex(xobjList4, string);
                if (!bl2.booleanValue()) {
                    XMPalignedArray.declAlignFunc(xMPalignedArray, n3, xMPtemplate, n4, xobjList5.getArg(n4), xMPglobalDecl, bl, pragmaBlock);
                } else {
                    XMPalignedArray.declAlignFunc_pointer(xMPalignedArray, n3, xMPtemplate, n4, xobjList5.getArg(n4), xMPglobalDecl, bl, pragmaBlock);
                }
            }
            ++n3;
        }
        if (bl2.booleanValue()) {
            return;
        }
        for (xobjArgs = xobjList4.getArgs(); xobjArgs != null && !(string = xobjArgs.getArg().getString()).equals("* @{ASTERISK}@") && !string.equals(": @{COLON}@"); xobjArgs = xobjArgs.nextArgs()) {
            if (!XMPutil.hasElmt(xobjList3, string)) throw new XMPexception("cannot find '" + string + "' in <align-source> list");
            if (XMPutil.countElmts(xobjList3, string) == 1) continue;
            throw new XMPexception("no/multiple '" + string + "' indicated in <align-source> list");
        }
        int n5 = 0;
        while (n5 < n) {
            long l = xtype2.getArraySize();
            if (l == 0L) {
                throw new XMPexception("array size should be declared statically");
            }
            if (l == -1L) {
                xobjList2.add(Xcons.Cast(Xtype.intType, xtype2.getArraySizeExpr()));
            } else {
                xobjList2.add(Xcons.Cast(Xtype.intType, Xcons.LongLongConstant(0L, l)));
            }
            ++n5;
            xtype2 = xtype2.getRef();
        }
        XobjList xobjList6 = Xcons.List(xMPalignedArray.getDescId().Ref());
        for (object = xobjList4.getArgs(); object != null; object = ((XobjArgs)object).nextArgs()) {
            String string4 = ((XobjArgs)object).getArg().getString();
            if (string4.equals("* @{ASTERISK}@")) {
                xobjList6.add(Xcons.IntConstant(1));
                continue;
            }
            xobjList6.add(Xcons.IntConstant(0));
        }
        if (bl) {
            if (bl3) {
                XMPlocalDecl.addConstructorCall2_staticDesc("_XMP_init_array_comm", xobjList6, xMPglobalDecl, block, xMPalignedArray.getFlagId(), false);
                XMPlocalDecl.addConstructorCall2_staticDesc("_XMP_init_array_nodes", Xcons.List(xMPalignedArray.getDescId().Ref()), xMPglobalDecl, block, xMPalignedArray.getFlagId(), false);
            } else {
                XMPlocalDecl.addConstructorCall2("_XMP_init_array_comm", xobjList6, xMPglobalDecl, block);
                XMPlocalDecl.addConstructorCall2("_XMP_init_array_nodes", Xcons.List(xMPalignedArray.getDescId().Ref()), xMPglobalDecl, block);
            }
            if (bl4.booleanValue()) {
                object = Xcons.List(xMPalignedArray.getAddrIdVoidAddr(), ident.Ref(), ident3.Ref());
                for (int i = n - 1; i >= 0; --i) {
                    ((XobjList)object).add(Xcons.Cast(Xtype.Pointer(Xtype.unsignedlonglongType), xMPalignedArray.getAccIdAt(i).getAddr()));
                }
                XMPlocalDecl.addAllocCall2("_XMP_init_array_addr", (Xobject)object, xMPglobalDecl, block);
                XobjList xobjList7 = (XobjList)block.getProp("XCALABLEMP_PROP_LOCAL_ALLOC");
                if (bl3) {
                    xobjList7.add(Xcons.List(Xcode.EXPR_STATEMENT, Xcons.Set(xMPalignedArray.getFlagId().Ref(), Xcons.IntConstant(1))));
                }
            } else {
                object = ident.getStorageClass() == StorageClass.EXTDEF ? Xcons.IntConstant(1) : Xcons.IntConstant(0);
                XobjList xobjList8 = Xcons.List(new Xobject[]{xMPalignedArray.getAddrIdVoidAddr(), xMPalignedArray.getDescId().Ref(), object});
                for (int i = xMPalignedArray.getDim() - 1; i >= 0; --i) {
                    xobjList8.add(Xcons.Cast(Xtype.Pointer(Xtype.unsignedlonglongType), xMPalignedArray.getAccIdAt(i).getAddr()));
                }
                XMPlocalDecl.addAllocCall2("_XMP_alloc_array", xobjList8, xMPglobalDecl, block);
                XobjList xobjList9 = (XobjList)block.getProp("XCALABLEMP_PROP_LOCAL_ALLOC");
                if (bl3) {
                    xobjList9.add(Xcons.List(Xcode.EXPR_STATEMENT, Xcons.Set(xMPalignedArray.getFlagId().Ref(), Xcons.IntConstant(1))));
                }
                XMPlocalDecl.insertDestructorCall2("_XMP_dealloc_array", Xcons.List(xMPalignedArray.getDescId().Ref()), xMPglobalDecl, block);
            }
        } else {
            xMPglobalDecl.addGlobalInitFuncCall("_XMP_init_array_comm", xobjList6);
            xMPglobalDecl.addGlobalInitFuncCall("_XMP_init_array_nodes", Xcons.List(xMPalignedArray.getDescId().Ref()));
        }
        if (bl && !bl4.booleanValue()) {
            XMPlocalDecl.removeLocalIdent(pragmaBlock, string2);
        }
        if (n > 1 && XMPalignedArray.is_divisible_size(xMPalignedArray).booleanValue()) {
            xMPalignedArray.setOptimized(true);
            return;
        } else {
            xMPalignedArray.setOptimized(false);
        }
    }

    private static void declNotAlignFunc(XMPalignedArray xMPalignedArray, int n, XMPglobalDecl xMPglobalDecl, boolean bl, PragmaBlock pragmaBlock) throws XMPexception {
        XobjList xobjList = Xcons.List(xMPalignedArray.getDescId().Ref(), Xcons.IntConstant(n));
        xMPalignedArray.setAlignMannerAt(200, n);
        if (bl) {
            Block block = pragmaBlock.getParentBlock();
            if (xMPalignedArray.isStaticDesc()) {
                XMPlocalDecl.addConstructorCall2_staticDesc("_XMP_align_array_NOT_ALIGNED", xobjList, xMPglobalDecl, block, xMPalignedArray.getFlagId(), false);
            } else {
                XMPlocalDecl.addConstructorCall2("_XMP_align_array_NOT_ALIGNED", xobjList, xMPglobalDecl, block);
            }
        } else {
            xMPglobalDecl.addGlobalInitFuncCall("_XMP_align_array_NOT_ALIGNED", xobjList);
        }
    }

    private static Xobject normArray(XMPalignedArray xMPalignedArray, int n, XMPtemplate xMPtemplate, int n2, Xobject xobject, XMPglobalDecl xMPglobalDecl, boolean bl, PragmaBlock pragmaBlock) throws XMPexception {
        Xobject xobject2 = xMPtemplate.getLowerAt(n2);
        Xobject xobject3 = Xcons.binaryOp(Xcode.MINUS_EXPR, xobject, xobject2);
        xMPalignedArray.setAlignNormExprAt(xobject3, n);
        xMPalignedArray.normArraySize(n, xobject3);
        return xobject2;
    }

    private static void declAlignFunc(XMPalignedArray xMPalignedArray, int n, XMPtemplate xMPtemplate, int n2, Xobject xobject, XMPglobalDecl xMPglobalDecl, boolean bl, PragmaBlock pragmaBlock) throws XMPexception {
        Block block = null;
        if (bl) {
            block = pragmaBlock.getParentBlock();
        }
        xobject = XMPalignedArray.normArray(xMPalignedArray, n, xMPtemplate, n2, xobject, xMPglobalDecl, bl, pragmaBlock);
        XobjList xobjList = Xcons.List(xMPalignedArray.getDescId().Ref(), Xcons.IntConstant(n), Xcons.IntConstant(n2));
        xobjList.add(xobject);
        int n3 = xMPtemplate.getDistMannerAt(n2);
        xMPalignedArray.setAlignMannerAt(XMPalignedArray.convertDistMannerToAlignManner(n3), n);
        xMPalignedArray.setAlignSubscriptIndexAt(n2, n);
        xMPalignedArray.setAlignSubscriptExprAt(xobject, n);
        switch (n3) {
            case 100: {
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                Ident ident = null;
                if (bl) {
                    ident = XMPlocalDecl.addObjectId2("_XMP_GTOL_temp0_" + xMPalignedArray.getName() + "_" + n, Xtype.intType, block);
                    if (xMPalignedArray.isStaticDesc()) {
                        ident.setStorageClass(StorageClass.STATIC);
                    }
                } else {
                    ident = xMPglobalDecl.declStaticIdent("_XMP_GTOL_temp0_" + xMPalignedArray.getName() + "_" + n, Xtype.intType);
                }
                xMPalignedArray.setGtolTemp0IdAt(ident, n);
                xobjList.add(ident.getAddr());
                break;
            }
            default: {
                throw new XMPexception("unknown distribute manner");
            }
        }
        if (bl) {
            if (xMPalignedArray.isStaticDesc()) {
                XMPlocalDecl.addConstructorCall2_staticDesc("_XMP_align_array_" + xMPtemplate.getDistMannerStringAt(n2), xobjList, xMPglobalDecl, block, xMPalignedArray.getFlagId(), false);
            } else {
                XMPlocalDecl.addConstructorCall2("_XMP_align_array_" + xMPtemplate.getDistMannerStringAt(n2), xobjList, xMPglobalDecl, block);
            }
        } else {
            xMPglobalDecl.addGlobalInitFuncCall("_XMP_align_array_" + xMPtemplate.getDistMannerStringAt(n2), xobjList);
        }
    }

    private static void declAlignFunc_pointer(XMPalignedArray xMPalignedArray, int n, XMPtemplate xMPtemplate, int n2, Xobject xobject, XMPglobalDecl xMPglobalDecl, boolean bl, PragmaBlock pragmaBlock) throws XMPexception {
        Block block = null;
        if (bl) {
            block = pragmaBlock.getParentBlock();
        }
        XobjList xobjList = Xcons.List(xMPalignedArray.getDescId().Ref(), Xcons.IntConstant(n), Xcons.IntConstant(n2));
        xobjList.add(xobject);
        if (xMPtemplate != null) {
            int n3 = xMPtemplate.getDistMannerAt(n2);
            xMPalignedArray.setAlignMannerAt(XMPalignedArray.convertDistMannerToAlignManner(n3), n);
            xMPalignedArray.setAlignSubscriptIndexAt(n2, n);
            xMPalignedArray.setAlignSubscriptExprAt(xobject, n);
        } else {
            xMPalignedArray.setAlignMannerAt(200, n);
        }
        Ident ident = null;
        if (bl) {
            ident = XMPlocalDecl.addObjectId2("_XMP_GTOL_temp0_" + xMPalignedArray.getName() + "_" + n, Xtype.intType, block);
            if (xMPalignedArray.isStaticDesc()) {
                ident.setStorageClass(StorageClass.STATIC);
            }
        } else {
            ident = xMPglobalDecl.declStaticIdent("_XMP_GTOL_temp0_" + xMPalignedArray.getName() + "_" + n, Xtype.intType);
        }
        xMPalignedArray.setGtolTemp0IdAt(ident, n);
        xobjList.add(ident.getAddr());
        xobjList.add(Xcons.Cast(Xtype.Pointer(Xtype.unsignedlonglongType), xMPalignedArray.getAccIdAt(n).getAddr()));
        if (bl) {
            if (xMPalignedArray.isStaticDesc()) {
                XMPlocalDecl.addConstructorCall2_staticDesc("_XMP_align_array_noalloc", xobjList, xMPglobalDecl, block, xMPalignedArray.getFlagId(), false);
            } else {
                XMPlocalDecl.addConstructorCall2("_XMP_align_array_noalloc", xobjList, xMPglobalDecl, block);
            }
        } else {
            xMPglobalDecl.addGlobalInitFuncCall("_XMP_align_array_noalloc", xobjList);
        }
    }

    public static void translateLocalAlias(XobjList xobjList, XMPglobalDecl xMPglobalDecl, boolean bl, PragmaBlock pragmaBlock) throws XMPexception {
        String string;
        XMPsymbolTable xMPsymbolTable = null;
        if (bl) {
            xMPsymbolTable = XMPlocalDecl.declXMPsymbolTable(pragmaBlock);
        }
        if (XMPutil.findXMPalignedArray(string = xobjList.getArg(0).getString(), xMPglobalDecl, xMPsymbolTable) != null) {
            throw new XMPexception("array '" + string + "' is declared as an aligned array");
        }
        String string2 = xobjList.getArg(1).getString();
        XMPalignedArray xMPalignedArray = XMPutil.findXMPalignedArray(string2, xMPglobalDecl, xMPsymbolTable);
        if (xMPalignedArray == null) {
            throw new XMPexception("the aligned array '" + string2 + "' is not found");
        }
    }
}

