/*
 * Decompiled with CFR 0.152.
 */
package exc.xcalablemp;

import exc.object.Ident;
import exc.object.LineNo;
import exc.object.StorageClass;
import exc.object.VarScope;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.Xobject;
import exc.object.Xtype;
import xcodeml.util.ILineNo;
import xcodeml.util.XmLog;

public class XMP {
    public static final int MAX_DIM = 7;
    public static final int NONBASIC_TYPE = 599;
    public static final String TEMP_PREFIX = "_XMP_TEMP";
    public static final String DESC_PREFIX_ = "_XMP_DESC_";
    public static final String NODES_SIZE_PREFIX_ = "_XMP_NODES_SIZE_";
    public static final String NODES_RANK_PREFIX_ = "_XMP_NODES_RANK_";
    public static final String STATIC_DESC_PREFIX_ = "_XMP_STATIC_";
    public static final String GPU_HOST_DESC_PREFIX_ = "_XMP_GPU_HOST_DESC_";
    public static final String GPU_DEVICE_DESC_PREFIX_ = "_XMP_GPU_DEVICE_DESC_";
    public static final String GPU_DEVICE_ADDR_PREFIX_ = "_XMP_GPU_DEVICE_ADDR_";
    public static final String GPU_FUNC_PREFIX = "_XMP_GPU_FUNC";
    public static final String COARRAY_DESC_PREFIX_ = "_XMP_COARRAY_DESC_";
    public static final String COARRAY_ADDR_PREFIX_ = "_XMP_COARRAY_ADDR_";
    public static final String ADDR_PREFIX_ = "_XMP_ADDR_";
    public static final String MULTI_ADDR_PREFIX_ = "_XMP_MULTI_ADDR_";
    public static final String GTOL_PREFIX_ = "_XMP_GTOL_";
    public static final String ASTERISK = "* @{ASTERISK}@";
    public static final String COLON = ": @{COLON}@";
    private static boolean errorFlag = false;

    public static Xobject createBasicTypeConstantObj(Xtype xtype) {
        return Xcons.IntConstant(xtype.getBasicType() + 500);
    }

    public static void exitByError() {
        if (errorFlag) {
            System.exit(1);
        }
    }

    public static void error(LineNo lineNo, String string) {
        errorFlag = true;
        XmLog.error((ILineNo)lineNo, (String)("[XcalableMP] " + string));
    }

    public static void warning(String string) {
        XmLog.warning((String)("[XcalableMP] " + string));
    }

    public static void fatal(String string) {
        XmLog.fatal((String)("[XcalableMP] " + string));
    }

    public static void fatal(LineNo lineNo, String string) {
        XmLog.fatal((String)("[XcalableMP] " + lineNo + " : " + string));
    }

    public static Ident getMacroId(String string) {
        return new Ident(string, StorageClass.EXTERN, Xtype.Function(Xtype.voidType), Xcons.Symbol(Xcode.FUNC_ADDR, Xtype.Pointer(Xtype.Function(Xtype.voidType)), string), VarScope.GLOBAL);
    }

    public static Ident getMacroId(String string, Xtype xtype) {
        return new Ident(string, StorageClass.EXTERN, Xtype.Function(xtype), Xcons.Symbol(Xcode.FUNC_ADDR, Xtype.Pointer(Xtype.Function(xtype)), string), VarScope.GLOBAL);
    }
}

