/*
 * Decompiled with CFR 0.152.
 */
package exc.openmp;

import exc.object.Ident;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjInt;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.openmp.OMP;
import exc.openmp.OMPpragma;
import xcodeml.util.XmLog;
import xcodeml.util.XmOption;

public class OMPvar {
    OMPvar next;
    Ident id;
    Ident thdprv_local_id;
    OMPpragma atr;
    boolean is_shared;
    boolean is_private;
    boolean is_first_private;
    boolean is_last_private;
    boolean is_copy_private;
    boolean is_reduction;
    boolean is_copyin;
    OMPpragma reduction_op;
    private Xobject private_addr;
    private Xobject copy_private_addr;
    private Xobject shared_addr;
    private Xobject shared_array;
    private Xobject size_of_array;
    private static final String C_FLOAT_MAX_VALUE = "3.40282347E38";
    private static final String C_DOUBLE_MAX_VALUE = "1.797693134862315E308";
    private static final String F_REAL4_MAX_VALUE = "3.40282347E38";
    private static final String F_REAL8_MAX_VALUE = "1.797693134862315D308";
    private static final String F_REAL16_MAX_VALUE = "1.1897314953572317650857593266280070E4931_16";

    public OMPvar(Ident ident, OMPpragma oMPpragma) {
        this.id = ident;
        this.atr = oMPpragma;
        if (OMP.debugFlag) {
            System.out.println("OMPvar(" + ident.getName() + "," + oMPpragma.getName() + ")");
        }
        switch (oMPpragma) {
            case DATA_SHARED: {
                this.is_shared = true;
                break;
            }
            case DATA_PRIVATE: {
                this.is_private = true;
                break;
            }
            case DATA_COPYIN: {
                this.is_copyin = true;
                this.is_shared = true;
                break;
            }
            case DATA_FIRSTPRIVATE: {
                this.is_private = true;
                this.is_shared = true;
                this.is_first_private = true;
                break;
            }
            case DATA_LASTPRIVATE: {
                this.is_private = true;
                this.is_shared = true;
                this.is_last_private = true;
                break;
            }
            case DATA_COPYPRIVATE: {
                this.is_private = true;
                this.is_copy_private = true;
                break;
            }
            case _DATA_PRIVATE_SHARED: {
                this.is_private = true;
                this.is_shared = true;
                break;
            }
            default: {
                if (!oMPpragma.isDataReduction()) break;
                this.is_private = true;
                this.is_shared = true;
                this.is_reduction = true;
                this.reduction_op = oMPpragma;
            }
        }
    }

    Xobject getAddr() {
        if (this.private_addr != null) {
            return this.private_addr;
        }
        return this.shared_addr;
    }

    Xobject getPrivateAddr() {
        return this.private_addr;
    }

    void setPrivateAddr(Xobject xobject) {
        this.private_addr = xobject;
    }

    Xobject getCopyPrivateAddr() {
        return this.copy_private_addr;
    }

    void setCopyPrivateAddr(Xobject xobject) {
        this.copy_private_addr = xobject;
    }

    Xobject getSharedAddr() {
        return this.shared_addr;
    }

    void setSharedAddr(Xobject xobject) {
        this.shared_addr = xobject;
    }

    Xobject getSharedArray() {
        return this.shared_array;
    }

    void setSharedArray(Xobject xobject) {
        this.shared_array = xobject;
    }

    Xobject Ref() {
        return Xcons.PointerRef(this.getAddr());
    }

    Xobject SharedRef() {
        return Xcons.PointerRef(this.getSharedAddr());
    }

    Xobject getSize() {
        if (this.size_of_array == null) {
            return Xcons.SizeOf(this.id.Type());
        }
        return this.size_of_array;
    }

    void setSizeOfArray(Xobject xobject) {
        this.size_of_array = xobject;
    }

    public boolean isVariableArray() {
        return this.size_of_array != null;
    }

    public Ident getThdPrvLocalId() {
        return this.thdprv_local_id;
    }

    public void setThdPrvLocalId(Ident ident) {
        this.thdprv_local_id = ident;
    }

    private String getFloatMaxValue(Xtype xtype) {
        if (XmOption.isLanguageC()) {
            if (xtype.getBasicType() == 14) {
                return C_DOUBLE_MAX_VALUE;
            }
            return "3.40282347E38";
        }
        Xobject xobject = Xcons.Reduce(xtype.getFkind());
        int n = 4;
        if (xobject == null) {
            if (xtype.getBasicType() == 14) {
                n = 8;
            }
        } else if (xobject instanceof XobjInt) {
            n = xobject.getInt();
        } else {
            XmLog.fatal((String)("cannot reduce REAL kind : " + xobject));
        }
        switch (n) {
            case 4: {
                return "3.40282347E38";
            }
            case 8: {
                return F_REAL8_MAX_VALUE;
            }
            case 16: {
                return F_REAL16_MAX_VALUE;
            }
        }
        XmLog.fatal((String)("unsupported REAL kind : " + n));
        return null;
    }

    Xobject reductionInitValue() {
        Xtype xtype = this.id.Type();
        switch (this.reduction_op) {
            case DATA_REDUCTION_PLUS: 
            case DATA_REDUCTION_MINUS: {
                if (xtype.isFloating()) {
                    return Xcons.Float(Xcode.FLOAT_CONSTANT, xtype, 0.0);
                }
            }
            case DATA_REDUCTION_BITOR: 
            case DATA_REDUCTION_BITXOR: 
            case DATA_REDUCTION_LOGOR: 
            case DATA_REDUCTION_IOR: 
            case DATA_REDUCTION_IEOR: {
                return Xcons.IntConstant(0);
            }
            case DATA_REDUCTION_MUL: {
                if (xtype.isFloating()) {
                    return Xcons.Float(Xcode.FLOAT_CONSTANT, xtype, 1.0);
                }
            }
            case DATA_REDUCTION_LOGAND: {
                return Xcons.IntConstant(1);
            }
            case DATA_REDUCTION_BITAND: {
                return Xcons.unaryOp(Xcode.BIT_NOT_EXPR, Xcons.IntConstant(0));
            }
            case DATA_REDUCTION_IAND: {
                return Xcons.IntConstant(-1);
            }
            case DATA_REDUCTION_MIN: {
                int n = this.id.Type().getKind() == 1 ? xtype.getBasicType() : (xtype.isEnum() ? 7 : 0);
                switch (n) {
                    case 3: {
                        return Xcons.Int(Xcode.INT_CONSTANT, xtype, 127);
                    }
                    case 4: {
                        return Xcons.Int(Xcode.INT_CONSTANT, xtype, 255);
                    }
                    case 5: {
                        return Xcons.Int(Xcode.INT_CONSTANT, xtype, Short.MAX_VALUE);
                    }
                    case 6: {
                        return Xcons.Int(Xcode.INT_CONSTANT, xtype, 65535);
                    }
                    case 7: 
                    case 9: {
                        return Xcons.Int(Xcode.INT_CONSTANT, xtype, Integer.MAX_VALUE);
                    }
                    case 8: 
                    case 10: {
                        return Xcons.Int(Xcode.INT_CONSTANT, xtype, -1);
                    }
                    case 13: 
                    case 14: {
                        return Xcons.Float(Xcode.FLOAT_CONSTANT, xtype, this.getFloatMaxValue(xtype));
                    }
                }
                break;
            }
            case DATA_REDUCTION_MAX: {
                int n = xtype.getKind() == 1 ? xtype.getBasicType() : (xtype.isEnum() ? 7 : 0);
                switch (n) {
                    case 3: {
                        return Xcons.Int(Xcode.INT_CONSTANT, xtype, -128);
                    }
                    case 5: {
                        return Xcons.Int(Xcode.INT_CONSTANT, xtype, Short.MIN_VALUE);
                    }
                    case 7: 
                    case 9: {
                        return Xcons.Int(Xcode.INT_CONSTANT, Xtype.unsignedType, Integer.MIN_VALUE);
                    }
                    case 4: 
                    case 6: 
                    case 8: 
                    case 10: {
                        return Xcons.Int(Xcode.INT_CONSTANT, xtype, 0);
                    }
                    case 13: 
                    case 14: {
                        return Xcons.Float(Xcode.FLOAT_CONSTANT, xtype, "-" + this.getFloatMaxValue(xtype));
                    }
                }
            }
            case DATA_REDUCTION_LOGEQV: {
                return Xcons.FlogicalConstant(true);
            }
            case DATA_REDUCTION_LOGNEQV: {
                return Xcons.FlogicalConstant(false);
            }
        }
        OMP.fatal("OMPvar.reductionInitValue");
        return null;
    }

    public String toString() {
        return "(" + this.id + " : " + (this.private_addr != null ? "private_addr=" + this.private_addr : "shared_addr=" + this.shared_addr) + ")";
    }
}

