/*
 * Decompiled with CFR 0.152.
 */
package exc.openmp;

import exc.block.BlockPrintWriter;
import exc.block.FuncDefBlock;
import exc.object.Ident;
import exc.object.XobjectDef;
import exc.object.XobjectDefVisitor;
import exc.object.XobjectFile;
import exc.object.Xtype;
import exc.openmp.OMP;
import exc.openmp.OMPanalyzeDecl;
import exc.openmp.OMPanalyzePragma;
import exc.openmp.OMPrewriteExpr;
import exc.openmp.OMPtransPragmaBlock;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import xcodeml.util.XmOption;

public class OMPtranslateBlock
implements XobjectDefVisitor {
    BlockPrintWriter debug_out;
    XobjectFile env;
    OMPanalyzePragma anaPragma = new OMPanalyzePragma();
    OMPrewriteExpr rewriteExpr = new OMPrewriteExpr();
    OMPtransPragmaBlock transPragma = new OMPtransPragmaBlock();
    boolean finalize_mode;

    public void init(XobjectFile xobjectFile, boolean bl) {
        this.env = xobjectFile;
        this.finalize_mode = bl;
        if (bl) {
            return;
        }
        if (OMP.debugFlag) {
            OutputStream outputStream = System.out;
            try {
                outputStream = new FileOutputStream("debug.OMPtranlateBlock");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.debug_out = new BlockPrintWriter(outputStream);
        }
    }

    private void replace_main(XobjectDef xobjectDef) {
        String string = xobjectDef.getName();
        Ident ident = this.env.findVarIdent(string);
        if (ident == null) {
            OMP.fatal("'" + string + "' not in id_list");
        }
        ident.setName(this.transPragma.mainFunc);
        xobjectDef.setName(this.transPragma.mainFunc);
    }

    @Override
    public void doDef(XobjectDef xobjectDef) {
        Object object;
        if (this.finalize_mode) {
            if (xobjectDef.isFuncDef()) {
                FuncDefBlock funcDefBlock = new FuncDefBlock(xobjectDef);
                if (OMP.debugFlag) {
                    this.debug_out.print(funcDefBlock.getBlock());
                }
                this.transPragma.transBlock(funcDefBlock);
                funcDefBlock.finalizeBlock();
            }
            return;
        }
        OMPanalyzeDecl oMPanalyzeDecl = new OMPanalyzeDecl(this.env);
        oMPanalyzeDecl.analyze(xobjectDef);
        if (!xobjectDef.isFuncDef()) {
            return;
        }
        if (XmOption.isLanguageC()) {
            if (xobjectDef.getName().equals("main")) {
                this.replace_main(xobjectDef);
            }
        } else {
            object = xobjectDef.getFuncType();
            if (object != null && ((Xtype)object).isFprogram()) {
                ((Xtype)object).setIsFprogram(false);
                this.replace_main(xobjectDef);
            }
        }
        OMP.resetError();
        object = new FuncDefBlock(xobjectDef);
        ((FuncDefBlock)object).removeDeclInit();
        this.anaPragma.run((FuncDefBlock)object, oMPanalyzeDecl);
        if (OMP.hasError()) {
            return;
        }
        this.rewriteExpr.run((FuncDefBlock)object, oMPanalyzeDecl);
        if (OMP.hasError()) {
            return;
        }
        this.transPragma.run((FuncDefBlock)object);
    }
}

