/*
 * Decompiled with CFR 0.152.
 */
package exc.openmp;

import exc.block.BlockPrintWriter;
import exc.block.FmoduleBlock;
import exc.block.FuncDefBlock;
import exc.object.Ident;
import exc.object.Xcode;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectDefVisitor;
import exc.object.XobjectFile;
import exc.object.XobjectIterator;
import exc.object.Xtype;
import exc.object.topdownXobjectIterator;
import exc.openmp.OMP;
import exc.openmp.OMPanalyzeDecl;
import exc.openmp.OMPanalyzePragma;
import exc.openmp.OMPrewriteExpr;
import exc.openmp.OMPtransPragma;
import java.util.List;
import xcodeml.util.XmOption;

public class OMPtranslate
implements XobjectDefVisitor {
    BlockPrintWriter debug_out;
    XobjectFile env;
    OMPanalyzePragma anaPragma = new OMPanalyzePragma();
    OMPrewriteExpr rewriteExpr = new OMPrewriteExpr();
    OMPtransPragma transPragma = new OMPtransPragma();

    public OMPtranslate() {
    }

    public OMPtranslate(XobjectFile xobjectFile) {
        this.init(xobjectFile);
    }

    public void init(XobjectFile xobjectFile) {
        this.env = xobjectFile;
        if (OMP.debugFlag) {
            this.debug_out = new BlockPrintWriter(System.out);
        }
    }

    public void finish() {
        FmoduleBlock fmoduleBlock = (FmoduleBlock)this.env.getProp("OMPtransPragma.FinternalModuel");
        if (fmoduleBlock != null) {
            XobjectDef xobjectDef = null;
            for (XobjectDef xobjectDef2 : this.env) {
                if (!xobjectDef2.isFmoduleDef()) continue;
                xobjectDef = xobjectDef2;
            }
            if (xobjectDef == null) {
                this.env.insert(fmoduleBlock.toXobjectDef());
            } else {
                xobjectDef.addAfterThis(fmoduleBlock.toXobjectDef());
            }
        }
        this.env.collectAllTypes();
        this.env.fixupTypeRef();
    }

    private void replace_main(XobjectDef xobjectDef) {
        String string = xobjectDef.getName();
        Ident ident = this.env.findVarIdent(string);
        if (ident == null) {
            OMP.fatal("'" + string + "' not in id_list");
        }
        ident.setName(this.transPragma.mainFunc);
        xobjectDef.setName(this.transPragma.mainFunc);
    }

    @Override
    public void doDef(XobjectDef xobjectDef) {
        Object object;
        OMP.resetError();
        OMPanalyzeDecl oMPanalyzeDecl = new OMPanalyzeDecl(this.env);
        oMPanalyzeDecl.analyze(xobjectDef);
        if (OMP.hasError()) {
            return;
        }
        if (!xobjectDef.isFuncDef()) {
            return;
        }
        if (XmOption.isLanguageC()) {
            if (xobjectDef.getName().equals("main")) {
                this.replace_main(xobjectDef);
            }
        } else {
            object = xobjectDef.getFuncType();
            if (object != null && ((Xtype)object).isFprogram()) {
                ((Xtype)object).setIsFprogram(false);
                this.replace_main(xobjectDef);
            }
        }
        object = new FuncDefBlock(xobjectDef);
        List list = oMPanalyzeDecl.getCommonName();
        for (int i = 0; i < list.size(); ++i) {
            ((FuncDefBlock)object).searchCommonMember(list.get(i).toString(), oMPanalyzeDecl, xobjectDef);
        }
        if (XmOption.isLanguageC()) {
            ((FuncDefBlock)object).removeDeclInit();
        }
        if (OMP.hasError()) {
            return;
        }
        OMP.debug("3");
        this.anaPragma.run((FuncDefBlock)object, oMPanalyzeDecl);
        if (OMP.hasError()) {
            return;
        }
        OMP.debug("4");
        this.rewriteExpr.run((FuncDefBlock)object, oMPanalyzeDecl);
        if (OMP.hasError()) {
            return;
        }
        OMP.debug("5");
        this.transPragma.run((FuncDefBlock)object);
        if (OMP.hasError()) {
            return;
        }
        ((FuncDefBlock)object).finalizeBlock();
    }

    boolean haveOMPpragma(Xobject xobject) {
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject);
        ((XobjectIterator)topdownXobjectIterator2).init();
        while (!((XobjectIterator)topdownXobjectIterator2).end()) {
            Xobject xobject2 = topdownXobjectIterator2.getXobject();
            if (xobject2 != null && xobject2.Opcode() == Xcode.OMP_PRAGMA) {
                return true;
            }
            ((XobjectIterator)topdownXobjectIterator2).next();
        }
        return false;
    }
}

