/*
 * Decompiled with CFR 0.152.
 */
package exc.openmp;

import exc.block.BasicBlock;
import exc.block.BasicBlockExprIterator;
import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockIterator;
import exc.block.BlockList;
import exc.block.ForBlock;
import exc.block.FuncDefBlock;
import exc.block.FunctionBlock;
import exc.block.PragmaBlock;
import exc.block.Statement;
import exc.block.StatementIterator;
import exc.block.bottomupBlockIterator;
import exc.object.FunctionType;
import exc.object.Ident;
import exc.object.PropObject;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjList;
import exc.object.XobjString;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.openmp.OMP;
import exc.openmp.OMPBlock;
import exc.openmp.OMPforallBlock;
import exc.openmp.OMPinfo;
import exc.openmp.OMPparallelBlock;
import exc.openmp.OMPtransPragma;
import exc.openmp.OMPvar;

public class OMPtransPragmaBlock
extends OMPtransPragma {
    public boolean moveAutoFlag;
    public String bcastCopy = "ompc_bcast_copy";
    public String thdprvCopy = "ompc_bcast_thdprv";
    public String lastCopy = "ompc_last_copy";

    @Override
    public Block transBarrier(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        return OMPBlock.Barrier();
    }

    @Override
    public Block transParallelRegion(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        Xobject xobject;
        BlockList blockList = Bcons.emptyBody(oMPinfo.getIdList(), null);
        this.addDataSetupBlock(blockList, oMPinfo);
        int n = oMPinfo.getRegionArgs().size();
        BasicBlock basicBlock = new BasicBlock();
        for (int i = 0; i < n; ++i) {
            xobject = oMPinfo.getRegionArgs().get(i);
            xobject = Xcons.List(Xcode.OMP_SETARG, Xcons.IntConstant(i), xobject);
            basicBlock.add(xobject);
        }
        blockList.add(Bcons.COMPOUND(pragmaBlock.getBody()));
        BasicBlock basicBlock2 = new BasicBlock();
        for (int i = 0; i < oMPinfo.getRegionParams().size(); ++i) {
            xobject = oMPinfo.getRegionParams().get(i).Ref();
            xobject = Xcons.Set(xobject, Xcons.List(Xcode.OMP_GETARG, xobject.Type(), Xcons.IntConstant(i)));
            basicBlock2.add(xobject);
        }
        blockList.insert(basicBlock2);
        Block block = this.dataUpdateBlock(oMPinfo);
        if (block != null) {
            blockList.add(block);
        }
        this.threadprivateSetup(null, blockList, oMPinfo, true);
        return OMPBlock.ParallelRegion(n, basicBlock, blockList, oMPinfo.getIfExpr());
    }

    @Override
    public Block transFor(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        Statement statement;
        ForBlock forBlock = (ForBlock)((Object)pragmaBlock.getBody().getHead());
        forBlock.Canonicalize();
        if (!forBlock.isCanonical()) {
            OMP.fatal("transFor: not canonical");
        }
        BlockList blockList = Bcons.emptyBody(oMPinfo.getIdList(), null);
        this.addDataSetupBlock(blockList, oMPinfo);
        BasicBlock basicBlock = new BasicBlock();
        blockList.add(basicBlock);
        StatementIterator statementIterator = forBlock.getInitBBlock().statements();
        while (statementIterator.hasMoreStatement() && (statement = statementIterator.nextStatement()).getNext() != null) {
            statement.remove();
            basicBlock.add(statement);
        }
        blockList.add(OMPBlock.Forall(forBlock.getInductionVar(), forBlock.getLowerBound(), forBlock.getUpperBound(), forBlock.getStep(), forBlock.getCheckOpcode(), forBlock.getBody(), oMPinfo.sched, oMPinfo.sched_chunk, oMPinfo.ordered));
        Block block = this.dataUpdateBlock(oMPinfo);
        if (block != null) {
            blockList.add(block);
        }
        if (!oMPinfo.no_wait) {
            blockList.add(OMPBlock.Barrier());
        }
        return Bcons.COMPOUND(blockList);
    }

    @Override
    public Block transSections(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        Block block;
        BlockList blockList = Bcons.emptyBody(oMPinfo.getIdList(), null);
        int n = 0;
        this.addDataSetupBlock(blockList, oMPinfo);
        n = 0;
        for (block = pragmaBlock.getBody().getHead(); block != null; block = block.getNext()) {
            ++n;
        }
        blockList.add(OMPBlock.Sections(n, pragmaBlock.getBody()));
        block = this.dataUpdateBlock(oMPinfo);
        if (block != null) {
            blockList.add(block);
        }
        if (!oMPinfo.no_wait) {
            blockList.add(OMPBlock.Barrier());
        }
        return Bcons.COMPOUND(blockList);
    }

    @Override
    public Block transSingle(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        BlockList blockList = Bcons.emptyBody(oMPinfo.getIdList(), null);
        BlockList blockList2 = Bcons.emptyBody();
        this.addDataSetupBlock(blockList, oMPinfo);
        blockList.add(Bcons.COMPOUND(pragmaBlock.getBody()));
        blockList2.add(OMPBlock.Single(blockList));
        if (!oMPinfo.no_wait) {
            blockList2.add(OMPBlock.Barrier());
        }
        return Bcons.COMPOUND(blockList2);
    }

    @Override
    public Block transMaster(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        return OMPBlock.Master(pragmaBlock.getBody());
    }

    @Override
    public Block transCritical(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        return OMPBlock.Critical(oMPinfo.arg, pragmaBlock.getBody());
    }

    @Override
    public Block transAtomic(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        Ident ident;
        Xobject xobject;
        BlockList blockList = pragmaBlock.getBody();
        BasicBlock basicBlock = blockList.getHead().getBasicBlock();
        Statement statement = basicBlock.getHead();
        Xobject xobject2 = statement.getExpr();
        if (xobject2.Opcode() != Xcode.POST_INCR_EXPR && xobject2.Opcode() != Xcode.POST_DECR_EXPR && xobject2.Opcode() != Xcode.PRE_INCR_EXPR && xobject2.Opcode() != Xcode.PRE_DECR_EXPR) {
            xobject = xobject2.right();
            ident = Ident.Local(this.env.genSym("t"), xobject.Type());
            blockList.addIdent(ident);
            statement.insert(Xcons.Set(ident.Ref(), xobject));
            xobject2.setRight(ident.Ref());
        }
        xobject = xobject2.operand();
        ident = Ident.Local(this.env.genSym("t"), Xtype.Pointer(xobject.Type()));
        blockList.addIdent(ident);
        statement.insert(Xcons.Set(ident.Ref(), Xcons.AddrOf(xobject)));
        xobject2.setOperand(Xcons.PointerRef(ident.Ref()));
        statement.insert(this.OMPfuncIdent(this.atomicLockFunc).Call(null));
        statement.add(this.OMPfuncIdent(this.atomicUnlockFunc).Call(null));
        return Bcons.COMPOUND(blockList);
    }

    @Override
    public Block transFlush(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        return OMPBlock.Flush(oMPinfo.flush_vars);
    }

    @Override
    public Block transOrdered(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        return OMPBlock.Ordered(pragmaBlock.getBody());
    }

    @Override
    public void addDataSetupBlock(BlockList blockList, OMPinfo oMPinfo) {
        BasicBlock basicBlock = new BasicBlock();
        for (OMPvar oMPvar : oMPinfo.getVarList()) {
            if (oMPvar.isVariableArray() && oMPvar.getPrivateAddr() != null || !oMPvar.is_first_private) continue;
            basicBlock.add(Xcons.List(Xcode.OMP_BCAST, oMPvar.getPrivateAddr(), oMPvar.getSharedAddr(), oMPvar.getSize()));
        }
        for (OMPvar oMPvar : oMPinfo.getVarList()) {
            Ident ident;
            if (oMPvar.isVariableArray() && oMPvar.getPrivateAddr() != null) {
                ident = this.OMPfuncIdent(this.allocaFunc);
                basicBlock.add(Xcons.Set(Xcons.PointerRef(oMPvar.getPrivateAddr()), Xcons.Cast(oMPvar.getPrivateAddr().Type().getRef(), ident.Call(Xcons.List(oMPvar.getSize())))));
            }
            if (oMPvar.is_first_private) continue;
            if (oMPvar.is_reduction) {
                basicBlock.add(Xcons.List(Xcode.OMP_SHARE, oMPvar.getPrivateAddr(), null));
                basicBlock.add(Xcons.Set(Xcons.PointerRef(oMPvar.getPrivateAddr()), oMPvar.reductionInitValue()));
                continue;
            }
            if (oMPvar.is_copyin) {
                if (OMP.leaveThreadPrivateFlag) {
                    ident = oMPvar.id;
                    basicBlock.add(Xcons.List(Xcode.OMP_BCAST_THDPRV, ident.getAddr(), ident.getAddr(), Xcons.SizeOf(ident.Type())));
                    continue;
                }
                ident = oMPvar.id;
                Ident ident2 = oMPvar.getThdPrvLocalId();
                if (ident2 == null) {
                    OMP.fatal("bad copyin: " + ident.getName());
                }
                basicBlock.add(Xcons.List(Xcode.OMP_BCAST_THDPRV, ident2.Ref(), ident.getAddr(), Xcons.SizeOf(ident.Type())));
                continue;
            }
            if (!oMPvar.is_shared) continue;
            ident = oMPvar.id;
            basicBlock.add(Xcons.List(Xcode.OMP_SHARE, oMPvar.getSharedAddr(), ident));
        }
        if (!basicBlock.isEmpty()) {
            blockList.add(basicBlock);
        }
    }

    @Override
    public Block dataUpdateBlock(OMPinfo oMPinfo) {
        boolean bl = false;
        boolean bl2 = false;
        for (OMPvar iterator : oMPinfo.getVarList()) {
            if (iterator.is_last_private) {
                bl2 = true;
            }
            if (!iterator.is_reduction) continue;
            bl = true;
        }
        if (!bl2 && !bl) {
            return null;
        }
        BasicBlock basicBlock = new BasicBlock();
        if (bl) {
            for (OMPvar oMPvar : oMPinfo.getVarList()) {
                int n;
                if (!oMPvar.is_reduction) continue;
                if (oMPvar.id.Type().isEnum()) {
                    n = 7;
                } else if (oMPvar.id.Type().isNumeric()) {
                    n = oMPvar.id.Type().getBasicType();
                } else {
                    OMP.fatal("bad reduction variable type");
                    continue;
                }
                basicBlock.add(Xcons.List(Xcode.OMP_REDUCTION, oMPvar.getPrivateAddr(), oMPvar.getSharedAddr(), Xcons.IntConstant(n), Xcons.String(oMPvar.reduction_op.toString())));
            }
        }
        if (bl2) {
            for (OMPvar oMPvar : oMPinfo.getVarList()) {
                if (!oMPvar.is_last_private) continue;
                basicBlock.add(Xcons.List(Xcode.OMP_LAST_UPDATE, oMPvar.getSharedAddr(), oMPvar.getPrivateAddr(), oMPvar.getSize()));
            }
        }
        return Bcons.BasicBlock(basicBlock);
    }

    public void transBlock(FuncDefBlock funcDefBlock) {
        FunctionBlock functionBlock = funcDefBlock.getBlock();
        this.current_def = funcDefBlock.getDef();
        this.env = this.current_def.getFile();
        if (OMP.debugFlag) {
            System.out.println("pass3-transBlock:");
        }
        this.cleanupOMPcode(functionBlock);
        bottomupBlockIterator bottomupBlockIterator2 = new bottomupBlockIterator(functionBlock);
        ((BlockIterator)bottomupBlockIterator2).init();
        while (!((BlockIterator)bottomupBlockIterator2).end()) {
            Block block = bottomupBlockIterator2.getBlock();
            switch (block.Opcode()) {
                case OMP_PARALLEL: {
                    bottomupBlockIterator2.setBlock(this.transParallelBlock((OMPparallelBlock)block));
                    break;
                }
                case OMP_FORALL: {
                    bottomupBlockIterator2.setBlock(this.transForallBlock((OMPforallBlock)block));
                    break;
                }
                case OMP_SECTIONS: {
                    bottomupBlockIterator2.setBlock(this.transSectionsBlock((OMPBlock)block));
                    break;
                }
                case OMP_CRITICAL: {
                    bottomupBlockIterator2.setBlock(this.transCriticalBlock((OMPBlock)block));
                    break;
                }
                case OMP_SINGLE: {
                    bottomupBlockIterator2.setBlock(this.transSingleBlock((OMPBlock)block));
                    break;
                }
                case OMP_MASTER: {
                    bottomupBlockIterator2.setBlock(this.transMasterBlock((OMPBlock)block));
                    break;
                }
                case OMP_ORDERED: {
                    bottomupBlockIterator2.setBlock(this.transOrderedBlock((OMPBlock)block));
                    break;
                }
                case OMP_ATOMIC: {
                    bottomupBlockIterator2.setBlock(this.transAtomicBlock((OMPBlock)block));
                    break;
                }
                case OMP_FLUSH: {
                    bottomupBlockIterator2.setBlock(this.transFlushBlock((OMPBlock)block));
                    break;
                }
                case OMP_BARRIER: {
                    bottomupBlockIterator2.setBlock(this.transBarrierBlock((OMPBlock)block));
                }
            }
            ((BlockIterator)bottomupBlockIterator2).next();
        }
    }

    void cleanupOMPcode(Block block) {
        BasicBlockExprIterator basicBlockExprIterator = new BasicBlockExprIterator(block);
        while (!basicBlockExprIterator.end()) {
            Xobject xobject = basicBlockExprIterator.getExpr();
            if (xobject != null) {
                switch (xobject.Opcode()) {
                    case OMP_BCAST: {
                        basicBlockExprIterator.setExpr(this.OMPfuncIdent(this.bcastCopy).Call(xobject));
                        break;
                    }
                    case OMP_BCAST_THDPRV: {
                        basicBlockExprIterator.setExpr(this.OMPfuncIdent(this.thdprvCopy).Call(xobject));
                        break;
                    }
                    case OMP_SHARE: {
                        basicBlockExprIterator.setExpr(null);
                        break;
                    }
                    case OMP_REDUCTION: {
                        basicBlockExprIterator.setExpr(this.OMPfuncIdent(this.doReduction).Call(xobject));
                        break;
                    }
                    case OMP_LAST_UPDATE: {
                        basicBlockExprIterator.setExpr(this.OMPfuncIdent(this.lastCopy).Call(xobject));
                    }
                }
            }
            basicBlockExprIterator.next();
        }
    }

    public Block transParallelBlock(OMPparallelBlock oMPparallelBlock) {
        Object object;
        Object object2;
        Object object3;
        PropObject propObject;
        Object object4;
        Object object5;
        Xobject xobject;
        Object object6;
        Ident ident = this.current_def.declStaticIdent(this.env.genExportSym(this.OMPfuncPrefix, this.current_def.getName()), Xtype.Function(Xtype.voidType));
        BlockList blockList = Bcons.emptyBody();
        BasicBlock basicBlock = oMPparallelBlock.setupBasicBlock();
        BasicBlock basicBlock2 = oMPparallelBlock.endBasicBlock();
        int n = oMPparallelBlock.getNarg();
        if (n != 0) {
            object6 = Xtype.Pointer(Xtype.voidType);
            xobject = Ident.Local("_ompc_argv", Xtype.Array((Xtype)object6, n));
            blockList.addIdent((Ident)xobject);
            object5 = basicBlock.statements();
            while (object5.hasMoreStatement()) {
                boolean bl;
                object4 = object5.nextStatement();
                propObject = ((Statement)object4).getExpr();
                if (((Xobject)propObject).Opcode() != Xcode.OMP_SETARG) continue;
                object3 = ((Ident)xobject).Index(((Xobject)propObject).getArg(0));
                object2 = ((Xobject)propObject).getArg(1);
                object = ((Xobject)object2).Opcode();
                boolean bl2 = ((Xobject)object2).isScopeLocal() && (object == Xcode.VAR_ADDR || object == Xcode.ARRAY_ADDR);
                boolean bl3 = bl = ((Xobject)object2).isScopeParam() && object == Xcode.VAR_ADDR;
                if (OMP.moveAutoFlag && (bl2 || bl)) {
                    Xobject xobject2 = ((Xobject)object2).Type().isVariableArray() ? ((Xobject)object2).Type().getArraySizeExpr().copy() : Xcons.SizeOf(((Xobject)object2).Type());
                    Xobject xobject3 = this.OMPfuncIdent(this.allocShared).Call(Xcons.List(new Xobject[]{object2, xobject2}));
                    basicBlock2.insert(this.OMPfuncIdent(this.freeShared).Call(Xcons.List(new Xobject[]{object3, object2, xobject2})));
                    object2 = xobject3;
                }
                ((Statement)object4).setExpr(Xcons.Set((Xobject)object3, Xcons.Cast((Xtype)object6, (Xobject)object2)));
            }
            if (oMPparallelBlock.getIfExpr() != null) {
                basicBlock.add(this.OMPfuncIdent(this.doParallelIfFunc).Call(Xcons.List(oMPparallelBlock.getIfExpr(), ident.Ref(), ((Ident)xobject).Ref(), Xcons.IntConstant(n))));
            } else {
                basicBlock.add(this.OMPfuncIdent(this.doParallelFunc).Call(Xcons.List(ident.Ref(), ((Ident)xobject).Ref(), Xcons.IntConstant(n))));
            }
        } else if (oMPparallelBlock.getIfExpr() != null) {
            basicBlock.add(this.OMPfuncIdent(this.doParallelIfFunc).Call(Xcons.List(oMPparallelBlock.getIfExpr(), ident.Ref(), Xcons.IntConstant(0), Xcons.IntConstant(0))));
        } else {
            basicBlock.add(this.OMPfuncIdent(this.doParallelFunc).Call(Xcons.List(ident.Ref(), Xcons.IntConstant(0), Xcons.IntConstant(0))));
        }
        blockList.add(basicBlock);
        blockList.add(basicBlock2);
        object6 = oMPparallelBlock.getBody();
        xobject = Xcons.IDList();
        if (n != 0) {
            object5 = Xtype.Pointer(Xtype.voidType);
            object4 = Ident.Param("_ompc_args", Xtype.Pointer((Xtype)object5));
            xobject.add((Xobject)object4);
            propObject = ((BlockList)object6).getHead().getBasicBlock();
            object3 = ((BasicBlock)propObject).statements();
            while (object3.hasMoreStatement()) {
                object2 = object3.nextStatement();
                object = ((Statement)object2).getExpr();
                if (!((Xobject)object).isSet() || ((Xobject)object).right().Opcode() != Xcode.OMP_GETARG) continue;
                ((Xobject)object).setRight(Xcons.Cast(((Xobject)object).left().Type(), ((Ident)object4).Index(((Xobject)object).right().operand())));
            }
        }
        ((FunctionType)ident.Type()).setFuncParamIdList(xobject);
        object5 = new FuncDefBlock(ident, xobject, null, (BlockList)object6, null, this.env);
        this.current_def.insertBeforeThis(((FuncDefBlock)object5).getDef());
        return Bcons.COMPOUND(blockList);
    }

    public Block transForallBlock(OMPforallBlock oMPforallBlock) {
        Object object;
        BlockList blockList = Bcons.emptyBody();
        Xobject xobject = oMPforallBlock.getLoopVar();
        Ident ident = Ident.Local(this.env.genSym(xobject.getName()), xobject.Type());
        Ident ident2 = Ident.Local(this.env.genSym(xobject.getName()), xobject.Type());
        Ident ident3 = Ident.Local(this.env.genSym(xobject.getName()), xobject.Type());
        blockList.addIdent(ident);
        blockList.addIdent(ident2);
        blockList.addIdent(ident3);
        BasicBlock basicBlock = new BasicBlock();
        Object object2 = oMPforallBlock.beginBasicBlock().statements();
        while (object2.hasMoreStatement()) {
            object = object2.nextStatement();
            ((Statement)object).remove();
            if (object == oMPforallBlock.iter_info) break;
            basicBlock.add((Statement)object);
        }
        basicBlock.add(Xcons.Set(ident.Ref(), oMPforallBlock.getLowerBound()));
        basicBlock.add(Xcons.Set(ident2.Ref(), oMPforallBlock.getUpperBound()));
        basicBlock.add(Xcons.Set(ident3.Ref(), oMPforallBlock.getStep()));
        if (oMPforallBlock.isOrdered()) {
            basicBlock.add(this.OMPfuncIdent(this.orderedInitFunc).Call(Xcons.List(ident.Ref(), ident3.Ref())));
            oMPforallBlock.getBody().insert(this.OMPfuncIdent(this.orderedSetLoopIdFunc).Call(Xcons.List(xobject)));
        }
        object2 = Bcons.FORall(xobject, ident.Ref(), ident2.Ref(), ident3.Ref(), oMPforallBlock.getCheckOpcode(), oMPforallBlock.getBody());
        if (!oMPforallBlock.beginBasicBlock().isEmpty() || !oMPforallBlock.endBasicBlock().isEmpty()) {
            object = Bcons.emptyBody();
            ((BlockList)object).add(oMPforallBlock.beginBasicBlock());
            ((BlockList)object).add((Block)object2);
            ((BlockList)object).add(oMPforallBlock.endBasicBlock());
            object2 = Bcons.COMPOUND((BlockList)object);
        }
        object = oMPforallBlock.getChunk();
        switch (oMPforallBlock.getSched()) {
            case SCHED_STATIC: {
                if (object != null) {
                    if (((Xobject)object).Opcode() == Xcode.INT_CONSTANT && ((Xobject)object).getInt() == 1) {
                        basicBlock.add(this.OMPfuncIdent(this.cyclicShedFunc).Call(Xcons.List(ident.getAddr(), ident2.getAddr(), ident3.getAddr())));
                        break;
                    }
                    basicBlock.add(this.OMPfuncIdent(this.staticShedInitFunc).Call(Xcons.List(new Xobject[]{ident.Ref(), ident2.Ref(), ident3.Ref(), object})));
                    if (((Block)object2).Opcode() != Xcode.FOR_STATEMENT) {
                        BlockList blockList2 = Bcons.emptyBody();
                        blockList2.add(((Block)object2).getBody().getHead().remove());
                        blockList2.add(Bcons.WHILE(this.OMPfuncIdent(this.staticShedNextFunc).Call(Xcons.List(ident.getAddr(), ident2.getAddr())), ((Block)object2).getBody().getHead().remove()));
                        blockList2.add(((Block)object2).getBody().getHead().remove());
                        object2 = Bcons.COMPOUND(blockList2);
                        break;
                    }
                    object2 = Bcons.WHILE(this.OMPfuncIdent(this.staticShedNextFunc).Call(Xcons.List(ident.getAddr(), ident2.getAddr())), (Block)object2);
                    break;
                }
            }
            case SCHED_NONE: {
                basicBlock.add(this.OMPfuncIdent(this.defaultShedFunc).Call(Xcons.List(ident.getAddr(), ident2.getAddr(), ident3.getAddr())));
                break;
            }
            case SCHED_AFFINITY: {
                XobjList xobjList = Xcons.List(ident.Ref(), ident2.Ref(), ident3.Ref());
                ((Xobject)xobjList).add(((Xobject)object).getArg(0));
                ((Xobject)xobjList).add(((Xobject)object).getArg(1));
                ((Xobject)xobjList).add(((Xobject)object).getArg(2));
                ((Xobject)xobjList).add(((Xobject)object).getArg(3));
                basicBlock.add(this.OMPfuncIdent(this.affinityShedInitFunc).Call(xobjList));
                object2 = Bcons.WHILE(this.OMPfuncIdent(this.affinityShedNextFunc).Call(Xcons.List(ident.getAddr(), ident2.getAddr())), (Block)object2);
                break;
            }
            case SCHED_DYNAMIC: {
                if (object == null) {
                    object = Xcons.IntConstant(1);
                }
                basicBlock.add(this.OMPfuncIdent(this.dynamicShedInitFunc).Call(Xcons.List(new Xobject[]{ident.Ref(), ident2.Ref(), ident3.Ref(), object})));
                object2 = Bcons.WHILE(this.OMPfuncIdent(this.dynamicShedNextFunc).Call(Xcons.List(ident.getAddr(), ident2.getAddr())), (Block)object2);
                break;
            }
            case SCHED_GUIDED: {
                if (object == null) {
                    object = Xcons.IntConstant(1);
                }
                basicBlock.add(this.OMPfuncIdent(this.guidedShedInitFunc).Call(Xcons.List(new Xobject[]{ident.Ref(), ident2.Ref(), ident3.Ref(), object})));
                object2 = Bcons.WHILE(this.OMPfuncIdent(this.guidedShedNextFunc).Call(Xcons.List(ident.getAddr(), ident2.getAddr())), (Block)object2);
                break;
            }
            case SCHED_RUNTIME: {
                basicBlock.add(this.OMPfuncIdent(this.runtimeShedInitFunc).Call(Xcons.List(ident.Ref(), ident2.Ref(), ident3.Ref())));
                object2 = Bcons.WHILE(this.OMPfuncIdent(this.runtimeShedNextFunc).Call(Xcons.List(ident.getAddr(), ident2.getAddr())), (Block)object2);
                break;
            }
            default: {
                OMP.fatal("unknown schedule: " + (Object)((Object)oMPforallBlock.getSched()));
            }
        }
        blockList.add(basicBlock);
        blockList.add((Block)object2);
        return Bcons.COMPOUND(blockList);
    }

    public Block transSectionsBlock(OMPBlock oMPBlock) {
        Block block;
        XobjString xobjString = Xcons.Symbol(Xcode.IDENT, this.env.genSym("L"));
        BlockList blockList = Bcons.emptyBody();
        BasicBlock basicBlock = oMPBlock.beginBasicBlock();
        basicBlock.add(this.OMPfuncIdent(this.sectionInitFunc).Call(Xcons.List(Xcons.IntConstant(oMPBlock.getNarg()))));
        blockList.add(basicBlock);
        blockList.add(Bcons.LABEL(xobjString));
        BlockList blockList2 = Bcons.emptyBody();
        int n = 0;
        while ((block = oMPBlock.getBody().getHead()) != null) {
            block.remove();
            blockList2.add(Bcons.CASE(Xcons.IntConstant(n++)));
            blockList2.add(block);
            blockList2.add(Bcons.GOTO(xobjString));
        }
        blockList.add(Bcons.SWITCH(this.OMPfuncIdent(this.sectionIdFunc).Call(null), Bcons.COMPOUND(blockList2)));
        return Bcons.COMPOUND(blockList);
    }

    public Block transCriticalBlock(OMPBlock oMPBlock) {
        String string = this.criticalLockPrefix;
        if (oMPBlock.getInfoExpr() != null) {
            string = string + "_" + oMPBlock.getInfoExpr().getName();
        }
        Ident ident = this.current_def.declGlobalIdent(string, Xtype.Pointer(Xtype.voidType));
        BlockList blockList = oMPBlock.getBody();
        blockList.insert(this.OMPfuncIdent(this.enterCriticalFunc).Call(Xcons.List(ident.getAddr())));
        blockList.add(this.OMPfuncIdent(this.exitCriticalFunc).Call(Xcons.List(ident.getAddr())));
        return Bcons.COMPOUND(blockList);
    }

    public Block transSingleBlock(OMPBlock oMPBlock) {
        BlockList blockList = Bcons.emptyBody();
        blockList.add(oMPBlock.beginBasicBlock());
        blockList.add(Bcons.IF(BasicBlock.Cond(this.OMPfuncIdent(this.doSingleFunc).Call(null)), oMPBlock.getBody(), null));
        blockList.add(oMPBlock.endBasicBlock());
        return Bcons.COMPOUND(blockList);
    }

    public Block transMasterBlock(OMPBlock oMPBlock) {
        BlockList blockList = Bcons.emptyBody();
        blockList.add(oMPBlock.beginBasicBlock());
        blockList.add(Bcons.IF(BasicBlock.Cond(this.OMPfuncIdent(this.isMasterFunc).Call(null)), oMPBlock.getBody(), null));
        blockList.add(oMPBlock.endBasicBlock());
        return Bcons.COMPOUND(blockList);
    }

    public Block transOrderedBlock(OMPBlock oMPBlock) {
        BlockList blockList = oMPBlock.getBody();
        blockList.insert(this.OMPfuncIdent(this.orderedBeginFunc).Call(null));
        blockList.insert(oMPBlock.beginBasicBlock());
        blockList.add(this.OMPfuncIdent(this.orderedEndFunc).Call(null));
        blockList.add(oMPBlock.endBasicBlock());
        return Bcons.COMPOUND(blockList);
    }

    public Block transAtomicBlock(OMPBlock oMPBlock) {
        BlockList blockList = oMPBlock.getBody();
        blockList.insert(this.OMPfuncIdent(this.atomicLockFunc).Call(null));
        blockList.insert(oMPBlock.beginBasicBlock());
        blockList.add(this.OMPfuncIdent(this.atomicUnlockFunc).Call(null));
        blockList.add(oMPBlock.endBasicBlock());
        return Bcons.COMPOUND(blockList);
    }

    public Block transFlushBlock(OMPBlock oMPBlock) {
        BlockList blockList = Bcons.emptyBody();
        blockList.add(oMPBlock.beginBasicBlock());
        Xobject xobject = oMPBlock.getInfoExpr();
        if (xobject == null) {
            blockList.add(Bcons.Statement(this.OMPfuncIdent(this.flushFunc).Call(Xcons.List(Xcons.IntConstant(0), Xcons.IntConstant(0)))));
        } else {
            BasicBlock basicBlock = new BasicBlock();
            for (XobjArgs xobjArgs = xobject.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
                Xobject xobject2 = xobjArgs.getArg();
                basicBlock.add(this.OMPfuncIdent(this.flushFunc).Call(xobject2));
            }
            blockList.add(basicBlock);
        }
        blockList.add(oMPBlock.endBasicBlock());
        return Bcons.COMPOUND(blockList);
    }

    public Block transBarrierBlock(OMPBlock oMPBlock) {
        BlockList blockList = Bcons.emptyBody();
        blockList.add(oMPBlock.beginBasicBlock());
        blockList.add(this.OMPfuncIdent(this.barrierFunc).Call(null));
        blockList.add(oMPBlock.endBasicBlock());
        return Bcons.COMPOUND(blockList);
    }
}

