/*
 * Decompiled with CFR 0.152.
 */
package exc.openmp;

import exc.block.BasicBlock;
import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockIterator;
import exc.block.BlockList;
import exc.block.CompoundBlock;
import exc.block.FmoduleBlock;
import exc.block.ForBlock;
import exc.block.FuncDefBlock;
import exc.block.FunctionBlock;
import exc.block.PragmaBlock;
import exc.block.Statement;
import exc.block.bottomupBlockIterator;
import exc.block.topdownBlockIterator;
import exc.object.BasicType;
import exc.object.FunctionType;
import exc.object.Ident;
import exc.object.PropObject;
import exc.object.StorageClass;
import exc.object.VarScope;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjConst;
import exc.object.XobjInt;
import exc.object.XobjList;
import exc.object.XobjString;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectFile;
import exc.object.Xtype;
import exc.openmp.FidentCollector;
import exc.openmp.OMP;
import exc.openmp.OMPinfo;
import exc.openmp.OMPrewriteExpr;
import exc.openmp.OMPvar;
import exc.util.MachineDep;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import xcodeml.util.ILineNo;
import xcodeml.util.XmLog;
import xcodeml.util.XmOption;

public class OMPtransPragma {
    protected XobjectDef current_def;
    protected XobjectFile env;
    public String mainFunc;
    public String barrierFunc;
    public String currentThreadBarrierFunc;
    public String doParallelFunc;
    public String doParallelIfFunc;
    public String parallelTaskFunc;
    public String parallelTaskIfFunc;
    public String defaultShedFunc;
    public String blockShedFunc;
    public String cyclicShedFunc;
    public String staticShedInitFunc;
    public String staticShedNextFunc;
    public String dynamicShedInitFunc;
    public String dynamicShedNextFunc;
    public String guidedShedInitFunc;
    public String guidedShedNextFunc;
    public String runtimeShedInitFunc;
    public String runtimeShedNextFunc;
    public String affinityShedInitFunc;
    public String affinityShedNextFunc;
    public String orderedInitFunc;
    public String orderedSetLoopIdFunc;
    public String orderedBeginFunc;
    public String orderedEndFunc;
    public String threadIdFunc;
    public String sectionInitFunc;
    public String sectionIdFunc;
    public String doSingleFunc;
    public String enterCriticalFunc;
    public String exitCriticalFunc;
    public String isMasterFunc;
    public String atomicLockFunc;
    public String atomicUnlockFunc;
    public String threadLockFunc;
    public String threadUnlockFunc;
    public String bcopyFunc;
    public String isLastFunc;
    public String flushFunc;
    public String getThdprvFunc;
    public String copyinThdprvFunc;
    public String allocShared;
    public String freeShared;
    public String allocaFunc;
    public String doReduction;
    public String doReductionInit;
    public String OMPfuncPrefix;
    public String criticalLockPrefix;
    public String reductionLockPrefix;
    public String setNumThreadsFunc;
    public String getNumThreadsFunc;
    public String getThreadNumFunc;
    public String getMaxThreadsFunc;
    public String setBoundsFuncPrefix;
    public String saveArrayFunc;
    public String loadArrayFunc;
    public final String FallocatedFunc = "allocated";
    public final String Fsize = "size";
    public final String FlboundFunc = "lbound";
    public final String FuboundFunc = "ubound";
    public final String FdoParallelWrapperPrefix = "ompf_dop";
    public final String FParallelTaskWrapperPrefix = "ompf_ptask";
    public final String FdummyFunc = "ompf_func";
    public final String FgetThdprvFuncPrefix = "ompf_getthdprv_";
    public static final String PROP_KEY_FINTERNAL_MODULE = "OMPtransPragma.FinternalModuel";
    public static final String ARGV_VAR = "_ompc_argv";
    public static final String ARGS_VAR = "_ompc_args";
    public static final String SHARE_VAR_PREFIX = "pp_";
    public static final String LOCAL_VAR_PREFIX = "p_";
    public static final String COPYPRV_VAR_PREFIX = "cp_";
    public static final String TEMP_VAR_PREFIX = "t_";
    public static final String THDPRV_LOCAL_VAR_PREFIX = "tp_";
    public static final String THDPRV_STORE_PREFIX = "ts_";
    public static final String COND_VAR = "p__cond";
    public static final String NARG_VAR = "p__narg";
    public static final String THDNUM_VAR = "p__tn";
    public static final String THDNUM_LOOP_VAR = "p__tnlp";
    public static final String FINTERNAL_MODULE_PREFIX = "ompf_internal_";
    public static final String FTHDPRV_COMMON_PREFIX = "tc_";
    public static final int F_MAX_PARALLEL_PARAMS = 64;

    public OMPtransPragma() {
        if (XmOption.isLanguageC()) {
            this.mainFunc = "ompc_main";
            this.OMPfuncPrefix = "ompc_func";
            this.barrierFunc = "ompc_barrier";
            this.currentThreadBarrierFunc = "ompc_current_thread_barrier";
            this.doParallelFunc = "ompc_do_parallel";
            this.doParallelIfFunc = "ompc_do_parallel_if";
            this.defaultShedFunc = "ompc_default_sched";
            this.blockShedFunc = "ompc_static_bsched";
            this.cyclicShedFunc = "ompc_static_csched";
            this.staticShedInitFunc = "ompc_static_sched_init";
            this.staticShedNextFunc = "ompc_static_sched_next";
            this.dynamicShedInitFunc = "ompc_dynamic_sched_init";
            this.dynamicShedNextFunc = "ompc_dynamic_sched_next";
            this.guidedShedInitFunc = "ompc_guided_sched_init";
            this.guidedShedNextFunc = "ompc_guided_sched_next";
            this.runtimeShedInitFunc = "ompc_runtime_sched_init";
            this.runtimeShedNextFunc = "ompc_runtime_sched_next";
            this.affinityShedInitFunc = "ompc_affinity_sched_init";
            this.affinityShedNextFunc = "ompc_affinity_sched_next";
            this.orderedInitFunc = "ompc_init_ordered";
            this.orderedSetLoopIdFunc = "ompc_set_loop_id";
            this.orderedBeginFunc = "ompc_ordered_begin";
            this.orderedEndFunc = "ompc_ordered_end";
            this.threadIdFunc = "ompc_thread_id";
            this.sectionInitFunc = "ompc_section_init";
            this.sectionIdFunc = "ompc_section_id";
            this.doSingleFunc = "ompc_do_single";
            this.enterCriticalFunc = "ompc_enter_critical";
            this.exitCriticalFunc = "ompc_exit_critical";
            this.isMasterFunc = "ompc_is_master";
            this.atomicLockFunc = "ompc_atomic_lock";
            this.atomicUnlockFunc = "ompc_atomic_unlock";
            this.threadLockFunc = "ompc_thread_lock";
            this.threadUnlockFunc = "ompc_thread_unlock";
            this.bcopyFunc = "ompc_bcopy";
            this.isLastFunc = "ompc_is_last";
            this.flushFunc = "ompc_flush";
            this.getThdprvFunc = "ompc_get_thdprv";
            this.copyinThdprvFunc = "ompc_copyin_thdprv";
            this.allocShared = "ompc_alloc_shared";
            this.freeShared = "ompc_free_shared";
            this.allocaFunc = "alloca";
            this.doReduction = "ompc_reduction";
            this.doReductionInit = "ompc_reduction_init";
            this.criticalLockPrefix = "ompc_lock_critical";
            this.reductionLockPrefix = "ompc_lock_reduction";
            this.setNumThreadsFunc = "ompc_set_num_threads";
            this.getNumThreadsFunc = "ompc_get_num_threads";
            this.getThreadNumFunc = "ompc_get_thread_num";
            this.getMaxThreadsFunc = "ompc_get_max_threads";
        } else {
            this.mainFunc = "ompf_main";
            this.OMPfuncPrefix = "ompf_func";
            this.barrierFunc = "ompf_barrier";
            this.currentThreadBarrierFunc = "ompf_current_thread_barrier";
            this.doParallelFunc = "ompf_do_parallel";
            this.doParallelIfFunc = "ompf_do_parallel_if";
            this.parallelTaskFunc = "ompf_parallel_task";
            this.parallelTaskIfFunc = "ompf_parallel_task_if";
            this.defaultShedFunc = "ompf_default_sched";
            this.blockShedFunc = "ompf_static_bsched";
            this.cyclicShedFunc = "ompf_static_csched";
            this.staticShedInitFunc = "ompf_static_sched_init";
            this.staticShedNextFunc = "ompf_static_sched_next";
            this.dynamicShedInitFunc = "ompf_dynamic_sched_init";
            this.dynamicShedNextFunc = "ompf_dynamic_sched_next";
            this.guidedShedInitFunc = "ompf_guided_sched_init";
            this.guidedShedNextFunc = "ompf_guided_sched_next";
            this.runtimeShedInitFunc = "ompf_runtime_sched_init";
            this.runtimeShedNextFunc = "ompf_runtime_sched_next";
            this.affinityShedInitFunc = "ompf_affinity_sched_init";
            this.affinityShedNextFunc = "ompf_affinity_sched_next";
            this.orderedInitFunc = "ompf_init_ordered";
            this.orderedSetLoopIdFunc = "ompf_set_loop_id";
            this.orderedBeginFunc = "ompf_ordered_begin";
            this.orderedEndFunc = "ompf_ordered_end";
            this.threadIdFunc = "ompf_thread_id";
            this.sectionInitFunc = "ompf_section_init";
            this.sectionIdFunc = "ompf_section_id";
            this.doSingleFunc = "ompf_do_single";
            this.enterCriticalFunc = "ompf_enter_critical";
            this.exitCriticalFunc = "ompf_exit_critical";
            this.isMasterFunc = "ompf_is_master";
            this.atomicLockFunc = "ompf_atomic_lock";
            this.atomicUnlockFunc = "ompf_atomic_unlock";
            this.threadLockFunc = "ompf_thread_lock";
            this.threadUnlockFunc = "ompf_thread_unlock";
            this.bcopyFunc = null;
            this.isLastFunc = "ompf_is_last";
            this.flushFunc = "ompf_flush";
            this.getThdprvFunc = null;
            this.copyinThdprvFunc = null;
            this.allocShared = null;
            this.freeShared = null;
            this.allocaFunc = null;
            this.doReduction = "ompf_reduction";
            this.doReductionInit = null;
            this.criticalLockPrefix = "ompf_lock_critical";
            this.reductionLockPrefix = null;
            this.setNumThreadsFunc = "ompf_set_num_threads";
            this.getNumThreadsFunc = "ompf_get_num_threads";
            this.getThreadNumFunc = "ompf_get_thread_num";
            this.getMaxThreadsFunc = "ompf_get_max_threads";
            this.setBoundsFuncPrefix = "ompf_set_bounds_";
            this.saveArrayFunc = "ompf_save_array_header";
            this.loadArrayFunc = "ompf_load_array_header";
        }
    }

    public void run(FuncDefBlock funcDefBlock) {
        FunctionBlock functionBlock = funcDefBlock.getBlock();
        this.current_def = funcDefBlock.getDef();
        this.env = this.current_def.getFile();
        OMP.debug("pass3:");
        bottomupBlockIterator bottomupBlockIterator2 = new bottomupBlockIterator(functionBlock);
        ((BlockIterator)bottomupBlockIterator2).init();
        while (!((BlockIterator)bottomupBlockIterator2).end()) {
            Block block = bottomupBlockIterator2.getBlock();
            if (block.Opcode() == Xcode.OMP_PRAGMA && (block = this.transPragma((PragmaBlock)block)) != null) {
                bottomupBlockIterator2.setBlock(block);
            }
            ((BlockIterator)bottomupBlockIterator2).next();
        }
        Block block = ((Block)functionBlock).getBody().getHead();
        this.transFunctionBody((CompoundBlock)block, ((Block)functionBlock).getBody().getDecls());
    }

    public Ident OMPfuncIdent(String string) {
        if (string == null) {
            throw new IllegalArgumentException("may be generating unsupported function call");
        }
        FunctionType functionType = XmOption.isLanguageC() ? (string == this.getThdprvFunc || string == this.allocShared || string == this.allocaFunc ? Xtype.Function(Xtype.Pointer(Xtype.voidType)) : Xtype.Function(Xtype.intType)) : (string == this.getMaxThreadsFunc || string == this.getThreadNumFunc || string == this.getNumThreadsFunc || string == this.sectionIdFunc ? Xtype.FintFunctionType : (string == this.isLastFunc || string == this.isMasterFunc || string == this.doSingleFunc || string == this.staticShedNextFunc || string == this.dynamicShedNextFunc || string == this.guidedShedNextFunc || string == this.runtimeShedNextFunc || string == this.affinityShedNextFunc ? Xtype.FlogicalFunctionType : Xtype.FsubroutineType));
        return this.current_def.declExternIdent(string, functionType);
    }

    public Ident OMPFintrinsicIdent(String string) {
        FunctionType functionType = string == "allocated" ? Xtype.FlogicalFunctionType : Xtype.FintFunctionType;
        return Ident.Fident(string, functionType, false, false, this.env);
    }

    public Block transPragma(PragmaBlock pragmaBlock, XobjectDef xobjectDef) {
        this.current_def = xobjectDef;
        this.env = xobjectDef.getFile();
        return this.transPragma(pragmaBlock);
    }

    Block transPragma(PragmaBlock pragmaBlock) {
        OMPinfo oMPinfo = (OMPinfo)pragmaBlock.getProp("OMPprop");
        OMP.debug("Pragma:" + (Object)((Object)oMPinfo.pragma));
        switch (oMPinfo.pragma) {
            case BARRIER: {
                return this.transBarrier(pragmaBlock, oMPinfo);
            }
            case PARALLEL: {
                return this.transParallelRegion(pragmaBlock, oMPinfo);
            }
            case FOR: {
                if (pragmaBlock.getBody().getHead().Opcode() == Xcode.OMP_PRAGMA) {
                    return null;
                }
                return this.transFor(pragmaBlock, oMPinfo);
            }
            case SECTIONS: {
                return this.transSections(pragmaBlock, oMPinfo);
            }
            case SINGLE: {
                return this.transSingle(pragmaBlock, oMPinfo);
            }
            case MASTER: {
                return this.transMaster(pragmaBlock, oMPinfo);
            }
            case CRITICAL: {
                return this.transCritical(pragmaBlock, oMPinfo);
            }
            case ATOMIC: {
                return this.transAtomic(pragmaBlock, oMPinfo);
            }
            case FLUSH: {
                return this.transFlush(pragmaBlock, oMPinfo);
            }
            case ORDERED: {
                return this.transOrdered(pragmaBlock, oMPinfo);
            }
            case TASK: {
                return this.transTaskRegion(pragmaBlock, oMPinfo);
            }
            case SIMD: {
                return null;
            }
        }
        OMP.fatal("unknown pragma");
        return null;
    }

    public Block transBarrier(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        return Bcons.Statement(this.OMPfuncIdent(this.barrierFunc).Call(null));
    }

    public Block transParallelRegion(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        if (XmOption.isLanguageC()) {
            return this.transCparallelRegion(pragmaBlock, oMPinfo);
        }
        return this.transFparallelRegion(pragmaBlock, oMPinfo);
    }

    public Block transCparallelRegion(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        Ident ident = this.current_def.declStaticIdent(this.env.genSym(this.OMPfuncPrefix), Xtype.Function(Xtype.voidType));
        BlockList blockList = Bcons.emptyBody(oMPinfo.getIdList(), null);
        this.addDataSetupBlock(blockList, oMPinfo);
        this.threadprivateCSetup(blockList, oMPinfo);
        blockList.add(Bcons.COMPOUND(pragmaBlock.getBody()));
        Block block = this.dataUpdateBlock(oMPinfo);
        if (block != null) {
            blockList.add(block);
        }
        this.addCcalleeBlock(blockList, ident, oMPinfo);
        BlockList blockList2 = Bcons.emptyBody();
        this.addCcallerBlock(blockList2, ident, oMPinfo);
        return Bcons.COMPOUND(blockList2);
    }

    private void addCcallerBlock(BlockList blockList, Ident ident, OMPinfo oMPinfo) {
        List<Xobject> list = oMPinfo.getRegionArgs();
        if (list.size() == 0) {
            if (oMPinfo.hasIfExpr()) {
                blockList.add(Bcons.Statement(this.OMPfuncIdent(this.doParallelIfFunc).Call(Xcons.List(oMPinfo.getIfExpr(), ident.Ref()))));
            } else {
                blockList.add(Bcons.Statement(this.OMPfuncIdent(this.doParallelFunc).Call(Xcons.List(ident.Ref()))));
            }
            return;
        }
        BasicBlock basicBlock = new BasicBlock();
        Xtype xtype = Xtype.Pointer(Xtype.voidType);
        Ident ident2 = Ident.Local(ARGV_VAR, Xtype.Array(xtype, list.size()));
        blockList.addIdent(ident2);
        for (int i = 0; i < list.size(); ++i) {
            Xobject xobject = list.get(i);
            xobject = Xcons.Set(ident2.Index(i), Xcons.Cast(xtype, xobject));
            basicBlock.add(xobject);
        }
        if (oMPinfo.getNumThreads() != null) {
            basicBlock.add(this.OMPfuncIdent(this.setNumThreadsFunc).Call(Xcons.List(oMPinfo.getNumThreads())));
        }
        if (oMPinfo.getIfExpr() != null) {
            basicBlock.add(this.OMPfuncIdent(this.doParallelIfFunc).Call(Xcons.List(oMPinfo.getIfExpr(), ident.Ref(), ident2.Ref())));
        } else {
            basicBlock.add(this.OMPfuncIdent(this.doParallelFunc).Call(Xcons.List(ident.Ref(), ident2.Ref())));
        }
        blockList.add(basicBlock);
    }

    private void addCcalleeBlock(BlockList blockList, Ident ident, OMPinfo oMPinfo) {
        XobjList xobjList = Xcons.IDList();
        if (oMPinfo.getRegionParams().size() != 0) {
            BasicBlock basicBlock = new BasicBlock();
            Xtype xtype = Xtype.Pointer(Xtype.voidType);
            Ident ident2 = Ident.Param(ARGS_VAR, Xtype.Pointer(xtype));
            ((Xobject)xobjList).add(ident2);
            for (int i = 0; i < oMPinfo.getRegionParams().size(); ++i) {
                Xobject xobject = oMPinfo.getRegionParams().get(i).Ref();
                xobject = Xcons.Set(xobject, Xcons.Cast(xobject.Type(), ident2.Index(i)));
                basicBlock.add(xobject);
            }
            blockList.insert(basicBlock);
        }
        ((FunctionType)ident.Type()).setFuncParamIdList(xobjList);
        this.current_def.insertBeforeThis(XobjectDef.Func(ident, xobjList, null, blockList.toXobject()));
    }

    private void addFcallerBlock(BlockList blockList, Ident ident, Ident ident2, OMPinfo oMPinfo) {
        List<Xobject> list = oMPinfo.getRegionArgs();
        BasicBlock basicBlock = new BasicBlock();
        XobjList xobjList = Xcons.List(ident.getAddr());
        for (Xobject xobject : list) {
            xobjList.add(xobject);
        }
        if (oMPinfo.getNumThreads() != null) {
            basicBlock.add(this.OMPfuncIdent(this.setNumThreadsFunc).Call(Xcons.List(oMPinfo.getNumThreads())));
        }
        if (oMPinfo.hasIfExpr()) {
            xobjList.insert(oMPinfo.getIfExpr());
        }
        basicBlock.add(ident2.Call(xobjList));
        blockList.add(basicBlock);
    }

    private void addFtaskCallerBlock(BlockList blockList, Ident ident, Ident ident2, OMPinfo oMPinfo) {
        List<Xobject> list = oMPinfo.getRegionArgs();
        BasicBlock basicBlock = new BasicBlock();
        XobjList xobjList = Xcons.List(ident.getAddr());
        for (Xobject xobject : list) {
            xobjList.add(xobject);
        }
        if (oMPinfo.getNumThreads() != null) {
            basicBlock.add(this.OMPfuncIdent(this.setNumThreadsFunc).Call(Xcons.List(oMPinfo.getNumThreads())));
        }
        if (oMPinfo.hasFinalExpr()) {
            xobjList.insert(oMPinfo.getFinalExpr());
        }
        if (oMPinfo.hasIfExpr()) {
            xobjList.insert(oMPinfo.getIfExpr());
        }
        basicBlock.add(ident2.Call(xobjList));
        blockList.add(basicBlock);
    }

    private void addFcalleeBlock(Ident ident, Ident ident2, BlockList blockList, XobjList xobjList, XobjList xobjList2, BlockList blockList2, OMPinfo oMPinfo) {
        XobjList xobjList3 = Xcons.List();
        for (Object object : xobjList) {
            xobjList3.add((Xobject)object);
        }
        if (blockList2.getDecls() != null) {
            Object object;
            HashMap hashMap = new HashMap();
            for (Xobject xobject : xobjList) {
                Ident ident3 = (Ident)xobject;
                hashMap.put(ident3.getName(), ident3);
            }
            object = new FidentCollector(blockList2, hashMap);
            ((FidentCollector)object).collectIdentName(blockList.toXobject(), oMPinfo);
            ((FidentCollector)object).copyDecls(xobjList, xobjList2, blockList, oMPinfo, false);
        }
        this.completeFstructTypeSymbol(blockList2.getIdentList(), xobjList);
        ((FunctionType)ident.Type()).setFuncParamIdList(xobjList3);
        this.current_def.insertBeforeThis(XobjectDef.Func(ident, xobjList, xobjList2, blockList.toXobject()));
    }

    private void transFioStatements(BlockList blockList) {
        if (!XmOption.isLanguageF() || !XmOption.isAtomicIO()) {
            return;
        }
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(blockList);
        topdownBlockIterator2.init();
        while (!topdownBlockIterator2.end()) {
            BasicBlock basicBlock;
            Block block = topdownBlockIterator2.getBlock();
            if (block != null && (basicBlock = block.getBasicBlock()) != null) {
                block4: for (Statement statement = basicBlock.getHead(); statement != null; statement = statement.getNext()) {
                    Xobject xobject = statement.getExpr();
                    if (xobject == null) continue;
                    switch (xobject.Opcode()) {
                        case F_PRINT_STATEMENT: 
                        case F_WRITE_STATEMENT: 
                        case F_READ_STATEMENT: 
                        case F_OPEN_STATEMENT: 
                        case F_CLOSE_STATEMENT: 
                        case F_INQUIRE_STATEMENT: 
                        case F_REWIND_STATEMENT: 
                        case F_END_FILE_STATEMENT: 
                        case F_BACKSPACE_STATEMENT: {
                            break;
                        }
                        default: {
                            continue block4;
                        }
                    }
                    if (xobject.isAtomicStmt()) continue;
                    xobject.setIsAtomicStmt(true);
                    block.insert(this.OMPfuncIdent(this.atomicLockFunc).Call());
                    block.add(this.OMPfuncIdent(this.atomicUnlockFunc).Call());
                }
            }
            topdownBlockIterator2.next();
        }
    }

    private void completeFstructTypeSymbol(XobjList xobjList, XobjList xobjList2) {
        ArrayList<Ident> arrayList = new ArrayList<Ident>();
        for (Xobject xobject : xobjList) {
            if (!StorageClass.FTYPE_NAME.equals((Object)((Ident)xobject).getStorageClass())) continue;
            arrayList.add((Ident)xobject);
        }
        for (Xobject xobject : xobjList2) {
            Xtype xtype = xobject.Type();
            if (xtype == null) continue;
            if (xtype.isFarray()) {
                xtype = xtype.getRef();
            }
            if (xtype == null || !xtype.isStruct()) continue;
            Ident ident = xtype.getTagIdent();
            if (ident == null) {
                throw new IllegalStateException();
            }
            if (xobjList2.find(ident.getName(), 3) != null) continue;
            arrayList.add(xtype.getTagIdent());
        }
        for (Ident ident : arrayList) {
            xobjList2.add(ident);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addFdoParallelWrapperBlock(Ident ident, XobjList xobjList, BlockList blockList, OMPinfo oMPinfo) {
        Xobject xobject222;
        XobjList xobjList2 = Xcons.List();
        int n = xobjList.Nargs();
        OMP.debug("nargs 0=" + n);
        for (Xobject xobject222 : xobjList) {
            OMP.debug("func_params =" + xobject222.Type().toString());
            if (xobject222.Type().isFcharacter()) {
                ++n;
            }
            xobjList2.add(xobject222);
        }
        OMP.debug("nargs=" + n);
        if (XmOption.isLanguageF() && n > 64) {
            XmLog.fatal((ILineNo)blockList.getHeadLineNo(), (String)"too many variables in parallel region.");
        }
        Ident ident2 = Ident.FidentNotExternal("ompf_func", Xtype.FsubroutineType);
        xobjList.insert(ident2);
        xobjList2.insert(ident2);
        xobject222 = null;
        if (oMPinfo.hasIfExpr()) {
            xobject222 = Ident.Fident(COND_VAR, Xtype.FlogicalType);
            xobjList.insert(xobject222);
        } else {
            xobject222 = Xcons.FlogicalConstant(true);
        }
        xobjList2.insert(xobject222);
        XobjList xobjList3 = Xcons.List();
        HashMap<String, Ident> hashMap = new HashMap<String, Ident>();
        FidentCollector fidentCollector = new FidentCollector(blockList, hashMap);
        for (Xobject xobject : xobjList) {
            void xobject3;
            if (xobject == ident2) {
                Xobject xobject2 = xobject.copy();
                xobject2.setType(Xtype.FexternalSubroutineType);
            }
            xobjList3.add((Xobject)xobject3);
            fidentCollector.collectIdentInIdent((Ident)xobject3);
        }
        for (Ident ident3 : hashMap.values()) {
            xobjList3.add(ident3);
        }
        this.completeFstructTypeSymbol(blockList.getIdentList(), xobjList3);
        BlockList blockList2 = new BlockList();
        Ident ident4 = Ident.FidentNotExternal(this.doParallelFunc + "_" + n, Xtype.FsubroutineType);
        blockList2.add(ident4.Call(xobjList2));
        ((FunctionType)ident.Type()).setFuncParamIdList(xobjList);
        XobjList xobjList4 = Xcons.List();
        hashMap.clear();
        fidentCollector.copyDecls(xobjList3, xobjList4, blockList2, oMPinfo, true);
        XobjectDef xobjectDef = XobjectDef.Func(ident, xobjList3, xobjList4, blockList2.toXobject());
        this.current_def.insertBeforeThis(xobjectDef);
        XobjList xobjList5 = (XobjList)ident4.Type().getFuncParam();
        if (xobjList5 == null) {
            xobjList5 = Xcons.List();
            ((FunctionType)ident4.Type()).setFuncParam(xobjList5);
        }
        XobjList xobjList6 = Xcons.List();
        Ident ident5 = Ident.FidentNotExternal("ompf_func", Xtype.FsubroutineType);
        if (!oMPinfo.hasIfExpr()) {
            Ident ident6 = Ident.Fident("cond", Xtype.FlogicalType);
            xobjList6.add(Xcons.List(Xcode.VAR_DECL, ident6));
            xobjList5.add(ident6);
        }
        xobjList6.add(Xcons.FinterfaceFunctionDecl(ident5, null));
        for (Xobject xobject : xobjList) {
            xobject = this.convertFidentTypeForParamDecl((Ident)xobject, oMPinfo);
            xobjList6.add(Xcons.List(Xcode.VAR_DECL, xobject));
            xobjList5.add(xobject);
        }
        this.copyFuseDecl(blockList.getDecls(), xobjList6);
        xobjectDef.getFuncDecls().add(Xcons.FinterfaceFunctionDecl(ident4, xobjList6));
    }

    /*
     * WARNING - void declaration
     */
    private void addFtaskWrapperBlock(Ident ident, XobjList xobjList, BlockList blockList, OMPinfo oMPinfo) {
        Object object;
        Xobject xobject222;
        XobjList xobjList2 = Xcons.List();
        int n = xobjList.Nargs();
        OMP.debug("nargs 0=" + n);
        for (Xobject xobject222 : xobjList) {
            OMP.debug("func_params =" + xobject222.Type().toString());
            if (xobject222.Type().isFcharacter()) {
                ++n;
            }
            xobjList2.add(xobject222);
        }
        OMP.debug("nargs =" + n);
        if (XmOption.isLanguageF() && n > 64) {
            XmLog.fatal((ILineNo)blockList.getHeadLineNo(), (String)"too many variables in parallel region.");
        }
        Ident ident2 = Ident.FidentNotExternal("ompf_func", Xtype.FsubroutineType);
        xobjList.insert(ident2);
        xobjList2.insert(ident2);
        xobject222 = null;
        if (oMPinfo.hasFinalExpr()) {
            xobject222 = Ident.Fident("TASK_p__cond_F", Xtype.FlogicalType);
            xobjList.insert(xobject222);
        } else {
            xobject222 = Xcons.FlogicalConstant(false);
        }
        xobjList2.insert(xobject222);
        if (oMPinfo.hasIfExpr()) {
            xobject222 = Ident.Fident("TASK_p__cond", Xtype.FlogicalType);
            xobjList.insert(xobject222);
        } else {
            xobject222 = Xcons.FlogicalConstant(true);
        }
        xobjList2.insert(xobject222);
        XobjList xobjList3 = Xcons.List();
        HashMap<String, Ident> hashMap = new HashMap<String, Ident>();
        FidentCollector fidentCollector = new FidentCollector(blockList, hashMap);
        for (Xobject xobject : xobjList) {
            void xobject3;
            if (xobject == ident2) {
                Xobject xobject2 = xobject.copy();
                xobject2.setType(Xtype.FexternalSubroutineType);
            }
            xobjList3.add((Xobject)xobject3);
            fidentCollector.collectIdentInIdent((Ident)xobject3);
        }
        for (Ident ident3 : hashMap.values()) {
            xobjList3.add(ident3);
        }
        this.completeFstructTypeSymbol(blockList.getIdentList(), xobjList3);
        BlockList blockList2 = new BlockList();
        Ident ident4 = Ident.FidentNotExternal(this.parallelTaskFunc + "_" + n, Xtype.FsubroutineType);
        blockList2.add(ident4.Call(xobjList2));
        ((FunctionType)ident.Type()).setFuncParamIdList(xobjList);
        XobjList xobjList4 = Xcons.List();
        hashMap.clear();
        fidentCollector.copyDecls(xobjList3, xobjList4, blockList2, oMPinfo, true);
        XobjectDef xobjectDef = XobjectDef.Func(ident, xobjList3, xobjList4, blockList2.toXobject());
        this.current_def.insertBeforeThis(xobjectDef);
        XobjList xobjList5 = (XobjList)ident4.Type().getFuncParam();
        if (xobjList5 == null) {
            xobjList5 = Xcons.List();
            ((FunctionType)ident4.Type()).setFuncParam(xobjList5);
        }
        XobjList xobjList6 = Xcons.List();
        Ident ident5 = Ident.FidentNotExternal("ompf_func", Xtype.FsubroutineType);
        if (!oMPinfo.hasFinalExpr()) {
            object = Ident.Fident("cond_F", Xtype.FlogicalType);
            xobjList6.add(Xcons.List(Xcode.VAR_DECL, new Xobject[]{object}));
            xobjList5.add((Xobject)object);
        }
        if (!oMPinfo.hasIfExpr()) {
            object = Ident.Fident("cond", Xtype.FlogicalType);
            xobjList6.add(Xcons.List(Xcode.VAR_DECL, new Xobject[]{object}));
            xobjList5.add((Xobject)object);
        }
        xobjList6.add(Xcons.FinterfaceFunctionDecl(ident5, null));
        for (Xobject xobject : xobjList) {
            xobject = this.convertFidentTypeForParamDecl((Ident)xobject, oMPinfo);
            xobjList6.add(Xcons.List(Xcode.VAR_DECL, xobject));
            xobjList5.add(xobject);
        }
        this.copyFuseDecl(blockList.getDecls(), xobjList6);
        xobjectDef.getFuncDecls().add(Xcons.FinterfaceFunctionDecl(ident4, xobjList6));
    }

    private void copyFuseDecl(Xobject xobject, Xobject xobject2) {
        if (xobject == null) {
            return;
        }
        XobjList xobjList = Xcons.List();
        for (Xobject xobject3 : (XobjList)xobject) {
            if (xobject3.Opcode() != Xcode.F_USE_DECL && xobject3.Opcode() != Xcode.F_USE_ONLY_DECL) continue;
            xobjList.add(xobject3);
        }
        xobjList.reverse();
        for (Xobject xobject3 : xobjList) {
            xobject2.insert(xobject3);
        }
    }

    private Ident convertFidentTypeForParamDecl(Ident ident, OMPinfo oMPinfo) {
        Xtype xtype = ident.Type();
        switch (xtype.getKind()) {
            case 1: {
                if (!xtype.isFcharacter() || xtype.getFlen() == null) break;
                xtype = xtype.copy();
                ident = (Ident)ident.copy();
                ident.setType(xtype);
                ((BasicType)xtype).setFlen(Xcons.IntConstant(-1));
                break;
            }
            case 8: {
                xtype = xtype.copy();
                ident = (Ident)ident.copy();
                ident.setType(xtype);
                if (xtype.isFassumedShape()) {
                    xtype.convertFindexRange(false, false, oMPinfo.getBlock());
                    break;
                }
                Xobject[] xobjectArray = xtype.getFarraySizeExpr();
                for (int i = 0; i < xtype.getNumDimensions(); ++i) {
                    xobjectArray[i] = Xcons.FindexRange(Xcons.IntConstant(1), Xcons.IntConstant(1));
                }
                xtype.convertFindexRange(true, true, oMPinfo.getBlock());
            }
        }
        return ident;
    }

    public Block transFparallelRegion(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        Xobject xobject2;
        Object object2;
        FunctionBlock functionBlock;
        Ident ident = this.current_def.declExternIdent(this.env.genExportSym(this.OMPfuncPrefix, this.current_def.getName()), Xtype.FsubroutineType);
        Ident ident2 = Ident.FidentNotExternal(this.env.genExportSym("ompf_dop", this.current_def.getName()), Xtype.FsubroutineType);
        BlockList blockList = Bcons.emptyBody(oMPinfo.getIdList(), null);
        this.addDataSetupBlock(blockList, oMPinfo);
        blockList.add(Bcons.COMPOUND(pragmaBlock.getBody()));
        Block block = this.dataUpdateBlock(oMPinfo);
        if (block != null) {
            blockList.add(block);
        }
        if ((functionBlock = OMPtransPragma.getParentFuncBlock(pragmaBlock)) == null) {
            throw new IllegalStateException("parent is not FunctionBlock");
        }
        XobjList xobjList = Xcons.List();
        BlockList blockList2 = functionBlock.getBody();
        OMP.debug("transParallelRegion" + blockList2.getDecls().toString());
        this.threadprivateFSetup(xobjList, blockList2.getDecls(), blockList, oMPinfo, true);
        OMP.debug("fbBody:" + blockList2.getDecls().toString());
        XobjList xobjList2 = Xcons.List();
        for (Ident object22 : oMPinfo.getRegionParams()) {
            xobjList2.add(object22);
        }
        XobjList xobjList3 = Xcons.List();
        for (Object object2 : xobjList2) {
            xobjList3.add((Xobject)object2);
        }
        this.transFioStatements(blockList2);
        OMPrewriteExpr oMPrewriteExpr = new OMPrewriteExpr();
        for (Xobject xobject2 : (XobjList)oMPinfo.getIdList()) {
            oMPrewriteExpr.run(xobject2, pragmaBlock, oMPinfo.env);
        }
        this.addFcalleeBlock(ident, ident2, blockList, xobjList2, xobjList, blockList2, oMPinfo);
        this.addFdoParallelWrapperBlock(ident2, xobjList3, blockList2, oMPinfo);
        object2 = Bcons.emptyBody();
        this.addFcallerBlock((BlockList)object2, ident, ident2, oMPinfo);
        xobject2 = Xcons.List();
        Ident ident3 = Ident.FidentNotExternal("ompf_func", Xtype.FsubroutineType);
        ((XobjList)xobject2).add(Xcons.FinterfaceFunctionDecl(ident3, null));
        Object object3 = xobjList3.iterator();
        while (object3.hasNext()) {
            Xobject xobject3 = object3.next();
            xobject3 = this.convertFidentTypeForParamDecl((Ident)xobject3, oMPinfo);
            oMPrewriteExpr.run(xobject3, pragmaBlock, oMPinfo.env);
            ((XobjList)xobject2).add(Xcons.List(Xcode.VAR_DECL, xobject3));
        }
        object3 = blockList2.getDecls();
        this.copyFuseDecl((Xobject)object3, xobject2);
        if (object3 == null) {
            object3 = Xcons.List();
            blockList2.setDecls((Xobject)object3);
        }
        ((Xobject)object3).add(Xcons.FinterfaceFunctionDecl(ident2, (XobjList)xobject2));
        return Bcons.COMPOUND((BlockList)object2);
    }

    public Block transFtaskRegion(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        Xobject xobject2;
        Object object2;
        FunctionBlock functionBlock;
        Ident ident = this.current_def.declExternIdent(this.env.genExportSym(this.OMPfuncPrefix, this.current_def.getName()), Xtype.FsubroutineType);
        Ident ident2 = Ident.FidentNotExternal(this.env.genExportSym("ompf_ptask", this.current_def.getName()), Xtype.FsubroutineType);
        BlockList blockList = Bcons.emptyBody(oMPinfo.getIdList(), null);
        this.addDataSetupBlock(blockList, oMPinfo);
        blockList.add(Bcons.COMPOUND(pragmaBlock.getBody()));
        Block block = this.dataUpdateBlock(oMPinfo);
        if (block != null) {
            blockList.add(block);
        }
        if ((functionBlock = OMPtransPragma.getParentFuncBlock(pragmaBlock)) == null) {
            throw new IllegalStateException("parent is not FunctionBlock");
        }
        XobjList xobjList = Xcons.List();
        BlockList blockList2 = functionBlock.getBody();
        OMP.debug("transFtaskRegion" + blockList2.getDecls().toString());
        this.threadprivateFSetup(xobjList, blockList2.getDecls(), blockList, oMPinfo, true);
        XobjList xobjList2 = Xcons.List();
        for (Ident object22 : oMPinfo.getRegionParams()) {
            xobjList2.add(object22);
        }
        XobjList xobjList3 = Xcons.List();
        for (Object object2 : xobjList2) {
            xobjList3.add((Xobject)object2);
        }
        this.transFioStatements(blockList2);
        OMPrewriteExpr oMPrewriteExpr = new OMPrewriteExpr();
        for (Xobject xobject2 : (XobjList)oMPinfo.getIdList()) {
            OMP.debug("Task" + xobject2.toString() + " " + pragmaBlock.toXobject().toString() + " " + (Object)((Object)oMPinfo.pragma));
            oMPrewriteExpr.run(xobject2, pragmaBlock, oMPinfo.env);
        }
        this.addFcalleeBlock(ident, ident2, blockList, xobjList2, xobjList, blockList2, oMPinfo);
        this.addFtaskWrapperBlock(ident2, xobjList3, blockList2, oMPinfo);
        object2 = Bcons.emptyBody();
        this.addFtaskCallerBlock((BlockList)object2, ident, ident2, oMPinfo);
        xobject2 = Xcons.List();
        Ident ident3 = Ident.FidentNotExternal("ompf_func", Xtype.FsubroutineType);
        ((XobjList)xobject2).add(Xcons.FinterfaceFunctionDecl(ident3, null));
        Object object3 = xobjList3.iterator();
        while (object3.hasNext()) {
            Xobject xobject3 = object3.next();
            xobject3 = this.convertFidentTypeForParamDecl((Ident)xobject3, oMPinfo);
            oMPrewriteExpr.run(xobject3, pragmaBlock, oMPinfo.env);
            ((XobjList)xobject2).add(Xcons.List(Xcode.VAR_DECL, xobject3));
        }
        object3 = blockList2.getDecls();
        this.copyFuseDecl((Xobject)object3, xobject2);
        if (object3 == null) {
            object3 = Xcons.List();
            blockList2.setDecls((Xobject)object3);
        }
        ((Xobject)object3).add(Xcons.FinterfaceFunctionDecl(ident2, (XobjList)xobject2));
        return Bcons.COMPOUND((BlockList)object2);
    }

    private static FunctionBlock getParentFuncBlock(Block block) {
        Block block2 = block.getParentBlock();
        if (block2 == null) {
            return null;
        }
        if (block2 instanceof FunctionBlock) {
            return (FunctionBlock)block2;
        }
        return OMPtransPragma.getParentFuncBlock(block2);
    }

    public Block transFor(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        Block block;
        Xobject xobject;
        Object object2;
        Xobject xobject2;
        Xobject xobject3;
        Xobject xobject4;
        Xobject xobject5;
        ForBlock forBlock = (ForBlock)((Object)pragmaBlock.getBody().getHead());
        forBlock.Canonicalize();
        if (!forBlock.isCanonical()) {
            OMP.fatal("transFor: not canonical");
        }
        BlockList blockList = Bcons.emptyBody(Xcons.IDList(), null);
        CompoundBlock compoundBlock = (CompoundBlock)Bcons.COMPOUND(blockList);
        Xobject xobject6 = forBlock.getInductionVar();
        BlockList blockList2 = Bcons.emptyBody(oMPinfo.getIdList(), null);
        this.addDataSetupBlock(blockList2, oMPinfo);
        boolean bl = xobject6.Type().isPointer();
        boolean bl2 = XmOption.isLanguageC() && !MachineDep.sizeEquals(xobject6.Type(), Xtype.indvarPtrType, pragmaBlock);
        Xtype xtype = XmOption.isLanguageC() ? Xtype.indvarType : Xtype.FuintPtrType;
        Xtype xtype2 = MachineDep.getUintPtrType();
        Xtype xtype3 = XmOption.isLanguageC() ? xobject6.Type() : xtype;
        Xtype xtype4 = bl ? Xtype.intType : xobject6.Type();
        Ident ident = Ident.Local(this.env.genSym(xobject6.getName()), xtype3);
        Ident ident2 = Ident.Local(this.env.genSym(xobject6.getName()), xtype3);
        Ident ident3 = Ident.Local(this.env.genSym(xobject6.getName()), xtype4);
        blockList2.addIdent(ident);
        blockList2.addIdent(ident2);
        blockList2.addIdent(ident3);
        Xobject xobject7 = ident3.getAddr();
        Xobject xobject8 = ident3.Ref();
        Ident ident4 = null;
        Ident ident5 = null;
        if (bl2) {
            ident4 = Ident.Local(this.env.genSym(xobject6.getName()), Xtype.indvarType);
            ident5 = Ident.Local(this.env.genSym(xobject6.getName()), Xtype.indvarType);
            xobject5 = ident4.Ref();
            xobject4 = ident5.Ref();
            xobject3 = ident4.getAddr();
            xobject2 = ident5.getAddr();
            blockList2.addIdent(ident4);
            blockList2.addIdent(ident5);
            blockList.add(Xcons.Set(ident.Ref(), Xcons.Cast(ident.Type(), Xcons.Cast(xtype2, xobject5))));
            blockList.add(Xcons.Set(ident2.Ref(), Xcons.Cast(ident2.Type(), Xcons.Cast(xtype2, xobject4))));
            blockList.add((Block)((Object)forBlock));
        } else {
            xobject5 = ident.Ref();
            xobject4 = ident2.Ref();
            xobject3 = ident.getAddr();
            xobject2 = ident2.getAddr();
            blockList.add((Block)((Object)forBlock));
        }
        BasicBlock basicBlock = new BasicBlock();
        blockList2.add(basicBlock);
        if (forBlock.getInitBBlock() != null) {
            for (Object object2 : forBlock.getInitBBlock()) {
                if (((Statement)object2).getNext() == null) break;
                ((Statement)object2).remove();
                basicBlock.add((Statement)object2);
            }
        }
        basicBlock.add(Xcons.Set(ident.Ref(), forBlock.getLowerBound()));
        basicBlock.add(Xcons.Set(ident2.Ref(), forBlock.getUpperBound()));
        if (bl2) {
            basicBlock.add(Xcons.Set(xobject5, Xcons.Cast(xtype, Xcons.Cast(xtype2, ident.Ref()))));
            basicBlock.add(Xcons.Set(xobject4, Xcons.Cast(xtype, Xcons.Cast(xtype2, ident2.Ref()))));
        }
        if (bl) {
            basicBlock.add(Xcons.Set(ident3.Ref(), Xcons.binaryOp(Xcode.MUL_EXPR, forBlock.getStep(), Xcons.SizeOf(xobject6.Type().getRef()))));
        } else {
            basicBlock.add(Xcons.Set(ident3.Ref(), forBlock.getStep()));
        }
        if (oMPinfo.getNumThreads() != null) {
            basicBlock.add(this.OMPfuncIdent(this.setNumThreadsFunc).Call(Xcons.List(oMPinfo.getNumThreads())));
        }
        forBlock.setLowerBound(ident.Ref());
        forBlock.setUpperBound(ident2.Ref());
        if (bl) {
            forBlock.setStep(Xcons.binaryOp(Xcode.DIV_EXPR, xobject8, Xcons.SizeOf(xobject6.Type().getRef())));
        } else {
            forBlock.setStep(xobject8);
        }
        if (oMPinfo.ordered) {
            boolean bl3 = false;
            object2 = xobject6;
            basicBlock.add(this.OMPfuncIdent(this.orderedInitFunc).Call(Xcons.List(xobject5, ident3.Ref())));
            if (XmOption.isLanguageC()) {
                xobject = this.OMPfuncIdent(this.orderedSetLoopIdFunc).Call(Xcons.List(Xcons.Cast(xtype, xobject6)));
            } else {
                boolean bl4 = bl3 = !MachineDep.sizeEquals(xtype3, xobject6.Type(), pragmaBlock);
                if (bl3) {
                    object2 = Ident.Fident(this.env.genSym(xobject6.getName()), xtype3);
                    blockList2.addIdent((Ident)object2);
                    object2 = ((Ident)object2).getAddr();
                }
                xobject = this.OMPfuncIdent(this.orderedSetLoopIdFunc).Call(Xcons.List(new Xobject[]{object2}));
            }
            forBlock.getBody().insert(xobject);
            if (bl3) {
                forBlock.getBody().insert(Xcons.Set((Xobject)object2, xobject6));
            }
        }
        boolean bl5 = bl2;
        switch (oMPinfo.sched) {
            case SCHED_NONE: {
                basicBlock.add(this.OMPfuncIdent(this.defaultShedFunc).Call(Xcons.List(xobject3, xobject2, xobject7)));
                blockList2.add(compoundBlock);
                break;
            }
            case SCHED_STATIC: {
                if (oMPinfo.sched_chunk == null) {
                    basicBlock.add(this.OMPfuncIdent(this.blockShedFunc).Call(Xcons.List(xobject3, xobject2, xobject7)));
                    blockList2.add(compoundBlock);
                    bl5 = false;
                    break;
                }
                if (oMPinfo.sched_chunk.Opcode() == Xcode.INT_CONSTANT && oMPinfo.sched_chunk.getInt() == 1) {
                    object2 = Ident.Local(this.env.genSym(xobject6.getName()), xtype4);
                    blockList2.addIdent((Ident)object2);
                    basicBlock.add(Xcons.Set(((Ident)object2).Ref(), ident3.Ref()));
                    basicBlock.add(this.OMPfuncIdent(this.cyclicShedFunc).Call(Xcons.List(xobject3, xobject2, xobject7)));
                    blockList2.add(compoundBlock);
                    xobject = Xcons.Set(xobject6, Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.binaryOp(Xcode.MINUS_EXPR, xobject6, ident3.Ref()), ((Ident)object2).Ref()));
                    blockList2.add(Bcons.Statement(xobject));
                    bl5 = false;
                    break;
                }
                basicBlock.add(this.OMPfuncIdent(this.staticShedInitFunc).Call(Xcons.List(xobject5, xobject4, xobject8, oMPinfo.sched_chunk)));
                blockList2.add(Bcons.DO_WHILE(this.OMPfuncIdent(this.staticShedNextFunc).Call(Xcons.List(xobject3, xobject2)), compoundBlock));
                break;
            }
            case SCHED_AFFINITY: {
                object2 = Xcons.List(xobject5, xobject4, xobject8);
                ((Xobject)object2).add(oMPinfo.sched_chunk.getArg(0));
                ((Xobject)object2).add(oMPinfo.sched_chunk.getArg(1));
                ((Xobject)object2).add(oMPinfo.sched_chunk.getArg(2));
                ((Xobject)object2).add(oMPinfo.sched_chunk.getArg(3));
                basicBlock.add(this.OMPfuncIdent(this.affinityShedInitFunc).Call((Xobject)object2));
                blockList2.add(Bcons.DO_WHILE(this.OMPfuncIdent(this.affinityShedNextFunc).Call(Xcons.List(xobject3, xobject2)), compoundBlock));
                break;
            }
            case SCHED_DYNAMIC: {
                if (oMPinfo.sched_chunk == null) {
                    oMPinfo.sched_chunk = Xcons.IntConstant(1);
                }
                basicBlock.add(this.OMPfuncIdent(this.dynamicShedInitFunc).Call(Xcons.List(xobject5, xobject4, xobject8, oMPinfo.sched_chunk)));
                blockList2.add(Bcons.DO_WHILE(this.OMPfuncIdent(this.dynamicShedNextFunc).Call(Xcons.List(xobject3, xobject2)), compoundBlock));
                break;
            }
            case SCHED_GUIDED: {
                if (oMPinfo.sched_chunk == null) {
                    oMPinfo.sched_chunk = Xcons.IntConstant(1);
                }
                basicBlock.add(this.OMPfuncIdent(this.guidedShedInitFunc).Call(Xcons.List(xobject5, xobject4, xobject8, oMPinfo.sched_chunk)));
                blockList2.add(Bcons.DO_WHILE(this.OMPfuncIdent(this.guidedShedNextFunc).Call(Xcons.List(xobject3, xobject2)), compoundBlock));
                break;
            }
            case SCHED_RUNTIME: {
                basicBlock.add(this.OMPfuncIdent(this.runtimeShedInitFunc).Call(Xcons.List(xobject5, xobject4, xobject8)));
                blockList2.add(Bcons.DO_WHILE(this.OMPfuncIdent(this.runtimeShedNextFunc).Call(Xcons.List(xobject3, xobject2)), compoundBlock));
                break;
            }
            default: {
                OMP.fatal("unknown schedule: " + (Object)((Object)oMPinfo.sched));
            }
        }
        if (bl5) {
            blockList.add(Xcons.Set(xobject5, Xcons.Cast(xtype, Xcons.Cast(xtype2, ident.Ref()))));
            blockList.add(Xcons.Set(xobject4, Xcons.Cast(xtype, Xcons.Cast(xtype2, ident2.Ref()))));
        }
        if ((block = this.dataUpdateBlock(oMPinfo)) != null) {
            blockList2.add(block);
        }
        if (!oMPinfo.no_wait) {
            blockList2.add(Bcons.Statement(this.OMPfuncIdent(this.barrierFunc).Call(null)));
        }
        return Bcons.COMPOUND(blockList2);
    }

    public Block transSections(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        Object object;
        Block block;
        BlockList blockList = Bcons.emptyBody(oMPinfo.getIdList(), null);
        int n = 0;
        this.addDataSetupBlock(blockList, oMPinfo);
        n = 0;
        for (block = pragmaBlock.getBody().getHead(); block != null; block = block.getNext()) {
            ++n;
        }
        BasicBlock basicBlock = new BasicBlock();
        if (oMPinfo.getNumThreads() != null) {
            basicBlock.add(this.OMPfuncIdent(this.setNumThreadsFunc).Call(Xcons.List(oMPinfo.getNumThreads())));
        }
        basicBlock.add(this.OMPfuncIdent(this.sectionInitFunc).Call(Xcons.List(Xcons.IntConstant(n))));
        blockList.add(basicBlock);
        XobjString xobjString = null;
        if (XmOption.isLanguageC()) {
            xobjString = Xcons.Symbol(Xcode.IDENT, this.env.genSym("L"));
            blockList.add(Bcons.LABEL(xobjString));
        }
        BlockList blockList2 = Bcons.emptyBody();
        n = 0;
        while ((block = pragmaBlock.getBody().getHead()) != null) {
            block.remove();
            if (XmOption.isLanguageC()) {
                blockList2.add(Bcons.CASE(Xcons.IntConstant(n)));
                blockList2.add(block);
                blockList2.add(Bcons.GOTO(xobjString));
            } else {
                object = new BlockList(block);
                blockList2.add(Bcons.FcaseLabel(Xcons.List(Xcons.List(Xcode.F_VALUE, Xcons.IntConstant(n))), (BlockList)object, null));
            }
            ++n;
        }
        object = this.OMPfuncIdent(this.sectionIdFunc).Call(null);
        if (XmOption.isLanguageC()) {
            blockList.add(Bcons.SWITCH(BasicBlock.Cond((Xobject)object), blockList2));
        } else {
            BlockList blockList3 = new BlockList();
            blockList3.add(Xcons.List(Xcode.F_EXIT_STATEMENT));
            blockList2.add(Bcons.FcaseLabel(null, blockList3, null));
            blockList.add(Bcons.Fdo(null, null, Bcons.blockList(Bcons.FselectCase((Xobject)object, blockList2, null)), null));
        }
        block = this.dataUpdateBlock(oMPinfo);
        if (block != null) {
            blockList.add(block);
        }
        if (!oMPinfo.no_wait) {
            blockList.add(Bcons.Statement(this.OMPfuncIdent(this.barrierFunc).Call(null)));
        }
        return Bcons.COMPOUND(blockList);
    }

    public Block transSingle(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        BlockList blockList = Bcons.emptyBody();
        BlockList blockList2 = null;
        BlockList blockList3 = Bcons.emptyBody(oMPinfo.getIdList(), null);
        this.addDataSetupBlock(blockList, oMPinfo);
        blockList.add(Bcons.COMPOUND(pragmaBlock.getBody()));
        boolean bl = oMPinfo.hasCopyPrivate();
        if (bl) {
            blockList2 = Bcons.emptyBody();
            blockList2.add(Bcons.Statement(this.OMPfuncIdent(this.barrierFunc).Call(null)));
            for (OMPvar oMPvar : oMPinfo.getVarList()) {
                if (!oMPvar.is_copy_private) continue;
                Xobject xobject = XmOption.isLanguageC() ? oMPvar.getSize() : null;
                blockList.add(this.getVarCopyStatement(oMPvar.id.Type(), oMPvar.getCopyPrivateAddr(), oMPvar.getPrivateAddr(), xobject));
                blockList2.add(this.getVarCopyStatement(oMPvar.id.Type(), oMPvar.getPrivateAddr(), oMPvar.getCopyPrivateAddr(), xobject));
            }
            blockList.add(Bcons.Statement(this.OMPfuncIdent(this.barrierFunc).Call(null)));
        }
        blockList3.add(Bcons.IF(BasicBlock.Cond(this.OMPfuncIdent(this.doSingleFunc).Call(null)), blockList, blockList2));
        if (!oMPinfo.no_wait) {
            blockList3.add(Bcons.Statement(this.OMPfuncIdent(this.barrierFunc).Call(null)));
        }
        return Bcons.COMPOUND(blockList3);
    }

    public Block transMaster(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        return Bcons.IF(BasicBlock.Cond(this.OMPfuncIdent(this.isMasterFunc).Call()), pragmaBlock.getBody(), null);
    }

    public Block transCritical(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        String string = this.criticalLockPrefix;
        if (oMPinfo.arg != null) {
            string = string + "_" + oMPinfo.arg.getName();
        }
        Ident ident = this.current_def.declGlobalIdent(string, Xtype.VoidPtrOrFuintPtr());
        BlockList blockList = pragmaBlock.getBody();
        blockList.insert(this.OMPfuncIdent(this.enterCriticalFunc).Call(Xcons.List(ident.getAddr())));
        blockList.add(this.OMPfuncIdent(this.exitCriticalFunc).Call(Xcons.List(ident.getAddr())));
        return Bcons.COMPOUND(blockList);
    }

    private Xobject getFtempVar(BlockList blockList, Xobject xobject) {
        if (xobject.isVarRef()) {
            return xobject;
        }
        Xtype xtype = xobject.Type().copy();
        xtype.setIsFintentIN(false);
        xtype.setIsFintentOUT(false);
        xtype.setIsFintentINOUT(false);
        if (xtype.isBasic() && (xtype.getBasicType() == 24 || xtype.getBasicType() == 25)) {
            return xobject;
        }
        Ident ident = Ident.Fident(this.env.genSym(TEMP_VAR_PREFIX), xtype);
        blockList.add(Xcons.Set(ident.getAddr(), xobject));
        return ident;
    }

    public Block transAtomic(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        BlockList blockList = pragmaBlock.getBody();
        BasicBlock basicBlock = blockList.getHead().getBasicBlock();
        Statement statement = basicBlock.getHead();
        if (XmOption.isLanguageC()) {
            Ident ident;
            Xobject xobject;
            statement.insert(this.OMPfuncIdent(this.atomicLockFunc).Call(null));
            Xobject xobject2 = statement.getExpr();
            switch (xobject2.Opcode()) {
                case POST_INCR_EXPR: 
                case POST_DECR_EXPR: 
                case PRE_INCR_EXPR: 
                case PRE_DECR_EXPR: {
                    break;
                }
                default: {
                    xobject = xobject2.right();
                    ident = Ident.Local(this.env.genSym(TEMP_VAR_PREFIX), xobject.Type());
                    blockList.addIdent(ident);
                    statement.insert(Xcons.Set(ident.Ref(), xobject));
                    xobject2.setRight(ident.Ref());
                }
            }
            xobject = xobject2.operand();
            ident = Ident.Local(this.env.genSym(TEMP_VAR_PREFIX), Xtype.Pointer(xobject.Type()));
            blockList.addIdent(ident);
            xobject2.setOperand(Xcons.PointerRef(ident.Ref()));
            statement.insert(Xcons.Set(ident.Ref(), Xcons.AddrOf(xobject)));
            statement.add(this.OMPfuncIdent(this.atomicUnlockFunc).Call(null));
        } else {
            blockList.add(this.OMPfuncIdent(this.atomicLockFunc).Call(null));
            Xobject xobject = statement.getExpr();
            Xobject xobject3 = xobject.getArg(0);
            Xobject xobject4 = this.getFtempVar(blockList, xobject.getArg(1));
            Xobject xobject5 = this.getFtempVar(blockList, xobject.getArg(2));
            XobjList xobjList = null;
            if (xobject.Opcode().isBinaryOp()) {
                xobjList = Xcons.List(xobject.Opcode(), xobject3.Type(), xobject4, xobject5);
            } else {
                XobjInt xobjInt = Xcons.IntConstant(1);
                xobjList = Xcons.List(Xcode.FUNCTION_CALL, xobject3.Type(), xobject.getArg(3), Xcons.List(xobject4, xobject5), xobjInt);
            }
            blockList.add(Xcons.Set(xobject3, xobjList));
            blockList.add(this.OMPfuncIdent(this.atomicUnlockFunc).Call(null));
            blockList.removeFirst();
        }
        return Bcons.COMPOUND(blockList);
    }

    Block transFlush(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        if (oMPinfo.flush_vars == null || XmOption.isLanguageF()) {
            return Bcons.Statement(this.OMPfuncIdent(this.flushFunc).Call(Xcons.List(Xcons.IntConstant(0), Xcons.IntConstant(0))));
        }
        BasicBlock basicBlock = new BasicBlock();
        for (Xobject xobject : oMPinfo.flush_vars) {
            basicBlock.add(this.OMPfuncIdent(this.flushFunc).Call(xobject));
        }
        return Bcons.BasicBlock(basicBlock);
    }

    public Block transOrdered(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        BlockList blockList = pragmaBlock.getBody();
        blockList.insert(this.OMPfuncIdent(this.orderedBeginFunc).Call(null));
        blockList.add(this.OMPfuncIdent(this.orderedEndFunc).Call(null));
        return Bcons.COMPOUND(blockList);
    }

    public Block transTaskRegion(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        if (XmOption.isLanguageC()) {
            return this.transCtaskRegion(pragmaBlock, oMPinfo);
        }
        return this.transFtaskRegion(pragmaBlock, oMPinfo);
    }

    public Block transCtaskRegion(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        return null;
    }

    public Block transSimd(PragmaBlock pragmaBlock, OMPinfo oMPinfo) {
        BlockList blockList = pragmaBlock.getBody();
        return Bcons.COMPOUND(blockList);
    }

    private Xobject getFallocateLocalArray(Xobject xobject, Xobject xobject2, Xtype xtype, Xobject xobject3) {
        Xobject[] xobjectArray = new Xobject[xtype.getNumDimensions() + 1];
        for (int i = 0; i < xobjectArray.length - 1; ++i) {
            xobjectArray[i] = Xcons.FarrayIndex(this.OMPFintrinsicIdent("size").Call(Xcons.List(xobject2, Xcons.IntConstant(i + 1))));
        }
        xobjectArray[xobjectArray.length - 1] = Xcons.FarrayIndex(xobject3);
        return Xcons.Fallocate(xobject, xobjectArray);
    }

    private Xobject getVarCopyStatement(Xtype xtype, Xobject xobject, Xobject xobject2, Xobject xobject3) {
        if (xtype.isArray()) {
            return this.OMPfuncIdent(this.bcopyFunc).Call(Xcons.List(xobject, xobject2, xobject3));
        }
        return Xcons.Set(Xcons.PointerRef(xobject), Xcons.PointerRef(xobject2));
    }

    /*
     * WARNING - void declaration
     */
    protected void addDataSetupBlock(BlockList blockList, OMPinfo oMPinfo) {
        Object object;
        OMP.debug("addDataSetUPBlock");
        boolean bl = false;
        for (OMPvar object32 : oMPinfo.getVarList()) {
            if (!object32.is_first_private && !object32.is_reduction && !object32.is_copyin && !object32.isVariableArray()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        OMP.debug("addDataSetUPBlock 2");
        BasicBlock basicBlock = new BasicBlock();
        BlockList blockList2 = new BlockList();
        for (OMPvar oMPvar : oMPinfo.getVarList()) {
            Xobject xobject = oMPvar.getPrivateAddr();
            if (!oMPvar.isVariableArray() || xobject == null) continue;
            basicBlock.add(Xcons.Set(xobject, Xcons.Cast(xobject.Type(), this.OMPfuncIdent(this.allocaFunc).Call(Xcons.List(oMPvar.getSize())))));
        }
        for (OMPvar oMPvar : oMPinfo.getVarList()) {
            if (!oMPvar.is_first_private) continue;
            basicBlock.add(this.getVarCopyStatement(oMPvar.id.Type(), oMPvar.getPrivateAddr(), oMPvar.getSharedAddr(), XmOption.isLanguageC() ? oMPvar.getSize() : null));
        }
        boolean bl2 = false;
        for (OMPvar oMPvar : oMPinfo.getVarList()) {
            if (oMPvar.is_first_private || !oMPvar.is_reduction) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            if (XmOption.isLanguageC()) {
                for (OMPvar oMPvar : oMPinfo.getVarList()) {
                    if (oMPvar.is_first_private || !oMPvar.is_reduction) continue;
                    basicBlock.add(Xcons.Set(Xcons.PointerRef(oMPvar.getPrivateAddr()), oMPvar.reductionInitValue()));
                }
            } else {
                blockList2.add(this.OMPfuncIdent(this.threadLockFunc).Call());
                for (OMPvar oMPvar : oMPinfo.getVarList()) {
                    if (oMPvar.is_first_private || !oMPvar.is_reduction) continue;
                    blockList2.add(Bcons.IF(Xcons.unaryOp(Xcode.LOG_NOT_EXPR, this.OMPFintrinsicIdent("allocated").Call(Xcons.List(oMPvar.getSharedArray()))), this.getFallocateLocalArray(oMPvar.getSharedArray(), oMPvar.getSharedAddr(), oMPvar.id.Type(), this.OMPfuncIdent(this.getNumThreadsFunc).Call()), null));
                }
                blockList2.add(this.OMPfuncIdent(this.threadUnlockFunc).Call());
                for (OMPvar oMPvar : oMPinfo.getVarList()) {
                    if (oMPvar.is_first_private || !oMPvar.is_reduction) continue;
                    object = oMPvar.getPrivateAddr().Type().copy();
                    ((Xtype)object).unsetIsFtarget();
                    ((Xtype)object).setIsFpointer(true);
                    oMPvar.getPrivateAddr().setType((Xtype)object);
                    blockList2.add(Xcons.FpointerAssignment(oMPvar.getPrivateAddr(), Xcons.FarrayRef(oMPvar.getSharedArray(), Xcons.binaryOp(Xcode.PLUS_EXPR, this.OMPfuncIdent(this.getThreadNumFunc).Call(), Xcons.IntConstant(1)))));
                    blockList2.add(Xcons.Set(oMPvar.getPrivateAddr(), oMPvar.reductionInitValue()));
                }
            }
        }
        for (OMPvar oMPvar : oMPinfo.getVarList()) {
            if (oMPvar.is_first_private || !oMPvar.is_copyin) continue;
            object = oMPvar.id;
            Ident ident = oMPvar.getThdPrvLocalId();
            if (ident == null) {
                OMP.fatal("bad copyin: " + ((Ident)object).getName());
            }
            if (XmOption.isLanguageC()) {
                basicBlock.add(this.OMPfuncIdent(this.copyinThdprvFunc).Call(Xcons.List(ident.Ref(), ((Ident)object).getAddr(), Xcons.SizeOf(((Xobject)object).Type()))));
                continue;
            }
            blockList2.add(Bcons.IF((Xobject)Xcons.List(Xcode.LOG_NOT_EXPR, this.OMPfuncIdent(this.isMasterFunc).Call()), Xcons.Set(ident.Ref(), ((Ident)object).getAddr()), null));
            blockList2.add(this.OMPfuncIdent(this.barrierFunc).Call());
        }
        if (!basicBlock.isEmpty()) {
            blockList.add(basicBlock);
        }
        if (!blockList2.isEmpty()) {
            void var7_19;
            Block block = blockList2.getHead();
            while (var7_19 != null) {
                blockList.add((Block)var7_19);
                Block block2 = var7_19.getNext();
            }
        }
        OMP.debug("addDataSetUPBlock End");
    }

    private void addCreductionUpdateBlock(BlockList blockList, OMPinfo oMPinfo) {
        BasicBlock basicBlock = new BasicBlock();
        for (OMPvar oMPvar : oMPinfo.getVarList()) {
            int n;
            if (!oMPvar.is_reduction) continue;
            if (oMPvar.id.Type().isEnum()) {
                n = 7;
            } else if (oMPvar.id.Type().isNumeric()) {
                n = oMPvar.id.Type().getBasicType();
            } else {
                OMP.fatal("bad reduction variable type");
                continue;
            }
            basicBlock.add(this.OMPfuncIdent(this.doReduction).Call(Xcons.List(oMPvar.getPrivateAddr(), oMPvar.getSharedAddr(), Xcons.IntConstant(n), Xcons.IntConstant(oMPvar.reduction_op.getId()))));
        }
        blockList.add(basicBlock);
    }

    private void addFreductionUpdateBlock(BlockList blockList, OMPinfo oMPinfo) {
        boolean bl = false;
        for (OMPvar object2 : oMPinfo.getVarList()) {
            if (!object2.is_reduction) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        blockList.add(this.OMPfuncIdent(this.currentThreadBarrierFunc).Call());
        Xobject xobject = Ident.Fident(THDNUM_LOOP_VAR, Xtype.intType, this.env).getAddr();
        BlockList blockList2 = Bcons.emptyBody();
        for (OMPvar oMPvar : oMPinfo.getVarList()) {
            if (!oMPvar.is_reduction) continue;
            Xobject xobject2 = oMPvar.getSharedAddr();
            Xobject xobject3 = oMPvar.getSharedArray();
            xobject3.setIsDelayedDecl(true);
            blockList2.add(Xcons.Set(xobject2, oMPvar.reduction_op.getReductionExpr(xobject2, Xcons.FarrayRef(xobject3, xobject))));
        }
        Xobject xobject4 = Xcons.FindexRange(Xcons.IntConstant(1), this.OMPfuncIdent(this.getNumThreadsFunc).Call());
        blockList.add(Bcons.IF(this.OMPfuncIdent(this.isMasterFunc).Call(), Bcons.Fdo(xobject, xobject4, blockList2, null), null));
        blockList.add(this.OMPfuncIdent(this.currentThreadBarrierFunc).Call());
    }

    public Block dataUpdateBlock(OMPinfo oMPinfo) {
        boolean bl = false;
        boolean bl2 = false;
        for (OMPvar object : oMPinfo.getVarList()) {
            if (object.is_last_private) {
                bl2 = true;
            }
            if (!object.is_reduction) continue;
            bl = true;
        }
        if (!bl2 && !bl) {
            return null;
        }
        BlockList blockList = Bcons.emptyBody();
        if (bl) {
            if (XmOption.isLanguageC()) {
                this.addCreductionUpdateBlock(blockList, oMPinfo);
            } else {
                this.addFreductionUpdateBlock(blockList, oMPinfo);
            }
        }
        if (bl2) {
            BasicBlock basicBlock = new BasicBlock();
            for (OMPvar oMPvar : oMPinfo.getVarList()) {
                if (!oMPvar.is_last_private) continue;
                basicBlock.add(this.getVarCopyStatement(oMPvar.id.Type(), oMPvar.getSharedAddr(), oMPvar.getPrivateAddr(), XmOption.isLanguageC() ? oMPvar.getSize() : null));
            }
            blockList.add(Bcons.IF(this.OMPfuncIdent(this.isLastFunc).Call(null), Bcons.BasicBlock(basicBlock), null));
        }
        return Bcons.COMPOUND(blockList);
    }

    public void transFunctionBody(CompoundBlock compoundBlock, XobjectDef xobjectDef) {
        this.current_def = xobjectDef;
        this.env = xobjectDef.getFile();
        this.transFunctionBody(compoundBlock, xobjectDef.getFuncDecls());
    }

    public void transFunctionBody(CompoundBlock compoundBlock, Xobject xobject) {
        OMPinfo oMPinfo = (OMPinfo)compoundBlock.getProp("OMPprop");
        if (oMPinfo == null) {
            return;
        }
        BlockList blockList = compoundBlock.getBody();
        this.threadprivateSetup(xobject, blockList, oMPinfo, false);
        this.transFioStatements(blockList);
    }

    private void threadprivateCSetup(BlockList blockList, OMPinfo oMPinfo) {
        BasicBlock basicBlock = new BasicBlock();
        for (OMPvar oMPvar : oMPinfo.getThdPrvVarList()) {
            Ident ident = oMPvar.id;
            Ident ident2 = oMPvar.getThdPrvLocalId();
            blockList.addIdent(ident2);
            Xobject xobject = ident.isCglobalVarOrFvar() ? ident.getAddr() : oMPvar.getSharedAddr();
            Xobject xobject2 = this.OMPfuncIdent(this.getThdprvFunc).Call(Xcons.List(Xcons.Symbol(Xcode.VAR_ADDR, Xtype.Pointer(ident.Type()), THDPRV_STORE_PREFIX + ident.getName()), Xcons.SizeOf(ident.Type()), xobject));
            basicBlock.add(Xcons.Set(ident2.Ref(), Xcons.Cast(ident2.Type(), xobject2)));
        }
        blockList.insert(basicBlock);
    }

    private FmoduleBlock getFinternalModule(Xobject xobject) {
        FmoduleBlock fmoduleBlock = (FmoduleBlock)this.env.getProp(PROP_KEY_FINTERNAL_MODULE);
        if (fmoduleBlock != null) {
            return fmoduleBlock;
        }
        String string = new File(this.env.getSourceFileName()).getName().trim().toLowerCase();
        if (string.length() == 0) {
            string = "blank";
        }
        int n = string.lastIndexOf(46);
        string = FINTERNAL_MODULE_PREFIX + string.substring(0, n).replaceAll("[ ./$%&<>{}~|\\`\"'@+*]", "_");
        fmoduleBlock = new FmoduleBlock(string, this.env);
        this.env.setProp(PROP_KEY_FINTERNAL_MODULE, fmoduleBlock);
        this.copyFuseDecl(xobject, fmoduleBlock.getBody().getDecls());
        return fmoduleBlock;
    }

    private static void addFparamToList(Xobject xobject, XobjList xobjList, String string, Xtype xtype) {
        Ident ident = Ident.Fident(string, xtype);
        xobject.add(ident);
        xobjList.add(Xcons.List(Xcode.VAR_DECL, Xcons.Symbol(Xcode.VAR, ident.Type(), ident.getName())));
    }

    private Ident addFsaveArrayFuncInterface(Xobject xobject, XobjList xobjList, Xtype xtype) {
        XobjList xobjList2 = Xcons.List();
        XobjList xobjList3 = Xcons.IDList();
        Xtype xtype2 = xtype.copy();
        xtype2.unsetIsFsave();
        OMPtransPragma.addFparamToList(xobjList3, xobjList2, "vendor", Xtype.FintType);
        OMPtransPragma.addFparamToList(xobjList3, xobjList2, "src", xtype2);
        OMPtransPragma.addFparamToList(xobjList3, xobjList2, "dst", Xtype.FuintPtrType);
        Ident ident = this.current_def.declStaticIdent(this.saveArrayFunc, new FunctionType(Xtype.FvoidType));
        ((FunctionType)ident.Type()).setFuncParamIdList(xobjList3);
        this.copyFuseDecl(xobject, xobjList2);
        xobjList.add(Xcons.FinterfaceFunctionDecl(ident, xobjList2));
        return ident;
    }

    private Ident addFloadArrayFuncInterface(Xobject xobject, XobjList xobjList, Xtype xtype) {
        XobjList xobjList2 = Xcons.List();
        XobjList xobjList3 = Xcons.IDList();
        Xtype xtype2 = xtype.copy();
        xtype2.unsetIsFsave();
        OMPtransPragma.addFparamToList(xobjList3, xobjList2, "vendor", Xtype.FintType);
        OMPtransPragma.addFparamToList(xobjList3, xobjList2, "src", Xtype.FuintPtrType);
        OMPtransPragma.addFparamToList(xobjList3, xobjList2, "dst", xtype2);
        OMPtransPragma.addFparamToList(xobjList3, xobjList2, "ndims", Xtype.FintType);
        Ident ident = this.current_def.declStaticIdent(this.loadArrayFunc, new FunctionType(Xtype.FvoidType));
        ((FunctionType)ident.Type()).setFuncParamIdList(xobjList3);
        this.copyFuseDecl(xobject, xobjList2);
        xobjList.add(Xcons.FinterfaceFunctionDecl(ident, xobjList2));
        return ident;
    }

    private Ident addFsetBoundsFuncInterface(Xobject xobject, XobjList xobjList, int n, Xtype xtype, Xtype xtype2) {
        XobjList xobjList2 = Xcons.List();
        XobjList xobjList3 = Xcons.IDList();
        Xtype xtype3 = xtype.copy();
        xtype3.setIsFpointer(false);
        OMPtransPragma.addFparamToList(xobjList3, xobjList2, "vendor", Xtype.FintType);
        OMPtransPragma.addFparamToList(xobjList3, xobjList2, "src", xtype3);
        OMPtransPragma.addFparamToList(xobjList3, xobjList2, "dst", xtype3);
        for (int i = 0; i < n; ++i) {
            OMPtransPragma.addFparamToList(xobjList3, xobjList2, "lb" + (i + 1), Xtype.FintType);
        }
        Ident ident = this.current_def.declStaticIdent(this.setBoundsFuncPrefix + n, new FunctionType(Xtype.FvoidType));
        ((FunctionType)ident.Type()).setFuncParamIdList(xobjList3);
        this.copyFuseDecl(xobject, xobjList2);
        xobjList.add(Xcons.FinterfaceFunctionDecl(ident, xobjList2));
        return ident;
    }

    private Ident addFgetThreadPrivateFunc(Xobject xobject, OMPvar oMPvar, OMPinfo oMPinfo, String string, String string2) {
        FmoduleBlock fmoduleBlock = this.getFinternalModule(xobject);
        XobjList xobjList = fmoduleBlock.getBody().getIdentList();
        int n = XmOption.getCompilerVendor();
        XobjInt xobjInt = Xcons.IntConstant(n);
        Xobject xobject2 = oMPvar.getSharedArray();
        Xobject xobject3 = oMPvar.getPrivateAddr();
        Xobject xobject4 = oMPvar.getSharedAddr();
        String string3 = FTHDPRV_COMMON_PREFIX + string2 + "_" + oMPvar.id.getName();
        BlockList blockList = Bcons.emptyBody();
        Block block = Bcons.COMPOUND(blockList);
        Xtype xtype = xobject4.Type();
        if (xtype.isFarray()) {
            xtype = xtype.copy();
            xtype.convertFindexRange(true, false, oMPinfo.getBlock());
        }
        xobject4.setIsDelayedDecl(true);
        xobject4.Type().setIsFtarget(true);
        Ident ident = new Ident(xobject4.getName(), StorageClass.FSAVE, xtype, xobject4, VarScope.LOCAL);
        Ident ident2 = new Ident(xobject3.getName(), StorageClass.FLOCAL, xobject3.Type(), xobject3, VarScope.LOCAL);
        XobjList xobjList2 = Xcons.List(Xcode.ID_LIST, ident, ident2);
        FunctionType functionType = new FunctionType(null, Xtype.FvoidType, xobjList2, 0L, false, null, null);
        Ident ident3 = Xcons.Ident(string, StorageClass.FFUNC, functionType, Xcons.Symbol(Xcode.FUNC_ADDR, functionType, string), VarScope.LOCAL);
        FunctionBlock functionBlock = new FunctionBlock(ident3, Xcons.IDList(), Xcons.List(), block, null, this.env);
        XobjList xobjList3 = (XobjList)functionBlock.getBody().getDecls();
        if (xobjList3 == null) {
            xobjList3 = Xcons.List();
            functionBlock.getBody().setDecls(xobjList3);
        }
        this.copyFuseDecl(xobject, xobjList3);
        Xtype xtype2 = Xtype.FlogicalType.copy(null);
        XobjString xobjString = Xcons.Symbol(Xcode.VAR, xtype2, "ts__alc");
        xobjString.setIsDelayedDecl(true);
        Xtype xtype3 = Xtype.FuintPtrType.copy();
        XobjString xobjString2 = Xcons.Symbol(Xcode.VAR, xtype3, "ts__hdr");
        xobjString2.setIsDelayedDecl(true);
        Ident ident4 = new Ident(((Xobject)xobjString).getName(), StorageClass.FCOMMON, xobjString.Type(), xobjString, VarScope.LOCAL);
        Ident ident5 = new Ident(((Xobject)xobjString2).getName(), StorageClass.FCOMMON, xobjString2.Type(), xobjString2, VarScope.LOCAL);
        xobjList3.add(Xcons.List(Xcode.F_COMMON_DECL, Xcons.List(Xcode.F_VAR_LIST, Xcons.Symbol(Xcode.IDENT, string3), Xcons.List(Xcons.FvarRef(ident5), Xcons.FvarRef(ident4)))));
        Ident ident6 = new Ident(xobject2.getName(), StorageClass.FSAVE, xobject2.Type(), xobject2, VarScope.LOCAL);
        xobjList.add(ident6);
        Ident ident7 = this.addFloadArrayFuncInterface(xobject, xobjList3, xobject2.Type());
        Ident ident8 = this.addFsaveArrayFuncInterface(xobject, xobjList3, xobject2.Type());
        BlockList blockList2 = Bcons.emptyBody();
        BlockList blockList3 = Bcons.emptyBody();
        blockList3.add(this.getFallocateLocalArray(xobject2, xobject4, oMPvar.id.Type(), Xcons.binaryOp(Xcode.MINUS_EXPR, this.OMPfuncIdent(this.getNumThreadsFunc).Call(), Xcons.IntConstant(1))));
        blockList3.add(ident8.Call(Xcons.List(xobjInt, xobject2, xobjString2)));
        XobjConst xobjConst = null;
        Xtype xtype4 = xobject2.Type().getBaseRefType();
        if (xtype4.isNumeric()) {
            xobjConst = Xcons.IntConstant(0);
        } else if (xtype4.isBool()) {
            xobjConst = Xcons.FlogicalConstant(false);
        }
        if (xobjConst != null) {
            blockList3.add(Xcons.Set(xobject2, xobjConst));
        }
        blockList3.add(this.OMPfuncIdent(this.flushFunc).Call());
        blockList3.add(Xcons.Set(xobjString, Xcons.FlogicalConstant(true)));
        blockList2.add(Bcons.Statement(this.OMPfuncIdent(this.threadLockFunc).Call()));
        blockList2.add(Bcons.IF(BasicBlock.Cond(Xcons.unaryOp(Xcode.LOG_NOT_EXPR, xobjString)), blockList3, null));
        blockList2.add(Bcons.Statement(this.OMPfuncIdent(this.threadUnlockFunc).Call()));
        blockList.add(Bcons.IF(BasicBlock.Cond(Xcons.binaryOp(Xcode.LOG_AND_EXPR, Xcons.unaryOp(Xcode.LOG_NOT_EXPR, xobjString), Xcons.binaryOp(Xcode.LOG_GT_EXPR, this.OMPfuncIdent(this.getNumThreadsFunc).Call(), Xcons.IntConstant(1)))), blockList2, null));
        BlockList blockList4 = Bcons.emptyBody();
        BlockList blockList5 = Bcons.emptyBody();
        XobjInt xobjInt2 = Xcons.IntConstant(ident6.Type().getNumDimensions());
        blockList4.add(Xcons.FpointerAssignment(xobject3, xobject4));
        blockList5.add(ident7.Call(Xcons.List(xobjInt, xobjString2, xobject2, xobjInt2)));
        blockList5.add(Xcons.FpointerAssignment(xobject3, Xcons.FarrayRef(xobject2, this.OMPfuncIdent(this.getThreadNumFunc).Call())));
        blockList.add(Bcons.IF(BasicBlock.Cond(this.OMPfuncIdent(this.isMasterFunc).Call()), blockList4, blockList5));
        int n2 = ident6.Type().getNumDimensions() - 1;
        if (n2 > 0) {
            XobjList xobjList4 = Xcons.List(xobjInt, xobject4, xobject3);
            Xobject[] xobjectArray = xobject4.Type().getFarraySizeExpr();
            for (int i = 0; i < n2; ++i) {
                xobjList4.add(xobjectArray[i].getArg(0));
            }
            Ident ident9 = this.addFsetBoundsFuncInterface(xobject, xobjList3, n2, xobject3.Type(), xobject4.Type());
            blockList.add(Bcons.Statement(ident9.Call(xobjList4)));
        }
        fmoduleBlock.addFunctionBlock(functionBlock);
        return ident3;
    }

    private void threadprivateFSetup(Xobject xobject, Xobject xobject2, BlockList blockList, OMPinfo oMPinfo, boolean bl) {
        if (oMPinfo.getThdPrvVarList() == null || oMPinfo.getThdPrvVarList().isEmpty()) {
            return;
        }
        FmoduleBlock fmoduleBlock = this.getFinternalModule(xobject2);
        for (OMPvar oMPvar : oMPinfo.getThdPrvVarList()) {
            PropObject propObject;
            Xobject xobject3 = oMPvar.getSharedArray();
            Xobject xobject4 = oMPvar.getPrivateAddr();
            Xobject xobject5 = oMPvar.getSharedAddr();
            String string = "";
            if (oMPvar.id.getStorageClass() == StorageClass.FCOMMON) {
                string = oMPvar.id.getFcommonName();
            }
            String string2 = "ompf_getthdprv_" + string + "_" + oMPvar.id.getName();
            Ident ident = null;
            if (fmoduleBlock.hasVar(xobject3.getName())) {
                propObject = fmoduleBlock.getFunctionBlock(string2);
                ident = (Ident)propObject.getNameObj();
            } else {
                ident = this.addFgetThreadPrivateFunc(xobject2, oMPvar, oMPinfo, string2, string);
            }
            propObject = (XobjList)blockList.getDecls();
            if (propObject == null) {
                propObject = Xcons.List();
                blockList.setDecls((Xobject)propObject);
            }
            blockList.insert(ident.Call(Xcons.List(bl ? xobject5 : oMPvar.id, xobject4)));
        }
        xobject.insert(Xcons.List(Xcode.F_USE_DECL, fmoduleBlock.getName()));
    }

    public void threadprivateSetup(Xobject xobject, BlockList blockList, OMPinfo oMPinfo, boolean bl) {
        if (OMP.leaveThreadPrivateFlag) {
            return;
        }
        if (oMPinfo.getThdPrvVarList().isEmpty()) {
            return;
        }
        if (XmOption.isLanguageC()) {
            this.threadprivateCSetup(blockList, oMPinfo);
        } else {
            this.threadprivateFSetup(xobject, xobject, blockList, oMPinfo, bl);
        }
    }
}

