/*
 * Decompiled with CFR 0.152.
 */
package exc.openmp;

import exc.block.BasicBlockExprIterator;
import exc.block.Block;
import exc.block.FuncDefBlock;
import exc.block.FunctionBlock;
import exc.object.ArrayType;
import exc.object.BasicType;
import exc.object.Ident;
import exc.object.LineNo;
import exc.object.Xcode;
import exc.object.Xobject;
import exc.object.XobjectIterator;
import exc.object.Xtype;
import exc.object.bottomupXobjectIterator;
import exc.openmp.OMP;
import exc.openmp.OMPfileEnv;
import exc.openmp.OMPinfo;
import exc.openmp.OMPpragma;
import exc.openmp.OMPvar;
import xcodeml.util.XmOption;

public class OMPrewriteExpr {
    public void run(FuncDefBlock funcDefBlock, OMPfileEnv oMPfileEnv) {
        OMP.debug("pass2:");
        FunctionBlock functionBlock = funcDefBlock.getBlock();
        BasicBlockExprIterator basicBlockExprIterator = new BasicBlockExprIterator(functionBlock);
        basicBlockExprIterator.init();
        while (!basicBlockExprIterator.end()) {
            Xobject xobject = basicBlockExprIterator.getExpr();
            if (xobject != null) {
                basicBlockExprIterator.setExpr(this.rewriteExpr(xobject, basicBlockExprIterator.getBasicBlock().getParent(), basicBlockExprIterator.getLineNo(), false));
            }
            basicBlockExprIterator.next();
        }
    }

    public void run(Xobject xobject, Block block, OMPfileEnv oMPfileEnv) {
        bottomupXobjectIterator bottomupXobjectIterator2 = new bottomupXobjectIterator(xobject);
        bottomupXobjectIterator2.init();
        while (!bottomupXobjectIterator2.end()) {
            Xobject xobject2 = bottomupXobjectIterator2.getXobject();
            if (xobject2 != null) {
                bottomupXobjectIterator2.setXobject(this.rewriteExpr(xobject2, block, xobject2.getLineNo(), false));
            }
            bottomupXobjectIterator2.next();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void checkReductionExpr(OMPvar oMPvar, Xobject xobject, Xobject xobject2) {
        xobject.setProp("OMPprop", oMPvar);
        if (xobject2 == null) {
            return;
        }
        block0 : switch (xobject2.Opcode()) {
            case POST_INCR_EXPR: 
            case POST_DECR_EXPR: 
            case PRE_INCR_EXPR: 
            case PRE_DECR_EXPR: {
                xobject2.setOperand(oMPvar.Ref());
                return;
            }
            case ASG_PLUS_EXPR: 
            case ASG_MUL_EXPR: 
            case ASG_MINUS_EXPR: 
            case ASG_BIT_AND_EXPR: 
            case ASG_BIT_OR_EXPR: 
            case ASG_BIT_XOR_EXPR: {
                if (xobject2.left() != xobject) return;
                xobject2.setLeft(oMPvar.Ref());
                return;
            }
            case ASSIGN_EXPR: {
                if (xobject2.left() != xobject) return;
                Xobject xobject3 = xobject2.right();
                switch (xobject3.Opcode()) {
                    case PLUS_EXPR: 
                    case MUL_EXPR: 
                    case BIT_AND_EXPR: 
                    case BIT_OR_EXPR: 
                    case BIT_XOR_EXPR: 
                    case LOG_AND_EXPR: 
                    case LOG_OR_EXPR: {
                        if ((OMPvar)xobject3.right().getProp("OMPprop") == oMPvar) {
                            xobject2.setLeft(oMPvar.Ref());
                            xobject3.setRight(oMPvar.Ref());
                            break block0;
                        }
                    }
                    case MINUS_EXPR: {
                        if ((OMPvar)xobject3.left().getProp("OMPprop") != oMPvar) return;
                        xobject2.setLeft(oMPvar.Ref());
                        xobject3.setLeft(oMPvar.Ref());
                    }
                }
            }
        }
    }

    private Xobject rewriteExpr(Xobject xobject, Block block, LineNo lineNo, boolean bl) {
        OMPvar oMPvar;
        Xobject xobject2;
        if (xobject == null) {
            return null;
        }
        bottomupXobjectIterator bottomupXobjectIterator2 = new bottomupXobjectIterator(xobject);
        ((XobjectIterator)bottomupXobjectIterator2).init();
        while (!((XobjectIterator)bottomupXobjectIterator2).end()) {
            xobject2 = bottomupXobjectIterator2.getXobject();
            OMP.debug("expr1=" + xobject2);
            if (xobject2 != null) {
                if (xobject2 instanceof Ident) {
                    oMPvar = OMPinfo.findOMPvarBySharedOrPrivate(block, xobject2.getName());
                    if (oMPvar != null && XmOption.isLanguageF()) {
                        this.rewriteType(xobject2, block);
                    }
                } else if (xobject2.isVariable()) {
                    oMPvar = OMPinfo.refOMPvar(block, xobject2.getName());
                    if (oMPvar != null) {
                        if (oMPvar.is_reduction) {
                            this.checkReductionExpr(oMPvar, xobject2, ((XobjectIterator)bottomupXobjectIterator2).getParent());
                        } else {
                            bottomupXobjectIterator2.setXobject(bl ? oMPvar.SharedRef() : oMPvar.Ref());
                            if (XmOption.isLanguageF()) {
                                this.rewriteType(oMPvar, block);
                            }
                        }
                    }
                } else if (xobject2.isVarAddr() || xobject2.isArray() || xobject2.isArrayAddr()) {
                    oMPvar = OMPinfo.refOMPvar(block, xobject2.getName());
                    if (oMPvar != null) {
                        if (oMPvar != null) {
                            bottomupXobjectIterator2.setXobject(bl ? oMPvar.getSharedAddr() : oMPvar.getAddr());
                        }
                        if (oMPvar.is_reduction) {
                            OMP.warning(lineNo, "may be bad reference for reduction variable,'" + xobject2.getName() + "'");
                        }
                    }
                } else if (xobject2.Opcode() == Xcode.ASSIGN_EXPR && (oMPvar = (OMPvar)xobject2.left().getProp("OMPprop")) != null) {
                    this.checkReductionExpr(oMPvar, xobject2.left(), xobject2);
                }
            }
            ((XobjectIterator)bottomupXobjectIterator2).next();
        }
        ((XobjectIterator)bottomupXobjectIterator2).init();
        while (!((XobjectIterator)bottomupXobjectIterator2).end()) {
            xobject2 = bottomupXobjectIterator2.getXobject();
            OMP.debug("expr2=" + xobject2);
            if (xobject2 != null && xobject2.isVariable() && (oMPvar = (OMPvar)xobject2.getProp("OMPprop")) != null) {
                if (((XobjectIterator)bottomupXobjectIterator2).getParent() != null && ((XobjectIterator)bottomupXobjectIterator2).getParent().Opcode() == Xcode.ASSIGN_EXPR && ((XobjectIterator)bottomupXobjectIterator2).getParent().left() == xobject2 && oMPvar.reduction_op != OMPpragma.DATA_REDUCTION_MIN && oMPvar.reduction_op != OMPpragma.DATA_REDUCTION_MAX) {
                    OMP.warning(lineNo, "may be bad reference for reduction variable,'" + xobject2.getName() + "'");
                }
                bottomupXobjectIterator2.setXobject(oMPvar.Ref());
            }
            ((XobjectIterator)bottomupXobjectIterator2).next();
        }
        return bottomupXobjectIterator2.topXobject();
    }

    private void rewriteType(OMPvar oMPvar, Block block) {
        this.rewriteType(oMPvar.getSharedAddr(), block);
        this.rewriteType(oMPvar.getPrivateAddr(), block);
    }

    private void rewriteType(Xobject xobject, Block block) {
        if (xobject == null) {
            return;
        }
        Xtype xtype = xobject.Type();
        if (xtype == null) {
            return;
        }
        switch (xtype.getKind()) {
            case 1: {
                xtype = xtype.copy();
                xobject.setType(xtype);
                if (!XmOption.isLanguageF()) break;
                Xobject xobject2 = this.rewriteExpr(xtype.getFlen(), block, block.getLineNo(), true);
                ((BasicType)xtype).setFlen(xobject2);
                break;
            }
            case 6: {
                xtype = xtype.copy();
                xobject.setType(xtype);
                Xobject xobject3 = this.rewriteExpr(xtype.getArraySizeExpr(), block, block.getLineNo(), true);
                ((ArrayType)xtype).setArraySizeExpr(xobject3);
                break;
            }
            case 8: {
                xtype = xtype.copy();
                xobject.setType(xtype);
                Xobject[] xobjectArray = xtype.getFarraySizeExpr();
                for (int i = 0; i < xobjectArray.length; ++i) {
                    Xobject xobject4;
                    xobjectArray[i] = xobject4 = this.rewriteExpr(xobjectArray[i].copy(), block, block.getLineNo(), true);
                }
                break;
            }
        }
    }
}

