/*
 * Decompiled with CFR 0.152.
 */
package exc.openmp;

import exc.object.ExternalPragmaParser;
import exc.object.Ident;
import exc.object.PragmaParser;
import exc.object.PragmaSyntax;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.openmp.OMPpragma;
import java.util.ArrayList;
import xcodeml.util.XmException;
import xcodeml.util.XmLog;
import xcodeml.util.XmOption;

public class OMPpragmaParser
implements ExternalPragmaParser {
    private PragmaParser _parser;

    public OMPpragmaParser(PragmaParser pragmaParser) {
        this._parser = pragmaParser;
    }

    private XmException exception(String string) {
        return new XmException("[OpenMP] " + string);
    }

    private Xobject omp_pg_list(OMPpragma oMPpragma, Xobject xobject) {
        return Xcons.List(Xcode.LIST, Xcons.String(oMPpragma.toString()), xobject);
    }

    private Xobject omp_kwd(OMPpragma oMPpragma) {
        return Xcons.String(oMPpragma.toString());
    }

    @Override
    public Xobject parse(Xobject xobject) throws XmException {
        if (xobject.getArgOrNull(0) == null) {
            XmLog.fatal((String)"pragma kind is null");
        }
        OMPpragma oMPpragma = OMPpragma.valueOf(xobject.getArg(0));
        switch (oMPpragma) {
            case PARALLEL: {
                ResultClause resultClause = this.compile_OMP_pragma_clause(xobject.getArg(1), OMPpragma.PARALLEL, true);
                return Xcons.List(Xcode.OMP_PRAGMA, xobject.getArg(0), resultClause.pclause, xobject.getArg(2));
            }
            case PARALLEL_FOR: {
                ResultClause resultClause = this.compile_OMP_pragma_clause(xobject.getArg(1), OMPpragma.FOR, true);
                return Xcons.List(Xcode.OMP_PRAGMA, this.omp_kwd(OMPpragma.PARALLEL), resultClause.pclause, Xcons.List(Xcode.OMP_PRAGMA, this.omp_kwd(OMPpragma.FOR), resultClause.dclause, xobject.getArg(2)));
            }
            case PARALLEL_SECTIONS: {
                ResultClause resultClause = this.compile_OMP_pragma_clause(xobject.getArg(1), OMPpragma.SECTIONS, true);
                Xobject xobject2 = this.compile_OMP_SECTIONS_statement(xobject.getArg(2));
                return Xcons.List(Xcode.OMP_PRAGMA, this.omp_kwd(OMPpragma.PARALLEL), resultClause.pclause, Xcons.List(Xcode.OMP_PRAGMA, this.omp_kwd(OMPpragma.SECTIONS), resultClause.dclause, xobject2));
            }
            case FOR: {
                ResultClause resultClause = this.compile_OMP_pragma_clause(xobject.getArg(1), OMPpragma.FOR, false);
                return Xcons.List(Xcode.OMP_PRAGMA, xobject.getArg(0), resultClause.dclause, xobject.getArg(2));
            }
            case SECTIONS: {
                ResultClause resultClause = this.compile_OMP_pragma_clause(xobject.getArg(1), OMPpragma.SECTIONS, false);
                Xobject xobject3 = this.compile_OMP_SECTIONS_statement(xobject.getArgOrNull(2));
                if (xobject3 == null) break;
                return Xcons.List(Xcode.OMP_PRAGMA, xobject.getArg(0), resultClause.dclause, xobject3);
            }
            case SINGLE: {
                ResultClause resultClause = this.compile_OMP_pragma_clause(xobject.getArg(1), OMPpragma.SINGLE, false);
                return Xcons.List(Xcode.OMP_PRAGMA, xobject.getArg(0), resultClause.dclause, xobject.getArg(2));
            }
            case MASTER: 
            case ORDERED: {
                return Xcons.List(Xcode.OMP_PRAGMA, xobject.getArg(0), null, xobject.getArg(2));
            }
            case CRITICAL: {
                Xobject xobject4 = xobject.getArg(1);
                if (xobject4 != null && xobject4.Nargs() > 1) {
                    throw this.exception("bad critical section name");
                }
                return Xcons.List(Xcode.OMP_PRAGMA, xobject.getArg(0), xobject4, xobject.getArg(2));
            }
            case ATOMIC: {
                Xobject xobject5 = xobject.getArgOrNull(2);
                if (xobject5 == null) break;
                if (XmOption.isLanguageC() && xobject5.Opcode() != Xcode.EXPR_STATEMENT || XmOption.isLanguageF() && !xobject5.Opcode().isFstatement()) {
                    throw this.exception("bad statement for OMP atomic directive");
                }
                return Xcons.List(Xcode.OMP_PRAGMA, xobject.getArg(0), null, xobject5);
            }
            case SECTION: {
                throw this.exception("'section' directive must be in sections block");
            }
            case BARRIER: {
                return Xcons.List(Xcode.OMP_PRAGMA, xobject.getArg(0), null, null);
            }
            case FLUSH: {
                Xobject xobject6 = xobject.getArg(1);
                this.compile_OMP_name_list(xobject6);
                return Xcons.List(Xcode.OMP_PRAGMA, xobject.getArg(0), xobject6, null);
            }
            case THREADPRIVATE: {
                Xobject xobject7 = xobject.getArg(1);
                this.compile_OMP_name_list(xobject7);
                return Xcons.List(Xcode.OMP_PRAGMA, xobject.getArg(0), xobject7, null);
            }
            default: {
                XmLog.fatal((String)("unknown pragma " + oMPpragma.toString().toLowerCase()));
            }
        }
        return null;
    }

    private Xobject compile_OMP_SECTIONS_statement(Xobject xobject) throws XmException {
        if (xobject == null) {
            throw this.exception("sections directive must be followed by compound statement block");
        }
        Xobject xobject2 = null;
        if (XmOption.isLanguageC()) {
            if (xobject.Opcode() != Xcode.COMPOUND_STATEMENT) {
                throw this.exception("sections directive must be followed by compound statement block");
            }
            Xobject xobject3 = xobject.getArg(0);
            if (xobject3 != null && !xobject3.isEmpty()) {
                throw this.exception("declarations in sections block");
            }
            xobject2 = xobject.getArg(2);
        } else {
            xobject2 = xobject;
        }
        XobjList xobjList = Xcons.List();
        Xobject xobject4 = null;
        for (Xobject xobject5 : (XobjList)xobject2) {
            if (xobject5.Opcode() == Xcode.OMP_PRAGMA && OMPpragma.valueOf(xobject5.getArg(1)) == OMPpragma.SECTION) {
                xobject4 = Xcons.CompoundStatement(Xcons.IDList(), Xcons.List(), Xcons.List());
                ((Xobject)xobjList).add(xobject4);
                continue;
            }
            if (xobject4 != null) {
                xobject4.getArg(2).add(xobject5);
                continue;
            }
            xobject4 = Xcons.CompoundStatement(Xcons.IDList(), Xcons.List(), Xcons.List(xobject5));
            ((Xobject)xobjList).add(xobject4);
        }
        return xobjList;
    }

    private ResultClause compile_OMP_pragma_clause(Xobject xobject, OMPpragma oMPpragma, boolean bl) throws XmException {
        Xobject xobject2 = null;
        XobjList xobjList = Xcons.List();
        if (bl) {
            xobject2 = Xcons.statementList();
        }
        block13: for (Xobject xobject3 : (XobjList)xobject) {
            OMPpragma oMPpragma2 = OMPpragma.valueOf(xobject3.getArg(0));
            switch (oMPpragma2) {
                case DATA_DEFAULT: {
                    if (!bl) {
                        throw this.exception("'default' clause must be in PARALLEL");
                    }
                    xobject2.add(xobject3);
                    continue block13;
                }
                case DATA_SHARED: {
                    this.compile_OMP_name_list(xobject3.getArg(1));
                    if (!bl) {
                        throw this.exception("'shared' clause must be in PARALLEL");
                    }
                    xobject2.add(xobject3);
                    continue block13;
                }
                case DATA_COPYIN: {
                    this.compile_OMP_name_list(xobject3.getArg(1));
                    if (!bl) {
                        throw this.exception("'copyin' clause must be in PARALLEL");
                    }
                    xobject2.add(xobject3);
                    continue block13;
                }
                case DIR_NUM_THREADS: {
                    if (xobject2 != null) {
                        xobject2.add(xobject3);
                        continue block13;
                    }
                    ((Xobject)xobjList).add(xobject3);
                    continue block13;
                }
                case DIR_IF: {
                    if (!bl) {
                        throw this.exception("'if' clause must be in PARALLEL");
                    }
                    Xobject xobject4 = xobject3.getArg(1);
                    xobject2.add(Xcons.List(xobject3.getArg(0), xobject4));
                    continue block13;
                }
                case DATA_PRIVATE: 
                case DATA_FIRSTPRIVATE: {
                    this.compile_OMP_name_list(xobject3.getArg(1));
                    if (oMPpragma == OMPpragma.PARALLEL) {
                        xobject2.add(xobject3);
                        continue block13;
                    }
                    ((Xobject)xobjList).add(xobject3);
                    continue block13;
                }
                case DATA_LASTPRIVATE: {
                    this.compile_OMP_name_list(xobject3.getArg(1));
                    if (oMPpragma != OMPpragma.FOR && oMPpragma != OMPpragma.SECTIONS) {
                        if (XmOption.isLanguageC()) {
                            throw this.exception("'lastprivate' clause must be in FOR or SECTIONS");
                        }
                        throw this.exception("'lastprivate' clause must be in DO or SECTIONS");
                    }
                    ((Xobject)xobjList).add(xobject3);
                    continue block13;
                }
                case DATA_COPYPRIVATE: {
                    this.compile_OMP_name_list(xobject3.getArg(1));
                    if (oMPpragma != OMPpragma.SINGLE) {
                        throw this.exception("'copyprivate' clause must be in SINGLE");
                    }
                    ((Xobject)xobjList).add(xobject3);
                    continue block13;
                }
                case DIR_ORDERED: {
                    if (oMPpragma != OMPpragma.FOR) {
                        if (XmOption.isLanguageC()) {
                            throw this.exception("'ordered' clause must be in FOR");
                        }
                        throw this.exception("'ordered' clause must be in DO");
                    }
                    ((Xobject)xobjList).add(xobject3);
                    continue block13;
                }
                case DIR_SCHEDULE: {
                    if (oMPpragma != OMPpragma.FOR) {
                        if (XmOption.isLanguageC()) {
                            throw this.exception("'schedule' clause must be in FOR");
                        }
                        throw this.exception("'schedule' clause must be in DO");
                    }
                    Xobject xobject4 = xobject3.getArg(1).getArg(1);
                    if (xobject4 != null && OMPpragma.valueOf(xobject3.getArg(1).getArg(0)) != OMPpragma.SCHED_AFFINITY) {
                        xobject3 = Xcons.List(xobject3.getArg(0), Xcons.List(xobject3.getArg(1).getArg(0), xobject4));
                    }
                    ((Xobject)xobjList).add(xobject3);
                    continue block13;
                }
                case DIR_NOWAIT: {
                    if (bl) {
                        throw this.exception("'nowait' clause must not be in PARALLEL");
                    }
                    ((Xobject)xobjList).add(xobject3);
                    continue block13;
                }
            }
            if (oMPpragma2.isDataReduction()) {
                this.compile_OMP_name_list(xobject3.getArg(1));
                if (oMPpragma == OMPpragma.PARALLEL) {
                    xobject2.add(xobject3);
                    continue;
                }
                if (oMPpragma == OMPpragma.FOR || oMPpragma == OMPpragma.SECTIONS) {
                    ((Xobject)xobjList).add(xobject3);
                    continue;
                }
                throw this.exception("'reduction' clause must not be in SINGLE");
            }
            XmLog.fatal((String)xobject3.getArg(0).toString());
        }
        if (bl && oMPpragma != OMPpragma.PARALLEL) {
            ((Xobject)xobjList).add(this.omp_pg_list(OMPpragma.DIR_NOWAIT, null));
        }
        return new ResultClause(xobject2, xobjList);
    }

    private void compile_OMP_name_list(Xobject xobject) throws XmException {
        if (xobject == null) {
            return;
        }
        ArrayList<Ident> arrayList = new ArrayList<Ident>();
        block4: for (Object object = xobject.getArgs(); object != null; object = ((XobjArgs)object).nextArgs()) {
            Xobject xobject2 = ((XobjArgs)object).getArg();
            Ident ident = this._parser.findIdent(xobject2.getName(), 1);
            if (ident == null) {
                if (XmOption.isLanguageC()) {
                    ident = this._parser.getXobjectFile().findVarIdent(xobject2.getName());
                } else {
                    ident = this._parser.findIdent(xobject2.getName(), 2);
                    if (ident.getStorageClass() != StorageClass.FCOMMON_NAME) {
                        ident = null;
                    }
                }
                if (ident == null) {
                    throw this.exception("undefined variable, " + xobject2.getName() + " in pragma");
                }
            }
            switch (ident.getStorageClass()) {
                case AUTO: 
                case PARAM: 
                case EXTERN: 
                case EXTDEF: 
                case STATIC: 
                case REGISTER: 
                case FLOCAL: 
                case FCOMMON: 
                case FPARAM: 
                case FSAVE: 
                case FFUNC: {
                    if (ident.Type() == null) {
                        XmLog.fatal((String)"type is null");
                    }
                    if (!ident.Type().isFunction()) continue block4;
                    throw this.exception("function name, " + xobject2.getName() + " in pragma");
                }
                case FCOMMON_NAME: {
                    arrayList.addAll(ident.getFcommonVars());
                    xobject.removeArgs((XobjArgs)object);
                    continue block4;
                }
                default: {
                    throw this.exception("identifer, " + xobject2.getName() + " is not variable in pragma");
                }
            }
        }
        for (Ident ident : arrayList) {
            xobject.add(ident);
        }
    }

    public boolean isPrePostPair(Xobject xobject, Xobject xobject2) {
        OMPpragma oMPpragma;
        OMPpragma oMPpragma2 = OMPpragma.valueOf(xobject.getArg(0).getString());
        if (oMPpragma2 != (oMPpragma = OMPpragma.valueOf(xobject2.getArg(1).getString()))) {
            return false;
        }
        if (oMPpragma2 == OMPpragma.CRITICAL) {
            Xobject xobject3 = xobject.getArgOrNull(1);
            Xobject xobject4 = xobject2.getArgOrNull(2);
            if (xobject3 == null && xobject4 == null) {
                return true;
            }
            if (xobject3 != null && xobject4 == null || xobject3 == null && xobject4 != null) {
                return false;
            }
            Xobject xobject5 = xobject3.getArgOrNull(0);
            Xobject xobject6 = xobject4.getArgOrNull(0);
            if (xobject5 == null && xobject6 == null) {
                return true;
            }
            if (xobject5 != null && xobject6 == null || xobject5 == null && xobject6 != null) {
                return false;
            }
            if (xobject5.Opcode() != Xcode.IDENT && xobject6.Opcode() != Xcode.IDENT) {
                return false;
            }
            return xobject5.getName().equals(xobject6.getName());
        }
        return true;
    }

    public void completePragmaEnd(Xobject xobject, Xobject xobject2) {
        OMPpragma oMPpragma = OMPpragma.valueOf(xobject.getArg(0).getString());
        if (oMPpragma != OMPpragma.PARALLEL) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (Xobject xobject3 : (XobjList)xobject2) {
            if (xobject3.Opcode() != Xcode.OMP_PRAGMA) continue;
            PragmaSyntax pragmaSyntax = PragmaSyntax.valueOf(xobject3.getArg(0).getString());
            OMPpragma oMPpragma2 = OMPpragma.valueOf(xobject3.getArg(1).getString());
            switch (oMPpragma2) {
                case FOR: {
                    if (pragmaSyntax == PragmaSyntax.SYN_START) {
                        n2 = ++n;
                        break;
                    }
                    bl = true;
                    break;
                }
                case SECTIONS: {
                    if (pragmaSyntax == PragmaSyntax.SYN_START) {
                        n3 = ++n;
                        break;
                    }
                    bl2 = true;
                }
            }
        }
        for (int i = 1; i <= 2; ++i) {
            if (i == n2 && !bl) {
                xobject2.add(Xcons.List(Xcode.OMP_PRAGMA, Xcons.String(PragmaSyntax.SYN_POSTFIX.toString()), Xcons.String(OMPpragma.FOR.toString())));
                continue;
            }
            if (i != n3 || bl2) continue;
            xobject2.add(Xcons.List(Xcode.OMP_PRAGMA, Xcons.String(PragmaSyntax.SYN_POSTFIX.toString()), Xcons.String(OMPpragma.SECTIONS.toString())));
        }
    }

    public XobjArgs getAbbrevPostfix(XobjArgs xobjArgs) {
        Xobject xobject = xobjArgs.getArg();
        OMPpragma oMPpragma = OMPpragma.valueOf(xobject.getArg(0).getString());
        if (oMPpragma == OMPpragma.FOR || oMPpragma == OMPpragma.PARALLEL_FOR || oMPpragma == OMPpragma.SECTIONS || oMPpragma == OMPpragma.PARALLEL_SECTIONS) {
            XobjArgs xobjArgs2 = xobjArgs.nextArgs();
            XobjArgs xobjArgs3 = xobjArgs2.nextArgs();
            XobjList xobjList = Xcons.List(Xcode.OMP_PRAGMA, Xcons.String(oMPpragma.toString()), Xcons.String(PragmaSyntax.SYN_POSTFIX.toString()), Xcons.List());
            XobjArgs xobjArgs4 = new XobjArgs(xobjList, xobjArgs3);
            xobjArgs2.setNext(xobjArgs4);
            return xobjArgs4;
        }
        return null;
    }

    public void mergeStartAndPostfixArgs(Xobject xobject, Xobject xobject2) {
        if (OMPpragma.valueOf(xobject.getArg(0).getString()) == OMPpragma.CRITICAL) {
            return;
        }
        Xobject xobject3 = xobject2.getArgOrNull(2);
        if (xobject3 != null) {
            Xobject xobject4 = xobject.getArgOrNull(1);
            if (xobject4 == null) {
                xobject4 = Xcons.List();
                xobject.add(xobject4);
            }
            for (Xobject xobject5 : (XobjList)xobject3) {
                xobject4.add(xobject5);
            }
        }
    }

    private class ResultClause {
        final Xobject pclause;
        final Xobject dclause;

        ResultClause(Xobject xobject, Xobject xobject2) {
            this.pclause = xobject;
            this.dclause = xobject2;
        }
    }
}

