/*
 * Decompiled with CFR 0.152.
 */
package exc.openmp;

import exc.object.Ident;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.Xobject;
import exc.object.Xtype;

public enum OMPpragma {
    PARALLEL,
    FOR,
    TASK,
    SIMD,
    DECLARE,
    SECTIONS,
    SECTION,
    SINGLE,
    MASTER,
    CRITICAL,
    BARRIER,
    ATOMIC,
    FLUSH,
    ORDERED,
    THREADPRIVATE,
    PARALLEL_FOR,
    PARALLEL_SECTIONS,
    FUNCTION_BODY,
    DATA_NONE,
    DATA_DEFAULT,
    DATA_PRIVATE,
    DATA_SHARED,
    DATA_FIRSTPRIVATE,
    DATA_LASTPRIVATE,
    DATA_COPYPRIVATE,
    DATA_COPYIN,
    _DATA_PRIVATE_SHARED,
    DIR_NUM_THREADS,
    DATA_REDUCTION_PLUS(1),
    DATA_REDUCTION_MINUS(2),
    DATA_REDUCTION_MUL(3),
    DATA_REDUCTION_LOGAND(4),
    DATA_REDUCTION_LOGOR(5),
    DATA_REDUCTION_MIN(6),
    DATA_REDUCTION_MAX(7),
    DATA_REDUCTION_BITAND(8),
    DATA_REDUCTION_BITOR(9),
    DATA_REDUCTION_BITXOR(10),
    DATA_REDUCTION_LOGEQV(11),
    DATA_REDUCTION_LOGNEQV(12),
    DATA_REDUCTION_IAND(13),
    DATA_REDUCTION_IOR(14),
    DATA_REDUCTION_IEOR(15),
    DATA_DEPEND_IN,
    DATA_DEPEND_OUT,
    DATA_DEPEND_INOUT,
    DATA_FINAL,
    DIR_UNTIED,
    DIR_MERGEABLE,
    DIR_ORDERED,
    DIR_IF,
    DIR_NOWAIT,
    DIR_SCHEDULE,
    DEFAULT_NONE,
    DEFAULT_SHARED,
    DEFAULT_PRIVATE,
    _DEFAULT_NOT_SET,
    SCHED_NONE,
    SCHED_STATIC,
    SCHED_DYNAMIC,
    SCHED_GUIDED,
    SCHED_RUNTIME,
    SCHED_AFFINITY;

    private String name;
    private int id;

    private OMPpragma() {
    }

    private OMPpragma(int n2) {
        this.id = n2;
    }

    public boolean isDataReduction() {
        switch (this) {
            case DATA_REDUCTION_PLUS: 
            case DATA_REDUCTION_MINUS: 
            case DATA_REDUCTION_MUL: 
            case DATA_REDUCTION_BITAND: 
            case DATA_REDUCTION_BITOR: 
            case DATA_REDUCTION_BITXOR: 
            case DATA_REDUCTION_LOGAND: 
            case DATA_REDUCTION_LOGOR: 
            case DATA_REDUCTION_MIN: 
            case DATA_REDUCTION_MAX: 
            case DATA_REDUCTION_LOGEQV: 
            case DATA_REDUCTION_LOGNEQV: 
            case DATA_REDUCTION_IAND: 
            case DATA_REDUCTION_IOR: 
            case DATA_REDUCTION_IEOR: {
                return true;
            }
        }
        return false;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.toString().toLowerCase();
        }
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public static OMPpragma valueOf(Xobject xobject) {
        return OMPpragma.valueOf(xobject.getString());
    }

    public Xobject getReductionExpr(Xobject xobject, Xobject xobject2) {
        Xcode xcode = null;
        String string = null;
        switch (this) {
            case DATA_REDUCTION_PLUS: {
                xcode = Xcode.PLUS_EXPR;
                break;
            }
            case DATA_REDUCTION_MINUS: {
                xcode = Xcode.MINUS_EXPR;
                break;
            }
            case DATA_REDUCTION_MUL: {
                xcode = Xcode.MUL_EXPR;
                break;
            }
            case DATA_REDUCTION_BITAND: {
                xcode = Xcode.BIT_AND_EXPR;
                break;
            }
            case DATA_REDUCTION_BITOR: {
                xcode = Xcode.BIT_OR_EXPR;
                break;
            }
            case DATA_REDUCTION_BITXOR: {
                xcode = Xcode.BIT_XOR_EXPR;
                break;
            }
            case DATA_REDUCTION_LOGAND: {
                xcode = Xcode.LOG_AND_EXPR;
                break;
            }
            case DATA_REDUCTION_LOGOR: {
                xcode = Xcode.LOG_OR_EXPR;
                break;
            }
            case DATA_REDUCTION_LOGEQV: {
                xcode = Xcode.F_LOG_EQV_EXPR;
                break;
            }
            case DATA_REDUCTION_LOGNEQV: {
                xcode = Xcode.F_LOG_NEQV_EXPR;
                break;
            }
            case DATA_REDUCTION_MIN: {
                string = "min";
                break;
            }
            case DATA_REDUCTION_MAX: {
                string = "max";
                break;
            }
            case DATA_REDUCTION_IAND: {
                string = "iand";
                break;
            }
            case DATA_REDUCTION_IOR: {
                string = "ior";
                break;
            }
            case DATA_REDUCTION_IEOR: {
                string = "ieor";
                break;
            }
            default: {
                throw new IllegalStateException(this.toString());
            }
        }
        if (xcode != null) {
            return Xcons.List(xcode, xobject, xobject2);
        }
        return Xcons.functionCall(Ident.FidentNotExternal(string, Xtype.FnumericalAllFunctionType), Xcons.List(xobject, xobject2));
    }
}

