/*
 * Decompiled with CFR 0.152.
 */
package exc.openmp;

import exc.block.Block;
import exc.block.BlockList;
import exc.object.Ident;
import exc.object.PropObject;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.XobjectIterator;
import exc.object.Xtype;
import exc.object.bottomupXobjectIterator;
import exc.object.topdownXobjectIterator;
import exc.openmp.OMP;
import exc.openmp.OMPfileEnv;
import exc.openmp.OMPpragma;
import exc.openmp.OMPvar;
import exc.xcodeml.XcodeMLtools;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import xcodeml.util.XmOption;

public class OMPinfo {
    private OMPinfo parent;
    private Block block;
    OMPpragma pragma;
    Xobject arg;
    private List<OMPvar> varlist;
    private XobjList id_list;
    private List<OMPvar> thdprv_varlist;
    private XcodeMLtools tools;
    List<Xobject> flush_vars;
    OMPpragma sched = OMPpragma.SCHED_NONE;
    Xobject sched_chunk;
    boolean ordered;
    boolean untied;
    boolean mergeable;
    boolean simd;
    OMPpragma data_default = OMPpragma._DEFAULT_NOT_SET;
    Xobject num_threads;
    boolean no_wait;
    private Xobject if_expr;
    private Xobject final_expr;
    private List<Xobject> region_args;
    private List<Ident> region_params;
    private Xobject thdnum_var;
    OMPfileEnv env;
    public static final String PROP_KEY_THDPRV = "OMPInfo.threadprivate";

    public OMPinfo(OMPpragma oMPpragma, OMPinfo oMPinfo, Block block, OMPfileEnv oMPfileEnv) {
        this.pragma = oMPpragma;
        this.parent = oMPinfo;
        this.block = block;
        this.env = oMPfileEnv;
        this.id_list = Xcons.IDList();
        this.varlist = new LinkedList<OMPvar>();
        this.region_args = new ArrayList<Xobject>();
        this.region_params = new ArrayList<Ident>();
        OMP.debug("OMPinfo");
        if (oMPpragma == OMPpragma.PARALLEL || oMPpragma == OMPpragma.TASK) {
            for (Block block2 = block.getParentBlock(); block2 != null; block2 = block2.getParentBlock()) {
                XobjList xobjList;
                BlockList blockList = block2.getBody();
                if (blockList == null || (xobjList = blockList.getIdentList()) == null) continue;
                for (XobjArgs xobjArgs = ((Xobject)xobjList).getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
                    Ident ident = (Ident)xobjArgs.getArg();
                    if (ident.getStorageClass() != StorageClass.TAGNAME) continue;
                    for (XobjArgs xobjArgs2 = this.id_list.getArgs(); xobjArgs2 != null; xobjArgs2 = xobjArgs2.nextArgs()) {
                        if (!((Ident)xobjArgs2.getArg()).getName().equals(ident.getName())) continue;
                        ident = null;
                        break;
                    }
                    if (ident == null) continue;
                    this.id_list.add(ident.copy());
                }
            }
        }
        if (oMPpragma == OMPpragma.PARALLEL || oMPpragma == OMPpragma.FUNCTION_BODY || oMPpragma == OMPpragma.TASK) {
            this.thdprv_varlist = new ArrayList<OMPvar>();
        }
    }

    public Block getBlock() {
        OMP.debug("getBlock");
        return this.block;
    }

    List<OMPvar> getVarList() {
        OMP.debug("getVarList");
        return this.varlist;
    }

    private void addVar(OMPvar oMPvar) {
        OMP.debug("addVar");
        this.varlist.add(oMPvar);
    }

    OMPvar findOMPvar(String string) {
        OMP.debug("findOMPVar");
        for (OMPvar oMPvar : this.varlist) {
            if (!oMPvar.id.getName().equals(string)) continue;
            return oMPvar;
        }
        return null;
    }

    OMPvar findOMPvar(Ident ident) {
        OMP.debug("findOMPVar");
        for (OMPvar oMPvar : this.varlist) {
            if (oMPvar.id != ident) continue;
            return oMPvar;
        }
        OMPvar oMPvar = (OMPvar)ident.getProp(PROP_KEY_THDPRV);
        return oMPvar;
    }

    boolean isPrivateOMPvar(String string) {
        OMPinfo oMPinfo;
        BlockList blockList;
        OMP.debug("isPrivateOMPVar");
        OMPvar oMPvar = null;
        Ident ident = null;
        for (Block block = this.block; block != null && ((blockList = block.getBody()) == null || (ident = blockList.findLocalIdent(string)) == null && ((oMPinfo = (OMPinfo)block.getProp("OMPprop")) == null || (oMPvar = oMPinfo.findOMPvar(string)) == null && oMPinfo.pragma != OMPpragma.PARALLEL && oMPinfo.pragma != OMPpragma.TASK)); block = block.getParentBlock()) {
        }
        if (ident != null) {
            switch (ident.getStorageClass()) {
                case PARAM: 
                case FPARAM: 
                case AUTO: 
                case REGISTER: {
                    return true;
                }
            }
        }
        return oMPvar != null && oMPvar.is_private;
    }

    OMPvar declOMPvar(String string, OMPpragma oMPpragma) {
        OMPinfo oMPinfo;
        Object object;
        Object object2;
        OMP.debug("declOMPVar");
        if (oMPpragma == null) {
            return null;
        }
        OMPvar oMPvar = null;
        Ident ident = null;
        if (OMP.debugFlag) {
            System.out.println("declOMPvar name=" + string + ", atr=" + (Object)((Object)oMPpragma));
        }
        if ((oMPvar = this.findOMPvar(string)) != null) {
            if (oMPvar.atr == OMPpragma.DATA_FIRSTPRIVATE && oMPpragma == OMPpragma.DATA_COPYPRIVATE || oMPpragma == OMPpragma.DATA_FIRSTPRIVATE && oMPvar.atr == OMPpragma.DATA_COPYPRIVATE) {
                OMP.error(this.block.getLineNo(), "copyprivate variable cannot be firstprivate");
                return null;
            }
            if (oMPvar.atr == OMPpragma.DATA_FIRSTPRIVATE && oMPpragma == OMPpragma.DATA_LASTPRIVATE || oMPpragma == OMPpragma.DATA_FIRSTPRIVATE && oMPvar.atr == OMPpragma.DATA_LASTPRIVATE) {
                oMPvar.is_first_private = true;
                oMPvar.is_last_private = true;
                return oMPvar;
            }
        }
        for (object2 = this.block; object2 != null && ((object = ((Block)object2).getBody()) == null || (ident = ((BlockList)object).findLocalIdent(string)) == null && ((oMPinfo = (OMPinfo)((PropObject)object2).getProp("OMPprop")) == null || (oMPvar = oMPinfo.findOMPvar(string)) == null && oMPinfo.pragma != OMPpragma.PARALLEL && oMPinfo.pragma != OMPpragma.TASK)); object2 = ((Block)object2).getParentBlock()) {
        }
        if (ident != null) {
            switch (ident.getStorageClass()) {
                case PARAM: 
                case FPARAM: 
                case AUTO: 
                case REGISTER: {
                    if (oMPpragma != OMPpragma.DATA_PRIVATE) {
                        OMP.warning(this.block.getLineNo(), "local variable '" + string + "' is already private");
                    }
                    return null;
                }
            }
        }
        if (oMPvar != null) {
            if (oMPvar.is_private) {
                if (oMPpragma == OMPpragma.DATA_COPYPRIVATE) {
                    oMPvar.is_copy_private = true;
                    oMPvar.setCopyPrivateAddr(this.createCopyPrivateAddr(oMPvar));
                } else {
                    OMP.warning(this.block.getLineNo(), "variable '" + string + "' is already defined as private");
                }
                return oMPvar;
            }
            if (oMPvar.is_shared && oMPpragma == OMPpragma.DATA_SHARED) {
                return oMPvar;
            }
        }
        if ((ident = this.block.findVarIdent(string)) == null) {
            OMP.error(this.block.getLineNo(), "undefined variable in clause, '" + string + "'");
            return null;
        }
        object2 = ident.Type();
        if (((Xtype)object2).isFunction()) {
            OMP.error(this.block.getLineNo(), "data '" + string + "' in cluase is a function");
            return null;
        }
        if (oMPpragma.isDataReduction() && (XmOption.isLanguageC() && !((Xtype)object2).isNumeric() || XmOption.isLanguageF() && (!((Xtype)object2).isFarray() && !((Xtype)object2).isNumeric() || ((Xtype)object2).isFarray() && !((Xtype)object2).getRef().isNumeric()))) {
            OMP.error(this.block.getLineNo(), "non-scalar variable '" + string + "' in reduction clause");
            return null;
        }
        if (ident.getStorageClass() != null) {
            if (this.env.isThreadPrivate(ident)) {
                if (oMPpragma != OMPpragma.DATA_COPYIN) {
                    OMP.error(this.block.getLineNo(), "variable '" + string + "' is threadprivate");
                    return null;
                }
                object = OMPinfo.refOMPvar(this.block, ident.getName());
                if (object != null) {
                    oMPvar = this.declCopyinThreadPrivate((OMPvar)object);
                }
                return oMPvar;
            }
            if (oMPpragma == OMPpragma.DATA_COPYIN) {
                OMP.error(this.block.getLineNo(), "non-threadprivate'" + string + "' in COPYIN clause");
                return null;
            }
        }
        oMPvar = new OMPvar(ident, oMPpragma);
        if (((Xtype)object2).isVariableArray()) {
            oMPvar.setSizeOfArray(Xcons.binaryOp(Xcode.MUL_EXPR, OMPinfo.refOMPvarExpr(this.block, ((Xtype)object2).getArraySizeExpr().copy()), Xcons.SizeOf(((Xtype)object2).getRef())));
        }
        if (oMPvar.is_private) {
            oMPvar.setPrivateAddr(this.createPrivateAddr(oMPvar));
        }
        if (oMPvar.is_copy_private) {
            oMPvar.setCopyPrivateAddr(this.createCopyPrivateAddr(oMPvar));
        }
        if (oMPvar.is_shared) {
            oMPvar.setSharedAddr(this.createSharedAddr(ident));
        }
        if (oMPvar.is_reduction) {
            oMPvar.setSharedArray(this.createSharedArray(oMPvar, 0, true));
        }
        this.addVar(oMPvar);
        return oMPvar;
    }

    private Xobject createPrivateAddr(OMPvar oMPvar) {
        OMP.debug("createPrivateAddr");
        Ident ident = oMPvar.id;
        Xtype xtype = ident.Type();
        if (oMPvar.isVariableArray()) {
            xtype = Xtype.Pointer(ident.Type().getRef());
        } else {
            xtype = xtype.copy();
            if (XmOption.isLanguageC()) {
                xtype.setIsConst(false);
            } else {
                xtype.unsetIsFsave();
                xtype.setIsFintentIN(false);
                xtype.setIsFintentOUT(false);
                xtype.setIsFintentINOUT(false);
                if (oMPvar.is_reduction || oMPvar.is_shared && !oMPvar.is_first_private && !oMPvar.is_last_private && !oMPvar.is_private) {
                    xtype.unsetIsFtarget();
                    xtype.setIsFpointer(true);
                    if (xtype.isFarray()) {
                        xtype.convertToAssumedShape();
                    }
                }
            }
        }
        Ident ident2 = Ident.Local("p_" + ident.getName(), xtype);
        this.id_list.add(ident2);
        return ident.Type().isArray() ? ident2.Ref() : ident2.getAddr();
    }

    private Xobject createCopyPrivateAddr(OMPvar oMPvar) {
        OMP.debug("createCopyPrivateAddr");
        Ident ident = oMPvar.id;
        Xtype xtype = ident.Type();
        if (oMPvar.isVariableArray()) {
            xtype = Xtype.Pointer(ident.Type().getRef());
        } else {
            xtype = xtype.copy();
            xtype.setIsConst(false);
        }
        Ident ident2 = Ident.Local("cp_" + ident.getName(), xtype);
        this.id_list.add(ident2);
        return ident.Type().isArray() ? ident2.Ref() : ident2.getAddr();
    }

    private Xobject createSharedAddr(Ident ident) {
        OMPvar oMPvar;
        OMPinfo oMPinfo;
        BlockList blockList;
        Block block;
        OMP.debug("createSharedAddr");
        StorageClass storageClass = ident.getStorageClass();
        if (storageClass.isBSS()) {
            for (block = this.block; !(block == null || storageClass != StorageClass.FCOMMON && (blockList = block.getBody()) != null && blockList.findLocalIdent(ident) != null || (oMPinfo = (OMPinfo)block.getProp("OMPprop")) != null && (oMPvar = oMPinfo.findOMPvar(ident)) != null && oMPvar.is_private); block = block.getParentBlock()) {
            }
            if (block == null) {
                return ident.Type().isArray() ? ident.Ref() : ident.getAddr();
            }
        }
        for (block = this.block; block != null; block = block.getParentBlock()) {
            blockList = block.getBody();
            if (blockList != null && blockList.findLocalIdent(ident) != null) {
                return ident.Type().isArray() ? ident.Ref() : ident.getAddr();
            }
            oMPinfo = (OMPinfo)block.getProp("OMPprop");
            if (oMPinfo == null) continue;
            oMPvar = oMPinfo.findOMPvar(ident.getName());
            if (oMPvar != null) {
                return oMPvar.getAddr();
            }
            if (oMPinfo.pragma != OMPpragma.PARALLEL && oMPinfo.pragma != OMPpragma.TASK) continue;
            return this.addRegionVar(block, oMPinfo, ident);
        }
        OMP.fatal("sharedAddr: id is not found, id =" + ident);
        return null;
    }

    private Xobject createSharedArray(OMPvar oMPvar, int n, boolean bl) {
        OMP.debug("createSharedArray");
        if (!XmOption.isLanguageF()) {
            return null;
        }
        Ident ident = oMPvar.id;
        Xtype xtype = ident.Type();
        Xobject[] xobjectArray = new Xobject[xtype.getNumDimensions() + 1];
        for (int i = 0; i < xobjectArray.length; ++i) {
            xobjectArray[i] = Xcons.FindexRangeOfAssumedShape();
        }
        xtype = Xtype.Farray(xtype.isFarray() ? xtype.getRef() : xtype, xobjectArray);
        if (bl) {
            xtype.setIsFpointer(false);
            xtype.setIsFallocatable(true);
            xtype.setIsFtarget(true);
        } else {
            xtype.setIsFpointer(true);
            xtype.setIsFallocatable(false);
            xtype.unsetIsFtarget();
        }
        xtype.setIsFsave(true);
        Ident ident2 = Ident.Fident("ts_" + ident.getName(), xtype);
        ident2.getAddr().setIsDelayedDecl(false);
        return ident2.getAddr();
    }

    private Xobject addRegionVar(Block block, OMPinfo oMPinfo, Ident ident) {
        Xtype xtype;
        OMP.debug("addRegionVar");
        if (XmOption.isLanguageF() && ident.Type() != null && ident.Type().isFparameter()) {
            return null;
        }
        String string = "pp_" + ident.getName();
        OMP.debug(string);
        if (oMPinfo.id_list.hasIdent(string)) {
            return oMPinfo.id_list.getIdent(string).Ref();
        }
        OMPvar oMPvar = OMPinfo.refOMPvar(block.getParentBlock(), ident.getName());
        Xobject xobject = oMPvar != null ? oMPvar.getAddr() : ident.getAddr();
        if (xobject == null) {
            throw new NullPointerException("addr");
        }
        oMPinfo.addRegionArg(xobject);
        Xtype xtype2 = ident.Type();
        if (xtype2.isArray()) {
            xtype = Xtype.Pointer(xtype2.getRef());
        } else if (XmOption.isLanguageC()) {
            xtype = Xtype.Pointer(xtype2);
        } else if (xtype2.isStruct()) {
            xtype = xtype2;
        } else {
            xtype = xtype2.copy();
            xtype.unsetIsFtarget();
            xtype.setIsFparameter(false);
            xtype.unsetIsFsave();
            if (xtype.isFarray()) {
                xtype.convertFindexRange(true, true, this.block);
            }
        }
        Ident ident2 = Ident.Local(string, xtype);
        for (int i = 0; i < oMPinfo.region_params.size(); ++i) {
            if (!oMPinfo.region_params.get(i).getName().equals(ident2.getName())) continue;
            return ident2.Ref();
        }
        oMPinfo.id_list.add(ident2);
        oMPinfo.addRegionParam(ident2);
        return ident2.Ref();
    }

    private void addRegionVarInExpr(Xobject xobject, Block block, OMPinfo oMPinfo) {
        OMP.debug("addRegionVarInExpr");
        if (xobject == null) {
            return;
        }
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject);
        topdownXobjectIterator2.init();
        while (!topdownXobjectIterator2.end()) {
            Ident ident;
            Xobject xobject2 = topdownXobjectIterator2.getXobject();
            if (xobject2 != null && xobject2.isVarRef() && (ident = oMPinfo.getIdList().findVarIdent(xobject2.getName())) == null) {
                ident = this.block.findVarIdent(xobject2.getName());
                if (ident == null) {
                    throw new NullPointerException("not found ident in array size : " + xobject2.getName());
                }
                OMPvar oMPvar = this.findOMPvar(ident);
                if (oMPvar == null) {
                    OMPinfo.refOMPvar(block, xobject2.getName(), OMPpragma.DATA_SHARED);
                }
            }
            topdownXobjectIterator2.next();
        }
    }

    void declOMPVarsInType(XobjList xobjList) {
        OMP.debug("addRegionVarInType");
        OMPinfo oMPinfo = null;
        Block block = null;
        for (block = this.block; block != null && (oMPinfo = (OMPinfo)block.getProp("OMPprop")) == null; block = block.getParentBlock()) {
        }
        if (oMPinfo == null) {
            return;
        }
        for (Xobject xobject : xobjList) {
            OMPvar oMPvar = this.findOMPvar(xobject.getName());
            if (oMPvar == null) {
                return;
            }
            Xtype xtype = oMPvar.id.Type();
            switch (xtype.getKind()) {
                case 1: {
                    if (!XmOption.isLanguageF()) break;
                    this.addRegionVarInExpr(xtype.getFlen(), block, oMPinfo);
                    break;
                }
                case 6: {
                    this.addRegionVarInExpr(xtype.getArraySizeExpr(), block, oMPinfo);
                    break;
                }
                case 8: {
                    for (Xobject xobject2 : xtype.getFarraySizeExpr()) {
                        this.addRegionVarInExpr(xobject2, block, oMPinfo);
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    OMPvar declThreadPrivate(Ident ident) {
        Xobject xobject;
        void var3_6;
        OMP.debug("declThreadPrivate");
        for (OMPvar object2 : this.varlist) {
            if (object2.id != ident) continue;
            return object2;
        }
        OMPvar oMPvar = new OMPvar(ident, OMPpragma.DATA_NONE);
        ident.setProp(PROP_KEY_THDPRV, oMPvar);
        if (OMP.leaveThreadPrivateFlag) {
            oMPvar.setSharedAddr(ident.getAddr());
            this.addVar(oMPvar);
            return oMPvar;
        }
        if (XmOption.isLanguageC()) {
            Xtype xtype = Xtype.Pointer(ident.Type());
        } else {
            Xtype xtype = ident.Type().copy();
            xtype.unsetIsFsave();
            xtype.unsetIsFtarget();
            xtype.setIsFpointer(true);
            if (xtype.isFarray()) {
                xtype.convertToAssumedShape();
            }
        }
        Ident ident2 = Ident.Local("tp_" + ident.getName(), (Xtype)var3_6);
        oMPvar.setThdPrvLocalId(ident2);
        Xobject xobject2 = xobject = ident.Type().isArray() ? Xcons.PointerRef(ident2.Ref()) : ident2.Ref();
        if (oMPvar.id.isCglobalVarOrFvar()) {
            if (XmOption.isLanguageF()) {
                Xtype xtype = ident.Type().copy();
                xtype.unsetIsFsave();
                if (xtype.isFarray()) {
                    xtype.convertFindexRange(true, false, this.block);
                }
                Ident ident3 = Ident.Fident("pp_" + ident.getName(), xtype);
                oMPvar.setPrivateAddr(xobject);
                oMPvar.setSharedAddr(ident3);
                oMPvar.setSharedArray(this.createSharedArray(oMPvar, -1, false));
                this.addRegionArg(oMPvar.id);
                this.addRegionParam(ident3);
            } else {
                oMPvar.setSharedAddr(xobject);
            }
        } else {
            oMPvar.setPrivateAddr(xobject);
            oMPvar.setSharedAddr(this.createSharedAddr(ident));
        }
        this.addThdPrvVar(oMPvar);
        this.addVar(oMPvar);
        return oMPvar;
    }

    OMPvar declCopyinThreadPrivate(OMPvar oMPvar) {
        OMP.debug("declCopyinThreadPrivate");
        OMPvar oMPvar2 = new OMPvar(oMPvar.id, OMPpragma.DATA_COPYIN);
        oMPvar2.setPrivateAddr(oMPvar.getPrivateAddr());
        oMPvar2.setSharedAddr(oMPvar.getSharedAddr());
        oMPvar2.setSharedArray(oMPvar.getSharedArray());
        oMPvar2.setThdPrvLocalId(oMPvar.getThdPrvLocalId());
        this.addVar(oMPvar2);
        boolean bl = false;
        for (OMPvar oMPvar3 : this.getThdPrvVarList()) {
            if (oMPvar3.id != oMPvar2.id) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.addThdPrvVar(oMPvar2);
        }
        return oMPvar2;
    }

    static OMPvar findOMPvarRecurse(Block block, String string) {
        OMP.debug("findOMPvarRecurse");
        while (block != null) {
            OMPvar oMPvar;
            BlockList blockList = block.getBody();
            if (blockList != null && blockList.findLocalIdent(string) != null) {
                return null;
            }
            OMPinfo oMPinfo = (OMPinfo)block.getProp("OMPprop");
            if (oMPinfo != null && (oMPvar = oMPinfo.findOMPvar(string)) != null) {
                return oMPvar;
            }
            block = block.getParentBlock();
        }
        return null;
    }

    static OMPvar refOMPvar(Block block, String string) {
        OMP.debug("refOMPvar" + string);
        return OMPinfo.refOMPvar(block, string, null);
    }

    private static OMPvar refOMPvar(Block block, String string, OMPpragma oMPpragma) {
        OMP.debug("refOMPvar");
        while (block != null) {
            BlockList blockList = block.getBody();
            if (blockList != null && blockList.findLocalIdent(string) != null) {
                return null;
            }
            OMPinfo oMPinfo = (OMPinfo)block.getProp("OMPprop");
            if (oMPinfo != null) {
                OMPvar oMPvar = oMPinfo.findOMPvar(string);
                if (oMPvar != null) {
                    return oMPvar;
                }
                switch (oMPinfo.pragma) {
                    case PARALLEL: 
                    case TASK: {
                        Ident ident = oMPinfo.env.findThreadPrivate(block, string);
                        if (ident != null) {
                            return oMPinfo.declThreadPrivate(ident);
                        }
                        ident = block.findVarIdent(string);
                        if (ident == null) {
                            return null;
                        }
                        if (ident.Type() != null && ident.Type().isFparameter()) {
                            return null;
                        }
                        OMPpragma oMPpragma2 = null;
                        if (oMPinfo.data_default == OMPpragma._DEFAULT_NOT_SET && ident.isInductionVar()) {
                            oMPpragma2 = OMPpragma.DATA_PRIVATE;
                        } else if (oMPinfo.data_default == OMPpragma.DEFAULT_SHARED || oMPinfo.data_default == OMPpragma._DEFAULT_NOT_SET) {
                            oMPpragma2 = OMPpragma.DATA_SHARED;
                        } else if (oMPinfo.data_default == OMPpragma.DEFAULT_PRIVATE) {
                            oMPpragma2 = ident.getStorageClass().isFuncParam() ? OMPpragma._DATA_PRIVATE_SHARED : OMPpragma.DATA_PRIVATE;
                        } else if (oMPpragma != null) {
                            oMPpragma2 = oMPpragma;
                        } else {
                            OMP.error(block.getLineNo(), "unknown data attribute on '" + string + "', default data attribute is 'none'");
                        }
                        return oMPinfo.declOMPvar(string, oMPpragma2);
                    }
                    case FUNCTION_BODY: {
                        Ident ident = oMPinfo.env.findThreadPrivate(block, string);
                        if (ident == null) break;
                        return oMPinfo.declThreadPrivate(ident);
                    }
                }
            }
            block = block.getParentBlock();
        }
        return null;
    }

    static OMPvar findOMPvarBySharedOrPrivate(Block block, String string) {
        OMP.debug("findOMPvarBySharedOrPrivate");
        if (string.startsWith("p_")) {
            return OMPinfo.findOMPvarRecurse(block, string.substring("p_".length()));
        }
        if (string.startsWith("pp_")) {
            return OMPinfo.findOMPvarRecurse(block, string.substring("pp_".length()));
        }
        return null;
    }

    static Xobject refOMPvarExpr(Block block, Xobject xobject) {
        OMP.debug("refOMPvarExpr");
        if (xobject == null) {
            return null;
        }
        bottomupXobjectIterator bottomupXobjectIterator2 = new bottomupXobjectIterator(xobject);
        ((XobjectIterator)bottomupXobjectIterator2).init();
        while (!((XobjectIterator)bottomupXobjectIterator2).end()) {
            Xobject xobject2 = bottomupXobjectIterator2.getXobject();
            if (xobject2 != null) {
                OMPvar oMPvar;
                if (xobject2.isVariable()) {
                    oMPvar = OMPinfo.refOMPvar(block, xobject2.getName());
                    if (oMPvar != null) {
                        bottomupXobjectIterator2.setXobject(oMPvar.Ref());
                    }
                } else if ((xobject2.isVarAddr() || xobject2.isArray() || xobject2.isArrayAddr()) && (oMPvar = OMPinfo.refOMPvar(block, xobject2.getName())) != null && oMPvar != null) {
                    bottomupXobjectIterator2.setXobject(oMPvar.getAddr());
                }
            }
            ((XobjectIterator)bottomupXobjectIterator2).next();
        }
        return bottomupXobjectIterator2.topXobject();
    }

    void setSchedule(Xobject xobject) {
        OMP.debug("setSchedule");
        if (xobject == null) {
            return;
        }
        if (this.sched != OMPpragma.SCHED_NONE) {
            OMP.error(this.block.getLineNo(), "schedule clause is already specified");
            return;
        }
        this.sched = OMPpragma.valueOf(xobject.getArg(0));
        this.sched_chunk = xobject.getArgOrNull(1);
        if (this.sched == OMPpragma.SCHED_RUNTIME && this.sched_chunk != null) {
            OMP.error(this.block.getLineNo(), "schedule RUNTIME has chunk argument");
        }
        if (this.sched == OMPpragma.SCHED_AFFINITY) {
            OMP.error(this.block.getLineNo(), "schedule AFFINITY is not supported in this mode");
        }
        this.sched_chunk = OMPinfo.refOMPvarExpr(this.block.getParentBlock(), this.sched_chunk);
        if (OMP.debugFlag) {
            System.out.println("schedule(" + (Object)((Object)this.sched) + "," + this.sched_chunk + ")");
        }
    }

    void setIfExpr(Xobject xobject) {
        OMP.debug("setIfExpr");
        this.if_expr = OMPinfo.refOMPvarExpr(this.block.getParentBlock(), xobject);
        if (XmOption.isLanguageC() && !this.if_expr.Type().isIntegral()) {
            this.if_expr = Xcons.Cast(Xtype.intType, this.if_expr);
        }
        if (OMP.debugFlag) {
            System.out.println("parallel if = " + this.if_expr);
        }
    }

    void setFinalExpr(Xobject xobject) {
        OMP.debug("setFinalExpr");
        this.final_expr = OMPinfo.refOMPvarExpr(this.block.getParentBlock(), xobject);
        if (XmOption.isLanguageC() && !this.final_expr.Type().isIntegral()) {
            this.final_expr = Xcons.Cast(Xtype.intType, this.final_expr);
        }
        if (OMP.debugFlag) {
            System.out.println("task final = " + this.final_expr);
        }
    }

    void setFlushVars(Xobject xobject) {
        OMP.debug("setFlushVars");
        if (xobject == null) {
            return;
        }
        this.flush_vars = new ArrayList<Xobject>();
        block3: for (Xobject xobject2 : (XobjList)xobject) {
            OMPvar oMPvar = OMPinfo.refOMPvar(this.block, xobject2.getName());
            if (oMPvar != null) {
                if (oMPvar.is_private) {
                    OMP.error(this.block.getLineNo(), "private variable in flush, '" + xobject2.getName() + "'");
                    continue;
                }
                if (!oMPvar.is_shared) {
                    OMP.fatal("not shared variable in flush '" + xobject2.getName() + "'");
                }
                if (!XmOption.isLanguageC()) continue;
                this.flush_vars.add(Xcons.List(oMPvar.getSharedAddr(), oMPvar.getSize()));
                continue;
            }
            Ident ident = this.block.findVarIdent(xobject2.getName());
            if (ident == null) {
                OMP.error(this.block.getLineNo(), "undefined variable '" + xobject2.getName() + "' in flush");
                continue;
            }
            switch (ident.getStorageClass()) {
                case FPARAM: 
                case EXTERN: 
                case EXTDEF: 
                case STATIC: 
                case FCOMMON: 
                case FSAVE: {
                    break;
                }
                default: {
                    OMP.error(this.block.getLineNo(), "local variable '" + xobject2.getName() + "' in flush");
                    continue block3;
                }
            }
            if (!XmOption.isLanguageC()) continue;
            Xtype xtype = ident.Type();
            Xobject xobject3 = xtype.isVariableArray() ? Xcons.binaryOp(Xcode.MUL_EXPR, OMPinfo.refOMPvarExpr(this.block, xtype.getArraySizeExpr().copy()), Xcons.SizeOf(xtype.getRef())) : Xcons.SizeOf(xtype);
            this.flush_vars.add(Xcons.List(ident.getAddr(), xobject3));
        }
    }

    OMPinfo findContext(OMPpragma oMPpragma) {
        OMP.debug("findContext");
        OMPinfo oMPinfo = this.parent;
        while (oMPinfo != null) {
            if (oMPinfo.pragma == oMPpragma) {
                return oMPinfo;
            }
            oMPinfo = oMPinfo.parent;
        }
        return null;
    }

    OMPinfo findContext(OMPpragma oMPpragma, Xobject xobject) {
        OMP.debug("findContext");
        OMPinfo oMPinfo = this.parent;
        while (oMPinfo != null) {
            if (oMPinfo.pragma == oMPpragma && oMPinfo.arg == xobject) {
                return oMPinfo;
            }
            oMPinfo = oMPinfo.parent;
        }
        return null;
    }

    OMPinfo findContext(OMPpragma oMPpragma, OMPpragma oMPpragma2) {
        OMPinfo oMPinfo = this.parent;
        while (oMPinfo != null && oMPinfo.pragma != oMPpragma2) {
            if (oMPinfo.pragma == oMPpragma) {
                return oMPinfo;
            }
            oMPinfo = oMPinfo.parent;
        }
        return null;
    }

    public List<Xobject> getRegionArgs() {
        OMP.debug("getRegionArgs");
        return this.region_args;
    }

    private void addRegionArg(Xobject xobject) {
        OMP.debug("getRegionArg");
        this.region_args.add(xobject);
    }

    public List<Ident> getRegionParams() {
        OMP.debug("getRegionParams");
        return this.region_params;
    }

    private void addRegionParam(Ident ident) {
        OMP.debug("addRegionParam" + ident.toString());
        this.region_params.add(ident);
    }

    public boolean hasIfExpr() {
        OMP.debug("hasIfExpr");
        return this.if_expr != null;
    }

    public Xobject getIfExpr() {
        OMP.debug("getIfExpr");
        return this.if_expr;
    }

    public boolean hasFinalExpr() {
        OMP.debug("hasFinalExpr");
        return this.final_expr != null;
    }

    public Xobject getFinalExpr() {
        OMP.debug("getFinalExpr");
        return this.final_expr;
    }

    public Xobject getIdList() {
        OMP.debug("getIdList");
        return this.id_list;
    }

    public List<OMPvar> getThdPrvVarList() {
        OMP.debug("getThdPrvVarList");
        return this.thdprv_varlist;
    }

    private void addThdPrvVar(OMPvar oMPvar) {
        OMP.debug("addThdPrvVar");
        this.thdprv_varlist.add(oMPvar);
    }

    public OMPpragma getSched() {
        OMP.debug("getSched");
        return this.sched;
    }

    public void setSchedChunk(Xobject xobject) {
        OMP.debug("setSchedChunk");
        this.sched_chunk = xobject;
    }

    public Xobject getSchedChunk() {
        OMP.debug("getSchedChunk");
        return this.sched_chunk;
    }

    public boolean isOrdered() {
        OMP.debug("isOrdered");
        return this.ordered;
    }

    public boolean isNoWait() {
        OMP.debug("isNoWait");
        return this.no_wait;
    }

    public Xobject getNumThreads() {
        OMP.debug("getNumThreads");
        return this.num_threads;
    }

    public boolean hasCopyPrivate() {
        OMP.debug("hasCopyPrivate");
        for (OMPvar oMPvar : this.varlist) {
            if (!oMPvar.is_copy_private) continue;
            return true;
        }
        return false;
    }

    public Xobject getThreadNumVar() {
        OMP.debug("getThreadNumVar");
        if (this.thdnum_var == null) {
            this.thdnum_var = Ident.Fident("p__tn", Xtype.FintType).getAddr();
        }
        return this.thdnum_var;
    }
}

