/*
 * Decompiled with CFR 0.152.
 */
package exc.openmp;

import exc.block.BasicBlock;
import exc.block.Block;
import exc.block.BlockIterator;
import exc.block.FdoBlock;
import exc.block.ForBlock;
import exc.block.FuncDefBlock;
import exc.block.FunctionBlock;
import exc.block.PragmaBlock;
import exc.block.topdownBlockIterator;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.openmp.OMP;
import exc.openmp.OMPfileEnv;
import exc.openmp.OMPinfo;
import exc.openmp.OMPpragma;
import exc.openmp.OMPvar;
import java.util.ArrayList;
import xcodeml.util.XmOption;

public class OMPanalyzePragma {
    FuncDefBlock def;
    OMPfileEnv omp_env;

    public void run(FuncDefBlock funcDefBlock, OMPfileEnv oMPfileEnv) {
        this.def = funcDefBlock;
        this.omp_env = oMPfileEnv;
        FunctionBlock functionBlock = funcDefBlock.getBlock();
        OMP.debug("run");
        if (OMP.debugFlag) {
            System.out.println("pass1:");
        }
        Block block = ((Block)functionBlock).getBody().getHead();
        block.setProp("OMPprop", new OMPinfo(OMPpragma.FUNCTION_BODY, null, block, oMPfileEnv));
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(functionBlock);
        ((BlockIterator)topdownBlockIterator2).init();
        while (!((BlockIterator)topdownBlockIterator2).end()) {
            block = topdownBlockIterator2.getBlock();
            if (OMP.debugFlag) {
                System.out.println("pass1=" + block);
            }
            if (block.Opcode() == Xcode.OMP_PRAGMA) {
                this.checkPragma((PragmaBlock)block);
            }
            ((BlockIterator)topdownBlockIterator2).next();
        }
    }

    OMPinfo outerOMPinfo(Block block) {
        OMP.debug("outerOMPinfo");
        for (Block block2 = block.getParentBlock(); block2 != null; block2 = block2.getParentBlock()) {
            if (block2.Opcode() != Xcode.OMP_PRAGMA) continue;
            return (OMPinfo)block2.getProp("OMPprop");
        }
        return null;
    }

    void checkPragma(PragmaBlock pragmaBlock) {
        OMPinfo oMPinfo = this.outerOMPinfo(pragmaBlock);
        OMPinfo oMPinfo2 = new OMPinfo(OMPpragma.valueOf(pragmaBlock.getPragma()), oMPinfo, pragmaBlock, this.omp_env);
        pragmaBlock.setProp("OMPprop", oMPinfo2);
        OMP.debug("checkPragma");
        OMPpragma oMPpragma = oMPinfo2.pragma;
        switch (oMPpragma) {
            case TASK: {
                oMPinfo2.setIfExpr(Xcons.FlogicalConstant(true));
                oMPinfo2.setFinalExpr(Xcons.FlogicalConstant(false));
            }
            case PARALLEL: 
            case FOR: 
            case SECTIONS: {
                Object object2;
                ArrayList<XobjList> arrayList = new ArrayList<XobjList>();
                block31: for (Object object2 : (XobjList)pragmaBlock.getClauses()) {
                    OMPpragma oMPpragma2 = OMPpragma.valueOf(((Xobject)object2).getArg(0));
                    switch (oMPpragma2) {
                        case DIR_IF: {
                            oMPinfo2.setIfExpr(((Xobject)object2).getArg(1));
                            continue block31;
                        }
                        case DATA_FINAL: {
                            oMPinfo2.setFinalExpr(((Xobject)object2).getArg(1));
                            continue block31;
                        }
                        case DIR_NOWAIT: {
                            oMPinfo2.no_wait = true;
                            continue block31;
                        }
                        case DIR_ORDERED: {
                            oMPinfo2.ordered = true;
                            continue block31;
                        }
                        case DIR_SCHEDULE: {
                            oMPinfo2.setSchedule(((Xobject)object2).getArg(1));
                            continue block31;
                        }
                        case DATA_DEFAULT: {
                            oMPinfo2.data_default = OMPpragma.valueOf(((Xobject)object2).getArg(1));
                            continue block31;
                        }
                        case DIR_NUM_THREADS: {
                            oMPinfo2.num_threads = ((Xobject)object2).getArg(1);
                            continue block31;
                        }
                        case DIR_UNTIED: {
                            oMPinfo2.untied = true;
                            OMP.debug("UNTIED");
                            continue block31;
                        }
                        case DIR_MERGEABLE: {
                            oMPinfo2.mergeable = true;
                            OMP.debug("MERGEABLE");
                            continue block31;
                        }
                        case DATA_DEPEND_IN: 
                        case DATA_DEPEND_OUT: 
                        case DATA_DEPEND_INOUT: {
                            oMPinfo2.mergeable = true;
                            OMP.debug("DEPEND");
                            continue block31;
                        }
                    }
                    for (Object object3 : (XobjList)((Xobject)object2).getArg(1)) {
                        oMPinfo2.declOMPvar(((Xobject)object3).getName(), oMPpragma2);
                    }
                    arrayList.add((XobjList)((Xobject)object2).getArg(1));
                }
                Object object4 = arrayList.iterator();
                while (object4.hasNext()) {
                    object2 = (XobjList)object4.next();
                    oMPinfo2.declOMPVarsInType((XobjList)object2);
                }
                if (oMPpragma == OMPpragma.FOR) {
                    Object object5;
                    if (oMPinfo != null && oMPinfo.pragma != OMPpragma.PARALLEL) {
                        OMP.error(pragmaBlock.getLineNo(), "'FOR/DO' directive is nested");
                        return;
                    }
                    if (XmOption.isLanguageC()) {
                        if (pragmaBlock.getBody().getHead().Opcode() != Xcode.FOR_STATEMENT) {
                            OMP.error(pragmaBlock.getLineNo(), "FOR loop must follows FOR directive");
                            return;
                        }
                    } else if (pragmaBlock.getBody().getHead().Opcode() == Xcode.OMP_PRAGMA) {
                        Object object3;
                        object4 = (PragmaBlock)pragmaBlock.getBody().getHead();
                        object2 = this.outerOMPinfo((Block)object4);
                        object5 = new OMPinfo(OMPpragma.valueOf(((PragmaBlock)object4).getPragma()), (OMPinfo)object2, (Block)object4, this.omp_env);
                        object3 = ((OMPinfo)object5).pragma;
                        switch (1.$SwitchMap$exc$openmp$OMPpragma[((Enum)object3).ordinal()]) {
                            case 13: {
                                oMPinfo2.simd = true;
                            }
                        }
                    } else if (pragmaBlock.getBody().getHead().Opcode() != Xcode.F_DO_STATEMENT) {
                        OMP.error(pragmaBlock.getLineNo(), "DO loop must follows DO directive");
                        return;
                    }
                    if (!oMPinfo2.simd) {
                        object4 = (ForBlock)((Object)pragmaBlock.getBody().getHead());
                        object4.Canonicalize();
                        if (!object4.isCanonical()) {
                            OMP.error(pragmaBlock.getLineNo(), "not cannonical FOR/DO loop");
                            return;
                        }
                        object2 = object4.getInductionVar();
                        if (!oMPinfo2.isPrivateOMPvar(((Xobject)object2).getName())) {
                            object5 = oMPinfo2.findOMPvar(((Xobject)object2).getName());
                            if (object5 == null) {
                                oMPinfo2.declOMPvar(((Xobject)object2).getName(), OMPpragma.DATA_PRIVATE);
                            } else if (!((OMPvar)object5).is_last_private && ((OMPvar)object5).is_shared) {
                                OMP.error(pragmaBlock.getLineNo(), "FOR/DO loop variable '" + ((OMPvar)object5).id.getName() + "' is declared as shared");
                                return;
                            }
                        }
                    }
                }
                if (oMPpragma == OMPpragma.SECTIONS && oMPinfo != null && oMPinfo.pragma != OMPpragma.PARALLEL) {
                    OMP.error(pragmaBlock.getLineNo(), "'sections' directive is nested");
                }
                topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(pragmaBlock.getBody());
                topdownBlockIterator2.init();
                while (!topdownBlockIterator2.end()) {
                    if (topdownBlockIterator2.getBlock() instanceof FdoBlock && (object2 = pragmaBlock.findVarIdent(((Xobject)(object4 = ((FdoBlock)topdownBlockIterator2.getBlock()).getInductionVar())).getName())) != null) {
                        ((Xobject)object2).setIsInductionVar(true);
                    }
                    topdownBlockIterator2.next();
                }
                break;
            }
            case SIMD: 
            case DECLARE: {
                break;
            }
            case SINGLE: {
                block35: for (XobjArgs xobjArgs = pragmaBlock.getClauses().getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
                    Xobject xobject = xobjArgs.getArg();
                    OMPpragma oMPpragma3 = OMPpragma.valueOf(xobject.getArg(0));
                    switch (oMPpragma3) {
                        case DIR_NOWAIT: {
                            oMPinfo2.no_wait = true;
                            continue block35;
                        }
                        default: {
                            for (XobjArgs xobjArgs2 = xobject.getArg(1).getArgs(); xobjArgs2 != null; xobjArgs2 = xobjArgs2.nextArgs()) {
                                oMPinfo2.declOMPvar(xobjArgs2.getArg().getName(), oMPpragma3);
                            }
                        }
                    }
                }
                if (oMPinfo == null || oMPinfo.pragma == OMPpragma.PARALLEL || oMPinfo.pragma == OMPpragma.PARALLEL_FOR || oMPinfo.pragma == OMPpragma.FOR) break;
                OMP.error(pragmaBlock.getLineNo(), "'single' directive is nested or is not in parallel region");
                break;
            }
            case MASTER: {
                if (oMPinfo2.findContext(OMPpragma.FOR, OMPpragma.PARALLEL) != null) {
                    OMP.error(pragmaBlock.getLineNo(), "'master' not permitted in the extent of 'for'");
                }
                if (oMPinfo2.findContext(OMPpragma.SECTIONS, OMPpragma.PARALLEL) != null) {
                    OMP.error(pragmaBlock.getLineNo(), "'master' not permitted in the extent of 'sections'");
                }
                if (oMPinfo2.findContext(OMPpragma.SINGLE, OMPpragma.PARALLEL) == null) break;
                OMP.error(pragmaBlock.getLineNo(), "'master' not permitted in the extent of 'single'");
                break;
            }
            case CRITICAL: {
                Xobject xobject = pragmaBlock.getClauses();
                oMPinfo2.arg = xobject != null ? xobject.getArgOrNull(0) : null;
                if (oMPinfo2.findContext(OMPpragma.CRITICAL, oMPinfo2.arg) == null) break;
                OMP.error(pragmaBlock.getLineNo(), "'critical' with the same name is nested");
                break;
            }
            case BARRIER: {
                if (oMPinfo == null || oMPinfo.pragma == OMPpragma.PARALLEL) break;
                OMP.error(pragmaBlock.getLineNo(), "'barrier' in bad context");
                break;
            }
            case FLUSH: {
                oMPinfo2.setFlushVars(pragmaBlock.getClauses());
                break;
            }
            case ATOMIC: {
                BasicBlock basicBlock;
                Block block;
                if (pragmaBlock.getBody().isSingle() && ((block = pragmaBlock.getBody().getHead()).Opcode() == Xcode.LIST || block.Opcode() == Xcode.F_STATEMENT_LIST) && (basicBlock = pragmaBlock.getBody().getHead().getBasicBlock()).isSingle()) {
                    Xobject xobject = basicBlock.getHead().getExpr();
                    if (this.isAtomicExpr(xobject)) break;
                    if (xobject.isSet() && (xobject = this.makeAtomicExpr(xobject)) != null) {
                        basicBlock.getHead().setExpr(xobject);
                        break;
                    }
                }
                OMP.error(pragmaBlock.getLineNo(), "bad expression in 'atomic' directive");
                break;
            }
            case ORDERED: {
                if (oMPinfo2.findContext(OMPpragma.CRITICAL) == null) break;
                OMP.error(pragmaBlock.getLineNo(), "'ordered' not permitted in the extent of 'critical'");
                break;
            }
            case THREADPRIVATE: {
                this.omp_env.declThreadPrivate(this.def.getDef().getDef(), pragmaBlock, pragmaBlock.getClauses());
                break;
            }
            default: {
                OMP.fatal("unknown OpenMP pramga = " + (Object)((Object)oMPpragma));
            }
        }
    }

    boolean isAtomicExpr(Xobject xobject) {
        OMP.debug("isAtomicExpr");
        switch (xobject.Opcode()) {
            case POST_INCR_EXPR: 
            case POST_DECR_EXPR: 
            case PRE_INCR_EXPR: 
            case PRE_DECR_EXPR: 
            case ASG_PLUS_EXPR: 
            case ASG_MUL_EXPR: 
            case ASG_MINUS_EXPR: 
            case ASG_DIV_EXPR: 
            case ASG_BIT_AND_EXPR: 
            case ASG_BIT_OR_EXPR: 
            case ASG_BIT_XOR_EXPR: 
            case ASG_LSHIFT_EXPR: 
            case ASG_RSHIFT_EXPR: {
                return true;
            }
        }
        return false;
    }

    private Xobject makeAtomicExpr(Xobject xobject) {
        OMP.debug("makeAtomicExpr");
        return XmOption.isLanguageC() ? this.makeAtomicExprC(xobject) : this.makeAtomicExprF(xobject);
    }

    private Xobject makeAtomicExprC(Xobject xobject) {
        Xobject xobject2 = xobject.left();
        Xobject xobject3 = xobject.right();
        OMP.debug("makeAtomicExprC");
        switch (xobject3.Opcode()) {
            case PLUS_EXPR: {
                if (xobject2.equals(xobject3.left())) {
                    return Xcons.asgOp(Xcode.ASG_PLUS_EXPR, xobject2, xobject3.right());
                }
                if (!xobject2.equals(xobject3.right())) break;
                return Xcons.asgOp(Xcode.ASG_PLUS_EXPR, xobject2, xobject3.left());
            }
            case MUL_EXPR: {
                if (xobject2.equals(xobject3.left())) {
                    return Xcons.asgOp(Xcode.ASG_MUL_EXPR, xobject2, xobject3.right());
                }
                if (!xobject2.equals(xobject3.right())) break;
                return Xcons.asgOp(Xcode.ASG_MUL_EXPR, xobject2, xobject3.left());
            }
            case MINUS_EXPR: {
                if (!xobject2.equals(xobject3.left())) break;
                return Xcons.asgOp(Xcode.ASG_MINUS_EXPR, xobject2, xobject3.right());
            }
            case DIV_EXPR: {
                if (!xobject2.equals(xobject3.left())) break;
                return Xcons.asgOp(Xcode.ASG_DIV_EXPR, xobject2, xobject3.right());
            }
            case BIT_AND_EXPR: 
            case LOG_AND_EXPR: {
                if (xobject2.equals(xobject3.left())) {
                    return Xcons.asgOp(Xcode.ASG_BIT_AND_EXPR, xobject2, xobject3.right());
                }
                if (!xobject2.equals(xobject3.right())) break;
                return Xcons.asgOp(Xcode.ASG_BIT_AND_EXPR, xobject2, xobject3.left());
            }
            case BIT_OR_EXPR: 
            case LOG_OR_EXPR: {
                if (xobject2.equals(xobject3.left())) {
                    return Xcons.asgOp(Xcode.ASG_BIT_OR_EXPR, xobject2, xobject3.right());
                }
                if (!xobject2.equals(xobject3.right())) break;
                return Xcons.asgOp(Xcode.ASG_BIT_OR_EXPR, xobject2, xobject3.left());
            }
            case BIT_XOR_EXPR: {
                if (xobject2.equals(xobject3.left())) {
                    return Xcons.asgOp(Xcode.ASG_BIT_XOR_EXPR, xobject2, xobject3.right());
                }
                if (!xobject2.equals(xobject3.right())) break;
                return Xcons.asgOp(Xcode.ASG_BIT_XOR_EXPR, xobject2, xobject3.left());
            }
        }
        return null;
    }

    private Xobject makeAtomicExprF(Xobject xobject) {
        OMP.debug("makeAtomicExprF");
        if (xobject.Opcode() != Xcode.F_ASSIGN_STATEMENT) {
            return null;
        }
        Xobject xobject2 = xobject.left();
        Xobject xobject3 = xobject.right();
        switch (xobject3.Opcode()) {
            case PLUS_EXPR: 
            case MUL_EXPR: 
            case MINUS_EXPR: 
            case DIV_EXPR: 
            case LOG_AND_EXPR: 
            case LOG_OR_EXPR: 
            case F_POWER_EXPR: 
            case LOG_EQ_EXPR: 
            case LOG_NEQ_EXPR: 
            case F_LOG_EQV_EXPR: 
            case F_LOG_NEQV_EXPR: 
            case LOG_GE_EXPR: 
            case LOG_GT_EXPR: 
            case LOG_LE_EXPR: 
            case LOG_LT_EXPR: 
            case F_USER_BINARY_EXPR: {
                if (!xobject2.equals(xobject3.left()) && !xobject2.equals(xobject3.right())) break;
                return Xcons.List(xobject3.Opcode(), xobject2, xobject3.left(), xobject3.right());
            }
            case FUNCTION_CALL: {
                String string;
                Xobject xobject4 = xobject3.getArgOrNull(1);
                if (xobject4 == null || xobject4.Nargs() != 2 || !(string = xobject3.getArg(0).getName()).equals("min") && !string.equals("max") && !string.equals("iand") && !string.equals("ior") && !string.equals("ieor") || !xobject2.equals(xobject4.left()) && !xobject2.equals(xobject4.right())) break;
                return Xcons.List(xobject3.Opcode(), xobject2, xobject4.left(), xobject4.right(), xobject3.getArg(0));
            }
        }
        return null;
    }
}

