/*
 * Decompiled with CFR 0.152.
 */
package exc.openmp;

import exc.block.Block;
import exc.object.IVarContainer;
import exc.object.Ident;
import exc.object.PropObject;
import exc.object.Xcode;
import exc.object.XobjArgs;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectFile;
import exc.object.Xtype;
import exc.object.topdownXobjectIterator;
import exc.openmp.OMP;
import exc.openmp.OMPfileEnv;
import exc.openmp.OMPpragma;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import xcodeml.util.XmOption;

public class OMPanalyzeDecl
implements OMPfileEnv {
    private XobjectFile env;
    private Vector<Ident> thdprv_vars = new Vector();
    private static final String PROP_KEY = "OMPanalyzeDecl";
    private OMPanalyzeDecl parent;
    private List<String> list = new LinkedList<String>();

    public OMPanalyzeDecl(XobjectFile xobjectFile) {
        this.env = xobjectFile;
    }

    @Override
    public XobjectFile getFile() {
        return this.env;
    }

    private void setToXobject(PropObject propObject) {
        propObject.setProp(PROP_KEY, this);
    }

    private OMPanalyzeDecl getParent(XobjectDef xobjectDef) {
        if (this.parent != null) {
            return this.parent;
        }
        PropObject propObject = xobjectDef.getParent();
        if (propObject == null) {
            propObject = xobjectDef.getParentEnv();
        }
        if (propObject == null) {
            throw new IllegalStateException();
        }
        OMPanalyzeDecl oMPanalyzeDecl = (OMPanalyzeDecl)propObject.getProp(PROP_KEY);
        if (oMPanalyzeDecl == null) {
            oMPanalyzeDecl = new OMPanalyzeDecl(xobjectDef.getFile());
            propObject.setProp(PROP_KEY, oMPanalyzeDecl);
        }
        this.parent = oMPanalyzeDecl;
        return oMPanalyzeDecl;
    }

    public void analyze(XobjectDef xobjectDef) {
        Xobject xobject = xobjectDef.getDef();
        if (xobject.Opcode() == Xcode.OMP_PRAGMA) {
            if (OMPpragma.valueOf(xobject.getArg(1)) != OMPpragma.THREADPRIVATE) {
                OMP.fatal("not threadprivate in decl");
            }
            this.getParent(xobjectDef).declThreadPrivate(xobject, xobjectDef, xobject.getArg(2));
            xobjectDef.setDef(null);
        } else if (xobjectDef.isFuncDef() || xobjectDef.isFmoduleDef()) {
            this.setToXobject(xobjectDef);
            this.getParent(xobjectDef);
            topdownXobjectIterator topdownXobjectIterator2 = xobjectDef.getDef().topdownIterator();
            topdownXobjectIterator2.init();
            while (!topdownXobjectIterator2.end()) {
                xobject = topdownXobjectIterator2.getXobject();
                if (xobject != null && xobject.Opcode() != null) {
                    switch (xobject.Opcode()) {
                        case OMP_PRAGMA: {
                            if (OMPpragma.valueOf(xobject.getArg(0)) != OMPpragma.THREADPRIVATE) break;
                            if (xobjectDef.isFmoduleDef()) {
                                OMP.error(xobjectDef.getLineNo(), "threadprivate for module variable is not supported");
                            } else {
                                this.declThreadPrivate(xobject, xobjectDef, xobject.getArg(1));
                            }
                            topdownXobjectIterator2.setXobject(null);
                        }
                    }
                }
                topdownXobjectIterator2.next();
            }
        }
    }

    @Override
    public void declThreadPrivate(Xobject xobject, IVarContainer iVarContainer, Xobject xobject2) {
        Xtype xtype = Xtype.Pointer(Xtype.voidType);
        block9: for (XobjArgs xobjArgs = xobject2.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            Ident ident;
            String string = xobjArgs.getArg().getName();
            Ident ident2 = iVarContainer != null ? (iVarContainer.findCommonIdent(string) == null ? iVarContainer.findVarIdent(string) : iVarContainer.findCommonIdent(string)) : (ident = xobject.findCommonIdent(string) == null ? xobject.findVarIdent(string) : xobject.findCommonIdent(string));
            if (ident == null) {
                OMP.fatal("undefined variable '" + string + "' in threadprivate directive");
                continue;
            }
            if (this.isThreadPrivate(ident)) continue;
            this.thdprv_vars.addElement(ident);
            OMP.setThreadPrivate(ident);
            if (OMP.leaveThreadPrivateFlag) continue;
            switch (ident.getStorageClass()) {
                case FCOMMON_NAME: {
                    this.list.add(ident.getName());
                }
                case EXTDEF: 
                case EXTERN: 
                case STATIC: 
                case FCOMMON: 
                case FSAVE: {
                    break;
                }
                default: {
                    if (XmOption.isLanguageC()) {
                        OMP.error(xobject.getLineNo(), "variable '" + ident.getName() + "' is not extern or static variable.");
                    } else {
                        OMP.error(xobject.getLineNo(), "variable '" + ident.getName() + "' does not have common or save attribute.");
                    }
                    return;
                }
            }
            if (!XmOption.isLanguageC()) continue;
            String string2 = "ts_" + ident.getName();
            switch (ident.getStorageClass()) {
                case EXTDEF: {
                    this.env.declGlobalIdent(string2, xtype);
                    continue block9;
                }
                case EXTERN: {
                    this.env.declExternIdent(string2, xtype);
                    continue block9;
                }
                case STATIC: {
                    this.env.declStaticIdent(string2, xtype);
                    continue block9;
                }
                default: {
                    OMP.fatal("declThreadPrivate: bad class, " + ident.getName());
                }
            }
        }
    }

    public void addThdprvVars(Ident ident) {
        this.thdprv_vars.addElement(ident);
    }

    @Override
    public boolean isThreadPrivate(Ident ident) {
        if (this.thdprv_vars.contains(ident) || OMP.isThreadPrivate(ident)) {
            return true;
        }
        return this.parent != null ? this.parent.isThreadPrivate(ident) : false;
    }

    @Override
    public Ident findThreadPrivate(Block block, String string) {
        for (Ident ident : this.thdprv_vars) {
            if (!ident.getName().equals(string)) continue;
            return ident;
        }
        return this.parent != null ? this.parent.findThreadPrivate(block, string) : null;
    }

    public List getCommonName() {
        return this.list;
    }
}

