/*
 * Decompiled with CFR 0.152.
 */
package exc.openmp;

import exc.block.BasicBlock;
import exc.block.BasicBlockVisitor;
import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockList;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.openmp.OMPforallBlock;
import exc.openmp.OMPparallelBlock;
import exc.openmp.OMPpragma;
import java.util.List;

public class OMPBlock
extends Block {
    BasicBlock end_bb;
    BlockList body;
    int narg;
    Xobject info;

    public OMPBlock(Xcode xcode) {
        super(xcode, new BasicBlock());
        this.end_bb = new BasicBlock();
        this.end_bb.setParent(this);
    }

    public OMPBlock(Xcode xcode, BasicBlock basicBlock) {
        super(xcode, basicBlock);
        this.end_bb = new BasicBlock();
        this.end_bb.setParent(this);
    }

    public OMPBlock(Xcode xcode, BasicBlock basicBlock, BasicBlock basicBlock2) {
        super(xcode, basicBlock);
        this.end_bb = basicBlock2;
        this.end_bb.setParent(this);
    }

    public BasicBlock beginBasicBlock() {
        return this.getBasicBlock();
    }

    public boolean isBeginBasicBlock(BasicBlock basicBlock) {
        return basicBlock == this.getBasicBlock();
    }

    public BasicBlock endBasicBlock() {
        return this.end_bb;
    }

    public boolean isEndBasicBlock(BasicBlock basicBlock) {
        return this.end_bb == basicBlock;
    }

    @Override
    public BlockList getBody() {
        return this.body;
    }

    @Override
    public void setBody(BlockList blockList) {
        this.body = blockList;
        blockList.setParent(this);
    }

    @Override
    public Xobject getInfoExpr() {
        return this.info;
    }

    public int getNarg() {
        return this.narg;
    }

    public void setNarg(int n) {
        this.narg = n;
    }

    @Override
    public void visitBasicBlock(BasicBlockVisitor basicBlockVisitor) {
        basicBlockVisitor.visit(this.beginBasicBlock());
        basicBlockVisitor.visit(this.endBasicBlock());
    }

    public static OMPBlock Barrier() {
        return new OMPBlock(Xcode.OMP_BARRIER);
    }

    public static OMPBlock Flush(List<Xobject> list) {
        OMPBlock oMPBlock = new OMPBlock(Xcode.OMP_FLUSH);
        if (list != null) {
            XobjList xobjList = Xcons.List();
            for (Xobject xobject : list) {
                ((Xobject)xobjList).add(xobject);
            }
            oMPBlock.info = xobjList;
        }
        return oMPBlock;
    }

    public static OMPBlock Master(BlockList blockList) {
        OMPBlock oMPBlock = new OMPBlock(Xcode.OMP_MASTER);
        oMPBlock.setBody(blockList);
        return oMPBlock;
    }

    public static OMPBlock Ordered(BlockList blockList) {
        OMPBlock oMPBlock = new OMPBlock(Xcode.OMP_ORDERED);
        oMPBlock.setBody(blockList);
        return oMPBlock;
    }

    public static OMPBlock Single(BlockList blockList) {
        OMPBlock oMPBlock = new OMPBlock(Xcode.OMP_SINGLE);
        oMPBlock.setBody(blockList);
        return oMPBlock;
    }

    public static OMPBlock Sections(int n, BlockList blockList) {
        OMPBlock oMPBlock = new OMPBlock(Xcode.OMP_SECTIONS);
        oMPBlock.setBody(blockList);
        oMPBlock.narg = n;
        return oMPBlock;
    }

    public static OMPBlock Critical(Xobject xobject, BlockList blockList) {
        OMPBlock oMPBlock = new OMPBlock(Xcode.OMP_CRITICAL);
        oMPBlock.setBody(blockList);
        oMPBlock.info = xobject;
        return oMPBlock;
    }

    public static OMPBlock Atomic(Xobject xobject) {
        OMPBlock oMPBlock = new OMPBlock(Xcode.OMP_ATOMIC);
        BlockList blockList = Bcons.emptyBody();
        blockList.add(Bcons.Statement(xobject));
        oMPBlock.setBody(blockList);
        return oMPBlock;
    }

    public static OMPparallelBlock ParallelRegion(int n, BasicBlock basicBlock, BlockList blockList, Xobject xobject) {
        return new OMPparallelBlock(n, basicBlock, blockList, xobject);
    }

    public static OMPforallBlock Forall(Xobject xobject, Xobject xobject2, Xobject xobject3, Xobject xobject4, Xcode xcode, BlockList blockList, OMPpragma oMPpragma, Xobject xobject5, boolean bl) {
        return new OMPforallBlock(xobject, xobject2, xobject3, xobject4, xcode, blockList, oMPpragma, xobject5, bl);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("(OMPBlock ");
        stringBuilder.append((Object)this.Opcode());
        stringBuilder.append(" ");
        stringBuilder.append(this.body);
        stringBuilder.append(" ");
        stringBuilder.append(this.getBasicBlock());
        stringBuilder.append(" ");
        stringBuilder.append(this.end_bb);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

