/*
 * Decompiled with CFR 0.152.
 */
package exc.openmp;

import exc.block.Block;
import exc.block.BlockList;
import exc.block.LabelBlock;
import exc.block.Statement;
import exc.block.StatementIterator;
import exc.block.topdownBlockIterator;
import exc.object.Ident;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.object.topdownXobjectIterator;
import exc.openmp.OMPinfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class FidentCollector {
    private BlockList orgBody;
    private Map<String, Ident> nameMap;

    FidentCollector(BlockList blockList, Map<String, Ident> map) {
        this.orgBody = blockList;
        this.nameMap = map;
    }

    private void collectIdent(BlockList blockList) {
        if (blockList == null) {
            return;
        }
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(blockList);
        topdownBlockIterator2.init();
        while (!topdownBlockIterator2.end()) {
            Block block = topdownBlockIterator2.getBlock();
            if (block != null && block.getBasicBlock() != null) {
                StatementIterator statementIterator = block.getBasicBlock().statements();
                while (statementIterator.hasNext()) {
                    Statement statement = (Statement)statementIterator.next();
                    if (statement == null) continue;
                    this.collectIdent(statement.getExpr());
                }
            }
            topdownBlockIterator2.next();
        }
    }

    void collectIdentInIdent(Ident ident) {
        if (ident == null) {
            return;
        }
        this.collectIdentInType(ident.Type());
        this.collectIdent(ident.getFparamValue());
    }

    void collectIdentName(Xobject xobject, OMPinfo oMPinfo) {
        if (xobject == null) {
            return;
        }
        String string = null;
        if (xobject instanceof Ident) {
            string = xobject.getName();
        } else {
            switch (xobject.Opcode()) {
                case IDENT: 
                case VAR: 
                case VAR_ADDR: {
                    string = xobject.getName();
                }
            }
        }
        if (string != null) {
            Object object = this.orgBody.findLocalIdent(string);
            if (object == null && (object = oMPinfo.getIdList().findVarIdent(string)) == null && string.startsWith("p_")) {
                object = this.orgBody.findLocalIdent(string.substring("p_".length(), string.length()));
            }
            if (object != null) {
                Xobject xobject2;
                this.nameMap.put(string, (Ident)object);
                this.collectIdentInIdent((Ident)object);
                if (((Xobject)object).Type().isStruct() && (xobject2 = this.orgBody.findLocalIdent(((Xobject)object).Type())) != null) {
                    this.nameMap.put(((Ident)xobject2).getName(), (Ident)xobject2);
                }
            }
        }
        if (xobject instanceof XobjList) {
            for (Xobject xobject2 : (XobjList)xobject) {
                this.collectIdentName(xobject2, oMPinfo);
            }
        }
    }

    private void collectIdentInVarList(Xobject xobject) {
        for (Xobject xobject2 : (XobjList)xobject) {
            String string;
            Ident ident;
            this.collectIdent(xobject2.getArg(1));
            Xobject xobject3 = xobject2.getArgOrNull(0);
            if (xobject3 == null || (ident = this.orgBody.findLocalIdent(string = xobject3.getName())) == null || this.nameMap.containsKey(string)) continue;
            this.nameMap.put(string, ident);
            this.collectIdentInIdent(ident);
        }
    }

    private void collectIdentInType(Xtype xtype) {
        if (xtype == null) {
            return;
        }
        this.collectIdent(xtype.getFkind());
        this.collectIdent(xtype.getFlen());
        if (xtype.isFarray()) {
            for (Xobject xobject : xtype.getFarraySizeExpr()) {
                this.collectIdent(xobject);
            }
        }
    }

    private void collectIdent(Xobject xobject) {
        if (xobject == null) {
            return;
        }
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject);
        topdownXobjectIterator2.init();
        while (!topdownXobjectIterator2.end()) {
            Ident ident;
            String string;
            Ident ident2;
            Xobject xobject2 = topdownXobjectIterator2.getXobject();
            if (xobject2 != null && xobject2.isVarRef() && (ident2 = this.orgBody.findLocalIdent(string = xobject2.getName())) != null && !ident2.isFmoduleVar() && (ident = this.nameMap.get(string)) == null) {
                if (ident2.isDeclared()) {
                    ident2 = (Ident)ident2.copy();
                    ident2.setIsDeclared(false);
                }
                this.nameMap.put(string, ident2);
                this.collectIdentInIdent(ident2);
            }
            topdownXobjectIterator2.next();
        }
    }

    void copyDecls(XobjList xobjList, Xobject xobject, BlockList blockList, OMPinfo oMPinfo, boolean bl) {
        Iterator iterator;
        Ident[] identArray22;
        Cloneable cloneable;
        Object object;
        if (bl || !this.nameMap.isEmpty()) {
            object = this.nameMap;
            cloneable = new HashMap<String, Ident>();
            this.nameMap = cloneable;
            for (Ident[] identArray22 : xobjList) {
                this.collectIdentInType(identArray22.Type());
            }
            this.collectIdent(this.orgBody);
            this.nameMap = object;
            iterator = this.orgBody.getDecls();
            block8: for (Object object2 : (XobjList)((Object)iterator)) {
                if (object2 == null) continue;
                String string = null;
                switch (((Xobject)object2).Opcode()) {
                    case F_USE_DECL: 
                    case F_USE_ONLY_DECL: {
                        xobject.add((Xobject)object2);
                        break;
                    }
                    case F_COMMON_DECL: 
                    case F_NAMELIST_DECL: {
                        if (!this.isInVarList((Xobject)object2, this.nameMap) && !this.isInVarList((Xobject)object2, (Map<String, Ident>)((Object)cloneable))) break;
                        this.collectIdentInVarList((Xobject)object2);
                        xobject.add((Xobject)object2);
                        break;
                    }
                    case VAR_DECL: {
                        if (bl || !this.nameMap.containsKey(string = ((Xobject)object2).getArg(0).getName())) break;
                        xobject.add((Xobject)object2);
                        break;
                    }
                    case F_STRUCT_DECL: {
                        xobject.add((Xobject)object2);
                        Ident ident = this.orgBody.findLocalIdent(((Xobject)object2).getArg(0).getName());
                        if (ident == null || this.nameMap.containsKey(ident.getName())) break;
                        this.nameMap.put(ident.getName(), ident);
                        break;
                    }
                    case F_INTERFACE_DECL: {
                        Ident ident;
                        if (bl) break;
                        String string2 = string = ((Xobject)object2).getArg(0) != null ? ((Xobject)object2).getArg(0).getName() : null;
                        if (this.nameMap.containsKey(string)) {
                            xobject.add((Xobject)object2);
                            break;
                        }
                        if (((Xobject)object2).getArgOrNull(3) == null) break;
                        ArrayList<Xobject> object3 = new ArrayList<Xobject>();
                        boolean bl2 = false;
                        for (Xobject xobject2 : (XobjList)((Xobject)object2).getArg(3)) {
                            if (xobject2 == null || xobject2.Opcode() != Xcode.FUNCTION_DECL) continue;
                            object3.add(xobject2.getArg(0));
                            string = xobject2.getArg(0).getName();
                            if (!this.nameMap.containsKey(string)) continue;
                            bl2 = true;
                        }
                        if (!bl2) break;
                        xobject.add((Xobject)object2);
                        for (Xobject xobject2 : object3) {
                            ident = this.orgBody.findLocalIdent(xobject2.getName());
                            if (ident == null || this.nameMap.containsKey(ident.getName())) continue;
                            this.nameMap.put(ident.getName(), ident);
                        }
                        continue block8;
                    }
                }
            }
            identArray22 = this.nameMap.values().toArray(new Ident[this.nameMap.size()]);
            for (Ident ident : identArray22) {
                this.collectIdentInIdent(ident);
            }
            for (Ident ident : this.nameMap.values()) {
                if (xobjList.has(ident)) continue;
                xobjList.add(ident);
            }
        }
        if (!bl && blockList != null) {
            object = new ArrayList();
            cloneable = new HashSet();
            this.collectFormatNumsInIOStatement(blockList, (Set<Integer>)((Object)cloneable));
            this.removeFormatNumsInLine(blockList, (Set<Integer>)((Object)cloneable));
            this.collectFormatDecls((List<Xobject>)object, (Set<Integer>)((Object)cloneable));
            iterator = object.iterator();
            while (iterator.hasNext()) {
                identArray22 = (Xobject)iterator.next();
                blockList.add((Xobject)identArray22);
            }
        }
    }

    private void collectFormatNumsInIOStatement(BlockList blockList, Set<Integer> set) {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(blockList);
        topdownBlockIterator2.init();
        while (!topdownBlockIterator2.end()) {
            Block block = topdownBlockIterator2.getBlock();
            if (block != null && block.getBasicBlock() != null) {
                StatementIterator statementIterator = block.getBasicBlock().statements();
                block4: while (statementIterator.hasNext()) {
                    Statement statement = (Statement)statementIterator.next();
                    if (statement == null || statement.getExpr() == null) continue;
                    switch (statement.getExpr().Opcode()) {
                        default: {
                            continue block4;
                        }
                        case F_READ_STATEMENT: 
                        case F_WRITE_STATEMENT: 
                    }
                    Xobject xobject = statement.getExpr().getArgOrNull(0);
                    if (xobject == null) continue;
                    for (Xobject xobject2 : (XobjList)xobject) {
                        Xobject xobject3;
                        Xobject xobject4 = xobject2.getArg(0);
                        if (!xobject4.getName().equals("fmt") || (xobject3 = xobject2.getArg(1)) == null || xobject3.Opcode() != Xcode.INT_CONSTANT) continue;
                        set.add(xobject3.getInt());
                    }
                }
            }
            topdownBlockIterator2.next();
        }
    }

    private void removeFormatNumsInLine(BlockList blockList, Set<Integer> set) {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(blockList);
        Xobject xobject = null;
        topdownBlockIterator2.init();
        while (!topdownBlockIterator2.end()) {
            Block block = topdownBlockIterator2.getBlock();
            if (block != null) {
                if (block instanceof LabelBlock && block.getLabel() != null) {
                    xobject = block.getLabel();
                } else if (block.getBasicBlock() != null) {
                    StatementIterator statementIterator = block.getBasicBlock().statements();
                    while (statementIterator.hasNext()) {
                        int n;
                        Statement statement = (Statement)statementIterator.next();
                        if (statement == null || statement.getExpr() == null || xobject == null || statement.getExpr().Opcode() != Xcode.F_FORMAT_DECL || !set.contains(n = Integer.parseInt(xobject.getName()))) continue;
                        set.remove(n);
                        xobject = null;
                    }
                }
            }
            topdownBlockIterator2.next();
        }
    }

    private void collectFormatDecls(List<Xobject> list, Set<Integer> set) {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(this.orgBody);
        Xobject xobject = null;
        topdownBlockIterator2.init();
        while (!topdownBlockIterator2.end()) {
            Block block = topdownBlockIterator2.getBlock();
            if (block != null) {
                if (block instanceof LabelBlock && block.getLabel() != null) {
                    xobject = block.getLabel();
                } else if (block.getBasicBlock() != null) {
                    StatementIterator statementIterator = block.getBasicBlock().statements();
                    while (statementIterator.hasNext()) {
                        int n;
                        Statement statement = (Statement)statementIterator.next();
                        if (statement == null || statement.getExpr() == null || xobject == null || statement.getExpr().Opcode() != Xcode.F_FORMAT_DECL || !set.contains(n = Integer.parseInt(xobject.getName()))) continue;
                        list.add(Xcons.List(Xcode.STATEMENT_LABEL, xobject));
                        list.add(statement.getExpr());
                        xobject = null;
                    }
                }
            }
            topdownBlockIterator2.next();
        }
    }

    private boolean isInVarList(Xobject xobject, Map<String, Ident> map) {
        for (Xobject xobject2 : (XobjList)xobject) {
            XobjList xobjList = (XobjList)xobject2.getArgOrNull(1);
            if (xobjList == null) continue;
            for (Xobject xobject3 : xobjList) {
                String string;
                if (xobject3.Opcode() != Xcode.F_VAR_REF || !map.containsKey(string = xobject3.getArg(0).getName())) continue;
                return true;
            }
        }
        return false;
    }
}

