/*
 * Decompiled with CFR 0.152.
 */
package exc.openacc;

import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockList;
import exc.block.PragmaBlock;
import exc.object.Ident;
import exc.object.StorageClass;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.openacc.ACCexception;
import exc.openacc.ACCglobalDecl;
import exc.openacc.ACCpragma;
import exc.openacc.ACCutil;
import exc.openacc.ACCvar;
import exc.openacc.AccData;
import exc.openacc.AccInformation;
import java.util.ArrayList;
import java.util.List;

class AccUpdate
extends AccData {
    private final List<Block> copyBlockList = new ArrayList<Block>();

    AccUpdate(ACCglobalDecl aCCglobalDecl, AccInformation accInformation, PragmaBlock pragmaBlock) {
        super(aCCglobalDecl, accInformation, pragmaBlock);
    }

    @Override
    boolean isAcceptableClause(ACCpragma aCCpragma) {
        switch (aCCpragma) {
            case IF: 
            case ASYNC: 
            case HOST: 
            case DEVICE: {
                return true;
            }
        }
        return false;
    }

    int getCopyDirection(ACCvar aCCvar) throws ACCexception {
        if (aCCvar.copiesDtoH()) {
            return 401;
        }
        if (aCCvar.copiesHtoD()) {
            return 400;
        }
        throw new ACCexception(aCCvar + " does not have update direction");
    }

    @Override
    void generate() throws ACCexception {
        if (this.isDisabled()) {
            return;
        }
        for (ACCvar aCCvar : this._info.getACCvarList()) {
            Block block;
            Object object;
            Ident ident = aCCvar.getHostDesc();
            if (ident == null) {
                throw new ACCexception(aCCvar + " is not allocated in device memory");
            }
            Xobject xobject = this.getAsyncExpr();
            int n = this.getCopyDirection(aCCvar);
            XobjList xobjList = Xcons.List(ident.Ref(), Xcons.IntConstant(n), xobject);
            if (aCCvar.isSubarray()) {
                object = aCCvar.getSubscripts();
                XobjList xobjList2 = Xcons.List();
                XobjList xobjList3 = Xcons.List();
                Object object2 = ((XobjList)object).iterator();
                while (object2.hasNext()) {
                    Xobject xobject2 = object2.next();
                    XobjList xobjList4 = (XobjList)xobject2;
                    xobjList2.add(xobjList4.left());
                    xobjList3.add(xobjList4.right());
                }
                object2 = "_ACC_copy_subdata";
                block = ACCutil.createFuncCallBlockWithArrayRange((String)object2, xobjList, Xcons.List(xobjList2, xobjList3));
            } else {
                object = "_ACC_copy_data";
                block = ACCutil.createFuncCallBlock((String)object, xobjList);
            }
            this.copyBlockList.add(block);
        }
    }

    @Override
    void rewrite() throws ACCexception {
        boolean bl;
        BlockList blockList = Bcons.emptyBody();
        for (Block propObject2 : this.copyBlockList) {
            blockList.add(propObject2);
        }
        BlockList blockList2 = Bcons.emptyBody();
        Xobject xobject = this._info.getIntExpr(ACCpragma.IF);
        boolean bl2 = bl = xobject == null || xobject.isIntConstant();
        if (bl) {
            blockList2.add(Bcons.COMPOUND(blockList));
        } else {
            Ident ident = blockList2.declLocalIdent("_ACC_DATA_IF_COND", Xtype.charType, StorageClass.AUTO, xobject);
            blockList2.add(Bcons.IF(ident.Ref(), Bcons.COMPOUND(blockList), null));
        }
        this._pb.replace(Bcons.COMPOUND(blockList2));
    }
}

