/*
 * Decompiled with CFR 0.152.
 */
package exc.openacc;

import exc.block.FuncDefBlock;
import exc.block.FunctionBlock;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectDefVisitor;
import exc.object.XobjectFile;
import exc.openacc.ACC;
import exc.openacc.ACCglobalDecl;
import exc.openacc.ACCgpuDecompiler;
import exc.openacc.AccAnalyzer;
import exc.openacc.AccGenerator;
import exc.openacc.AccInfoReader;
import exc.openacc.AccInfoWriter;
import exc.openacc.AccRewriter;
import xcodeml.util.XmOption;

public class AccTranslator
implements XobjectDefVisitor {
    private final ACCglobalDecl _globalDecl;
    private final AccInfoReader _infoReader;
    private final AccInfoWriter _infoWriter;
    private final AccAnalyzer _analyzer;
    private final AccGenerator _generator;
    private final AccRewriter _rewrite;
    private final boolean _onlyAnalyze;

    public AccTranslator(XobjectFile xobjectFile, boolean bl) {
        if (!XmOption.isLanguageC()) {
            ACC.fatal("current version only supports C language.");
        }
        this._globalDecl = new ACCglobalDecl(xobjectFile);
        this._infoReader = new AccInfoReader(this._globalDecl);
        this._infoWriter = new AccInfoWriter(this._globalDecl);
        this._analyzer = new AccAnalyzer(this._globalDecl);
        this._generator = new AccGenerator(this._globalDecl);
        this._rewrite = new AccRewriter(this._globalDecl);
        this._onlyAnalyze = bl;
    }

    @Override
    public void doDef(XobjectDef xobjectDef) {
        if (xobjectDef.isFuncDef()) {
            FuncDefBlock funcDefBlock = new FuncDefBlock(xobjectDef);
            FunctionBlock functionBlock = funcDefBlock.getBlock();
            this.doFuncDef(functionBlock);
            funcDefBlock.finalizeBlock();
        } else {
            Xobject xobject = xobjectDef.getDef();
            this.doNonFuncDef(xobject);
        }
    }

    private void doFuncDef(FunctionBlock functionBlock) {
        this._infoReader.doFuncDef(functionBlock);
        ACC.exitByError();
        this._analyzer.doFuncDef(functionBlock);
        ACC.exitByError();
        if (this._onlyAnalyze) {
            this._infoWriter.doFuncDef(functionBlock);
            ACC.exitByError();
            return;
        }
        this._generator.doFuncDef(functionBlock);
        ACC.exitByError();
        this._rewrite.doFuncDef(functionBlock);
        ACC.exitByError();
    }

    private void doNonFuncDef(Xobject xobject) {
        this._infoReader.doNonFuncDef(xobject);
        ACC.exitByError();
        this._analyzer.doNonFuncDef(xobject);
        ACC.exitByError();
        if (this._onlyAnalyze) {
            this._infoWriter.doNonFuncDef(xobject);
            ACC.exitByError();
            return;
        }
        this._generator.doNonFuncDef(xobject);
        ACC.exitByError();
        this._rewrite.doNonFuncDef(xobject);
        ACC.exitByError();
    }

    public void finish() {
        if (!this._onlyAnalyze) {
            ACCgpuDecompiler aCCgpuDecompiler = new ACCgpuDecompiler();
            aCCgpuDecompiler.decompile(this._globalDecl);
            this._globalDecl.setupKernelsInitAndFinalize();
            this._globalDecl.setupGlobalConstructor();
            this._globalDecl.setupGlobalDestructor();
            this._globalDecl.setupMain();
            this._globalDecl.setupHeaderInclude();
        }
        this._globalDecl.finish();
    }
}

