/*
 * Decompiled with CFR 0.152.
 */
package exc.openacc;

import exc.block.Block;
import exc.block.BlockIterator;
import exc.block.FunctionBlock;
import exc.block.PragmaBlock;
import exc.block.bottomupBlockIterator;
import exc.block.topdownBlockIterator;
import exc.object.Xobject;
import exc.openacc.ACC;
import exc.openacc.ACCexception;
import exc.openacc.ACCglobalDecl;

abstract class AccProcessor {
    final ACCglobalDecl _globalDecl;
    private final boolean _isTopdown;
    private final boolean _warnUnknownPragma;

    AccProcessor(ACCglobalDecl aCCglobalDecl, boolean bl, boolean bl2) {
        this._globalDecl = aCCglobalDecl;
        this._isTopdown = bl;
        this._warnUnknownPragma = bl2;
    }

    void doNonFuncDef(Xobject xobject) {
        switch (xobject.Opcode()) {
            case ACC_PRAGMA: {
                try {
                    this.doGlobalAccPragma(xobject);
                }
                catch (ACCexception aCCexception) {
                    ACC.error(xobject.getLineNo(), aCCexception.getMessage());
                }
                break;
            }
            case PRAGMA_LINE: {
                if (!this._warnUnknownPragma) break;
                ACC.warning(xobject.getLineNo(), "unknown pragma : " + xobject);
                break;
            }
        }
    }

    void doFuncDef(FunctionBlock functionBlock) {
        BlockIterator blockIterator = this._isTopdown ? new topdownBlockIterator(functionBlock) : new bottomupBlockIterator(functionBlock);
        blockIterator.init();
        while (!blockIterator.end()) {
            Block block = blockIterator.getBlock();
            switch (block.Opcode()) {
                case ACC_PRAGMA: {
                    try {
                        this.doLocalAccPragma((PragmaBlock)block);
                    }
                    catch (ACCexception aCCexception) {
                        ACC.error(block.getLineNo(), aCCexception.getMessage());
                    }
                    break;
                }
                case PRAGMA_LINE: {
                    if (!this._warnUnknownPragma) break;
                    ACC.warning(block.getLineNo(), "unknown pragma : " + block);
                    break;
                }
            }
            blockIterator.next();
        }
    }

    abstract void doGlobalAccPragma(Xobject var1) throws ACCexception;

    abstract void doLocalAccPragma(PragmaBlock var1) throws ACCexception;
}

