/*
 * Decompiled with CFR 0.152.
 */
package exc.openacc;

import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockIterator;
import exc.block.BlockList;
import exc.block.PragmaBlock;
import exc.block.topdownBlockIterator;
import exc.object.Ident;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.openacc.ACC;
import exc.openacc.ACCexception;
import exc.openacc.ACCglobalDecl;
import exc.openacc.ACCpragma;
import exc.openacc.ACCvar;
import exc.openacc.AccData;
import exc.openacc.AccDirective;
import exc.openacc.AccInformation;
import exc.openacc.AccKernel;
import java.util.ArrayList;
import java.util.Set;

class AccParallel
extends AccData {
    private Block _parallelBlock;
    private final AccKernel _accKernel;

    AccParallel(ACCglobalDecl aCCglobalDecl, AccInformation accInformation, PragmaBlock pragmaBlock) {
        super(aCCglobalDecl, accInformation, pragmaBlock);
        ArrayList<Block> arrayList = new ArrayList<Block>();
        arrayList.add(this._pb);
        this._accKernel = new AccKernel(this._decl, this._pb, this._info, arrayList);
    }

    @Override
    void analyze() throws ACCexception {
        if (this.isDisabled()) {
            return;
        }
        this.completeParallelism();
        this._accKernel.analyze();
        Set<Ident> set = this._accKernel.getReadOnlyOuterIdSet();
        for (Ident ident : this._accKernel.getOuterIdList()) {
            String string = ident.getName();
            if (this._info.isDeclared(string)) continue;
            ACCvar aCCvar = this.findParentVar(ident);
            ACCvar aCCvar2 = this._info.findACCvar(string);
            boolean bl = this.isReductionVariableInKernel(ident);
            if (!(ident.Type().isPointer() || ACC.version < 20 && !set.contains(ident) || aCCvar != null || aCCvar2 != null && aCCvar2.isReduction() || bl)) {
                this._info.addVar(ACCpragma.FIRSTPRIVATE, Xcons.Symbol(Xcode.VAR, string));
                continue;
            }
            this._info.addVar(ACCpragma.PRESENT_OR_COPY, Xcons.Symbol(Xcode.VAR, string));
        }
        super.analyze();
    }

    private boolean isReductionVariableInKernel(Ident ident) {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(this._pb.getBody());
        ((BlockIterator)topdownBlockIterator2).init();
        while (!((BlockIterator)topdownBlockIterator2).end()) {
            AccDirective accDirective;
            AccInformation accInformation;
            ACCvar aCCvar;
            Block block = topdownBlockIterator2.getBlock();
            if (block.Opcode() == Xcode.ACC_PRAGMA && (aCCvar = (accInformation = (accDirective = (AccDirective)block.getProp("_ACC_DIRECTIVE")).getInfo()).findReductionACCvar(ident.getName())) != null && aCCvar.getId() == ident) {
                return true;
            }
            ((BlockIterator)topdownBlockIterator2).next();
        }
        return false;
    }

    void completeParallelism() throws ACCexception {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(this._pb.getBody());
        ((BlockIterator)topdownBlockIterator2).init();
        while (!((BlockIterator)topdownBlockIterator2).end()) {
            Block block = topdownBlockIterator2.getBlock();
            if (block.Opcode() == Xcode.ACC_PRAGMA) {
                AccDirective accDirective = (AccDirective)block.getProp("_ACC_DIRECTIVE");
                accDirective.analyze();
            }
            ((BlockIterator)topdownBlockIterator2).next();
        }
    }

    @Override
    void generate() throws ACCexception {
        if (this.isDisabled()) {
            return;
        }
        super.generate();
        this._parallelBlock = this._accKernel.makeLaunchFuncCallBlock();
    }

    @Override
    void rewrite() throws ACCexception {
        boolean bl;
        Block block2;
        Object object2;
        if (this.isDisabled()) {
            this._pb.replace(Bcons.COMPOUND(this._pb.getBody()));
            return;
        }
        BlockList blockList = Bcons.emptyBody();
        for (Object object2 : this.initBlockList) {
            blockList.add((Block)object2);
        }
        for (Object object2 : this.copyinBlockList) {
            blockList.add((Block)object2);
        }
        BlockList blockList2 = Bcons.emptyBody();
        for (Block block2 : this.copyoutBlockList) {
            blockList2.add(block2);
        }
        for (Block block2 : this.finalizeBlockList) {
            blockList2.add(block2);
        }
        object2 = Bcons.COMPOUND(blockList);
        block2 = Bcons.COMPOUND(blockList2);
        BlockList blockList3 = Bcons.emptyBody();
        for (Xobject xobject : this.idList) {
            blockList3.addIdent((Ident)xobject);
        }
        Xobject xobject = this._info.getIntExpr(ACCpragma.IF);
        boolean bl2 = bl = xobject == null || xobject.isIntConstant() && !xobject.isZeroConstant();
        if (bl) {
            blockList3.add((Block)object2);
            blockList3.add(this._parallelBlock);
            blockList3.add(block2);
        } else {
            Ident ident = blockList3.declLocalIdent("_ACC_DATA_IF_COND", Xtype.charType, StorageClass.AUTO, xobject);
            blockList3.add(Bcons.IF(ident.Ref(), (Block)object2, null));
            blockList3.add(Bcons.IF(ident.Ref(), this._parallelBlock, Bcons.COMPOUND(this._pb.getBody())));
            blockList3.add(Bcons.IF(ident.Ref(), block2, null));
        }
        this._pb.replace(Bcons.COMPOUND(blockList3));
    }

    @Override
    boolean isAcceptableClause(ACCpragma aCCpragma) {
        switch (aCCpragma) {
            case IF: 
            case ASYNC: 
            case NUM_GANGS: 
            case NUM_WORKERS: 
            case VECT_LEN: 
            case PRIVATE: 
            case FIRSTPRIVATE: {
                return true;
            }
        }
        return aCCpragma.isDataClause() || aCCpragma.isReduction();
    }
}

