/*
 * Decompiled with CFR 0.152.
 */
package exc.openacc;

import exc.block.Block;
import exc.block.CforBlock;
import exc.block.PragmaBlock;
import exc.block.topdownBlockIterator;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjInt;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.openacc.ACC;
import exc.openacc.ACCpragma;
import exc.openacc.AccDirective;
import exc.openacc.AccInformation;
import exc.openacc.AccLoop;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class AccManager {
    private final AccInformation _info;
    private final PragmaBlock _pb;
    private Xobject numGangs = null;
    private Xobject vectorLength = null;
    private final Map<CforBlock, LoopExecInfo> execMethodMap = new HashMap<CforBlock, LoopExecInfo>();

    AccManager(AccInformation accInformation, PragmaBlock pragmaBlock) {
        this._info = accInformation;
        this._pb = pragmaBlock;
    }

    public void analyze() {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(this._pb);
        topdownBlockIterator2.init();
        while (!topdownBlockIterator2.end()) {
            AccDirective accDirective;
            AccInformation accInformation;
            Block block = topdownBlockIterator2.getBlock();
            if (block.Opcode() == Xcode.ACC_PRAGMA && (accInformation = (accDirective = (AccDirective)block.getProp("_ACC_DIRECTIVE")).getInfo()).getPragma().isLoop()) {
                int n;
                AbstractCollection abstractCollection;
                CforBlock cforBlock = (CforBlock)block.getBody().getHead();
                EnumSet<ACCpragma> enumSet = EnumSet.noneOf(ACCpragma.class);
                Xobject xobject = null;
                if (accInformation != null) {
                    abstractCollection = this.getExecModels(accInformation);
                    enumSet.addAll(abstractCollection);
                    xobject = accInformation.getIntExpr(ACCpragma.COLLAPSE);
                }
                abstractCollection = new ArrayList();
                CforBlock cforBlock2 = cforBlock;
                for (int i = n = xobject == null ? 1 : xobject.getInt(); i > 0; --i) {
                    abstractCollection.add((CforBlock)cforBlock2);
                    if (i <= 1) continue;
                    cforBlock2 = AccLoop.findOutermostTightlyNestedForBlock(cforBlock2.getBody().getHead());
                }
                this.execMethodMap.put(cforBlock, new LoopExecInfo((List<CforBlock>)((Object)abstractCollection), enumSet));
            }
            topdownBlockIterator2.next();
        }
    }

    private EnumSet<ACCpragma> getExecModels(AccInformation accInformation) {
        EnumSet<ACCpragma> enumSet = EnumSet.noneOf(ACCpragma.class);
        if (accInformation.hasClause(ACCpragma.GANG)) {
            enumSet.add(ACCpragma.GANG);
        }
        if (accInformation.hasClause(ACCpragma.WORKER)) {
            enumSet.add(ACCpragma.WORKER);
        }
        if (accInformation.hasClause(ACCpragma.VECTOR)) {
            enumSet.add(ACCpragma.VECTOR);
        }
        if (accInformation.hasClause(ACCpragma.SEQ)) {
            enumSet.add(ACCpragma.SEQ);
        }
        if (enumSet.isEmpty()) {
            enumSet.add(ACCpragma.AUTO);
        }
        return enumSet;
    }

    public String getMethodName(CforBlock cforBlock) {
        LoopExecInfo loopExecInfo = this.execMethodMap.get(cforBlock);
        EnumSet<ACCpragma> enumSet = loopExecInfo.methods;
        if (enumSet.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (enumSet.contains((Object)ACCpragma.GANG)) {
            stringBuilder.append("block_");
        }
        if (enumSet.contains((Object)ACCpragma.WORKER)) {
            stringBuilder.append("warp_");
        }
        if (enumSet.contains((Object)ACCpragma.VECTOR)) {
            stringBuilder.append("thread_");
        }
        stringBuilder.append('x');
        return new String(stringBuilder);
    }

    public EnumSet<ACCpragma> getMethodType(CforBlock cforBlock) {
        LoopExecInfo loopExecInfo = this.execMethodMap.get(cforBlock);
        return loopExecInfo.methods;
    }

    public XobjList getBlockThreadSize() {
        EnumSet<ACCpragma> enumSet;
        LoopExecInfo loopExecInfo;
        Xobject xobject = this.getNumGangsExpr();
        Xobject xobject2 = this.getVectorLengthExpr();
        if (xobject == null) {
            xobject = this.numGangs;
        }
        if (xobject2 == null) {
            xobject2 = this.vectorLength;
        }
        for (CforBlock cforBlock : this.execMethodMap.keySet()) {
            loopExecInfo = this.execMethodMap.get(cforBlock);
            enumSet = loopExecInfo.methods;
            if (!enumSet.contains((Object)ACCpragma.VECTOR) || xobject2 != null) continue;
            xobject2 = Xcons.IntConstant(ACC.device.getDefaultVectorLength());
        }
        if (xobject2 == null) {
            xobject2 = Xcons.IntConstant(1);
        }
        for (CforBlock cforBlock : this.execMethodMap.keySet()) {
            loopExecInfo = this.execMethodMap.get(cforBlock);
            enumSet = loopExecInfo.methods;
            if (!enumSet.contains((Object)ACCpragma.GANG) || xobject != null) continue;
            if (enumSet.contains((Object)ACCpragma.VECTOR)) {
                xobject = Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.binaryOp(Xcode.DIV_EXPR, Xcons.binaryOp(Xcode.MINUS_EXPR, loopExecInfo.getTotalIterNum(), Xcons.IntConstant(1)), xobject2), Xcons.IntConstant(1));
                continue;
            }
            xobject = loopExecInfo.getTotalIterNum();
        }
        if (xobject == null) {
            xobject = Xcons.IntConstant(1);
        }
        XobjInt xobjInt = Xcons.IntConstant(1);
        return Xcons.List(xobject, xobjInt, xobject2);
    }

    public void setNumGangs(Xobject xobject) {
        this.numGangs = xobject;
    }

    public void setVectorLength(Xobject xobject) {
        this.vectorLength = xobject;
    }

    private Xobject getNumGangsExpr() {
        Xobject xobject = this._info.getIntExpr(ACCpragma.NUM_GANGS);
        if (xobject != null) {
            return xobject;
        }
        return this._info.getIntExpr(ACCpragma.GANG);
    }

    private Xobject getVectorLengthExpr() {
        Xobject xobject = this._info.getIntExpr(ACCpragma.VECT_LEN);
        if (xobject != null) {
            return xobject;
        }
        return this._info.getIntExpr(ACCpragma.VECTOR);
    }

    class LoopExecInfo {
        final List<CforBlock> forBlocks;
        final EnumSet<ACCpragma> methods;

        LoopExecInfo(List<CforBlock> list, EnumSet<ACCpragma> enumSet) {
            this.forBlocks = list;
            this.methods = enumSet;
        }

        public Xobject getTotalIterNum() {
            Iterator<CforBlock> iterator = this.forBlocks.iterator();
            return this.recTotalIterNum(iterator);
        }

        private Xobject recTotalIterNum(Iterator<CforBlock> iterator) {
            CforBlock cforBlock = iterator.next();
            if (iterator.hasNext()) {
                return Xcons.binaryOp(Xcode.MUL_EXPR, this.getIterNum(cforBlock), this.recTotalIterNum(iterator));
            }
            return this.getIterNum(cforBlock);
        }

        private Xobject getIterNum(CforBlock cforBlock) {
            Xobject xobject = cforBlock.getUpperBound();
            Xobject xobject2 = cforBlock.getLowerBound();
            Xobject xobject3 = cforBlock.getStep();
            return Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.binaryOp(Xcode.DIV_EXPR, Xcons.binaryOp(Xcode.MINUS_EXPR, Xcons.binaryOp(Xcode.MINUS_EXPR, xobject, xobject2), Xcons.IntConstant(1)), xobject3), Xcons.IntConstant(1));
        }
    }
}

